use ross_eeprom::DeviceInfo;
use ross_protocol::packet::Packet;
use ross_protocol::event::bcm_event::BcmChangeBrightnessEvent;
use ross_protocol::convert_packet::ConvertPacket;

use crate::module::config_module::extractor::Value;
use crate::module::config_module::producer::Producer;

pub struct BcmChangeBrightnessProducer {
    bcm_address: u16,
    channel: u8,
    brightness: u8,
}

impl BcmChangeBrightnessProducer {
    pub fn new(bcm_address: u16, channel: u8, brightness: u8) -> Self {
        BcmChangeBrightnessProducer {
            bcm_address,
            channel,
            brightness,
        }
    }
}

impl Producer for BcmChangeBrightnessProducer {
    fn produce(&self, _value: &Value, device_info: &DeviceInfo) -> Packet {
        let bcm_change_brightness_event = BcmChangeBrightnessEvent {
            bcm_address: self.bcm_address,
            transmitter_address: device_info.device_address,
            channel: self.channel,
            brightness: self.brightness,
        };

        bcm_change_brightness_event.to_packet()
    }
}
