use core::convert::TryInto;

use ross_protocol::packet::Packet;

use crate::module::config_module::filter::Filter;

pub struct EventCodeFilter {
    event_code: u16,
}

impl EventCodeFilter {
    pub fn new(event_code: u16) -> Self {
        EventCodeFilter {
            event_code
        }
    }
}

impl Filter for EventCodeFilter {
    fn filter(&self, packet: &Packet) -> bool {
        u16::from_be_bytes(packet.data[0..=1].try_into().unwrap()) == self.event_code
    }
}
