use core::cell::UnsafeCell;
use stm32f1xx_hal_bxcan::can::Can as HalCan;
use stm32f1xx_hal_bxcan::gpio::gpioa::{PA10, PA9};
use stm32f1xx_hal_bxcan::gpio::gpiob::{PB13, PB14, PB15};
use stm32f1xx_hal_bxcan::gpio::{Alternate, Floating, Input, PushPull, Output};
use stm32f1xx_hal_bxcan::pac::{CAN1, USART1, SPI2};
use stm32f1xx_hal_bxcan::spi::{NoMiso, Spi, Spi2NoRemap};
use stm32f1xx_hal_bxcan::serial::Serial;

use ross_logger::Logger;
use ross_protocol::interface::can::Can;
use ross_protocol::interface::usart::Usart;
use ross_protocol::protocol::Protocol;

use crate::module::hello_module::HelloModule;
use crate::module::programmer_module::ProgrammerModule;
use crate::module::bcm_module::BcmModule;
use crate::module::button_module::ButtonModule;
use crate::module::config_module::ConfigModule;

pub type UnsafeCanProtocol<'a> = UnsafeCell<Protocol<'a, Can<HalCan<CAN1>>>>;
pub type UnsafeUsartProtocol<'a> = UnsafeCell<
    Protocol<'a, Usart<Serial<USART1, (PA9<Alternate<PushPull>>, PA10<Input<Floating>>)>>>,
>;
pub type UnsafeLogger = UnsafeCell<Logger>;
pub type UnsafeHelloModule = UnsafeCell<HelloModule>;
pub type UnsafeProgrammerModule = UnsafeCell<ProgrammerModule>;
pub type UnsafeBcmModule = UnsafeCell<BcmModule>;
pub type UnsafeButtonModule = UnsafeCell<ButtonModule>;
pub type UnsafeConfigModule = UnsafeCell<ConfigModule>;

pub type BcmClockPin = PB13<Alternate<PushPull>>;
pub type BcmLatchPin = PB14<Output<PushPull>>;
pub type BcmDataPin = PB15<Alternate<PushPull>>;
pub type BcmSpi = Spi<SPI2, Spi2NoRemap, (PB13<Alternate<PushPull>>, NoMiso, PB15<Alternate<PushPull>>), u8>;
