use crate::config::CanConfig;

pub fn calc_can_btr(config: &CanConfig, clock_rate: u32) -> u32 {
    let brp = clock_rate / config.bitrate / (config.tseg1 + config.tseg2);

    (brp - 1) | ((config.tseg1 - 1) << 16) | ((config.tseg2 - 1) << 20) | ((config.sjw - 1) << 24)
}
