extern crate alloc;

use alloc::boxed::Box;

pub struct BufferHelper<const BUFFER_LEN: usize> {
    buffer: [u8; BUFFER_LEN],
    buffer_offset: usize,
}

impl<const BUFFER_LEN: usize> BufferHelper<BUFFER_LEN> {
    pub fn new() -> Self {
        Self {
            buffer: [0x00; BUFFER_LEN],
            buffer_offset: 0,
        }
    }

    pub fn add_data<'a>(
        &mut self,
        data: &[u8],
        force_call_handler: bool,
        mut data_handler: Box<dyn FnMut(&[u8; BUFFER_LEN]) + 'a>,
    ) {
        for byte in data.iter() {
            self.buffer[self.buffer_offset] = *byte;
            self.buffer_offset += 1;

            if self.buffer_offset == self.buffer.len() {
                (data_handler)(&self.buffer);
                self.buffer_offset = 0;
            }
        }

        if force_call_handler {
            (data_handler)(&self.buffer);
        }
    }

    pub fn get_buffer_offset(&self) -> usize {
        self.buffer_offset
    }
}
