use stm32f1xx_hal_bxcan::can::Can as HalCan;
use stm32f1xx_hal_bxcan::gpio::gpioa::{PA11, PA12};
use stm32f1xx_hal_bxcan::gpio::gpiob::{PB6, PB7};
use stm32f1xx_hal_bxcan::gpio::{Alternate, Floating, Input, OpenDrain, PushPull};
use stm32f1xx_hal_bxcan::i2c::BlockingI2c;
use stm32f1xx_hal_bxcan::pac::{CAN1, I2C1};

use ross_protocol::interface::can::Can;
use ross_protocol::protocol::Protocol;

pub type CanProtocol<'a> = Protocol<'a, Can<HalCan<CAN1>>>;

pub type CanRxPin = PA11<Input<Floating>>;
pub type CanTxPin = PA12<Alternate<PushPull>>;

pub type EepromSclPin = PB6<Alternate<OpenDrain>>;
pub type EepromSdaPin = PB7<Alternate<OpenDrain>>;
pub type EepromI2c = BlockingI2c<I2C1, (EepromSclPin, EepromSdaPin)>;
