use serde::ser::{Serialize, Serializer};

use crate::value::{Number, Value};

impl Serialize for Value {
    fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
    where
        S: Serializer,
    {
        match *self {
            Value::Bool(b) => serializer.serialize_bool(b),
            Value::Char(c) => serializer.serialize_char(c),
            Value::Map(ref m) => m.serialize(serializer),
            Value::Number(Number::Float(ref f)) => serializer.serialize_f64(f.get()),
            Value::Number(Number::Integer(i)) => serializer.serialize_i64(i),
            Value::Option(Some(ref o)) => serializer.serialize_some(o.as_ref()),
            Value::Option(None) => serializer.serialize_none(),
            Value::String(ref s) => serializer.serialize_str(s),
            Value::List(ref l) => l.serialize(serializer),
            Value::Unit(None) => serializer.serialize_unit(),
            Value::Unit(Some(ref _ident)) => {
                serializer.serialize_unit()
                //TODO serializer.serialize_unit_struct(ident)
            }
            Value::Tuple(None, ref t) => {
                t.serialize(serializer)
            }
            Value::Tuple(Some(ref _ident), ref t) => {
                //todo!()
                t.serialize(serializer)
                //serializer.serialize_tuple_struct(ident, )
            }
            Value::Struct(ref _ident, ref s) => {
                s.serialize(serializer)
                //todo!()
                //serializer.serialize_struct()
            }
        }
    }
}
