#[cfg(feature = "serde")]
use serde::{Deserialize, Serialize};

use crate::ast;
use crate::ast::{Attribute, Extension};

#[derive(Clone, Copy, Debug, Default)]
#[cfg_attr(feature = "serde", derive(Deserialize, Serialize))]
pub struct Extensions {
    pub(crate) implicit_some: bool,
    pub(crate) unwrap_newtypes: bool,
}

impl Extensions {
    pub fn new() -> Self {
        Default::default()
    }

    pub fn from_attrs(ron: &ast::Ron) -> Self {
        let mut extensions = Extensions::default();

        for attribute in &ron.attributes {
            match &attribute.value {
                Attribute::Enable(list) => for extension in &list.value {
                    match extension.value {
                        Extension::UnwrapNewtypes => {
                            extensions.unwrap_newtypes = true;
                        }
                        Extension::ImplicitSome => {
                            extensions.implicit_some = true;
                        }
                    }
                }
            }
        }

        extensions
    }

    pub fn with_implicit_some(mut self) -> Self {
        self.implicit_some = true;

        self
    }


    pub fn with_unwrap_newtypes(mut self) -> Self {
        self.unwrap_newtypes = true;

        self
    }
}
