# romu - Rust crate

[![Documentation](https://docs.rs/romu/badge.svg)](https://docs.rs/romu/)
[![Crates.io](https://img.shields.io/crates/v/romu.svg)](https://crates.io/crates/romu)
[![License: Apache 2.0](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](LICENSE-APACHE)

A pseudo random number generator using the algorithm [Romu](https://www.romu-random.org/) for the
programing language Rust.

This pseudo random number generator (PRNG) is not intended for cryptographic purposes. This crate only implements the
64-bit "RomuTrio" generator, since it's the recommended generator by the original author.

## Non-linear random number generator

Romu is a non-linear random number generator. That means that the period is probabilistic and is based on the seed.
The bigger the needed period is, the higher the chance it is that the actual period is "too small".

Following formula is given by the author:

```
    P(|cycle contains x<= 2^k|) = 2^k-s+7
        k is size of random numbers needed + 1.
        s is the state size.
```

Example chances for getting a "too small" period:
 * When 2^62 * 64-bit numbers are needed (32 EiB) -> 2^-122 chance
 * When 2^39 * 64-bit numbers are needed (4 TiB) -> 2^-146 chance
 * When 2^36 * 64-bit numbers are needed (512 GiB) -> 2^-149 chance

You can read more about the theory behind Romu in the [official paper](https://arxiv.org/abs/2002.11331) and it's unique
selling points on the [official website](https://www.romu-random.org/) of the original author.

## Features

The crate is `no_std` compatible.

 * `std` - If `getrandom` is not used or returns an error, the generator will use the thread name and the current
           instance time to create a seed value. Enabled by default.
 * `tls` - Creates static functions that use a thread local version of the generator. Enabled by default.
 * `getrandom` - Uses the `getrandom` crate to create a seed of high entropy. Enabled by default.
 * `unstable_tls` - Uses the unstable `thread_local` feature of Rust nightly. Improves the call times to the
                    thread local functions greatly. 
 * `unstable_simd` - Uses the unstable `std::simd` crate of Rust nightly to provide special SIMD versions of the
                     generator which can be used to create large amount of random data fast.

## SIMD

The `unstable_simd` feature activates the types `Rng128`, `Rng256`, `Rng512` for 2 lane, 4 lane and 8 lane SIMD
respectively. From my limited testing it seems that speed improvements can only be seen once AVX2 is activated and 
at least "Rng256" is used:

```bash
bytes/Copy/1048576      time:   [34.508 us 35.437 us 36.277 us]
                        thrpt:  [26.919 GiB/s 27.558 GiB/s 28.300 GiB/s]
bytes/Rng/1048576       time:   [76.342 us 76.462 us 76.595 us]
                        thrpt:  [12.750 GiB/s 12.772 GiB/s 12.792 GiB/s]
bytes/Rng128/1048576    time:   [105.01 us 105.21 us 105.42 us]
                        thrpt:  [9.2634 GiB/s 9.2824 GiB/s 9.2994 GiB/s]
bytes/Rng256/1048576    time:   [52.945 us 53.111 us 53.284 us]
                        thrpt:  [18.327 GiB/s 18.387 GiB/s 18.445 GiB/s]
bytes/Rng512/1048576    time:   [34.794 us 34.853 us 34.917 us]
                        thrpt:  [27.968 GiB/s 28.019 GiB/s 28.067 GiB/s]
```

## License

Licensed under Apache License, Version 2.0, ([LICENSE](LICENSE) or http://www.apache.org/licenses/LICENSE-2.0).

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as
defined in the Apache-2.0 license without any additional terms or conditions.
