// Default doesn't make sense for a type whose constructor is random.
#![allow(clippy::new_without_default)]

use std::fmt;

use serde::{Deserialize, Serialize};
use uuid::Uuid;

/// A randomly generated ID generated by Rojo during a serve session.
///
/// If the session ID of the server changes between requests, that indicates
/// that a new server has started up and the session should be terminated.
#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, Serialize, Deserialize)]
pub struct SessionId(Uuid);

impl SessionId {
    pub fn new() -> SessionId {
        SessionId(Uuid::new_v4())
    }
}

impl fmt::Display for SessionId {
    fn fmt(&self, writer: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(writer, "{}", self.0)
    }
}
