use libxm::XMContext;
use rodio::{OutputStream, Sink};
use rodio_xm::XMSource;

const SAMPLE_RATE: u32 = 44100;

fn main() {
    let xm_context = XMContext::new(
        include_bytes!("drozerix_-_chica-pop!.xm"),
        SAMPLE_RATE
    ).expect("Couldn't build XM context");

    let source = XMSource::new(xm_context, SAMPLE_RATE);

    let (_stream, stream_handle) = OutputStream::try_default().unwrap();
    let sink = Sink::try_new(&stream_handle).unwrap();

    sink.append(source);
    sink.play();

    loop {}
}
