# rodio-xm

provides a Source for playback of FastTracker 2 extended modules in rodio

## examples

```rust
use std::path::PathBuf;

use rodio::{OutputStream, Sink};
use rodio_xm::XMSource;

fn main() {
    let source = XMSource::from_file(
        PathBuf::from("path/to/file.xm"),
        44100
    );

    let (_stream, stream_handle) = OutputStream::try_default().unwrap();
    let sink = Sink::try_new(&stream_handle).unwrap();

    sink.append(source);
    sink.play();

    loop {}
}
```

see more in the *examples* directory.

## license

released under the MIT license.

example track ["Chica-pop!"](https://modarchive.org/index.php?request=view_by_moduleid&query=189433) 
is in the public domain.
