//! Method, error and parameter types for the SecretScanning endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct SecretScanning<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> SecretScanning {
    SecretScanning { auth }
}

/// Errors for the [Get a secret scanning alert](SecretScanning::get_alert_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SecretScanningGetAlertError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Repository is public, or secret scanning is disabled for the repository, or the resource is not found")]
    Status404,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List secret scanning alerts for a repository](SecretScanning::list_alerts_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SecretScanningListAlertsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Repository is public or secret scanning is disabled for the repository")]
    Status404,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a secret scanning alert](SecretScanning::update_alert_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SecretScanningUpdateAlertError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Repository is public, or secret scanning is disabled for the repository, or the resource is not found")]
    Status404,
    #[error("State does not match the resolution")]
    Status422,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List secret scanning alerts for a repository](SecretScanning::list_alerts_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SecretScanningListAlertsForRepoParams<'req> {
    /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
    state: Option<&'req str>, 
    /// A comma separated list of secret types to return. By default all secret types are returned.
    secret_type: Option<&'req str>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl<'req> SecretScanningListAlertsForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            secret_type: self.secret_type, 
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// A comma separated list of secret types to return. By default all secret types are returned.
    pub fn secret_type(self, secret_type: &'req str) -> Self {
        Self { 
            state: self.state, 
            secret_type: Some(secret_type),
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            secret_type: self.secret_type, 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            secret_type: self.secret_type, 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SecretScanningListAlertsForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> SecretScanning<'api> {
    /// ---
    ///
    /// # Get a secret scanning alert
    ///
    /// Gets a single secret scanning alert detected in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_alert](https://docs.github.com/rest/reference/secret-scanning#get-a-secret-scanning-alert)
    ///
    /// ---
    pub async fn get_alert_async(&self, owner: &str, repo: &str, alert_number: AlertNumber) -> Result<SecretScanningAlert, SecretScanningGetAlertError> {

        let request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningGetAlertError::Status404),
                503 => Err(SecretScanningGetAlertError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SecretScanningGetAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a secret scanning alert
    ///
    /// Gets a single secret scanning alert detected in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_alert](https://docs.github.com/rest/reference/secret-scanning#get-a-secret-scanning-alert)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_alert(&self, owner: &str, repo: &str, alert_number: AlertNumber) -> Result<SecretScanningAlert, SecretScanningGetAlertError> {

        let request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningGetAlertError::Status404),
                503 => Err(SecretScanningGetAlertError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(SecretScanningGetAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List secret scanning alerts for a repository
    ///
    /// Lists all secret scanning alerts for a private repository, from newest to oldest. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_alerts_for_repo](https://docs.github.com/rest/reference/secret-scanning#list-secret-scanning-alerts-for-a-repository)
    ///
    /// ---
    pub async fn list_alerts_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<SecretScanningListAlertsForRepoParams<'api>>>) -> Result<Vec<SecretScanningAlert>, SecretScanningListAlertsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningListAlertsForRepoError::Status404),
                503 => Err(SecretScanningListAlertsForRepoError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SecretScanningListAlertsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List secret scanning alerts for a repository
    ///
    /// Lists all secret scanning alerts for a private repository, from newest to oldest. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_alerts_for_repo](https://docs.github.com/rest/reference/secret-scanning#list-secret-scanning-alerts-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_alerts_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<SecretScanningListAlertsForRepoParams<'api>>>) -> Result<Vec<SecretScanningAlert>, SecretScanningListAlertsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: SecretScanningListAlertsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningListAlertsForRepoError::Status404),
                503 => Err(SecretScanningListAlertsForRepoError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(SecretScanningListAlertsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a secret scanning alert
    ///
    /// Updates the status of a secret scanning alert in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` write permission to use this endpoint.
    /// 
    /// [GitHub API docs for update_alert](https://docs.github.com/rest/reference/secret-scanning#update-a-secret-scanning-alert)
    ///
    /// ---
    pub async fn update_alert_async(&self, owner: &str, repo: &str, alert_number: AlertNumber, body: PatchSecretScanningUpdateAlert) -> Result<SecretScanningAlert, SecretScanningUpdateAlertError> {

        let request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchSecretScanningUpdateAlert::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningUpdateAlertError::Status404),
                422 => Err(SecretScanningUpdateAlertError::Status422),
                503 => Err(SecretScanningUpdateAlertError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SecretScanningUpdateAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a secret scanning alert
    ///
    /// Updates the status of a secret scanning alert in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
    /// 
    /// GitHub Apps must have the `secret_scanning_alerts` write permission to use this endpoint.
    /// 
    /// [GitHub API docs for update_alert](https://docs.github.com/rest/reference/secret-scanning#update-a-secret-scanning-alert)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_alert(&self, owner: &str, repo: &str, alert_number: AlertNumber, body: PatchSecretScanningUpdateAlert) -> Result<SecretScanningAlert, SecretScanningUpdateAlertError> {

        let request_uri = format!("{}/repos/{}/{}/secret-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchSecretScanningUpdateAlert::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(SecretScanningUpdateAlertError::Status404),
                422 => Err(SecretScanningUpdateAlertError::Status422),
                503 => Err(SecretScanningUpdateAlertError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(SecretScanningUpdateAlertError::Generic { code }),
            }
        }
    }

}
