//! Method, error and parameter types for the Issues endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Issues<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Issues {
    Issues { auth }
}

/// Errors for the [Add assignees to an issue](Issues::add_assignees_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesAddAssigneesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add labels to an issue](Issues::add_labels_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesAddLabelsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a user can be assigned](Issues::check_user_can_be_assigned_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesCheckUserCanBeAssignedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Otherwise a &#x60;404&#x60; status code is returned.")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an issue](Issues::create_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesCreateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an issue comment](Issues::create_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesCreateCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a label](Issues::create_label_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesCreateLabelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a milestone](Issues::create_milestone_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesCreateMilestoneError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an issue comment](Issues::delete_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesDeleteCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a label](Issues::delete_label_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesDeleteLabelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a milestone](Issues::delete_milestone_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesDeleteMilestoneError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an issue](Issues::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an issue comment](Issues::get_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesGetCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an issue event](Issues::get_event_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesGetEventError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a label](Issues::get_label_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesGetLabelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a milestone](Issues::get_milestone_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesGetMilestoneError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List issues assigned to the authenticated user](Issues::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List assignees](Issues::list_assignees_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListAssigneesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List issue comments](Issues::list_comments_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListCommentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List issue comments for a repository](Issues::list_comments_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListCommentsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List issue events](Issues::list_events_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListEventsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List issue events for a repository](Issues::list_events_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListEventsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List timeline events for an issue](Issues::list_events_for_timeline_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListEventsForTimelineError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List user account issues assigned to the authenticated user](Issues::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization issues assigned to the authenticated user](Issues::list_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository issues](Issues::list_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List labels for issues in a milestone](Issues::list_labels_for_milestone_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListLabelsForMilestoneError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List labels for a repository](Issues::list_labels_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListLabelsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List labels for an issue](Issues::list_labels_on_issue_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListLabelsOnIssueError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List milestones](Issues::list_milestones_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesListMilestonesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Lock an issue](Issues::lock_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesLockError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove all labels from an issue](Issues::remove_all_labels_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesRemoveAllLabelsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove assignees from an issue](Issues::remove_assignees_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesRemoveAssigneesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a label from an issue](Issues::remove_label_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesRemoveLabelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set labels for an issue](Issues::set_labels_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesSetLabelsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unlock an issue](Issues::unlock_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesUnlockError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an issue](Issues::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an issue comment](Issues::update_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesUpdateCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a label](Issues::update_label_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesUpdateLabelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a milestone](Issues::update_milestone_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum IssuesUpdateMilestoneError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List issues assigned to the authenticated user](Issues::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListParams<'req> {
    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    filter: Option<&'req str>, 
    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// A list of comma separated label names. Example: `bug,ui,@high`
    labels: Option<&'req str>, 
    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    
    collab: Option<bool>, 
    
    orgs: Option<bool>, 
    
    owned: Option<bool>, 
    
    pulls: Option<bool>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: Some(state),
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A list of comma separated label names. Example: `bug,ui,@high`
    pub fn labels(self, labels: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: Some(labels),
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    
    pub fn collab(self, collab: bool) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: Some(collab),
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    
    pub fn orgs(self, orgs: bool) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: Some(orgs),
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    
    pub fn owned(self, owned: bool) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: Some(owned),
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    
    pub fn pulls(self, pulls: bool) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: Some(pulls),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            collab: self.collab, 
            orgs: self.orgs, 
            owned: self.owned, 
            pulls: self.pulls, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List assignees](Issues::list_assignees_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListAssigneesParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListAssigneesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListAssigneesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List issue comments](Issues::list_comments_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListCommentsParams {
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListCommentsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListCommentsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List issue comments for a repository](Issues::list_comments_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListCommentsForRepoParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// Either `asc` or `desc`. Ignored without the `sort` parameter.
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListCommentsForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Either `asc` or `desc`. Ignored without the `sort` parameter.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListCommentsForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List issue events](Issues::list_events_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListEventsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListEventsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListEventsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List issue events for a repository](Issues::list_events_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListEventsForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListEventsForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListEventsForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List timeline events for an issue](Issues::list_events_for_timeline_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListEventsForTimelineParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListEventsForTimelineParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListEventsForTimelineParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List user account issues assigned to the authenticated user](Issues::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListForAuthenticatedUserParams<'req> {
    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    filter: Option<&'req str>, 
    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// A list of comma separated label names. Example: `bug,ui,@high`
    labels: Option<&'req str>, 
    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListForAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: Some(state),
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A list of comma separated label names. Example: `bug,ui,@high`
    pub fn labels(self, labels: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: Some(labels),
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListForAuthenticatedUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization issues assigned to the authenticated user](Issues::list_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListForOrgParams<'req> {
    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    filter: Option<&'req str>, 
    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// A list of comma separated label names. Example: `bug,ui,@high`
    labels: Option<&'req str>, 
    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListForOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates which sorts of issues to return. Can be one of:   \\* `assigned`: Issues assigned to you   \\* `created`: Issues created by you   \\* `mentioned`: Issues mentioning you   \\* `subscribed`: Issues you're subscribed to updates for   \\* `all` or `repos`: All issues the authenticated user can see, regardless of participation or creation
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: Some(state),
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A list of comma separated label names. Example: `bug,ui,@high`
    pub fn labels(self, labels: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: Some(labels),
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            state: self.state, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListForOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository issues](Issues::list_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListForRepoParams<'req> {
    /// If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
    milestone: Option<&'req str>, 
    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
    assignee: Option<&'req str>, 
    /// The user that created the issue.
    creator: Option<&'req str>, 
    /// A user that's mentioned in the issue.
    mentioned: Option<&'req str>, 
    /// A list of comma separated label names. Example: `bug,ui,@high`
    labels: Option<&'req str>, 
    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
    pub fn milestone(self, milestone: &'req str) -> Self {
        Self { 
            milestone: Some(milestone),
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: Some(state),
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
    pub fn assignee(self, assignee: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: Some(assignee),
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The user that created the issue.
    pub fn creator(self, creator: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: Some(creator),
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A user that's mentioned in the issue.
    pub fn mentioned(self, mentioned: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: Some(mentioned),
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A list of comma separated label names. Example: `bug,ui,@high`
    pub fn labels(self, labels: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: Some(labels),
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Can be either `created`, `updated`, `comments`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            milestone: self.milestone, 
            state: self.state, 
            assignee: self.assignee, 
            creator: self.creator, 
            mentioned: self.mentioned, 
            labels: self.labels, 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List labels for issues in a milestone](Issues::list_labels_for_milestone_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListLabelsForMilestoneParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListLabelsForMilestoneParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListLabelsForMilestoneParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List labels for a repository](Issues::list_labels_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListLabelsForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListLabelsForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListLabelsForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List labels for an issue](Issues::list_labels_on_issue_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListLabelsOnIssueParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl IssuesListLabelsOnIssueParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListLabelsOnIssueParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List milestones](Issues::list_milestones_async()) endpoint.
#[derive(Default, Serialize)]
pub struct IssuesListMilestonesParams<'req> {
    /// The state of the milestone. Either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// What to sort results by. Either `due_on` or `completeness`.
    sort: Option<&'req str>, 
    /// The direction of the sort. Either `asc` or `desc`.
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> IssuesListMilestonesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The state of the milestone. Either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Either `due_on` or `completeness`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            state: self.state, 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The direction of the sort. Either `asc` or `desc`.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            state: self.state, 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for IssuesListMilestonesParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Issues<'api> {
    /// ---
    ///
    /// # Add assignees to an issue
    ///
    /// Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
    /// 
    /// [GitHub API docs for add_assignees](https://docs.github.com/rest/reference/issues#add-assignees-to-an-issue)
    ///
    /// ---
    pub async fn add_assignees_async(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesAddAssignees) -> Result<IssueSimple, IssuesAddAssigneesError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesAddAssignees::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesAddAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add assignees to an issue
    ///
    /// Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
    /// 
    /// [GitHub API docs for add_assignees](https://docs.github.com/rest/reference/issues#add-assignees-to-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_assignees(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesAddAssignees) -> Result<IssueSimple, IssuesAddAssigneesError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesAddAssignees::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesAddAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add labels to an issue
    /// 
    /// [GitHub API docs for add_labels](https://docs.github.com/rest/reference/issues#add-labels-to-an-issue)
    ///
    /// ---
    pub async fn add_labels_async(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesAddLabels) -> Result<Vec<Label>, IssuesAddLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesAddLabels::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesAddLabelsError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesAddLabelsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesAddLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add labels to an issue
    /// 
    /// [GitHub API docs for add_labels](https://docs.github.com/rest/reference/issues#add-labels-to-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_labels(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesAddLabels) -> Result<Vec<Label>, IssuesAddLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesAddLabels::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesAddLabelsError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesAddLabelsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesAddLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user can be assigned
    ///
    /// Checks if a user has permission to be assigned to an issue in this repository.
    /// 
    /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
    /// 
    /// Otherwise a `404` status code is returned.
    /// 
    /// [GitHub API docs for check_user_can_be_assigned](https://docs.github.com/rest/reference/issues#check-if-a-user-can-be-assigned)
    ///
    /// ---
    pub async fn check_user_can_be_assigned_async(&self, owner: &str, repo: &str, assignee: &str) -> Result<(), IssuesCheckUserCanBeAssignedError> {

        let request_uri = format!("{}/repos/{}/{}/assignees/{}", super::GITHUB_BASE_API_URL, owner, repo, assignee);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesCheckUserCanBeAssignedError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesCheckUserCanBeAssignedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user can be assigned
    ///
    /// Checks if a user has permission to be assigned to an issue in this repository.
    /// 
    /// If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
    /// 
    /// Otherwise a `404` status code is returned.
    /// 
    /// [GitHub API docs for check_user_can_be_assigned](https://docs.github.com/rest/reference/issues#check-if-a-user-can-be-assigned)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_user_can_be_assigned(&self, owner: &str, repo: &str, assignee: &str) -> Result<(), IssuesCheckUserCanBeAssignedError> {

        let request_uri = format!("{}/repos/{}/{}/assignees/{}", super::GITHUB_BASE_API_URL, owner, repo, assignee);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesCheckUserCanBeAssignedError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesCheckUserCanBeAssignedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an issue
    ///
    /// Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://help.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/issues#create-an-issue)
    ///
    /// ---
    pub async fn create_async(&self, owner: &str, repo: &str, body: PostIssuesCreate) -> Result<Issue, IssuesCreateError> {

        let request_uri = format!("{}/repos/{}/{}/issues", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesCreateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesCreateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(IssuesCreateError::Status503(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesCreateError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesCreateError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an issue
    ///
    /// Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://help.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/issues#create-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create(&self, owner: &str, repo: &str, body: PostIssuesCreate) -> Result<Issue, IssuesCreateError> {

        let request_uri = format!("{}/repos/{}/{}/issues", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesCreateError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesCreateError::Status422(crate::adapters::to_json(github_response)?)),
                503 => Err(IssuesCreateError::Status503(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesCreateError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesCreateError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an issue comment
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)
    ///
    /// ---
    pub async fn create_comment_async(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesCreateComment) -> Result<IssueComment, IssuesCreateCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesCreateCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesCreateCommentError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesCreateCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesCreateCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesCreateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an issue comment
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_comment(&self, owner: &str, repo: &str, issue_number: i32, body: PostIssuesCreateComment) -> Result<IssueComment, IssuesCreateCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesCreateCommentError::Status403(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesCreateCommentError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesCreateCommentError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesCreateCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesCreateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a label
    /// 
    /// [GitHub API docs for create_label](https://docs.github.com/rest/reference/issues#create-a-label)
    ///
    /// ---
    pub async fn create_label_async(&self, owner: &str, repo: &str, body: PostIssuesCreateLabel) -> Result<Label, IssuesCreateLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateLabel::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesCreateLabelError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesCreateLabelError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesCreateLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a label
    /// 
    /// [GitHub API docs for create_label](https://docs.github.com/rest/reference/issues#create-a-label)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_label(&self, owner: &str, repo: &str, body: PostIssuesCreateLabel) -> Result<Label, IssuesCreateLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateLabel::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesCreateLabelError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesCreateLabelError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesCreateLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a milestone
    /// 
    /// [GitHub API docs for create_milestone](https://docs.github.com/rest/reference/issues#create-a-milestone)
    ///
    /// ---
    pub async fn create_milestone_async(&self, owner: &str, repo: &str, body: PostIssuesCreateMilestone) -> Result<Milestone, IssuesCreateMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateMilestone::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesCreateMilestoneError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesCreateMilestoneError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesCreateMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a milestone
    /// 
    /// [GitHub API docs for create_milestone](https://docs.github.com/rest/reference/issues#create-a-milestone)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_milestone(&self, owner: &str, repo: &str, body: PostIssuesCreateMilestone) -> Result<Milestone, IssuesCreateMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostIssuesCreateMilestone::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesCreateMilestoneError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesCreateMilestoneError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesCreateMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue comment
    /// 
    /// [GitHub API docs for delete_comment](https://docs.github.com/rest/reference/issues#delete-an-issue-comment)
    ///
    /// ---
    pub async fn delete_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), IssuesDeleteCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesDeleteCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue comment
    /// 
    /// [GitHub API docs for delete_comment](https://docs.github.com/rest/reference/issues#delete-an-issue-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), IssuesDeleteCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesDeleteCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a label
    /// 
    /// [GitHub API docs for delete_label](https://docs.github.com/rest/reference/issues#delete-a-label)
    ///
    /// ---
    pub async fn delete_label_async(&self, owner: &str, repo: &str, name: &str) -> Result<(), IssuesDeleteLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesDeleteLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a label
    /// 
    /// [GitHub API docs for delete_label](https://docs.github.com/rest/reference/issues#delete-a-label)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_label(&self, owner: &str, repo: &str, name: &str) -> Result<(), IssuesDeleteLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesDeleteLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a milestone
    /// 
    /// [GitHub API docs for delete_milestone](https://docs.github.com/rest/reference/issues#delete-a-milestone)
    ///
    /// ---
    pub async fn delete_milestone_async(&self, owner: &str, repo: &str, milestone_number: i32) -> Result<(), IssuesDeleteMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesDeleteMilestoneError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesDeleteMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a milestone
    /// 
    /// [GitHub API docs for delete_milestone](https://docs.github.com/rest/reference/issues#delete-a-milestone)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_milestone(&self, owner: &str, repo: &str, milestone_number: i32) -> Result<(), IssuesDeleteMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesDeleteMilestoneError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesDeleteMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue
    ///
    /// The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-redirects-redirects) if the issue was
    /// [transferred](https://help.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
    /// the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
    /// returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
    /// access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
    /// to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/issues#get-an-issue)
    ///
    /// The `get_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_async(&self, owner: &str, repo: &str, issue_number: i32) -> Result<Issue, IssuesGetError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                301 => Err(IssuesGetError::Status301(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesGetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesGetError::Status410(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(IssuesGetError::Status304),
                code => Err(IssuesGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue
    ///
    /// The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-redirects-redirects) if the issue was
    /// [transferred](https://help.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
    /// the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
    /// returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
    /// access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
    /// to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/issues#get-an-issue)
    ///
    /// The `get` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get(&self, owner: &str, repo: &str, issue_number: i32) -> Result<Issue, IssuesGetError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                301 => Err(IssuesGetError::Status301(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesGetError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesGetError::Status410(crate::adapters::to_json(github_response)?)),
                304 => Err(IssuesGetError::Status304),
                code => Err(IssuesGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue comment
    /// 
    /// [GitHub API docs for get_comment](https://docs.github.com/rest/reference/issues#get-an-issue-comment)
    ///
    /// The `get_comment_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<IssueComment, IssuesGetCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesGetCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue comment
    /// 
    /// [GitHub API docs for get_comment](https://docs.github.com/rest/reference/issues#get-an-issue-comment)
    ///
    /// The `get_comment` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<IssueComment, IssuesGetCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesGetCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue event
    /// 
    /// [GitHub API docs for get_event](https://docs.github.com/rest/reference/issues#get-an-issue-event)
    ///
    /// The `get_event_async` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(feature = "starfox")]
    pub async fn get_event_async(&self, owner: &str, repo: &str, event_id: i32) -> Result<IssueEvent, IssuesGetEventError> {

        let request_uri = format!("{}/repos/{}/{}/issues/events/{}", super::GITHUB_BASE_API_URL, owner, repo, event_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetEventError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesGetEventError::Status410(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(IssuesGetEventError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesGetEventError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an issue event
    /// 
    /// [GitHub API docs for get_event](https://docs.github.com/rest/reference/issues#get-an-issue-event)
    ///
    /// The `get_event` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "starfox")]
    pub fn get_event(&self, owner: &str, repo: &str, event_id: i32) -> Result<IssueEvent, IssuesGetEventError> {

        let request_uri = format!("{}/repos/{}/{}/issues/events/{}", super::GITHUB_BASE_API_URL, owner, repo, event_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetEventError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesGetEventError::Status410(crate::adapters::to_json(github_response)?)),
                403 => Err(IssuesGetEventError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesGetEventError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a label
    /// 
    /// [GitHub API docs for get_label](https://docs.github.com/rest/reference/issues#get-a-label)
    ///
    /// ---
    pub async fn get_label_async(&self, owner: &str, repo: &str, name: &str) -> Result<Label, IssuesGetLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetLabelError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesGetLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a label
    /// 
    /// [GitHub API docs for get_label](https://docs.github.com/rest/reference/issues#get-a-label)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_label(&self, owner: &str, repo: &str, name: &str) -> Result<Label, IssuesGetLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetLabelError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesGetLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a milestone
    /// 
    /// [GitHub API docs for get_milestone](https://docs.github.com/rest/reference/issues#get-a-milestone)
    ///
    /// ---
    pub async fn get_milestone_async(&self, owner: &str, repo: &str, milestone_number: i32) -> Result<Milestone, IssuesGetMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetMilestoneError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesGetMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a milestone
    /// 
    /// [GitHub API docs for get_milestone](https://docs.github.com/rest/reference/issues#get-a-milestone)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_milestone(&self, owner: &str, repo: &str, milestone_number: i32) -> Result<Milestone, IssuesGetMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesGetMilestoneError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesGetMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issues assigned to the authenticated user
    ///
    /// List issues assigned to the authenticated user across all visible repositories including owned repositories, member
    /// repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
    /// necessarily assigned to you.
    /// 
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/issues#list-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_async(&self, query_params: Option<impl Into<IssuesListParams<'api>>>) -> Result<Vec<Issue>, IssuesListError> {

        let mut request_uri = format!("{}/issues", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(IssuesListError::Status304),
                404 => Err(IssuesListError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issues assigned to the authenticated user
    ///
    /// List issues assigned to the authenticated user across all visible repositories including owned repositories, member
    /// repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
    /// necessarily assigned to you.
    /// 
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/issues#list-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list(&self, query_params: Option<impl Into<IssuesListParams<'api>>>) -> Result<Vec<Issue>, IssuesListError> {

        let mut request_uri = format!("{}/issues", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(IssuesListError::Status304),
                404 => Err(IssuesListError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List assignees
    ///
    /// Lists the [available assignees](https://help.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
    /// 
    /// [GitHub API docs for list_assignees](https://docs.github.com/rest/reference/issues#list-assignees)
    ///
    /// ---
    pub async fn list_assignees_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListAssigneesParams>>) -> Result<Vec<SimpleUser>, IssuesListAssigneesError> {

        let mut request_uri = format!("{}/repos/{}/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListAssigneesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List assignees
    ///
    /// Lists the [available assignees](https://help.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
    /// 
    /// [GitHub API docs for list_assignees](https://docs.github.com/rest/reference/issues#list-assignees)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_assignees(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListAssigneesParams>>) -> Result<Vec<SimpleUser>, IssuesListAssigneesError> {

        let mut request_uri = format!("{}/repos/{}/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListAssigneesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListAssigneesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue comments
    ///
    /// Issue Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_comments](https://docs.github.com/rest/reference/issues#list-issue-comments)
    ///
    /// The `list_comments_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_comments_async(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListCommentsParams>>) -> Result<Vec<IssueComment>, IssuesListCommentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListCommentsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesListCommentsError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue comments
    ///
    /// Issue Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_comments](https://docs.github.com/rest/reference/issues#list-issue-comments)
    ///
    /// The `list_comments` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_comments(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListCommentsParams>>) -> Result<Vec<IssueComment>, IssuesListCommentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListCommentsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListCommentsError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesListCommentsError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue comments for a repository
    ///
    /// By default, Issue Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_comments_for_repo](https://docs.github.com/rest/reference/issues#list-issue-comments-for-a-repository)
    ///
    /// The `list_comments_for_repo_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_comments_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListCommentsForRepoParams<'api>>>) -> Result<Vec<IssueComment>, IssuesListCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListCommentsForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesListCommentsForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue comments for a repository
    ///
    /// By default, Issue Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_comments_for_repo](https://docs.github.com/rest/reference/issues#list-issue-comments-for-a-repository)
    ///
    /// The `list_comments_for_repo` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_comments_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListCommentsForRepoParams<'api>>>) -> Result<Vec<IssueComment>, IssuesListCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListCommentsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListCommentsForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesListCommentsForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue events
    /// 
    /// [GitHub API docs for list_events](https://docs.github.com/rest/reference/issues#list-issue-events)
    ///
    /// The `list_events_async` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(feature = "starfox")]
    pub async fn list_events_async(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListEventsParams>>) -> Result<Vec<IssueEventForIssue>, IssuesListEventsError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/events", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesListEventsError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue events
    /// 
    /// [GitHub API docs for list_events](https://docs.github.com/rest/reference/issues#list-issue-events)
    ///
    /// The `list_events` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "starfox")]
    pub fn list_events(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListEventsParams>>) -> Result<Vec<IssueEventForIssue>, IssuesListEventsError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/events", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListEventsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesListEventsError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue events for a repository
    /// 
    /// [GitHub API docs for list_events_for_repo](https://docs.github.com/rest/reference/issues#list-issue-events-for-a-repository)
    ///
    /// The `list_events_for_repo_async` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(feature = "starfox")]
    pub async fn list_events_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListEventsForRepoParams>>) -> Result<Vec<IssueEvent>, IssuesListEventsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListEventsForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListEventsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List issue events for a repository
    /// 
    /// [GitHub API docs for list_events_for_repo](https://docs.github.com/rest/reference/issues#list-issue-events-for-a-repository)
    ///
    /// The `list_events_for_repo` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "starfox")]
    pub fn list_events_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListEventsForRepoParams>>) -> Result<Vec<IssueEvent>, IssuesListEventsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListEventsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesListEventsForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListEventsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List timeline events for an issue
    /// 
    /// [GitHub API docs for list_events_for_timeline](https://docs.github.com/rest/reference/issues#list-timeline-events-for-an-issue)
    ///
    /// The `list_events_for_timeline_async` endpoint is enabled with the `mockingbird` cargo feature.
    /// The `list_events_for_timeline_async` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(feature = "mockingbird")]
    #[cfg(feature = "starfox")]
    pub async fn list_events_for_timeline_async(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListEventsForTimelineParams>>) -> Result<Vec<TimelineIssueEvents>, IssuesListEventsForTimelineError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/timeline", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mockingbird-preview+json"), ("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListEventsForTimelineError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesListEventsForTimelineError::Status410(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(IssuesListEventsForTimelineError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListEventsForTimelineError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List timeline events for an issue
    /// 
    /// [GitHub API docs for list_events_for_timeline](https://docs.github.com/rest/reference/issues#list-timeline-events-for-an-issue)
    ///
    /// The `list_events_for_timeline` endpoint is enabled with the `mockingbird` cargo feature.
    /// The `list_events_for_timeline` endpoint is enabled with the `starfox` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "mockingbird")]
    #[cfg(feature = "starfox")]
    pub fn list_events_for_timeline(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListEventsForTimelineParams>>) -> Result<Vec<TimelineIssueEvents>, IssuesListEventsForTimelineError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/timeline", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListEventsForTimelineParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mockingbird-preview+json"), ("Accept", "application/vnd.github.starfox-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListEventsForTimelineError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesListEventsForTimelineError::Status410(crate::adapters::to_json(github_response)?)),
                415 => Err(IssuesListEventsForTimelineError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListEventsForTimelineError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user account issues assigned to the authenticated user
    ///
    /// List issues across owned and member repositories assigned to the authenticated user.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/issues#list-user-account-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list_for_authenticated_user_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<IssuesListForAuthenticatedUserParams<'api>>>) -> Result<Vec<Issue>, IssuesListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/issues", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(IssuesListForAuthenticatedUserError::Status304),
                code => Err(IssuesListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user account issues assigned to the authenticated user
    ///
    /// List issues across owned and member repositories assigned to the authenticated user.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/issues#list-user-account-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list_for_authenticated_user` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<IssuesListForAuthenticatedUserParams<'api>>>) -> Result<Vec<Issue>, IssuesListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/issues", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(IssuesListForAuthenticatedUserError::Status304),
                code => Err(IssuesListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization issues assigned to the authenticated user
    ///
    /// List issues in an organization assigned to the authenticated user.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/issues#list-organization-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list_for_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_for_org_async(&self, org: &str, query_params: Option<impl Into<IssuesListForOrgParams<'api>>>) -> Result<Vec<Issue>, IssuesListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/issues", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization issues assigned to the authenticated user
    ///
    /// List issues in an organization assigned to the authenticated user.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/issues#list-organization-issues-assigned-to-the-authenticated-user)
    ///
    /// The `list_for_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_for_org(&self, org: &str, query_params: Option<impl Into<IssuesListForOrgParams<'api>>>) -> Result<Vec<Issue>, IssuesListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/issues", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository issues
    ///
    /// List issues in a repository.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_repo](https://docs.github.com/rest/reference/issues#list-repository-issues)
    ///
    /// The `list_for_repo_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListForRepoParams<'api>>>) -> Result<Vec<IssueSimple>, IssuesListForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                301 => Err(IssuesListForRepoError::Status301(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesListForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesListForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository issues
    ///
    /// List issues in a repository.
    /// 
    /// **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
    /// reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
    /// the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
    /// request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
    /// 
    /// [GitHub API docs for list_for_repo](https://docs.github.com/rest/reference/issues#list-repository-issues)
    ///
    /// The `list_for_repo` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListForRepoParams<'api>>>) -> Result<Vec<IssueSimple>, IssuesListForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                301 => Err(IssuesListForRepoError::Status301(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesListForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesListForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for issues in a milestone
    /// 
    /// [GitHub API docs for list_labels_for_milestone](https://docs.github.com/rest/reference/issues#list-labels-for-issues-in-a-milestone)
    ///
    /// ---
    pub async fn list_labels_for_milestone_async(&self, owner: &str, repo: &str, milestone_number: i32, query_params: Option<impl Into<IssuesListLabelsForMilestoneParams>>) -> Result<Vec<Label>, IssuesListLabelsForMilestoneError> {

        let mut request_uri = format!("{}/repos/{}/{}/milestones/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesListLabelsForMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for issues in a milestone
    /// 
    /// [GitHub API docs for list_labels_for_milestone](https://docs.github.com/rest/reference/issues#list-labels-for-issues-in-a-milestone)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_labels_for_milestone(&self, owner: &str, repo: &str, milestone_number: i32, query_params: Option<impl Into<IssuesListLabelsForMilestoneParams>>) -> Result<Vec<Label>, IssuesListLabelsForMilestoneError> {

        let mut request_uri = format!("{}/repos/{}/{}/milestones/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListLabelsForMilestoneParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesListLabelsForMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for a repository
    /// 
    /// [GitHub API docs for list_labels_for_repo](https://docs.github.com/rest/reference/issues#list-labels-for-a-repository)
    ///
    /// ---
    pub async fn list_labels_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListLabelsForRepoParams>>) -> Result<Vec<Label>, IssuesListLabelsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/labels", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListLabelsForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListLabelsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for a repository
    /// 
    /// [GitHub API docs for list_labels_for_repo](https://docs.github.com/rest/reference/issues#list-labels-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_labels_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListLabelsForRepoParams>>) -> Result<Vec<Label>, IssuesListLabelsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/labels", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListLabelsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListLabelsForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListLabelsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for an issue
    /// 
    /// [GitHub API docs for list_labels_on_issue](https://docs.github.com/rest/reference/issues#list-labels-for-an-issue)
    ///
    /// ---
    pub async fn list_labels_on_issue_async(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListLabelsOnIssueParams>>) -> Result<Vec<Label>, IssuesListLabelsOnIssueError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesListLabelsOnIssueError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListLabelsOnIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List labels for an issue
    /// 
    /// [GitHub API docs for list_labels_on_issue](https://docs.github.com/rest/reference/issues#list-labels-for-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_labels_on_issue(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<IssuesListLabelsOnIssueParams>>) -> Result<Vec<Label>, IssuesListLabelsOnIssueError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListLabelsOnIssueParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesListLabelsOnIssueError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListLabelsOnIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List milestones
    /// 
    /// [GitHub API docs for list_milestones](https://docs.github.com/rest/reference/issues#list-milestones)
    ///
    /// ---
    pub async fn list_milestones_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListMilestonesParams<'api>>>) -> Result<Vec<Milestone>, IssuesListMilestonesError> {

        let mut request_uri = format!("{}/repos/{}/{}/milestones", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListMilestonesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesListMilestonesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List milestones
    /// 
    /// [GitHub API docs for list_milestones](https://docs.github.com/rest/reference/issues#list-milestones)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_milestones(&self, owner: &str, repo: &str, query_params: Option<impl Into<IssuesListMilestonesParams<'api>>>) -> Result<Vec<Milestone>, IssuesListMilestonesError> {

        let mut request_uri = format!("{}/repos/{}/{}/milestones", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: IssuesListMilestonesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesListMilestonesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesListMilestonesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Lock an issue
    ///
    /// Users with push access can lock an issue or pull request's conversation.
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for lock](https://docs.github.com/rest/reference/issues#lock-an-issue)
    ///
    /// ---
    pub async fn lock_async(&self, owner: &str, repo: &str, issue_number: i32, body: PutIssuesLock) -> Result<(), IssuesLockError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/lock", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutIssuesLock::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesLockError::Status403(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesLockError::Status410(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesLockError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesLockError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesLockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Lock an issue
    ///
    /// Users with push access can lock an issue or pull request's conversation.
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for lock](https://docs.github.com/rest/reference/issues#lock-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn lock(&self, owner: &str, repo: &str, issue_number: i32, body: PutIssuesLock) -> Result<(), IssuesLockError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/lock", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutIssuesLock::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesLockError::Status403(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesLockError::Status410(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesLockError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesLockError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesLockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove all labels from an issue
    /// 
    /// [GitHub API docs for remove_all_labels](https://docs.github.com/rest/reference/issues#remove-all-labels-from-an-issue)
    ///
    /// ---
    pub async fn remove_all_labels_async(&self, owner: &str, repo: &str, issue_number: i32) -> Result<(), IssuesRemoveAllLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesRemoveAllLabelsError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesRemoveAllLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove all labels from an issue
    /// 
    /// [GitHub API docs for remove_all_labels](https://docs.github.com/rest/reference/issues#remove-all-labels-from-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_all_labels(&self, owner: &str, repo: &str, issue_number: i32) -> Result<(), IssuesRemoveAllLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesRemoveAllLabelsError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesRemoveAllLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove assignees from an issue
    ///
    /// Removes one or more assignees from an issue.
    /// 
    /// [GitHub API docs for remove_assignees](https://docs.github.com/rest/reference/issues#remove-assignees-from-an-issue)
    ///
    /// ---
    pub async fn remove_assignees_async(&self, owner: &str, repo: &str, issue_number: i32, body: DeleteIssuesRemoveAssignees) -> Result<IssueSimple, IssuesRemoveAssigneesError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteIssuesRemoveAssignees::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesRemoveAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove assignees from an issue
    ///
    /// Removes one or more assignees from an issue.
    /// 
    /// [GitHub API docs for remove_assignees](https://docs.github.com/rest/reference/issues#remove-assignees-from-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_assignees(&self, owner: &str, repo: &str, issue_number: i32, body: DeleteIssuesRemoveAssignees) -> Result<IssueSimple, IssuesRemoveAssigneesError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/assignees", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteIssuesRemoveAssignees::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesRemoveAssigneesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a label from an issue
    ///
    /// Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
    /// 
    /// [GitHub API docs for remove_label](https://docs.github.com/rest/reference/issues#remove-a-label-from-an-issue)
    ///
    /// ---
    pub async fn remove_label_async(&self, owner: &str, repo: &str, issue_number: i32, name: &str) -> Result<Vec<Label>, IssuesRemoveLabelError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesRemoveLabelError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesRemoveLabelError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesRemoveLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a label from an issue
    ///
    /// Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
    /// 
    /// [GitHub API docs for remove_label](https://docs.github.com/rest/reference/issues#remove-a-label-from-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_label(&self, owner: &str, repo: &str, issue_number: i32, name: &str) -> Result<Vec<Label>, IssuesRemoveLabelError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(IssuesRemoveLabelError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesRemoveLabelError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesRemoveLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set labels for an issue
    ///
    /// Removes any previous labels and sets the new labels for an issue.
    /// 
    /// [GitHub API docs for set_labels](https://docs.github.com/rest/reference/issues#set-labels-for-an-issue)
    ///
    /// ---
    pub async fn set_labels_async(&self, owner: &str, repo: &str, issue_number: i32, body: PutIssuesSetLabels) -> Result<Vec<Label>, IssuesSetLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutIssuesSetLabels::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesSetLabelsError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(IssuesSetLabelsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesSetLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set labels for an issue
    ///
    /// Removes any previous labels and sets the new labels for an issue.
    /// 
    /// [GitHub API docs for set_labels](https://docs.github.com/rest/reference/issues#set-labels-for-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_labels(&self, owner: &str, repo: &str, issue_number: i32, body: PutIssuesSetLabels) -> Result<Vec<Label>, IssuesSetLabelsError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/labels", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutIssuesSetLabels::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                410 => Err(IssuesSetLabelsError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(IssuesSetLabelsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesSetLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock an issue
    ///
    /// Users with push access can unlock an issue's conversation.
    /// 
    /// [GitHub API docs for unlock](https://docs.github.com/rest/reference/issues#unlock-an-issue)
    ///
    /// ---
    pub async fn unlock_async(&self, owner: &str, repo: &str, issue_number: i32) -> Result<(), IssuesUnlockError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/lock", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesUnlockError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesUnlockError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesUnlockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock an issue
    ///
    /// Users with push access can unlock an issue's conversation.
    /// 
    /// [GitHub API docs for unlock](https://docs.github.com/rest/reference/issues#unlock-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unlock(&self, owner: &str, repo: &str, issue_number: i32) -> Result<(), IssuesUnlockError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/lock", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(IssuesUnlockError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesUnlockError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesUnlockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an issue
    ///
    /// Issue owners and users with push access can edit an issue.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/issues/#update-an-issue)
    ///
    /// ---
    pub async fn update_async(&self, owner: &str, repo: &str, issue_number: i32, body: PatchIssuesUpdate) -> Result<Issue, IssuesUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(IssuesUpdateError::Status503(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(IssuesUpdateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                301 => Err(IssuesUpdateError::Status301(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(IssuesUpdateError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(IssuesUpdateError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an issue
    ///
    /// Issue owners and users with push access can edit an issue.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/issues/#update-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, owner: &str, repo: &str, issue_number: i32, body: PatchIssuesUpdate) -> Result<Issue, IssuesUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                503 => Err(IssuesUpdateError::Status503(crate::adapters::to_json(github_response)?)),
                403 => Err(IssuesUpdateError::Status403(crate::adapters::to_json(github_response)?)),
                301 => Err(IssuesUpdateError::Status301(crate::adapters::to_json(github_response)?)),
                404 => Err(IssuesUpdateError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(IssuesUpdateError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an issue comment
    /// 
    /// [GitHub API docs for update_comment](https://docs.github.com/rest/reference/issues#update-an-issue-comment)
    ///
    /// ---
    pub async fn update_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PatchIssuesUpdateComment) -> Result<IssueComment, IssuesUpdateCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesUpdateCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(IssuesUpdateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an issue comment
    /// 
    /// [GitHub API docs for update_comment](https://docs.github.com/rest/reference/issues#update-an-issue-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PatchIssuesUpdateComment) -> Result<IssueComment, IssuesUpdateCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(IssuesUpdateCommentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(IssuesUpdateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a label
    /// 
    /// [GitHub API docs for update_label](https://docs.github.com/rest/reference/issues#update-a-label)
    ///
    /// ---
    pub async fn update_label_async(&self, owner: &str, repo: &str, name: &str, body: PatchIssuesUpdateLabel) -> Result<Label, IssuesUpdateLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateLabel::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesUpdateLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a label
    /// 
    /// [GitHub API docs for update_label](https://docs.github.com/rest/reference/issues#update-a-label)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_label(&self, owner: &str, repo: &str, name: &str, body: PatchIssuesUpdateLabel) -> Result<Label, IssuesUpdateLabelError> {

        let request_uri = format!("{}/repos/{}/{}/labels/{}", super::GITHUB_BASE_API_URL, owner, repo, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateLabel::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesUpdateLabelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a milestone
    /// 
    /// [GitHub API docs for update_milestone](https://docs.github.com/rest/reference/issues#update-a-milestone)
    ///
    /// ---
    pub async fn update_milestone_async(&self, owner: &str, repo: &str, milestone_number: i32, body: PatchIssuesUpdateMilestone) -> Result<Milestone, IssuesUpdateMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateMilestone::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesUpdateMilestoneError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a milestone
    /// 
    /// [GitHub API docs for update_milestone](https://docs.github.com/rest/reference/issues#update-a-milestone)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_milestone(&self, owner: &str, repo: &str, milestone_number: i32, body: PatchIssuesUpdateMilestone) -> Result<Milestone, IssuesUpdateMilestoneError> {

        let request_uri = format!("{}/repos/{}/{}/milestones/{}", super::GITHUB_BASE_API_URL, owner, repo, milestone_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchIssuesUpdateMilestone::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(IssuesUpdateMilestoneError::Generic { code }),
            }
        }
    }

}
