//! Method, error and parameter types for the Git endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Git<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Git {
    Git { auth }
}

/// Errors for the [Create a blob](Git::create_blob_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitCreateBlobError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a commit](Git::create_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitCreateCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a reference](Git::create_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitCreateRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a tag object](Git::create_tag_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitCreateTagError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a tree](Git::create_tree_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitCreateTreeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a reference](Git::delete_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitDeleteRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a blob](Git::get_blob_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitGetBlobError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a commit](Git::get_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitGetCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a reference](Git::get_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitGetRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a tag](Git::get_tag_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitGetTagError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a tree](Git::get_tree_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitGetTreeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List matching references](Git::list_matching_refs_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitListMatchingRefsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a reference](Git::update_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitUpdateRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get a tree](Git::get_tree_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GitGetTreeParams<'req> {
    /// Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `\"true\"`, and `\"false\"`. Omit this parameter to prevent recursively returning objects or subtrees.
    recursive: Option<&'req str>
}

impl<'req> GitGetTreeParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `\"true\"`, and `\"false\"`. Omit this parameter to prevent recursively returning objects or subtrees.
    pub fn recursive(self, recursive: &'req str) -> Self {
        Self { 
            recursive: Some(recursive),
        }
    }
}

/// Query parameters for the [List matching references](Git::list_matching_refs_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GitListMatchingRefsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GitListMatchingRefsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GitListMatchingRefsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Git<'api> {
    /// ---
    ///
    /// # Create a blob
    /// 
    /// [GitHub API docs for create_blob](https://docs.github.com/rest/reference/git#create-a-blob)
    ///
    /// ---
    pub async fn create_blob_async(&self, owner: &str, repo: &str, body: PostGitCreateBlob) -> Result<ShortBlob, GitCreateBlobError> {

        let request_uri = format!("{}/repos/{}/{}/git/blobs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateBlob::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GitCreateBlobError::Status404(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(GitCreateBlobError::Status409(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GitCreateBlobError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(GitCreateBlobError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitCreateBlobError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a blob
    /// 
    /// [GitHub API docs for create_blob](https://docs.github.com/rest/reference/git#create-a-blob)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_blob(&self, owner: &str, repo: &str, body: PostGitCreateBlob) -> Result<ShortBlob, GitCreateBlobError> {

        let request_uri = format!("{}/repos/{}/{}/git/blobs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateBlob::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GitCreateBlobError::Status404(crate::adapters::to_json(github_response)?)),
                409 => Err(GitCreateBlobError::Status409(crate::adapters::to_json(github_response)?)),
                403 => Err(GitCreateBlobError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(GitCreateBlobError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GitCreateBlobError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit
    ///
    /// Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for create_commit](https://docs.github.com/rest/reference/git#create-a-commit)
    ///
    /// ---
    pub async fn create_commit_async(&self, owner: &str, repo: &str, body: PostGitCreateCommit) -> Result<GitCommit, GitCreateCommitError> {

        let request_uri = format!("{}/repos/{}/{}/git/commits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateCommit::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateCommitError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GitCreateCommitError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitCreateCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit
    ///
    /// Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for create_commit](https://docs.github.com/rest/reference/git#create-a-commit)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_commit(&self, owner: &str, repo: &str, body: PostGitCreateCommit) -> Result<GitCommit, GitCreateCommitError> {

        let request_uri = format!("{}/repos/{}/{}/git/commits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateCommit::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateCommitError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(GitCreateCommitError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GitCreateCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a reference
    ///
    /// Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
    /// 
    /// [GitHub API docs for create_ref](https://docs.github.com/rest/reference/git#create-a-reference)
    ///
    /// ---
    pub async fn create_ref_async(&self, owner: &str, repo: &str, body: PostGitCreateRef) -> Result<GitRef, GitCreateRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateRef::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateRefError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitCreateRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a reference
    ///
    /// Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
    /// 
    /// [GitHub API docs for create_ref](https://docs.github.com/rest/reference/git#create-a-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_ref(&self, owner: &str, repo: &str, body: PostGitCreateRef) -> Result<GitRef, GitCreateRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateRef::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateRefError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GitCreateRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a tag object
    ///
    /// Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/reference/git#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/reference/git#create-a-reference) the tag reference - this call would be unnecessary.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for create_tag](https://docs.github.com/rest/reference/git#create-a-tag-object)
    ///
    /// ---
    pub async fn create_tag_async(&self, owner: &str, repo: &str, body: PostGitCreateTag) -> Result<GitTag, GitCreateTagError> {

        let request_uri = format!("{}/repos/{}/{}/git/tags", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateTag::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateTagError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitCreateTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a tag object
    ///
    /// Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/reference/git#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/reference/git#create-a-reference) the tag reference - this call would be unnecessary.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for create_tag](https://docs.github.com/rest/reference/git#create-a-tag-object)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_tag(&self, owner: &str, repo: &str, body: PostGitCreateTag) -> Result<GitTag, GitCreateTagError> {

        let request_uri = format!("{}/repos/{}/{}/git/tags", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateTag::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateTagError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GitCreateTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a tree
    ///
    /// The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
    /// 
    /// If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/reference/git#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/reference/git#update-a-reference)."
    /// 
    /// [GitHub API docs for create_tree](https://docs.github.com/rest/reference/git#create-a-tree)
    ///
    /// ---
    pub async fn create_tree_async(&self, owner: &str, repo: &str, body: PostGitCreateTree) -> Result<GitTree, GitCreateTreeError> {

        let request_uri = format!("{}/repos/{}/{}/git/trees", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateTree::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateTreeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GitCreateTreeError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GitCreateTreeError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitCreateTreeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a tree
    ///
    /// The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
    /// 
    /// If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/reference/git#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/reference/git#update-a-reference)."
    /// 
    /// [GitHub API docs for create_tree](https://docs.github.com/rest/reference/git#create-a-tree)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_tree(&self, owner: &str, repo: &str, body: PostGitCreateTree) -> Result<GitTree, GitCreateTreeError> {

        let request_uri = format!("{}/repos/{}/{}/git/trees", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGitCreateTree::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitCreateTreeError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(GitCreateTreeError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GitCreateTreeError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GitCreateTreeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a reference
    /// 
    /// [GitHub API docs for delete_ref](https://docs.github.com/rest/reference/git#delete-a-reference)
    ///
    /// ---
    pub async fn delete_ref_async(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), GitDeleteRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitDeleteRefError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitDeleteRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a reference
    /// 
    /// [GitHub API docs for delete_ref](https://docs.github.com/rest/reference/git#delete-a-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_ref(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), GitDeleteRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitDeleteRefError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GitDeleteRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a blob
    ///
    /// The `content` in the response will always be Base64 encoded.
    /// 
    /// _Note_: This API supports blobs up to 100 megabytes in size.
    /// 
    /// [GitHub API docs for get_blob](https://docs.github.com/rest/reference/git#get-a-blob)
    ///
    /// ---
    pub async fn get_blob_async(&self, owner: &str, repo: &str, file_sha: &str) -> Result<Blob, GitGetBlobError> {

        let request_uri = format!("{}/repos/{}/{}/git/blobs/{}", super::GITHUB_BASE_API_URL, owner, repo, file_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetBlobError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(GitGetBlobError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GitGetBlobError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitGetBlobError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a blob
    ///
    /// The `content` in the response will always be Base64 encoded.
    /// 
    /// _Note_: This API supports blobs up to 100 megabytes in size.
    /// 
    /// [GitHub API docs for get_blob](https://docs.github.com/rest/reference/git#get-a-blob)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_blob(&self, owner: &str, repo: &str, file_sha: &str) -> Result<Blob, GitGetBlobError> {

        let request_uri = format!("{}/repos/{}/{}/git/blobs/{}", super::GITHUB_BASE_API_URL, owner, repo, file_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetBlobError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(GitGetBlobError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(GitGetBlobError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GitGetBlobError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit
    ///
    /// Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_commit](https://docs.github.com/rest/reference/git#get-a-commit)
    ///
    /// ---
    pub async fn get_commit_async(&self, owner: &str, repo: &str, commit_sha: &str) -> Result<GitCommit, GitGetCommitError> {

        let request_uri = format!("{}/repos/{}/{}/git/commits/{}", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetCommitError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitGetCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit
    ///
    /// Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_commit](https://docs.github.com/rest/reference/git#get-a-commit)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit(&self, owner: &str, repo: &str, commit_sha: &str) -> Result<GitCommit, GitGetCommitError> {

        let request_uri = format!("{}/repos/{}/{}/git/commits/{}", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetCommitError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GitGetCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a reference
    ///
    /// Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
    /// 
    /// **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// [GitHub API docs for get_ref](https://docs.github.com/rest/reference/git#get-a-reference)
    ///
    /// ---
    pub async fn get_ref_async(&self, owner: &str, repo: &str, git_ref: &str) -> Result<GitRef, GitGetRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/ref/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetRefError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitGetRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a reference
    ///
    /// Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
    /// 
    /// **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// [GitHub API docs for get_ref](https://docs.github.com/rest/reference/git#get-a-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_ref(&self, owner: &str, repo: &str, git_ref: &str) -> Result<GitRef, GitGetRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/ref/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetRefError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GitGetRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a tag
    ///
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_tag](https://docs.github.com/rest/reference/git#get-a-tag)
    ///
    /// ---
    pub async fn get_tag_async(&self, owner: &str, repo: &str, tag_sha: &str) -> Result<GitTag, GitGetTagError> {

        let request_uri = format!("{}/repos/{}/{}/git/tags/{}", super::GITHUB_BASE_API_URL, owner, repo, tag_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetTagError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitGetTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a tag
    ///
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_tag](https://docs.github.com/rest/reference/git#get-a-tag)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_tag(&self, owner: &str, repo: &str, tag_sha: &str) -> Result<GitTag, GitGetTagError> {

        let request_uri = format!("{}/repos/{}/{}/git/tags/{}", super::GITHUB_BASE_API_URL, owner, repo, tag_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GitGetTagError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GitGetTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a tree
    ///
    /// Returns a single tree using the SHA1 value for that tree.
    /// 
    /// If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
    /// 
    /// [GitHub API docs for get_tree](https://docs.github.com/rest/reference/git#get-a-tree)
    ///
    /// ---
    pub async fn get_tree_async(&self, owner: &str, repo: &str, tree_sha: &str, query_params: Option<impl Into<GitGetTreeParams<'api>>>) -> Result<GitTree, GitGetTreeError> {

        let mut request_uri = format!("{}/repos/{}/{}/git/trees/{}", super::GITHUB_BASE_API_URL, owner, repo, tree_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitGetTreeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GitGetTreeError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitGetTreeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a tree
    ///
    /// Returns a single tree using the SHA1 value for that tree.
    /// 
    /// If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
    /// 
    /// [GitHub API docs for get_tree](https://docs.github.com/rest/reference/git#get-a-tree)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_tree(&self, owner: &str, repo: &str, tree_sha: &str, query_params: Option<impl Into<GitGetTreeParams<'api>>>) -> Result<GitTree, GitGetTreeError> {

        let mut request_uri = format!("{}/repos/{}/{}/git/trees/{}", super::GITHUB_BASE_API_URL, owner, repo, tree_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GitGetTreeParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitGetTreeError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(GitGetTreeError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GitGetTreeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List matching references
    ///
    /// Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
    /// 
    /// When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
    /// 
    /// **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
    /// 
    /// [GitHub API docs for list_matching_refs](https://docs.github.com/rest/reference/git#list-matching-references)
    ///
    /// ---
    pub async fn list_matching_refs_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<GitListMatchingRefsParams>>) -> Result<Vec<GitRef>, GitListMatchingRefsError> {

        let mut request_uri = format!("{}/repos/{}/{}/git/matching-refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(GitListMatchingRefsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List matching references
    ///
    /// Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
    /// 
    /// When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
    /// 
    /// **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
    /// 
    /// [GitHub API docs for list_matching_refs](https://docs.github.com/rest/reference/git#list-matching-references)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_matching_refs(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<GitListMatchingRefsParams>>) -> Result<Vec<GitRef>, GitListMatchingRefsError> {

        let mut request_uri = format!("{}/repos/{}/{}/git/matching-refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GitListMatchingRefsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(GitListMatchingRefsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a reference
    /// 
    /// [GitHub API docs for update_ref](https://docs.github.com/rest/reference/git#update-a-reference)
    ///
    /// ---
    pub async fn update_ref_async(&self, owner: &str, repo: &str, git_ref: &str, body: PatchGitUpdateRef) -> Result<GitRef, GitUpdateRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGitUpdateRef::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GitUpdateRefError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GitUpdateRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a reference
    /// 
    /// [GitHub API docs for update_ref](https://docs.github.com/rest/reference/git#update-a-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_ref(&self, owner: &str, repo: &str, git_ref: &str, body: PatchGitUpdateRef) -> Result<GitRef, GitUpdateRefError> {

        let request_uri = format!("{}/repos/{}/{}/git/refs/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGitUpdateRef::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GitUpdateRefError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GitUpdateRefError::Generic { code }),
            }
        }
    }

}
