//! Method, error and parameter types for the Gists endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Gists<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Gists {
    Gists { auth }
}

/// Errors for the [Check if a gist is starred](Gists::check_is_starred_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsCheckIsStarredError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if gist is not starred")]
    Status404(HashMap<String, Value>),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a gist](Gists::create_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsCreateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a gist comment](Gists::create_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsCreateCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a gist](Gists::delete_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsDeleteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a gist comment](Gists::delete_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsDeleteCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Fork a gist](Gists::fork_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsForkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a gist](Gists::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden Gist")]
    Status403(GetGistsGetCommentResponse403),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a gist comment](Gists::get_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsGetCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden Gist")]
    Status403(GetGistsGetCommentResponse403),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a gist revision](Gists::get_revision_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsGetRevisionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List gists for the authenticated user](Gists::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List gist comments](Gists::list_comments_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListCommentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List gist commits](Gists::list_commits_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListCommitsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List gists for a user](Gists::list_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List gist forks](Gists::list_forks_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListForksError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public gists](Gists::list_public_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListPublicError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List starred gists](Gists::list_starred_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsListStarredError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Star a gist](Gists::star_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsStarError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unstar a gist](Gists::unstar_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsUnstarError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a gist](Gists::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a gist comment](Gists::update_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GistsUpdateCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List gists for the authenticated user](Gists::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListParams {
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List gist comments](Gists::list_comments_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListCommentsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListCommentsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListCommentsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List gist commits](Gists::list_commits_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListCommitsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListCommitsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListCommitsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List gists for a user](Gists::list_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListForUserParams {
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List gist forks](Gists::list_forks_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListForksParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListForksParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListForksParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public gists](Gists::list_public_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListPublicParams {
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListPublicParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListPublicParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List starred gists](Gists::list_starred_async()) endpoint.
#[derive(Default, Serialize)]
pub struct GistsListStarredParams {
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl GistsListStarredParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for GistsListStarredParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Gists<'api> {
    /// ---
    ///
    /// # Check if a gist is starred
    /// 
    /// [GitHub API docs for check_is_starred](https://docs.github.com/rest/reference/gists#check-if-a-gist-is-starred)
    ///
    /// ---
    pub async fn check_is_starred_async(&self, gist_id: &str) -> Result<(), GistsCheckIsStarredError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsCheckIsStarredError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsCheckIsStarredError::Status304),
                403 => Err(GistsCheckIsStarredError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsCheckIsStarredError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a gist is starred
    /// 
    /// [GitHub API docs for check_is_starred](https://docs.github.com/rest/reference/gists#check-if-a-gist-is-starred)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_is_starred(&self, gist_id: &str) -> Result<(), GistsCheckIsStarredError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsCheckIsStarredError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsCheckIsStarredError::Status304),
                403 => Err(GistsCheckIsStarredError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsCheckIsStarredError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a gist
    ///
    /// Allows you to add a new gist with one or more files.
    /// 
    /// **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/gists#create-a-gist)
    ///
    /// ---
    pub async fn create_async(&self, body: PostGistsCreate) -> Result<GistSimple, GistsCreateError> {

        let request_uri = format!("{}/gists", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGistsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsCreateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsCreateError::Status304),
                404 => Err(GistsCreateError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsCreateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a gist
    ///
    /// Allows you to add a new gist with one or more files.
    /// 
    /// **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/gists#create-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create(&self, body: PostGistsCreate) -> Result<GistSimple, GistsCreateError> {

        let request_uri = format!("{}/gists", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGistsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsCreateError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsCreateError::Status304),
                404 => Err(GistsCreateError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsCreateError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a gist comment
    /// 
    /// [GitHub API docs for create_comment](https://docs.github.com/rest/reference/gists#create-a-gist-comment)
    ///
    /// ---
    pub async fn create_comment_async(&self, gist_id: &str, body: PostGistsCreateComment) -> Result<GistComment, GistsCreateCommentError> {

        let request_uri = format!("{}/gists/{}/comments", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGistsCreateComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsCreateCommentError::Status304),
                404 => Err(GistsCreateCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsCreateCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsCreateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a gist comment
    /// 
    /// [GitHub API docs for create_comment](https://docs.github.com/rest/reference/gists#create-a-gist-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_comment(&self, gist_id: &str, body: PostGistsCreateComment) -> Result<GistComment, GistsCreateCommentError> {

        let request_uri = format!("{}/gists/{}/comments", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostGistsCreateComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsCreateCommentError::Status304),
                404 => Err(GistsCreateCommentError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsCreateCommentError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsCreateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a gist
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/gists#delete-a-gist)
    ///
    /// ---
    pub async fn delete_async(&self, gist_id: &str) -> Result<(), GistsDeleteError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsDeleteError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsDeleteError::Status304),
                403 => Err(GistsDeleteError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a gist
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/gists#delete-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete(&self, gist_id: &str) -> Result<(), GistsDeleteError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsDeleteError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsDeleteError::Status304),
                403 => Err(GistsDeleteError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a gist comment
    /// 
    /// [GitHub API docs for delete_comment](https://docs.github.com/rest/reference/gists#delete-a-gist-comment)
    ///
    /// ---
    pub async fn delete_comment_async(&self, gist_id: &str, comment_id: i32) -> Result<(), GistsDeleteCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsDeleteCommentError::Status304),
                404 => Err(GistsDeleteCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsDeleteCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsDeleteCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a gist comment
    /// 
    /// [GitHub API docs for delete_comment](https://docs.github.com/rest/reference/gists#delete-a-gist-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_comment(&self, gist_id: &str, comment_id: i32) -> Result<(), GistsDeleteCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsDeleteCommentError::Status304),
                404 => Err(GistsDeleteCommentError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsDeleteCommentError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsDeleteCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Fork a gist
    ///
    /// **Note**: This was previously `/gists/:gist_id/fork`.
    /// 
    /// [GitHub API docs for fork](https://docs.github.com/rest/reference/gists#fork-a-gist)
    ///
    /// ---
    pub async fn fork_async(&self, gist_id: &str) -> Result<BaseGist, GistsForkError> {

        let request_uri = format!("{}/gists/{}/forks", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsForkError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(GistsForkError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsForkError::Status304),
                403 => Err(GistsForkError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsForkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Fork a gist
    ///
    /// **Note**: This was previously `/gists/:gist_id/fork`.
    /// 
    /// [GitHub API docs for fork](https://docs.github.com/rest/reference/gists#fork-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn fork(&self, gist_id: &str) -> Result<BaseGist, GistsForkError> {

        let request_uri = format!("{}/gists/{}/forks", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsForkError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(GistsForkError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsForkError::Status304),
                403 => Err(GistsForkError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsForkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/gists#get-a-gist)
    ///
    /// ---
    pub async fn get_async(&self, gist_id: &str) -> Result<GistSimple, GistsGetError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(GistsGetError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GistsGetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsGetError::Status304),
                code => Err(GistsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/gists#get-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, gist_id: &str) -> Result<GistSimple, GistsGetError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(GistsGetError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(GistsGetError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsGetError::Status304),
                code => Err(GistsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist comment
    /// 
    /// [GitHub API docs for get_comment](https://docs.github.com/rest/reference/gists#get-a-gist-comment)
    ///
    /// ---
    pub async fn get_comment_async(&self, gist_id: &str, comment_id: i32) -> Result<GistComment, GistsGetCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsGetCommentError::Status304),
                404 => Err(GistsGetCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsGetCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsGetCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist comment
    /// 
    /// [GitHub API docs for get_comment](https://docs.github.com/rest/reference/gists#get-a-gist-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_comment(&self, gist_id: &str, comment_id: i32) -> Result<GistComment, GistsGetCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsGetCommentError::Status304),
                404 => Err(GistsGetCommentError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsGetCommentError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsGetCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist revision
    /// 
    /// [GitHub API docs for get_revision](https://docs.github.com/rest/reference/gists#get-a-gist-revision)
    ///
    /// ---
    pub async fn get_revision_async(&self, gist_id: &str, sha: &str) -> Result<GistSimple, GistsGetRevisionError> {

        let request_uri = format!("{}/gists/{}/{}", super::GITHUB_BASE_API_URL, gist_id, sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsGetRevisionError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GistsGetRevisionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsGetRevisionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsGetRevisionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gist revision
    /// 
    /// [GitHub API docs for get_revision](https://docs.github.com/rest/reference/gists#get-a-gist-revision)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_revision(&self, gist_id: &str, sha: &str) -> Result<GistSimple, GistsGetRevisionError> {

        let request_uri = format!("{}/gists/{}/{}", super::GITHUB_BASE_API_URL, gist_id, sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsGetRevisionError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(GistsGetRevisionError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsGetRevisionError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsGetRevisionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gists for the authenticated user
    ///
    /// Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/gists#list-gists-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_async(&self, query_params: Option<impl Into<GistsListParams>>) -> Result<Vec<BaseGist>, GistsListError> {

        let mut request_uri = format!("{}/gists", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsListError::Status304),
                403 => Err(GistsListError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gists for the authenticated user
    ///
    /// Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/gists#list-gists-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list(&self, query_params: Option<impl Into<GistsListParams>>) -> Result<Vec<BaseGist>, GistsListError> {

        let mut request_uri = format!("{}/gists", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsListError::Status304),
                403 => Err(GistsListError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist comments
    /// 
    /// [GitHub API docs for list_comments](https://docs.github.com/rest/reference/gists#list-gist-comments)
    ///
    /// ---
    pub async fn list_comments_async(&self, gist_id: &str, query_params: Option<impl Into<GistsListCommentsParams>>) -> Result<Vec<GistComment>, GistsListCommentsError> {

        let mut request_uri = format!("{}/gists/{}/comments", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsListCommentsError::Status304),
                404 => Err(GistsListCommentsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsListCommentsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist comments
    /// 
    /// [GitHub API docs for list_comments](https://docs.github.com/rest/reference/gists#list-gist-comments)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_comments(&self, gist_id: &str, query_params: Option<impl Into<GistsListCommentsParams>>) -> Result<Vec<GistComment>, GistsListCommentsError> {

        let mut request_uri = format!("{}/gists/{}/comments", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListCommentsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsListCommentsError::Status304),
                404 => Err(GistsListCommentsError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsListCommentsError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist commits
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/gists#list-gist-commits)
    ///
    /// ---
    pub async fn list_commits_async(&self, gist_id: &str, query_params: Option<impl Into<GistsListCommitsParams>>) -> Result<Vec<GistCommit>, GistsListCommitsError> {

        let mut request_uri = format!("{}/gists/{}/commits", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsListCommitsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsListCommitsError::Status304),
                403 => Err(GistsListCommitsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist commits
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/gists#list-gist-commits)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_commits(&self, gist_id: &str, query_params: Option<impl Into<GistsListCommitsParams>>) -> Result<Vec<GistCommit>, GistsListCommitsError> {

        let mut request_uri = format!("{}/gists/{}/commits", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListCommitsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsListCommitsError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsListCommitsError::Status304),
                403 => Err(GistsListCommitsError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gists for a user
    ///
    /// Lists public gists for the specified user:
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/gists#list-gists-for-a-user)
    ///
    /// ---
    pub async fn list_for_user_async(&self, username: &str, query_params: Option<impl Into<GistsListForUserParams>>) -> Result<Vec<BaseGist>, GistsListForUserError> {

        let mut request_uri = format!("{}/users/{}/gists", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsListForUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gists for a user
    ///
    /// Lists public gists for the specified user:
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/gists#list-gists-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_user(&self, username: &str, query_params: Option<impl Into<GistsListForUserParams>>) -> Result<Vec<BaseGist>, GistsListForUserError> {

        let mut request_uri = format!("{}/users/{}/gists", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsListForUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist forks
    /// 
    /// [GitHub API docs for list_forks](https://docs.github.com/rest/reference/gists#list-gist-forks)
    ///
    /// ---
    pub async fn list_forks_async(&self, gist_id: &str, query_params: Option<impl Into<GistsListForksParams>>) -> Result<Vec<GistSimple>, GistsListForksError> {

        let mut request_uri = format!("{}/gists/{}/forks", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsListForksError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsListForksError::Status304),
                403 => Err(GistsListForksError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListForksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List gist forks
    /// 
    /// [GitHub API docs for list_forks](https://docs.github.com/rest/reference/gists#list-gist-forks)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_forks(&self, gist_id: &str, query_params: Option<impl Into<GistsListForksParams>>) -> Result<Vec<GistSimple>, GistsListForksError> {

        let mut request_uri = format!("{}/gists/{}/forks", super::GITHUB_BASE_API_URL, gist_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListForksParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsListForksError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsListForksError::Status304),
                403 => Err(GistsListForksError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListForksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public gists
    ///
    /// List public gists sorted by most recently updated to least recently updated.
    /// 
    /// Note: With [pagination](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
    /// 
    /// [GitHub API docs for list_public](https://docs.github.com/rest/reference/gists#list-public-gists)
    ///
    /// ---
    pub async fn list_public_async(&self, query_params: Option<impl Into<GistsListPublicParams>>) -> Result<Vec<BaseGist>, GistsListPublicError> {

        let mut request_uri = format!("{}/gists/public", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsListPublicError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsListPublicError::Status304),
                403 => Err(GistsListPublicError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListPublicError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public gists
    ///
    /// List public gists sorted by most recently updated to least recently updated.
    /// 
    /// Note: With [pagination](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
    /// 
    /// [GitHub API docs for list_public](https://docs.github.com/rest/reference/gists#list-public-gists)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public(&self, query_params: Option<impl Into<GistsListPublicParams>>) -> Result<Vec<BaseGist>, GistsListPublicError> {

        let mut request_uri = format!("{}/gists/public", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListPublicParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsListPublicError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsListPublicError::Status304),
                403 => Err(GistsListPublicError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListPublicError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List starred gists
    ///
    /// List the authenticated user's starred gists:
    /// 
    /// [GitHub API docs for list_starred](https://docs.github.com/rest/reference/gists#list-starred-gists)
    ///
    /// ---
    pub async fn list_starred_async(&self, query_params: Option<impl Into<GistsListStarredParams>>) -> Result<Vec<BaseGist>, GistsListStarredError> {

        let mut request_uri = format!("{}/gists/starred", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(GistsListStarredError::Status401(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsListStarredError::Status304),
                403 => Err(GistsListStarredError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsListStarredError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List starred gists
    ///
    /// List the authenticated user's starred gists:
    /// 
    /// [GitHub API docs for list_starred](https://docs.github.com/rest/reference/gists#list-starred-gists)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_starred(&self, query_params: Option<impl Into<GistsListStarredParams>>) -> Result<Vec<BaseGist>, GistsListStarredError> {

        let mut request_uri = format!("{}/gists/starred", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: GistsListStarredParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(GistsListStarredError::Status401(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsListStarredError::Status304),
                403 => Err(GistsListStarredError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsListStarredError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Star a gist
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for star](https://docs.github.com/rest/reference/gists#star-a-gist)
    ///
    /// ---
    pub async fn star_async(&self, gist_id: &str) -> Result<(), GistsStarError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsStarError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(GistsStarError::Status304),
                403 => Err(GistsStarError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsStarError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Star a gist
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for star](https://docs.github.com/rest/reference/gists#star-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn star(&self, gist_id: &str) -> Result<(), GistsStarError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsStarError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(GistsStarError::Status304),
                403 => Err(GistsStarError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsStarError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unstar a gist
    /// 
    /// [GitHub API docs for unstar](https://docs.github.com/rest/reference/gists#unstar-a-gist)
    ///
    /// ---
    pub async fn unstar_async(&self, gist_id: &str) -> Result<(), GistsUnstarError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsUnstarError::Status304),
                404 => Err(GistsUnstarError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(GistsUnstarError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsUnstarError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unstar a gist
    /// 
    /// [GitHub API docs for unstar](https://docs.github.com/rest/reference/gists#unstar-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unstar(&self, gist_id: &str) -> Result<(), GistsUnstarError> {

        let request_uri = format!("{}/gists/{}/star", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GistsUnstarError::Status304),
                404 => Err(GistsUnstarError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(GistsUnstarError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(GistsUnstarError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a gist
    ///
    /// Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/gists/#update-a-gist)
    ///
    /// ---
    pub async fn update_async(&self, gist_id: &str, body: PatchGistsUpdate) -> Result<GistSimple, GistsUpdateError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGistsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(GistsUpdateError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a gist
    ///
    /// Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/gists/#update-a-gist)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, gist_id: &str, body: PatchGistsUpdate) -> Result<GistSimple, GistsUpdateError> {

        let request_uri = format!("{}/gists/{}", super::GITHUB_BASE_API_URL, gist_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGistsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(GistsUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(GistsUpdateError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GistsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a gist comment
    /// 
    /// [GitHub API docs for update_comment](https://docs.github.com/rest/reference/gists#update-a-gist-comment)
    ///
    /// ---
    pub async fn update_comment_async(&self, gist_id: &str, comment_id: i32, body: PatchGistsUpdateComment) -> Result<GistComment, GistsUpdateCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGistsUpdateComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsUpdateCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(GistsUpdateCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a gist comment
    /// 
    /// [GitHub API docs for update_comment](https://docs.github.com/rest/reference/gists#update-a-gist-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_comment(&self, gist_id: &str, comment_id: i32, body: PatchGistsUpdateComment) -> Result<GistComment, GistsUpdateCommentError> {

        let request_uri = format!("{}/gists/{}/comments/{}", super::GITHUB_BASE_API_URL, gist_id, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchGistsUpdateComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(GistsUpdateCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(GistsUpdateCommentError::Generic { code }),
            }
        }
    }

}
