//! Method, error and parameter types for the CodeScanning endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct CodeScanning<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> CodeScanning {
    CodeScanning { auth }
}

/// Errors for the [Delete a code scanning analysis from a repository](CodeScanning::delete_analysis_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningDeleteAnalysisError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Response if the repository is archived or if github advanced security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a code scanning alert](CodeScanning::get_alert_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningGetAlertError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a code scanning analysis for a repository](CodeScanning::get_analysis_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningGetAnalysisError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get information about a SARIF upload](CodeScanning::get_sarif_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningGetSarifError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Not Found if the sarif id does not match any upload")]
    Status404,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List instances of a code scanning alert](CodeScanning::list_alert_instances_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningListAlertInstancesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List code scanning alerts for a repository](CodeScanning::list_alerts_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningListAlertsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List code scanning analyses for a repository](CodeScanning::list_recent_analyses_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningListRecentAnalysesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if GitHub Advanced Security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a code scanning alert](CodeScanning::update_alert_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningUpdateAlertError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if the repository is archived or if github advanced security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Upload an analysis as SARIF data](CodeScanning::upload_sarif_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodeScanningUploadSarifError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request if the sarif field is invalid")]
    Status400,
    #[error("Response if the repository is archived or if github advanced security is not enabled for this repository")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Payload Too Large if the sarif field is too large")]
    Status413,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Delete a code scanning analysis from a repository](CodeScanning::delete_analysis_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodeScanningDeleteAnalysisParams<'req> {
    /// Allow deletion if the specified analysis is the last in a set. If you attempt to delete the final analysis in a set without setting this parameter to `true`, you'll get a 400 response with the message: `Analysis is last of its type and deletion may result in the loss of historical alert data. Please specify confirm_delete.`
    confirm_delete: Option<&'req str>
}

impl<'req> CodeScanningDeleteAnalysisParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Allow deletion if the specified analysis is the last in a set. If you attempt to delete the final analysis in a set without setting this parameter to `true`, you'll get a 400 response with the message: `Analysis is last of its type and deletion may result in the loss of historical alert data. Please specify confirm_delete.`
    pub fn confirm_delete(self, confirm_delete: &'req str) -> Self {
        Self { 
            confirm_delete: Some(confirm_delete),
        }
    }
}

/// Query parameters for the [List instances of a code scanning alert](CodeScanning::list_alert_instances_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodeScanningListAlertInstancesParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    git_ref: Option<CodeScanningRef>
}

impl CodeScanningListAlertInstancesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
            git_ref: self.git_ref, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
            git_ref: self.git_ref, 
        }
    }

    /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    pub fn git_ref(self, git_ref: CodeScanningRef) -> Self {
        Self { 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: Some(git_ref),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodeScanningListAlertInstancesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List code scanning alerts for a repository](CodeScanning::list_alerts_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodeScanningListAlertsForRepoParams {
    /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
    tool_name: Option<CodeScanningAnalysisToolName>, 
    /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
    tool_guid: Option<CodeScanningAnalysisToolGuid>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    git_ref: Option<CodeScanningRef>, 
    /// Set to `open`, `fixed`, or `dismissed` to list code scanning alerts in a specific state.
    state: Option<CodeScanningAlertState>
}

impl CodeScanningListAlertsForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
    pub fn tool_name(self, tool_name: CodeScanningAnalysisToolName) -> Self {
        Self { 
            tool_name: Some(tool_name),
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            state: self.state, 
        }
    }

    /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
    pub fn tool_guid(self, tool_guid: CodeScanningAnalysisToolGuid) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: Some(tool_guid),
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            state: self.state, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: Some(page),
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            state: self.state, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: Some(per_page),
            git_ref: self.git_ref, 
            state: self.state, 
        }
    }

    /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    pub fn git_ref(self, git_ref: CodeScanningRef) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: Some(git_ref),
            state: self.state, 
        }
    }

    /// Set to `open`, `fixed`, or `dismissed` to list code scanning alerts in a specific state.
    pub fn state(self, state: CodeScanningAlertState) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            state: Some(state),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodeScanningListAlertsForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List code scanning analyses for a repository](CodeScanning::list_recent_analyses_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodeScanningListRecentAnalysesParams {
    /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
    tool_name: Option<CodeScanningAnalysisToolName>, 
    /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
    tool_guid: Option<CodeScanningAnalysisToolGuid>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// The Git reference for the analyses you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    git_ref: Option<CodeScanningRef>, 
    /// Filter analyses belonging to the same SARIF upload.
    sarif_id: Option<CodeScanningAnalysisSarifId>
}

impl CodeScanningListRecentAnalysesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
    pub fn tool_name(self, tool_name: CodeScanningAnalysisToolName) -> Self {
        Self { 
            tool_name: Some(tool_name),
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            sarif_id: self.sarif_id, 
        }
    }

    /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
    pub fn tool_guid(self, tool_guid: CodeScanningAnalysisToolGuid) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: Some(tool_guid),
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            sarif_id: self.sarif_id, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: Some(page),
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            sarif_id: self.sarif_id, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: Some(per_page),
            git_ref: self.git_ref, 
            sarif_id: self.sarif_id, 
        }
    }

    /// The Git reference for the analyses you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
    pub fn git_ref(self, git_ref: CodeScanningRef) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: Some(git_ref),
            sarif_id: self.sarif_id, 
        }
    }

    /// Filter analyses belonging to the same SARIF upload.
    pub fn sarif_id(self, sarif_id: CodeScanningAnalysisSarifId) -> Self {
        Self { 
            tool_name: self.tool_name, 
            tool_guid: self.tool_guid, 
            page: self.page, 
            per_page: self.per_page, 
            git_ref: self.git_ref, 
            sarif_id: Some(sarif_id),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodeScanningListRecentAnalysesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> CodeScanning<'api> {
    /// ---
    ///
    /// # Delete a code scanning analysis from a repository
    ///
    /// Deletes a specified code scanning analysis from a repository. For
    /// private repositories, you must use an access token with the `repo` scope. For public repositories,
    /// you must use an access token with `public_repo` and `repo:security_events` scopes.
    /// GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// You can delete one analysis at a time.
    /// To delete a series of analyses, start with the most recent analysis and work backwards.
    /// Conceptually, the process is similar to the undo function in a text editor.
    /// 
    /// When you list the analyses for a repository,
    /// one or more will be identified as deletable in the response:
    /// 
    /// ```nocompile
    /// "deletable": true
    /// ```
    /// 
    /// An analysis is deletable when it's the most recent in a set of analyses.
    /// Typically, a repository will have multiple sets of analyses
    /// for each enabled code scanning tool,
    /// where a set is determined by a unique combination of analysis values:
    /// 
    /// * `ref`
    /// * `tool`
    /// * `analysis_key`
    /// * `environment`
    /// 
    /// If you attempt to delete an analysis that is not the most recent in a set,
    /// you'll get a 400 response with the message:
    /// 
    /// ```nocompile
    /// Analysis specified is not deletable.
    /// ```
    /// 
    /// The response from a successful `DELETE` operation provides you with
    /// two alternative URLs for deleting the next analysis in the set
    /// (see the example default response below).
    /// Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
    /// in the set. This is a useful option if you want to preserve at least one analysis
    /// for the specified tool in your repository.
    /// Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
    /// When you delete the last analysis in a set the value of `next_analysis_url` and `confirm_delete_url`
    /// in the 200 response is `null`.
    /// 
    /// As an example of the deletion process,
    /// let's imagine that you added a workflow that configured a particular code scanning tool
    /// to analyze the code in a repository. This tool has added 15 analyses:
    /// 10 on the default branch, and another 5 on a topic branch.
    /// You therefore have two separate sets of analyses for this tool.
    /// You've now decided that you want to remove all of the analyses for the tool.
    /// To do this you must make 15 separate deletion requests.
    /// To start, you must find the deletable analysis for one of the sets,
    /// step through deleting the analyses in that set,
    /// and then repeat the process for the second set.
    /// The procedure therefore consists of a nested loop:
    /// 
    /// **Outer loop**:
    /// * List the analyses for the repository, filtered by tool.
    /// * Parse this list to find a deletable analysis. If found:
    /// 
    ///   **Inner loop**:
    ///   * Delete the identified analysis.
    ///   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
    /// 
    /// The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
    /// 
    /// [GitHub API docs for delete_analysis](https://docs.github.com/rest/reference/code-scanning#delete-a-code-scanning-analysis-from-a-repository)
    ///
    /// ---
    pub async fn delete_analysis_async(&self, owner: &str, repo: &str, analysis_id: i32, query_params: Option<impl Into<CodeScanningDeleteAnalysisParams<'api>>>) -> Result<CodeScanningAnalysisDeletion, CodeScanningDeleteAnalysisError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/analyses/{}", super::GITHUB_BASE_API_URL, owner, repo, analysis_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(CodeScanningDeleteAnalysisError::Status400(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodeScanningDeleteAnalysisError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningDeleteAnalysisError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningDeleteAnalysisError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningDeleteAnalysisError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a code scanning analysis from a repository
    ///
    /// Deletes a specified code scanning analysis from a repository. For
    /// private repositories, you must use an access token with the `repo` scope. For public repositories,
    /// you must use an access token with `public_repo` and `repo:security_events` scopes.
    /// GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// You can delete one analysis at a time.
    /// To delete a series of analyses, start with the most recent analysis and work backwards.
    /// Conceptually, the process is similar to the undo function in a text editor.
    /// 
    /// When you list the analyses for a repository,
    /// one or more will be identified as deletable in the response:
    /// 
    /// ```nocompile
    /// "deletable": true
    /// ```
    /// 
    /// An analysis is deletable when it's the most recent in a set of analyses.
    /// Typically, a repository will have multiple sets of analyses
    /// for each enabled code scanning tool,
    /// where a set is determined by a unique combination of analysis values:
    /// 
    /// * `ref`
    /// * `tool`
    /// * `analysis_key`
    /// * `environment`
    /// 
    /// If you attempt to delete an analysis that is not the most recent in a set,
    /// you'll get a 400 response with the message:
    /// 
    /// ```nocompile
    /// Analysis specified is not deletable.
    /// ```
    /// 
    /// The response from a successful `DELETE` operation provides you with
    /// two alternative URLs for deleting the next analysis in the set
    /// (see the example default response below).
    /// Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
    /// in the set. This is a useful option if you want to preserve at least one analysis
    /// for the specified tool in your repository.
    /// Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
    /// When you delete the last analysis in a set the value of `next_analysis_url` and `confirm_delete_url`
    /// in the 200 response is `null`.
    /// 
    /// As an example of the deletion process,
    /// let's imagine that you added a workflow that configured a particular code scanning tool
    /// to analyze the code in a repository. This tool has added 15 analyses:
    /// 10 on the default branch, and another 5 on a topic branch.
    /// You therefore have two separate sets of analyses for this tool.
    /// You've now decided that you want to remove all of the analyses for the tool.
    /// To do this you must make 15 separate deletion requests.
    /// To start, you must find the deletable analysis for one of the sets,
    /// step through deleting the analyses in that set,
    /// and then repeat the process for the second set.
    /// The procedure therefore consists of a nested loop:
    /// 
    /// **Outer loop**:
    /// * List the analyses for the repository, filtered by tool.
    /// * Parse this list to find a deletable analysis. If found:
    /// 
    ///   **Inner loop**:
    ///   * Delete the identified analysis.
    ///   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
    /// 
    /// The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
    /// 
    /// [GitHub API docs for delete_analysis](https://docs.github.com/rest/reference/code-scanning#delete-a-code-scanning-analysis-from-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_analysis(&self, owner: &str, repo: &str, analysis_id: i32, query_params: Option<impl Into<CodeScanningDeleteAnalysisParams<'api>>>) -> Result<CodeScanningAnalysisDeletion, CodeScanningDeleteAnalysisError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/analyses/{}", super::GITHUB_BASE_API_URL, owner, repo, analysis_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodeScanningDeleteAnalysisParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(CodeScanningDeleteAnalysisError::Status400(crate::adapters::to_json(github_response)?)),
                403 => Err(CodeScanningDeleteAnalysisError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningDeleteAnalysisError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningDeleteAnalysisError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningDeleteAnalysisError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a code scanning alert
    ///
    /// Gets a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// **Deprecation notice**:
    /// The instances field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The same information can now be retrieved via a GET request to the URL specified by `instances_url`.
    /// 
    /// [GitHub API docs for get_alert](https://docs.github.com/rest/reference/code-scanning#get-a-code-scanning-alert)
    ///
    /// ---
    pub async fn get_alert_async(&self, owner: &str, repo: &str, alert_number: AlertNumber) -> Result<CodeScanningAlert, CodeScanningGetAlertError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetAlertError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningGetAlertError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningGetAlertError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningGetAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a code scanning alert
    ///
    /// Gets a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// **Deprecation notice**:
    /// The instances field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The same information can now be retrieved via a GET request to the URL specified by `instances_url`.
    /// 
    /// [GitHub API docs for get_alert](https://docs.github.com/rest/reference/code-scanning#get-a-code-scanning-alert)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_alert(&self, owner: &str, repo: &str, alert_number: AlertNumber) -> Result<CodeScanningAlert, CodeScanningGetAlertError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetAlertError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningGetAlertError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningGetAlertError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningGetAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a code scanning analysis for a repository
    ///
    /// Gets a specified code scanning analysis for a repository.
    /// You must use an access token with the `security_events` scope to use this endpoint.
    /// GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// The default JSON response contains fields that describe the analysis.
    /// This includes the Git reference and commit SHA to which the analysis relates,
    /// the datetime of the analysis, the name of the code scanning tool,
    /// and the number of alerts.
    /// 
    /// The `rules_count` field in the default response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    /// 
    /// If you use the Accept header `application/sarif+json`,
    /// the response contains the analysis data that was uploaded.
    /// This is formatted as
    /// [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html).
    /// For an example response, see "[Custom media type for code scanning](#custom-media-type-for-code-scanning)."
    /// 
    /// **Deprecation notice**:
    /// The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    /// 
    /// [GitHub API docs for get_analysis](https://docs.github.com/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)
    ///
    /// ---
    pub async fn get_analysis_async(&self, owner: &str, repo: &str, analysis_id: i32) -> Result<String, CodeScanningGetAnalysisError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/analyses/{}", super::GITHUB_BASE_API_URL, owner, repo, analysis_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetAnalysisError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningGetAnalysisError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningGetAnalysisError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningGetAnalysisError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a code scanning analysis for a repository
    ///
    /// Gets a specified code scanning analysis for a repository.
    /// You must use an access token with the `security_events` scope to use this endpoint.
    /// GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// The default JSON response contains fields that describe the analysis.
    /// This includes the Git reference and commit SHA to which the analysis relates,
    /// the datetime of the analysis, the name of the code scanning tool,
    /// and the number of alerts.
    /// 
    /// The `rules_count` field in the default response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    /// 
    /// If you use the Accept header `application/sarif+json`,
    /// the response contains the analysis data that was uploaded.
    /// This is formatted as
    /// [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html).
    /// For an example response, see "[Custom media type for code scanning](#custom-media-type-for-code-scanning)."
    /// 
    /// **Deprecation notice**:
    /// The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    /// 
    /// [GitHub API docs for get_analysis](https://docs.github.com/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_analysis(&self, owner: &str, repo: &str, analysis_id: i32) -> Result<String, CodeScanningGetAnalysisError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/analyses/{}", super::GITHUB_BASE_API_URL, owner, repo, analysis_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetAnalysisError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningGetAnalysisError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningGetAnalysisError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningGetAnalysisError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get information about a SARIF upload
    ///
    /// Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)." You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_sarif](https://docs.github.com/rest/reference/code-scanning#list-recent-code-scanning-analyses-for-a-repository)
    ///
    /// ---
    pub async fn get_sarif_async(&self, owner: &str, repo: &str, sarif_id: &str) -> Result<CodeScanningSarifsStatus, CodeScanningGetSarifError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/sarifs/{}", super::GITHUB_BASE_API_URL, owner, repo, sarif_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetSarifError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningGetSarifError::Status404),
                503 => Err(CodeScanningGetSarifError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningGetSarifError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get information about a SARIF upload
    ///
    /// Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)." You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_sarif](https://docs.github.com/rest/reference/code-scanning#list-recent-code-scanning-analyses-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_sarif(&self, owner: &str, repo: &str, sarif_id: &str) -> Result<CodeScanningSarifsStatus, CodeScanningGetSarifError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/sarifs/{}", super::GITHUB_BASE_API_URL, owner, repo, sarif_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningGetSarifError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningGetSarifError::Status404),
                503 => Err(CodeScanningGetSarifError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningGetSarifError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List instances of a code scanning alert
    ///
    /// Lists all instances of the specified code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_alert_instances](https://docs.github.com/rest/reference/code-scanning#list-instances-of-a-code-scanning-alert)
    ///
    /// ---
    pub async fn list_alert_instances_async(&self, owner: &str, repo: &str, alert_number: AlertNumber, query_params: Option<impl Into<CodeScanningListAlertInstancesParams>>) -> Result<Vec<CodeScanningAlertInstance>, CodeScanningListAlertInstancesError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}/instances", super::GITHUB_BASE_API_URL, owner, repo, alert_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListAlertInstancesError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningListAlertInstancesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningListAlertInstancesError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningListAlertInstancesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List instances of a code scanning alert
    ///
    /// Lists all instances of the specified code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_alert_instances](https://docs.github.com/rest/reference/code-scanning#list-instances-of-a-code-scanning-alert)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_alert_instances(&self, owner: &str, repo: &str, alert_number: AlertNumber, query_params: Option<impl Into<CodeScanningListAlertInstancesParams>>) -> Result<Vec<CodeScanningAlertInstance>, CodeScanningListAlertInstancesError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}/instances", super::GITHUB_BASE_API_URL, owner, repo, alert_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodeScanningListAlertInstancesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListAlertInstancesError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningListAlertInstancesError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningListAlertInstancesError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningListAlertInstancesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List code scanning alerts for a repository
    ///
    /// Lists all open code scanning alerts for the default branch (usually `main`
    /// or `master`). You must use an access token with the `security_events` scope to use
    /// this endpoint. GitHub Apps must have the `security_events` read permission to use
    /// this endpoint.
    /// 
    /// The response includes a `most_recent_instance` object.
    /// This provides details of the most recent instance of this alert
    /// for the default branch or for the specified Git reference
    /// (if you used `ref` in the request).
    /// 
    /// [GitHub API docs for list_alerts_for_repo](https://docs.github.com/rest/reference/code-scanning#list-code-scanning-alerts-for-a-repository)
    ///
    /// ---
    pub async fn list_alerts_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodeScanningListAlertsForRepoParams>>) -> Result<Vec<CodeScanningAlertItems>, CodeScanningListAlertsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/alerts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListAlertsForRepoError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningListAlertsForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningListAlertsForRepoError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningListAlertsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List code scanning alerts for a repository
    ///
    /// Lists all open code scanning alerts for the default branch (usually `main`
    /// or `master`). You must use an access token with the `security_events` scope to use
    /// this endpoint. GitHub Apps must have the `security_events` read permission to use
    /// this endpoint.
    /// 
    /// The response includes a `most_recent_instance` object.
    /// This provides details of the most recent instance of this alert
    /// for the default branch or for the specified Git reference
    /// (if you used `ref` in the request).
    /// 
    /// [GitHub API docs for list_alerts_for_repo](https://docs.github.com/rest/reference/code-scanning#list-code-scanning-alerts-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_alerts_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodeScanningListAlertsForRepoParams>>) -> Result<Vec<CodeScanningAlertItems>, CodeScanningListAlertsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/alerts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodeScanningListAlertsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListAlertsForRepoError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningListAlertsForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningListAlertsForRepoError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningListAlertsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List code scanning analyses for a repository
    ///
    /// Lists the details of all code scanning analyses for a repository,
    /// starting with the most recent.
    /// The response is paginated and you can use the `page` and `per_page` parameters
    /// to list the analyses you're interested in.
    /// By default 30 analyses are listed per page.
    /// 
    /// The `rules_count` field in the response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    /// 
    /// You must use an access token with the `security_events` scope to use this endpoint.
    /// GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// **Deprecation notice**:
    /// The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    /// 
    /// [GitHub API docs for list_recent_analyses](https://docs.github.com/rest/reference/code-scanning#list-code-scanning-analyses-for-a-repository)
    ///
    /// ---
    pub async fn list_recent_analyses_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodeScanningListRecentAnalysesParams>>) -> Result<Vec<CodeScanningAnalysis>, CodeScanningListRecentAnalysesError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/analyses", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListRecentAnalysesError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningListRecentAnalysesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningListRecentAnalysesError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningListRecentAnalysesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List code scanning analyses for a repository
    ///
    /// Lists the details of all code scanning analyses for a repository,
    /// starting with the most recent.
    /// The response is paginated and you can use the `page` and `per_page` parameters
    /// to list the analyses you're interested in.
    /// By default 30 analyses are listed per page.
    /// 
    /// The `rules_count` field in the response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    /// 
    /// You must use an access token with the `security_events` scope to use this endpoint.
    /// GitHub Apps must have the `security_events` read permission to use this endpoint.
    /// 
    /// **Deprecation notice**:
    /// The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    /// 
    /// [GitHub API docs for list_recent_analyses](https://docs.github.com/rest/reference/code-scanning#list-code-scanning-analyses-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_recent_analyses(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodeScanningListRecentAnalysesParams>>) -> Result<Vec<CodeScanningAnalysis>, CodeScanningListRecentAnalysesError> {

        let mut request_uri = format!("{}/repos/{}/{}/code-scanning/analyses", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodeScanningListRecentAnalysesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningListRecentAnalysesError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningListRecentAnalysesError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningListRecentAnalysesError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningListRecentAnalysesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a code scanning alert
    ///
    /// Updates the status of a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// [GitHub API docs for update_alert](https://docs.github.com/rest/reference/code-scanning#update-a-code-scanning-alert)
    ///
    /// ---
    pub async fn update_alert_async(&self, owner: &str, repo: &str, alert_number: AlertNumber, body: PatchCodeScanningUpdateAlert) -> Result<CodeScanningAlert, CodeScanningUpdateAlertError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchCodeScanningUpdateAlert::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningUpdateAlertError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningUpdateAlertError::Status404(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(CodeScanningUpdateAlertError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningUpdateAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a code scanning alert
    ///
    /// Updates the status of a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// [GitHub API docs for update_alert](https://docs.github.com/rest/reference/code-scanning#update-a-code-scanning-alert)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_alert(&self, owner: &str, repo: &str, alert_number: AlertNumber, body: PatchCodeScanningUpdateAlert) -> Result<CodeScanningAlert, CodeScanningUpdateAlertError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/alerts/{}", super::GITHUB_BASE_API_URL, owner, repo, alert_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchCodeScanningUpdateAlert::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(CodeScanningUpdateAlertError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningUpdateAlertError::Status404(crate::adapters::to_json(github_response)?)),
                503 => Err(CodeScanningUpdateAlertError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningUpdateAlertError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Upload an analysis as SARIF data
    ///
    /// Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// There are two places where you can upload code scanning results.
    ///  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
    ///  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
    /// 
    /// You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
    /// 
    /// ```nocompile
    /// gzip -c analysis-data.sarif | base64 -w0
    /// ```
    /// 
    /// SARIF upload supports a maximum of 5000 results per analysis run. Any results over this limit are ignored and any SARIF uploads with more than 25,000 results are rejected. Typically, but not necessarily, a SARIF file contains a single run of a single tool. If a code scanning tool generates too many results, you should update the analysis configuration to run only the most important rules or queries.
    /// 
    /// The `202 Accepted`, response includes an `id` value.
    /// You can use this ID to check the status of the upload by using this for the `/sarifs/{sarif_id}` endpoint.
    /// For more information, see "[Get information about a SARIF upload](/rest/reference/code-scanning#get-information-about-a-sarif-upload)."
    /// 
    /// [GitHub API docs for upload_sarif](https://docs.github.com/rest/reference/code-scanning#upload-a-sarif-file)
    ///
    /// ---
    pub async fn upload_sarif_async(&self, owner: &str, repo: &str, body: PostCodeScanningUploadSarif) -> Result<CodeScanningSarifsReceipt, CodeScanningUploadSarifError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/sarifs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodeScanningUploadSarif::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(CodeScanningUploadSarifError::Status400),
                403 => Err(CodeScanningUploadSarifError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodeScanningUploadSarifError::Status404(crate::adapters::to_json_async(github_response).await?)),
                413 => Err(CodeScanningUploadSarifError::Status413),
                503 => Err(CodeScanningUploadSarifError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodeScanningUploadSarifError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Upload an analysis as SARIF data
    ///
    /// Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
    /// 
    /// There are two places where you can upload code scanning results.
    ///  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
    ///  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
    /// 
    /// You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
    /// 
    /// ```nocompile
    /// gzip -c analysis-data.sarif | base64 -w0
    /// ```
    /// 
    /// SARIF upload supports a maximum of 5000 results per analysis run. Any results over this limit are ignored and any SARIF uploads with more than 25,000 results are rejected. Typically, but not necessarily, a SARIF file contains a single run of a single tool. If a code scanning tool generates too many results, you should update the analysis configuration to run only the most important rules or queries.
    /// 
    /// The `202 Accepted`, response includes an `id` value.
    /// You can use this ID to check the status of the upload by using this for the `/sarifs/{sarif_id}` endpoint.
    /// For more information, see "[Get information about a SARIF upload](/rest/reference/code-scanning#get-information-about-a-sarif-upload)."
    /// 
    /// [GitHub API docs for upload_sarif](https://docs.github.com/rest/reference/code-scanning#upload-a-sarif-file)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn upload_sarif(&self, owner: &str, repo: &str, body: PostCodeScanningUploadSarif) -> Result<CodeScanningSarifsReceipt, CodeScanningUploadSarifError> {

        let request_uri = format!("{}/repos/{}/{}/code-scanning/sarifs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodeScanningUploadSarif::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(CodeScanningUploadSarifError::Status400),
                403 => Err(CodeScanningUploadSarifError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodeScanningUploadSarifError::Status404(crate::adapters::to_json(github_response)?)),
                413 => Err(CodeScanningUploadSarifError::Status413),
                503 => Err(CodeScanningUploadSarifError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(CodeScanningUploadSarifError::Generic { code }),
            }
        }
    }

}
