//! Method, error and parameter types for the Checks endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Checks<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Checks {
    Checks { auth }
}

/// Errors for the [Create a check run](Checks::create_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksCreateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a check suite](Checks::create_suite_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksCreateSuiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when the suite was created")]
    Status201(CheckSuite),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a check run](Checks::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a check suite](Checks::get_suite_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksGetSuiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List check run annotations](Checks::list_annotations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksListAnnotationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List check runs for a Git reference](Checks::list_for_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksListForRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List check runs in a check suite](Checks::list_for_suite_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksListForSuiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List check suites for a Git reference](Checks::list_suites_for_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksListSuitesForRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Rerequest a check suite](Checks::rerequest_suite_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksRerequestSuiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update repository preferences for check suites](Checks::set_suites_preferences_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksSetSuitesPreferencesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a check run](Checks::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ChecksUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List check run annotations](Checks::list_annotations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ChecksListAnnotationsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ChecksListAnnotationsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ChecksListAnnotationsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List check runs for a Git reference](Checks::list_for_ref_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ChecksListForRefParams<'req> {
    /// Returns check runs with the specified `name`.
    check_name: Option<&'req str>, 
    /// Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
    status: Option<&'req str>, 
    /// Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
    filter: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    
    app_id: Option<i32>
}

impl<'req> ChecksListForRefParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns check runs with the specified `name`.
    pub fn check_name(self, check_name: &'req str) -> Self {
        Self { 
            check_name: Some(check_name),
            status: self.status, 
            filter: self.filter, 
            per_page: self.per_page, 
            page: self.page, 
            app_id: self.app_id, 
        }
    }

    /// Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
    pub fn status(self, status: &'req str) -> Self {
        Self { 
            check_name: self.check_name, 
            status: Some(status),
            filter: self.filter, 
            per_page: self.per_page, 
            page: self.page, 
            app_id: self.app_id, 
        }
    }

    /// Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: Some(filter),
            per_page: self.per_page, 
            page: self.page, 
            app_id: self.app_id, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: self.filter, 
            per_page: Some(per_page),
            page: self.page, 
            app_id: self.app_id, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: self.filter, 
            per_page: self.per_page, 
            page: Some(page),
            app_id: self.app_id, 
        }
    }

    
    pub fn app_id(self, app_id: i32) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: self.filter, 
            per_page: self.per_page, 
            page: self.page, 
            app_id: Some(app_id),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ChecksListForRefParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List check runs in a check suite](Checks::list_for_suite_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ChecksListForSuiteParams<'req> {
    /// Returns check runs with the specified `name`.
    check_name: Option<&'req str>, 
    /// Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
    status: Option<&'req str>, 
    /// Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
    filter: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ChecksListForSuiteParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns check runs with the specified `name`.
    pub fn check_name(self, check_name: &'req str) -> Self {
        Self { 
            check_name: Some(check_name),
            status: self.status, 
            filter: self.filter, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
    pub fn status(self, status: &'req str) -> Self {
        Self { 
            check_name: self.check_name, 
            status: Some(status),
            filter: self.filter, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: Some(filter),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: self.filter, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            check_name: self.check_name, 
            status: self.status, 
            filter: self.filter, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ChecksListForSuiteParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List check suites for a Git reference](Checks::list_suites_for_ref_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ChecksListSuitesForRefParams<'req> {
    /// Filters check suites by GitHub App `id`.
    app_id: Option<i32>, 
    /// Returns check runs with the specified `name`.
    check_name: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ChecksListSuitesForRefParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters check suites by GitHub App `id`.
    pub fn app_id(self, app_id: i32) -> Self {
        Self { 
            app_id: Some(app_id),
            check_name: self.check_name, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Returns check runs with the specified `name`.
    pub fn check_name(self, check_name: &'req str) -> Self {
        Self { 
            app_id: self.app_id, 
            check_name: Some(check_name),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            app_id: self.app_id, 
            check_name: self.check_name, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            app_id: self.app_id, 
            check_name: self.check_name, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ChecksListSuitesForRefParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Checks<'api> {
    /// ---
    ///
    /// # Create a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
    /// 
    /// In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/checks#create-a-check-run)
    ///
    /// ---
    pub async fn create_async(&self, owner: &str, repo: &str, body: PostChecksCreate) -> Result<CheckRun, ChecksCreateError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostChecksCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
    /// 
    /// In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/checks#create-a-check-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create(&self, owner: &str, repo: &str, body: PostChecksCreate) -> Result<CheckRun, ChecksCreateError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostChecksCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/reference/checks#check-runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)". Your GitHub App must have the `checks:write` permission to create check suites.
    /// 
    /// [GitHub API docs for create_suite](https://docs.github.com/rest/reference/checks#create-a-check-suite)
    ///
    /// ---
    pub async fn create_suite_async(&self, owner: &str, repo: &str, body: PostChecksCreateSuite) -> Result<CheckSuite, ChecksCreateSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostChecksCreateSuite::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ChecksCreateSuiteError::Status201(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ChecksCreateSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/reference/checks#check-runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)". Your GitHub App must have the `checks:write` permission to create check suites.
    /// 
    /// [GitHub API docs for create_suite](https://docs.github.com/rest/reference/checks#create-a-check-suite)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_suite(&self, owner: &str, repo: &str, body: PostChecksCreateSuite) -> Result<CheckSuite, ChecksCreateSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostChecksCreateSuite::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ChecksCreateSuiteError::Status201(crate::adapters::to_json(github_response)?)),
                code => Err(ChecksCreateSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/checks#get-a-check-run)
    ///
    /// ---
    pub async fn get_async(&self, owner: &str, repo: &str, check_run_id: i32) -> Result<CheckRun, ChecksGetError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs/{}", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/checks#get-a-check-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, owner: &str, repo: &str, check_run_id: i32) -> Result<CheckRun, ChecksGetError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs/{}", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
    /// 
    /// [GitHub API docs for get_suite](https://docs.github.com/rest/reference/checks#get-a-check-suite)
    ///
    /// ---
    pub async fn get_suite_async(&self, owner: &str, repo: &str, check_suite_id: i32) -> Result<CheckSuite, ChecksGetSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/{}", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksGetSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
    /// 
    /// [GitHub API docs for get_suite](https://docs.github.com/rest/reference/checks#get-a-check-suite)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_suite(&self, owner: &str, repo: &str, check_suite_id: i32) -> Result<CheckSuite, ChecksGetSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/{}", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksGetSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check run annotations
    ///
    /// Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
    /// 
    /// [GitHub API docs for list_annotations](https://docs.github.com/rest/reference/checks#list-check-run-annotations)
    ///
    /// ---
    pub async fn list_annotations_async(&self, owner: &str, repo: &str, check_run_id: i32, query_params: Option<impl Into<ChecksListAnnotationsParams>>) -> Result<Vec<CheckAnnotation>, ChecksListAnnotationsError> {

        let mut request_uri = format!("{}/repos/{}/{}/check-runs/{}/annotations", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListAnnotationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check run annotations
    ///
    /// Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
    /// 
    /// [GitHub API docs for list_annotations](https://docs.github.com/rest/reference/checks#list-check-run-annotations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_annotations(&self, owner: &str, repo: &str, check_run_id: i32, query_params: Option<impl Into<ChecksListAnnotationsParams>>) -> Result<Vec<CheckAnnotation>, ChecksListAnnotationsError> {

        let mut request_uri = format!("{}/repos/{}/{}/check-runs/{}/annotations", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ChecksListAnnotationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListAnnotationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check runs for a Git reference
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for list_for_ref](https://docs.github.com/rest/reference/checks#list-check-runs-for-a-git-reference)
    ///
    /// ---
    pub async fn list_for_ref_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ChecksListForRefParams<'api>>>) -> Result<GetChecksListForRefResponse200, ChecksListForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check runs for a Git reference
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for list_for_ref](https://docs.github.com/rest/reference/checks#list-check-runs-for-a-git-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_ref(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ChecksListForRefParams<'api>>>) -> Result<GetChecksListForRefResponse200, ChecksListForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ChecksListForRefParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check runs in a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for list_for_suite](https://docs.github.com/rest/reference/checks#list-check-runs-in-a-check-suite)
    ///
    /// ---
    pub async fn list_for_suite_async(&self, owner: &str, repo: &str, check_suite_id: i32, query_params: Option<impl Into<ChecksListForSuiteParams<'api>>>) -> Result<GetChecksListForRefResponse200, ChecksListForSuiteError> {

        let mut request_uri = format!("{}/repos/{}/{}/check-suites/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListForSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check runs in a check suite
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
    /// 
    /// [GitHub API docs for list_for_suite](https://docs.github.com/rest/reference/checks#list-check-runs-in-a-check-suite)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_suite(&self, owner: &str, repo: &str, check_suite_id: i32, query_params: Option<impl Into<ChecksListForSuiteParams<'api>>>) -> Result<GetChecksListForRefResponse200, ChecksListForSuiteError> {

        let mut request_uri = format!("{}/repos/{}/{}/check-suites/{}/check-runs", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ChecksListForSuiteParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListForSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check suites for a Git reference
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
    /// 
    /// [GitHub API docs for list_suites_for_ref](https://docs.github.com/rest/reference/checks#list-check-suites-for-a-git-reference)
    ///
    /// ---
    pub async fn list_suites_for_ref_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ChecksListSuitesForRefParams<'api>>>) -> Result<GetChecksListSuitesForRefResponse200, ChecksListSuitesForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/check-suites", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListSuitesForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List check suites for a Git reference
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    /// 
    /// Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
    /// 
    /// [GitHub API docs for list_suites_for_ref](https://docs.github.com/rest/reference/checks#list-check-suites-for-a-git-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_suites_for_ref(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ChecksListSuitesForRefParams<'api>>>) -> Result<GetChecksListSuitesForRefResponse200, ChecksListSuitesForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/check-suites", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ChecksListSuitesForRefParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksListSuitesForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Rerequest a check suite
    ///
    /// Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
    /// 
    /// To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
    /// 
    /// [GitHub API docs for rerequest_suite](https://docs.github.com/rest/reference/checks#rerequest-a-check-suite)
    ///
    /// ---
    pub async fn rerequest_suite_async(&self, owner: &str, repo: &str, check_suite_id: i32) -> Result<HashMap<String, Value>, ChecksRerequestSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/{}/rerequest", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksRerequestSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Rerequest a check suite
    ///
    /// Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
    /// 
    /// To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
    /// 
    /// [GitHub API docs for rerequest_suite](https://docs.github.com/rest/reference/checks#rerequest-a-check-suite)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn rerequest_suite(&self, owner: &str, repo: &str, check_suite_id: i32) -> Result<HashMap<String, Value>, ChecksRerequestSuiteError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/{}/rerequest", super::GITHUB_BASE_API_URL, owner, repo, check_suite_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksRerequestSuiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update repository preferences for check suites
    ///
    /// Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/reference/checks#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
    /// 
    /// [GitHub API docs for set_suites_preferences](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)
    ///
    /// ---
    pub async fn set_suites_preferences_async(&self, owner: &str, repo: &str, body: PatchChecksSetSuitesPreferences) -> Result<CheckSuitePreference, ChecksSetSuitesPreferencesError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/preferences", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchChecksSetSuitesPreferences::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksSetSuitesPreferencesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update repository preferences for check suites
    ///
    /// Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/reference/checks#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
    /// 
    /// [GitHub API docs for set_suites_preferences](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_suites_preferences(&self, owner: &str, repo: &str, body: PatchChecksSetSuitesPreferences) -> Result<CheckSuitePreference, ChecksSetSuitesPreferencesError> {

        let request_uri = format!("{}/repos/{}/{}/check-suites/preferences", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchChecksSetSuitesPreferences::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksSetSuitesPreferencesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/checks#update-a-check-run)
    ///
    /// ---
    pub async fn update_async(&self, owner: &str, repo: &str, check_run_id: i32, body: PatchChecksUpdate) -> Result<CheckRun, ChecksUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs/{}", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchChecksUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a check run
    ///
    /// **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    /// 
    /// Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/checks#update-a-check-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, owner: &str, repo: &str, check_run_id: i32, body: PatchChecksUpdate) -> Result<CheckRun, ChecksUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/check-runs/{}", super::GITHUB_BASE_API_URL, owner, repo, check_run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchChecksUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ChecksUpdateError::Generic { code }),
            }
        }
    }

}
