//! Method, error and parameter types for the Teams endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Teams<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Teams {
    Teams { auth }
}

/// Errors for the [Add team member (Legacy)](Teams::add_member_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddMemberLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if team synchronization is set up")]
    Status404,
    #[error("Unprocessable Entity if you attempt to add an organization to a team or you attempt to add a user to a team when they are not a member of at least one other team in the same organization")]
    Status422,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team membership for a user](Teams::add_or_update_membership_for_user_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateMembershipForUserInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden if team synchronization is set up")]
    Status403,
    #[error("Unprocessable Entity if you attempt to add an organization to a team")]
    Status422,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team membership for a user (Legacy)](Teams::add_or_update_membership_for_user_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateMembershipForUserLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden if team synchronization is set up")]
    Status403,
    #[error("Unprocessable Entity if you attempt to add an organization to a team")]
    Status422,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team project permissions](Teams::add_or_update_project_permissions_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateProjectPermissionsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden if the project is not owned by the organization")]
    Status403(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team project permissions (Legacy)](Teams::add_or_update_project_permissions_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateProjectPermissionsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden if the project is not owned by the organization")]
    Status403(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team repository permissions](Teams::add_or_update_repo_permissions_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateRepoPermissionsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add or update team repository permissions (Legacy)](Teams::add_or_update_repo_permissions_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsAddOrUpdateRepoPermissionsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check team permissions for a project](Teams::check_permissions_for_project_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCheckPermissionsForProjectInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if project is not managed by this team")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check team permissions for a project (Legacy)](Teams::check_permissions_for_project_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCheckPermissionsForProjectLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if project is not managed by this team")]
    Status404,
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check team permissions for a repository](Teams::check_permissions_for_repo_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCheckPermissionsForRepoInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if team has permission for the repository. This is the response when the repository media type hasn&#x27;t been provded in the Accept header.")]
    Status204,
    #[error("Not Found if team does not have permission for the repository")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check team permissions for a repository (Legacy)](Teams::check_permissions_for_repo_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCheckPermissionsForRepoLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if repository is managed by this team")]
    Status204,
    #[error("Not Found if repository is not managed by this team")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a team](Teams::create_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a discussion comment](Teams::create_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a discussion comment (Legacy)](Teams::create_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a discussion](Teams::create_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a discussion (Legacy)](Teams::create_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update IdP group connections](Teams::create_or_update_idp_group_connections_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateOrUpdateIdpGroupConnectionsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update IdP group connections (Legacy)](Teams::create_or_update_idp_group_connections_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsCreateOrUpdateIdpGroupConnectionsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a discussion comment](Teams::delete_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a discussion comment (Legacy)](Teams::delete_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a discussion](Teams::delete_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a discussion (Legacy)](Teams::delete_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a team](Teams::delete_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a team (Legacy)](Teams::delete_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsDeleteLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a team by name](Teams::get_by_name_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetByNameError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a discussion comment](Teams::get_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a discussion comment (Legacy)](Teams::get_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a discussion](Teams::get_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a discussion (Legacy)](Teams::get_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a team (Legacy)](Teams::get_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get team member (Legacy)](Teams::get_member_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetMemberLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("if user is not a member")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get team membership for a user](Teams::get_membership_for_user_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetMembershipForUserInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("if user has no team membership")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get team membership for a user (Legacy)](Teams::get_membership_for_user_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsGetMembershipForUserLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List teams](Teams::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List child teams](Teams::list_child_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListChildInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List child teams (Legacy)](Teams::list_child_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListChildLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List discussion comments](Teams::list_discussion_comments_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListDiscussionCommentsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List discussion comments (Legacy)](Teams::list_discussion_comments_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListDiscussionCommentsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List discussions](Teams::list_discussions_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListDiscussionsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List discussions (Legacy)](Teams::list_discussions_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListDiscussionsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List teams for the authenticated user](Teams::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List IdP groups for a team (Legacy)](Teams::list_idp_groups_for_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListIdpGroupsForLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List IdP groups for an organization](Teams::list_idp_groups_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListIdpGroupsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List IdP groups for a team](Teams::list_idp_groups_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListIdpGroupsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team members](Teams::list_members_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListMembersInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team members (Legacy)](Teams::list_members_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListMembersLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pending team invitations](Teams::list_pending_invitations_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListPendingInvitationsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pending team invitations (Legacy)](Teams::list_pending_invitations_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListPendingInvitationsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team projects](Teams::list_projects_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListProjectsInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team projects (Legacy)](Teams::list_projects_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListProjectsLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team repositories](Teams::list_repos_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListReposInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List team repositories (Legacy)](Teams::list_repos_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsListReposLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove team member (Legacy)](Teams::remove_member_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveMemberLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if team synchronization is setup")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove team membership for a user](Teams::remove_membership_for_user_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveMembershipForUserInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden if team synchronization is set up")]
    Status403,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove team membership for a user (Legacy)](Teams::remove_membership_for_user_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveMembershipForUserLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("if team synchronization is set up")]
    Status403,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a project from a team](Teams::remove_project_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveProjectInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a project from a team (Legacy)](Teams::remove_project_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveProjectLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a repository from a team](Teams::remove_repo_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveRepoInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a repository from a team (Legacy)](Teams::remove_repo_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsRemoveRepoLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a discussion comment](Teams::update_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a discussion comment (Legacy)](Teams::update_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a discussion](Teams::update_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a discussion (Legacy)](Teams::update_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a team](Teams::update_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a team (Legacy)](Teams::update_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum TeamsUpdateLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status201(TeamFull),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List teams](Teams::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List child teams](Teams::list_child_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListChildInOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListChildInOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListChildInOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List child teams (Legacy)](Teams::list_child_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListChildLegacyParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListChildLegacyParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListChildLegacyParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List discussion comments](Teams::list_discussion_comments_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListDiscussionCommentsInOrgParams<'req> {
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> TeamsListDiscussionCommentsInOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListDiscussionCommentsInOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List discussion comments (Legacy)](Teams::list_discussion_comments_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListDiscussionCommentsLegacyParams<'req> {
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> TeamsListDiscussionCommentsLegacyParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListDiscussionCommentsLegacyParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List discussions](Teams::list_discussions_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListDiscussionsInOrgParams<'req> {
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Pinned discussions only filter
    pinned: Option<&'req str>
}

impl<'req> TeamsListDiscussionsInOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
            pinned: self.pinned, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
            pinned: self.pinned, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
            pinned: self.pinned, 
        }
    }

    /// Pinned discussions only filter
    pub fn pinned(self, pinned: &'req str) -> Self {
        Self { 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            pinned: Some(pinned),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListDiscussionsInOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List discussions (Legacy)](Teams::list_discussions_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListDiscussionsLegacyParams<'req> {
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> TeamsListDiscussionsLegacyParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListDiscussionsLegacyParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List teams for the authenticated user](Teams::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListForAuthenticatedUserParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List IdP groups for an organization](Teams::list_idp_groups_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListIdpGroupsForOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page token
    page: Option<u16>
}

impl TeamsListIdpGroupsForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page token
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListIdpGroupsForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team members](Teams::list_members_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListMembersInOrgParams<'req> {
    /// Filters members returned by their role in the team. Can be one of:   \\* `member` - normal members of the team.   \\* `maintainer` - team maintainers.   \\* `all` - all members of the team.
    role: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> TeamsListMembersInOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters members returned by their role in the team. Can be one of:   \\* `member` - normal members of the team.   \\* `maintainer` - team maintainers.   \\* `all` - all members of the team.
    pub fn role(self, role: &'req str) -> Self {
        Self { 
            role: Some(role),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            role: self.role, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            role: self.role, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListMembersInOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team members (Legacy)](Teams::list_members_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListMembersLegacyParams<'req> {
    /// Filters members returned by their role in the team. Can be one of:   \\* `member` - normal members of the team.   \\* `maintainer` - team maintainers.   \\* `all` - all members of the team.
    role: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> TeamsListMembersLegacyParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters members returned by their role in the team. Can be one of:   \\* `member` - normal members of the team.   \\* `maintainer` - team maintainers.   \\* `all` - all members of the team.
    pub fn role(self, role: &'req str) -> Self {
        Self { 
            role: Some(role),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            role: self.role, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            role: self.role, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListMembersLegacyParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List pending team invitations](Teams::list_pending_invitations_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListPendingInvitationsInOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListPendingInvitationsInOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListPendingInvitationsInOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List pending team invitations (Legacy)](Teams::list_pending_invitations_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListPendingInvitationsLegacyParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListPendingInvitationsLegacyParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListPendingInvitationsLegacyParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team projects](Teams::list_projects_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListProjectsInOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListProjectsInOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListProjectsInOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team projects (Legacy)](Teams::list_projects_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListProjectsLegacyParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListProjectsLegacyParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListProjectsLegacyParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team repositories](Teams::list_repos_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListReposInOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListReposInOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListReposInOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List team repositories (Legacy)](Teams::list_repos_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct TeamsListReposLegacyParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl TeamsListReposLegacyParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for TeamsListReposLegacyParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Teams<'api> {
    /// ---
    ///
    /// # Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for add_member_legacy](https://docs.github.com/rest/reference/teams#add-team-member-legacy)
    ///
    /// ---
    pub async fn add_member_legacy_async(&self, team_id: i32, username: &str) -> Result<(), TeamsAddMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsAddMemberLegacyError::Status404),
                422 => Err(TeamsAddMemberLegacyError::Status422),
                403 => Err(TeamsAddMemberLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsAddMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for add_member_legacy](https://docs.github.com/rest/reference/teams#add-team-member-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_member_legacy(&self, team_id: i32, username: &str) -> Result<(), TeamsAddMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsAddMemberLegacyError::Status404),
                422 => Err(TeamsAddMemberLegacyError::Status422),
                403 => Err(TeamsAddMemberLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsAddMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team membership for a user
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    /// 
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// [GitHub API docs for add_or_update_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user)
    ///
    /// ---
    pub async fn add_or_update_membership_for_user_in_org_async(&self, org: &str, team_slug: &str, username: &str, body: PutTeamsAddOrUpdateMembershipForUserInOrg) -> Result<TeamMembership, TeamsAddOrUpdateMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateMembershipForUserInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Status403),
                422 => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Status422),
                code => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team membership for a user
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    /// 
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// [GitHub API docs for add_or_update_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_or_update_membership_for_user_in_org(&self, org: &str, team_slug: &str, username: &str, body: PutTeamsAddOrUpdateMembershipForUserInOrg) -> Result<TeamMembership, TeamsAddOrUpdateMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateMembershipForUserInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Status403),
                422 => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Status422),
                code => Err(TeamsAddOrUpdateMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    /// 
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// [GitHub API docs for add_or_update_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user-legacy)
    ///
    /// ---
    pub async fn add_or_update_membership_for_user_legacy_async(&self, team_id: i32, username: &str, body: PutTeamsAddOrUpdateMembershipForUserLegacy) -> Result<TeamMembership, TeamsAddOrUpdateMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateMembershipForUserLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status403),
                422 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status422),
                404 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    /// 
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    /// 
    /// [GitHub API docs for add_or_update_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_or_update_membership_for_user_legacy(&self, team_id: i32, username: &str, body: PutTeamsAddOrUpdateMembershipForUserLegacy) -> Result<TeamMembership, TeamsAddOrUpdateMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateMembershipForUserLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status403),
                422 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status422),
                404 => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsAddOrUpdateMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team project permissions
    ///
    /// Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for add_or_update_project_permissions_in_org](https://docs.github.com/rest/reference/teams/#add-or-update-team-project-permissions)
    ///
    /// The `add_or_update_project_permissions_in_org_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn add_or_update_project_permissions_in_org_async(&self, org: &str, team_slug: &str, project_id: i32, body: PutTeamsAddOrUpdateProjectPermissionsInOrg) -> Result<(), TeamsAddOrUpdateProjectPermissionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateProjectPermissionsInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateProjectPermissionsInOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsAddOrUpdateProjectPermissionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team project permissions
    ///
    /// Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for add_or_update_project_permissions_in_org](https://docs.github.com/rest/reference/teams/#add-or-update-team-project-permissions)
    ///
    /// The `add_or_update_project_permissions_in_org` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn add_or_update_project_permissions_in_org(&self, org: &str, team_slug: &str, project_id: i32, body: PutTeamsAddOrUpdateProjectPermissionsInOrg) -> Result<(), TeamsAddOrUpdateProjectPermissionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateProjectPermissionsInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateProjectPermissionsInOrgError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsAddOrUpdateProjectPermissionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team project permissions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-project-permissions) endpoint.
    /// 
    /// Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
    /// 
    /// [GitHub API docs for add_or_update_project_permissions_legacy](https://docs.github.com/rest/reference/teams/#add-or-update-team-project-permissions-legacy)
    ///
    /// The `add_or_update_project_permissions_legacy_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn add_or_update_project_permissions_legacy_async(&self, team_id: i32, project_id: i32, body: PutTeamsAddOrUpdateProjectPermissionsLegacy) -> Result<(), TeamsAddOrUpdateProjectPermissionsLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateProjectPermissionsLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status415(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team project permissions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-project-permissions) endpoint.
    /// 
    /// Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
    /// 
    /// [GitHub API docs for add_or_update_project_permissions_legacy](https://docs.github.com/rest/reference/teams/#add-or-update-team-project-permissions-legacy)
    ///
    /// The `add_or_update_project_permissions_legacy` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn add_or_update_project_permissions_legacy(&self, team_id: i32, project_id: i32, body: PutTeamsAddOrUpdateProjectPermissionsLegacy) -> Result<(), TeamsAddOrUpdateProjectPermissionsLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateProjectPermissionsLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status415(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsAddOrUpdateProjectPermissionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    /// 
    /// [GitHub API docs for add_or_update_repo_permissions_in_org](https://docs.github.com/rest/reference/teams/#add-or-update-team-repository-permissions)
    ///
    /// ---
    pub async fn add_or_update_repo_permissions_in_org_async(&self, org: &str, team_slug: &str, owner: &str, repo: &str, body: PutTeamsAddOrUpdateRepoPermissionsInOrg) -> Result<(), TeamsAddOrUpdateRepoPermissionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateRepoPermissionsInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsAddOrUpdateRepoPermissionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    /// 
    /// [GitHub API docs for add_or_update_repo_permissions_in_org](https://docs.github.com/rest/reference/teams/#add-or-update-team-repository-permissions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_or_update_repo_permissions_in_org(&self, org: &str, team_slug: &str, owner: &str, repo: &str, body: PutTeamsAddOrUpdateRepoPermissionsInOrg) -> Result<(), TeamsAddOrUpdateRepoPermissionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateRepoPermissionsInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsAddOrUpdateRepoPermissionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team repository permissions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-repository-permissions)" endpoint.
    /// 
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for add_or_update_repo_permissions_legacy](https://docs.github.com/rest/reference/teams/#add-or-update-team-repository-permissions-legacy)
    ///
    /// ---
    pub async fn add_or_update_repo_permissions_legacy_async(&self, team_id: i32, owner: &str, repo: &str, body: PutTeamsAddOrUpdateRepoPermissionsLegacy) -> Result<(), TeamsAddOrUpdateRepoPermissionsLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateRepoPermissionsLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add or update team repository permissions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-repository-permissions)" endpoint.
    /// 
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for add_or_update_repo_permissions_legacy](https://docs.github.com/rest/reference/teams/#add-or-update-team-repository-permissions-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_or_update_repo_permissions_legacy(&self, team_id: i32, owner: &str, repo: &str, body: PutTeamsAddOrUpdateRepoPermissionsLegacy) -> Result<(), TeamsAddOrUpdateRepoPermissionsLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutTeamsAddOrUpdateRepoPermissionsLegacy::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsAddOrUpdateRepoPermissionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a project
    ///
    /// Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for check_permissions_for_project_in_org](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-project)
    ///
    /// The `check_permissions_for_project_in_org_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn check_permissions_for_project_in_org_async(&self, org: &str, team_slug: &str, project_id: i32) -> Result<TeamProject, TeamsCheckPermissionsForProjectInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsCheckPermissionsForProjectInOrgError::Status404),
                code => Err(TeamsCheckPermissionsForProjectInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a project
    ///
    /// Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for check_permissions_for_project_in_org](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-project)
    ///
    /// The `check_permissions_for_project_in_org` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn check_permissions_for_project_in_org(&self, org: &str, team_slug: &str, project_id: i32) -> Result<TeamProject, TeamsCheckPermissionsForProjectInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsCheckPermissionsForProjectInOrgError::Status404),
                code => Err(TeamsCheckPermissionsForProjectInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a project (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-project) endpoint.
    /// 
    /// Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
    /// 
    /// [GitHub API docs for check_permissions_for_project_legacy](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-project-legacy)
    ///
    /// The `check_permissions_for_project_legacy_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn check_permissions_for_project_legacy_async(&self, team_id: i32, project_id: i32) -> Result<TeamProject, TeamsCheckPermissionsForProjectLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsCheckPermissionsForProjectLegacyError::Status404),
                415 => Err(TeamsCheckPermissionsForProjectLegacyError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsCheckPermissionsForProjectLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a project (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-project) endpoint.
    /// 
    /// Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
    /// 
    /// [GitHub API docs for check_permissions_for_project_legacy](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-project-legacy)
    ///
    /// The `check_permissions_for_project_legacy` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn check_permissions_for_project_legacy(&self, team_id: i32, project_id: i32) -> Result<TeamProject, TeamsCheckPermissionsForProjectLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsCheckPermissionsForProjectLegacyError::Status404),
                415 => Err(TeamsCheckPermissionsForProjectLegacyError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsCheckPermissionsForProjectLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    /// 
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    /// 
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// [GitHub API docs for check_permissions_for_repo_in_org](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-repository)
    ///
    /// ---
    pub async fn check_permissions_for_repo_in_org_async(&self, org: &str, team_slug: &str, owner: &str, repo: &str) -> Result<TeamRepository, TeamsCheckPermissionsForRepoInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(TeamsCheckPermissionsForRepoInOrgError::Status204),
                404 => Err(TeamsCheckPermissionsForRepoInOrgError::Status404),
                code => Err(TeamsCheckPermissionsForRepoInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    /// 
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    /// 
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// [GitHub API docs for check_permissions_for_repo_in_org](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_permissions_for_repo_in_org(&self, org: &str, team_slug: &str, owner: &str, repo: &str) -> Result<TeamRepository, TeamsCheckPermissionsForRepoInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(TeamsCheckPermissionsForRepoInOrgError::Status204),
                404 => Err(TeamsCheckPermissionsForRepoInOrgError::Status404),
                code => Err(TeamsCheckPermissionsForRepoInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a repository (Legacy)
    ///
    /// **Note**: Repositories inherited through a parent team will also be checked.
    /// 
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-repository) endpoint.
    /// 
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for check_permissions_for_repo_legacy](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-repository-legacy)
    ///
    /// ---
    pub async fn check_permissions_for_repo_legacy_async(&self, team_id: i32, owner: &str, repo: &str) -> Result<TeamRepository, TeamsCheckPermissionsForRepoLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(TeamsCheckPermissionsForRepoLegacyError::Status204),
                404 => Err(TeamsCheckPermissionsForRepoLegacyError::Status404),
                code => Err(TeamsCheckPermissionsForRepoLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check team permissions for a repository (Legacy)
    ///
    /// **Note**: Repositories inherited through a parent team will also be checked.
    /// 
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-repository) endpoint.
    /// 
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for check_permissions_for_repo_legacy](https://docs.github.com/rest/reference/teams/#check-team-permissions-for-a-repository-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_permissions_for_repo_legacy(&self, team_id: i32, owner: &str, repo: &str) -> Result<TeamRepository, TeamsCheckPermissionsForRepoLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(TeamsCheckPermissionsForRepoLegacyError::Status204),
                404 => Err(TeamsCheckPermissionsForRepoLegacyError::Status404),
                code => Err(TeamsCheckPermissionsForRepoLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://help.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
    /// 
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/teams/#create-a-team)
    ///
    /// ---
    pub async fn create_async(&self, org: &str, body: PostTeamsCreate) -> Result<TeamFull, TeamsCreateError> {

        let request_uri = format!("{}/orgs/{}/teams", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(TeamsCreateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(TeamsCreateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://help.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
    /// 
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/teams/#create-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create(&self, org: &str, body: PostTeamsCreate) -> Result<TeamFull, TeamsCreateError> {

        let request_uri = format!("{}/orgs/{}/teams", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(TeamsCreateError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(TeamsCreateError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion comment
    ///
    /// Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    /// 
    /// [GitHub API docs for create_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#create-a-discussion-comment)
    ///
    /// The `create_discussion_comment_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn create_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, body: PostTeamsCreateDiscussionCommentInOrg) -> Result<TeamDiscussionComment, TeamsCreateDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionCommentInOrg::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion comment
    ///
    /// Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    /// 
    /// [GitHub API docs for create_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#create-a-discussion-comment)
    ///
    /// The `create_discussion_comment_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn create_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, body: PostTeamsCreateDiscussionCommentInOrg) -> Result<TeamDiscussionComment, TeamsCreateDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionCommentInOrg::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/reference/teams#create-a-discussion-comment) endpoint.
    /// 
    /// Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#create-a-discussion-comment-legacy)
    ///
    /// The `create_discussion_comment_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn create_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, body: PostTeamsCreateDiscussionCommentLegacy) -> Result<TeamDiscussionComment, TeamsCreateDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionCommentLegacy::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/reference/teams#create-a-discussion-comment) endpoint.
    /// 
    /// Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#create-a-discussion-comment-legacy)
    ///
    /// The `create_discussion_comment_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn create_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, body: PostTeamsCreateDiscussionCommentLegacy) -> Result<TeamDiscussionComment, TeamsCreateDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionCommentLegacy::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion
    ///
    /// Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    /// 
    /// [GitHub API docs for create_discussion_in_org](https://docs.github.com/rest/reference/teams#create-a-discussion)
    ///
    /// The `create_discussion_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn create_discussion_in_org_async(&self, org: &str, team_slug: &str, body: PostTeamsCreateDiscussionInOrg) -> Result<TeamDiscussion, TeamsCreateDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionInOrg::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion
    ///
    /// Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    /// 
    /// [GitHub API docs for create_discussion_in_org](https://docs.github.com/rest/reference/teams#create-a-discussion)
    ///
    /// The `create_discussion_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn create_discussion_in_org(&self, org: &str, team_slug: &str, body: PostTeamsCreateDiscussionInOrg) -> Result<TeamDiscussion, TeamsCreateDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionInOrg::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/reference/teams#create-a-discussion) endpoint.
    /// 
    /// Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_discussion_legacy](https://docs.github.com/rest/reference/teams#create-a-discussion-legacy)
    ///
    /// The `create_discussion_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn create_discussion_legacy_async(&self, team_id: i32, body: PostTeamsCreateDiscussionLegacy) -> Result<TeamDiscussion, TeamsCreateDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionLegacy::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/reference/teams#create-a-discussion) endpoint.
    /// 
    /// Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_discussion_legacy](https://docs.github.com/rest/reference/teams#create-a-discussion-legacy)
    ///
    /// The `create_discussion_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn create_discussion_legacy(&self, team_id: i32, body: PostTeamsCreateDiscussionLegacy) -> Result<TeamDiscussion, TeamsCreateDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostTeamsCreateDiscussionLegacy::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update IdP group connections
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
    /// 
    /// [GitHub API docs for create_or_update_idp_group_connections_in_org](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections)
    ///
    /// ---
    pub async fn create_or_update_idp_group_connections_in_org_async(&self, org: &str, team_slug: &str, body: PatchTeamsCreateOrUpdateIdpGroupConnectionsInOrg) -> Result<GroupMapping, TeamsCreateOrUpdateIdpGroupConnectionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsCreateOrUpdateIdpGroupConnectionsInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateOrUpdateIdpGroupConnectionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update IdP group connections
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
    /// 
    /// [GitHub API docs for create_or_update_idp_group_connections_in_org](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_idp_group_connections_in_org(&self, org: &str, team_slug: &str, body: PatchTeamsCreateOrUpdateIdpGroupConnectionsInOrg) -> Result<GroupMapping, TeamsCreateOrUpdateIdpGroupConnectionsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsCreateOrUpdateIdpGroupConnectionsInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsCreateOrUpdateIdpGroupConnectionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update IdP group connections (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
    /// 
    /// [GitHub API docs for create_or_update_idp_group_connections_legacy](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections-legacy)
    ///
    /// ---
    pub async fn create_or_update_idp_group_connections_legacy_async(&self, team_id: i32, body: PatchTeamsCreateOrUpdateIdpGroupConnectionsLegacy) -> Result<GroupMapping, TeamsCreateOrUpdateIdpGroupConnectionsLegacyError> {

        let request_uri = format!("{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsCreateOrUpdateIdpGroupConnectionsLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update IdP group connections (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
    /// 
    /// [GitHub API docs for create_or_update_idp_group_connections_legacy](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_idp_group_connections_legacy(&self, team_id: i32, body: PatchTeamsCreateOrUpdateIdpGroupConnectionsLegacy) -> Result<GroupMapping, TeamsCreateOrUpdateIdpGroupConnectionsLegacyError> {

        let request_uri = format!("{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsCreateOrUpdateIdpGroupConnectionsLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsCreateOrUpdateIdpGroupConnectionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for delete_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment)
    ///
    /// ---
    pub async fn delete_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32) -> Result<(), TeamsDeleteDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for delete_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32) -> Result<(), TeamsDeleteDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment) endpoint.
    /// 
    /// Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment-legacy)
    ///
    /// ---
    pub async fn delete_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, comment_number: i32) -> Result<(), TeamsDeleteDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment) endpoint.
    /// 
    /// Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, comment_number: i32) -> Result<(), TeamsDeleteDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion
    ///
    /// Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for delete_discussion_in_org](https://docs.github.com/rest/reference/teams#delete-a-discussion)
    ///
    /// ---
    pub async fn delete_discussion_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32) -> Result<(), TeamsDeleteDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion
    ///
    /// Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for delete_discussion_in_org](https://docs.github.com/rest/reference/teams#delete-a-discussion)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_discussion_in_org(&self, org: &str, team_slug: &str, discussion_number: i32) -> Result<(), TeamsDeleteDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/reference/teams#delete-a-discussion) endpoint.
    /// 
    /// Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_discussion_legacy](https://docs.github.com/rest/reference/teams#delete-a-discussion-legacy)
    ///
    /// ---
    pub async fn delete_discussion_legacy_async(&self, team_id: i32, discussion_number: i32) -> Result<(), TeamsDeleteDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/reference/teams#delete-a-discussion) endpoint.
    /// 
    /// Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_discussion_legacy](https://docs.github.com/rest/reference/teams#delete-a-discussion-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_discussion_legacy(&self, team_id: i32, discussion_number: i32) -> Result<(), TeamsDeleteDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    /// 
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for delete_in_org](https://docs.github.com/rest/reference/teams/#delete-a-team)
    ///
    /// ---
    pub async fn delete_in_org_async(&self, org: &str, team_slug: &str) -> Result<(), TeamsDeleteInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    /// 
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for delete_in_org](https://docs.github.com/rest/reference/teams/#delete-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_in_org(&self, org: &str, team_slug: &str) -> Result<(), TeamsDeleteInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsDeleteInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/reference/teams#delete-a-team) endpoint.
    /// 
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    /// 
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    /// 
    /// [GitHub API docs for delete_legacy](https://docs.github.com/rest/reference/teams/#delete-a-team-legacy)
    ///
    /// ---
    pub async fn delete_legacy_async(&self, team_id: i32) -> Result<(), TeamsDeleteLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsDeleteLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsDeleteLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsDeleteLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/reference/teams#delete-a-team) endpoint.
    /// 
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    /// 
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    /// 
    /// [GitHub API docs for delete_legacy](https://docs.github.com/rest/reference/teams/#delete-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_legacy(&self, team_id: i32) -> Result<(), TeamsDeleteLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsDeleteLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsDeleteLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsDeleteLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a team by name
    ///
    /// Gets a team using the team's `slug`. GitHub generates the `slug` from the team `name`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for get_by_name](https://docs.github.com/rest/reference/teams/#get-a-team-by-name)
    ///
    /// ---
    pub async fn get_by_name_async(&self, org: &str, team_slug: &str) -> Result<TeamFull, TeamsGetByNameError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetByNameError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsGetByNameError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a team by name
    ///
    /// Gets a team using the team's `slug`. GitHub generates the `slug` from the team `name`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for get_by_name](https://docs.github.com/rest/reference/teams/#get-a-team-by-name)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_by_name(&self, org: &str, team_slug: &str) -> Result<TeamFull, TeamsGetByNameError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetByNameError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsGetByNameError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion comment
    ///
    /// Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for get_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#get-a-discussion-comment)
    ///
    /// The `get_discussion_comment_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32) -> Result<TeamDiscussionComment, TeamsGetDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion comment
    ///
    /// Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for get_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#get-a-discussion-comment)
    ///
    /// The `get_discussion_comment_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32) -> Result<TeamDiscussionComment, TeamsGetDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/reference/teams#get-a-discussion-comment) endpoint.
    /// 
    /// Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#get-a-discussion-comment-legacy)
    ///
    /// The `get_discussion_comment_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, comment_number: i32) -> Result<TeamDiscussionComment, TeamsGetDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/reference/teams#get-a-discussion-comment) endpoint.
    /// 
    /// Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#get-a-discussion-comment-legacy)
    ///
    /// The `get_discussion_comment_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, comment_number: i32) -> Result<TeamDiscussionComment, TeamsGetDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion
    ///
    /// Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for get_discussion_in_org](https://docs.github.com/rest/reference/teams#get-a-discussion)
    ///
    /// The `get_discussion_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_discussion_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32) -> Result<TeamDiscussion, TeamsGetDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion
    ///
    /// Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for get_discussion_in_org](https://docs.github.com/rest/reference/teams#get-a-discussion)
    ///
    /// The `get_discussion_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_discussion_in_org(&self, org: &str, team_slug: &str, discussion_number: i32) -> Result<TeamDiscussion, TeamsGetDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/reference/teams#get-a-discussion) endpoint.
    /// 
    /// Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_discussion_legacy](https://docs.github.com/rest/reference/teams#get-a-discussion-legacy)
    ///
    /// The `get_discussion_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_discussion_legacy_async(&self, team_id: i32, discussion_number: i32) -> Result<TeamDiscussion, TeamsGetDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/reference/teams#get-a-discussion) endpoint.
    /// 
    /// Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_discussion_legacy](https://docs.github.com/rest/reference/teams#get-a-discussion-legacy)
    ///
    /// The `get_discussion_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_discussion_legacy(&self, team_id: i32, discussion_number: i32) -> Result<TeamDiscussion, TeamsGetDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsGetDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/reference/teams#get-a-team-by-name) endpoint.
    /// 
    /// [GitHub API docs for get_legacy](https://docs.github.com/rest/reference/teams/#get-a-team-legacy)
    ///
    /// ---
    pub async fn get_legacy_async(&self, team_id: i32) -> Result<TeamFull, TeamsGetLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsGetLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/reference/teams#get-a-team-by-name) endpoint.
    /// 
    /// [GitHub API docs for get_legacy](https://docs.github.com/rest/reference/teams/#get-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_legacy(&self, team_id: i32) -> Result<TeamFull, TeamsGetLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsGetLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    /// 
    /// To list members in a team, the team must be visible to the authenticated user.
    /// 
    /// [GitHub API docs for get_member_legacy](https://docs.github.com/rest/reference/teams#get-team-member-legacy)
    ///
    /// ---
    pub async fn get_member_legacy_async(&self, team_id: i32, username: &str) -> Result<(), TeamsGetMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMemberLegacyError::Status404),
                code => Err(TeamsGetMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    /// 
    /// To list members in a team, the team must be visible to the authenticated user.
    /// 
    /// [GitHub API docs for get_member_legacy](https://docs.github.com/rest/reference/teams#get-team-member-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_member_legacy(&self, team_id: i32, username: &str) -> Result<(), TeamsGetMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMemberLegacyError::Status404),
                code => Err(TeamsGetMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    /// 
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    /// 
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
    /// 
    /// [GitHub API docs for get_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user)
    ///
    /// ---
    pub async fn get_membership_for_user_in_org_async(&self, org: &str, team_slug: &str, username: &str) -> Result<TeamMembership, TeamsGetMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMembershipForUserInOrgError::Status404),
                code => Err(TeamsGetMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    /// 
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    /// 
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
    /// 
    /// [GitHub API docs for get_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_membership_for_user_in_org(&self, org: &str, team_slug: &str, username: &str) -> Result<TeamMembership, TeamsGetMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMembershipForUserInOrgError::Status404),
                code => Err(TeamsGetMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    /// 
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    /// 
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
    /// 
    /// [GitHub API docs for get_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user-legacy)
    ///
    /// ---
    pub async fn get_membership_for_user_legacy_async(&self, team_id: i32, username: &str) -> Result<TeamMembership, TeamsGetMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMembershipForUserLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsGetMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    /// 
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    /// 
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
    /// 
    /// [GitHub API docs for get_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_membership_for_user_legacy(&self, team_id: i32, username: &str) -> Result<TeamMembership, TeamsGetMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsGetMembershipForUserLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsGetMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/teams/#list-teams)
    ///
    /// ---
    pub async fn list_async(&self, org: &str, query_params: Option<impl Into<TeamsListParams>>) -> Result<Vec<Team>, TeamsListError> {

        let mut request_uri = format!("{}/orgs/{}/teams", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsListError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/teams/#list-teams)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list(&self, org: &str, query_params: Option<impl Into<TeamsListParams>>) -> Result<Vec<Team>, TeamsListError> {

        let mut request_uri = format!("{}/orgs/{}/teams", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsListError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    /// 
    /// [GitHub API docs for list_child_in_org](https://docs.github.com/rest/reference/teams/#list-child-teams)
    ///
    /// ---
    pub async fn list_child_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListChildInOrgParams>>) -> Result<Vec<Team>, TeamsListChildInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/teams", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListChildInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    /// 
    /// [GitHub API docs for list_child_in_org](https://docs.github.com/rest/reference/teams/#list-child-teams)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_child_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListChildInOrgParams>>) -> Result<Vec<Team>, TeamsListChildInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/teams", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListChildInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListChildInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List child teams (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/reference/teams#list-child-teams) endpoint.
    /// 
    /// [GitHub API docs for list_child_legacy](https://docs.github.com/rest/reference/teams/#list-child-teams-legacy)
    ///
    /// ---
    pub async fn list_child_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListChildLegacyParams>>) -> Result<Vec<Team>, TeamsListChildLegacyError> {

        let mut request_uri = format!("{}/teams/{}/teams", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListChildLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(TeamsListChildLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsListChildLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListChildLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List child teams (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/reference/teams#list-child-teams) endpoint.
    /// 
    /// [GitHub API docs for list_child_legacy](https://docs.github.com/rest/reference/teams/#list-child-teams-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_child_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListChildLegacyParams>>) -> Result<Vec<Team>, TeamsListChildLegacyError> {

        let mut request_uri = format!("{}/teams/{}/teams", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListChildLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListChildLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(TeamsListChildLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsListChildLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListChildLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussion comments
    ///
    /// List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    /// 
    /// [GitHub API docs for list_discussion_comments_in_org](https://docs.github.com/rest/reference/teams#list-discussion-comments)
    ///
    /// The `list_discussion_comments_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_discussion_comments_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, query_params: Option<impl Into<TeamsListDiscussionCommentsInOrgParams<'api>>>) -> Result<Vec<TeamDiscussionComment>, TeamsListDiscussionCommentsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionCommentsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussion comments
    ///
    /// List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    /// 
    /// [GitHub API docs for list_discussion_comments_in_org](https://docs.github.com/rest/reference/teams#list-discussion-comments)
    ///
    /// The `list_discussion_comments_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_discussion_comments_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, query_params: Option<impl Into<TeamsListDiscussionCommentsInOrgParams<'api>>>) -> Result<Vec<TeamDiscussionComment>, TeamsListDiscussionCommentsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListDiscussionCommentsInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionCommentsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussion comments (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/reference/teams#list-discussion-comments) endpoint.
    /// 
    /// List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_discussion_comments_legacy](https://docs.github.com/rest/reference/teams#list-discussion-comments-legacy)
    ///
    /// The `list_discussion_comments_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_discussion_comments_legacy_async(&self, team_id: i32, discussion_number: i32, query_params: Option<impl Into<TeamsListDiscussionCommentsLegacyParams<'api>>>) -> Result<Vec<TeamDiscussionComment>, TeamsListDiscussionCommentsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, team_id, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionCommentsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussion comments (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/reference/teams#list-discussion-comments) endpoint.
    /// 
    /// List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_discussion_comments_legacy](https://docs.github.com/rest/reference/teams#list-discussion-comments-legacy)
    ///
    /// The `list_discussion_comments_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_discussion_comments_legacy(&self, team_id: i32, discussion_number: i32, query_params: Option<impl Into<TeamsListDiscussionCommentsLegacyParams<'api>>>) -> Result<Vec<TeamDiscussionComment>, TeamsListDiscussionCommentsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/comments", super::GITHUB_BASE_API_URL, team_id, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListDiscussionCommentsLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionCommentsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussions
    ///
    /// List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    /// 
    /// [GitHub API docs for list_discussions_in_org](https://docs.github.com/rest/reference/teams#list-discussions)
    ///
    /// The `list_discussions_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_discussions_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListDiscussionsInOrgParams<'api>>>) -> Result<Vec<TeamDiscussion>, TeamsListDiscussionsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussions
    ///
    /// List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    /// 
    /// [GitHub API docs for list_discussions_in_org](https://docs.github.com/rest/reference/teams#list-discussions)
    ///
    /// The `list_discussions_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_discussions_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListDiscussionsInOrgParams<'api>>>) -> Result<Vec<TeamDiscussion>, TeamsListDiscussionsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListDiscussionsInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/reference/teams#list-discussions) endpoint.
    /// 
    /// List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_discussions_legacy](https://docs.github.com/rest/reference/teams#list-discussions-legacy)
    ///
    /// The `list_discussions_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_discussions_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListDiscussionsLegacyParams<'api>>>) -> Result<Vec<TeamDiscussion>, TeamsListDiscussionsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List discussions (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/reference/teams#list-discussions) endpoint.
    /// 
    /// List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_discussions_legacy](https://docs.github.com/rest/reference/teams#list-discussions-legacy)
    ///
    /// The `list_discussions_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_discussions_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListDiscussionsLegacyParams<'api>>>) -> Result<Vec<TeamDiscussion>, TeamsListDiscussionsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListDiscussionsLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListDiscussionsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://docs.github.com/apps/building-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/teams/#list-teams-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<TeamsListForAuthenticatedUserParams>>) -> Result<Vec<TeamFull>, TeamsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/teams", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(TeamsListForAuthenticatedUserError::Status304),
                404 => Err(TeamsListForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(TeamsListForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://docs.github.com/apps/building-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/teams/#list-teams-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<TeamsListForAuthenticatedUserParams>>) -> Result<Vec<TeamFull>, TeamsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/teams", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(TeamsListForAuthenticatedUserError::Status304),
                404 => Err(TeamsListForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(TeamsListForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups connected to a team on GitHub.
    /// 
    /// [GitHub API docs for list_idp_groups_for_legacy](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team-legacy)
    ///
    /// ---
    pub async fn list_idp_groups_for_legacy_async(&self, team_id: i32) -> Result<GroupMapping, TeamsListIdpGroupsForLegacyError> {

        let request_uri = format!("{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsListIdpGroupsForLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(TeamsListIdpGroupsForLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListIdpGroupsForLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups connected to a team on GitHub.
    /// 
    /// [GitHub API docs for list_idp_groups_for_legacy](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_idp_groups_for_legacy(&self, team_id: i32) -> Result<GroupMapping, TeamsListIdpGroupsForLegacyError> {

        let request_uri = format!("{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsListIdpGroupsForLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(TeamsListIdpGroupsForLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListIdpGroupsForLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for an organization
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups available in an organization. You can limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
    /// 
    /// The `per_page` parameter provides pagination for a list of IdP groups the authenticated user can access in an organization. For example, if the user `octocat` wants to see two groups per page in `octo-org` via cURL, it would look like this:
    /// 
    /// [GitHub API docs for list_idp_groups_for_org](https://docs.github.com/rest/reference/teams#list-idp-groups-for-an-organization)
    ///
    /// ---
    pub async fn list_idp_groups_for_org_async(&self, org: &str, query_params: Option<impl Into<TeamsListIdpGroupsForOrgParams>>) -> Result<GroupMapping, TeamsListIdpGroupsForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/team-sync/groups", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListIdpGroupsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for an organization
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups available in an organization. You can limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
    /// 
    /// The `per_page` parameter provides pagination for a list of IdP groups the authenticated user can access in an organization. For example, if the user `octocat` wants to see two groups per page in `octo-org` via cURL, it would look like this:
    /// 
    /// [GitHub API docs for list_idp_groups_for_org](https://docs.github.com/rest/reference/teams#list-idp-groups-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_idp_groups_for_org(&self, org: &str, query_params: Option<impl Into<TeamsListIdpGroupsForOrgParams>>) -> Result<GroupMapping, TeamsListIdpGroupsForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/team-sync/groups", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListIdpGroupsForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListIdpGroupsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for a team
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups connected to a team on GitHub.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
    /// 
    /// [GitHub API docs for list_idp_groups_in_org](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team)
    ///
    /// ---
    pub async fn list_idp_groups_in_org_async(&self, org: &str, team_slug: &str) -> Result<GroupMapping, TeamsListIdpGroupsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListIdpGroupsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List IdP groups for a team
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// List IdP groups connected to a team on GitHub.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
    /// 
    /// [GitHub API docs for list_idp_groups_in_org](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_idp_groups_in_org(&self, org: &str, team_slug: &str) -> Result<GroupMapping, TeamsListIdpGroupsInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/team-sync/group-mappings", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListIdpGroupsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team members
    ///
    /// Team members will include the members of child teams.
    /// 
    /// To list members in a team, the team must be visible to the authenticated user.
    /// 
    /// [GitHub API docs for list_members_in_org](https://docs.github.com/rest/reference/teams#list-team-members)
    ///
    /// ---
    pub async fn list_members_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListMembersInOrgParams<'api>>>) -> Result<Vec<SimpleUser>, TeamsListMembersInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/members", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListMembersInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team members
    ///
    /// Team members will include the members of child teams.
    /// 
    /// To list members in a team, the team must be visible to the authenticated user.
    /// 
    /// [GitHub API docs for list_members_in_org](https://docs.github.com/rest/reference/teams#list-team-members)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_members_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListMembersInOrgParams<'api>>>) -> Result<Vec<SimpleUser>, TeamsListMembersInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/members", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListMembersInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListMembersInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team members (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/reference/teams#list-team-members) endpoint.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// [GitHub API docs for list_members_legacy](https://docs.github.com/rest/reference/teams#list-team-members-legacy)
    ///
    /// ---
    pub async fn list_members_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListMembersLegacyParams<'api>>>) -> Result<Vec<SimpleUser>, TeamsListMembersLegacyError> {

        let mut request_uri = format!("{}/teams/{}/members", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListMembersLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListMembersLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team members (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/reference/teams#list-team-members) endpoint.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// [GitHub API docs for list_members_legacy](https://docs.github.com/rest/reference/teams#list-team-members-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_members_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListMembersLegacyParams<'api>>>) -> Result<Vec<SimpleUser>, TeamsListMembersLegacyError> {

        let mut request_uri = format!("{}/teams/{}/members", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListMembersLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListMembersLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListMembersLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    /// 
    /// [GitHub API docs for list_pending_invitations_in_org](https://docs.github.com/rest/reference/teams#list-pending-team-invitations)
    ///
    /// ---
    pub async fn list_pending_invitations_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListPendingInvitationsInOrgParams>>) -> Result<Vec<OrganizationInvitation>, TeamsListPendingInvitationsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/invitations", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListPendingInvitationsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    /// 
    /// [GitHub API docs for list_pending_invitations_in_org](https://docs.github.com/rest/reference/teams#list-pending-team-invitations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_pending_invitations_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListPendingInvitationsInOrgParams>>) -> Result<Vec<OrganizationInvitation>, TeamsListPendingInvitationsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/invitations", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListPendingInvitationsInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListPendingInvitationsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending team invitations (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/reference/teams#list-pending-team-invitations) endpoint.
    /// 
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// [GitHub API docs for list_pending_invitations_legacy](https://docs.github.com/rest/reference/teams#list-pending-team-invitations-legacy)
    ///
    /// ---
    pub async fn list_pending_invitations_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListPendingInvitationsLegacyParams>>) -> Result<Vec<OrganizationInvitation>, TeamsListPendingInvitationsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/invitations", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListPendingInvitationsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending team invitations (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/reference/teams#list-pending-team-invitations) endpoint.
    /// 
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// [GitHub API docs for list_pending_invitations_legacy](https://docs.github.com/rest/reference/teams#list-pending-team-invitations-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_pending_invitations_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListPendingInvitationsLegacyParams>>) -> Result<Vec<OrganizationInvitation>, TeamsListPendingInvitationsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/invitations", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListPendingInvitationsLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListPendingInvitationsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team projects
    ///
    /// Lists the organization projects for a team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
    /// 
    /// [GitHub API docs for list_projects_in_org](https://docs.github.com/rest/reference/teams/#list-team-projects)
    ///
    /// The `list_projects_in_org_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn list_projects_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListProjectsInOrgParams>>) -> Result<Vec<TeamProject>, TeamsListProjectsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/projects", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListProjectsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team projects
    ///
    /// Lists the organization projects for a team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
    /// 
    /// [GitHub API docs for list_projects_in_org](https://docs.github.com/rest/reference/teams/#list-team-projects)
    ///
    /// The `list_projects_in_org` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn list_projects_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListProjectsInOrgParams>>) -> Result<Vec<TeamProject>, TeamsListProjectsInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/projects", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListProjectsInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListProjectsInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team projects (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/rest/reference/teams#list-team-projects) endpoint.
    /// 
    /// Lists the organization projects for a team.
    /// 
    /// [GitHub API docs for list_projects_legacy](https://docs.github.com/rest/reference/teams/#list-team-projects-legacy)
    ///
    /// The `list_projects_legacy_async` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(feature = "inertia")]
    pub async fn list_projects_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListProjectsLegacyParams>>) -> Result<Vec<TeamProject>, TeamsListProjectsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/projects", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListProjectsLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(TeamsListProjectsLegacyError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListProjectsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team projects (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/rest/reference/teams#list-team-projects) endpoint.
    /// 
    /// Lists the organization projects for a team.
    /// 
    /// [GitHub API docs for list_projects_legacy](https://docs.github.com/rest/reference/teams/#list-team-projects-legacy)
    ///
    /// The `list_projects_legacy` endpoint is enabled with the `inertia` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "inertia")]
    pub fn list_projects_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListProjectsLegacyParams>>) -> Result<Vec<TeamProject>, TeamsListProjectsLegacyError> {

        let mut request_uri = format!("{}/teams/{}/projects", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListProjectsLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.inertia-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListProjectsLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(TeamsListProjectsLegacyError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListProjectsLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    /// 
    /// [GitHub API docs for list_repos_in_org](https://docs.github.com/rest/reference/teams/#list-team-repositories)
    ///
    /// ---
    pub async fn list_repos_in_org_async(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListReposInOrgParams>>) -> Result<Vec<MinimalRepository>, TeamsListReposInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/repos", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListReposInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    /// 
    /// [GitHub API docs for list_repos_in_org](https://docs.github.com/rest/reference/teams/#list-team-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_in_org(&self, org: &str, team_slug: &str, query_params: Option<impl Into<TeamsListReposInOrgParams>>) -> Result<Vec<MinimalRepository>, TeamsListReposInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/repos", super::GITHUB_BASE_API_URL, org, team_slug);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListReposInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsListReposInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team repositories (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/reference/teams#list-team-repositories) endpoint.
    /// 
    /// [GitHub API docs for list_repos_legacy](https://docs.github.com/rest/reference/teams/#list-team-repositories-legacy)
    ///
    /// ---
    pub async fn list_repos_legacy_async(&self, team_id: i32, query_params: Option<impl Into<TeamsListReposLegacyParams>>) -> Result<Vec<MinimalRepository>, TeamsListReposLegacyError> {

        let mut request_uri = format!("{}/teams/{}/repos", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListReposLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsListReposLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List team repositories (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/reference/teams#list-team-repositories) endpoint.
    /// 
    /// [GitHub API docs for list_repos_legacy](https://docs.github.com/rest/reference/teams/#list-team-repositories-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_legacy(&self, team_id: i32, query_params: Option<impl Into<TeamsListReposLegacyParams>>) -> Result<Vec<MinimalRepository>, TeamsListReposLegacyError> {

        let mut request_uri = format!("{}/teams/{}/repos", super::GITHUB_BASE_API_URL, team_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: TeamsListReposLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsListReposLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsListReposLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// [GitHub API docs for remove_member_legacy](https://docs.github.com/rest/reference/teams#remove-team-member-legacy)
    ///
    /// ---
    pub async fn remove_member_legacy_async(&self, team_id: i32, username: &str) -> Result<(), TeamsRemoveMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsRemoveMemberLegacyError::Status404),
                code => Err(TeamsRemoveMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is deprecated.
    /// 
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// [GitHub API docs for remove_member_legacy](https://docs.github.com/rest/reference/teams#remove-team-member-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_member_legacy(&self, team_id: i32, username: &str) -> Result<(), TeamsRemoveMemberLegacyError> {

        let request_uri = format!("{}/teams/{}/members/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsRemoveMemberLegacyError::Status404),
                code => Err(TeamsRemoveMemberLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team membership for a user
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// [GitHub API docs for remove_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user)
    ///
    /// ---
    pub async fn remove_membership_for_user_in_org_async(&self, org: &str, team_slug: &str, username: &str) -> Result<(), TeamsRemoveMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsRemoveMembershipForUserInOrgError::Status403),
                code => Err(TeamsRemoveMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team membership for a user
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    /// 
    /// [GitHub API docs for remove_membership_for_user_in_org](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_membership_for_user_in_org(&self, org: &str, team_slug: &str, username: &str) -> Result<(), TeamsRemoveMembershipForUserInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, team_slug, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsRemoveMembershipForUserInOrgError::Status403),
                code => Err(TeamsRemoveMembershipForUserInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// [GitHub API docs for remove_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user-legacy)
    ///
    /// ---
    pub async fn remove_membership_for_user_legacy_async(&self, team_id: i32, username: &str) -> Result<(), TeamsRemoveMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsRemoveMembershipForUserLegacyError::Status403),
                code => Err(TeamsRemoveMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team membership for a user (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint.
    /// 
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    /// 
    /// **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    /// 
    /// [GitHub API docs for remove_membership_for_user_legacy](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_membership_for_user_legacy(&self, team_id: i32, username: &str) -> Result<(), TeamsRemoveMembershipForUserLegacyError> {

        let request_uri = format!("{}/teams/{}/memberships/{}", super::GITHUB_BASE_API_URL, team_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(TeamsRemoveMembershipForUserLegacyError::Status403),
                code => Err(TeamsRemoveMembershipForUserLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a project from a team
    ///
    /// Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for remove_project_in_org](https://docs.github.com/rest/reference/teams/#remove-a-project-from-a-team)
    ///
    /// ---
    pub async fn remove_project_in_org_async(&self, org: &str, team_slug: &str, project_id: i32) -> Result<(), TeamsRemoveProjectInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveProjectInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a project from a team
    ///
    /// Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
    /// 
    /// [GitHub API docs for remove_project_in_org](https://docs.github.com/rest/reference/teams/#remove-a-project-from-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_project_in_org(&self, org: &str, team_slug: &str, project_id: i32) -> Result<(), TeamsRemoveProjectInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, org, team_slug, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveProjectInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a project from a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/rest/reference/teams#remove-a-project-from-a-team) endpoint.
    /// 
    /// Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
    /// 
    /// [GitHub API docs for remove_project_legacy](https://docs.github.com/rest/reference/teams/#remove-a-project-from-a-team-legacy)
    ///
    /// ---
    pub async fn remove_project_legacy_async(&self, team_id: i32, project_id: i32) -> Result<(), TeamsRemoveProjectLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsRemoveProjectLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(TeamsRemoveProjectLegacyError::Status415(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsRemoveProjectLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsRemoveProjectLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a project from a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/rest/reference/teams#remove-a-project-from-a-team) endpoint.
    /// 
    /// Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
    /// 
    /// [GitHub API docs for remove_project_legacy](https://docs.github.com/rest/reference/teams/#remove-a-project-from-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_project_legacy(&self, team_id: i32, project_id: i32) -> Result<(), TeamsRemoveProjectLegacyError> {

        let request_uri = format!("{}/teams/{}/projects/{}", super::GITHUB_BASE_API_URL, team_id, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(TeamsRemoveProjectLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(TeamsRemoveProjectLegacyError::Status415(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsRemoveProjectLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsRemoveProjectLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// [GitHub API docs for remove_repo_in_org](https://docs.github.com/rest/reference/teams/#remove-a-repository-from-a-team)
    ///
    /// ---
    pub async fn remove_repo_in_org_async(&self, org: &str, team_slug: &str, owner: &str, repo: &str) -> Result<(), TeamsRemoveRepoInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveRepoInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    /// 
    /// [GitHub API docs for remove_repo_in_org](https://docs.github.com/rest/reference/teams/#remove-a-repository-from-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_repo_in_org(&self, org: &str, team_slug: &str, owner: &str, repo: &str) -> Result<(), TeamsRemoveRepoInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, org, team_slug, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveRepoInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/reference/teams#remove-a-repository-from-a-team) endpoint.
    /// 
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    /// 
    /// [GitHub API docs for remove_repo_legacy](https://docs.github.com/rest/reference/teams/#remove-a-repository-from-a-team-legacy)
    ///
    /// ---
    pub async fn remove_repo_legacy_async(&self, team_id: i32, owner: &str, repo: &str) -> Result<(), TeamsRemoveRepoLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveRepoLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/reference/teams#remove-a-repository-from-a-team) endpoint.
    /// 
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    /// 
    /// [GitHub API docs for remove_repo_legacy](https://docs.github.com/rest/reference/teams/#remove-a-repository-from-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_repo_legacy(&self, team_id: i32, owner: &str, repo: &str) -> Result<(), TeamsRemoveRepoLegacyError> {

        let request_uri = format!("{}/teams/{}/repos/{}/{}", super::GITHUB_BASE_API_URL, team_id, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsRemoveRepoLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion comment
    ///
    /// Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for update_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#update-a-discussion-comment)
    ///
    /// The `update_discussion_comment_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn update_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, body: PatchTeamsUpdateDiscussionCommentInOrg) -> Result<TeamDiscussionComment, TeamsUpdateDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionCommentInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion comment
    ///
    /// Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// 
    /// [GitHub API docs for update_discussion_comment_in_org](https://docs.github.com/rest/reference/teams#update-a-discussion-comment)
    ///
    /// The `update_discussion_comment_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn update_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, body: PatchTeamsUpdateDiscussionCommentInOrg) -> Result<TeamDiscussionComment, TeamsUpdateDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionCommentInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/reference/teams#update-a-discussion-comment) endpoint.
    /// 
    /// Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for update_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#update-a-discussion-comment-legacy)
    ///
    /// The `update_discussion_comment_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn update_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, comment_number: i32, body: PatchTeamsUpdateDiscussionCommentLegacy) -> Result<TeamDiscussionComment, TeamsUpdateDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionCommentLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/reference/teams#update-a-discussion-comment) endpoint.
    /// 
    /// Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for update_discussion_comment_legacy](https://docs.github.com/rest/reference/teams#update-a-discussion-comment-legacy)
    ///
    /// The `update_discussion_comment_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn update_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, comment_number: i32, body: PatchTeamsUpdateDiscussionCommentLegacy) -> Result<TeamDiscussionComment, TeamsUpdateDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionCommentLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for update_discussion_in_org](https://docs.github.com/rest/reference/teams#update-a-discussion)
    ///
    /// The `update_discussion_in_org_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn update_discussion_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, body: PatchTeamsUpdateDiscussionInOrg) -> Result<TeamDiscussion, TeamsUpdateDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    /// 
    /// [GitHub API docs for update_discussion_in_org](https://docs.github.com/rest/reference/teams#update-a-discussion)
    ///
    /// The `update_discussion_in_org` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn update_discussion_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, body: PatchTeamsUpdateDiscussionInOrg) -> Result<TeamDiscussion, TeamsUpdateDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/reference/teams#update-a-discussion) endpoint.
    /// 
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for update_discussion_legacy](https://docs.github.com/rest/reference/teams#update-a-discussion-legacy)
    ///
    /// The `update_discussion_legacy_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "squirrel-girl")]
    pub async fn update_discussion_legacy_async(&self, team_id: i32, discussion_number: i32, body: PatchTeamsUpdateDiscussionLegacy) -> Result<TeamDiscussion, TeamsUpdateDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/reference/teams#update-a-discussion) endpoint.
    /// 
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for update_discussion_legacy](https://docs.github.com/rest/reference/teams#update-a-discussion-legacy)
    ///
    /// The `update_discussion_legacy` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "squirrel-girl")]
    pub fn update_discussion_legacy(&self, team_id: i32, discussion_number: i32, body: PatchTeamsUpdateDiscussionLegacy) -> Result<TeamDiscussion, TeamsUpdateDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateDiscussionLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for update_in_org](https://docs.github.com/rest/reference/teams/#update-a-team)
    ///
    /// ---
    pub async fn update_in_org_async(&self, org: &str, team_slug: &str, body: PatchTeamsUpdateInOrg) -> Result<TeamFull, TeamsUpdateInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    /// 
    /// [GitHub API docs for update_in_org](https://docs.github.com/rest/reference/teams/#update-a-team)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_in_org(&self, org: &str, team_slug: &str, body: PatchTeamsUpdateInOrg) -> Result<TeamFull, TeamsUpdateInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}", super::GITHUB_BASE_API_URL, org, team_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateInOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(TeamsUpdateInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/reference/teams#update-a-team) endpoint.
    /// 
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    /// 
    /// **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
    /// 
    /// [GitHub API docs for update_legacy](https://docs.github.com/rest/reference/teams/#update-a-team-legacy)
    ///
    /// ---
    pub async fn update_legacy_async(&self, team_id: i32, body: PatchTeamsUpdateLegacy) -> Result<TeamFull, TeamsUpdateLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(TeamsUpdateLegacyError::Status201(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(TeamsUpdateLegacyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(TeamsUpdateLegacyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(TeamsUpdateLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(TeamsUpdateLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a team (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/reference/teams#update-a-team) endpoint.
    /// 
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    /// 
    /// **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
    /// 
    /// [GitHub API docs for update_legacy](https://docs.github.com/rest/reference/teams/#update-a-team-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_legacy(&self, team_id: i32, body: PatchTeamsUpdateLegacy) -> Result<TeamFull, TeamsUpdateLegacyError> {

        let request_uri = format!("{}/teams/{}", super::GITHUB_BASE_API_URL, team_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchTeamsUpdateLegacy::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(TeamsUpdateLegacyError::Status201(crate::adapters::to_json(github_response)?)),
                404 => Err(TeamsUpdateLegacyError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(TeamsUpdateLegacyError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(TeamsUpdateLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(TeamsUpdateLegacyError::Generic { code }),
            }
        }
    }

}
