//! Method, error and parameter types for the Pulls endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Pulls<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Pulls {
    Pulls { auth }
}

/// Errors for the [Check if a pull request has been merged](Pulls::check_if_merged_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsCheckIfMergedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if pull request has not been merged")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a pull request](Pulls::create_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsCreateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a reply for a review comment](Pulls::create_reply_for_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsCreateReplyForReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a review for a pull request](Pulls::create_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsCreateReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a review comment for a pull request](Pulls::create_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsCreateReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a pending review for a pull request](Pulls::delete_pending_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsDeletePendingReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a review comment for a pull request](Pulls::delete_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsDeleteReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Dismiss a review for a pull request](Pulls::dismiss_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsDismissReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a pull request](Pulls::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a review for a pull request](Pulls::get_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsGetReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a review comment for a pull request](Pulls::get_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsGetReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pull requests](Pulls::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List comments for a pull request review](Pulls::list_comments_for_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListCommentsForReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List commits on a pull request](Pulls::list_commits_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListCommitsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pull requests files](Pulls::list_files_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListFilesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List requested reviewers for a pull request](Pulls::list_requested_reviewers_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListRequestedReviewersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List review comments on a pull request](Pulls::list_review_comments_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListReviewCommentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List review comments in a repository](Pulls::list_review_comments_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListReviewCommentsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reviews for a pull request](Pulls::list_reviews_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsListReviewsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Merge a pull request](Pulls::merge_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsMergeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Method Not Allowed if merge cannot be performed")]
    Status405(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Conflict if sha was provided and pull request head did not match")]
    Status409(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove requested reviewers from a pull request](Pulls::remove_requested_reviewers_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsRemoveRequestedReviewersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Request reviewers for a pull request](Pulls::request_reviewers_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsRequestReviewersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Unprocessable Entity if user is not a collaborator")]
    Status422,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Submit a review for a pull request](Pulls::submit_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsSubmitReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a pull request](Pulls::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a pull request branch](Pulls::update_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsUpdateBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a review for a pull request](Pulls::update_review_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsUpdateReviewError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a review comment for a pull request](Pulls::update_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PullsUpdateReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List pull requests](Pulls::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListParams<'req> {
    /// Either `open`, `closed`, or `all` to filter by state.
    state: Option<&'req str>, 
    /// Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
    head: Option<&'req str>, 
    /// Filter pulls by base branch name. Example: `gh-pages`.
    base: Option<&'req str>, 
    /// What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
    sort: Option<&'req str>, 
    /// The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
    direction: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> PullsListParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Either `open`, `closed`, or `all` to filter by state.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            head: self.head, 
            base: self.base, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
    pub fn head(self, head: &'req str) -> Self {
        Self { 
            state: self.state, 
            head: Some(head),
            base: self.base, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Filter pulls by base branch name. Example: `gh-pages`.
    pub fn base(self, base: &'req str) -> Self {
        Self { 
            state: self.state, 
            head: self.head, 
            base: Some(base),
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            state: self.state, 
            head: self.head, 
            base: self.base, 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            state: self.state, 
            head: self.head, 
            base: self.base, 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            head: self.head, 
            base: self.base, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            head: self.head, 
            base: self.base, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List comments for a pull request review](Pulls::list_comments_for_review_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListCommentsForReviewParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl PullsListCommentsForReviewParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListCommentsForReviewParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List commits on a pull request](Pulls::list_commits_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListCommitsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl PullsListCommitsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListCommitsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List pull requests files](Pulls::list_files_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListFilesParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl PullsListFilesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListFilesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List requested reviewers for a pull request](Pulls::list_requested_reviewers_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListRequestedReviewersParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl PullsListRequestedReviewersParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListRequestedReviewersParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List review comments on a pull request](Pulls::list_review_comments_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListReviewCommentsParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// Can be either `asc` or `desc`. Ignored without `sort` parameter.
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> PullsListReviewCommentsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be either `asc` or `desc`. Ignored without `sort` parameter.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListReviewCommentsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List review comments in a repository](Pulls::list_review_comments_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListReviewCommentsForRepoParams<'req> {
    
    sort: Option<&'req str>, 
    /// Can be either `asc` or `desc`. Ignored without `sort` parameter.
    direction: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<&'req str>, 
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> PullsListReviewCommentsForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be either `asc` or `desc`. Ignored without `sort` parameter.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            since: self.since, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: Some(since),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            since: self.since, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListReviewCommentsForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reviews for a pull request](Pulls::list_reviews_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PullsListReviewsParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl PullsListReviewsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PullsListReviewsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Pulls<'api> {
    /// ---
    ///
    /// # Check if a pull request has been merged
    /// 
    /// [GitHub API docs for check_if_merged](https://docs.github.com/rest/reference/pulls/#check-if-a-pull-request-has-been-merged)
    ///
    /// ---
    pub async fn check_if_merged_async(&self, owner: &str, repo: &str, pull_number: i32) -> Result<(), PullsCheckIfMergedError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/merge", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsCheckIfMergedError::Status404),
                code => Err(PullsCheckIfMergedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a pull request has been merged
    /// 
    /// [GitHub API docs for check_if_merged](https://docs.github.com/rest/reference/pulls/#check-if-a-pull-request-has-been-merged)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_if_merged(&self, owner: &str, repo: &str, pull_number: i32) -> Result<(), PullsCheckIfMergedError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/merge", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsCheckIfMergedError::Status404),
                code => Err(PullsCheckIfMergedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    /// 
    /// You can create a new pull request.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request)
    ///
    /// ---
    pub async fn create_async(&self, owner: &str, repo: &str, body: PostPullsCreate) -> Result<PullRequest, PullsCreateError> {

        let request_uri = format!("{}/repos/{}/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(PullsCreateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(PullsCreateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    /// 
    /// You can create a new pull request.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create(&self, owner: &str, repo: &str, body: PostPullsCreate) -> Result<PullRequest, PullsCreateError> {

        let request_uri = format!("{}/repos/{}/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(PullsCreateError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(PullsCreateError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(PullsCreateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a reply for a review comment
    ///
    /// Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_reply_for_review_comment](https://docs.github.com/rest/reference/pulls#create-a-reply-for-a-review-comment)
    ///
    /// ---
    pub async fn create_reply_for_review_comment_async(&self, owner: &str, repo: &str, pull_number: i32, comment_id: i32, body: PostPullsCreateReplyForReviewComment) -> Result<PullRequestReviewComment, PullsCreateReplyForReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/comments/{}/replies", super::GITHUB_BASE_API_URL, owner, repo, pull_number, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReplyForReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsCreateReplyForReviewCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsCreateReplyForReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a reply for a review comment
    ///
    /// Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_reply_for_review_comment](https://docs.github.com/rest/reference/pulls#create-a-reply-for-a-review-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_reply_for_review_comment(&self, owner: &str, repo: &str, pull_number: i32, comment_id: i32, body: PostPullsCreateReplyForReviewComment) -> Result<PullRequestReviewComment, PullsCreateReplyForReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/comments/{}/replies", super::GITHUB_BASE_API_URL, owner, repo, pull_number, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReplyForReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsCreateReplyForReviewCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsCreateReplyForReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a review for a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// Pull request reviews created in the `PENDING` state do not include the `submitted_at` property in the response.
    /// 
    /// **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://docs.github.com/rest/overview/media-types#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) endpoint.
    /// 
    /// The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    /// 
    /// [GitHub API docs for create_review](https://docs.github.com/rest/reference/pulls#create-a-review-for-a-pull-request)
    ///
    /// ---
    pub async fn create_review_async(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsCreateReview) -> Result<PullRequestReview, PullsCreateReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReview::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsCreateReviewError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsCreateReviewError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsCreateReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a review for a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// Pull request reviews created in the `PENDING` state do not include the `submitted_at` property in the response.
    /// 
    /// **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://docs.github.com/rest/overview/media-types#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) endpoint.
    /// 
    /// The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    /// 
    /// [GitHub API docs for create_review](https://docs.github.com/rest/reference/pulls#create-a-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_review(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsCreateReview) -> Result<PullRequestReview, PullsCreateReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReview::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsCreateReviewError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsCreateReviewError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(PullsCreateReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a review comment for a pull request
    ///
    /// 
    /// Creates a review comment in the pull request diff. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)." We recommend creating a review comment using `line`, `side`, and optionally `start_line` and `start_side` if your comment applies to more than one line in the pull request diff.
    /// 
    /// You can still create a review comment using the `position` parameter. When you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required. For more information, see the [`comfort-fade` preview notice](https://docs.github.com/rest/reference/pulls#create-a-review-comment-for-a-pull-request-preview-notices).
    /// 
    /// **Note:** The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_review_comment](https://docs.github.com/rest/reference/pulls#create-a-review-comment-for-a-pull-request)
    ///
    /// The `create_review_comment_async` endpoint is enabled with the `comfort-fade` cargo feature.
    ///
    /// ---
    #[cfg(feature = "comfort-fade")]
    pub async fn create_review_comment_async(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsCreateReviewComment) -> Result<PullRequestReviewComment, PullsCreateReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsCreateReviewCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsCreateReviewCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsCreateReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a review comment for a pull request
    ///
    /// 
    /// Creates a review comment in the pull request diff. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)." We recommend creating a review comment using `line`, `side`, and optionally `start_line` and `start_side` if your comment applies to more than one line in the pull request diff.
    /// 
    /// You can still create a review comment using the `position` parameter. When you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required. For more information, see the [`comfort-fade` preview notice](https://docs.github.com/rest/reference/pulls#create-a-review-comment-for-a-pull-request-preview-notices).
    /// 
    /// **Note:** The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_review_comment](https://docs.github.com/rest/reference/pulls#create-a-review-comment-for-a-pull-request)
    ///
    /// The `create_review_comment` endpoint is enabled with the `comfort-fade` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "comfort-fade")]
    pub fn create_review_comment(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsCreateReviewComment) -> Result<PullRequestReviewComment, PullsCreateReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsCreateReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsCreateReviewCommentError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsCreateReviewCommentError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(PullsCreateReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a pending review for a pull request
    /// 
    /// [GitHub API docs for delete_pending_review](https://docs.github.com/rest/reference/pulls#delete-a-pending-review-for-a-pull-request)
    ///
    /// ---
    pub async fn delete_pending_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32) -> Result<PullRequestReview, PullsDeletePendingReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsDeletePendingReviewError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(PullsDeletePendingReviewError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsDeletePendingReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a pending review for a pull request
    /// 
    /// [GitHub API docs for delete_pending_review](https://docs.github.com/rest/reference/pulls#delete-a-pending-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_pending_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32) -> Result<PullRequestReview, PullsDeletePendingReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsDeletePendingReviewError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(PullsDeletePendingReviewError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsDeletePendingReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a review comment for a pull request
    ///
    /// Deletes a review comment.
    /// 
    /// [GitHub API docs for delete_review_comment](https://docs.github.com/rest/reference/pulls#delete-a-review-comment-for-a-pull-request)
    ///
    /// ---
    pub async fn delete_review_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), PullsDeleteReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsDeleteReviewCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsDeleteReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a review comment for a pull request
    ///
    /// Deletes a review comment.
    /// 
    /// [GitHub API docs for delete_review_comment](https://docs.github.com/rest/reference/pulls#delete-a-review-comment-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_review_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), PullsDeleteReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsDeleteReviewCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsDeleteReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Dismiss a review for a pull request
    ///
    /// **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/reference/repos#branches), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
    /// 
    /// [GitHub API docs for dismiss_review](https://docs.github.com/rest/reference/pulls#dismiss-a-review-for-a-pull-request)
    ///
    /// ---
    pub async fn dismiss_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PutPullsDismissReview) -> Result<PullRequestReview, PullsDismissReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/dismissals", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsDismissReview::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsDismissReviewError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(PullsDismissReviewError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsDismissReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Dismiss a review for a pull request
    ///
    /// **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/reference/repos#branches), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
    /// 
    /// [GitHub API docs for dismiss_review](https://docs.github.com/rest/reference/pulls#dismiss-a-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn dismiss_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PutPullsDismissReview) -> Result<PullRequestReview, PullsDismissReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/dismissals", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsDismissReview::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsDismissReviewError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(PullsDismissReviewError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(PullsDismissReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists details of a pull request by providing its number.
    /// 
    /// When you get, [create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/reference/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
    /// 
    /// The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
    /// 
    /// *   If merged as a [merge commit](https://help.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
    /// *   If merged via a [squash](https://help.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
    /// *   If [rebased](https://help.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
    /// 
    /// Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/pulls/#get-a-pull-request)
    ///
    /// ---
    pub async fn get_async(&self, owner: &str, repo: &str, pull_number: i32) -> Result<PullRequest, PullsGetError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(PullsGetError::Status304),
                500 => Err(PullsGetError::Status500(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(PullsGetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists details of a pull request by providing its number.
    /// 
    /// When you get, [create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/reference/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    /// 
    /// The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
    /// 
    /// The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
    /// 
    /// *   If merged as a [merge commit](https://help.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
    /// *   If merged via a [squash](https://help.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
    /// *   If [rebased](https://help.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
    /// 
    /// Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/pulls/#get-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, owner: &str, repo: &str, pull_number: i32) -> Result<PullRequest, PullsGetError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(PullsGetError::Status304),
                500 => Err(PullsGetError::Status500(crate::adapters::to_json(github_response)?)),
                404 => Err(PullsGetError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a review for a pull request
    /// 
    /// [GitHub API docs for get_review](https://docs.github.com/rest/reference/pulls#get-a-review-for-a-pull-request)
    ///
    /// ---
    pub async fn get_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32) -> Result<PullRequestReview, PullsGetReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsGetReviewError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsGetReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a review for a pull request
    /// 
    /// [GitHub API docs for get_review](https://docs.github.com/rest/reference/pulls#get-a-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32) -> Result<PullRequestReview, PullsGetReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsGetReviewError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsGetReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a review comment for a pull request
    ///
    /// Provides details for a review comment.
    /// 
    /// [GitHub API docs for get_review_comment](https://docs.github.com/rest/reference/pulls#get-a-review-comment-for-a-pull-request)
    ///
    /// The `get_review_comment_async` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `get_review_comment_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub async fn get_review_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<PullRequestReviewComment, PullsGetReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsGetReviewCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsGetReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a review comment for a pull request
    ///
    /// Provides details for a review comment.
    /// 
    /// [GitHub API docs for get_review_comment](https://docs.github.com/rest/reference/pulls#get-a-review-comment-for-a-pull-request)
    ///
    /// The `get_review_comment` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `get_review_comment` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub fn get_review_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<PullRequestReviewComment, PullsGetReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsGetReviewCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsGetReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/pulls/#list-pull-requests)
    ///
    /// ---
    pub async fn list_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<PullsListParams<'api>>>) -> Result<Vec<PullRequestSimple>, PullsListError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(PullsListError::Status304),
                422 => Err(PullsListError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/pulls/#list-pull-requests)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list(&self, owner: &str, repo: &str, query_params: Option<impl Into<PullsListParams<'api>>>) -> Result<Vec<PullRequestSimple>, PullsListError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(PullsListError::Status304),
                422 => Err(PullsListError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(PullsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List comments for a pull request review
    ///
    /// List comments for a specific pull request review.
    /// 
    /// [GitHub API docs for list_comments_for_review](https://docs.github.com/rest/reference/pulls#list-comments-for-a-pull-request-review)
    ///
    /// ---
    pub async fn list_comments_for_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, query_params: Option<impl Into<PullsListCommentsForReviewParams>>) -> Result<Vec<ReviewComment>, PullsListCommentsForReviewError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsListCommentsForReviewError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsListCommentsForReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List comments for a pull request review
    ///
    /// List comments for a specific pull request review.
    /// 
    /// [GitHub API docs for list_comments_for_review](https://docs.github.com/rest/reference/pulls#list-comments-for-a-pull-request-review)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_comments_for_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, query_params: Option<impl Into<PullsListCommentsForReviewParams>>) -> Result<Vec<ReviewComment>, PullsListCommentsForReviewError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListCommentsForReviewParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsListCommentsForReviewError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsListCommentsForReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commits on a pull request
    ///
    /// Lists a maximum of 250 commits for a pull request. To receive a complete commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/reference/repos#list-commits) endpoint.
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/pulls/#list-commits-on-a-pull-request)
    ///
    /// ---
    pub async fn list_commits_async(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListCommitsParams>>) -> Result<Vec<Commit>, PullsListCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/commits", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commits on a pull request
    ///
    /// Lists a maximum of 250 commits for a pull request. To receive a complete commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/reference/repos#list-commits) endpoint.
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/pulls/#list-commits-on-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_commits(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListCommitsParams>>) -> Result<Vec<Commit>, PullsListCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/commits", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListCommitsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests files
    ///
    /// **Note:** Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
    /// 
    /// [GitHub API docs for list_files](https://docs.github.com/rest/reference/pulls/#list-pull-requests-files)
    ///
    /// ---
    pub async fn list_files_async(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListFilesParams>>) -> Result<Vec<DiffEntry>, PullsListFilesError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/files", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsListFilesError::Status422(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(PullsListFilesError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsListFilesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests files
    ///
    /// **Note:** Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
    /// 
    /// [GitHub API docs for list_files](https://docs.github.com/rest/reference/pulls/#list-pull-requests-files)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_files(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListFilesParams>>) -> Result<Vec<DiffEntry>, PullsListFilesError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/files", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListFilesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsListFilesError::Status422(crate::adapters::to_json(github_response)?)),
                500 => Err(PullsListFilesError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(PullsListFilesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List requested reviewers for a pull request
    /// 
    /// [GitHub API docs for list_requested_reviewers](https://docs.github.com/rest/reference/pulls#list-requested-reviewers-for-a-pull-request)
    ///
    /// ---
    pub async fn list_requested_reviewers_async(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListRequestedReviewersParams>>) -> Result<PullRequestReviewRequest, PullsListRequestedReviewersError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListRequestedReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List requested reviewers for a pull request
    /// 
    /// [GitHub API docs for list_requested_reviewers](https://docs.github.com/rest/reference/pulls#list-requested-reviewers-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_requested_reviewers(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListRequestedReviewersParams>>) -> Result<PullRequestReviewRequest, PullsListRequestedReviewersError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListRequestedReviewersParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListRequestedReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List review comments on a pull request
    ///
    /// Lists all review comments for a pull request. By default, review comments are in ascending order by ID.
    /// 
    /// [GitHub API docs for list_review_comments](https://docs.github.com/rest/reference/pulls#list-review-comments-on-a-pull-request)
    ///
    /// The `list_review_comments_async` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `list_review_comments_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_review_comments_async(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListReviewCommentsParams<'api>>>) -> Result<Vec<PullRequestReviewComment>, PullsListReviewCommentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List review comments on a pull request
    ///
    /// Lists all review comments for a pull request. By default, review comments are in ascending order by ID.
    /// 
    /// [GitHub API docs for list_review_comments](https://docs.github.com/rest/reference/pulls#list-review-comments-on-a-pull-request)
    ///
    /// The `list_review_comments` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `list_review_comments` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_review_comments(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListReviewCommentsParams<'api>>>) -> Result<Vec<PullRequestReviewComment>, PullsListReviewCommentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListReviewCommentsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewCommentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List review comments in a repository
    ///
    /// Lists review comments for all pull requests in a repository. By default, review comments are in ascending order by ID.
    /// 
    /// [GitHub API docs for list_review_comments_for_repo](https://docs.github.com/rest/reference/pulls#list-review-comments-in-a-repository)
    ///
    /// The `list_review_comments_for_repo_async` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `list_review_comments_for_repo_async` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub async fn list_review_comments_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<PullsListReviewCommentsForRepoParams<'api>>>) -> Result<Vec<PullRequestReviewComment>, PullsListReviewCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List review comments in a repository
    ///
    /// Lists review comments for all pull requests in a repository. By default, review comments are in ascending order by ID.
    /// 
    /// [GitHub API docs for list_review_comments_for_repo](https://docs.github.com/rest/reference/pulls#list-review-comments-in-a-repository)
    ///
    /// The `list_review_comments_for_repo` endpoint is enabled with the `comfort-fade` cargo feature.
    /// The `list_review_comments_for_repo` endpoint is enabled with the `squirrel-girl` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "comfort-fade")]
    #[cfg(feature = "squirrel-girl")]
    pub fn list_review_comments_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<PullsListReviewCommentsForRepoParams<'api>>>) -> Result<Vec<PullRequestReviewComment>, PullsListReviewCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListReviewCommentsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ("Accept", "application/vnd.github.squirrel-girl-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reviews for a pull request
    ///
    /// The list of reviews returns in chronological order.
    /// 
    /// [GitHub API docs for list_reviews](https://docs.github.com/rest/reference/pulls#list-reviews-for-a-pull-request)
    ///
    /// ---
    pub async fn list_reviews_async(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListReviewsParams>>) -> Result<Vec<PullRequestReview>, PullsListReviewsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reviews for a pull request
    ///
    /// The list of reviews returns in chronological order.
    /// 
    /// [GitHub API docs for list_reviews](https://docs.github.com/rest/reference/pulls#list-reviews-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_reviews(&self, owner: &str, repo: &str, pull_number: i32, query_params: Option<impl Into<PullsListReviewsParams>>) -> Result<Vec<PullRequestReview>, PullsListReviewsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews", super::GITHUB_BASE_API_URL, owner, repo, pull_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PullsListReviewsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsListReviewsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Merge a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for merge](https://docs.github.com/rest/reference/pulls/#merge-a-pull-request)
    ///
    /// ---
    pub async fn merge_async(&self, owner: &str, repo: &str, pull_number: i32, body: PutPullsMerge) -> Result<PullRequestMergeResult, PullsMergeError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/merge", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsMerge::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                405 => Err(PullsMergeError::Status405(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(PullsMergeError::Status409(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(PullsMergeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsMergeError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(PullsMergeError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsMergeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Merge a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for merge](https://docs.github.com/rest/reference/pulls/#merge-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn merge(&self, owner: &str, repo: &str, pull_number: i32, body: PutPullsMerge) -> Result<PullRequestMergeResult, PullsMergeError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/merge", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsMerge::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                405 => Err(PullsMergeError::Status405(crate::adapters::to_json(github_response)?)),
                409 => Err(PullsMergeError::Status409(crate::adapters::to_json(github_response)?)),
                422 => Err(PullsMergeError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsMergeError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(PullsMergeError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(PullsMergeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove requested reviewers from a pull request
    /// 
    /// [GitHub API docs for remove_requested_reviewers](https://docs.github.com/rest/reference/pulls#remove-requested-reviewers-from-a-pull-request)
    ///
    /// ---
    pub async fn remove_requested_reviewers_async(&self, owner: &str, repo: &str, pull_number: i32, body: DeletePullsRemoveRequestedReviewers) -> Result<PullRequestSimple, PullsRemoveRequestedReviewersError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeletePullsRemoveRequestedReviewers::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsRemoveRequestedReviewersError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsRemoveRequestedReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove requested reviewers from a pull request
    /// 
    /// [GitHub API docs for remove_requested_reviewers](https://docs.github.com/rest/reference/pulls#remove-requested-reviewers-from-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_requested_reviewers(&self, owner: &str, repo: &str, pull_number: i32, body: DeletePullsRemoveRequestedReviewers) -> Result<PullRequestSimple, PullsRemoveRequestedReviewersError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeletePullsRemoveRequestedReviewers::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsRemoveRequestedReviewersError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(PullsRemoveRequestedReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Request reviewers for a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for request_reviewers](https://docs.github.com/rest/reference/pulls#request-reviewers-for-a-pull-request)
    ///
    /// ---
    pub async fn request_reviewers_async(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsRequestReviewers) -> Result<PullRequestSimple, PullsRequestReviewersError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsRequestReviewers::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsRequestReviewersError::Status422),
                403 => Err(PullsRequestReviewersError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsRequestReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Request reviewers for a pull request
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
    /// 
    /// [GitHub API docs for request_reviewers](https://docs.github.com/rest/reference/pulls#request-reviewers-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn request_reviewers(&self, owner: &str, repo: &str, pull_number: i32, body: PostPullsRequestReviewers) -> Result<PullRequestSimple, PullsRequestReviewersError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/requested_reviewers", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsRequestReviewers::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsRequestReviewersError::Status422),
                403 => Err(PullsRequestReviewersError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(PullsRequestReviewersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Submit a review for a pull request
    /// 
    /// [GitHub API docs for submit_review](https://docs.github.com/rest/reference/pulls#submit-a-review-for-a-pull-request)
    ///
    /// ---
    pub async fn submit_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PostPullsSubmitReview) -> Result<PullRequestReview, PullsSubmitReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/events", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsSubmitReview::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsSubmitReviewError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(PullsSubmitReviewError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsSubmitReviewError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsSubmitReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Submit a review for a pull request
    /// 
    /// [GitHub API docs for submit_review](https://docs.github.com/rest/reference/pulls#submit-a-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn submit_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PostPullsSubmitReview) -> Result<PullRequestReview, PullsSubmitReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}/events", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostPullsSubmitReview::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PullsSubmitReviewError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(PullsSubmitReviewError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsSubmitReviewError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(PullsSubmitReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/pulls/#update-a-pull-request)
    ///
    /// ---
    pub async fn update_async(&self, owner: &str, repo: &str, pull_number: i32, body: PatchPullsUpdate) -> Result<PullRequest, PullsUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchPullsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsUpdateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/pulls/#update-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, owner: &str, repo: &str, pull_number: i32, body: PatchPullsUpdate) -> Result<PullRequest, PullsUpdateError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchPullsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsUpdateError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(PullsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a pull request branch
    ///
    /// Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
    /// 
    /// [GitHub API docs for update_branch](https://docs.github.com/rest/reference/pulls/#update-a-pull-request-branch)
    ///
    /// The `update_branch_async` endpoint is enabled with the `lydian` cargo feature.
    ///
    /// ---
    #[cfg(feature = "lydian")]
    pub async fn update_branch_async(&self, owner: &str, repo: &str, pull_number: i32, body: PutPullsUpdateBranch) -> Result<PutPullsUpdateBranchResponse202, PullsUpdateBranchError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/update-branch", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsUpdateBranch::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.lydian-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateBranchError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PullsUpdateBranchError::Status403(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(PullsUpdateBranchError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsUpdateBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a pull request branch
    ///
    /// Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
    /// 
    /// [GitHub API docs for update_branch](https://docs.github.com/rest/reference/pulls/#update-a-pull-request-branch)
    ///
    /// The `update_branch` endpoint is enabled with the `lydian` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "lydian")]
    pub fn update_branch(&self, owner: &str, repo: &str, pull_number: i32, body: PutPullsUpdateBranch) -> Result<PutPullsUpdateBranchResponse202, PullsUpdateBranchError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/update-branch", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsUpdateBranch::from_json(body)?),
            method: "PUT",
            headers: vec![("Accept", "application/vnd.github.lydian-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateBranchError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(PullsUpdateBranchError::Status403(crate::adapters::to_json(github_response)?)),
                415 => Err(PullsUpdateBranchError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(PullsUpdateBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a review for a pull request
    ///
    /// Update the review summary comment with new text.
    /// 
    /// [GitHub API docs for update_review](https://docs.github.com/rest/reference/pulls#update-a-review-for-a-pull-request)
    ///
    /// ---
    pub async fn update_review_async(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PutPullsUpdateReview) -> Result<PullRequestReview, PullsUpdateReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsUpdateReview::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateReviewError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PullsUpdateReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a review for a pull request
    ///
    /// Update the review summary comment with new text.
    /// 
    /// [GitHub API docs for update_review](https://docs.github.com/rest/reference/pulls#update-a-review-for-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_review(&self, owner: &str, repo: &str, pull_number: i32, review_id: i32, body: PutPullsUpdateReview) -> Result<PullRequestReview, PullsUpdateReviewError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/reviews/{}", super::GITHUB_BASE_API_URL, owner, repo, pull_number, review_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutPullsUpdateReview::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(PullsUpdateReviewError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(PullsUpdateReviewError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a review comment for a pull request
    ///
    /// Enables you to edit a review comment.
    /// 
    /// [GitHub API docs for update_review_comment](https://docs.github.com/rest/reference/pulls#update-a-review-comment-for-a-pull-request)
    ///
    /// The `update_review_comment_async` endpoint is enabled with the `comfort-fade` cargo feature.
    ///
    /// ---
    #[cfg(feature = "comfort-fade")]
    pub async fn update_review_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PatchPullsUpdateReviewComment) -> Result<PullRequestReviewComment, PullsUpdateReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchPullsUpdateReviewComment::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PullsUpdateReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a review comment for a pull request
    ///
    /// Enables you to edit a review comment.
    /// 
    /// [GitHub API docs for update_review_comment](https://docs.github.com/rest/reference/pulls#update-a-review-comment-for-a-pull-request)
    ///
    /// The `update_review_comment` endpoint is enabled with the `comfort-fade` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "comfort-fade")]
    pub fn update_review_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PatchPullsUpdateReviewComment) -> Result<PullRequestReviewComment, PullsUpdateReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchPullsUpdateReviewComment::from_json(body)?),
            method: "PATCH",
            headers: vec![("Accept", "application/vnd.github.comfort-fade-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PullsUpdateReviewCommentError::Generic { code }),
            }
        }
    }

}
