//! Method, error and parameter types for the OauthAuthorizations endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct OauthAuthorizations<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> OauthAuthorizations {
    OauthAuthorizations { auth }
}

/// Errors for the [Create a new authorization](OauthAuthorizations::create_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsCreateAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an authorization](OauthAuthorizations::delete_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsDeleteAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a grant](OauthAuthorizations::delete_grant_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsDeleteGrantError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a single authorization](OauthAuthorizations::get_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsGetAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a single grant](OauthAuthorizations::get_grant_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsGetGrantError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get-or-create an authorization for a specific app](OauthAuthorizations::get_or_create_authorization_for_app_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsGetOrCreateAuthorizationForAppError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("**Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).")]
    Status201(Authorization),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get-or-create an authorization for a specific app and fingerprint](OauthAuthorizations::get_or_create_authorization_for_app_and_fingerprint_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if returning a new token")]
    Status201(Authorization),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List your authorizations](OauthAuthorizations::list_authorizations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsListAuthorizationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List your grants](OauthAuthorizations::list_grants_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsListGrantsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an existing authorization](OauthAuthorizations::update_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OauthAuthorizationsUpdateAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List your authorizations](OauthAuthorizations::list_authorizations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OauthAuthorizationsListAuthorizationsParams<'req> {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// The client ID of your GitHub app.
    client_id: Option<&'req str>
}

impl<'req> OauthAuthorizationsListAuthorizationsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
            client_id: self.client_id, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
            client_id: self.client_id, 
        }
    }

    /// The client ID of your GitHub app.
    pub fn client_id(self, client_id: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            client_id: Some(client_id),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OauthAuthorizationsListAuthorizationsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List your grants](OauthAuthorizations::list_grants_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OauthAuthorizationsListGrantsParams<'req> {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// The client ID of your GitHub app.
    client_id: Option<&'req str>
}

impl<'req> OauthAuthorizationsListGrantsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
            client_id: self.client_id, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
            client_id: self.client_id, 
        }
    }

    /// The client ID of your GitHub app.
    pub fn client_id(self, client_id: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            client_id: Some(client_id),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OauthAuthorizationsListGrantsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> OauthAuthorizations<'api> {
    /// ---
    ///
    /// # Create a new authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// Creates OAuth tokens using [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
    /// 
    /// You can also create tokens on GitHub from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://help.github.com/articles/creating-an-access-token-for-command-line-use).
    /// 
    /// Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://help.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
    /// 
    /// [GitHub API docs for create_authorization](https://docs.github.com/rest/reference/oauth-authorizations#create-a-new-authorization)
    ///
    /// ---
    pub async fn create_authorization_async(&self, body: PostOauthAuthorizationsCreateAuthorization) -> Result<Authorization, OauthAuthorizationsCreateAuthorizationError> {

        let request_uri = format!("{}/authorizations", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOauthAuthorizationsCreateAuthorization::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OauthAuthorizationsCreateAuthorizationError::Status422(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(OauthAuthorizationsCreateAuthorizationError::Status410(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(OauthAuthorizationsCreateAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsCreateAuthorizationError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsCreateAuthorizationError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsCreateAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a new authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// Creates OAuth tokens using [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
    /// 
    /// You can also create tokens on GitHub from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://help.github.com/articles/creating-an-access-token-for-command-line-use).
    /// 
    /// Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://help.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
    /// 
    /// [GitHub API docs for create_authorization](https://docs.github.com/rest/reference/oauth-authorizations#create-a-new-authorization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_authorization(&self, body: PostOauthAuthorizationsCreateAuthorization) -> Result<Authorization, OauthAuthorizationsCreateAuthorizationError> {

        let request_uri = format!("{}/authorizations", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOauthAuthorizationsCreateAuthorization::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OauthAuthorizationsCreateAuthorizationError::Status422(crate::adapters::to_json(github_response)?)),
                410 => Err(OauthAuthorizationsCreateAuthorizationError::Status410(crate::adapters::to_json(github_response)?)),
                304 => Err(OauthAuthorizationsCreateAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsCreateAuthorizationError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsCreateAuthorizationError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsCreateAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for delete_authorization](https://docs.github.com/rest/reference/oauth-authorizations#delete-an-authorization)
    ///
    /// ---
    pub async fn delete_authorization_async(&self, authorization_id: i32) -> Result<(), OauthAuthorizationsDeleteAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsDeleteAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsDeleteAuthorizationError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsDeleteAuthorizationError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsDeleteAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for delete_authorization](https://docs.github.com/rest/reference/oauth-authorizations#delete-an-authorization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_authorization(&self, authorization_id: i32) -> Result<(), OauthAuthorizationsDeleteAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsDeleteAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsDeleteAuthorizationError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsDeleteAuthorizationError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsDeleteAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a grant
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    /// 
    /// [GitHub API docs for delete_grant](https://docs.github.com/rest/reference/oauth-authorizations#delete-a-grant)
    ///
    /// ---
    pub async fn delete_grant_async(&self, grant_id: i32) -> Result<(), OauthAuthorizationsDeleteGrantError> {

        let request_uri = format!("{}/applications/grants/{}", super::GITHUB_BASE_API_URL, grant_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsDeleteGrantError::Status304),
                403 => Err(OauthAuthorizationsDeleteGrantError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsDeleteGrantError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsDeleteGrantError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a grant
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    /// 
    /// [GitHub API docs for delete_grant](https://docs.github.com/rest/reference/oauth-authorizations#delete-a-grant)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_grant(&self, grant_id: i32) -> Result<(), OauthAuthorizationsDeleteGrantError> {

        let request_uri = format!("{}/applications/grants/{}", super::GITHUB_BASE_API_URL, grant_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsDeleteGrantError::Status304),
                403 => Err(OauthAuthorizationsDeleteGrantError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsDeleteGrantError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsDeleteGrantError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a single authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_authorization](https://docs.github.com/rest/reference/oauth-authorizations#get-a-single-authorization)
    ///
    /// ---
    pub async fn get_authorization_async(&self, authorization_id: i32) -> Result<Authorization, OauthAuthorizationsGetAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsGetAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsGetAuthorizationError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsGetAuthorizationError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsGetAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a single authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_authorization](https://docs.github.com/rest/reference/oauth-authorizations#get-a-single-authorization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_authorization(&self, authorization_id: i32) -> Result<Authorization, OauthAuthorizationsGetAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsGetAuthorizationError::Status304),
                403 => Err(OauthAuthorizationsGetAuthorizationError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsGetAuthorizationError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsGetAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a single grant
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_grant](https://docs.github.com/rest/reference/oauth-authorizations#get-a-single-grant)
    ///
    /// ---
    pub async fn get_grant_async(&self, grant_id: i32) -> Result<ApplicationGrant, OauthAuthorizationsGetGrantError> {

        let request_uri = format!("{}/applications/grants/{}", super::GITHUB_BASE_API_URL, grant_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsGetGrantError::Status304),
                403 => Err(OauthAuthorizationsGetGrantError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsGetGrantError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsGetGrantError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a single grant
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_grant](https://docs.github.com/rest/reference/oauth-authorizations#get-a-single-grant)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_grant(&self, grant_id: i32) -> Result<ApplicationGrant, OauthAuthorizationsGetGrantError> {

        let request_uri = format!("{}/applications/grants/{}", super::GITHUB_BASE_API_URL, grant_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsGetGrantError::Status304),
                403 => Err(OauthAuthorizationsGetGrantError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsGetGrantError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsGetGrantError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get-or-create an authorization for a specific app
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_or_create_authorization_for_app](https://docs.github.com/rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app)
    ///
    /// ---
    pub async fn get_or_create_authorization_for_app_async(&self, client_id: &str, body: PutOauthAuthorizationsGetOrCreateAuthorizationForApp) -> Result<Authorization, OauthAuthorizationsGetOrCreateAuthorizationForAppError> {

        let request_uri = format!("{}/authorizations/clients/{}", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOauthAuthorizationsGetOrCreateAuthorizationForApp::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status304),
                403 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get-or-create an authorization for a specific app
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for get_or_create_authorization_for_app](https://docs.github.com/rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_or_create_authorization_for_app(&self, client_id: &str, body: PutOauthAuthorizationsGetOrCreateAuthorizationForApp) -> Result<Authorization, OauthAuthorizationsGetOrCreateAuthorizationForAppError> {

        let request_uri = format!("{}/authorizations/clients/{}", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOauthAuthorizationsGetOrCreateAuthorizationForApp::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status304),
                403 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get-or-create an authorization for a specific app and fingerprint
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// [GitHub API docs for get_or_create_authorization_for_app_and_fingerprint](https://docs.github.com/rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app-and-fingerprint)
    ///
    /// ---
    pub async fn get_or_create_authorization_for_app_and_fingerprint_async(&self, client_id: &str, fingerprint: &str, body: PutOauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprint) -> Result<Authorization, OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError> {

        let request_uri = format!("{}/authorizations/clients/{}/{}", super::GITHUB_BASE_API_URL, client_id, fingerprint);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprint::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get-or-create an authorization for a specific app and fingerprint
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
    /// 
    /// This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// [GitHub API docs for get_or_create_authorization_for_app_and_fingerprint](https://docs.github.com/rest/reference/oauth-authorizations#get-or-create-an-authorization-for-a-specific-app-and-fingerprint)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_or_create_authorization_for_app_and_fingerprint(&self, client_id: &str, fingerprint: &str, body: PutOauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprint) -> Result<Authorization, OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError> {

        let request_uri = format!("{}/authorizations/clients/{}/{}", super::GITHUB_BASE_API_URL, client_id, fingerprint);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprint::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List your authorizations
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for list_authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations)
    ///
    /// ---
    pub async fn list_authorizations_async(&self, query_params: Option<impl Into<OauthAuthorizationsListAuthorizationsParams<'api>>>) -> Result<Vec<Authorization>, OauthAuthorizationsListAuthorizationsError> {

        let mut request_uri = format!("{}/authorizations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsListAuthorizationsError::Status304),
                403 => Err(OauthAuthorizationsListAuthorizationsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsListAuthorizationsError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OauthAuthorizationsListAuthorizationsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsListAuthorizationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List your authorizations
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// [GitHub API docs for list_authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_authorizations(&self, query_params: Option<impl Into<OauthAuthorizationsListAuthorizationsParams<'api>>>) -> Result<Vec<Authorization>, OauthAuthorizationsListAuthorizationsError> {

        let mut request_uri = format!("{}/authorizations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OauthAuthorizationsListAuthorizationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsListAuthorizationsError::Status304),
                403 => Err(OauthAuthorizationsListAuthorizationsError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsListAuthorizationsError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(OauthAuthorizationsListAuthorizationsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsListAuthorizationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List your grants
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
    /// 
    /// [GitHub API docs for list_grants](https://docs.github.com/rest/reference/oauth-authorizations#list-your-grants)
    ///
    /// ---
    pub async fn list_grants_async(&self, query_params: Option<impl Into<OauthAuthorizationsListGrantsParams<'api>>>) -> Result<Vec<ApplicationGrant>, OauthAuthorizationsListGrantsError> {

        let mut request_uri = format!("{}/applications/grants", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsListGrantsError::Status304),
                403 => Err(OauthAuthorizationsListGrantsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OauthAuthorizationsListGrantsError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OauthAuthorizationsListGrantsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsListGrantsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List your grants
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
    /// 
    /// [GitHub API docs for list_grants](https://docs.github.com/rest/reference/oauth-authorizations#list-your-grants)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_grants(&self, query_params: Option<impl Into<OauthAuthorizationsListGrantsParams<'api>>>) -> Result<Vec<ApplicationGrant>, OauthAuthorizationsListGrantsError> {

        let mut request_uri = format!("{}/applications/grants", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OauthAuthorizationsListGrantsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OauthAuthorizationsListGrantsError::Status304),
                403 => Err(OauthAuthorizationsListGrantsError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OauthAuthorizationsListGrantsError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(OauthAuthorizationsListGrantsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsListGrantsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// You can only send one of these scope keys at a time.
    /// 
    /// [GitHub API docs for update_authorization](https://docs.github.com/rest/reference/oauth-authorizations#update-an-existing-authorization)
    ///
    /// ---
    pub async fn update_authorization_async(&self, authorization_id: i32, body: PatchOauthAuthorizationsUpdateAuthorization) -> Result<Authorization, OauthAuthorizationsUpdateAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOauthAuthorizationsUpdateAuthorization::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OauthAuthorizationsUpdateAuthorizationError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OauthAuthorizationsUpdateAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing authorization
    ///
    /// **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
    /// 
    /// If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
    /// 
    /// You can only send one of these scope keys at a time.
    /// 
    /// [GitHub API docs for update_authorization](https://docs.github.com/rest/reference/oauth-authorizations#update-an-existing-authorization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_authorization(&self, authorization_id: i32, body: PatchOauthAuthorizationsUpdateAuthorization) -> Result<Authorization, OauthAuthorizationsUpdateAuthorizationError> {

        let request_uri = format!("{}/authorizations/{}", super::GITHUB_BASE_API_URL, authorization_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOauthAuthorizationsUpdateAuthorization::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OauthAuthorizationsUpdateAuthorizationError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OauthAuthorizationsUpdateAuthorizationError::Generic { code }),
            }
        }
    }

}
