//! Method, error and parameter types for the Migrations endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Migrations<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Migrations {
    Migrations { auth }
}

/// Errors for the [Cancel an import](Migrations::cancel_import_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsCancelImportError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a user migration archive](Migrations::delete_archive_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsDeleteArchiveForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an organization migration archive](Migrations::delete_archive_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsDeleteArchiveForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download an organization migration archive](Migrations::download_archive_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsDownloadArchiveForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download a user migration archive](Migrations::get_archive_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetArchiveForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get commit authors](Migrations::get_commit_authors_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetCommitAuthorsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an import status](Migrations::get_import_status_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetImportStatusError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get large files](Migrations::get_large_files_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetLargeFilesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a user migration status](Migrations::get_status_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetStatusForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization migration status](Migrations::get_status_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsGetStatusForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List user migrations](Migrations::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization migrations](Migrations::list_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsListForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories in an organization migration](Migrations::list_repos_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsListReposForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories for a user migration](Migrations::list_repos_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsListReposForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Map a commit author](Migrations::map_commit_author_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsMapCommitAuthorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update Git LFS preference](Migrations::set_lfs_preference_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsSetLfsPreferenceError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Start a user migration](Migrations::start_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsStartForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Start an organization migration](Migrations::start_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsStartForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Start an import](Migrations::start_import_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsStartImportError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unlock a user repository](Migrations::unlock_repo_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsUnlockRepoForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unlock an organization repository](Migrations::unlock_repo_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsUnlockRepoForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an import](Migrations::update_import_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MigrationsUpdateImportError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get commit authors](Migrations::get_commit_authors_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsGetCommitAuthorsParams {
    /// A user ID. Only return users with an ID greater than this ID.
    since: Option<i32>
}

impl MigrationsGetCommitAuthorsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// A user ID. Only return users with an ID greater than this ID.
    pub fn since(self, since: i32) -> Self {
        Self { 
            since: Some(since),
        }
    }
}

/// Query parameters for the [Get a user migration status](Migrations::get_status_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsGetStatusForAuthenticatedUserParams {
    
    exclude: Option<Vec<String>>
}

impl MigrationsGetStatusForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    
    pub fn exclude(self, exclude: Vec<String>) -> Self {
        Self { 
            exclude: Some(exclude),
        }
    }
}

/// Query parameters for the [Get an organization migration status](Migrations::get_status_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsGetStatusForOrgParams {
    /// Exclude attributes from the API response to improve performance
    exclude: Option<Vec<String>>
}

impl MigrationsGetStatusForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Exclude attributes from the API response to improve performance
    pub fn exclude(self, exclude: Vec<String>) -> Self {
        Self { 
            exclude: Some(exclude),
        }
    }
}

/// Query parameters for the [List user migrations](Migrations::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsListForAuthenticatedUserParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl MigrationsListForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for MigrationsListForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization migrations](Migrations::list_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsListForOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Exclude attributes from the API response to improve performance
    exclude: Option<Vec<String>>
}

impl MigrationsListForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
            exclude: self.exclude, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
            exclude: self.exclude, 
        }
    }

    /// Exclude attributes from the API response to improve performance
    pub fn exclude(self, exclude: Vec<String>) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            exclude: Some(exclude),
        }
    }
}

impl<'enc> From<&'enc PerPage> for MigrationsListForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories in an organization migration](Migrations::list_repos_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsListReposForOrgParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl MigrationsListReposForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for MigrationsListReposForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories for a user migration](Migrations::list_repos_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct MigrationsListReposForUserParams {
    /// Results per page (max 100).
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl MigrationsListReposForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100).
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for MigrationsListReposForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Migrations<'api> {
    /// ---
    ///
    /// # Cancel an import
    ///
    /// Stop an import for a repository.
    /// 
    /// [GitHub API docs for cancel_import](https://docs.github.com/rest/reference/migrations#cancel-an-import)
    ///
    /// ---
    pub async fn cancel_import_async(&self, owner: &str, repo: &str) -> Result<(), MigrationsCancelImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsCancelImportError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Cancel an import
    ///
    /// Stop an import for a repository.
    /// 
    /// [GitHub API docs for cancel_import](https://docs.github.com/rest/reference/migrations#cancel-an-import)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn cancel_import(&self, owner: &str, repo: &str) -> Result<(), MigrationsCancelImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsCancelImportError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a user migration archive
    ///
    /// Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/reference/migrations#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
    /// 
    /// [GitHub API docs for delete_archive_for_authenticated_user](https://docs.github.com/rest/reference/migrations#delete-a-user-migration-archive)
    ///
    /// The `delete_archive_for_authenticated_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn delete_archive_for_authenticated_user_async(&self, migration_id: i32) -> Result<(), MigrationsDeleteArchiveForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/archive", super::GITHUB_BASE_API_URL, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status304),
                403 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a user migration archive
    ///
    /// Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/reference/migrations#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
    /// 
    /// [GitHub API docs for delete_archive_for_authenticated_user](https://docs.github.com/rest/reference/migrations#delete-a-user-migration-archive)
    ///
    /// The `delete_archive_for_authenticated_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn delete_archive_for_authenticated_user(&self, migration_id: i32) -> Result<(), MigrationsDeleteArchiveForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/archive", super::GITHUB_BASE_API_URL, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status304),
                403 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsDeleteArchiveForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization migration archive
    ///
    /// Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
    /// 
    /// [GitHub API docs for delete_archive_for_org](https://docs.github.com/rest/reference/migrations#delete-an-organization-migration-archive)
    ///
    /// The `delete_archive_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn delete_archive_for_org_async(&self, org: &str, migration_id: i32) -> Result<(), MigrationsDeleteArchiveForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/archive", super::GITHUB_BASE_API_URL, org, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsDeleteArchiveForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsDeleteArchiveForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization migration archive
    ///
    /// Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
    /// 
    /// [GitHub API docs for delete_archive_for_org](https://docs.github.com/rest/reference/migrations#delete-an-organization-migration-archive)
    ///
    /// The `delete_archive_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn delete_archive_for_org(&self, org: &str, migration_id: i32) -> Result<(), MigrationsDeleteArchiveForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/archive", super::GITHUB_BASE_API_URL, org, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsDeleteArchiveForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsDeleteArchiveForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download an organization migration archive
    ///
    /// Fetches the URL to a migration archive.
    /// 
    /// [GitHub API docs for download_archive_for_org](https://docs.github.com/rest/reference/migrations#download-an-organization-migration-archive)
    ///
    /// The `download_archive_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn download_archive_for_org_async(&self, org: &str, migration_id: i32) -> Result<(), MigrationsDownloadArchiveForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/archive", super::GITHUB_BASE_API_URL, org, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(MigrationsDownloadArchiveForOrgError::Status302),
                404 => Err(MigrationsDownloadArchiveForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsDownloadArchiveForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download an organization migration archive
    ///
    /// Fetches the URL to a migration archive.
    /// 
    /// [GitHub API docs for download_archive_for_org](https://docs.github.com/rest/reference/migrations#download-an-organization-migration-archive)
    ///
    /// The `download_archive_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn download_archive_for_org(&self, org: &str, migration_id: i32) -> Result<(), MigrationsDownloadArchiveForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/archive", super::GITHUB_BASE_API_URL, org, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(MigrationsDownloadArchiveForOrgError::Status302),
                404 => Err(MigrationsDownloadArchiveForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsDownloadArchiveForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a user migration archive
    ///
    /// Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
    /// 
    /// *   attachments
    /// *   bases
    /// *   commit\_comments
    /// *   issue\_comments
    /// *   issue\_events
    /// *   issues
    /// *   milestones
    /// *   organizations
    /// *   projects
    /// *   protected\_branches
    /// *   pull\_request\_reviews
    /// *   pull\_requests
    /// *   releases
    /// *   repositories
    /// *   review\_comments
    /// *   schema
    /// *   users
    /// 
    /// The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
    /// 
    /// [GitHub API docs for get_archive_for_authenticated_user](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive)
    ///
    /// The `get_archive_for_authenticated_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn get_archive_for_authenticated_user_async(&self, migration_id: i32) -> Result<(), MigrationsGetArchiveForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/archive", super::GITHUB_BASE_API_URL, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status302),
                304 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status304),
                403 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsGetArchiveForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a user migration archive
    ///
    /// Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
    /// 
    /// *   attachments
    /// *   bases
    /// *   commit\_comments
    /// *   issue\_comments
    /// *   issue\_events
    /// *   issues
    /// *   milestones
    /// *   organizations
    /// *   projects
    /// *   protected\_branches
    /// *   pull\_request\_reviews
    /// *   pull\_requests
    /// *   releases
    /// *   repositories
    /// *   review\_comments
    /// *   schema
    /// *   users
    /// 
    /// The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
    /// 
    /// [GitHub API docs for get_archive_for_authenticated_user](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive)
    ///
    /// The `get_archive_for_authenticated_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn get_archive_for_authenticated_user(&self, migration_id: i32) -> Result<(), MigrationsGetArchiveForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/archive", super::GITHUB_BASE_API_URL, migration_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status302),
                304 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status304),
                403 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsGetArchiveForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsGetArchiveForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get commit authors
    ///
    /// Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
    /// 
    /// This endpoint and the [Map a commit author](https://docs.github.com/rest/reference/migrations#map-a-commit-author) endpoint allow you to provide correct Git author information.
    /// 
    /// [GitHub API docs for get_commit_authors](https://docs.github.com/rest/reference/migrations#get-commit-authors)
    ///
    /// ---
    pub async fn get_commit_authors_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<MigrationsGetCommitAuthorsParams>>) -> Result<Vec<PorterAuthor>, MigrationsGetCommitAuthorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/import/authors", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetCommitAuthorsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsGetCommitAuthorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get commit authors
    ///
    /// Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
    /// 
    /// This endpoint and the [Map a commit author](https://docs.github.com/rest/reference/migrations#map-a-commit-author) endpoint allow you to provide correct Git author information.
    /// 
    /// [GitHub API docs for get_commit_authors](https://docs.github.com/rest/reference/migrations#get-commit-authors)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit_authors(&self, owner: &str, repo: &str, query_params: Option<impl Into<MigrationsGetCommitAuthorsParams>>) -> Result<Vec<PorterAuthor>, MigrationsGetCommitAuthorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/import/authors", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsGetCommitAuthorsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetCommitAuthorsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsGetCommitAuthorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an import status
    ///
    /// View the progress of an import.
    /// 
    /// **Import status**
    /// 
    /// This section includes details about the possible values of the `status` field of the Import Progress response.
    /// 
    /// An import that does not have errors will progress through these steps:
    /// 
    /// *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
    /// *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
    /// *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
    /// *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
    /// *   `complete` - the import is complete, and the repository is ready on GitHub.
    /// 
    /// If there are problems, you will see one of these in the `status` field:
    /// 
    /// *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact) or [GitHub Premium Support](https://premium.githubsupport.com) for more information.
    /// *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/reference/migrations#cancel-an-import) and [retry](https://docs.github.com/rest/reference/migrations#start-an-import) with the correct URL.
    /// *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// 
    /// **The project_choices field**
    /// 
    /// When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
    /// 
    /// **Git LFS related fields**
    /// 
    /// This section includes details about Git LFS related fields that may be present in the Import Progress response.
    /// 
    /// *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
    /// *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
    /// *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
    /// *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
    /// 
    /// [GitHub API docs for get_import_status](https://docs.github.com/rest/reference/migrations#get-an-import-status)
    ///
    /// ---
    pub async fn get_import_status_async(&self, owner: &str, repo: &str) -> Result<Import, MigrationsGetImportStatusError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetImportStatusError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsGetImportStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an import status
    ///
    /// View the progress of an import.
    /// 
    /// **Import status**
    /// 
    /// This section includes details about the possible values of the `status` field of the Import Progress response.
    /// 
    /// An import that does not have errors will progress through these steps:
    /// 
    /// *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
    /// *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
    /// *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
    /// *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
    /// *   `complete` - the import is complete, and the repository is ready on GitHub.
    /// 
    /// If there are problems, you will see one of these in the `status` field:
    /// 
    /// *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact) or [GitHub Premium Support](https://premium.githubsupport.com) for more information.
    /// *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/reference/migrations#cancel-an-import) and [retry](https://docs.github.com/rest/reference/migrations#start-an-import) with the correct URL.
    /// *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
    /// 
    /// **The project_choices field**
    /// 
    /// When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
    /// 
    /// **Git LFS related fields**
    /// 
    /// This section includes details about Git LFS related fields that may be present in the Import Progress response.
    /// 
    /// *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
    /// *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
    /// *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
    /// *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
    /// 
    /// [GitHub API docs for get_import_status](https://docs.github.com/rest/reference/migrations#get-an-import-status)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_import_status(&self, owner: &str, repo: &str) -> Result<Import, MigrationsGetImportStatusError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetImportStatusError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsGetImportStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get large files
    ///
    /// List files larger than 100MB found during the import
    /// 
    /// [GitHub API docs for get_large_files](https://docs.github.com/rest/reference/migrations#get-large-files)
    ///
    /// ---
    pub async fn get_large_files_async(&self, owner: &str, repo: &str) -> Result<Vec<PorterLargeFile>, MigrationsGetLargeFilesError> {

        let request_uri = format!("{}/repos/{}/{}/import/large_files", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsGetLargeFilesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get large files
    ///
    /// List files larger than 100MB found during the import
    /// 
    /// [GitHub API docs for get_large_files](https://docs.github.com/rest/reference/migrations#get-large-files)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_large_files(&self, owner: &str, repo: &str) -> Result<Vec<PorterLargeFile>, MigrationsGetLargeFilesError> {

        let request_uri = format!("{}/repos/{}/{}/import/large_files", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsGetLargeFilesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user migration status
    ///
    /// Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
    /// 
    /// *   `pending` - the migration hasn't started yet.
    /// *   `exporting` - the migration is in progress.
    /// *   `exported` - the migration finished successfully.
    /// *   `failed` - the migration failed.
    /// 
    /// Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive).
    /// 
    /// [GitHub API docs for get_status_for_authenticated_user](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status)
    ///
    /// The `get_status_for_authenticated_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn get_status_for_authenticated_user_async(&self, migration_id: i32, query_params: Option<impl Into<MigrationsGetStatusForAuthenticatedUserParams>>) -> Result<Migration, MigrationsGetStatusForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/migrations/{}", super::GITHUB_BASE_API_URL, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetStatusForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(MigrationsGetStatusForAuthenticatedUserError::Status304),
                403 => Err(MigrationsGetStatusForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsGetStatusForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsGetStatusForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user migration status
    ///
    /// Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
    /// 
    /// *   `pending` - the migration hasn't started yet.
    /// *   `exporting` - the migration is in progress.
    /// *   `exported` - the migration finished successfully.
    /// *   `failed` - the migration failed.
    /// 
    /// Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive).
    /// 
    /// [GitHub API docs for get_status_for_authenticated_user](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status)
    ///
    /// The `get_status_for_authenticated_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn get_status_for_authenticated_user(&self, migration_id: i32, query_params: Option<impl Into<MigrationsGetStatusForAuthenticatedUserParams>>) -> Result<Migration, MigrationsGetStatusForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/migrations/{}", super::GITHUB_BASE_API_URL, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsGetStatusForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetStatusForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(MigrationsGetStatusForAuthenticatedUserError::Status304),
                403 => Err(MigrationsGetStatusForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsGetStatusForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsGetStatusForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization migration status
    ///
    /// Fetches the status of a migration.
    /// 
    /// The `state` of a migration can be one of the following values:
    /// 
    /// *   `pending`, which means the migration hasn't started yet.
    /// *   `exporting`, which means the migration is in progress.
    /// *   `exported`, which means the migration finished successfully.
    /// *   `failed`, which means the migration failed.
    /// 
    /// [GitHub API docs for get_status_for_org](https://docs.github.com/rest/reference/migrations#get-an-organization-migration-status)
    ///
    /// The `get_status_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn get_status_for_org_async(&self, org: &str, migration_id: i32, query_params: Option<impl Into<MigrationsGetStatusForOrgParams>>) -> Result<Migration, MigrationsGetStatusForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations/{}", super::GITHUB_BASE_API_URL, org, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetStatusForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsGetStatusForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization migration status
    ///
    /// Fetches the status of a migration.
    /// 
    /// The `state` of a migration can be one of the following values:
    /// 
    /// *   `pending`, which means the migration hasn't started yet.
    /// *   `exporting`, which means the migration is in progress.
    /// *   `exported`, which means the migration finished successfully.
    /// *   `failed`, which means the migration failed.
    /// 
    /// [GitHub API docs for get_status_for_org](https://docs.github.com/rest/reference/migrations#get-an-organization-migration-status)
    ///
    /// The `get_status_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn get_status_for_org(&self, org: &str, migration_id: i32, query_params: Option<impl Into<MigrationsGetStatusForOrgParams>>) -> Result<Migration, MigrationsGetStatusForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations/{}", super::GITHUB_BASE_API_URL, org, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsGetStatusForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsGetStatusForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsGetStatusForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user migrations
    ///
    /// Lists all migrations a user has started.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/migrations#list-user-migrations)
    ///
    /// The `list_for_authenticated_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<MigrationsListForAuthenticatedUserParams>>) -> Result<Vec<Migration>, MigrationsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/migrations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(MigrationsListForAuthenticatedUserError::Status304),
                403 => Err(MigrationsListForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsListForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user migrations
    ///
    /// Lists all migrations a user has started.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/migrations#list-user-migrations)
    ///
    /// The `list_for_authenticated_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<MigrationsListForAuthenticatedUserParams>>) -> Result<Vec<Migration>, MigrationsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/migrations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(MigrationsListForAuthenticatedUserError::Status304),
                403 => Err(MigrationsListForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsListForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization migrations
    ///
    /// Lists the most recent migrations.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/migrations#list-organization-migrations)
    ///
    /// The `list_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn list_for_org_async(&self, org: &str, query_params: Option<impl Into<MigrationsListForOrgParams>>) -> Result<Vec<Migration>, MigrationsListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization migrations
    ///
    /// Lists the most recent migrations.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/migrations#list-organization-migrations)
    ///
    /// The `list_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn list_for_org(&self, org: &str, query_params: Option<impl Into<MigrationsListForOrgParams>>) -> Result<Vec<Migration>, MigrationsListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsListForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories in an organization migration
    ///
    /// List all the repositories for this organization migration.
    /// 
    /// [GitHub API docs for list_repos_for_org](https://docs.github.com/rest/reference/migrations#list-repositories-in-an-organization-migration)
    ///
    /// The `list_repos_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn list_repos_for_org_async(&self, org: &str, migration_id: i32, query_params: Option<impl Into<MigrationsListReposForOrgParams>>) -> Result<Vec<MinimalRepository>, MigrationsListReposForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations/{}/repositories", super::GITHUB_BASE_API_URL, org, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsListReposForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsListReposForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories in an organization migration
    ///
    /// List all the repositories for this organization migration.
    /// 
    /// [GitHub API docs for list_repos_for_org](https://docs.github.com/rest/reference/migrations#list-repositories-in-an-organization-migration)
    ///
    /// The `list_repos_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn list_repos_for_org(&self, org: &str, migration_id: i32, query_params: Option<impl Into<MigrationsListReposForOrgParams>>) -> Result<Vec<MinimalRepository>, MigrationsListReposForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/migrations/{}/repositories", super::GITHUB_BASE_API_URL, org, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsListReposForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsListReposForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsListReposForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for a user migration
    ///
    /// Lists all the repositories for this user migration.
    /// 
    /// [GitHub API docs for list_repos_for_user](https://docs.github.com/rest/reference/migrations#list-repositories-for-a-user-migration)
    ///
    /// The `list_repos_for_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn list_repos_for_user_async(&self, migration_id: i32, query_params: Option<impl Into<MigrationsListReposForUserParams>>) -> Result<Vec<MinimalRepository>, MigrationsListReposForUserError> {

        let mut request_uri = format!("{}/user/migrations/{}/repositories", super::GITHUB_BASE_API_URL, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsListReposForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsListReposForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for a user migration
    ///
    /// Lists all the repositories for this user migration.
    /// 
    /// [GitHub API docs for list_repos_for_user](https://docs.github.com/rest/reference/migrations#list-repositories-for-a-user-migration)
    ///
    /// The `list_repos_for_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn list_repos_for_user(&self, migration_id: i32, query_params: Option<impl Into<MigrationsListReposForUserParams>>) -> Result<Vec<MinimalRepository>, MigrationsListReposForUserError> {

        let mut request_uri = format!("{}/user/migrations/{}/repositories", super::GITHUB_BASE_API_URL, migration_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: MigrationsListReposForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsListReposForUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsListReposForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Map a commit author
    ///
    /// Update an author's identity for the import. Your application can continue updating authors any time before you push new commits to the repository.
    /// 
    /// [GitHub API docs for map_commit_author](https://docs.github.com/rest/reference/migrations#map-a-commit-author)
    ///
    /// ---
    pub async fn map_commit_author_async(&self, owner: &str, repo: &str, author_id: i32, body: PatchMigrationsMapCommitAuthor) -> Result<PorterAuthor, MigrationsMapCommitAuthorError> {

        let request_uri = format!("{}/repos/{}/{}/import/authors/{}", super::GITHUB_BASE_API_URL, owner, repo, author_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsMapCommitAuthor::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsMapCommitAuthorError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(MigrationsMapCommitAuthorError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsMapCommitAuthorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Map a commit author
    ///
    /// Update an author's identity for the import. Your application can continue updating authors any time before you push new commits to the repository.
    /// 
    /// [GitHub API docs for map_commit_author](https://docs.github.com/rest/reference/migrations#map-a-commit-author)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn map_commit_author(&self, owner: &str, repo: &str, author_id: i32, body: PatchMigrationsMapCommitAuthor) -> Result<PorterAuthor, MigrationsMapCommitAuthorError> {

        let request_uri = format!("{}/repos/{}/{}/import/authors/{}", super::GITHUB_BASE_API_URL, owner, repo, author_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsMapCommitAuthor::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsMapCommitAuthorError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(MigrationsMapCommitAuthorError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsMapCommitAuthorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update Git LFS preference
    ///
    /// You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability is powered by [Git LFS](https://git-lfs.github.com). You can learn more about our LFS feature and working with large files [on our help site](https://help.github.com/articles/versioning-large-files/).
    /// 
    /// [GitHub API docs for set_lfs_preference](https://docs.github.com/rest/reference/migrations#update-git-lfs-preference)
    ///
    /// ---
    pub async fn set_lfs_preference_async(&self, owner: &str, repo: &str, body: PatchMigrationsSetLfsPreference) -> Result<Import, MigrationsSetLfsPreferenceError> {

        let request_uri = format!("{}/repos/{}/{}/import/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsSetLfsPreference::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsSetLfsPreferenceError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsSetLfsPreferenceError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update Git LFS preference
    ///
    /// You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability is powered by [Git LFS](https://git-lfs.github.com). You can learn more about our LFS feature and working with large files [on our help site](https://help.github.com/articles/versioning-large-files/).
    /// 
    /// [GitHub API docs for set_lfs_preference](https://docs.github.com/rest/reference/migrations#update-git-lfs-preference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_lfs_preference(&self, owner: &str, repo: &str, body: PatchMigrationsSetLfsPreference) -> Result<Import, MigrationsSetLfsPreferenceError> {

        let request_uri = format!("{}/repos/{}/{}/import/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsSetLfsPreference::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsSetLfsPreferenceError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsSetLfsPreferenceError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start a user migration
    ///
    /// Initiates the generation of a user migration archive.
    /// 
    /// [GitHub API docs for start_for_authenticated_user](https://docs.github.com/rest/reference/migrations#start-a-user-migration)
    ///
    /// ---
    pub async fn start_for_authenticated_user_async(&self, body: PostMigrationsStartForAuthenticatedUser) -> Result<Migration, MigrationsStartForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMigrationsStartForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsStartForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(MigrationsStartForAuthenticatedUserError::Status304),
                403 => Err(MigrationsStartForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsStartForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsStartForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start a user migration
    ///
    /// Initiates the generation of a user migration archive.
    /// 
    /// [GitHub API docs for start_for_authenticated_user](https://docs.github.com/rest/reference/migrations#start-a-user-migration)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn start_for_authenticated_user(&self, body: PostMigrationsStartForAuthenticatedUser) -> Result<Migration, MigrationsStartForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMigrationsStartForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsStartForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(MigrationsStartForAuthenticatedUserError::Status304),
                403 => Err(MigrationsStartForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsStartForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsStartForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start an organization migration
    ///
    /// Initiates the generation of a migration archive.
    /// 
    /// [GitHub API docs for start_for_org](https://docs.github.com/rest/reference/migrations#start-an-organization-migration)
    ///
    /// ---
    pub async fn start_for_org_async(&self, org: &str, body: PostMigrationsStartForOrg) -> Result<Migration, MigrationsStartForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMigrationsStartForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsStartForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(MigrationsStartForOrgError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsStartForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start an organization migration
    ///
    /// Initiates the generation of a migration archive.
    /// 
    /// [GitHub API docs for start_for_org](https://docs.github.com/rest/reference/migrations#start-an-organization-migration)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn start_for_org(&self, org: &str, body: PostMigrationsStartForOrg) -> Result<Migration, MigrationsStartForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMigrationsStartForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsStartForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(MigrationsStartForOrgError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsStartForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start an import
    ///
    /// Start a source import to a GitHub repository using GitHub Importer.
    /// 
    /// [GitHub API docs for start_import](https://docs.github.com/rest/reference/migrations#start-an-import)
    ///
    /// ---
    pub async fn start_import_async(&self, owner: &str, repo: &str, body: PutMigrationsStartImport) -> Result<Import, MigrationsStartImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutMigrationsStartImport::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsStartImportError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(MigrationsStartImportError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsStartImportError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start an import
    ///
    /// Start a source import to a GitHub repository using GitHub Importer.
    /// 
    /// [GitHub API docs for start_import](https://docs.github.com/rest/reference/migrations#start-an-import)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn start_import(&self, owner: &str, repo: &str, body: PutMigrationsStartImport) -> Result<Import, MigrationsStartImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutMigrationsStartImport::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(MigrationsStartImportError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(MigrationsStartImportError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsStartImportError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock a user repository
    ///
    /// Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/reference/migrations#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/reference/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
    /// 
    /// [GitHub API docs for unlock_repo_for_authenticated_user](https://docs.github.com/rest/reference/migrations#unlock-a-user-repository)
    ///
    /// The `unlock_repo_for_authenticated_user_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn unlock_repo_for_authenticated_user_async(&self, migration_id: i32, repo_name: &str) -> Result<(), MigrationsUnlockRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/repos/{}/lock", super::GITHUB_BASE_API_URL, migration_id, repo_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status304),
                404 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsUnlockRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock a user repository
    ///
    /// Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/reference/migrations#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/reference/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
    /// 
    /// [GitHub API docs for unlock_repo_for_authenticated_user](https://docs.github.com/rest/reference/migrations#unlock-a-user-repository)
    ///
    /// The `unlock_repo_for_authenticated_user` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn unlock_repo_for_authenticated_user(&self, migration_id: i32, repo_name: &str) -> Result<(), MigrationsUnlockRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/migrations/{}/repos/{}/lock", super::GITHUB_BASE_API_URL, migration_id, repo_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status304),
                404 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(MigrationsUnlockRepoForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsUnlockRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock an organization repository
    ///
    /// Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/reference/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
    /// 
    /// [GitHub API docs for unlock_repo_for_org](https://docs.github.com/rest/reference/migrations#unlock-an-organization-repository)
    ///
    /// The `unlock_repo_for_org_async` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(feature = "wyandotte")]
    pub async fn unlock_repo_for_org_async(&self, org: &str, migration_id: i32, repo_name: &str) -> Result<(), MigrationsUnlockRepoForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/repos/{}/lock", super::GITHUB_BASE_API_URL, org, migration_id, repo_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsUnlockRepoForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(MigrationsUnlockRepoForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unlock an organization repository
    ///
    /// Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/reference/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
    /// 
    /// [GitHub API docs for unlock_repo_for_org](https://docs.github.com/rest/reference/migrations#unlock-an-organization-repository)
    ///
    /// The `unlock_repo_for_org` endpoint is enabled with the `wyandotte` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "wyandotte")]
    pub fn unlock_repo_for_org(&self, org: &str, migration_id: i32, repo_name: &str) -> Result<(), MigrationsUnlockRepoForOrgError> {

        let request_uri = format!("{}/orgs/{}/migrations/{}/repos/{}/lock", super::GITHUB_BASE_API_URL, org, migration_id, repo_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![("Accept", "application/vnd.github.wyandotte-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(MigrationsUnlockRepoForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(MigrationsUnlockRepoForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an import
    ///
    /// An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
    /// request. If no parameters are provided, the import will be restarted.
    /// 
    /// [GitHub API docs for update_import](https://docs.github.com/rest/reference/migrations#update-an-import)
    ///
    /// ---
    pub async fn update_import_async(&self, owner: &str, repo: &str, body: PatchMigrationsUpdateImport) -> Result<Import, MigrationsUpdateImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsUpdateImport::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsUpdateImportError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an import
    ///
    /// An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
    /// request. If no parameters are provided, the import will be restarted.
    /// 
    /// [GitHub API docs for update_import](https://docs.github.com/rest/reference/migrations#update-an-import)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_import(&self, owner: &str, repo: &str, body: PatchMigrationsUpdateImport) -> Result<Import, MigrationsUpdateImportError> {

        let request_uri = format!("{}/repos/{}/{}/import", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchMigrationsUpdateImport::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(MigrationsUpdateImportError::Generic { code }),
            }
        }
    }

}
