//! Method, error and parameter types for the Markdown endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Markdown<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Markdown {
    Markdown { auth }
}

/// Errors for the [Render a Markdown document](Markdown::render_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MarkdownRenderError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Render a Markdown document in raw mode](Markdown::render_raw_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum MarkdownRenderRawError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}



impl<'api> Markdown<'api> {
    /// ---
    ///
    /// # Render a Markdown document
    /// 
    /// [GitHub API docs for render](https://docs.github.com/rest/reference/markdown/#render-a-markdown-document)
    ///
    /// ---
    pub async fn render_async(&self, body: PostMarkdownRender) -> Result<String, MarkdownRenderError> {

        let request_uri = format!("{}/markdown", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMarkdownRender::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(MarkdownRenderError::Status304),
                code => Err(MarkdownRenderError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Render a Markdown document
    /// 
    /// [GitHub API docs for render](https://docs.github.com/rest/reference/markdown/#render-a-markdown-document)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn render(&self, body: PostMarkdownRender) -> Result<String, MarkdownRenderError> {

        let request_uri = format!("{}/markdown", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostMarkdownRender::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(MarkdownRenderError::Status304),
                code => Err(MarkdownRenderError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    /// 
    /// [GitHub API docs for render_raw](https://docs.github.com/rest/reference/markdown/#render-a-markdown-document-in-raw-mode)
    ///
    /// ---
    pub async fn render_raw_async(&self, body: String) -> Result<String, MarkdownRenderRawError> {

        let request_uri = format!("{}/markdown/raw", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(String::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(MarkdownRenderRawError::Status304),
                code => Err(MarkdownRenderRawError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    /// 
    /// [GitHub API docs for render_raw](https://docs.github.com/rest/reference/markdown/#render-a-markdown-document-in-raw-mode)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn render_raw(&self, body: String) -> Result<String, MarkdownRenderRawError> {

        let request_uri = format!("{}/markdown/raw", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(String::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(MarkdownRenderRawError::Status304),
                code => Err(MarkdownRenderRawError::Generic { code }),
            }
        }
    }

}
