//! Method, error and parameter types for the Gitignore endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Gitignore<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Gitignore {
    Gitignore { auth }
}

/// Errors for the [Get all gitignore templates](Gitignore::get_all_templates_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitignoreGetAllTemplatesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a gitignore template](Gitignore::get_template_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum GitignoreGetTemplateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}



impl<'api> Gitignore<'api> {
    /// ---
    ///
    /// # Get all gitignore templates
    ///
    /// List all templates available to pass as an option when [creating a repository](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user).
    /// 
    /// [GitHub API docs for get_all_templates](https://docs.github.com/rest/reference/gitignore/#get-all-gitignore-templates)
    ///
    /// ---
    pub async fn get_all_templates_async(&self) -> Result<Vec<String>, GitignoreGetAllTemplatesError> {

        let request_uri = format!("{}/gitignore/templates", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GitignoreGetAllTemplatesError::Status304),
                code => Err(GitignoreGetAllTemplatesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all gitignore templates
    ///
    /// List all templates available to pass as an option when [creating a repository](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user).
    /// 
    /// [GitHub API docs for get_all_templates](https://docs.github.com/rest/reference/gitignore/#get-all-gitignore-templates)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_templates(&self) -> Result<Vec<String>, GitignoreGetAllTemplatesError> {

        let request_uri = format!("{}/gitignore/templates", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GitignoreGetAllTemplatesError::Status304),
                code => Err(GitignoreGetAllTemplatesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gitignore template
    ///
    /// The API also allows fetching the source of a single template.
    /// Use the raw [media type](https://docs.github.com/rest/overview/media-types/) to get the raw contents.
    /// 
    /// [GitHub API docs for get_template](https://docs.github.com/rest/reference/gitignore/#get-a-gitignore-template)
    ///
    /// ---
    pub async fn get_template_async(&self, name: &str) -> Result<GitignoreTemplate, GitignoreGetTemplateError> {

        let request_uri = format!("{}/gitignore/templates/{}", super::GITHUB_BASE_API_URL, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(GitignoreGetTemplateError::Status304),
                code => Err(GitignoreGetTemplateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a gitignore template
    ///
    /// The API also allows fetching the source of a single template.
    /// Use the raw [media type](https://docs.github.com/rest/overview/media-types/) to get the raw contents.
    /// 
    /// [GitHub API docs for get_template](https://docs.github.com/rest/reference/gitignore/#get-a-gitignore-template)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_template(&self, name: &str) -> Result<GitignoreTemplate, GitignoreGetTemplateError> {

        let request_uri = format!("{}/gitignore/templates/{}", super::GITHUB_BASE_API_URL, name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(GitignoreGetTemplateError::Status304),
                code => Err(GitignoreGetTemplateError::Generic { code }),
            }
        }
    }

}
