#![allow(unused_imports, unused_qualifications, unused_extern_crates)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::ser::Serializer;
use serde::de::{DeserializeOwned, Deserializer};
use serde::Deserialize;
use serde_json::value::Value;

use std::cmp::Eq;
use std::collections::HashMap;
use std::default::Default;
use std::fmt::{self, Formatter, Display};
use std::hash::Hash;

use chrono::DateTime;
use chrono::Utc;

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsBillingUsage {     
    /// The sum of the free and paid GitHub Actions minutes used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_minutes_used: Option<i64>,
    /// The total paid GitHub Actions minutes used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_paid_minutes_used: Option<i64>,
    /// The amount of free GitHub Actions minutes available.
    #[serde(skip_serializing_if="Option::is_none")]
    pub included_minutes: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub minutes_used_breakdown: Option<ActionsbillingusageMinutesUsedBreakdown>,
}

/// Whether GitHub Actions is enabled on the repository.
pub type ActionsEnabled = bool;

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsEnterprisePermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled_organizations: Option<EnabledOrganizations>,
    /// The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_actions_url: Option<SelectedActionsUrl>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsOrganizationPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled_repositories: Option<EnabledRepositories>,
    /// The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_actions_url: Option<SelectedActionsUrl>,
}

/// The public key used for setting Actions Secrets.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsPublicKey {     
    /// The identifier for the key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    /// The Base64 encoded public key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsRepositoryPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<ActionsEnabled>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_actions_url: Option<SelectedActionsUrl>,
}

/// Set secrets for GitHub Actions.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsSecret {     
    /// The name of the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ActionsbillingusageMinutesUsedBreakdown {     
    /// Total minutes used on Ubuntu runner machines.
    #[serde(rename = "UBUNTU")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub ubuntu: Option<i64>,
    /// Total minutes used on macOS runner machines.
    #[serde(rename = "MACOS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub macos: Option<i64>,
    /// Total minutes used on Windows runner machines.
    #[serde(rename = "WINDOWS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub windows: Option<i64>,
}

/// Actor
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Actor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
}

/// Added to Project Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AddedToProjectIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_card: Option<AddedtoprojectissueeventProjectCard>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AddedtoprojectissueeventProjectCard {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub column_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_column_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AdvancedSecurityActiveCommitters {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_advanced_security_committers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<AdvancedSecurityActiveCommittersRepository>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AdvancedSecurityActiveCommittersRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub advanced_security_committers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub advanced_security_committers_breakdown: Option<Vec<AdvancedSecurityActiveCommittersUser>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AdvancedSecurityActiveCommittersUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_pushed_date: Option<String>,
}

/// The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
pub type AlertCreatedAt = DateTime<Utc>;

/// The GitHub URL of the alert resource.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AlertHtmlUrl {     
}

/// The REST API URL for fetching the list of instances for an alert.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AlertInstancesUrl {     
}

/// The security alert number.
pub type AlertNumber = i32;

/// The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
pub type AlertUpdatedAt = DateTime<Utc>;

/// The REST API URL of the alert resource.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AlertUrl {     
}

/// The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum AllowedActions { 
    #[serde(rename = "all")]
    ALL,
    #[serde(rename = "local_only")]
    LOCAL_ONLY,
    #[serde(rename = "selected")]
    SELECTED,
}

impl Display for AllowedActions {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            AllowedActions::ALL => write!(f, "{}", "all"),
            AllowedActions::LOCAL_ONLY => write!(f, "{}", "local_only"),
            AllowedActions::SELECTED => write!(f, "{}", "selected"),
        }
    }
}

impl std::str::FromStr for AllowedActions {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "all" => Ok(AllowedActions::ALL),
            "local_only" => Ok(AllowedActions::LOCAL_ONLY),
            "selected" => Ok(AllowedActions::SELECTED),
            _ => Err(()),
        }
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposUpdateInformationAboutPagesSiteSourceEnum { 
    PutReposUpdateInformationAboutPagesSiteSourceEnumVariant0(String),
    PutReposUpdateInformationAboutPagesSiteSourceEnumVariant1(HashMap<String, Value>),
}

impl From<String> for PutReposUpdateInformationAboutPagesSiteSourceEnum {
    fn from(value: String) -> Self {
        PutReposUpdateInformationAboutPagesSiteSourceEnum::PutReposUpdateInformationAboutPagesSiteSourceEnumVariant0(value)
    }
}

impl From<HashMap<String, Value>> for PutReposUpdateInformationAboutPagesSiteSourceEnum {
    fn from(value: HashMap<String, Value>) -> Self {
        PutReposUpdateInformationAboutPagesSiteSourceEnum::PutReposUpdateInformationAboutPagesSiteSourceEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum EnvironmentProtectionRulesItems { 
    EnvironmentProtectionRulesItemsVariant0(HashMap<String, Value>),
}

impl From<HashMap<String, Value>> for EnvironmentProtectionRulesItems {
    fn from(value: HashMap<String, Value>) -> Self {
        EnvironmentProtectionRulesItems::EnvironmentProtectionRulesItemsVariant0(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InstallationAccount { 
    InstallationAccountVariant0(SimpleUser),
    InstallationAccountVariant1(Enterprise),
}

impl From<SimpleUser> for InstallationAccount {
    fn from(value: SimpleUser) -> Self {
        InstallationAccount::InstallationAccountVariant0(value)
    }
}

impl From<Enterprise> for InstallationAccount {
    fn from(value: Enterprise) -> Self {
        InstallationAccount::InstallationAccountVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PendingdeploymentReviewersReviewer { 
    PendingdeploymentReviewersReviewerVariant0(SimpleUser),
    PendingdeploymentReviewersReviewerVariant1(Team),
}

impl From<SimpleUser> for PendingdeploymentReviewersReviewer {
    fn from(value: SimpleUser) -> Self {
        PendingdeploymentReviewersReviewer::PendingdeploymentReviewersReviewerVariant0(value)
    }
}

impl From<Team> for PendingdeploymentReviewersReviewer {
    fn from(value: Team) -> Self {
        PendingdeploymentReviewersReviewer::PendingdeploymentReviewersReviewerVariant1(value)
    }
}

/// Api Overview
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ApiOverview {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub verifiable_password_authentication: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_key_fingerprints: Option<ApioverviewSshKeyFingerprints>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub web: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub api: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub packages: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pages: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub importer: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actions: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dependabot: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ApioverviewSshKeyFingerprints {     
    #[serde(rename = "SHA256_RSA")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha256_rsa: Option<String>,
    #[serde(rename = "SHA256_DSA")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha256_dsa: Option<String>,
    #[serde(rename = "SHA256_ECDSA")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha256_ecdsa: Option<String>,
    #[serde(rename = "SHA256_ED25519")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha256_ed25519: Option<String>,
}

/// The permissions granted to the user-to-server access token.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AppPermissions {     
    /// The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub actions: Option<String>,
    /// The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub administration: Option<String>,
    /// The level of permission to grant the access token for checks on code. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<String>,
    /// The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents: Option<String>,
    /// The level of permission to grant the access token for deployments and deployment statuses. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments: Option<String>,
    /// The level of permission to grant the access token for managing repository environments. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environments: Option<String>,
    /// The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues: Option<String>,
    /// The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub metadata: Option<String>,
    /// The level of permission to grant the access token for packages published to GitHub Packages. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub packages: Option<String>,
    /// The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pages: Option<String>,
    /// The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_requests: Option<String>,
    /// The level of permission to grant the access token to manage the post-receive hooks for a repository. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_hooks: Option<String>,
    /// The level of permission to grant the access token to manage repository projects, columns, and cards. Can be one of: `read`, `write`, or `admin`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_projects: Option<String>,
    /// The level of permission to grant the access token to view and manage secret scanning alerts. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret_scanning_alerts: Option<String>,
    /// The level of permission to grant the access token to manage repository secrets. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secrets: Option<String>,
    /// The level of permission to grant the access token to view and manage security events like code scanning alerts. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_events: Option<String>,
    /// The level of permission to grant the access token to manage just a single file. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file: Option<String>,
    /// The level of permission to grant the access token for commit statuses. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses: Option<String>,
    /// The level of permission to grant the access token to manage Dependabot alerts. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vulnerability_alerts: Option<String>,
    /// The level of permission to grant the access token to update GitHub Actions workflow files. Can be one of: `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub workflows: Option<String>,
    /// The level of permission to grant the access token for organization teams and members. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<String>,
    /// The level of permission to grant the access token to manage access to an organization. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_administration: Option<String>,
    /// The level of permission to grant the access token to manage the post-receive hooks for an organization. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_hooks: Option<String>,
    /// The level of permission to grant the access token for viewing an organization's plan. Can be one of: `read`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_plan: Option<String>,
    /// The level of permission to grant the access token to manage organization projects and projects beta (where available). Can be one of: `read`, `write`, or `admin`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_projects: Option<String>,
    /// The level of permission to grant the access token for organization packages published to GitHub Packages. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_packages: Option<String>,
    /// The level of permission to grant the access token to manage organization secrets. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_secrets: Option<String>,
    /// The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_self_hosted_runners: Option<String>,
    /// The level of permission to grant the access token to view and manage users blocked by the organization. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_user_blocking: Option<String>,
    /// The level of permission to grant the access token to manage team discussions and related comments. Can be one of: `read` or `write`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_discussions: Option<String>,
}

/// The authorization associated with an OAuth Access.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ApplicationGrant {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app: Option<ApplicationgrantApp>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ApplicationgrantApp {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// An artifact
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Artifact {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the artifact.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The size in bytes of the artifact.
    #[serde(skip_serializing_if="Option::is_none")]
    pub size_in_bytes: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_download_url: Option<String>,
    /// Whether or not the artifact has expired.
    #[serde(skip_serializing_if="Option::is_none")]
    pub expired: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Assigned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AssignedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<Integration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assigner: Option<SimpleUser>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AuditLogEvent {     
    /// The time the audit log event occurred, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
    #[serde(rename = "@timestamp")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub timestamp: Option<i64>,
    /// The name of the action that was performed, for example `user.login` or `repo.create`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub action: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_was: Option<bool>,
    /// The actor who performed the action.
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<String>,
    /// The id of the actor who performed the action.
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor_location: Option<AuditlogeventActorLocation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub data: Option<HashMap<String, HashMap<String, Value>>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub org_id: Option<i64>,
    /// The username of the account being blocked.
    #[serde(skip_serializing_if="Option::is_none")]
    pub blocked_user: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub business: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config_was: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<String>,
    /// The time the audit log event was recorded, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deploy_key_fingerprint: Option<String>,
    /// A unique identifier for an audit event.
    #[serde(skip_serializing_if="Option::is_none")]
    pub _document_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emoji: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_were: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub explanation: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hook_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub limited_availability: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub old_user: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub openssh_public_key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub org: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub read_only: Option<bool>,
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<String>,
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub team: Option<String>,
    /// The type of protocol (for example, HTTP or SSH) used to transfer Git data.
    #[serde(skip_serializing_if="Option::is_none")]
    pub transport_protocol: Option<i64>,
    /// A human readable name for the protocol (for example, HTTP or SSH) used to transfer Git data.
    #[serde(skip_serializing_if="Option::is_none")]
    pub transport_protocol_name: Option<String>,
    /// The user that was affected by the action performed (if available).
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<String>,
    /// The repository visibility, for example `public` or `private`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AuditlogeventActorLocation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub country_name: Option<String>,
}

/// Authentication Token
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AuthenticationToken {     
    /// The token used for authentication
    #[serde(skip_serializing_if="Option::is_none")]
    pub token: Option<String>,
    /// The time this token expires
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<HashMap<String, Value>>,
    /// The repositories this token has access to
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file: Option<String>,
    /// Describe whether all repositories have been selected or there's a selection involved
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
}

/// How the author is associated with the repository.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum AuthorAssociation { 
    #[serde(rename = "COLLABORATOR")]
    COLLABORATOR,
    #[serde(rename = "CONTRIBUTOR")]
    CONTRIBUTOR,
    #[serde(rename = "FIRST_TIMER")]
    FIRST_TIMER,
    #[serde(rename = "FIRST_TIME_CONTRIBUTOR")]
    FIRST_TIME_CONTRIBUTOR,
    #[serde(rename = "MANNEQUIN")]
    MANNEQUIN,
    #[serde(rename = "MEMBER")]
    MEMBER,
    #[serde(rename = "NONE")]
    NONE,
    #[serde(rename = "OWNER")]
    OWNER,
}

impl Display for AuthorAssociation {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            AuthorAssociation::COLLABORATOR => write!(f, "{}", "COLLABORATOR"),
            AuthorAssociation::CONTRIBUTOR => write!(f, "{}", "CONTRIBUTOR"),
            AuthorAssociation::FIRST_TIMER => write!(f, "{}", "FIRST_TIMER"),
            AuthorAssociation::FIRST_TIME_CONTRIBUTOR => write!(f, "{}", "FIRST_TIME_CONTRIBUTOR"),
            AuthorAssociation::MANNEQUIN => write!(f, "{}", "MANNEQUIN"),
            AuthorAssociation::MEMBER => write!(f, "{}", "MEMBER"),
            AuthorAssociation::NONE => write!(f, "{}", "NONE"),
            AuthorAssociation::OWNER => write!(f, "{}", "OWNER"),
        }
    }
}

impl std::str::FromStr for AuthorAssociation {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "COLLABORATOR" => Ok(AuthorAssociation::COLLABORATOR),
            "CONTRIBUTOR" => Ok(AuthorAssociation::CONTRIBUTOR),
            "FIRST_TIMER" => Ok(AuthorAssociation::FIRST_TIMER),
            "FIRST_TIME_CONTRIBUTOR" => Ok(AuthorAssociation::FIRST_TIME_CONTRIBUTOR),
            "MANNEQUIN" => Ok(AuthorAssociation::MANNEQUIN),
            "MEMBER" => Ok(AuthorAssociation::MEMBER),
            "NONE" => Ok(AuthorAssociation::NONE),
            "OWNER" => Ok(AuthorAssociation::OWNER),
            _ => Err(()),
        }
    }
}

/// The authorization for an OAuth app, GitHub App, or a Personal Access Token.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Authorization {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// A list of scopes that this authorization is in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub token_last_eight: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hashed_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app: Option<ApplicationgrantApp>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub note_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub installation: Option<NullableScopedInstallation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// The status of auto merging a pull request.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct AutoMerge {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled_by: Option<SimpleUser>,
    /// The merge method to use.
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_method: Option<String>,
    /// Title for the merge commit message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_title: Option<String>,
    /// Commit message for the merge commit.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_message: Option<String>,
}

/// An autolink reference.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Autolink {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The prefix of a key that is linkified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_prefix: Option<String>,
    /// A template for the target URL that is generated if a key was found.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url_template: Option<String>,
}

/// Base Gist
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BaseGist {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_pull_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_push_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<HashMap<String, BasegistFiles>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub truncated: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub history: Option<Vec<Value>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BasegistFiles {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub filename: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
}

/// Basic Error
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BasicError {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
}

/// Blob
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Blob {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub encoding: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub highlighted_content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchAppsUpdateWebhookConfigForApp {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostAppsCreateInstallationAccessToken {     
    /// List of repository names that the token should have access to
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<String>>,
    /// List of repository IDs that the token should have access to
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_ids: Option<Vec<i32>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<AppPermissions>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchOauthAuthorizationsUpdateAuthorization {     
    /// A list of scopes that this authorization is in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    /// A list of scopes to add to this authorization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub add_scopes: Option<Vec<String>>,
    /// A list of scopes to remove from this authorization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub remove_scopes: Option<Vec<String>>,
    /// A note to remind you what the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    /// A URL to remind you what app the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note_url: Option<String>,
    /// A unique string to distinguish an authorization from others created for the same client ID and user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateCommitComment {     
    /// The contents of the comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Relative path of the file to comment on.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// Line index in the diff to comment on.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    /// **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutReposCreateOrUpdateFileContents {     
    /// The commit message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    /// The new file content, using Base64 encoding.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    /// **Required if you are updating a file**. The blob SHA of the file being replaced.
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// The branch name. Default: the repository’s default branch (usually `master`)
    #[serde(skip_serializing_if="Option::is_none")]
    pub branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<ReposownerrepocontentspathCommitter>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<ReposownerrepocontentspathAuthor>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeleteReposDeleteFile {     
    /// The commit message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    /// The blob SHA of the file being replaced.
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// The branch name. Default: the repository’s default branch (usually `master`)
    #[serde(skip_serializing_if="Option::is_none")]
    pub branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<ReposownerrepocontentspathCommitter1>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<ReposownerrepocontentspathAuthor1>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateDeployment {     
    /// The ref to deploy. This can be a branch, tag, or SHA.
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    /// Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
    #[serde(skip_serializing_if="Option::is_none")]
    pub task: Option<String>,
    /// Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_merge: Option<bool>,
    /// The [status](https://docs.github.com/rest/reference/repos#statuses) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_contexts: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<PostReposCreateDeploymentPayloadEnum>,
    /// Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<String>,
    /// Short description of the deployment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
    #[serde(skip_serializing_if="Option::is_none")]
    pub transient_environment: Option<bool>,
    /// Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
    #[serde(skip_serializing_if="Option::is_none")]
    pub production_environment: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateDeploymentStatus {     
    /// The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued`, `pending`, or `success`. When you set a transient deployment to `inactive`, the deployment will be shown as `destroyed` in GitHub.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_url: Option<String>,
    /// The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `\"\"`
    #[serde(skip_serializing_if="Option::is_none")]
    pub log_url: Option<String>,
    /// A short description of the status. The maximum description length is 140 characters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<String>,
    /// Sets the URL for accessing your environment. Default: `\"\"`
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment_url: Option<String>,
    /// Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_inactive: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateDispatchEvent {     
    /// A custom webhook event name.
    #[serde(skip_serializing_if="Option::is_none")]
    pub event_type: Option<String>,
    /// JSON payload with extra information about the webhook event that your action or worklow may use.
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_payload: Option<HashMap<String, HashMap<String, Value>>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutReposCreateOrUpdateEnvironment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub wait_timer: Option<WaitTimer>,
    /// The people or teams that may review jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub reviewers: Option<Vec<ReposownerrepoenvironmentsenvironmentNameReviewers>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployment_branch_policy: Option<DeploymentBranchPolicy>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateFork {     
    /// Optional parameter to specify the organization name if forking into an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGitCreateBlob {     
    /// The new blob's content.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    /// The encoding used for `content`. Currently, `\"utf-8\"` and `\"base64\"` are supported.
    #[serde(skip_serializing_if="Option::is_none")]
    pub encoding: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGitCreateCommit {     
    /// The commit message
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    /// The SHA of the tree object this commit points to
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<String>,
    /// The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<ReposownerrepogitcommitsAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<ReposownerrepogitcommitsCommitter>,
    /// The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
    #[serde(skip_serializing_if="Option::is_none")]
    pub signature: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetGithubActionsPermissionsEnterprise {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled_organizations: Option<EnabledOrganizations>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGitCreateRef {     
    /// The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    /// The SHA1 value for this reference.
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchGitUpdateRef {     
    /// The SHA1 value to set this reference to
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
    #[serde(skip_serializing_if="Option::is_none")]
    pub force: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGitCreateTag {     
    /// The tag's name. This is typically a version (e.g., \"v0.0.1\").
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag: Option<String>,
    /// The tag message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    /// The SHA of the git object this is tagging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub object: Option<String>,
    /// The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tagger: Option<ReposownerrepogittagsTagger>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGitCreateTree {     
    /// Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<Vec<ReposownerrepogittreesTree>>,
    /// The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you're creating new changes on a branch, then normally you'd set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you're working on. If not provided, GitHub will create a new Git tree object from only the entries defined in the `tree` parameter. If you create a new commit pointing to such a tree, then all files which were a part of the parent commit's tree and were not defined in the `tree` parameter will be listed as deleted by the new commit. 
    #[serde(skip_serializing_if="Option::is_none")]
    pub base_tree: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateWebhook {     
    /// Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<ReposownerrepohooksConfig>,
    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateWebhook {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<ReposownerrepohookshookIdConfig>,
    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. This replaces the entire array of events.
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// Determines a list of events to be added to the list of events that the Hook triggers for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub add_events: Option<Vec<String>>,
    /// Determines a list of events to be removed from the list of events that the Hook triggers for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub remove_events: Option<Vec<String>>,
    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateWebhookConfigForRepo {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutMigrationsStartImport {     
    /// The URL of the originating repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_url: Option<String>,
    /// The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs: Option<String>,
    /// If authentication is required, the username to provide to `vcs_url`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_username: Option<String>,
    /// If authentication is required, the password to provide to `vcs_url`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_password: Option<String>,
    /// For a tfvc import, the name of the project that is being imported.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tfvc_project: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchMigrationsUpdateImport {     
    /// The username to provide to the originating repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_username: Option<String>,
    /// The password to provide to the originating repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_password: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tfvc_project: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchMigrationsMapCommitAuthor {     
    /// The new Git author email.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// The new Git author name.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterprise {     
    /// List of organization IDs to enable for GitHub Actions.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_organization_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchMigrationsSetLfsPreference {     
    /// Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
    #[serde(skip_serializing_if="Option::is_none")]
    pub use_lfs: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateInvitation {     
    /// The permissions that the associated user will have on the repository. Valid values are `read`, `write`, `maintain`, `triage`, and `admin`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostIssuesCreate {     
    /// The title of the issue.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<PostIssuesCreateTitleEnum>,
    /// The contents of the issue.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<PostIssuesCreateMilestoneEnum>,
    /// Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<PostIssuesCreateLabelsItemsEnum>>,
    /// Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchIssuesUpdateComment {     
    /// The contents of the comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForIssueComment {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the issue comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchIssuesUpdate {     
    /// The title of the issue.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<PatchIssuesUpdateTitleEnum>,
    /// The contents of the issue.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Login for the user that this issue should be assigned to. **This field is deprecated.**
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<String>,
    /// State of the issue. Either `open` or `closed`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<PatchIssuesUpdateMilestoneEnum>,
    /// Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<PatchIssuesUpdateLabelsItemsEnum>>,
    /// Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostIssuesAddAssignees {     
    /// Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeleteIssuesRemoveAssignees {     
    /// Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostIssuesCreateComment {     
    /// The contents of the comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutIssuesSetLabels { 
    PutIssuesSetLabelsVariant0(HashMap<String, Vec<String>>),
    PutIssuesSetLabelsVariant1(Vec<String>),
    PutIssuesSetLabelsVariant2(Vec<HashMap<String, Value>>),
    PutIssuesSetLabelsVariant3(String),
}

impl From<HashMap<String, Vec<String>>> for PutIssuesSetLabels {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PutIssuesSetLabels::PutIssuesSetLabelsVariant0(value)
    }
}

impl From<Vec<String>> for PutIssuesSetLabels {
    fn from(value: Vec<String>) -> Self {
        PutIssuesSetLabels::PutIssuesSetLabelsVariant1(value)
    }
}

impl From<Vec<HashMap<String, Value>>> for PutIssuesSetLabels {
    fn from(value: Vec<HashMap<String, Value>>) -> Self {
        PutIssuesSetLabels::PutIssuesSetLabelsVariant2(value)
    }
}

impl From<String> for PutIssuesSetLabels {
    fn from(value: String) -> Self {
        PutIssuesSetLabels::PutIssuesSetLabelsVariant3(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostEnterpriseAdminCreateSelfHostedRunnerGroupForEnterprise {     
    /// Name of the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Visibility of a runner group. You can select all organizations or select individual organization. Can be one of: `all` or `selected`
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// List of organization IDs that can access the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_organization_ids: Option<Vec<i32>>,
    /// List of runner IDs to add to the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<i32>>,
    /// Whether the runner group can be used by `public` repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostIssuesAddLabels { 
    PostIssuesAddLabelsVariant0(HashMap<String, Vec<String>>),
    PostIssuesAddLabelsVariant1(Vec<String>),
    PostIssuesAddLabelsVariant2(Vec<HashMap<String, Value>>),
    PostIssuesAddLabelsVariant3(String),
}

impl From<HashMap<String, Vec<String>>> for PostIssuesAddLabels {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostIssuesAddLabels::PostIssuesAddLabelsVariant0(value)
    }
}

impl From<Vec<String>> for PostIssuesAddLabels {
    fn from(value: Vec<String>) -> Self {
        PostIssuesAddLabels::PostIssuesAddLabelsVariant1(value)
    }
}

impl From<Vec<HashMap<String, Value>>> for PostIssuesAddLabels {
    fn from(value: Vec<HashMap<String, Value>>) -> Self {
        PostIssuesAddLabels::PostIssuesAddLabelsVariant2(value)
    }
}

impl From<String> for PostIssuesAddLabels {
    fn from(value: String) -> Self {
        PostIssuesAddLabels::PostIssuesAddLabelsVariant3(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutIssuesLock {     
    /// The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:   \\* `off-topic`   \\* `too heated`   \\* `resolved`   \\* `spam`
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_reason: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForIssue {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the issue.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateDeployKey {     
    /// A name for the key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The contents of the key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    /// If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.      Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see \"[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)\" and \"[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub read_only: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostIssuesCreateLabel {     
    /// The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png \":strawberry:\"). For a full list of available emoji and codes, see \"[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    /// A short description of the label. Must be 100 characters or fewer.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchIssuesUpdateLabel {     
    /// The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png \":strawberry:\"). For a full list of available emoji and codes, see \"[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub new_name: Option<String>,
    /// The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    /// A short description of the label. Must be 100 characters or fewer.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposMergeUpstream {     
    /// The name of the branch which should be updated to match upstream.
    #[serde(skip_serializing_if="Option::is_none")]
    pub branch: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposMerge {     
    /// The name of the base branch that the head will be merged into.
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<String>,
    /// The head to merge. This can be a branch name or a commit SHA1.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head: Option<String>,
    /// Commit message to use for the merge commit. If omitted, a default message will be used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_message: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostIssuesCreateMilestone {     
    /// The title of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The state of the milestone. Either `open` or `closed`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// A description of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub due_on: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchIssuesUpdateMilestone {     
    /// The title of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The state of the milestone. Either `open` or `closed`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// A description of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub due_on: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchEnterpriseAdminUpdateSelfHostedRunnerGroupForEnterprise {     
    /// Name of the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Visibility of a runner group. You can select all organizations or select individual organizations. Can be one of: `all` or `selected`
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// Whether the runner group can be used by `public` repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActivityMarkRepoNotificationsAsRead {     
    /// Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_read_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposUpdateInformationAboutPagesSite { 
    PutReposUpdateInformationAboutPagesSiteVariant0(Value),
}

impl From<Value> for PutReposUpdateInformationAboutPagesSite {
    fn from(value: Value) -> Self {
        PutReposUpdateInformationAboutPagesSite::PutReposUpdateInformationAboutPagesSiteVariant0(value)
    }
}

impl Display for PutReposUpdateInformationAboutPagesSite {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match self { 
            PutReposUpdateInformationAboutPagesSite::PutReposUpdateInformationAboutPagesSiteVariant0(value) => write!(f, "{}", value),
        }
    }
}

/// The source branch and directory used to publish your Pages site.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreatePagesSite {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub source: Option<ReposownerrepopagesSource>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateForRepo {     
    /// The name of the project.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the project.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostPullsCreate {     
    /// The title of the new pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head: Option<String>,
    /// The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<String>,
    /// The contents of the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintainer_can_modify: Option<bool>,
    /// Indicates whether the pull request is a draft. See \"[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)\" in the GitHub Help documentation to learn more.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchPullsUpdateReviewComment {     
    /// The text of the reply to the review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForPullRequestReviewComment {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the pull request review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchPullsUpdate {     
    /// The title of the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The contents of the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// State of this Pull Request. Either `open` or `closed`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<String>,
    /// Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintainer_can_modify: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostCodespacesCreateWithPrForAuthenticatedUser {     
    /// Location for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    /// Machine type to use for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub machine: Option<String>,
    /// Working directory for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub working_directory: Option<String>,
    /// Time in minutes before codespace stops from inactivity
    #[serde(skip_serializing_if="Option::is_none")]
    pub idle_timeout_minutes: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostPullsCreateReviewComment {     
    /// The text of the review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    /// The relative path to the file that necessitates a comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// **Required without `comfort-fade` preview unless using `in_reply_to`**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    /// **Required with `comfort-fade` preview unless using `in_reply_to`**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see \"[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub side: Option<String>,
    /// **Required with `comfort-fade` preview unless using `in_reply_to`**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
    /// **Required when using multi-line comments unless using `in_reply_to`**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see \"[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    /// **Required when using multi-line comments unless using `in_reply_to`**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see \"[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation. See `side` in this table for additional context.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_side: Option<String>,
    /// The ID of the review comment to reply to. To find the ID of a review comment with [\"List review comments on a pull request\"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.
    #[serde(skip_serializing_if="Option::is_none")]
    pub in_reply_to: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterprise {     
    /// List of organization IDs that can access the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_organization_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostPullsCreateReplyForReviewComment {     
    /// The text of the review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutPullsMerge {     
    /// Title for the automatic commit message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_title: Option<String>,
    /// Extra detail to append to automatic commit message.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_message: Option<String>,
    /// SHA that pull request head must match to allow merge.
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_method: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostPullsRequestReviewers { 
    PostPullsRequestReviewersVariant0(Value),
}

impl From<Value> for PostPullsRequestReviewers {
    fn from(value: Value) -> Self {
        PostPullsRequestReviewers::PostPullsRequestReviewersVariant0(value)
    }
}

impl Display for PostPullsRequestReviewers {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match self { 
            PostPullsRequestReviewers::PostPullsRequestReviewersVariant0(value) => write!(f, "{}", value),
        }
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeletePullsRemoveRequestedReviewers {     
    /// An array of user `login`s that will be removed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub reviewers: Option<Vec<String>>,
    /// An array of team `slug`s that will be removed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_reviewers: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostPullsCreateReview {     
    /// The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    /// **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/reference/pulls#submit-a-review-for-a-pull-request) when you are ready.
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    /// Use the following table to specify the location, destination, and contents of the draft review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<Vec<ReposownerrepopullspullNumberreviewsComments>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutPullsUpdateReview {     
    /// The body text of the pull request review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutPullsDismissReview {     
    /// The message for the pull request review dismissal
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostPullsSubmitReview {     
    /// The body text of the pull request review
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutPullsUpdateBranch {     
    /// The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the \"[List commits](https://docs.github.com/rest/reference/repos#list-commits)\" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
    #[serde(skip_serializing_if="Option::is_none")]
    pub expected_head_sha: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateRelease {     
    /// The name of the tag.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag_name: Option<String>,
    /// Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_commitish: Option<String>,
    /// The name of the release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Text describing the contents of the tag.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// `true` to create a draft (unpublished) release, `false` to create a published one.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    /// `true` to identify the release as a prerelease. `false` to identify the release as a full release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prerelease: Option<bool>,
    /// If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see \"[Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub discussion_category_name: Option<String>,
    /// Whether to automatically generate the name and body for this release. If `name` is specified, the specified name will be used; otherwise, a name will be automatically generated. If `body` is specified, the body will be pre-pended to the automatically generated notes.
    #[serde(skip_serializing_if="Option::is_none")]
    pub generate_release_notes: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetSelfHostedRunnersInGroupForEnterprise {     
    /// List of runner IDs to add to the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateReleaseAsset {     
    /// The file name of the asset.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// An alternate short description of the asset. Used in place of the filename.
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposGenerateReleaseNotes {     
    /// The tag name for the release. This can be an existing tag or a new one.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag_name: Option<String>,
    /// Specifies the commitish value that will be the target for the release's tag. Required if the supplied tag_name does not reference an existing tag. Ignored if the tag_name already exists.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_commitish: Option<String>,
    /// The name of the previous tag to use as the starting point for the release notes. Use to manually specify the range for the set of changes considered as part this release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_tag_name: Option<String>,
    /// Specifies a path to a file in the repository containing configuration settings used for generating the release notes. If unspecified, the configuration file located in the repository at '.github/release.yml' or '.github/release.yaml' will be used. If that is not present, the default configuration will be used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub configuration_file_path: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateRelease {     
    /// The name of the tag.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag_name: Option<String>,
    /// Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_commitish: Option<String>,
    /// The name of the release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Text describing the contents of the tag.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// `true` makes the release a draft, and `false` publishes the release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    /// `true` to identify the release as a prerelease, `false` to identify the release as a full release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prerelease: Option<bool>,
    /// If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. If there is already a discussion linked to the release, this parameter is ignored. For more information, see \"[Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub discussion_category_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForRelease {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchSecretScanningUpdateAlert {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<SecretScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolution: Option<SecretScanningAlertResolution>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateCommitStatus {     
    /// The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.   For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:   `http://ci.example.com/user/repo/build/sha`
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_url: Option<String>,
    /// A short description of the status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// A string label to differentiate this status from the status of other systems. This field is case-insensitive.
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActivitySetRepoSubscription {     
    /// Determines if notifications should be received from this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribed: Option<bool>,
    /// Determines if all notifications should be blocked from this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub ignored: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutReposReplaceAllTopics {     
    /// An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub names: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposTransfer {     
    /// The username or organization name the repository will be transferred to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub new_owner: Option<String>,
    /// ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateUsingTemplate {     
    /// The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<String>,
    /// The name of the new repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// A short description of the new repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Set to `true` to include the directory structure and files from all branches in the template repository, and not just the default branch. Default: `false`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub include_all_branches: Option<bool>,
    /// Either `true` to create a new private repository or `false` to create a new public one.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetCustomLabelsForSelfHostedRunnerForEnterprise {     
    /// The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsCreateOrUpdateEnvironmentSecret {     
    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an environment public key](https://docs.github.com/rest/reference/actions#get-an-environment-public-key) endpoint.
    #[serde(skip_serializing_if="Option::is_none")]
    pub encrypted_value: Option<String>,
    /// ID of the key you used to encrypt the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostEnterpriseAdminProvisionAndInviteEnterpriseGroup {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// The name of the SCIM group. This must match the GitHub organization that the group maps to.
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<Vec<Scimv2enterprisesenterpriseGroupsMembers>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetInformationForProvisionedEnterpriseGroup {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// The name of the SCIM group. This must match the GitHub organization that the group maps to.
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<Vec<Scimv2enterprisesenterpriseGroupsMembers>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchEnterpriseAdminUpdateAttributeForEnterpriseGroup {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    #[serde(rename = "Operations")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub operations: Option<Vec<Scimv2enterprisesenterpriseGroupsscimGroupIdOperations>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostEnterpriseAdminProvisionAndInviteEnterpriseUser {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// The username for the user.
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<Scimv2enterprisesenterpriseUsersName>,
    /// List of user emails.
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<Scimv2enterprisesenterpriseUsersEmails>>,
    /// List of SCIM group IDs the user is a member of.
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<Scimv2enterprisesenterpriseUsersGroups>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutEnterpriseAdminSetInformationForProvisionedEnterpriseUser {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// The username for the user.
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<Scimv2enterprisesenterpriseUsersName>,
    /// List of user emails.
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<Scimv2enterprisesenterpriseUsersEmails>>,
    /// List of SCIM group IDs the user is a member of.
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<Scimv2enterprisesenterpriseUsersGroups>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchEnterpriseAdminUpdateAttributeForEnterpriseUser {     
    /// The SCIM schema URIs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    #[serde(rename = "Operations")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub operations: Option<Vec<Value>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostScimProvisionAndInviteUser {     
    /// Configured by the admin. Could be an email, login, or username
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    /// The name of the user, suitable for display to end-users
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<Scimv2organizationsorgUsersName>,
    /// user emails
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<Scimv2organizationsorgUsersEmails>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutScimSetInformationForProvisionedUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// The name of the user, suitable for display to end-users
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    /// Configured by the admin. Could be an email, login, or username
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<Scimv2organizationsorgUsersName>,
    /// user emails
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<Scimv2organizationsorgUsersscimUserIdEmails>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchScimUpdateAttributeForUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// Set of operations to be performed
    #[serde(rename = "Operations")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub operations: Option<Vec<Scimv2organizationsorgUsersscimUserIdOperations>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostEnterpriseAdminAddCustomLabelsToSelfHostedRunnerForEnterprise {     
    /// The names of the custom labels to add to the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateLegacy {     
    /// The name of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:   **For a non-nested team:**   \\* `secret` - only visible to organization owners and members of this team.   \\* `closed` - visible to all members of this organization.   **For a parent or child team:**   \\* `closed` - visible to all members of this organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    /// **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:   \\* `pull` - team members can pull, but not push to or administer newly-added repositories.   \\* `push` - team members can pull and push, but not administer newly-added repositories.   \\* `admin` - team members can pull, push and administer newly-added repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    /// The ID of a team to set as the parent team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent_team_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostTeamsCreateDiscussionLegacy {     
    /// The discussion post's title.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The discussion post's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateDiscussionLegacy {     
    /// The discussion post's title.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The discussion post's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostTeamsCreateDiscussionCommentLegacy {     
    /// The discussion comment's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateDiscussionCommentLegacy {     
    /// The discussion comment's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForTeamDiscussionCommentLegacy {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForTeamDiscussionLegacy {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateMembershipForUserLegacy {     
    /// The role that this user should have in the team. Can be one of:   \\* `member` - a normal member of the team.   \\* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateProjectPermissionsLegacy {     
    /// The permission to grant to the team for this project. Can be one of:   \\* `read` - team members can read, but not write to or administer this project.   \\* `write` - team members can read and write, but not administer this project.   \\* `admin` - team members can read, write and administer this project.   Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see \"[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateRepoPermissionsLegacy {     
    /// The permission to grant the team on this repository. Can be one of:   \\* `pull` - team members can pull, but not push to or administer this repository.   \\* `push` - team members can pull and push, but not administer this repository.   \\* `admin` - team members can pull, push and administer this repository.      If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGistsCreate {     
    /// Description of the gist
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Names and content for the files that make up the gist
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<HashMap<String, GistsFiles>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<PostGistsCreatePublicEnum>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsCreateOrUpdateIdpGroupConnectionsLegacy {     
    /// The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<TeamsteamIdteamsyncgroupmappingsGroups>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub synced_at: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchUsersUpdateAuthenticated {     
    /// The new name of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The publicly visible email address of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// The new blog URL of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
    /// The new Twitter username of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub twitter_username: Option<String>,
    /// The new company of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    /// The new location of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    /// The new hiring availability of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub hireable: Option<bool>,
    /// The new short biography of the user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub bio: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostCodespacesCreateForAuthenticatedUser { 
    PostCodespacesCreateForAuthenticatedUserVariant0(HashMap<String, i32>),
}

impl From<HashMap<String, i32>> for PostCodespacesCreateForAuthenticatedUser {
    fn from(value: HashMap<String, i32>) -> Self {
        PostCodespacesCreateForAuthenticatedUser::PostCodespacesCreateForAuthenticatedUserVariant0(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutCodespacesCreateOrUpdateSecretForAuthenticatedUser {     
    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get the public key for the authenticated user](https://docs.github.com/rest/reference/codespaces#get-the-public-key-for-the-authenticated-user) endpoint.
    #[serde(skip_serializing_if="Option::is_none")]
    pub encrypted_value: Option<String>,
    /// ID of the key you used to encrypt the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    /// An array of repository ids that can access the user secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/reference/codespaces#list-selected-repositories-for-a-user-secret), [Set selected repositories for a user secret](https://docs.github.com/rest/reference/codespaces#set-selected-repositories-for-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/reference/codespaces#remove-a-selected-repository-from-a-user-secret) endpoints.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutCodespacesSetRepositoriesForSecretForAuthenticatedUser {     
    /// An array of repository ids for which a codespace can access the secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/reference/codespaces#list-selected-repositories-for-a-user-secret), [Add a selected repository to a user secret](https://docs.github.com/rest/reference/codespaces#add-a-selected-repository-to-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/reference/codespaces#remove-a-selected-repository-from-a-user-secret) endpoints.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchCodespacesUpdateForAuthenticatedUser {     
    /// A valid machine to transition this codespace to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub machine: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchUsersSetPrimaryEmailVisibilityForAuthenticatedUser {     
    /// Denotes whether an email is publicly visible.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostUsersAddEmailForAuthenticatedUser { 
    PostUsersAddEmailForAuthenticatedUserVariant0(HashMap<String, Vec<String>>),
    PostUsersAddEmailForAuthenticatedUserVariant1(Vec<String>),
    PostUsersAddEmailForAuthenticatedUserVariant2(String),
}

impl From<HashMap<String, Vec<String>>> for PostUsersAddEmailForAuthenticatedUser {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostUsersAddEmailForAuthenticatedUser::PostUsersAddEmailForAuthenticatedUserVariant0(value)
    }
}

impl From<Vec<String>> for PostUsersAddEmailForAuthenticatedUser {
    fn from(value: Vec<String>) -> Self {
        PostUsersAddEmailForAuthenticatedUser::PostUsersAddEmailForAuthenticatedUserVariant1(value)
    }
}

impl From<String> for PostUsersAddEmailForAuthenticatedUser {
    fn from(value: String) -> Self {
        PostUsersAddEmailForAuthenticatedUser::PostUsersAddEmailForAuthenticatedUserVariant2(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteUsersDeleteEmailForAuthenticatedUser { 
    DeleteUsersDeleteEmailForAuthenticatedUserVariant0(HashMap<String, Vec<String>>),
    DeleteUsersDeleteEmailForAuthenticatedUserVariant1(Vec<String>),
    DeleteUsersDeleteEmailForAuthenticatedUserVariant2(String),
}

impl From<HashMap<String, Vec<String>>> for DeleteUsersDeleteEmailForAuthenticatedUser {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        DeleteUsersDeleteEmailForAuthenticatedUser::DeleteUsersDeleteEmailForAuthenticatedUserVariant0(value)
    }
}

impl From<Vec<String>> for DeleteUsersDeleteEmailForAuthenticatedUser {
    fn from(value: Vec<String>) -> Self {
        DeleteUsersDeleteEmailForAuthenticatedUser::DeleteUsersDeleteEmailForAuthenticatedUserVariant1(value)
    }
}

impl From<String> for DeleteUsersDeleteEmailForAuthenticatedUser {
    fn from(value: String) -> Self {
        DeleteUsersDeleteEmailForAuthenticatedUser::DeleteUsersDeleteEmailForAuthenticatedUserVariant2(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostUsersCreateGpgKeyForAuthenticatedUser {     
    /// A GPG key in ASCII-armored format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub armored_public_key: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeleteAppsDeleteAuthorization {     
    /// The OAuth access token used to authenticate to the GitHub API.
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_token: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PatchGistsUpdate { 
    PatchGistsUpdateVariant0(Value),
}

impl From<Value> for PatchGistsUpdate {
    fn from(value: Value) -> Self {
        PatchGistsUpdate::PatchGistsUpdateVariant0(value)
    }
}

impl Display for PatchGistsUpdate {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match self { 
            PatchGistsUpdate::PatchGistsUpdateVariant0(value) => write!(f, "{}", value),
        }
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostUsersCreatePublicSshKeyForAuthenticatedUser {     
    /// A descriptive name for the new key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The public SSH key to add to your GitHub account.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchOrgsUpdateMembershipForAuthenticatedUser {     
    /// The state that the membership should be in. Only `\"active\"` will be accepted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostMigrationsStartForAuthenticatedUser {     
    /// Lock the repositories being migrated at the start of the migration
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_repositories: Option<bool>,
    /// Do not include attachments in the migration
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_attachments: Option<bool>,
    /// Do not include releases in the migration
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_releases: Option<bool>,
    /// Indicates whether projects owned by the organization or users should be excluded.
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_owner_projects: Option<bool>,
    /// Exclude attributes from the API response to improve performance
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateForAuthenticatedUser {     
    /// Name of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Body of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateForAuthenticatedUser {     
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// A short description of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// A URL with more information about the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    /// Whether the repository is private.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    /// Whether issues are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Whether projects are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Whether the wiki is enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    /// The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_id: Option<i64>,
    /// Whether the repository is initialized with a minimal README.
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_init: Option<bool>,
    /// The desired language or platform to apply to the .gitignore.
    #[serde(skip_serializing_if="Option::is_none")]
    pub gitignore_template: Option<String>,
    /// The license keyword of the open source license for this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub license_template: Option<String>,
    /// Whether to allow squash merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Whether to allow merge commits for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Whether to allow rebase merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    /// Whether to allow Auto-merge to be used on pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Whether to delete head branches when pull requests are merged
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    /// Whether downloads are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    /// Whether this repository acts as a template that can be used to generate new repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostGistsCreateComment {     
    /// The comment text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchGistsUpdateComment {     
    /// The comment text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostMarkdownRender {     
    /// The Markdown text to render in HTML.
    #[serde(skip_serializing_if="Option::is_none")]
    pub text: Option<String>,
    /// The rendering mode. Can be either `markdown` or `gfm`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub mode: Option<String>,
    /// The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActivityMarkNotificationsAsRead {     
    /// Describes the last point that notifications were checked.
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_read_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether the notification has been read.
    #[serde(skip_serializing_if="Option::is_none")]
    pub read: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActivitySetThreadSubscription {     
    /// Whether to block all notifications from a thread.
    #[serde(skip_serializing_if="Option::is_none")]
    pub ignored: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchOrgsUpdate {     
    /// Billing email address. This address is not publicized.
    #[serde(skip_serializing_if="Option::is_none")]
    pub billing_email: Option<String>,
    /// The company name.
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    /// The publicly visible email address.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// The Twitter username of the company.
    #[serde(skip_serializing_if="Option::is_none")]
    pub twitter_username: Option<String>,
    /// The location.
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    /// The shorthand name of the company.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the company.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Toggles whether an organization can use organization projects.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_organization_projects: Option<bool>,
    /// Toggles whether repositories that belong to the organization can use repository projects.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_repository_projects: Option<bool>,
    /// Default permission level members have for organization repositories:   \\* `read` - can pull, but not push to or administer this repository.   \\* `write` - can pull and push, but not administer this repository.   \\* `admin` - can pull, push, and administer this repository.   \\* `none` - no permissions granted by default.
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_repository_permission: Option<String>,
    /// Toggles the ability of non-admin organization members to create repositories. Can be one of:   \\* `true` - all organization members can create repositories.   \\* `false` - only organization owners can create repositories.   Default: `true`   **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_repositories: Option<bool>,
    /// Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. Can be one of:   \\* `true` - all organization members can create internal repositories.   \\* `false` - only organization owners can create internal repositories.   Default: `true`. For more information, see \"[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_internal_repositories: Option<bool>,
    /// Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:   \\* `true` - all organization members can create private repositories.   \\* `false` - only organization owners can create private repositories.   Default: `true`. For more information, see \"[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_private_repositories: Option<bool>,
    /// Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:   \\* `true` - all organization members can create public repositories.   \\* `false` - only organization owners can create public repositories.   Default: `true`. For more information, see \"[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_public_repositories: Option<bool>,
    /// Specifies which types of repositories non-admin organization members can create. Can be one of:   \\* `all` - all organization members can create public and private repositories.   \\* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.   \\* `none` - only admin members can create repositories.   **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_allowed_repository_creation_type: Option<String>,
    /// Toggles whether organization members can create GitHub Pages sites. Can be one of:   \\* `true` - all organization members can create GitHub Pages sites.   \\* `false` - no organization members can create GitHub Pages sites. Existing published sites will not be impacted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_pages: Option<bool>,
    /// Toggles whether organization members can create public GitHub Pages sites. Can be one of:   \\* `true` - all organization members can create public GitHub Pages sites.   \\* `false` - no organization members can create public GitHub Pages sites. Existing published sites will not be impacted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_public_pages: Option<bool>,
    /// Toggles whether organization members can create private GitHub Pages sites. Can be one of:   \\* `true` - all organization members can create private GitHub Pages sites.   \\* `false` - no organization members can create private GitHub Pages sites. Existing published sites will not be impacted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_private_pages: Option<bool>,
    /// Toggles whether organization members can fork private organization repositories. Can be one of:   \\* `true` - all organization members can fork private repositories within the organization.   \\* `false` - no organization members can fork private repositories within the organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_fork_private_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetGithubActionsPermissionsOrganization {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled_repositories: Option<EnabledRepositories>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetSelectedRepositoriesEnabledGithubActionsOrganization {     
    /// List of repository IDs to enable for GitHub Actions.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostActionsCreateSelfHostedRunnerGroupForOrg {     
    /// Name of the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories. Can be one of: `all`, `selected`, or `private`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// List of repository IDs that can access the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<i32>>,
    /// List of runner IDs to add to the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<i32>>,
    /// Whether the runner group can be used by `public` repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostAppsCheckToken {     
    /// The access_token of the OAuth application.
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_token: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchActionsUpdateSelfHostedRunnerGroupForOrg {     
    /// Name of the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Visibility of a runner group. You can select all repositories, select individual repositories, or all private repositories. Can be one of: `all`, `selected`, or `private`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// Whether the runner group can be used by `public` repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetRepoAccessToSelfHostedRunnerGroupInOrg {     
    /// List of repository IDs that can access the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetSelfHostedRunnersInGroupForOrg {     
    /// List of runner IDs to add to the runner group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetCustomLabelsForSelfHostedRunnerForOrg {     
    /// The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostActionsAddCustomLabelsToSelfHostedRunnerForOrg {     
    /// The names of the custom labels to add to the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsCreateOrUpdateOrgSecret {     
    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/reference/actions#get-an-organization-public-key) endpoint.
    #[serde(skip_serializing_if="Option::is_none")]
    pub encrypted_value: Option<String>,
    /// ID of the key you used to encrypt the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    /// Configures the access that repositories have to the organization secret. Can be one of:   \\- `all` - All repositories in an organization can access the secret.   \\- `private` - Private repositories in an organization can access the secret.   \\- `selected` - Only specific repositories can access the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetSelectedReposForOrgSecret {     
    /// An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints.
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repository_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostOrgsCreateWebhook {     
    /// Must be passed as \"web\".
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<OrgsorghooksConfig>,
    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchOrgsUpdateWebhook {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<OrgsorghookshookIdConfig>,
    /// Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchOrgsUpdateWebhookConfigForOrg {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeleteAppsDeleteToken {     
    /// The OAuth access token used to authenticate to the GitHub API.
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_token: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostOrgsCreateInvitation {     
    /// **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
    #[serde(skip_serializing_if="Option::is_none")]
    pub invitee_id: Option<i64>,
    /// **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// Specify role for new member. Can be one of:   \\* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.   \\* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.   \\* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
    /// Specify IDs for the teams you want to invite new members to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_ids: Option<Vec<i32>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutOrgsSetMembershipForUser {     
    /// The role to give the user in the organization. Can be one of:   \\* `admin` - The user will become an owner of the organization.   \\* `member` - The user will become a non-owner member of the organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostMigrationsStartForOrg {     
    /// A list of arrays indicating which repositories should be migrated.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<String>>,
    /// Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_repositories: Option<bool>,
    /// Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_attachments: Option<bool>,
    /// Indicates whether releases should be excluded from the migration (to reduce migration archive file size).
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_releases: Option<bool>,
    /// Indicates whether projects owned by the organization or users should be excluded. from the migration.
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_owner_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateForOrg {     
    /// The name of the project.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the project.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateInOrg {     
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// A short description of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// A URL with more information about the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    /// Whether the repository is private.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    /// Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. Note: For GitHub Enterprise Server and GitHub AE, this endpoint will only list repositories available to all users on the enterprise. For more information, see \"[Creating an internal repository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    /// Either `true` to enable issues for this repository or `false` to disable them.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Either `true` to enable the wiki for this repository or `false` to disable it.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    /// Either `true` to make this repo available as a template repository or `false` to prevent it.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    /// The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_id: Option<i64>,
    /// Pass `true` to create an initial commit with empty README.
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_init: Option<bool>,
    /// Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, \"Haskell\".
    #[serde(skip_serializing_if="Option::is_none")]
    pub gitignore_template: Option<String>,
    /// Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, \"mit\" or \"mpl-2.0\".
    #[serde(skip_serializing_if="Option::is_none")]
    pub license_template: Option<String>,
    /// Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    /// Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostTeamsCreate {     
    /// The name of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// List GitHub IDs for organization members who will become team maintainers.
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintainers: Option<Vec<String>>,
    /// The full name (e.g., \"organization-name/repository-name\") of repositories to add the team to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo_names: Option<Vec<String>>,
    /// The level of privacy this team should have. The options are:   **For a non-nested team:**   \\* `secret` - only visible to organization owners and members of this team.   \\* `closed` - visible to all members of this organization.   Default: `secret`   **For a parent or child team:**   \\* `closed` - visible to all members of this organization.   Default for child team: `closed`
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    /// **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:   \\* `pull` - team members can pull, but not push to or administer newly-added repositories.   \\* `push` - team members can pull and push, but not administer newly-added repositories.   \\* `admin` - team members can pull, push and administer newly-added repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    /// The ID of a team to set as the parent team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent_team_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateInOrg {     
    /// The name of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The description of the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:   **For a non-nested team:**   \\* `secret` - only visible to organization owners and members of this team.   \\* `closed` - visible to all members of this organization.   **For a parent or child team:**   \\* `closed` - visible to all members of this organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    /// **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:   \\* `pull` - team members can pull, but not push to or administer newly-added repositories.   \\* `push` - team members can pull and push, but not administer newly-added repositories.   \\* `admin` - team members can pull, push and administer newly-added repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    /// The ID of a team to set as the parent team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent_team_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostTeamsCreateDiscussionInOrg {     
    /// The discussion post's title.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The discussion post's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateDiscussionInOrg {     
    /// The discussion post's title.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The discussion post's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostTeamsCreateDiscussionCommentInOrg {     
    /// The discussion comment's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchAppsResetToken {     
    /// The access_token of the OAuth application.
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_token: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsUpdateDiscussionCommentInOrg {     
    /// The discussion comment's body text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForTeamDiscussionCommentInOrg {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForTeamDiscussionInOrg {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsLinkExternalIdpGroupToTeamForOrg {     
    /// External Group Id
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateMembershipForUserInOrg {     
    /// The role that this user should have in the team. Can be one of:   \\* `member` - a normal member of the team.   \\* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateProjectPermissionsInOrg {     
    /// The permission to grant to the team for this project. Can be one of:   \\* `read` - team members can read, but not write to or administer this project.   \\* `write` - team members can read and write, but not administer this project.   \\* `admin` - team members can read, write and administer this project.   Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see \"[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs).\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateRepoPermissionsInOrg {     
    /// The permission to grant the team on this repository. Can be one of:   \\* `pull` - team members can pull, but not push to or administer this repository.   \\* `push` - team members can pull and push, but not administer this repository.   \\* `admin` - team members can pull, push and administer this repository.   \\* `maintain` - team members can manage the repository without access to sensitive or destructive actions. Recommended for project managers. Only applies to repositories owned by organizations.   \\* `triage` - team members can proactively manage issues and pull requests without write access. Recommended for contributors who triage a repository. Only applies to repositories owned by organizations.   \\* custom repository role name - A custom repository role if the owning organization has defined any.      If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchTeamsCreateOrUpdateIdpGroupConnectionsInOrg {     
    /// The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<OrgsorgteamsteamSlugteamsyncgroupmappingsGroups>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchProjectsUpdateCard {     
    /// The project card's note
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    /// Whether or not the card is archived
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsMoveCard {     
    /// The position of the card in a column. Can be one of: `top`, `bottom`, or `after:<card_id>` to place after the specified card.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<String>,
    /// The unique identifier of the column the card should be moved to
    #[serde(skip_serializing_if="Option::is_none")]
    pub column_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostAppsScopeToken {     
    /// The OAuth access token used to authenticate to the GitHub API.
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_token: Option<String>,
    /// The name of the user or organization to scope the user-to-server access token to. **Required** unless `target_id` is specified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target: Option<String>,
    /// The ID of the user or organization to scope the user-to-server access token to. **Required** unless `target` is specified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_id: Option<i64>,
    /// The list of repository names to scope the user-to-server access token to. `repositories` may not be specified if `repository_ids` is specified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<String>>,
    /// The list of repository IDs to scope the user-to-server access token to. `repository_ids` may not be specified if `repositories` is specified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_ids: Option<Vec<i32>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<AppPermissions>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchProjectsUpdateColumn {     
    /// Name of the project column
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostProjectsCreateCard { 
    PostProjectsCreateCardVariant0(HashMap<String, String>),
}

impl From<HashMap<String, String>> for PostProjectsCreateCard {
    fn from(value: HashMap<String, String>) -> Self {
        PostProjectsCreateCard::PostProjectsCreateCardVariant0(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsMoveColumn {     
    /// The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchProjectsUpdate {     
    /// Name of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Body of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// State of the project; either 'open' or 'closed'
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The baseline permission that all organization members have on this project
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_permission: Option<String>,
    /// Whether or not this project can be seen by everyone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutProjectsAddCollaborator {     
    /// The permission to grant the collaborator.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateColumn {     
    /// Name of the project column
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdate {     
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// A short description of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// A URL with more information about the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    /// Either `true` to make the repository private or `false` to make it public. Default: `false`.   **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    /// Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`.\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_and_analysis: Option<ReposownerrepoSecurityAndAnalysis>,
    /// Either `true` to enable issues for this repository or `false` to disable them.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Either `true` to enable the wiki for this repository or `false` to disable it.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    /// Either `true` to make this repo available as a template repository or `false` to prevent it.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    /// Updates the default branch for this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    /// Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    /// Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    /// `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Either `true` to allow private forks, or `false` to prevent private forks.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetGithubActionsPermissionsRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<ActionsEnabled>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_actions: Option<AllowedActions>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetCustomLabelsForSelfHostedRunnerForRepo {     
    /// The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostActionsAddCustomLabelsToSelfHostedRunnerForRepo {     
    /// The names of the custom labels to add to the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostOauthAuthorizationsCreateAuthorization {     
    /// A list of scopes that this authorization is in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    /// A note to remind you what the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    /// A URL to remind you what app the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note_url: Option<String>,
    /// The OAuth app client key for which to create the token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_id: Option<String>,
    /// The OAuth app client secret for which to create the token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    /// A unique string to distinguish an authorization from others created for the same client ID and user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostActionsReviewPendingDeploymentsForRun {     
    /// The list of environment ids to approve or reject
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment_ids: Option<Vec<i32>>,
    /// Whether to approve or reject deployment to the specified environments. Must be one of: `approved` or `rejected`
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// A comment to accompany the deployment review
    #[serde(skip_serializing_if="Option::is_none")]
    pub comment: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsCreateOrUpdateRepoSecret {     
    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/reference/actions#get-a-repository-public-key) endpoint.
    #[serde(skip_serializing_if="Option::is_none")]
    pub encrypted_value: Option<String>,
    /// ID of the key you used to encrypt the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostActionsCreateWorkflowDispatch {     
    /// The git reference for the workflow. The reference can be a branch or tag name.
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    /// Input keys and values configured in the workflow file. The maximum number of properties is 10. Any default properties configured in the workflow file will be used when `inputs` are omitted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub inputs: Option<HashMap<String, String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateAutolink {     
    /// The prefix appended by a number will generate a link any time it is found in an issue, pull request, or commit.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_prefix: Option<String>,
    /// The URL must contain <num> for the reference number.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url_template: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutReposUpdateBranchProtection {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_status_checks: Option<ReposownerrepobranchesbranchprotectionRequiredStatusChecks>,
    /// Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
    #[serde(skip_serializing_if="Option::is_none")]
    pub enforce_admins: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_pull_request_reviews: Option<ReposownerrepobranchesbranchprotectionRequiredPullRequestReviews>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub restrictions: Option<ReposownerrepobranchesbranchprotectionRestrictions>,
    /// Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see \"[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_linear_history: Option<bool>,
    /// Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_force_pushes: Option<bool>,
    /// Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_deletions: Option<bool>,
    /// Requires all conversations on code to be resolved before a pull request can be merged into a branch that matches this rule. Set to `false` to disable. Default: `false`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_conversation_resolution: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdatePullRequestReviewProtection {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_restrictions: Option<ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsDismissalRestrictions>,
    /// Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismiss_stale_reviews: Option<bool>,
    /// Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub require_code_owner_reviews: Option<bool>,
    /// Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_approving_review_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bypass_pull_request_allowances: Option<ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsBypassPullRequestAllowances>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateStatusCheckProtection {     
    /// Require branches to be up to date before merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub strict: Option<bool>,
    /// **Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control. 
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts: Option<Vec<String>>,
    /// The list of status checks to require in order to merge into this branch.
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<Vec<ReposownerrepobranchesbranchprotectionRequiredStatusChecksChecks>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposSetStatusCheckContexts { 
    PutReposSetStatusCheckContextsVariant0(HashMap<String, Vec<String>>),
    PutReposSetStatusCheckContextsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PutReposSetStatusCheckContexts {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PutReposSetStatusCheckContexts::PutReposSetStatusCheckContextsVariant0(value)
    }
}

impl From<Vec<String>> for PutReposSetStatusCheckContexts {
    fn from(value: Vec<String>) -> Self {
        PutReposSetStatusCheckContexts::PutReposSetStatusCheckContextsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostReposAddStatusCheckContexts { 
    PostReposAddStatusCheckContextsVariant0(HashMap<String, Vec<String>>),
    PostReposAddStatusCheckContextsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PostReposAddStatusCheckContexts {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostReposAddStatusCheckContexts::PostReposAddStatusCheckContextsVariant0(value)
    }
}

impl From<Vec<String>> for PostReposAddStatusCheckContexts {
    fn from(value: Vec<String>) -> Self {
        PostReposAddStatusCheckContexts::PostReposAddStatusCheckContextsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteReposRemoveStatusCheckContexts { 
    DeleteReposRemoveStatusCheckContextsVariant0(HashMap<String, Vec<String>>),
    DeleteReposRemoveStatusCheckContextsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for DeleteReposRemoveStatusCheckContexts {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        DeleteReposRemoveStatusCheckContexts::DeleteReposRemoveStatusCheckContextsVariant0(value)
    }
}

impl From<Vec<String>> for DeleteReposRemoveStatusCheckContexts {
    fn from(value: Vec<String>) -> Self {
        DeleteReposRemoveStatusCheckContexts::DeleteReposRemoveStatusCheckContextsVariant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutOauthAuthorizationsGetOrCreateAuthorizationForApp {     
    /// The OAuth app client secret for which to create the token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    /// A list of scopes that this authorization is in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    /// A note to remind you what the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    /// A URL to remind you what app the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note_url: Option<String>,
    /// A unique string to distinguish an authorization from others created for the same client ID and user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposSetAppAccessRestrictions { 
    PutReposSetAppAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PutReposSetAppAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PutReposSetAppAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PutReposSetAppAccessRestrictions::PutReposSetAppAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PutReposSetAppAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PutReposSetAppAccessRestrictions::PutReposSetAppAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostReposAddAppAccessRestrictions { 
    PostReposAddAppAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PostReposAddAppAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PostReposAddAppAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostReposAddAppAccessRestrictions::PostReposAddAppAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PostReposAddAppAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PostReposAddAppAccessRestrictions::PostReposAddAppAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteReposRemoveAppAccessRestrictions { 
    DeleteReposRemoveAppAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    DeleteReposRemoveAppAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for DeleteReposRemoveAppAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        DeleteReposRemoveAppAccessRestrictions::DeleteReposRemoveAppAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for DeleteReposRemoveAppAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        DeleteReposRemoveAppAccessRestrictions::DeleteReposRemoveAppAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposSetTeamAccessRestrictions { 
    PutReposSetTeamAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PutReposSetTeamAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PutReposSetTeamAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PutReposSetTeamAccessRestrictions::PutReposSetTeamAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PutReposSetTeamAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PutReposSetTeamAccessRestrictions::PutReposSetTeamAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostReposAddTeamAccessRestrictions { 
    PostReposAddTeamAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PostReposAddTeamAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PostReposAddTeamAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostReposAddTeamAccessRestrictions::PostReposAddTeamAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PostReposAddTeamAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PostReposAddTeamAccessRestrictions::PostReposAddTeamAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteReposRemoveTeamAccessRestrictions { 
    DeleteReposRemoveTeamAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    DeleteReposRemoveTeamAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for DeleteReposRemoveTeamAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        DeleteReposRemoveTeamAccessRestrictions::DeleteReposRemoveTeamAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for DeleteReposRemoveTeamAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        DeleteReposRemoveTeamAccessRestrictions::DeleteReposRemoveTeamAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PutReposSetUserAccessRestrictions { 
    PutReposSetUserAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PutReposSetUserAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PutReposSetUserAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PutReposSetUserAccessRestrictions::PutReposSetUserAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PutReposSetUserAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PutReposSetUserAccessRestrictions::PutReposSetUserAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostReposAddUserAccessRestrictions { 
    PostReposAddUserAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    PostReposAddUserAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for PostReposAddUserAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        PostReposAddUserAccessRestrictions::PostReposAddUserAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for PostReposAddUserAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        PostReposAddUserAccessRestrictions::PostReposAddUserAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteReposRemoveUserAccessRestrictions { 
    DeleteReposRemoveUserAccessRestrictionsVariant0(HashMap<String, Vec<String>>),
    DeleteReposRemoveUserAccessRestrictionsVariant1(Vec<String>),
}

impl From<HashMap<String, Vec<String>>> for DeleteReposRemoveUserAccessRestrictions {
    fn from(value: HashMap<String, Vec<String>>) -> Self {
        DeleteReposRemoveUserAccessRestrictions::DeleteReposRemoveUserAccessRestrictionsVariant0(value)
    }
}

impl From<Vec<String>> for DeleteReposRemoveUserAccessRestrictions {
    fn from(value: Vec<String>) -> Self {
        DeleteReposRemoveUserAccessRestrictions::DeleteReposRemoveUserAccessRestrictionsVariant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposRenameBranch {     
    /// The new name of the branch.
    #[serde(skip_serializing_if="Option::is_none")]
    pub new_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutOauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprint {     
    /// The OAuth app client secret for which to create the token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    /// A list of scopes that this authorization is in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    /// A note to remind you what the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    /// A URL to remind you what app the OAuth token is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub note_url: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostChecksCreate { 
    PostChecksCreateVariant0(HashMap<String, String>),
}

impl From<HashMap<String, String>> for PostChecksCreate {
    fn from(value: HashMap<String, String>) -> Self {
        PostChecksCreate::PostChecksCreateVariant0(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PatchChecksUpdate { 
    PatchChecksUpdateVariant0(HashMap<String, String>),
}

impl From<HashMap<String, String>> for PatchChecksUpdate {
    fn from(value: HashMap<String, String>) -> Self {
        PatchChecksUpdate::PatchChecksUpdateVariant0(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostChecksCreateSuite {     
    /// The sha of the head commit.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_sha: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchChecksSetSuitesPreferences {     
    /// Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://docs.github.com/rest/reference/checks#auto_trigger_checks-object) description for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_trigger_checks: Option<Vec<ReposownerrepochecksuitespreferencesAutoTriggerChecks>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchCodeScanningUpdateAlert {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<CodeScanningAlertSetState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_reason: Option<CodeScanningAlertDismissedReason>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostCodeScanningUploadSarif {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_sha: Option<CodeScanningAnalysisCommitSha>,
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<CodeScanningRef>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sarif: Option<CodeScanningAnalysisSarifFile>,
    /// The base directory used in the analysis, as it appears in the SARIF file. This property is used to convert file paths from absolute to relative, so that alerts can be mapped to their correct location in the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub checkout_uri: Option<String>,
    /// The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub started_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The name of the tool used to generate the code scanning analysis. If this parameter is not used, the tool name defaults to \"API\". If the uploaded SARIF contains a tool GUID, this will be available for filtering using the `tool_guid` parameter of operations such as `GET /repos/{owner}/{repo}/code-scanning/alerts`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tool_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostCodespacesCreateWithRepoForAuthenticatedUser {     
    /// Git ref (typically a branch name) for this codespace
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    /// Location for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    /// Machine type to use for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub machine: Option<String>,
    /// Working directory for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub working_directory: Option<String>,
    /// Time in minutes before codespace stops from inactivity
    #[serde(skip_serializing_if="Option::is_none")]
    pub idle_timeout_minutes: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutReposAddCollaborator {     
    /// The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:   \\* `pull` - can pull, but not push to or administer this repository.   \\* `push` - can pull and push, but not administer this repository.   \\* `admin` - can pull, push and administer this repository.   \\* `maintain` - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.   \\* `triage` - Recommended for contributors who need to proactively manage issues and pull requests without write access.   \\* custom repository role name - A custom repository role, if the owning organization has defined any.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchReposUpdateCommitComment {     
    /// The contents of the comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReactionsCreateForCommitComment {     
    /// The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the commit comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

/// Branch Protection
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchProtection {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_status_checks: Option<ProtectedBranchRequiredStatusCheck>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enforce_admins: Option<ProtectedBranchAdminEnforced>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_pull_request_reviews: Option<ProtectedBranchPullRequestReview>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub restrictions: Option<BranchRestrictionPolicy>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_linear_history: Option<BranchprotectionRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_force_pushes: Option<BranchprotectionRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_deletions: Option<BranchprotectionRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_conversation_resolution: Option<BranchprotectionRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_signatures: Option<BranchprotectionRequiredSignatures>,
}

/// Branch Restriction Policy
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchRestrictionPolicy {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub users_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub apps_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<RepositoryTemplateRepositoryOwner>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<BranchrestrictionpolicyTeams>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub apps: Option<Vec<BranchrestrictionpolicyApps>>,
}

/// Branch Short
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchShort {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<BranchshortCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protected: Option<bool>,
}

/// Branch With Protection
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchWithProtection {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<Commit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<BranchwithprotectionLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protected: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection: Option<BranchProtection>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pattern: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_approving_review_count: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchprotectionRequiredLinearHistory {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchprotectionRequiredSignatures {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchrestrictionpolicyApps {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<BranchrestrictionpolicyOwner>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<BranchrestrictionpolicyPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchrestrictionpolicyOwner {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchrestrictionpolicyPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub metadata: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchrestrictionpolicyTeams {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchshortCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct BranchwithprotectionLinks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<String>,
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<String>,
}

/// Check Annotation
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckAnnotation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_column: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_column: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotation_level: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_details: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blob_href: Option<String>,
}

/// A check performed on the code of a given code change
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckRun {     
    /// The id of the check.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The SHA of the commit that is being checked.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub details_url: Option<String>,
    /// The phase of the lifecycle that the check is currently in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub conclusion: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub started_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub completed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub output: Option<CheckrunOutput>,
    /// The name of the check.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_suite: Option<CheckrunCheckSuite>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_requests: Option<Vec<PullRequestMinimal>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployment: Option<DeploymentSimple>,
}

/// A suite of checks performed on the code of a given code change
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckSuite {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_branch: Option<String>,
    /// The SHA of the head commit that is being checked.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub conclusion: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub before: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub after: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_requests: Option<Vec<PullRequestMinimal>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_commit: Option<SimpleCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub latest_check_runs_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_runs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rerequestable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runs_rerequestable: Option<bool>,
}

/// Check suite configuration preferences for a repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckSuitePreference {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub preferences: Option<ChecksuitepreferencePreferences>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckrunCheckSuite {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CheckrunOutput {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub summary: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotations_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotations_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ChecksuitepreferencePreferences {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_trigger_checks: Option<Vec<ChecksuitepreferencePreferencesAutoTriggerChecks>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ChecksuitepreferencePreferencesAutoTriggerChecks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub setting: Option<bool>,
}

/// Clone Traffic
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CloneTraffic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uniques: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clones: Option<Vec<Traffic>>,
}

/// Code Frequency Stat
pub type CodeFrequencyStat = Vec<i32>;

/// Code Of Conduct
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeOfConduct {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Code of Conduct Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeOfConductSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlert {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<AlertNumber>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<AlertCreatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<AlertUpdatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<AlertUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<AlertHtmlUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub instances_url: Option<AlertInstancesUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<CodeScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fixed_at: Option<CodeScanningAlertFixedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_at: Option<CodeScanningAlertDismissedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_reason: Option<CodeScanningAlertDismissedReason>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rule: Option<CodeScanningAlertRule>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tool: Option<CodeScanningAnalysisTool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub most_recent_instance: Option<CodeScanningAlertInstance>,
}

/// A classification of the file. For example to identify it as generated.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum CodeScanningAlertClassification { 
    #[serde(rename = "source")]
    SOURCE,
    #[serde(rename = "generated")]
    GENERATED,
    #[serde(rename = "test")]
    TEST,
    #[serde(rename = "library")]
    LIBRARY,
}

impl Display for CodeScanningAlertClassification {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            CodeScanningAlertClassification::SOURCE => write!(f, "{}", "source"),
            CodeScanningAlertClassification::GENERATED => write!(f, "{}", "generated"),
            CodeScanningAlertClassification::TEST => write!(f, "{}", "test"),
            CodeScanningAlertClassification::LIBRARY => write!(f, "{}", "library"),
        }
    }
}

impl std::str::FromStr for CodeScanningAlertClassification {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "source" => Ok(CodeScanningAlertClassification::SOURCE),
            "generated" => Ok(CodeScanningAlertClassification::GENERATED),
            "test" => Ok(CodeScanningAlertClassification::TEST),
            "library" => Ok(CodeScanningAlertClassification::LIBRARY),
            _ => Err(()),
        }
    }
}

/// The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
pub type CodeScanningAlertDismissedAt = DateTime<Utc>;

/// **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum CodeScanningAlertDismissedReason { 
    #[serde(rename = "null")]
    NULL,
    #[serde(rename = "false positive")]
    FALSE_POSITIVE,
    #[serde(rename = "won't fix")]
    WON_T_FIX,
    #[serde(rename = "used in tests")]
    USED_IN_TESTS,
}

impl Display for CodeScanningAlertDismissedReason {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            CodeScanningAlertDismissedReason::NULL => write!(f, "{}", "null"),
            CodeScanningAlertDismissedReason::FALSE_POSITIVE => write!(f, "{}", "false positive"),
            CodeScanningAlertDismissedReason::WON_T_FIX => write!(f, "{}", "won't fix"),
            CodeScanningAlertDismissedReason::USED_IN_TESTS => write!(f, "{}", "used in tests"),
        }
    }
}

impl std::str::FromStr for CodeScanningAlertDismissedReason {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "null" => Ok(CodeScanningAlertDismissedReason::NULL),
            "false positive" => Ok(CodeScanningAlertDismissedReason::FALSE_POSITIVE),
            "won't fix" => Ok(CodeScanningAlertDismissedReason::WON_T_FIX),
            "used in tests" => Ok(CodeScanningAlertDismissedReason::USED_IN_TESTS),
            _ => Err(()),
        }
    }
}

/// Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertEnvironment {     
}

/// The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
pub type CodeScanningAlertFixedAt = DateTime<Utc>;

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertInstance {     
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<CodeScanningRef>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub analysis_key: Option<CodeScanningAnalysisAnalysisKey>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<CodeScanningAlertEnvironment>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub category: Option<CodeScanningAnalysisCategory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<CodeScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<CodescanningalertinstanceMessage>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<CodeScanningAlertLocation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// Classifications that have been applied to the file that triggered the alert. For example identifying it as documentation, or a generated file.
    #[serde(skip_serializing_if="Option::is_none")]
    pub classifications: Option<Vec<CodeScanningAlertClassification>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertItems {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<AlertNumber>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<AlertCreatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<AlertUpdatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<AlertUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<AlertHtmlUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub instances_url: Option<AlertInstancesUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<CodeScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fixed_at: Option<CodeScanningAlertFixedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_at: Option<CodeScanningAlertDismissedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_reason: Option<CodeScanningAlertDismissedReason>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rule: Option<CodeScanningAlertRuleSummary>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tool: Option<CodeScanningAnalysisTool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub most_recent_instance: Option<CodeScanningAlertInstance>,
}

/// Describe a region within a file for the alert.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertLocation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_column: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_column: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertRule {     
    /// A unique identifier for the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    /// The name of the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The severity of the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub severity: Option<String>,
    /// The security severity of the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_severity_level: Option<String>,
    /// A short description of the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// description of the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_description: Option<String>,
    /// A set of tags applicable for the rule.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// Detailed documentation for the rule as GitHub Flavored Markdown.
    #[serde(skip_serializing_if="Option::is_none")]
    pub help: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAlertRuleSummary {     
    /// A unique identifier for the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    /// The name of the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// A set of tags applicable for the rule.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The severity of the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub severity: Option<String>,
    /// A short description of the rule used to detect the alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

/// Sets the state of the code scanning alert. Can be one of `open` or `dismissed`. You must provide `dismissed_reason` when you set the state to `dismissed`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum CodeScanningAlertSetState { 
    #[serde(rename = "open")]
    OPEN,
    #[serde(rename = "dismissed")]
    DISMISSED,
}

impl Display for CodeScanningAlertSetState {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            CodeScanningAlertSetState::OPEN => write!(f, "{}", "open"),
            CodeScanningAlertSetState::DISMISSED => write!(f, "{}", "dismissed"),
        }
    }
}

impl std::str::FromStr for CodeScanningAlertSetState {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "open" => Ok(CodeScanningAlertSetState::OPEN),
            "dismissed" => Ok(CodeScanningAlertSetState::DISMISSED),
            _ => Err(()),
        }
    }
}

/// State of a code scanning alert.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum CodeScanningAlertState { 
    #[serde(rename = "open")]
    OPEN,
    #[serde(rename = "closed")]
    CLOSED,
    #[serde(rename = "dismissed")]
    DISMISSED,
    #[serde(rename = "fixed")]
    FIXED,
}

impl Display for CodeScanningAlertState {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            CodeScanningAlertState::OPEN => write!(f, "{}", "open"),
            CodeScanningAlertState::CLOSED => write!(f, "{}", "closed"),
            CodeScanningAlertState::DISMISSED => write!(f, "{}", "dismissed"),
            CodeScanningAlertState::FIXED => write!(f, "{}", "fixed"),
        }
    }
}

impl std::str::FromStr for CodeScanningAlertState {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "open" => Ok(CodeScanningAlertState::OPEN),
            "closed" => Ok(CodeScanningAlertState::CLOSED),
            "dismissed" => Ok(CodeScanningAlertState::DISMISSED),
            "fixed" => Ok(CodeScanningAlertState::FIXED),
            _ => Err(()),
        }
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysis {     
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<CodeScanningRef>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_sha: Option<CodeScanningAnalysisCommitSha>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub analysis_key: Option<CodeScanningAnalysisAnalysisKey>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<CodeScanningAnalysisEnvironment>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub category: Option<CodeScanningAnalysisCategory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub error: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<CodeScanningAnalysisCreatedAt>,
    /// The total number of results in the analysis.
    #[serde(skip_serializing_if="Option::is_none")]
    pub results_count: Option<i64>,
    /// The total number of rules used in the analysis.
    #[serde(skip_serializing_if="Option::is_none")]
    pub rules_count: Option<i64>,
    /// Unique identifier for this analysis.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<CodeScanningAnalysisUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sarif_id: Option<CodeScanningAnalysisSarifId>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tool: Option<CodeScanningAnalysisTool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deletable: Option<bool>,
    /// Warning generated when processing the analysis
    #[serde(skip_serializing_if="Option::is_none")]
    pub warning: Option<String>,
}

/// Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisAnalysisKey {     
}

/// Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisCategory {     
}

/// The SHA of the commit to which the analysis you are uploading relates.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisCommitSha {     
}

/// The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
pub type CodeScanningAnalysisCreatedAt = DateTime<Utc>;

/// Successful deletion of a code scanning analysis
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisDeletion {     
    /// Next deletable analysis in chain, without last analysis deletion confirmation
    #[serde(skip_serializing_if="Option::is_none")]
    pub next_analysis_url: Option<String>,
    /// Next deletable analysis in chain, with last analysis deletion confirmation
    #[serde(skip_serializing_if="Option::is_none")]
    pub confirm_delete_url: Option<String>,
}

/// Identifies the variable values associated with the environment in which this analysis was performed.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisEnvironment {     
}

/// A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see \"[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning).\"
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisSarifFile {     
}

/// An identifier for the upload.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisSarifId {     
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisTool {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<CodeScanningAnalysisToolName>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub version: Option<CodeScanningAnalysisToolVersion>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub guid: Option<CodeScanningAnalysisToolGuid>,
}

/// The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisToolGuid {     
}

/// The name of the tool used to generate the code scanning analysis.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisToolName {     
}

/// The version of the tool used to generate the code scanning analysis.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisToolVersion {     
}

/// The REST API URL of the analysis resource.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningAnalysisUrl {     
}

/// The full Git reference, formatted as `refs/heads/<branch name>`, `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningRef {     
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningSarifsReceipt {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<CodeScanningAnalysisSarifId>,
    /// The REST API URL for checking the status of the upload.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeScanningSarifsStatus {     
    /// `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub processing_status: Option<String>,
    /// The REST API URL for getting the analyses associated with the upload.
    #[serde(skip_serializing_if="Option::is_none")]
    pub analyses_url: Option<String>,
    /// Any errors that ocurred during processing of the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<String>>,
}

/// Code Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodeSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub file_size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_modified_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub line_numbers: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodescanningalertinstanceMessage {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub text: Option<String>,
}

/// A codespace.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Codespace {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// Automatically generated name of this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// UUID identifying this codespace's environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub billable_owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub machine: Option<NullableCodespaceMachine>,
    /// Whether the codespace was created from a prebuild.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prebuild: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Last known time this codespace was started.
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_used_at: Option<chrono::DateTime<chrono::Utc>>,
    /// State of this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// API URL for this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_status: Option<CodespaceGitStatus>,
    /// The Azure region where this codespace is located.
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    /// The number of minutes of inactivity after which this codespace will be automatically stopped.
    #[serde(skip_serializing_if="Option::is_none")]
    pub idle_timeout_minutes: Option<i64>,
    /// URL to access this codespace on the web.
    #[serde(skip_serializing_if="Option::is_none")]
    pub web_url: Option<String>,
    /// API URL to access available alternate machine types for this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub machines_url: Option<String>,
    /// API URL to start this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_url: Option<String>,
    /// API URL to stop this codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub stop_url: Option<String>,
    /// API URL for the Pull Request associated with this codespace, if any.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub recent_folders: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runtime_constraints: Option<CodespaceRuntimeConstraints>,
}

/// Details about the codespace's git repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodespaceGitStatus {     
    /// The number of commits the local repository is ahead of the remote.
    #[serde(skip_serializing_if="Option::is_none")]
    pub ahead: Option<i64>,
    /// The number of commits the local repository is behind the remote.
    #[serde(skip_serializing_if="Option::is_none")]
    pub behind: Option<i64>,
    /// Whether the local repository has unpushed changes.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_unpushed_changes: Option<bool>,
    /// Whether the local repository has uncommitted changes.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_uncommitted_changes: Option<bool>,
    /// The current branch (or SHA if in detached HEAD state) of the local repository.
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
}

/// A description of the machine powering a codespace.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodespaceMachine {     
    /// The name of the machine.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The display name of the machine includes cores, memory, and storage.
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    /// The operating system of the machine.
    #[serde(skip_serializing_if="Option::is_none")]
    pub operating_system: Option<String>,
    /// How much storage is available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub storage_in_bytes: Option<i64>,
    /// How much memory is available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub memory_in_bytes: Option<i64>,
    /// How many cores are available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub cpus: Option<i64>,
    /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be \"null\" if prebuilds are not supported or prebuild availability could not be determined. Value is the type of prebuild available, or \"none\" if none are available.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prebuild_availability: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodespaceRuntimeConstraints {     
    /// The privacy settings a user can select from when forwarding a port.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allowed_port_privacy_settings: Option<Vec<String>>,
}

/// Secrets for a GitHub Codespace.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodespacesSecret {     
    /// The name of the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Visibility of a secret
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repositories_url: Option<String>,
}

/// The public key used for setting user Codespaces' Secrets.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CodespacesUserPublicKey {     
    /// The identifier for the key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    /// The Base64 encoded public key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
}

/// Collaborator
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Collaborator {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<CollaboratorPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CollaboratorPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub triage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CombinedBillingUsage {     
    /// Numbers of days left in billing cycle.
    #[serde(skip_serializing_if="Option::is_none")]
    pub days_left_in_billing_cycle: Option<i64>,
    /// Estimated storage space (GB) used in billing cycle.
    #[serde(skip_serializing_if="Option::is_none")]
    pub estimated_paid_storage_for_month: Option<i64>,
    /// Estimated sum of free and paid storage space (GB) used in billing cycle.
    #[serde(skip_serializing_if="Option::is_none")]
    pub estimated_storage_for_month: Option<i64>,
}

/// Combined Commit Status
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CombinedCommitStatus {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses: Option<Vec<SimpleCommitStatus>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Commit
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Commit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<CommitCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<CommitParents>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stats: Option<CommitStats>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<Vec<DiffEntry>>,
}

/// Commit Activity
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitActivity {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub days: Option<Vec<i32>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub week: Option<i64>,
}

/// Commit Comment
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitComment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableGitUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullableGitUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comment_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<CommitCommitTree>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<Verification>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitCommitTree {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Commit Comparison
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitComparison {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permalink_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub patch_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub base_commit: Option<Commit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_base_commit: Option<Commit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ahead_by: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub behind_by: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_commits: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits: Option<Vec<Commit>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<Vec<DiffEntry>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitParents {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Commit Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<CommitsearchresultitemCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullableGitUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<FilecommitCommitParents>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitStats {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub additions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deletions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitsearchresultitemCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<CommitsearchresultitemCommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullableGitUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comment_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<ShortbranchCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<Verification>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommitsearchresultitemCommitAuthor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<chrono::DateTime<chrono::Utc>>,
}

/// Community Profile
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommunityProfile {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub health_percentage: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<CommunityprofileFiles>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_reports_enabled: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CommunityprofileFiles {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_of_conduct: Option<NullableCodeOfConductSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_of_conduct_file: Option<NullableCommunityHealthFile>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributing: Option<NullableCommunityHealthFile>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub readme: Option<NullableCommunityHealthFile>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_template: Option<NullableCommunityHealthFile>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_template: Option<NullableCommunityHealthFile>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContainerMetadata {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags: Option<Vec<String>>,
}

/// A list of directory items
pub type ContentDirectory = Vec<ContentdirectoryInner>;

/// Content File
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentFile {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub encoding: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub submodule_git_url: Option<String>,
}

/// An object describing a symlink
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentSubmodule {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub submodule_git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
}

/// An object describing a symlink
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentSymlink {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
}

/// Content Traffic
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentTraffic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uniques: Option<i64>,
}

/// Content Tree
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentTree {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub entries: Option<Vec<ContenttreeEntries>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContentdirectoryInner {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<HashMap<String, Value>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContenttreeEntries {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContenttreeLinks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub git: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<String>,
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<String>,
}

/// Contributor
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Contributor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

/// Contributor Activity
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContributorActivity {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub weeks: Option<Vec<ContributoractivityWeeks>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ContributoractivityWeeks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub w: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub a: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub d: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub c: Option<i64>,
}

/// Converted Note to Issue Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ConvertedNoteToIssueIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<Integration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_card: Option<AddedtoprojectissueeventProjectCard>,
}

/// Credential Authorization
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct CredentialAuthorization {     
    /// User login that owns the underlying credential.
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    /// Unique identifier for the credential.
    #[serde(skip_serializing_if="Option::is_none")]
    pub credential_id: Option<i64>,
    /// Human-readable description of the credential type.
    #[serde(skip_serializing_if="Option::is_none")]
    pub credential_type: Option<String>,
    /// Last eight characters of the credential. Only included in responses with credential_type of personal access token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub token_last_eight: Option<String>,
    /// Date when the credential was authorized for use.
    #[serde(skip_serializing_if="Option::is_none")]
    pub credential_authorized_at: Option<chrono::DateTime<chrono::Utc>>,
    /// List of oauth scopes the token has been granted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub scopes: Option<Vec<String>>,
    /// Unique string to distinguish the credential. Only included in responses with credential_type of SSH Key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub fingerprint: Option<String>,
    /// Date when the credential was last accessed. May be null if it was never accessed
    #[serde(skip_serializing_if="Option::is_none")]
    pub credential_accessed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub authorized_credential_id: Option<i64>,
    /// The title given to the ssh key. This will only be present when the credential is an ssh key.
    #[serde(skip_serializing_if="Option::is_none")]
    pub authorized_credential_title: Option<String>,
    /// The note given to the token. This will only be present when the credential is a token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub authorized_credential_note: Option<String>,
    /// The expiry for the token. This will only be present when the credential is a token.
    #[serde(skip_serializing_if="Option::is_none")]
    pub authorized_credential_expires_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Demilestoned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DemilestonedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<MilestonedissueeventMilestone>,
}

/// An SSH key granting access to a single repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeployKey {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub read_only: Option<bool>,
}

/// A request for a specific ref(branch,sha,tag) to be deployed
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Deployment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// Unique identifier of the deployment
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// The ref to deploy. This can be a branch, tag, or sha.
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    /// Parameter to specify a task to execute
    #[serde(skip_serializing_if="Option::is_none")]
    pub task: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<DeploymentPayload>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_environment: Option<String>,
    /// Name for the target deployment environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    /// Specifies if the given environment is will no longer exist at some point in the future. Default: false.
    #[serde(skip_serializing_if="Option::is_none")]
    pub transient_environment: Option<bool>,
    /// Specifies if the given environment is one that end-users directly interact with. Default: false.
    #[serde(skip_serializing_if="Option::is_none")]
    pub production_environment: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
}

/// The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeploymentBranchPolicy {     
    /// Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub protected_branches: Option<bool>,
    /// Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub custom_branch_policies: Option<bool>,
}

/// The type of reviewer. Must be one of: `User` or `Team`
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum DeploymentReviewerType { 
    #[serde(rename = "User")]
    USER,
    #[serde(rename = "Team")]
    TEAM,
}

impl Display for DeploymentReviewerType {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            DeploymentReviewerType::USER => write!(f, "{}", "User"),
            DeploymentReviewerType::TEAM => write!(f, "{}", "Team"),
        }
    }
}

impl std::str::FromStr for DeploymentReviewerType {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "User" => Ok(DeploymentReviewerType::USER),
            "Team" => Ok(DeploymentReviewerType::TEAM),
            _ => Err(()),
        }
    }
}

/// A deployment created as the result of an Actions check run from a workflow that references an environment
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeploymentSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// Unique identifier of the deployment
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// Parameter to specify a task to execute
    #[serde(skip_serializing_if="Option::is_none")]
    pub task: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_environment: Option<String>,
    /// Name for the target deployment environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    /// Specifies if the given environment is will no longer exist at some point in the future. Default: false.
    #[serde(skip_serializing_if="Option::is_none")]
    pub transient_environment: Option<bool>,
    /// Specifies if the given environment is one that end-users directly interact with. Default: false.
    #[serde(skip_serializing_if="Option::is_none")]
    pub production_environment: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
}

/// The status of a deployment.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeploymentStatus {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The state of the status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    /// A short description of the status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The environment of the deployment that the status is for.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<String>,
    /// Deprecated: the URL to associate with this status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    /// The URL for accessing your environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment_url: Option<String>,
    /// The URL to associate with this status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub log_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
}

/// Diff Entry
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DiffEntry {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub filename: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub additions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deletions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub changes: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blob_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub patch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_filename: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DockerMetadata {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag: Option<Vec<String>>,
}

/// Email
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Email {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
}

/// An object without any properties.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EmptyObject {     
}

/// The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum EnabledOrganizations { 
    #[serde(rename = "all")]
    ALL,
    #[serde(rename = "none")]
    NONE,
    #[serde(rename = "selected")]
    SELECTED,
}

impl Display for EnabledOrganizations {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            EnabledOrganizations::ALL => write!(f, "{}", "all"),
            EnabledOrganizations::NONE => write!(f, "{}", "none"),
            EnabledOrganizations::SELECTED => write!(f, "{}", "selected"),
        }
    }
}

impl std::str::FromStr for EnabledOrganizations {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "all" => Ok(EnabledOrganizations::ALL),
            "none" => Ok(EnabledOrganizations::NONE),
            "selected" => Ok(EnabledOrganizations::SELECTED),
            _ => Err(()),
        }
    }
}

/// The policy that controls the repositories in the organization that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum EnabledRepositories { 
    #[serde(rename = "all")]
    ALL,
    #[serde(rename = "none")]
    NONE,
    #[serde(rename = "selected")]
    SELECTED,
}

impl Display for EnabledRepositories {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            EnabledRepositories::ALL => write!(f, "{}", "all"),
            EnabledRepositories::NONE => write!(f, "{}", "none"),
            EnabledRepositories::SELECTED => write!(f, "{}", "selected"),
        }
    }
}

impl std::str::FromStr for EnabledRepositories {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "all" => Ok(EnabledRepositories::ALL),
            "none" => Ok(EnabledRepositories::NONE),
            "selected" => Ok(EnabledRepositories::SELECTED),
            _ => Err(()),
        }
    }
}

/// An enterprise account
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Enterprise {     
    /// A short description of the enterprise.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// The enterprise's website URL.
    #[serde(skip_serializing_if="Option::is_none")]
    pub website_url: Option<String>,
    /// Unique identifier of the enterprise
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the enterprise.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The slug url identifier for the enterprise.
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
}

/// Details of a deployment environment
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Environment {     
    /// The id of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// The time that the environment was created, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The time that the environment was last updated, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection_rules: Option<Vec<EnvironmentProtectionRulesItems>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployment_branch_policy: Option<DeploymentBranchPolicy>,
}

/// An entry in the reviews log for environment deployments
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentApprovals {     
    /// The list of environments that were approved or rejected
    #[serde(skip_serializing_if="Option::is_none")]
    pub environments: Option<Vec<EnvironmentapprovalsEnvironments>>,
    /// Whether deployment to the environment(s) was approved or rejected
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<SimpleUser>,
    /// The comment submitted with the deployment review
    #[serde(skip_serializing_if="Option::is_none")]
    pub comment: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EnvironmentapprovalsEnvironments {     
    /// The id of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// The time that the environment was created, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The time that the environment was last updated, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Event {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<Actor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<EventRepo>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub org: Option<Actor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<EventPayload>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EventPayload {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub action: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue: Option<Issue>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comment: Option<IssueComment>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pages: Option<Vec<EventPayloadPages>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EventPayloadPages {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub page_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub summary: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub action: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct EventRepo {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Information about an external group's usage and its members
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ExternalGroup {     
    /// The internal ID of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<i64>,
    /// The display name for the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_name: Option<String>,
    /// The date when the group was last updated_at
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    /// An array of teams linked to this group
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<ExternalgroupTeams>>,
    /// An array of external members linked to this group
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<Vec<ExternalgroupMembers>>,
}

/// A list of external groups available to be connected to a team
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ExternalGroups {     
    /// An array of external groups available to be mapped to a team
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<ExternalgroupsGroups>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ExternalgroupMembers {     
    /// The internal user ID of the identity
    #[serde(skip_serializing_if="Option::is_none")]
    pub member_id: Option<i64>,
    /// The handle/login for the user
    #[serde(skip_serializing_if="Option::is_none")]
    pub member_login: Option<String>,
    /// The user display name/profile name
    #[serde(skip_serializing_if="Option::is_none")]
    pub member_name: Option<String>,
    /// An email attached to a user
    #[serde(skip_serializing_if="Option::is_none")]
    pub member_email: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ExternalgroupTeams {     
    /// The id for a team
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_id: Option<i64>,
    /// The name of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ExternalgroupsGroups {     
    /// The internal ID of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<i64>,
    /// The display name of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_name: Option<String>,
    /// The time of the last update for this group
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
}

/// Feed
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Feed {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub timeline_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_public_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_actor_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_organization_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_organization_urls: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_advisories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<FeedLinks>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FeedLinks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub timeline: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_advisories: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_public: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_actor: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_organization: Option<LinkWithType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_organizations: Option<Vec<LinkWithType>>,
}

/// File Commit
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FileCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<FilecommitContent>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<FilecommitCommit>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<FilecommitCommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<FilecommitCommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<FilecommitCommitTree>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<FilecommitCommitParents>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<FilecommitCommitVerification>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitCommitAuthor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitCommitParents {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitCommitTree {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitCommitVerification {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub signature: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitContent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<FilecommitContentLinks>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FilecommitContentLinks {     
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<String>,
}

/// Full Repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FullRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Returns whether or not this repository disabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<FullrepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<NullableRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub source: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    /// Whether anonymous git access is allowed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub anonymous_access_enabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_of_conduct: Option<CodeOfConductSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub security_and_analysis: Option<FullrepositorySecurityAndAnalysis>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FullrepositoryPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub triage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FullrepositorySecurityAndAnalysis {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub advanced_security: Option<FullrepositorySecurityAndAnalysisAdvancedSecurity>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret_scanning: Option<FullrepositorySecurityAndAnalysisAdvancedSecurity>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct FullrepositorySecurityAndAnalysisAdvancedSecurity {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
}

/// Gist
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Gist {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_pull_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_push_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<HashMap<String, BasegistFiles>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub truncated: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub history: Option<Vec<Value>>,
}

/// A comment made to a gist.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistComment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The comment text.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
}

/// Gist Commit
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub version: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub change_status: Option<GisthistoryChangeStatus>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committed_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Gist History
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistHistory {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub version: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub change_status: Option<GisthistoryChangeStatus>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Gist Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<Vec<GistsimpleForks>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub history: Option<Vec<GistHistory>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork_of: Option<Gist>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_pull_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_push_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub files: Option<HashMap<String, GistsimpleFiles>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub truncated: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GisthistoryChangeStatus {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub additions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deletions: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistsFiles {     
    /// Content of the file
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistsgistIdFiles {     
    /// The new content of the file
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    /// The new filename for the file
    #[serde(skip_serializing_if="Option::is_none")]
    pub filename: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistsimpleFiles {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub filename: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub truncated: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GistsimpleForks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<PublicUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Low-level Git commit operations within a repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitCommit {     
    /// SHA for the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<GitcommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<GitcommitAuthor>,
    /// Message describing the purpose of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<GitcommitTree>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<GitcommitParents>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<GitcommitVerification>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Git references within a repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitRef {     
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub object: Option<GitrefObject>,
}

/// Metadata for a Git tag
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitTag {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// Name of the tag
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// URL for the tag
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// Message describing the purpose of the tag
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tagger: Option<GittagTagger>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub object: Option<GittagObject>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<Verification>,
}

/// The hierarchy between files in a Git repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitTree {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub truncated: Option<bool>,
    /// Objects specifying a tree structure
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<Vec<GittreeTree>>,
}

/// Identifying information for the git-user
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitcommitAuthor {     
    /// Timestamp of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<chrono::DateTime<chrono::Utc>>,
    /// Git email address of the user
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// Name of the git user
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitcommitParents {     
    /// SHA for the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitcommitTree {     
    /// SHA for the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitcommitVerification {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub signature: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<String>,
}

/// Gitignore Template
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitignoreTemplate {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub source: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GitrefObject {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    /// SHA for the reference
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GittagObject {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GittagTagger {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GittreeTree {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mode: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// A unique encryption key
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GpgKey {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary_key_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<GpgkeyEmails>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subkeys: Option<Vec<GpgkeySubkeys>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_sign: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_encrypt_comms: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_encrypt_storage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_certify: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_key: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GpgkeyEmails {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GpgkeySubkeys {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary_key_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subkeys: Option<Vec<Value>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_sign: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_encrypt_comms: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_encrypt_storage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_certify: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_key: Option<String>,
}

/// External Groups to be mapped to a team for membership
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GroupMapping {     
    /// Array of groups to be mapped to this team
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<GroupmappingGroups>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GroupmappingGroups {     
    /// The ID of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<String>,
    /// The name of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_name: Option<String>,
    /// a description of the group
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_description: Option<String>,
    /// synchronization status for this group mapping
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// the time of the last sync for this group-mapping
    #[serde(skip_serializing_if="Option::is_none")]
    pub synced_at: Option<String>,
}

/// Webhooks for repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Hook {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    /// Unique identifier of the webhook.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The name of a valid service, use 'web' for a webhook.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Determines whether the hook is actually triggered on pushes.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    /// Determines what events the hook is triggered for. Default: ['push'].
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<HookConfig>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub test_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ping_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deliveries_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_response: Option<HookResponse>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub password: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub room: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subdomain: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub digest: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub token: Option<String>,
}

/// Delivery made by a webhook.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookDelivery {     
    /// Unique identifier of the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
    #[serde(skip_serializing_if="Option::is_none")]
    pub guid: Option<String>,
    /// Time when the delivery was delivered.
    #[serde(skip_serializing_if="Option::is_none")]
    pub delivered_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether the delivery is a redelivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub redelivery: Option<bool>,
    /// Time spent delivering.
    #[serde(skip_serializing_if="Option::is_none")]
    pub duration: Option<f64>,
    /// Description of the status of the attempted delivery
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// Status code received when delivery was made.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status_code: Option<i64>,
    /// The event that triggered the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    /// The type of activity for the event that triggered the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub action: Option<String>,
    /// The id of the GitHub App installation associated with this event.
    #[serde(skip_serializing_if="Option::is_none")]
    pub installation_id: Option<i64>,
    /// The id of the repository associated with this event.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_id: Option<i64>,
    /// The URL target of the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub request: Option<HookdeliveryRequest>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub response: Option<HookdeliveryResponse>,
}

/// Delivery made by a webhook, without request and response information.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookDeliveryItem {     
    /// Unique identifier of the webhook delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
    #[serde(skip_serializing_if="Option::is_none")]
    pub guid: Option<String>,
    /// Time when the webhook delivery occurred.
    #[serde(skip_serializing_if="Option::is_none")]
    pub delivered_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether the webhook delivery is a redelivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub redelivery: Option<bool>,
    /// Time spent delivering.
    #[serde(skip_serializing_if="Option::is_none")]
    pub duration: Option<f64>,
    /// Describes the response returned after attempting the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// Status code received when delivery was made.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status_code: Option<i64>,
    /// The event that triggered the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    /// The type of activity for the event that triggered the delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub action: Option<String>,
    /// The id of the GitHub App installation associated with this event.
    #[serde(skip_serializing_if="Option::is_none")]
    pub installation_id: Option<i64>,
    /// The id of the repository associated with this event.
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_id: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookResponse {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookdeliveryRequest {     
    /// The request headers sent with the webhook delivery.
    #[serde(skip_serializing_if="Option::is_none")]
    pub headers: Option<HashMap<String, HashMap<String, Value>>>,
    /// The webhook payload.
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<HashMap<String, HashMap<String, Value>>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HookdeliveryResponse {     
    /// The response headers received when the delivery was made.
    #[serde(skip_serializing_if="Option::is_none")]
    pub headers: Option<HashMap<String, HashMap<String, Value>>>,
    /// The response payload received.
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<HashMap<String, HashMap<String, Value>>>,
}

/// Hovercard
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Hovercard {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts: Option<Vec<HovercardContexts>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct HovercardContexts {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub octicon: Option<String>,
}

/// A repository import from an external source.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Import {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub use_lfs: Option<bool>,
    /// The URL of the originating repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svc_root: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tfvc_project: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub failed_step: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub error_message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub import_percent: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push_percent: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_large_files: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub large_files_size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub large_files_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_choices: Option<Vec<ImportProjectChoices>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub authors_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub authors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_root: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ImportProjectChoices {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub vcs: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tfvc_project: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub human_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetMetaRootResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_authorizations_html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub authorizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emojis_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub feeds_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hub_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub label_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rate_limit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topic_search_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_search_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetEnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations: Option<Vec<OrganizationSimple>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListRepoAccessToSelfHostedRunnerGroupInOrgResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<MinimalRepository>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListSelfHostedRunnersForRepoResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<Runner>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListOrgSecretsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secrets: Option<Vec<OrganizationActionsSecret>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetCodespacesListRepositoriesForSecretForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<MinimalRepository>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetAppsListInstallationsForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub installations: Option<Vec<Installation>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetInteractionsGetRestrictionsForAuthenticatedUserResponse200 { 
    GetInteractionsGetRestrictionsForAuthenticatedUserResponse200Variant0(InteractionLimitResponse),
    GetInteractionsGetRestrictionsForAuthenticatedUserResponse200Variant1(HashMap<String, Value>),
}

impl From<InteractionLimitResponse> for GetInteractionsGetRestrictionsForAuthenticatedUserResponse200 {
    fn from(value: InteractionLimitResponse) -> Self {
        GetInteractionsGetRestrictionsForAuthenticatedUserResponse200::GetInteractionsGetRestrictionsForAuthenticatedUserResponse200Variant0(value)
    }
}

impl From<HashMap<String, Value>> for GetInteractionsGetRestrictionsForAuthenticatedUserResponse200 {
    fn from(value: HashMap<String, Value>) -> Self {
        GetInteractionsGetRestrictionsForAuthenticatedUserResponse200::GetInteractionsGetRestrictionsForAuthenticatedUserResponse200Variant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListWorkflowRunArtifactsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub artifacts: Option<Vec<Artifact>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListWorkflowRunsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub workflow_runs: Option<Vec<WorkflowRun>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListJobsForWorkflowRunResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub jobs: Option<Vec<Job>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListEnvironmentSecretsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secrets: Option<Vec<ActionsSecret>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetEnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_groups: Option<Vec<RunnerGroupsEnterprise>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListRepoWorkflowsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub workflows: Option<Vec<Workflow>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetChecksListForRefResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_runs: Option<Vec<CheckRun>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetCodespacesListForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub codespaces: Option<Vec<Codespace>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetCodespacesCodespaceMachinesForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub machines: Option<Vec<CodespaceMachine>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetChecksListSuitesForRefResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_suites: Option<Vec<CheckSuite>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InlineResponse20025 { 
    InlineResponse20025Variant0(ContentDirectory),
    InlineResponse20025Variant1(ContentFile),
    InlineResponse20025Variant2(ContentSymlink),
    InlineResponse20025Variant3(ContentSubmodule),
}

impl From<ContentDirectory> for InlineResponse20025 {
    fn from(value: ContentDirectory) -> Self {
        InlineResponse20025::InlineResponse20025Variant0(value)
    }
}

impl From<ContentFile> for InlineResponse20025 {
    fn from(value: ContentFile) -> Self {
        InlineResponse20025::InlineResponse20025Variant1(value)
    }
}

impl From<ContentSymlink> for InlineResponse20025 {
    fn from(value: ContentSymlink) -> Self {
        InlineResponse20025::InlineResponse20025Variant2(value)
    }
}

impl From<ContentSubmodule> for InlineResponse20025 {
    fn from(value: ContentSubmodule) -> Self {
        InlineResponse20025::InlineResponse20025Variant3(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetReposGetAllEnvironmentsResponse200 {     
    /// The number of environments in this repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub environments: Option<Vec<Environment>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetActivityListStargazersForRepoResponse200 { 
    GetActivityListStargazersForRepoResponse200Variant0(Vec<SimpleUser>),
    GetActivityListStargazersForRepoResponse200Variant1(Vec<Stargazer>),
}

impl From<Vec<SimpleUser>> for GetActivityListStargazersForRepoResponse200 {
    fn from(value: Vec<SimpleUser>) -> Self {
        GetActivityListStargazersForRepoResponse200::GetActivityListStargazersForRepoResponse200Variant0(value)
    }
}

impl From<Vec<Stargazer>> for GetActivityListStargazersForRepoResponse200 {
    fn from(value: Vec<Stargazer>) -> Self {
        GetActivityListStargazersForRepoResponse200::GetActivityListStargazersForRepoResponse200Variant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchCodeResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<CodeSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchCommitsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<CommitSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListSelfHostedRunnersInGroupForOrgResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<Runner>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchIssuesAndPullRequestsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<IssueSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchLabelsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<LabelSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchReposResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<RepoSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchTopicsResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<TopicSearchResultItem>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchUsersResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub incomplete_results: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub items: Option<Vec<UserSearchResultItem>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetUsersGetByUsernameResponse200 { 
    GetUsersGetByUsernameResponse200Variant0(PrivateUser),
    GetUsersGetByUsernameResponse200Variant1(PublicUser),
}

impl From<PrivateUser> for GetUsersGetByUsernameResponse200 {
    fn from(value: PrivateUser) -> Self {
        GetUsersGetByUsernameResponse200::GetUsersGetByUsernameResponse200Variant0(value)
    }
}

impl From<PublicUser> for GetUsersGetByUsernameResponse200 {
    fn from(value: PublicUser) -> Self {
        GetUsersGetByUsernameResponse200::GetUsersGetByUsernameResponse200Variant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetCodespacesListSecretsForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secrets: Option<Vec<CodespacesSecret>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetAppsListInstallationReposForAuthenticatedUserResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetActivityListReposStarredByUserResponse200 { 
    GetActivityListReposStarredByUserResponse200Variant0(Vec<StarredRepository>),
    GetActivityListReposStarredByUserResponse200Variant1(Vec<Repository>),
}

impl From<Vec<StarredRepository>> for GetActivityListReposStarredByUserResponse200 {
    fn from(value: Vec<StarredRepository>) -> Self {
        GetActivityListReposStarredByUserResponse200::GetActivityListReposStarredByUserResponse200Variant0(value)
    }
}

impl From<Vec<Repository>> for GetActivityListReposStarredByUserResponse200 {
    fn from(value: Vec<Repository>) -> Self {
        GetActivityListReposStarredByUserResponse200::GetActivityListReposStarredByUserResponse200Variant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetEnterpriseAdminListSelfHostedRunnersForEnterpriseResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners: Option<Vec<Runner>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct DeleteActionsRemoveCustomLabelFromSelfHostedRunnerForRepoResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<RunnerLabel>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetAppsListReposAccessibleToInstallationResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetOrgsListCustomRolesResponse200 {     
    /// The number of custom roles in this organization
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub custom_roles: Option<Vec<OrganizationCustomRepositoryRole>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListSelectedRepositoriesEnabledGithubActionsOrganizationResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetActionsListSelfHostedRunnerGroupsForOrgResponse200 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_groups: Option<Vec<RunnerGroupsOrg>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostAppsCreateFromManifestResponse201 {     
    /// Unique identifier of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The slug name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    /// The name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<IntegrationPermissions>,
    /// The list of events for the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// The number of installations associated with the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub installations_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub webhook_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pem: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostReposCreateDeploymentResponse202 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutPullsUpdateBranchResponse202 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetGistsGetCommentResponse403 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub block: Option<InlineResponse403Block>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PatchProjectsUpdateResponse403 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsMoveCardResponse403 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<InlineResponse4032Errors>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct InlineResponse4032Errors {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resource: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub field: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct InlineResponse403Block {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateForAuthenticatedUserResponse415 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostProjectsCreateCardResponse422 { 
    PostProjectsCreateCardResponse422Variant0(ValidationError),
    PostProjectsCreateCardResponse422Variant1(ValidationErrorSimple),
}

impl From<ValidationError> for PostProjectsCreateCardResponse422 {
    fn from(value: ValidationError) -> Self {
        PostProjectsCreateCardResponse422::PostProjectsCreateCardResponse422Variant0(value)
    }
}

impl From<ValidationErrorSimple> for PostProjectsCreateCardResponse422 {
    fn from(value: ValidationErrorSimple) -> Self {
        PostProjectsCreateCardResponse422::PostProjectsCreateCardResponse422Variant1(value)
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct GetSearchUsersResponse503 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PostProjectsCreateCardResponse503 {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<InlineResponse5031Errors>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct InlineResponse5031Errors {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
}

/// Installation
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Installation {     
    /// The ID of the installation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub account: Option<InstallationAccount>,
    /// Describe whether all repositories have been selected or there's a selection involved
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub access_tokens_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
    /// The ID of the user or organization this token is being scoped to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<AppPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_multiple_single_files: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file_paths: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub suspended_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub suspended_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contact_email: Option<String>,
}

/// Authentication token for a GitHub App installed on a user or org.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct InstallationToken {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<AppPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_multiple_single_files: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file_paths: Option<Vec<String>>,
}

/// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Integration {     
    /// Unique identifier of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The slug name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    /// The name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<IntegrationPermissions>,
    /// The list of events for the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// The number of installations associated with the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub installations_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub webhook_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pem: Option<String>,
}

/// The set of permissions for the GitHub app
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IntegrationPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub metadata: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments: Option<String>,
}

/// The duration of the interaction restriction. Can be one of: `one_day`, `three_days`, `one_week`, `one_month`, `six_months`. Default: `one_day`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum InteractionExpiry { 
    #[serde(rename = "one_day")]
    ONE_DAY,
    #[serde(rename = "three_days")]
    THREE_DAYS,
    #[serde(rename = "one_week")]
    ONE_WEEK,
    #[serde(rename = "one_month")]
    ONE_MONTH,
    #[serde(rename = "six_months")]
    SIX_MONTHS,
}

impl Display for InteractionExpiry {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            InteractionExpiry::ONE_DAY => write!(f, "{}", "one_day"),
            InteractionExpiry::THREE_DAYS => write!(f, "{}", "three_days"),
            InteractionExpiry::ONE_WEEK => write!(f, "{}", "one_week"),
            InteractionExpiry::ONE_MONTH => write!(f, "{}", "one_month"),
            InteractionExpiry::SIX_MONTHS => write!(f, "{}", "six_months"),
        }
    }
}

impl std::str::FromStr for InteractionExpiry {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "one_day" => Ok(InteractionExpiry::ONE_DAY),
            "three_days" => Ok(InteractionExpiry::THREE_DAYS),
            "one_week" => Ok(InteractionExpiry::ONE_WEEK),
            "one_month" => Ok(InteractionExpiry::ONE_MONTH),
            "six_months" => Ok(InteractionExpiry::SIX_MONTHS),
            _ => Err(()),
        }
    }
}

/// The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect. Can be one of: `existing_users`, `contributors_only`, `collaborators_only`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum InteractionGroup { 
    #[serde(rename = "existing_users")]
    EXISTING_USERS,
    #[serde(rename = "contributors_only")]
    CONTRIBUTORS_ONLY,
    #[serde(rename = "collaborators_only")]
    COLLABORATORS_ONLY,
}

impl Display for InteractionGroup {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            InteractionGroup::EXISTING_USERS => write!(f, "{}", "existing_users"),
            InteractionGroup::CONTRIBUTORS_ONLY => write!(f, "{}", "contributors_only"),
            InteractionGroup::COLLABORATORS_ONLY => write!(f, "{}", "collaborators_only"),
        }
    }
}

impl std::str::FromStr for InteractionGroup {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "existing_users" => Ok(InteractionGroup::EXISTING_USERS),
            "contributors_only" => Ok(InteractionGroup::CONTRIBUTORS_ONLY),
            "collaborators_only" => Ok(InteractionGroup::COLLABORATORS_ONLY),
            _ => Err(()),
        }
    }
}

/// Limit interactions to a specific type of user for a specified duration
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutInteractionsSetRestrictionsForAuthenticatedUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub limit: Option<InteractionGroup>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expiry: Option<InteractionExpiry>,
}

/// Interaction limit settings.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct InteractionLimitResponse {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub limit: Option<InteractionGroup>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub origin: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Issue {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// Number uniquely identifying the issue within its repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// State of the issue; either 'open' or 'closed'
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// Title of the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// Contents of the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<IssueLabelsItems>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<NullableMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub locked: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<IssuePullRequest>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub timeline_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// Comments provide a way for people to collaborate on an issue.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueComment {     
    /// Unique identifier of the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// Contents of the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue: Option<NullableIssue>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<IssueEventLabel>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assigner: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_requester: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_reviewer: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_team: Option<Team>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_review: Option<IssueEventDismissedReview>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<IssueEventMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_card: Option<IssueEventProjectCard>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rename: Option<IssueEventRename>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEventDismissedReview {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_commit_id: Option<String>,
}

/// Issue Event for Issue
#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum IssueEventForIssue { 
    IssueEventForIssueVariant0(LabeledIssueEvent),
    IssueEventForIssueVariant1(UnlabeledIssueEvent),
    IssueEventForIssueVariant2(AssignedIssueEvent),
    IssueEventForIssueVariant3(UnassignedIssueEvent),
    IssueEventForIssueVariant4(MilestonedIssueEvent),
    IssueEventForIssueVariant5(DemilestonedIssueEvent),
    IssueEventForIssueVariant6(RenamedIssueEvent),
    IssueEventForIssueVariant7(ReviewRequestedIssueEvent),
    IssueEventForIssueVariant8(ReviewRequestRemovedIssueEvent),
    IssueEventForIssueVariant9(ReviewDismissedIssueEvent),
    IssueEventForIssueVariant10(LockedIssueEvent),
    IssueEventForIssueVariant11(AddedToProjectIssueEvent),
    IssueEventForIssueVariant12(MovedColumnInProjectIssueEvent),
    IssueEventForIssueVariant13(RemovedFromProjectIssueEvent),
    IssueEventForIssueVariant14(ConvertedNoteToIssueIssueEvent),
}

impl From<LabeledIssueEvent> for IssueEventForIssue {
    fn from(value: LabeledIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant0(value)
    }
}

impl From<UnlabeledIssueEvent> for IssueEventForIssue {
    fn from(value: UnlabeledIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant1(value)
    }
}

impl From<AssignedIssueEvent> for IssueEventForIssue {
    fn from(value: AssignedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant2(value)
    }
}

impl From<UnassignedIssueEvent> for IssueEventForIssue {
    fn from(value: UnassignedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant3(value)
    }
}

impl From<MilestonedIssueEvent> for IssueEventForIssue {
    fn from(value: MilestonedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant4(value)
    }
}

impl From<DemilestonedIssueEvent> for IssueEventForIssue {
    fn from(value: DemilestonedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant5(value)
    }
}

impl From<RenamedIssueEvent> for IssueEventForIssue {
    fn from(value: RenamedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant6(value)
    }
}

impl From<ReviewRequestedIssueEvent> for IssueEventForIssue {
    fn from(value: ReviewRequestedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant7(value)
    }
}

impl From<ReviewRequestRemovedIssueEvent> for IssueEventForIssue {
    fn from(value: ReviewRequestRemovedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant8(value)
    }
}

impl From<ReviewDismissedIssueEvent> for IssueEventForIssue {
    fn from(value: ReviewDismissedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant9(value)
    }
}

impl From<LockedIssueEvent> for IssueEventForIssue {
    fn from(value: LockedIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant10(value)
    }
}

impl From<AddedToProjectIssueEvent> for IssueEventForIssue {
    fn from(value: AddedToProjectIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant11(value)
    }
}

impl From<MovedColumnInProjectIssueEvent> for IssueEventForIssue {
    fn from(value: MovedColumnInProjectIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant12(value)
    }
}

impl From<RemovedFromProjectIssueEvent> for IssueEventForIssue {
    fn from(value: RemovedFromProjectIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant13(value)
    }
}

impl From<ConvertedNoteToIssueIssueEvent> for IssueEventForIssue {
    fn from(value: ConvertedNoteToIssueIssueEvent) -> Self {
        IssueEventForIssue::IssueEventForIssueVariant14(value)
    }
}

/// Issue Event Label
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEventLabel {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
}

/// Issue Event Milestone
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEventMilestone {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
}

/// Issue Event Project Card
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEventProjectCard {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub column_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_column_name: Option<String>,
}

/// Issue Event Rename
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueEventRename {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub from: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub to: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssuePullRequest {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub patch_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Issue Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssueSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub locked: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<IssuesearchresultitemLabels>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<NullableMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<IssuePullRequest>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub timeline_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct IssuesearchresultitemLabels {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

/// Information of a job execution in a workflow run
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Job {     
    /// The id of the job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The id of the associated workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_url: Option<String>,
    /// Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_attempt: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The SHA of the commit that is being run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// The phase of the lifecycle that the job is currently in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// The outcome of the job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub conclusion: Option<String>,
    /// The time that the job started, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub started_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The time that the job finished, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub completed_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The name of the job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Steps in this job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub steps: Option<Vec<JobSteps>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_run_url: Option<String>,
    /// Labels for the workflow job. Specified by the \"runs_on\" attribute in the action's workflow file.
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<String>>,
    /// The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_id: Option<i64>,
    /// The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_name: Option<String>,
    /// The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_group_id: Option<i64>,
    /// The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
    #[serde(skip_serializing_if="Option::is_none")]
    pub runner_group_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct JobSteps {     
    /// The phase of the lifecycle that the job is currently in.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// The outcome of the job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub conclusion: Option<String>,
    /// The name of the job.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// The time that the step started, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub started_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The time that the job finished, in ISO 8601 format.
    #[serde(skip_serializing_if="Option::is_none")]
    pub completed_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Key
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Key {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub read_only: Option<bool>,
}

/// Key Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct KeySimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
}

/// Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Label {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the label
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The name of the label.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// 6-character hex code, without the leading #, identifying the color
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
}

/// Label Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LabelSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
}

/// Labeled Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LabeledIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<LabeledissueeventLabel>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LabeledissueeventLabel {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
}

/// Language
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Language {     
}

/// License
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct License {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub spdx_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub implementation: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub conditions: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub limitations: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub featured: Option<bool>,
}

/// License Content
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LicenseContent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub encoding: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ContenttreeLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
}

/// License Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LicenseSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub spdx_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Hypermedia Link
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Link {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
}

/// Hypermedia Link with Type
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LinkWithType {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

/// Locked Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct LockedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_reason: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MarketplaceAccount {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_billing_email: Option<String>,
}

/// Marketplace Listing Plan
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MarketplaceListingPlan {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub accounts_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub monthly_price_in_cents: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub yearly_price_in_cents: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub price_model: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_free_trial: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub unit_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bullets: Option<Vec<String>>,
}

/// Marketplace Purchase
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MarketplacePurchase {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_billing_email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub marketplace_pending_change: Option<MarketplacepurchaseMarketplacePendingChange>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub marketplace_purchase: Option<MarketplacepurchaseMarketplacePurchase>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MarketplacepurchaseMarketplacePendingChange {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_installed: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub effective_date: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub unit_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<MarketplaceListingPlan>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MarketplacepurchaseMarketplacePurchase {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub billing_cycle: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub next_billing_date: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_installed: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub unit_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub on_free_trial: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub free_trial_ends_on: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<MarketplaceListingPlan>,
}

/// Results of a successful merge upstream request
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MergedUpstream {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub base_branch: Option<String>,
}

/// A migration.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Migration {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub guid: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub lock_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_metadata: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_git_data: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_attachments: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_releases: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude_owner_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories: Option<Vec<Repository>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub exclude: Option<Vec<Value>>,
}

/// A collection of related issues and pull requests.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Milestone {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The number of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// The state of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The title of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub due_on: Option<chrono::DateTime<chrono::Utc>>,
}

/// Milestoned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MilestonedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<MilestonedissueeventMilestone>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MilestonedissueeventMilestone {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
}

/// Minimal Repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MinimalRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryTemplateRepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<NullableRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_of_conduct: Option<CodeOfConduct>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<MinimalrepositoryLicense>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MinimalrepositoryLicense {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub spdx_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
}

/// Moved Column in Project Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct MovedColumnInProjectIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_card: Option<AddedtoprojectissueeventProjectCard>,
}

/// Code of Conduct Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableCodeOfConductSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// A description of the machine powering a codespace.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableCodespaceMachine {     
    /// The name of the machine.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The display name of the machine includes cores, memory, and storage.
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    /// The operating system of the machine.
    #[serde(skip_serializing_if="Option::is_none")]
    pub operating_system: Option<String>,
    /// How much storage is available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub storage_in_bytes: Option<i64>,
    /// How much memory is available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub memory_in_bytes: Option<i64>,
    /// How many cores are available to the codespace.
    #[serde(skip_serializing_if="Option::is_none")]
    pub cpus: Option<i64>,
    /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be \"null\" if prebuilds are not supported or prebuild availability could not be determined. Value is the type of prebuild available, or \"none\" if none are available.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prebuild_availability: Option<String>,
}

/// Collaborator
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableCollaborator {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<CollaboratorPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableCommunityHealthFile {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Metaproperties for Git author/committer information.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableGitUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<String>,
}

/// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableIntegration {     
    /// Unique identifier of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The slug name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    /// The name of the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<IntegrationPermissions>,
    /// The list of events for the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    /// The number of installations associated with the GitHub app
    #[serde(skip_serializing_if="Option::is_none")]
    pub installations_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub client_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub webhook_secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pem: Option<String>,
}

/// Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableIssue {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// Number uniquely identifying the issue within its repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// State of the issue; either 'open' or 'closed'
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// Title of the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// Contents of the issue
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<NullableIssueLabelsItems>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<NullableMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub locked: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<IssuePullRequest>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub timeline_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// License Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableLicenseSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub spdx_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// A collection of related issues and pull requests.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableMilestone {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The number of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// The state of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The title of the milestone.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub due_on: Option<chrono::DateTime<chrono::Utc>>,
}

/// Minimal Repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableMinimalRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryTemplateRepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<NullableRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_of_conduct: Option<CodeOfConduct>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<MinimalrepositoryLicense>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
}

/// A git repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableRepository {     
    /// Unique identifier of the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    /// Whether the repository is private or public.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    /// The default branch of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    /// Whether this repository acts as a template that can be used to generate new repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    /// Whether issues are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Whether projects are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Whether the wiki is enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    /// Whether downloads are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    /// Whether the repository is archived.
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Returns whether or not this repository disabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether to allow rebase merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<RepositoryTemplateRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    /// Whether to allow squash merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Whether to allow Auto-merge to be used on pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Whether to delete head branches when pull requests are merged
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    /// Whether to allow merge commits for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Whether to allow forking this repo
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableScopedInstallation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<AppPermissions>,
    /// Describe whether all repositories have been selected or there's a selection involved
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_selection: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_multiple_single_files: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub single_file_paths: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub account: Option<SimpleUser>,
}

/// Simple Commit
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableSimpleCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub timestamp: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullablesimplecommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullablesimplecommitAuthor>,
}

/// Simple User
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableSimpleUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<String>,
}

/// Groups of organization members that gives permissions on specified repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullableTeamSimple {     
    /// Unique identifier of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    /// Name of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Description of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Permission that the team will have for its repositories
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    /// The level of privacy this team should have
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    /// Distinguished Name (DN) that team maps to within LDAP environment
    #[serde(skip_serializing_if="Option::is_none")]
    pub ldap_dn: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct NullablesimplecommitAuthor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostReposCreateDeploymentPayloadEnum { 
    PostReposCreateDeploymentPayloadEnumVariant0(HashMap<String, HashMap<String, Value>>),
    PostReposCreateDeploymentPayloadEnumVariant1(String),
}

impl From<HashMap<String, HashMap<String, Value>>> for PostReposCreateDeploymentPayloadEnum {
    fn from(value: HashMap<String, HashMap<String, Value>>) -> Self {
        PostReposCreateDeploymentPayloadEnum::PostReposCreateDeploymentPayloadEnumVariant0(value)
    }
}

impl From<String> for PostReposCreateDeploymentPayloadEnum {
    fn from(value: String) -> Self {
        PostReposCreateDeploymentPayloadEnum::PostReposCreateDeploymentPayloadEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostIssuesCreateLabelsItemsEnum { 
    PostIssuesCreateLabelsItemsEnumVariant0(String),
    PostIssuesCreateLabelsItemsEnumVariant1(HashMap<String, Value>),
}

impl From<String> for PostIssuesCreateLabelsItemsEnum {
    fn from(value: String) -> Self {
        PostIssuesCreateLabelsItemsEnum::PostIssuesCreateLabelsItemsEnumVariant0(value)
    }
}

impl From<HashMap<String, Value>> for PostIssuesCreateLabelsItemsEnum {
    fn from(value: HashMap<String, Value>) -> Self {
        PostIssuesCreateLabelsItemsEnum::PostIssuesCreateLabelsItemsEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostIssuesCreateMilestoneEnum { 
    PostIssuesCreateMilestoneEnumVariant0(String),
    PostIssuesCreateMilestoneEnumVariant1(i32),
}

impl From<String> for PostIssuesCreateMilestoneEnum {
    fn from(value: String) -> Self {
        PostIssuesCreateMilestoneEnum::PostIssuesCreateMilestoneEnumVariant0(value)
    }
}

impl From<i32> for PostIssuesCreateMilestoneEnum {
    fn from(value: i32) -> Self {
        PostIssuesCreateMilestoneEnum::PostIssuesCreateMilestoneEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostIssuesCreateTitleEnum { 
    PostIssuesCreateTitleEnumVariant0(String),
    PostIssuesCreateTitleEnumVariant1(i32),
}

impl From<String> for PostIssuesCreateTitleEnum {
    fn from(value: String) -> Self {
        PostIssuesCreateTitleEnum::PostIssuesCreateTitleEnumVariant0(value)
    }
}

impl From<i32> for PostIssuesCreateTitleEnum {
    fn from(value: i32) -> Self {
        PostIssuesCreateTitleEnum::PostIssuesCreateTitleEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PatchIssuesUpdateLabelsItemsEnum { 
    PatchIssuesUpdateLabelsItemsEnumVariant0(String),
    PatchIssuesUpdateLabelsItemsEnumVariant1(HashMap<String, Value>),
}

impl From<String> for PatchIssuesUpdateLabelsItemsEnum {
    fn from(value: String) -> Self {
        PatchIssuesUpdateLabelsItemsEnum::PatchIssuesUpdateLabelsItemsEnumVariant0(value)
    }
}

impl From<HashMap<String, Value>> for PatchIssuesUpdateLabelsItemsEnum {
    fn from(value: HashMap<String, Value>) -> Self {
        PatchIssuesUpdateLabelsItemsEnum::PatchIssuesUpdateLabelsItemsEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PatchIssuesUpdateMilestoneEnum { 
    PatchIssuesUpdateMilestoneEnumVariant0(String),
    PatchIssuesUpdateMilestoneEnumVariant1(i32),
}

impl From<String> for PatchIssuesUpdateMilestoneEnum {
    fn from(value: String) -> Self {
        PatchIssuesUpdateMilestoneEnum::PatchIssuesUpdateMilestoneEnumVariant0(value)
    }
}

impl From<i32> for PatchIssuesUpdateMilestoneEnum {
    fn from(value: i32) -> Self {
        PatchIssuesUpdateMilestoneEnum::PatchIssuesUpdateMilestoneEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PatchIssuesUpdateTitleEnum { 
    PatchIssuesUpdateTitleEnumVariant0(String),
    PatchIssuesUpdateTitleEnumVariant1(i32),
}

impl From<String> for PatchIssuesUpdateTitleEnum {
    fn from(value: String) -> Self {
        PatchIssuesUpdateTitleEnum::PatchIssuesUpdateTitleEnumVariant0(value)
    }
}

impl From<i32> for PatchIssuesUpdateTitleEnum {
    fn from(value: i32) -> Self {
        PatchIssuesUpdateTitleEnum::PatchIssuesUpdateTitleEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PostGistsCreatePublicEnum { 
    PostGistsCreatePublicEnumVariant0(bool),
    PostGistsCreatePublicEnumVariant1(String),
}

impl From<bool> for PostGistsCreatePublicEnum {
    fn from(value: bool) -> Self {
        PostGistsCreatePublicEnum::PostGistsCreatePublicEnumVariant0(value)
    }
}

impl From<String> for PostGistsCreatePublicEnum {
    fn from(value: String) -> Self {
        PostGistsCreatePublicEnum::PostGistsCreatePublicEnumVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeploymentPayload { 
    DeploymentPayloadVariant0(HashMap<String, HashMap<String, Value>>),
    DeploymentPayloadVariant1(String),
}

impl From<HashMap<String, HashMap<String, Value>>> for DeploymentPayload {
    fn from(value: HashMap<String, HashMap<String, Value>>) -> Self {
        DeploymentPayload::DeploymentPayloadVariant0(value)
    }
}

impl From<String> for DeploymentPayload {
    fn from(value: String) -> Self {
        DeploymentPayload::DeploymentPayloadVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum IssueLabelsItems { 
    IssueLabelsItemsVariant0(String),
    IssueLabelsItemsVariant1(HashMap<String, Value>),
}

impl From<String> for IssueLabelsItems {
    fn from(value: String) -> Self {
        IssueLabelsItems::IssueLabelsItemsVariant0(value)
    }
}

impl From<HashMap<String, Value>> for IssueLabelsItems {
    fn from(value: HashMap<String, Value>) -> Self {
        IssueLabelsItems::IssueLabelsItemsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum NullableIssueLabelsItems { 
    NullableIssueLabelsItemsVariant0(String),
    NullableIssueLabelsItemsVariant1(HashMap<String, Value>),
}

impl From<String> for NullableIssueLabelsItems {
    fn from(value: String) -> Self {
        NullableIssueLabelsItems::NullableIssueLabelsItemsVariant0(value)
    }
}

impl From<HashMap<String, Value>> for NullableIssueLabelsItems {
    fn from(value: HashMap<String, Value>) -> Self {
        NullableIssueLabelsItems::NullableIssueLabelsItemsVariant1(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ScimuserOperationsValue { 
    ScimuserOperationsValueVariant0(String),
    ScimuserOperationsValueVariant1(HashMap<String, Value>),
    ScimuserOperationsValueVariant2(Vec<Value>),
}

impl From<String> for ScimuserOperationsValue {
    fn from(value: String) -> Self {
        ScimuserOperationsValue::ScimuserOperationsValueVariant0(value)
    }
}

impl From<HashMap<String, Value>> for ScimuserOperationsValue {
    fn from(value: HashMap<String, Value>) -> Self {
        ScimuserOperationsValue::ScimuserOperationsValueVariant1(value)
    }
}

impl From<Vec<Value>> for ScimuserOperationsValue {
    fn from(value: Vec<Value>) -> Self {
        ScimuserOperationsValue::ScimuserOperationsValueVariant2(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum Scimv2organizationsorgUsersscimUserIdOperationsValue { 
    Scimv2organizationsorgUsersscimUserIdOperationsValueVariant0(HashMap<String, Value>),
    Scimv2organizationsorgUsersscimUserIdOperationsValueVariant1(Vec<Value>),
    Scimv2organizationsorgUsersscimUserIdOperationsValueVariant2(String),
}

impl From<HashMap<String, Value>> for Scimv2organizationsorgUsersscimUserIdOperationsValue {
    fn from(value: HashMap<String, Value>) -> Self {
        Scimv2organizationsorgUsersscimUserIdOperationsValue::Scimv2organizationsorgUsersscimUserIdOperationsValueVariant0(value)
    }
}

impl From<Vec<Value>> for Scimv2organizationsorgUsersscimUserIdOperationsValue {
    fn from(value: Vec<Value>) -> Self {
        Scimv2organizationsorgUsersscimUserIdOperationsValue::Scimv2organizationsorgUsersscimUserIdOperationsValueVariant1(value)
    }
}

impl From<String> for Scimv2organizationsorgUsersscimUserIdOperationsValue {
    fn from(value: String) -> Self {
        Scimv2organizationsorgUsersscimUserIdOperationsValue::Scimv2organizationsorgUsersscimUserIdOperationsValueVariant2(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SecretScanningLocationDetails { 
    SecretScanningLocationDetailsVariant0(SecretScanningLocationCommit),
}

impl From<SecretScanningLocationCommit> for SecretScanningLocationDetails {
    fn from(value: SecretScanningLocationCommit) -> Self {
        SecretScanningLocationDetails::SecretScanningLocationDetailsVariant0(value)
    }
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ValidationerrorErrorsValue { 
    ValidationerrorErrorsValueVariant0(String),
    ValidationerrorErrorsValueVariant1(i32),
    ValidationerrorErrorsValueVariant2(Vec<String>),
}

impl From<String> for ValidationerrorErrorsValue {
    fn from(value: String) -> Self {
        ValidationerrorErrorsValue::ValidationerrorErrorsValueVariant0(value)
    }
}

impl From<i32> for ValidationerrorErrorsValue {
    fn from(value: i32) -> Self {
        ValidationerrorErrorsValue::ValidationerrorErrorsValueVariant1(value)
    }
}

impl From<Vec<String>> for ValidationerrorErrorsValue {
    fn from(value: Vec<String>) -> Self {
        ValidationerrorErrorsValue::ValidationerrorErrorsValueVariant2(value)
    }
}

/// Org Hook
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgHook {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ping_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deliveries_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub config: Option<OrghookConfig>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

/// Org Membership
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgMembership {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    /// The user's membership type in the organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<OrganizationSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<OrgmembershipPermissions>,
}

/// Secrets for GitHub Actions for an organization.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationActionsSecret {     
    /// The name of the secret.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Visibility of a secret
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repositories_url: Option<String>,
}

/// Custom repository roles created by organization administrators
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationCustomRepositoryRole {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

/// Organization Full
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationFull {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub twitter_username: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_organization_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_repository_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owned_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disk_usage: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub billing_email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<OrganizationfullPlan>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_repository_permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub two_factor_requirement_enabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_allowed_repository_creation_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_public_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_private_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_internal_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_public_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_create_private_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_can_fork_private_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Organization Invitation
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationInvitation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub failed_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub failed_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub inviter: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub invitation_teams_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationSecretScanningAlert {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<AlertNumber>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<AlertCreatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<AlertUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<AlertHtmlUrl>,
    /// The REST API URL of the code locations for this alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub locations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<SecretScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolution: Option<SecretScanningAlertResolution>,
    /// The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolved_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolved_by: Option<NullableSimpleUser>,
    /// The type of secret that secret scanning detected.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret_type: Option<String>,
    /// The secret that was detected.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
}

/// Organization Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrganizationfullPlan {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub space: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub filled_seats: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub seats: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrghookConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgmembershipPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub can_create_repository: Option<bool>,
}

/// Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#create-hook-config-params).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgsorghooksConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub username: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub password: Option<String>,
}

/// Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#update-hook-config-params).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgsorghookshookIdConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct OrgsorgteamsteamSlugteamsyncgroupmappingsGroups {     
    /// ID of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<String>,
    /// Name of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_name: Option<String>,
    /// Description of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_description: Option<String>,
}

/// A software package
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Package {     
    /// Unique identifier of the package.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The name of the package.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub package_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// The number of versions of the package.
    #[serde(skip_serializing_if="Option::is_none")]
    pub version_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<NullableMinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// A version of a software package
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PackageVersion {     
    /// Unique identifier of the package version.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The name of the package version.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub package_html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deleted_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub metadata: Option<PackageVersionMetadata>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PackageVersionMetadata {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub package_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub container: Option<ContainerMetadata>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub docker: Option<DockerMetadata>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PackagesBillingUsage {     
    /// Sum of the free and paid storage space (GB) for GitHuub Packages.
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_gigabytes_bandwidth_used: Option<i64>,
    /// Total paid storage space (GB) for GitHuub Packages.
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_paid_gigabytes_bandwidth_used: Option<i64>,
    /// Free storage space (GB) for GitHub Packages.
    #[serde(skip_serializing_if="Option::is_none")]
    pub included_gigabytes_bandwidth: Option<i64>,
}

/// The configuration for GitHub Pages for a repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Page {     
    /// The API address for accessing this Page resource.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The status of the most recent build of the Page.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    /// The Pages site's custom domain
    #[serde(skip_serializing_if="Option::is_none")]
    pub cname: Option<String>,
    /// The state if the domain is verified
    #[serde(skip_serializing_if="Option::is_none")]
    pub protected_domain_state: Option<String>,
    /// The timestamp when a pending domain becomes unverified.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pending_domain_unverified_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether the Page has a custom 404 page.
    #[serde(skip_serializing_if="Option::is_none")]
    pub custom_404: Option<bool>,
    /// The web address the Page can be accessed from.
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub source: Option<PagesSourceHash>,
    /// Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.
    #[serde(skip_serializing_if="Option::is_none")]
    pub public: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub https_certificate: Option<PagesHttpsCertificate>,
    /// Whether https is enabled on the domain
    #[serde(skip_serializing_if="Option::is_none")]
    pub https_enforced: Option<bool>,
}

/// Page Build
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PageBuild {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub error: Option<PagebuildError>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pusher: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub duration: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Page Build Status
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PageBuildStatus {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PagebuildError {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
}

/// Pages Health Check Status
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PagesHealthCheck {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub domain: Option<PageshealthcheckDomain>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub alt_domain: Option<PageshealthcheckDomain>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PagesHttpsCertificate {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Array of the domain set and its alternate name (if it is configured)
    #[serde(skip_serializing_if="Option::is_none")]
    pub domains: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub expires_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PagesSourceHash {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PageshealthcheckDomain {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub host: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uri: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub nameservers: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dns_resolves: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_proxied: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_cloudflare_ip: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_fastly_ip: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_old_ip_address: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_a_record: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_cname_record: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_mx_records_present: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_valid_domain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_apex_domain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub should_be_a_record: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_cname_to_github_user_domain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_cname_to_pages_dot_github_dot_com: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_cname_to_fastly: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_pointed_to_github_pages_ip: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_non_github_pages_ip_present: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_pages_domain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_served_by_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_valid: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub responds_to_https: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enforces_https: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub https_error: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_https_eligible: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub caa_error: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ParticipationStats {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub all: Option<Vec<i32>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<Vec<i32>>,
}

/// Details of a deployment that is waiting for protection rules to pass
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PendingDeployment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub environment: Option<PendingdeploymentEnvironment>,
    /// The set duration of the wait timer
    #[serde(skip_serializing_if="Option::is_none")]
    pub wait_timer: Option<i64>,
    /// The time that the wait timer began.
    #[serde(skip_serializing_if="Option::is_none")]
    pub wait_timer_started_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether the currently authenticated user can approve the deployment
    #[serde(skip_serializing_if="Option::is_none")]
    pub current_user_can_approve: Option<bool>,
    /// The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub reviewers: Option<Vec<PendingdeploymentReviewers>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PendingdeploymentEnvironment {     
    /// The id of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the environment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PendingdeploymentReviewers {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<DeploymentReviewerType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reviewer: Option<PendingdeploymentReviewersReviewer>,
}

/// Porter Author
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PorterAuthor {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub remote_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub remote_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub import_url: Option<String>,
}

/// Porter Large File
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PorterLargeFile {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub ref_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub oid: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
}

/// Private User
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PrivateUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hireable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bio: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub twitter_username: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owned_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disk_usage: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub two_factor_authentication: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<PublicuserPlan>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub suspended_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub business_plus: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ldap_dn: Option<String>,
}

/// Projects are a way to organize columns and cards of work.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Project {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub columns_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// Name of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Body of the project
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// State of the project; either 'open' or 'closed'
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The baseline permission that all organization members have on this project. Only present if owner is an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_permission: Option<String>,
    /// Whether or not this project can be seen by everyone. Only present if owner is an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
}

/// Project cards represent a scope of work.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProjectCard {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The project card's ID
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub note: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether or not the card is archived
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub column_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub column_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_url: Option<String>,
}

/// Project Collaborator Permission
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProjectCollaboratorPermission {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
}

/// Project columns contain cards of work.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProjectColumn {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub cards_url: Option<String>,
    /// The unique identifier of the project column
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// Name of the project column
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Branch protections protect branches
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedBranch {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_status_checks: Option<StatusCheckPolicy>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_pull_request_reviews: Option<ProtectedbranchRequiredPullRequestReviews>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_signatures: Option<BranchprotectionRequiredSignatures>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enforce_admins: Option<ProtectedbranchEnforceAdmins>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_linear_history: Option<ProtectedbranchRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_force_pushes: Option<ProtectedbranchRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_deletions: Option<ProtectedbranchRequiredLinearHistory>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub restrictions: Option<BranchRestrictionPolicy>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_conversation_resolution: Option<BranchprotectionRequiredLinearHistory>,
}

/// Protected Branch Admin Enforced
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedBranchAdminEnforced {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
}

/// Protected Branch Pull Request Review
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedBranchPullRequestReview {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_restrictions: Option<ProtectedbranchpullrequestreviewDismissalRestrictions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bypass_pull_request_allowances: Option<ProtectedbranchpullrequestreviewBypassPullRequestAllowances>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismiss_stale_reviews: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub require_code_owner_reviews: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_approving_review_count: Option<u8>,
}

/// Protected Branch Required Status Check
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedBranchRequiredStatusCheck {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enforcement_level: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<Vec<ProtectedbranchrequiredstatuscheckChecks>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub strict: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchEnforceAdmins {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchRequiredLinearHistory {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub enabled: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchRequiredPullRequestReviews {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismiss_stale_reviews: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub require_code_owner_reviews: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_approving_review_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_restrictions: Option<ProtectedbranchRequiredPullRequestReviewsDismissalRestrictions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bypass_pull_request_allowances: Option<ProtectedbranchRequiredPullRequestReviewsBypassPullRequestAllowances>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchRequiredPullRequestReviewsBypassPullRequestAllowances {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<Team>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchRequiredPullRequestReviewsDismissalRestrictions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub users_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<Team>>,
}

/// Allow specific users or teams to bypass pull request requirements. Set to `null` to disable.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchpullrequestreviewBypassPullRequestAllowances {     
    /// The list of users allowed to bypass pull request requirements.
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<SimpleUser>>,
    /// The list of teams allowed to bypass pull request requirements.
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<Team>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchpullrequestreviewDismissalRestrictions {     
    /// The list of users with review dismissal access.
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<SimpleUser>>,
    /// The list of teams with review dismissal access.
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<Team>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub users_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ProtectedbranchrequiredstatuscheckChecks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
}

/// Public User
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PublicUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hireable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bio: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub twitter_username: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<PublicuserPlan>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub suspended_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owned_private_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disk_usage: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PublicuserPlan {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub space: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private_repos: Option<i64>,
}

/// Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequest {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub patch_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    /// Number uniquely identifying the pull request within its repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// State of this Pull Request. Either `open` or `closed`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub locked: Option<bool>,
    /// The title of the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<PullrequestLabels>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<NullableMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_commit_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_reviewers: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_teams: Option<Vec<TeamSimple>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head: Option<PullrequestHead>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<PullrequestBase>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<PullrequestsimpleLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_merge: Option<AutoMerge>,
    /// Indicates whether or not the pull request is a draft.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mergeable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rebaseable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mergeable_state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged_by: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comments: Option<i64>,
    /// Indicates whether maintainers can modify the pull request.
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintainer_can_modify: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub additions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deletions: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub changed_files: Option<i64>,
}

/// Pull Request Merge Result
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestMergeResult {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestMinimal {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head: Option<PullrequestminimalHead>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<PullrequestminimalHead>,
}

/// Pull Request Reviews are reviews on pull requests.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestReview {     
    /// Unique identifier of the review
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    /// The text of the review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<TimelinereviewedeventLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub submitted_at: Option<chrono::DateTime<chrono::Utc>>,
    /// A commit SHA for the review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
}

/// Pull Request Review Comments are comments on a portion of the Pull Request's diff.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestReviewComment {     
    /// URL for the pull request review comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The ID of the pull request review to which the comment belongs.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_review_id: Option<i64>,
    /// The ID of the pull request review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The node ID of the pull request review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The diff of the line that the comment refers to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_hunk: Option<String>,
    /// The relative path of the file to which the comment applies.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// The line index in the diff to which the comment applies.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    /// The index of the original line in the diff to which the comment applies.
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_position: Option<i64>,
    /// The SHA of the commit to which the comment applies.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    /// The SHA of the original commit to which the comment applies.
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_commit_id: Option<String>,
    /// The comment ID to reply to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub in_reply_to_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<SimpleUser>,
    /// The text of the comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// HTML URL for the pull request review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// URL for the pull request that the review comment belongs to.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<PullrequestreviewcommentLinks>,
    /// The first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    /// The first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_start_line: Option<i64>,
    /// The side of the first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_side: Option<String>,
    /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
    /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_line: Option<i64>,
    /// The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub side: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
}

/// Pull Request Review Request
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestReviewRequest {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<Team>>,
}

/// Pull Request Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullRequestSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub patch_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub locked: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<PullrequestsimpleLabels>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestone: Option<NullableMilestone>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active_lock_reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub closed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merged_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merge_commit_sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_reviewers: Option<Vec<SimpleUser>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_teams: Option<Vec<Team>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head: Option<PullrequestsimpleHead>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub base: Option<PullrequestsimpleHead>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<PullrequestsimpleLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub auto_merge: Option<AutoMerge>,
    /// Indicates whether or not the pull request is a draft.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestBase {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<PullrequestBaseRepo>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<PullrequestHeadRepoOwner>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestBaseRepo {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<PullrequestHeadRepoOwner>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<FullrepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestHead {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<PullrequestHeadRepo>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<PullrequestHeadRepoOwner>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestHeadRepo {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<PullrequestHeadRepoOwner>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<FullrepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<PullrequestHeadRepoLicense>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestHeadRepoLicense {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub key: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub spdx_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestHeadRepoOwner {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestLabels {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestminimalHead {     
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<PullrequestminimalHeadRepo>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestminimalHeadRepo {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestreviewcommentLinks {     
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<PullrequestreviewcommentLinksSelf>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<PullrequestreviewcommentLinksHtml>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<PullrequestreviewcommentLinksPullRequest>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestreviewcommentLinksHtml {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestreviewcommentLinksPullRequest {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestreviewcommentLinksSelf {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestsimpleHead {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    #[serde(rename = "ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<Repository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestsimpleLabels {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub color: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PullrequestsimpleLinks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comments: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_comment: Option<Link>,
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<Link>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RateLimit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub limit: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub remaining: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reset: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub used: Option<i64>,
}

/// Rate Limit Overview
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RateLimitOverview {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub resources: Option<RatelimitoverviewResources>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rate: Option<RateLimit>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RatelimitoverviewResources {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub core: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub graphql: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub search: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub source_import: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub integration_manifest: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code_scanning_upload: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actions_runner_registration: Option<RateLimit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub scim: Option<RateLimit>,
}

/// Reactions to conversations provide a way to help people express their feelings more simply and effectively.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Reaction {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    /// The reaction to use
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReactionRollup {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_count: Option<i64>,
    #[serde(rename = "+1")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub plus_1: Option<i64>,
    #[serde(rename = "-1")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub minus_1: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub laugh: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub confused: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub heart: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooray: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub eyes: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rocket: Option<i64>,
}

/// Referrer Traffic
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReferrerTraffic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub referrer: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uniques: Option<i64>,
}

/// A release.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Release {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assets_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub upload_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tarball_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub zipball_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the tag.
    #[serde(skip_serializing_if="Option::is_none")]
    pub tag_name: Option<String>,
    /// Specifies the commitish value that determines where the Git tag is created from.
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_commitish: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    /// true to create a draft (unpublished) release, false to create a published one.
    #[serde(skip_serializing_if="Option::is_none")]
    pub draft: Option<bool>,
    /// Whether to identify the release as a prerelease or a full release.
    #[serde(skip_serializing_if="Option::is_none")]
    pub prerelease: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub published_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assets: Option<Vec<ReleaseAsset>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mentions_count: Option<i64>,
    /// The URL of the release discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub discussion_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// Data related to a release.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReleaseAsset {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub browser_download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The file name of the asset.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    /// State of the release asset.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uploader: Option<NullableSimpleUser>,
}

/// Generated name and body describing a release
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReleaseNotesContent {     
    /// The generated name of the release
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The generated body describing the contents of the release supporting markdown formatting
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
}

/// Removed from Project Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RemovedFromProjectIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub project_card: Option<AddedtoprojectissueeventProjectCard>,
}

/// Renamed Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RenamedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub rename: Option<RenamedissueeventRename>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RenamedissueeventRename {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub from: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub to: Option<String>,
}

/// Repo Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepoSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Returns whether or not this repository disabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<FullrepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
}

/// A git repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Repository {     
    /// Unique identifier of the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<SimpleUser>,
    /// Whether the repository is private or public.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    /// The default branch of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    /// Whether this repository acts as a template that can be used to generate new repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    /// Whether issues are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Whether projects are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Whether the wiki is enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    /// Whether downloads are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    /// Whether the repository is archived.
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Returns whether or not this repository disabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether to allow rebase merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<RepositoryTemplateRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    /// Whether to allow squash merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Whether to allow Auto-merge to be used on pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Whether to delete head branches when pull requests are merged
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    /// Whether to allow merge commits for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Whether to allow forking this repo
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<String>,
}

/// Repository Collaborator Permission
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryCollaboratorPermission {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableCollaborator>,
}

/// Repository invitations let you manage who you collaborate with.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryInvitation {     
    /// Unique identifier of the repository invitation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub invitee: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub inviter: Option<NullableSimpleUser>,
    /// The permission associated with the invitation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether or not the invitation has expired
    #[serde(skip_serializing_if="Option::is_none")]
    pub expired: Option<bool>,
    /// URL for the repository invitation
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub triage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintain: Option<bool>,
}

/// Repository invitations let you manage who you collaborate with.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositorySubscription {     
    /// Determines if notifications should be received from this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribed: Option<bool>,
    /// Determines if all notifications should be blocked from this repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub ignored: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryTemplateRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<RepositoryTemplateRepositoryOwner>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryTemplateRepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_update_branch: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryTemplateRepositoryOwner {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RepositoryTemplateRepositoryPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub triage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull: Option<bool>,
}

/// Specify which security and analysis features to enable or disable. For example, to enable GitHub Advanced Security, use this data in the body of the PATCH request: `{\"security_and_analysis\": {\"advanced_security\": {\"status\": \"enabled\"}}}`. If you have admin permissions for a private repository covered by an Advanced Security license, you can check which security and analysis features are currently enabled by using a `GET /repos/{owner}/{repo}` request.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepoSecurityAndAnalysis {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub advanced_security: Option<ReposownerrepoSecurityAndAnalysisAdvancedSecurity>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret_scanning: Option<ReposownerrepoSecurityAndAnalysisSecretScanning>,
}

/// Use the `status` property to enable or disable GitHub Advanced Security for this repository. For more information, see \"[About GitHub Advanced Security](/github/getting-started-with-github/learning-about-github/about-github-advanced-security).\"
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepoSecurityAndAnalysisAdvancedSecurity {     
    /// Can be `enabled` or `disabled`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
}

/// Use the `status` property to enable or disable secret scanning for this repository. For more information, see \"[About secret scanning](/code-security/secret-security/about-secret-scanning).\"
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepoSecurityAndAnalysisSecretScanning {     
    /// Can be `enabled` or `disabled`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
}

/// Require at least one approving review on a pull request, before merging. Set to `null` to disable.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRequiredPullRequestReviews {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_restrictions: Option<ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsDismissalRestrictions>,
    /// Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismiss_stale_reviews: Option<bool>,
    /// Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) review them.
    #[serde(skip_serializing_if="Option::is_none")]
    pub require_code_owner_reviews: Option<bool>,
    /// Specify the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.
    #[serde(skip_serializing_if="Option::is_none")]
    pub required_approving_review_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bypass_pull_request_allowances: Option<ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsBypassPullRequestAllowances>,
}

/// Allow specific users or teams to bypass pull request requirements. Set to `null` to disable.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsBypassPullRequestAllowances {     
    /// The list of user `login`s allowed to bypass pull request requirements.
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<String>>,
    /// The list of team `slug`s allowed to bypass pull request requirements.
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<String>>,
}

/// Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRequiredPullRequestReviewsDismissalRestrictions {     
    /// The list of user `login`s with dismissal access
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<String>>,
    /// The list of team `slug`s with dismissal access
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<String>>,
}

/// Require status checks to pass before merging. Set to `null` to disable.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRequiredStatusChecks {     
    /// Require branches to be up to date before merging.
    #[serde(skip_serializing_if="Option::is_none")]
    pub strict: Option<bool>,
    /// **Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control. 
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts: Option<Vec<String>>,
    /// The list of status checks to require in order to merge into this branch.
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<Vec<ReposownerrepobranchesbranchprotectionRequiredStatusChecksChecks>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRequiredStatusChecksChecks {     
    /// The name of the required check
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
    /// The ID of the GitHub App that must provide this check. Omit this field to automatically select the GitHub App that has recently provided this check, or any app if it was not set by a GitHub App. Pass -1 to explicitly allow any app to set the status.
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
}

/// Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepobranchesbranchprotectionRestrictions {     
    /// The list of user `login`s with push access
    #[serde(skip_serializing_if="Option::is_none")]
    pub users: Option<Vec<String>>,
    /// The list of team `slug`s with push access
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams: Option<Vec<String>>,
    /// The list of app `slug`s with push access
    #[serde(skip_serializing_if="Option::is_none")]
    pub apps: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocheckrunsActions {     
    /// The text to be displayed on a button in the web UI. The maximum size is 20 characters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<String>,
    /// A short explanation of what this action would do. The maximum size is 40 characters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// A reference for the action on the integrator's system. The maximum size is 20 characters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub identifier: Option<String>,
}

/// Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://docs.github.com/rest/reference/checks#output-object) description.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocheckrunsOutput {     
    /// The title of the check run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// The summary of the check run. This parameter supports Markdown.
    #[serde(skip_serializing_if="Option::is_none")]
    pub summary: Option<String>,
    /// The details of the check run. This parameter supports Markdown.
    #[serde(skip_serializing_if="Option::is_none")]
    pub text: Option<String>,
    /// Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about how you can view annotations on GitHub, see \"[About status checks](https://help.github.com/articles/about-status-checks#checks)\". See the [`annotations` object](https://docs.github.com/rest/reference/checks#annotations-object) description for details about how to use this parameter.
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotations: Option<Vec<ReposownerrepocheckrunsOutputAnnotations>>,
    /// Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://docs.github.com/rest/reference/checks#images-object) description for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub images: Option<Vec<ReposownerrepocheckrunsOutputImages>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocheckrunsOutputAnnotations {     
    /// The path of the file to add an annotation to. For example, `assets/css/main.css`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// The start line of the annotation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    /// The end line of the annotation.
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_line: Option<i64>,
    /// The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_column: Option<i64>,
    /// The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_column: Option<i64>,
    /// The level of the annotation. Can be one of `notice`, `warning`, or `failure`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotation_level: Option<String>,
    /// A short description of the feedback for these lines of code. The maximum size is 64 KB.
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    /// The title that represents the annotation. The maximum size is 255 characters.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// Details about this annotation. The maximum size is 64 KB.
    #[serde(skip_serializing_if="Option::is_none")]
    pub raw_details: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocheckrunsOutputImages {     
    /// The alternative text for the image.
    #[serde(skip_serializing_if="Option::is_none")]
    pub alt: Option<String>,
    /// The full URL of the image.
    #[serde(skip_serializing_if="Option::is_none")]
    pub image_url: Option<String>,
    /// A short image description.
    #[serde(skip_serializing_if="Option::is_none")]
    pub caption: Option<String>,
}

/// Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://docs.github.com/rest/reference/checks#output-object-1) description.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocheckrunscheckRunIdOutput {     
    /// **Required**.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    /// Can contain Markdown.
    #[serde(skip_serializing_if="Option::is_none")]
    pub summary: Option<String>,
    /// Can contain Markdown.
    #[serde(skip_serializing_if="Option::is_none")]
    pub text: Option<String>,
    /// Adds information from your analysis to specific lines of code. Annotations are visible in GitHub's pull request UI. Annotations are visible in GitHub's pull request UI. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about annotations in the UI, see \"[About status checks](https://help.github.com/articles/about-status-checks#checks)\". See the [`annotations` object](https://docs.github.com/rest/reference/checks#annotations-object-1) description for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub annotations: Option<Vec<ReposownerrepocheckrunsOutputAnnotations>>,
    /// Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://docs.github.com/rest/reference/checks#annotations-object-1) description for details.
    #[serde(skip_serializing_if="Option::is_none")]
    pub images: Option<Vec<ReposownerrepocheckrunsOutputImages>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepochecksuitespreferencesAutoTriggerChecks {     
    /// The `id` of the GitHub App.
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
    /// Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.
    #[serde(skip_serializing_if="Option::is_none")]
    pub setting: Option<bool>,
}

/// The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocontentspathAuthor {     
    /// The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<String>,
}

/// object containing information about the author.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocontentspathAuthor1 {     
    /// The name of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
}

/// The person that committed the file. Default: the authenticated user.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocontentspathCommitter {     
    /// The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<String>,
}

/// object containing information about the committer.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepocontentspathCommitter1 {     
    /// The name of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepoenvironmentsenvironmentNameReviewers {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<DeploymentReviewerType>,
    /// The id of the user or team who can review the deployment
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
}

/// Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepogitcommitsAuthor {     
    /// The name of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<chrono::DateTime<chrono::Utc>>,
}

/// Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepogitcommitsCommitter {     
    /// The name of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author (or committer) of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<chrono::DateTime<chrono::Utc>>,
}

/// An object with information about the individual creating the tag.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepogittagsTagger {     
    /// The name of the author of the tag
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The email of the author of the tag
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    /// When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub date: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepogittreesTree {     
    /// The file referenced in the tree.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
    #[serde(skip_serializing_if="Option::is_none")]
    pub mode: Option<String>,
    /// Either `blob`, `tree`, or `commit`.
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    /// The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.      **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    /// The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.      **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
    #[serde(skip_serializing_if="Option::is_none")]
    pub content: Option<String>,
}

/// Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepohooksConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub digest: Option<String>,
}

/// Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepohookshookIdConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub address: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub room: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepoissuesissueNumberlabelsLabels {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
}

/// The source branch and directory used to publish your Pages site.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepopagesSource {     
    /// The repository branch used to publish your site's source files.
    #[serde(skip_serializing_if="Option::is_none")]
    pub branch: Option<String>,
    /// The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`. Default: `/`
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReposownerrepopullspullNumberreviewsComments {     
    /// The relative path to the file that necessitates a review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    /// Text of the review comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub side: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_side: Option<String>,
}

/// Legacy Review Comment
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewComment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_review_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub diff_hunk: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub position: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_position: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub in_reply_to_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<ReviewcommentLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
    /// The side of the first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub side: Option<String>,
    /// The side of the first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_side: Option<String>,
    /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub line: Option<i64>,
    /// The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_line: Option<i64>,
    /// The first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<i64>,
    /// The original first line of the range for a multi-line comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub original_start_line: Option<i64>,
}

/// Review Dismissed Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewDismissedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissed_review: Option<ReviewdismissedissueeventDismissedReview>,
}

/// Review Request Removed Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewRequestRemovedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_requester: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_team: Option<Team>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_reviewer: Option<SimpleUser>,
}

/// Review Requested Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewRequestedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_requester: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_team: Option<Team>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub requested_reviewer: Option<SimpleUser>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewcommentLinks {     
    #[serde(rename = "self")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _self: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<Link>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<Link>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ReviewdismissedissueeventDismissedReview {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub review_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub dismissal_commit_id: Option<String>,
}

/// A self hosted runner
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Runner {     
    /// The id of the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The name of the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The Operating System of the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub os: Option<String>,
    /// The status of the runner.
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub busy: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels: Option<Vec<RunnerLabel>>,
}

/// Runner Application
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RunnerApplication {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub os: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub architecture: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub download_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub filename: Option<String>,
    /// A short lived bearer token used to download the runner, if needed.
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_download_token: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha256_checksum: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RunnerGroupsEnterprise {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RunnerGroupsOrg {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub default: Option<bool>,
    /// Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`
    #[serde(skip_serializing_if="Option::is_none")]
    pub selected_repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub runners_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub inherited: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub inherited_allows_public_repositories: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub allows_public_repositories: Option<bool>,
}

/// A label for a self hosted runner
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct RunnerLabel {     
    /// Unique identifier of the label.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// Name of the label.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// The type of label. Read-only labels are applied automatically when the runner is configured.
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimEnterpriseGroup {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<Vec<ScimgrouplistenterpriseMembers>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub meta: Option<ScimgrouplistenterpriseMeta>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimEnterpriseUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<ScimuserlistenterpriseName>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<ScimenterpriseuserEmails>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<Scimv2enterprisesenterpriseUsersGroups>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub meta: Option<ScimgrouplistenterpriseMeta>,
}

/// Scim Error
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimError {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub detail: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<i64>,
    #[serde(rename = "scimType")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub scim_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimGroupListEnterprise {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(rename = "totalResults")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_results: Option<f64>,
    #[serde(rename = "itemsPerPage")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub items_per_page: Option<f64>,
    #[serde(rename = "startIndex")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_index: Option<f64>,
    #[serde(rename = "Resources")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub resources: Option<Vec<ScimgrouplistenterpriseResources>>,
}

/// SCIM /Users provisioning endpoints
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimUser {     
    /// SCIM schema used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    /// Unique identifier of an external identity
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    /// The ID of the User.
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    /// Configured by the admin. Could be an email, login, or username
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    /// The name of the user, suitable for display to end-users
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<ScimuserName>,
    /// user emails
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<ScimuserEmails>>,
    /// The active status of the User.
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub meta: Option<ScimuserMeta>,
    /// The ID of the organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_id: Option<i64>,
    /// Set of operations to be performed
    #[serde(skip_serializing_if="Option::is_none")]
    pub operations: Option<Vec<ScimuserOperations>>,
    /// associated groups
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<ScimuserGroups>>,
}

/// SCIM User List
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimUserList {     
    /// SCIM schema used.
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(rename = "totalResults")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_results: Option<i64>,
    #[serde(rename = "itemsPerPage")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub items_per_page: Option<i64>,
    #[serde(rename = "startIndex")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_index: Option<i64>,
    #[serde(rename = "Resources")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub resources: Option<Vec<ScimUser>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimUserListEnterprise {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(rename = "totalResults")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_results: Option<f64>,
    #[serde(rename = "itemsPerPage")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub items_per_page: Option<f64>,
    #[serde(rename = "startIndex")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_index: Option<f64>,
    #[serde(rename = "Resources")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub resources: Option<Vec<ScimuserlistenterpriseResources>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimenterpriseuserEmails {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimgrouplistenterpriseMembers {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(rename = "$ref")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _ref: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub display: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimgrouplistenterpriseMeta {     
    #[serde(rename = "resourceType")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created: Option<String>,
    #[serde(rename = "lastModified")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_modified: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimgrouplistenterpriseResources {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "displayName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members: Option<Vec<ScimgrouplistenterpriseMembers>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub meta: Option<ScimgrouplistenterpriseMeta>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserEmails {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserGroups {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub display: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserMeta {     
    #[serde(rename = "resourceType")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub resource_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(rename = "lastModified")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_modified: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserName {     
    #[serde(rename = "givenName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub given_name: Option<String>,
    #[serde(rename = "familyName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub family_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub formatted: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserOperations {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub op: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<ScimuserOperationsValue>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserlistenterpriseEmails {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserlistenterpriseName {     
    #[serde(rename = "givenName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub given_name: Option<String>,
    #[serde(rename = "familyName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub family_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ScimuserlistenterpriseResources {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub schemas: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "externalId")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub external_id: Option<String>,
    #[serde(rename = "userName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub user_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<ScimuserlistenterpriseName>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub emails: Option<Vec<ScimuserlistenterpriseEmails>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub groups: Option<Vec<Scimv2enterprisesenterpriseUsersGroups>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub active: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub meta: Option<ScimgrouplistenterpriseMeta>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2enterprisesenterpriseGroupsMembers {     
    /// The SCIM user ID for a user.
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2enterprisesenterpriseGroupsscimGroupIdOperations {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub op: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// Can be any value - string, number, array or object.
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<Value>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2enterprisesenterpriseUsersEmails {     
    /// The email address.
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    /// The type of email address.
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    /// Whether this email address is the primary address.
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2enterprisesenterpriseUsersGroups {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2enterprisesenterpriseUsersName {     
    /// The first name of the user.
    #[serde(rename = "givenName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub given_name: Option<String>,
    /// The last name of the user.
    #[serde(rename = "familyName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub family_name: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2organizationsorgUsersEmails {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2organizationsorgUsersName {     
    #[serde(rename = "givenName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub given_name: Option<String>,
    #[serde(rename = "familyName")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub family_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub formatted: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2organizationsorgUsersscimUserIdEmails {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub primary: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Scimv2organizationsorgUsersscimUserIdOperations {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub op: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<Scimv2organizationsorgUsersscimUserIdOperationsValue>,
}

pub type SearchResultTextMatches = Vec<SearchresulttextmatchesInner>;

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SearchresulttextmatchesInner {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub object_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub object_type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub property: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fragment: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub matches: Option<Vec<Value>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SecretScanningAlert {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<AlertNumber>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<AlertCreatedAt>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<AlertUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<AlertHtmlUrl>,
    /// The REST API URL of the code locations for this alert.
    #[serde(skip_serializing_if="Option::is_none")]
    pub locations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<SecretScanningAlertState>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolution: Option<SecretScanningAlertResolution>,
    /// The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolved_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub resolved_by: Option<NullableSimpleUser>,
    /// The type of secret that secret scanning detected.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret_type: Option<String>,
    /// The secret that was detected.
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<String>,
}

/// **Required when the `state` is `resolved`.** The reason for resolving the alert. Can be one of `false_positive`, `wont_fix`, `revoked`, or `used_in_tests`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum SecretScanningAlertResolution { 
    #[serde(rename = "null")]
    NULL,
    #[serde(rename = "false_positive")]
    FALSE_POSITIVE,
    #[serde(rename = "wont_fix")]
    WONT_FIX,
    #[serde(rename = "revoked")]
    REVOKED,
    #[serde(rename = "used_in_tests")]
    USED_IN_TESTS,
}

impl Display for SecretScanningAlertResolution {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            SecretScanningAlertResolution::NULL => write!(f, "{}", "null"),
            SecretScanningAlertResolution::FALSE_POSITIVE => write!(f, "{}", "false_positive"),
            SecretScanningAlertResolution::WONT_FIX => write!(f, "{}", "wont_fix"),
            SecretScanningAlertResolution::REVOKED => write!(f, "{}", "revoked"),
            SecretScanningAlertResolution::USED_IN_TESTS => write!(f, "{}", "used_in_tests"),
        }
    }
}

impl std::str::FromStr for SecretScanningAlertResolution {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "null" => Ok(SecretScanningAlertResolution::NULL),
            "false_positive" => Ok(SecretScanningAlertResolution::FALSE_POSITIVE),
            "wont_fix" => Ok(SecretScanningAlertResolution::WONT_FIX),
            "revoked" => Ok(SecretScanningAlertResolution::REVOKED),
            "used_in_tests" => Ok(SecretScanningAlertResolution::USED_IN_TESTS),
            _ => Err(()),
        }
    }
}

/// Sets the state of the secret scanning alert. Can be either `open` or `resolved`. You must provide `resolution` when you set the state to `resolved`.
/// Enumeration of values.
/// Since this enum's variants do not hold data, we can easily define them them as `#[repr(C)]`
/// which helps with FFI.
#[allow(non_camel_case_types)]
#[repr(C)]
#[derive(Debug, Clone, Copy, PartialEq, PartialOrd, Serialize, Deserialize, Eq, Ord)]
pub enum SecretScanningAlertState { 
    #[serde(rename = "open")]
    OPEN,
    #[serde(rename = "resolved")]
    RESOLVED,
}

impl Display for SecretScanningAlertState {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match *self { 
            SecretScanningAlertState::OPEN => write!(f, "{}", "open"),
            SecretScanningAlertState::RESOLVED => write!(f, "{}", "resolved"),
        }
    }
}

impl std::str::FromStr for SecretScanningAlertState {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "open" => Ok(SecretScanningAlertState::OPEN),
            "resolved" => Ok(SecretScanningAlertState::RESOLVED),
            _ => Err(()),
        }
    }
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SecretScanningLocation {     
    /// The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub details: Option<SecretScanningLocationDetails>,
}

/// Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SecretScanningLocationCommit {     
    /// The file path in the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    /// Line number at which the secret starts in the file
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_line: Option<f64>,
    /// Line number at which the secret ends in the file
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_line: Option<f64>,
    /// The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
    #[serde(skip_serializing_if="Option::is_none")]
    pub start_column: Option<f64>,
    /// The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
    #[serde(skip_serializing_if="Option::is_none")]
    pub end_column: Option<f64>,
    /// SHA-1 hash ID of the associated blob
    #[serde(skip_serializing_if="Option::is_none")]
    pub blob_sha: Option<String>,
    /// The API URL to get the associated blob resource
    #[serde(skip_serializing_if="Option::is_none")]
    pub blob_url: Option<String>,
    /// SHA-1 hash ID of the associated commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_sha: Option<String>,
    /// The API URL to get the associated commit resource
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct PutActionsSetAllowedActionsRepository {     
    /// Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub github_owned_allowed: Option<bool>,
    /// Whether actions in GitHub Marketplace from verified creators are allowed. Set to `true` to allow all GitHub Marketplace actions by verified creators.
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified_allowed: Option<bool>,
    /// Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/_*`.\"
    #[serde(skip_serializing_if="Option::is_none")]
    pub patterns_allowed: Option<Vec<String>>,
}

/// The API URL to use to get or set the actions that are allowed to run, when `allowed_actions` is set to `selected`.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SelectedActionsUrl {     
}

/// Short Blob
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ShortBlob {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
}

/// Short Branch
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ShortBranch {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<ShortbranchCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protected: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection: Option<BranchProtection>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub protection_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ShortbranchCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
}

/// Simple Commit
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SimpleCommit {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub timestamp: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullablesimplecommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<NullablesimplecommitAuthor>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SimpleCommitStatus {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub required: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Simple User
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct SimpleUser {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<String>,
}

/// Stargazer
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Stargazer {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<NullableSimpleUser>,
}

/// Starred Repository
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct StarredRepository {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repo: Option<Repository>,
}

/// The status of a commit.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Status {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub target_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<NullableSimpleUser>,
}

/// Status Check Policy
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct StatusCheckPolicy {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub strict: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts: Option<Vec<String>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub checks: Option<Vec<StatuscheckpolicyChecks>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contexts_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct StatuscheckpolicyChecks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub context: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub app_id: Option<i64>,
}

/// Tag
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Tag {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit: Option<ShortbranchCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub zipball_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tarball_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
}

/// Groups of organization members that gives permissions on specified repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Team {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<TeamPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent: Option<NullableTeamSimple>,
}

/// A team discussion is a persistent record of a free-form conversation within a team.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamDiscussion {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableSimpleUser>,
    /// The main text of the discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    /// The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_version: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_edited_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The unique sequence number of a team discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    /// Whether or not this discussion should be pinned for easy retrieval.
    #[serde(skip_serializing_if="Option::is_none")]
    pub pinned: Option<bool>,
    /// Whether or not this discussion should be restricted to team members and organization administrators.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub team_url: Option<String>,
    /// The title of the discussion.
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// A reply to a discussion within a team.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamDiscussionComment {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<NullableSimpleUser>,
    /// The main text of the comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    /// The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_version: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_edited_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub discussion_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The unique sequence number of a team discussion comment.
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// Groups of organization members that gives permissions on specified repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamFull {     
    /// Unique identifier of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    /// Name of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// The level of privacy this team should have
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    /// Permission that the team will have for its repositories
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parent: Option<NullableTeamSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization: Option<OrganizationFull>,
    /// Distinguished Name (DN) that team maps to within LDAP environment
    #[serde(skip_serializing_if="Option::is_none")]
    pub ldap_dn: Option<String>,
}

/// Team Membership
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamMembership {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// The role of the user in the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub role: Option<String>,
    /// The state of the user's membership in the team.
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub triage: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub push: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub maintain: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
}

/// A team's access to a project.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamProject {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub columns_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub number: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub creator: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    /// The organization permission for this project. Only present when owner is an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub organization_permission: Option<String>,
    /// Whether the project is private or not. Only present when owner is an organization.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<TeamprojectPermissions>,
}

/// A team's access to a repository.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamRepository {     
    /// Unique identifier of the repository
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The name of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub full_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub license: Option<NullableLicenseSimple>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub permissions: Option<RepositoryPermissions>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub role_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub owner: Option<NullableSimpleUser>,
    /// Whether the repository is private or public.
    #[serde(skip_serializing_if="Option::is_none")]
    pub private: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub fork: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub archive_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blobs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub branches_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub collaborators_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub compare_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contents_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub contributors_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deployments_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub downloads_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_commits_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_refs_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub git_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_comment_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issues_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub keys_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub labels_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub languages_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub merges_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub milestones_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub notifications_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pulls_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub releases_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ssh_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub statuses_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tags_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub teams_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub trees_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub clone_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub mirror_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hooks_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub svn_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub homepage: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub language: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub forks_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub stargazers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub size: Option<i64>,
    /// The default branch of the repository.
    #[serde(skip_serializing_if="Option::is_none")]
    pub default_branch: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues_count: Option<i64>,
    /// Whether this repository acts as a template that can be used to generate new repositories.
    #[serde(skip_serializing_if="Option::is_none")]
    pub is_template: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topics: Option<Vec<String>>,
    /// Whether issues are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_issues: Option<bool>,
    /// Whether projects are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_projects: Option<bool>,
    /// Whether the wiki is enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_wiki: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_pages: Option<bool>,
    /// Whether downloads are enabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub has_downloads: Option<bool>,
    /// Whether the repository is archived.
    #[serde(skip_serializing_if="Option::is_none")]
    pub archived: Option<bool>,
    /// Returns whether or not this repository disabled.
    #[serde(skip_serializing_if="Option::is_none")]
    pub disabled: Option<bool>,
    /// The repository visibility: public, private, or internal.
    #[serde(skip_serializing_if="Option::is_none")]
    pub visibility: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pushed_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// Whether to allow rebase merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_rebase_merge: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub template_repository: Option<NullableRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub temp_clone_token: Option<String>,
    /// Whether to allow squash merges for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_squash_merge: Option<bool>,
    /// Whether to allow Auto-merge to be used on pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_auto_merge: Option<bool>,
    /// Whether to delete head branches when pull requests are merged
    #[serde(skip_serializing_if="Option::is_none")]
    pub delete_branch_on_merge: Option<bool>,
    /// Whether to allow merge commits for pull requests.
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_merge_commit: Option<bool>,
    /// Whether to allow forking this repo
    #[serde(skip_serializing_if="Option::is_none")]
    pub allow_forking: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribers_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub network_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub open_issues: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub watchers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub master_branch: Option<String>,
}

/// Groups of organization members that gives permissions on specified repositories.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamSimple {     
    /// Unique identifier of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub members_url: Option<String>,
    /// Name of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    /// Description of the team
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    /// Permission that the team will have for its repositories
    #[serde(skip_serializing_if="Option::is_none")]
    pub permission: Option<String>,
    /// The level of privacy this team should have
    #[serde(skip_serializing_if="Option::is_none")]
    pub privacy: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repositories_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub slug: Option<String>,
    /// Distinguished Name (DN) that team maps to within LDAP environment
    #[serde(skip_serializing_if="Option::is_none")]
    pub ldap_dn: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamprojectPermissions {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub read: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub write: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub admin: Option<bool>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TeamsteamIdteamsyncgroupmappingsGroups {     
    /// ID of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_id: Option<String>,
    /// Name of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_name: Option<String>,
    /// Description of the IdP group.
    #[serde(skip_serializing_if="Option::is_none")]
    pub group_description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
}

/// Thread
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Thread {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subject: Option<ThreadSubject>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub unread: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub last_read_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscription_url: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ThreadSubject {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub title: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub latest_comment_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
}

/// Thread Subscription
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ThreadSubscription {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscribed: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub ignored: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub thread_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_url: Option<String>,
}

/// Timeline Assigned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineAssignedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<SimpleUser>,
}

/// Timeline Comment Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineCommentEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    /// Unique identifier of the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// URL for the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    /// Contents of the issue comment
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reactions: Option<ReactionRollup>,
}

/// Timeline Commit Commented Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineCommitCommentedEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<Vec<CommitComment>>,
}

/// Timeline Committed Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineCommittedEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    /// SHA for the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub sha: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author: Option<GitcommitAuthor>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub committer: Option<GitcommitAuthor>,
    /// Message describing the purpose of the commit
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub tree: Option<GitcommitTree>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub parents: Option<Vec<GitcommitParents>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub verification: Option<GitcommitVerification>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
}

/// Timeline Cross Referenced Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineCrossReferencedEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub source: Option<TimelinecrossreferencedeventSource>,
}

/// Timeline Event
#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TimelineIssueEvents { 
    TimelineIssueEventsVariant0(LabeledIssueEvent),
    TimelineIssueEventsVariant1(UnlabeledIssueEvent),
    TimelineIssueEventsVariant2(MilestonedIssueEvent),
    TimelineIssueEventsVariant3(DemilestonedIssueEvent),
    TimelineIssueEventsVariant4(RenamedIssueEvent),
    TimelineIssueEventsVariant5(ReviewRequestedIssueEvent),
    TimelineIssueEventsVariant6(ReviewRequestRemovedIssueEvent),
    TimelineIssueEventsVariant7(ReviewDismissedIssueEvent),
    TimelineIssueEventsVariant8(LockedIssueEvent),
    TimelineIssueEventsVariant9(AddedToProjectIssueEvent),
    TimelineIssueEventsVariant10(MovedColumnInProjectIssueEvent),
    TimelineIssueEventsVariant11(RemovedFromProjectIssueEvent),
    TimelineIssueEventsVariant12(ConvertedNoteToIssueIssueEvent),
    TimelineIssueEventsVariant13(TimelineCommentEvent),
    TimelineIssueEventsVariant14(TimelineCrossReferencedEvent),
    TimelineIssueEventsVariant15(TimelineCommittedEvent),
    TimelineIssueEventsVariant16(TimelineReviewedEvent),
    TimelineIssueEventsVariant17(TimelineLineCommentedEvent),
    TimelineIssueEventsVariant18(TimelineCommitCommentedEvent),
    TimelineIssueEventsVariant19(TimelineAssignedIssueEvent),
    TimelineIssueEventsVariant20(TimelineUnassignedIssueEvent),
}

impl From<LabeledIssueEvent> for TimelineIssueEvents {
    fn from(value: LabeledIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant0(value)
    }
}

impl From<UnlabeledIssueEvent> for TimelineIssueEvents {
    fn from(value: UnlabeledIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant1(value)
    }
}

impl From<MilestonedIssueEvent> for TimelineIssueEvents {
    fn from(value: MilestonedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant2(value)
    }
}

impl From<DemilestonedIssueEvent> for TimelineIssueEvents {
    fn from(value: DemilestonedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant3(value)
    }
}

impl From<RenamedIssueEvent> for TimelineIssueEvents {
    fn from(value: RenamedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant4(value)
    }
}

impl From<ReviewRequestedIssueEvent> for TimelineIssueEvents {
    fn from(value: ReviewRequestedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant5(value)
    }
}

impl From<ReviewRequestRemovedIssueEvent> for TimelineIssueEvents {
    fn from(value: ReviewRequestRemovedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant6(value)
    }
}

impl From<ReviewDismissedIssueEvent> for TimelineIssueEvents {
    fn from(value: ReviewDismissedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant7(value)
    }
}

impl From<LockedIssueEvent> for TimelineIssueEvents {
    fn from(value: LockedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant8(value)
    }
}

impl From<AddedToProjectIssueEvent> for TimelineIssueEvents {
    fn from(value: AddedToProjectIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant9(value)
    }
}

impl From<MovedColumnInProjectIssueEvent> for TimelineIssueEvents {
    fn from(value: MovedColumnInProjectIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant10(value)
    }
}

impl From<RemovedFromProjectIssueEvent> for TimelineIssueEvents {
    fn from(value: RemovedFromProjectIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant11(value)
    }
}

impl From<ConvertedNoteToIssueIssueEvent> for TimelineIssueEvents {
    fn from(value: ConvertedNoteToIssueIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant12(value)
    }
}

impl From<TimelineCommentEvent> for TimelineIssueEvents {
    fn from(value: TimelineCommentEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant13(value)
    }
}

impl From<TimelineCrossReferencedEvent> for TimelineIssueEvents {
    fn from(value: TimelineCrossReferencedEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant14(value)
    }
}

impl From<TimelineCommittedEvent> for TimelineIssueEvents {
    fn from(value: TimelineCommittedEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant15(value)
    }
}

impl From<TimelineReviewedEvent> for TimelineIssueEvents {
    fn from(value: TimelineReviewedEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant16(value)
    }
}

impl From<TimelineLineCommentedEvent> for TimelineIssueEvents {
    fn from(value: TimelineLineCommentedEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant17(value)
    }
}

impl From<TimelineCommitCommentedEvent> for TimelineIssueEvents {
    fn from(value: TimelineCommitCommentedEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant18(value)
    }
}

impl From<TimelineAssignedIssueEvent> for TimelineIssueEvents {
    fn from(value: TimelineAssignedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant19(value)
    }
}

impl From<TimelineUnassignedIssueEvent> for TimelineIssueEvents {
    fn from(value: TimelineUnassignedIssueEvent) -> Self {
        TimelineIssueEvents::TimelineIssueEventsVariant20(value)
    }
}

/// Timeline Line Commented Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineLineCommentedEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub comments: Option<Vec<PullRequestReviewComment>>,
}

/// Timeline Reviewed Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineReviewedEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    /// Unique identifier of the review
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub user: Option<SimpleUser>,
    /// The text of the review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub body: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub _links: Option<TimelinereviewedeventLinks>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub submitted_at: Option<chrono::DateTime<chrono::Utc>>,
    /// A commit SHA for the review.
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_html: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub body_text: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub author_association: Option<AuthorAssociation>,
}

/// Timeline Unassigned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelineUnassignedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<SimpleUser>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelinecrossreferencedeventSource {     
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub issue: Option<Issue>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelinereviewedeventLinks {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub html: Option<TimelinereviewedeventLinksHtml>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request: Option<TimelinereviewedeventLinksHtml>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TimelinereviewedeventLinksHtml {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub href: Option<String>,
}

/// A topic aggregates entities that are related to a subject.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Topic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub names: Option<Vec<String>>,
}

/// Topic Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TopicSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub display_name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub short_description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub description: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_by: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub released: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub featured: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub curated: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub logo_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub related: Option<Vec<TopicsearchresultitemRelated>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub aliases: Option<Vec<TopicsearchresultitemRelated>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TopicsearchresultitemRelated {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub topic_relation: Option<TopicsearchresultitemTopicRelation>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct TopicsearchresultitemTopicRelation {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub topic_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub relation_type: Option<String>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Traffic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub timestamp: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uniques: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub count: Option<i64>,
}

/// Unassigned Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct UnassignedIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assignee: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub assigner: Option<SimpleUser>,
}

/// Unlabeled Issue Event
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct UnlabeledIssueEvent {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub actor: Option<SimpleUser>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub performed_via_github_app: Option<NullableIntegration>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub label: Option<LabeledissueeventLabel>,
}

/// User Marketplace Purchase
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct UserMarketplacePurchase {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub billing_cycle: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub next_billing_date: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub unit_count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub on_free_trial: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub free_trial_ends_on: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub account: Option<MarketplaceAccount>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub plan: Option<MarketplaceListingPlan>,
}

/// User Search Result Item
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct UserSearchResultItem {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub login: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gravatar_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub subscriptions_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub organizations_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repos_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub received_events_url: Option<String>,
    #[serde(rename = "type")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub _type: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub score: Option<f64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub gists_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub starred_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub events_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_repos: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub public_gists: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub followers: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub following: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub bio: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub email: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub location: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub site_admin: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub hireable: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub text_matches: Option<SearchResultTextMatches>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub blog: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub company: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub suspended_at: Option<chrono::DateTime<chrono::Utc>>,
}

/// Pull request number for this codespace
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct UsercodespacesPullRequest {     
    /// Pull request number
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_request_number: Option<i64>,
    /// Repository id for this codespace
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository_id: Option<i64>,
}

/// Validation Error
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ValidationError {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<ValidationerrorErrors>>,
}

/// Validation Error Simple
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ValidationErrorSimple {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub documentation_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub errors: Option<Vec<String>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ValidationerrorErrors {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub resource: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub field: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub message: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub code: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub index: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub value: Option<ValidationerrorErrorsValue>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Verification {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub verified: Option<bool>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub reason: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub payload: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub signature: Option<String>,
}

/// View Traffic
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct ViewTraffic {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub count: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub uniques: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub views: Option<Vec<Traffic>>,
}

/// The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).
pub type WaitTimer = i32;

/// Configuration object of the webhook
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WebhookConfig {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<WebhookConfigUrl>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub content_type: Option<WebhookConfigContentType>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub secret: Option<WebhookConfigSecret>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub insecure_ssl: Option<WebhookConfigInsecureSsl>,
}

/// The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WebhookConfigContentType {     
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum WebhookConfigInsecureSsl { 
    WebhookConfigInsecureSslVariant0(String),
    WebhookConfigInsecureSslVariant1(f64),
}

impl From<String> for WebhookConfigInsecureSsl {
    fn from(value: String) -> Self {
        WebhookConfigInsecureSsl::WebhookConfigInsecureSslVariant0(value)
    }
}

impl From<f64> for WebhookConfigInsecureSsl {
    fn from(value: f64) -> Self {
        WebhookConfigInsecureSsl::WebhookConfigInsecureSslVariant1(value)
    }
}

impl Display for WebhookConfigInsecureSsl {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match self { 
            WebhookConfigInsecureSsl::WebhookConfigInsecureSslVariant0(value) => write!(f, "{}", value),
            WebhookConfigInsecureSsl::WebhookConfigInsecureSslVariant1(value) => write!(f, "{}", value),
        }
    }
}

/// If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WebhookConfigSecret {     
}

/// The URL to which the payloads will be delivered.
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WebhookConfigUrl {     
}

/// A GitHub Actions workflow
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct Workflow {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub path: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub state: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub badge_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub deleted_at: Option<chrono::DateTime<chrono::Utc>>,
}

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum WorkflowId { 
    WorkflowIdVariant0(i32),
    WorkflowIdVariant1(String),
}

impl From<i32> for WorkflowId {
    fn from(value: i32) -> Self {
        WorkflowId::WorkflowIdVariant0(value)
    }
}

impl From<String> for WorkflowId {
    fn from(value: String) -> Self {
        WorkflowId::WorkflowIdVariant1(value)
    }
}

impl Display for WorkflowId {
    fn fmt(&self, f: &mut Formatter) -> fmt::Result {
        match self { 
            WorkflowId::WorkflowIdVariant0(value) => write!(f, "{}", value),
            WorkflowId::WorkflowIdVariant1(value) => write!(f, "{}", value),
        }
    }
}

/// An invocation of a workflow
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowRun {     
    /// The ID of the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub id: Option<i64>,
    /// The name of the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub name: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub node_id: Option<String>,
    /// The ID of the associated check suite.
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_suite_id: Option<i64>,
    /// The node ID of the associated check suite.
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_suite_node_id: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_branch: Option<String>,
    /// The SHA of the head commit that points to the version of the worflow being run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_sha: Option<String>,
    /// The auto incrementing run number for the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_number: Option<i64>,
    /// Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_attempt: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub event: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub status: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub conclusion: Option<String>,
    /// The ID of the parent workflow.
    #[serde(skip_serializing_if="Option::is_none")]
    pub workflow_id: Option<i64>,
    /// The URL to the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub html_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub pull_requests: Option<Vec<PullRequestMinimal>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub created_at: Option<chrono::DateTime<chrono::Utc>>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub updated_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The start time of the latest run. Resets on re-run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_started_at: Option<chrono::DateTime<chrono::Utc>>,
    /// The URL to the jobs for the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub jobs_url: Option<String>,
    /// The URL to download the logs for the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub logs_url: Option<String>,
    /// The URL to the associated check suite.
    #[serde(skip_serializing_if="Option::is_none")]
    pub check_suite_url: Option<String>,
    /// The URL to the artifacts for the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub artifacts_url: Option<String>,
    /// The URL to cancel the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub cancel_url: Option<String>,
    /// The URL to rerun the workflow run.
    #[serde(skip_serializing_if="Option::is_none")]
    pub rerun_url: Option<String>,
    /// The URL to the previous attempted run of this workflow, if one exists.
    #[serde(skip_serializing_if="Option::is_none")]
    pub previous_attempt_url: Option<String>,
    /// The URL to the workflow.
    #[serde(skip_serializing_if="Option::is_none")]
    pub workflow_url: Option<String>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_commit: Option<NullableSimpleCommit>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_repository: Option<MinimalRepository>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub head_repository_id: Option<i64>,
}

/// Workflow Run Usage
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowRunUsage {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub billable: Option<WorkflowrunusageBillable>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub run_duration_ms: Option<i64>,
}

/// Workflow Usage
#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowUsage {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub billable: Option<WorkflowusageBillable>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowrunusageBillable {     
    #[serde(rename = "UBUNTU")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub ubuntu: Option<WorkflowrunusageBillableUbuntu>,
    #[serde(rename = "MACOS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub macos: Option<WorkflowrunusageBillableUbuntu>,
    #[serde(rename = "WINDOWS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub windows: Option<WorkflowrunusageBillableUbuntu>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowrunusageBillableUbuntu {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_ms: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub jobs: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub job_runs: Option<Vec<WorkflowrunusageBillableUbuntuJobRuns>>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowrunusageBillableUbuntuJobRuns {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub job_id: Option<i64>,
    #[serde(skip_serializing_if="Option::is_none")]
    pub duration_ms: Option<i64>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowusageBillable {     
    #[serde(rename = "UBUNTU")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub ubuntu: Option<WorkflowusageBillableUbuntu>,
    #[serde(rename = "MACOS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub macos: Option<WorkflowusageBillableUbuntu>,
    #[serde(rename = "WINDOWS")]
    #[serde(skip_serializing_if="Option::is_none")]
    pub windows: Option<WorkflowusageBillableUbuntu>,
}

#[derive(Debug, Default, Clone, PartialEq, Serialize, Deserialize)]
pub struct WorkflowusageBillableUbuntu {     
    #[serde(skip_serializing_if="Option::is_none")]
    pub total_ms: Option<i64>,
}
