//! Method, error and parameter types for the Users endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Users<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Users {
    Users { auth }
}

/// Errors for the [Add an email address for the authenticated user](Users::add_email_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersAddEmailForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Block a user](Users::block_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersBlockError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a user is blocked by the authenticated user](Users::check_blocked_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersCheckBlockedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("If the user is not blocked:")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a user follows another user](Users::check_following_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersCheckFollowingForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("if the user does not follow the target user")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a person is followed by the authenticated user](Users::check_person_is_followed_by_authenticated_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersCheckPersonIsFollowedByAuthenticatedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("if the person is not followed by the authenticated user")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a GPG key for the authenticated user](Users::create_gpg_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersCreateGpgKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a public SSH key for the authenticated user](Users::create_public_ssh_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersCreatePublicSshKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an email address for the authenticated user](Users::delete_email_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersDeleteEmailForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a GPG key for the authenticated user](Users::delete_gpg_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersDeleteGpgKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a public SSH key for the authenticated user](Users::delete_public_ssh_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersDeletePublicSshKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Follow a user](Users::follow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersFollowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the authenticated user](Users::get_authenticated_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersGetAuthenticatedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a user](Users::get_by_username_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersGetByUsernameError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get contextual information for a user](Users::get_context_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersGetContextForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a GPG key for the authenticated user](Users::get_gpg_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersGetGpgKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a public SSH key for the authenticated user](Users::get_public_ssh_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersGetPublicSshKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List users](Users::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List users blocked by the authenticated user](Users::list_blocked_by_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListBlockedByAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List email addresses for the authenticated user](Users::list_emails_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListEmailsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List the people the authenticated user follows](Users::list_followed_by_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListFollowedByAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List followers of the authenticated user](Users::list_followers_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListFollowersForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List followers of a user](Users::list_followers_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListFollowersForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List the people a user follows](Users::list_following_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListFollowingForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List GPG keys for the authenticated user](Users::list_gpg_keys_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListGpgKeysForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List GPG keys for a user](Users::list_gpg_keys_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListGpgKeysForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public email addresses for the authenticated user](Users::list_public_emails_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListPublicEmailsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public keys for a user](Users::list_public_keys_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListPublicKeysForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public SSH keys for the authenticated user](Users::list_public_ssh_keys_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersListPublicSshKeysForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set primary email visibility for the authenticated user](Users::set_primary_email_visibility_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersSetPrimaryEmailVisibilityForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unblock a user](Users::unblock_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersUnblockError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unfollow a user](Users::unfollow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersUnfollowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update the authenticated user](Users::update_authenticated_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum UsersUpdateAuthenticatedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get contextual information for a user](Users::get_context_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersGetContextForUserParams<'req> {
    /// Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
    subject_type: Option<&'req str>, 
    /// Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
    subject_id: Option<&'req str>
}

impl<'req> UsersGetContextForUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
    pub fn subject_type(self, subject_type: &'req str) -> Self {
        Self { 
            subject_type: Some(subject_type),
            subject_id: self.subject_id, 
        }
    }

    /// Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
    pub fn subject_id(self, subject_id: &'req str) -> Self {
        Self { 
            subject_type: self.subject_type, 
            subject_id: Some(subject_id),
        }
    }
}

/// Query parameters for the [List users](Users::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListParams {
    /// A user ID. Only return users with an ID greater than this ID.
    since: Option<i32>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl UsersListParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// A user ID. Only return users with an ID greater than this ID.
    pub fn since(self, since: i32) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
        }
    }
}

/// Query parameters for the [List email addresses for the authenticated user](Users::list_emails_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListEmailsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListEmailsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListEmailsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List the people the authenticated user follows](Users::list_followed_by_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListFollowedByAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListFollowedByAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListFollowedByAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List followers of the authenticated user](Users::list_followers_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListFollowersForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListFollowersForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListFollowersForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List followers of a user](Users::list_followers_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListFollowersForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListFollowersForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListFollowersForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List the people a user follows](Users::list_following_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListFollowingForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListFollowingForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListFollowingForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List GPG keys for the authenticated user](Users::list_gpg_keys_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListGpgKeysForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListGpgKeysForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListGpgKeysForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List GPG keys for a user](Users::list_gpg_keys_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListGpgKeysForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListGpgKeysForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListGpgKeysForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public email addresses for the authenticated user](Users::list_public_emails_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListPublicEmailsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListPublicEmailsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListPublicEmailsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public keys for a user](Users::list_public_keys_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListPublicKeysForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListPublicKeysForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListPublicKeysForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public SSH keys for the authenticated user](Users::list_public_ssh_keys_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct UsersListPublicSshKeysForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl UsersListPublicSshKeysForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for UsersListPublicSshKeysForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Users<'api> {
    /// ---
    ///
    /// # Add an email address for the authenticated user
    ///
    /// This endpoint is accessible with the `user` scope.
    /// 
    /// [GitHub API docs for add_email_for_authenticated_user](https://docs.github.com/rest/reference/users#add-an-email-address-for-the-authenticated-user)
    ///
    /// ---
    pub async fn add_email_for_authenticated_user_async(&self, body: PostUsersAddEmailForAuthenticatedUser) -> Result<Vec<Email>, UsersAddEmailForAuthenticatedUserError> {

        let request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersAddEmailForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersAddEmailForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersAddEmailForAuthenticatedUserError::Status304),
                404 => Err(UsersAddEmailForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersAddEmailForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersAddEmailForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersAddEmailForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add an email address for the authenticated user
    ///
    /// This endpoint is accessible with the `user` scope.
    /// 
    /// [GitHub API docs for add_email_for_authenticated_user](https://docs.github.com/rest/reference/users#add-an-email-address-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_email_for_authenticated_user(&self, body: PostUsersAddEmailForAuthenticatedUser) -> Result<Vec<Email>, UsersAddEmailForAuthenticatedUserError> {

        let request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersAddEmailForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersAddEmailForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersAddEmailForAuthenticatedUserError::Status304),
                404 => Err(UsersAddEmailForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersAddEmailForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersAddEmailForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersAddEmailForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Block a user
    /// 
    /// [GitHub API docs for block](https://docs.github.com/rest/reference/users#block-a-user)
    ///
    /// ---
    pub async fn block_async(&self, username: &str) -> Result<(), UsersBlockError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersBlockError::Status304),
                404 => Err(UsersBlockError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersBlockError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersBlockError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersBlockError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersBlockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Block a user
    /// 
    /// [GitHub API docs for block](https://docs.github.com/rest/reference/users#block-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn block(&self, username: &str) -> Result<(), UsersBlockError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersBlockError::Status304),
                404 => Err(UsersBlockError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersBlockError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersBlockError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersBlockError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(UsersBlockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is blocked by the authenticated user
    /// 
    /// [GitHub API docs for check_blocked](https://docs.github.com/rest/reference/users#check-if-a-user-is-blocked-by-the-authenticated-user)
    ///
    /// ---
    pub async fn check_blocked_async(&self, username: &str) -> Result<(), UsersCheckBlockedError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckBlockedError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersCheckBlockedError::Status304),
                403 => Err(UsersCheckBlockedError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersCheckBlockedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersCheckBlockedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is blocked by the authenticated user
    /// 
    /// [GitHub API docs for check_blocked](https://docs.github.com/rest/reference/users#check-if-a-user-is-blocked-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_blocked(&self, username: &str) -> Result<(), UsersCheckBlockedError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckBlockedError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersCheckBlockedError::Status304),
                403 => Err(UsersCheckBlockedError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersCheckBlockedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersCheckBlockedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user follows another user
    /// 
    /// [GitHub API docs for check_following_for_user](https://docs.github.com/rest/reference/users#check-if-a-user-follows-another-user)
    ///
    /// ---
    pub async fn check_following_for_user_async(&self, username: &str, target_user: &str) -> Result<(), UsersCheckFollowingForUserError> {

        let request_uri = format!("{}/users/{}/following/{}", super::GITHUB_BASE_API_URL, username, target_user);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckFollowingForUserError::Status404),
                code => Err(UsersCheckFollowingForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user follows another user
    /// 
    /// [GitHub API docs for check_following_for_user](https://docs.github.com/rest/reference/users#check-if-a-user-follows-another-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_following_for_user(&self, username: &str, target_user: &str) -> Result<(), UsersCheckFollowingForUserError> {

        let request_uri = format!("{}/users/{}/following/{}", super::GITHUB_BASE_API_URL, username, target_user);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckFollowingForUserError::Status404),
                code => Err(UsersCheckFollowingForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a person is followed by the authenticated user
    /// 
    /// [GitHub API docs for check_person_is_followed_by_authenticated](https://docs.github.com/rest/reference/users#check-if-a-person-is-followed-by-the-authenticated-user)
    ///
    /// ---
    pub async fn check_person_is_followed_by_authenticated_async(&self, username: &str) -> Result<(), UsersCheckPersonIsFollowedByAuthenticatedError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status304),
                403 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a person is followed by the authenticated user
    /// 
    /// [GitHub API docs for check_person_is_followed_by_authenticated](https://docs.github.com/rest/reference/users#check-if-a-person-is-followed-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_person_is_followed_by_authenticated(&self, username: &str) -> Result<(), UsersCheckPersonIsFollowedByAuthenticatedError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status304),
                403 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersCheckPersonIsFollowedByAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GPG key for the authenticated user
    ///
    /// Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for create_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#create-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn create_gpg_key_for_authenticated_user_async(&self, body: PostUsersCreateGpgKeyForAuthenticatedUser) -> Result<GpgKey, UsersCreateGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersCreateGpgKeyForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersCreateGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GPG key for the authenticated user
    ///
    /// Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for create_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#create-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_gpg_key_for_authenticated_user(&self, body: PostUsersCreateGpgKeyForAuthenticatedUser) -> Result<GpgKey, UsersCreateGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersCreateGpgKeyForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersCreateGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersCreateGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a public SSH key for the authenticated user
    ///
    /// Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for create_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#create-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn create_public_ssh_key_for_authenticated_user_async(&self, body: PostUsersCreatePublicSshKeyForAuthenticatedUser) -> Result<Key, UsersCreatePublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersCreatePublicSshKeyForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a public SSH key for the authenticated user
    ///
    /// Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for create_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#create-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_public_ssh_key_for_authenticated_user(&self, body: PostUsersCreatePublicSshKeyForAuthenticatedUser) -> Result<Key, UsersCreatePublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostUsersCreatePublicSshKeyForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersCreatePublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an email address for the authenticated user
    ///
    /// This endpoint is accessible with the `user` scope.
    /// 
    /// [GitHub API docs for delete_email_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-an-email-address-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_email_for_authenticated_user_async(&self, body: DeleteUsersDeleteEmailForAuthenticatedUser) -> Result<(), UsersDeleteEmailForAuthenticatedUserError> {

        let request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteUsersDeleteEmailForAuthenticatedUser::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersDeleteEmailForAuthenticatedUserError::Status304),
                404 => Err(UsersDeleteEmailForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersDeleteEmailForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersDeleteEmailForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersDeleteEmailForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersDeleteEmailForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an email address for the authenticated user
    ///
    /// This endpoint is accessible with the `user` scope.
    /// 
    /// [GitHub API docs for delete_email_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-an-email-address-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_email_for_authenticated_user(&self, body: DeleteUsersDeleteEmailForAuthenticatedUser) -> Result<(), UsersDeleteEmailForAuthenticatedUserError> {

        let request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteUsersDeleteEmailForAuthenticatedUser::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersDeleteEmailForAuthenticatedUserError::Status304),
                404 => Err(UsersDeleteEmailForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersDeleteEmailForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersDeleteEmailForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersDeleteEmailForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(UsersDeleteEmailForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a GPG key for the authenticated user
    ///
    /// Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_gpg_key_for_authenticated_user_async(&self, gpg_key_id: i32) -> Result<(), UsersDeleteGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys/{}", super::GITHUB_BASE_API_URL, gpg_key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a GPG key for the authenticated user
    ///
    /// Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_gpg_key_for_authenticated_user(&self, gpg_key_id: i32) -> Result<(), UsersDeleteGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys/{}", super::GITHUB_BASE_API_URL, gpg_key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersDeleteGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a public SSH key for the authenticated user
    ///
    /// Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_public_ssh_key_for_authenticated_user_async(&self, key_id: i32) -> Result<(), UsersDeletePublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys/{}", super::GITHUB_BASE_API_URL, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a public SSH key for the authenticated user
    ///
    /// Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#delete-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_public_ssh_key_for_authenticated_user(&self, key_id: i32) -> Result<(), UsersDeletePublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys/{}", super::GITHUB_BASE_API_URL, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status304),
                404 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersDeletePublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Follow a user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
    /// 
    /// [GitHub API docs for follow](https://docs.github.com/rest/reference/users#follow-a-user)
    ///
    /// ---
    pub async fn follow_async(&self, username: &str) -> Result<(), UsersFollowError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersFollowError::Status304),
                404 => Err(UsersFollowError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersFollowError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersFollowError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersFollowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Follow a user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
    /// 
    /// [GitHub API docs for follow](https://docs.github.com/rest/reference/users#follow-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn follow(&self, username: &str) -> Result<(), UsersFollowError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersFollowError::Status304),
                404 => Err(UsersFollowError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersFollowError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersFollowError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersFollowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the authenticated user
    ///
    /// If the authenticated user is authenticated through basic authentication or OAuth with the `user` scope, then the response lists public and private profile information.
    /// 
    /// If the authenticated user is authenticated through OAuth without the `user` scope, then the response lists only public profile information.
    /// 
    /// [GitHub API docs for get_authenticated](https://docs.github.com/rest/reference/users#get-the-authenticated-user)
    ///
    /// ---
    pub async fn get_authenticated_async(&self) -> Result<GetUsersGetByUsernameResponse200, UsersGetAuthenticatedError> {

        let request_uri = format!("{}/user", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersGetAuthenticatedError::Status304),
                403 => Err(UsersGetAuthenticatedError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersGetAuthenticatedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersGetAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the authenticated user
    ///
    /// If the authenticated user is authenticated through basic authentication or OAuth with the `user` scope, then the response lists public and private profile information.
    /// 
    /// If the authenticated user is authenticated through OAuth without the `user` scope, then the response lists only public profile information.
    /// 
    /// [GitHub API docs for get_authenticated](https://docs.github.com/rest/reference/users#get-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_authenticated(&self) -> Result<GetUsersGetByUsernameResponse200, UsersGetAuthenticatedError> {

        let request_uri = format!("{}/user", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersGetAuthenticatedError::Status304),
                403 => Err(UsersGetAuthenticatedError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersGetAuthenticatedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersGetAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user
    ///
    /// Provides publicly available information about someone with a GitHub account.
    /// 
    /// GitHub Apps with the `Plan` user permission can use this endpoint to retrieve information about a user's GitHub plan. The GitHub App must be authenticated as a user. See "[Identifying and authorizing users for GitHub Apps](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)" for details about authentication. For an example response, see 'Response with GitHub plan information' below"
    /// 
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/overview/resources-in-the-rest-api#authentication).
    /// 
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/rest/reference/users#emails)".
    /// 
    /// [GitHub API docs for get_by_username](https://docs.github.com/rest/reference/users#get-a-user)
    ///
    /// ---
    pub async fn get_by_username_async(&self, username: &str) -> Result<GetUsersGetByUsernameResponse200, UsersGetByUsernameError> {

        let request_uri = format!("{}/users/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetByUsernameError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersGetByUsernameError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user
    ///
    /// Provides publicly available information about someone with a GitHub account.
    /// 
    /// GitHub Apps with the `Plan` user permission can use this endpoint to retrieve information about a user's GitHub plan. The GitHub App must be authenticated as a user. See "[Identifying and authorizing users for GitHub Apps](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)" for details about authentication. For an example response, see 'Response with GitHub plan information' below"
    /// 
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/overview/resources-in-the-rest-api#authentication).
    /// 
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/rest/reference/users#emails)".
    /// 
    /// [GitHub API docs for get_by_username](https://docs.github.com/rest/reference/users#get-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_by_username(&self, username: &str) -> Result<GetUsersGetByUsernameResponse200, UsersGetByUsernameError> {

        let request_uri = format!("{}/users/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetByUsernameError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(UsersGetByUsernameError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get contextual information for a user
    ///
    /// Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
    /// 
    /// The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
    /// 
    /// ```shell,nocompile
    ///  curl -u username:token
    ///   https://api.github.com/users/octocat/hovercard?subject_type=repository&subject_id=1300192
    /// ```
    /// 
    /// [GitHub API docs for get_context_for_user](https://docs.github.com/rest/reference/users#get-contextual-information-for-a-user)
    ///
    /// ---
    pub async fn get_context_for_user_async(&self, username: &str, query_params: Option<impl Into<UsersGetContextForUserParams<'api>>>) -> Result<Hovercard, UsersGetContextForUserError> {

        let mut request_uri = format!("{}/users/{}/hovercard", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetContextForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersGetContextForUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersGetContextForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get contextual information for a user
    ///
    /// Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
    /// 
    /// The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
    /// 
    /// ```shell,nocompile
    ///  curl -u username:token
    ///   https://api.github.com/users/octocat/hovercard?subject_type=repository&subject_id=1300192
    /// ```
    /// 
    /// [GitHub API docs for get_context_for_user](https://docs.github.com/rest/reference/users#get-contextual-information-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_context_for_user(&self, username: &str, query_params: Option<impl Into<UsersGetContextForUserParams<'api>>>) -> Result<Hovercard, UsersGetContextForUserError> {

        let mut request_uri = format!("{}/users/{}/hovercard", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersGetContextForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetContextForUserError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersGetContextForUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(UsersGetContextForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a GPG key for the authenticated user
    ///
    /// View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#get-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_gpg_key_for_authenticated_user_async(&self, gpg_key_id: i32) -> Result<GpgKey, UsersGetGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys/{}", super::GITHUB_BASE_API_URL, gpg_key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersGetGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a GPG key for the authenticated user
    ///
    /// View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_gpg_key_for_authenticated_user](https://docs.github.com/rest/reference/users#get-a-gpg-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_gpg_key_for_authenticated_user(&self, gpg_key_id: i32) -> Result<GpgKey, UsersGetGpgKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/gpg_keys/{}", super::GITHUB_BASE_API_URL, gpg_key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersGetGpgKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersGetGpgKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a public SSH key for the authenticated user
    ///
    /// View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#get-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_public_ssh_key_for_authenticated_user_async(&self, key_id: i32) -> Result<Key, UsersGetPublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys/{}", super::GITHUB_BASE_API_URL, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a public SSH key for the authenticated user
    ///
    /// View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for get_public_ssh_key_for_authenticated_user](https://docs.github.com/rest/reference/users#get-a-public-ssh-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_public_ssh_key_for_authenticated_user(&self, key_id: i32) -> Result<Key, UsersGetPublicSshKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/keys/{}", super::GITHUB_BASE_API_URL, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status304),
                403 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersGetPublicSshKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users
    ///
    /// Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
    /// 
    /// Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of users.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/users#list-users)
    ///
    /// ---
    pub async fn list_async(&self, query_params: Option<impl Into<UsersListParams>>) -> Result<Vec<SimpleUser>, UsersListError> {

        let mut request_uri = format!("{}/users", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListError::Status304),
                code => Err(UsersListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users
    ///
    /// Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
    /// 
    /// Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of users.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/users#list-users)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list(&self, query_params: Option<impl Into<UsersListParams>>) -> Result<Vec<SimpleUser>, UsersListError> {

        let mut request_uri = format!("{}/users", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListError::Status304),
                code => Err(UsersListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users blocked by the authenticated user
    ///
    /// List the users you've blocked on your personal account.
    /// 
    /// [GitHub API docs for list_blocked_by_authenticated_user](https://docs.github.com/rest/reference/users#list-users-blocked-by-the-authenticated-user)
    ///
    /// ---
    pub async fn list_blocked_by_authenticated_user_async(&self) -> Result<Vec<SimpleUser>, UsersListBlockedByAuthenticatedUserError> {

        let request_uri = format!("{}/user/blocks", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListBlockedByAuthenticatedUserError::Status304),
                404 => Err(UsersListBlockedByAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersListBlockedByAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListBlockedByAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(UsersListBlockedByAuthenticatedUserError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListBlockedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users blocked by the authenticated user
    ///
    /// List the users you've blocked on your personal account.
    /// 
    /// [GitHub API docs for list_blocked_by_authenticated_user](https://docs.github.com/rest/reference/users#list-users-blocked-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_blocked_by_authenticated_user(&self) -> Result<Vec<SimpleUser>, UsersListBlockedByAuthenticatedUserError> {

        let request_uri = format!("{}/user/blocks", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListBlockedByAuthenticatedUserError::Status304),
                404 => Err(UsersListBlockedByAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersListBlockedByAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListBlockedByAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                415 => Err(UsersListBlockedByAuthenticatedUserError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListBlockedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List email addresses for the authenticated user
    ///
    /// Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope.
    /// 
    /// [GitHub API docs for list_emails_for_authenticated_user](https://docs.github.com/rest/reference/users#list-email-addresses-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_emails_for_authenticated_user_async(&self, query_params: Option<impl Into<UsersListEmailsForAuthenticatedUserParams>>) -> Result<Vec<Email>, UsersListEmailsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListEmailsForAuthenticatedUserError::Status304),
                404 => Err(UsersListEmailsForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersListEmailsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListEmailsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListEmailsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List email addresses for the authenticated user
    ///
    /// Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope.
    /// 
    /// [GitHub API docs for list_emails_for_authenticated_user](https://docs.github.com/rest/reference/users#list-email-addresses-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_emails_for_authenticated_user(&self, query_params: Option<impl Into<UsersListEmailsForAuthenticatedUserParams>>) -> Result<Vec<Email>, UsersListEmailsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/emails", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListEmailsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListEmailsForAuthenticatedUserError::Status304),
                404 => Err(UsersListEmailsForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersListEmailsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListEmailsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListEmailsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List the people the authenticated user follows
    ///
    /// Lists the people who the authenticated user follows.
    /// 
    /// [GitHub API docs for list_followed_by_authenticated_user](https://docs.github.com/rest/reference/users#list-the-people-the-authenticated-user-follows)
    ///
    /// ---
    pub async fn list_followed_by_authenticated_user_async(&self, query_params: Option<impl Into<UsersListFollowedByAuthenticatedUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowedByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/following", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListFollowedByAuthenticatedUserError::Status304),
                403 => Err(UsersListFollowedByAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListFollowedByAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListFollowedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List the people the authenticated user follows
    ///
    /// Lists the people who the authenticated user follows.
    /// 
    /// [GitHub API docs for list_followed_by_authenticated_user](https://docs.github.com/rest/reference/users#list-the-people-the-authenticated-user-follows)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_followed_by_authenticated_user(&self, query_params: Option<impl Into<UsersListFollowedByAuthenticatedUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowedByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/following", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListFollowedByAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListFollowedByAuthenticatedUserError::Status304),
                403 => Err(UsersListFollowedByAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListFollowedByAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListFollowedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List followers of the authenticated user
    ///
    /// Lists the people following the authenticated user.
    /// 
    /// [GitHub API docs for list_followers_for_authenticated_user](https://docs.github.com/rest/reference/users#list-followers-of-the-authenticated-user)
    ///
    /// ---
    pub async fn list_followers_for_authenticated_user_async(&self, query_params: Option<impl Into<UsersListFollowersForAuthenticatedUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowersForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/followers", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListFollowersForAuthenticatedUserError::Status304),
                403 => Err(UsersListFollowersForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListFollowersForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListFollowersForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List followers of the authenticated user
    ///
    /// Lists the people following the authenticated user.
    /// 
    /// [GitHub API docs for list_followers_for_authenticated_user](https://docs.github.com/rest/reference/users#list-followers-of-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_followers_for_authenticated_user(&self, query_params: Option<impl Into<UsersListFollowersForAuthenticatedUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowersForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/followers", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListFollowersForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListFollowersForAuthenticatedUserError::Status304),
                403 => Err(UsersListFollowersForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListFollowersForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListFollowersForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List followers of a user
    ///
    /// Lists the people following the specified user.
    /// 
    /// [GitHub API docs for list_followers_for_user](https://docs.github.com/rest/reference/users#list-followers-of-a-user)
    ///
    /// ---
    pub async fn list_followers_for_user_async(&self, username: &str, query_params: Option<impl Into<UsersListFollowersForUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowersForUserError> {

        let mut request_uri = format!("{}/users/{}/followers", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListFollowersForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List followers of a user
    ///
    /// Lists the people following the specified user.
    /// 
    /// [GitHub API docs for list_followers_for_user](https://docs.github.com/rest/reference/users#list-followers-of-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_followers_for_user(&self, username: &str, query_params: Option<impl Into<UsersListFollowersForUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowersForUserError> {

        let mut request_uri = format!("{}/users/{}/followers", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListFollowersForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListFollowersForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List the people a user follows
    ///
    /// Lists the people who the specified user follows.
    /// 
    /// [GitHub API docs for list_following_for_user](https://docs.github.com/rest/reference/users#list-the-people-a-user-follows)
    ///
    /// ---
    pub async fn list_following_for_user_async(&self, username: &str, query_params: Option<impl Into<UsersListFollowingForUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowingForUserError> {

        let mut request_uri = format!("{}/users/{}/following", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListFollowingForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List the people a user follows
    ///
    /// Lists the people who the specified user follows.
    /// 
    /// [GitHub API docs for list_following_for_user](https://docs.github.com/rest/reference/users#list-the-people-a-user-follows)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_following_for_user(&self, username: &str, query_params: Option<impl Into<UsersListFollowingForUserParams>>) -> Result<Vec<SimpleUser>, UsersListFollowingForUserError> {

        let mut request_uri = format!("{}/users/{}/following", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListFollowingForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListFollowingForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GPG keys for the authenticated user
    ///
    /// Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_gpg_keys_for_authenticated_user](https://docs.github.com/rest/reference/users#list-gpg-keys-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_gpg_keys_for_authenticated_user_async(&self, query_params: Option<impl Into<UsersListGpgKeysForAuthenticatedUserParams>>) -> Result<Vec<GpgKey>, UsersListGpgKeysForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/gpg_keys", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListGpgKeysForAuthenticatedUserError::Status304),
                404 => Err(UsersListGpgKeysForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersListGpgKeysForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListGpgKeysForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListGpgKeysForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GPG keys for the authenticated user
    ///
    /// Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_gpg_keys_for_authenticated_user](https://docs.github.com/rest/reference/users#list-gpg-keys-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_gpg_keys_for_authenticated_user(&self, query_params: Option<impl Into<UsersListGpgKeysForAuthenticatedUserParams>>) -> Result<Vec<GpgKey>, UsersListGpgKeysForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/gpg_keys", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListGpgKeysForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListGpgKeysForAuthenticatedUserError::Status304),
                404 => Err(UsersListGpgKeysForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersListGpgKeysForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListGpgKeysForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListGpgKeysForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GPG keys for a user
    ///
    /// Lists the GPG keys for a user. This information is accessible by anyone.
    /// 
    /// [GitHub API docs for list_gpg_keys_for_user](https://docs.github.com/rest/reference/users#list-gpg-keys-for-a-user)
    ///
    /// ---
    pub async fn list_gpg_keys_for_user_async(&self, username: &str, query_params: Option<impl Into<UsersListGpgKeysForUserParams>>) -> Result<Vec<GpgKey>, UsersListGpgKeysForUserError> {

        let mut request_uri = format!("{}/users/{}/gpg_keys", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListGpgKeysForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GPG keys for a user
    ///
    /// Lists the GPG keys for a user. This information is accessible by anyone.
    /// 
    /// [GitHub API docs for list_gpg_keys_for_user](https://docs.github.com/rest/reference/users#list-gpg-keys-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_gpg_keys_for_user(&self, username: &str, query_params: Option<impl Into<UsersListGpgKeysForUserParams>>) -> Result<Vec<GpgKey>, UsersListGpgKeysForUserError> {

        let mut request_uri = format!("{}/users/{}/gpg_keys", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListGpgKeysForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListGpgKeysForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public email addresses for the authenticated user
    ///
    /// Lists your publicly visible email address, which you can set with the [Set primary email visibility for the authenticated user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user) endpoint. This endpoint is accessible with the `user:email` scope.
    /// 
    /// [GitHub API docs for list_public_emails_for_authenticated_user](https://docs.github.com/rest/reference/users#list-public-email-addresses-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_public_emails_for_authenticated_user_async(&self, query_params: Option<impl Into<UsersListPublicEmailsForAuthenticatedUserParams>>) -> Result<Vec<Email>, UsersListPublicEmailsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/public_emails", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status304),
                404 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListPublicEmailsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public email addresses for the authenticated user
    ///
    /// Lists your publicly visible email address, which you can set with the [Set primary email visibility for the authenticated user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user) endpoint. This endpoint is accessible with the `user:email` scope.
    /// 
    /// [GitHub API docs for list_public_emails_for_authenticated_user](https://docs.github.com/rest/reference/users#list-public-email-addresses-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_emails_for_authenticated_user(&self, query_params: Option<impl Into<UsersListPublicEmailsForAuthenticatedUserParams>>) -> Result<Vec<Email>, UsersListPublicEmailsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/public_emails", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListPublicEmailsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status304),
                404 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListPublicEmailsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListPublicEmailsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public keys for a user
    ///
    /// Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
    /// 
    /// [GitHub API docs for list_public_keys_for_user](https://docs.github.com/rest/reference/users#list-public-keys-for-a-user)
    ///
    /// ---
    pub async fn list_public_keys_for_user_async(&self, username: &str, query_params: Option<impl Into<UsersListPublicKeysForUserParams>>) -> Result<Vec<KeySimple>, UsersListPublicKeysForUserError> {

        let mut request_uri = format!("{}/users/{}/keys", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListPublicKeysForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public keys for a user
    ///
    /// Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
    /// 
    /// [GitHub API docs for list_public_keys_for_user](https://docs.github.com/rest/reference/users#list-public-keys-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_keys_for_user(&self, username: &str, query_params: Option<impl Into<UsersListPublicKeysForUserParams>>) -> Result<Vec<KeySimple>, UsersListPublicKeysForUserError> {

        let mut request_uri = format!("{}/users/{}/keys", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListPublicKeysForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(UsersListPublicKeysForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public SSH keys for the authenticated user
    ///
    /// Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_public_ssh_keys_for_authenticated_user](https://docs.github.com/rest/reference/users#list-public-ssh-keys-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_public_ssh_keys_for_authenticated_user_async(&self, query_params: Option<impl Into<UsersListPublicSshKeysForAuthenticatedUserParams>>) -> Result<Vec<Key>, UsersListPublicSshKeysForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/keys", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status304),
                404 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersListPublicSshKeysForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public SSH keys for the authenticated user
    ///
    /// Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_public_ssh_keys_for_authenticated_user](https://docs.github.com/rest/reference/users#list-public-ssh-keys-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_ssh_keys_for_authenticated_user(&self, query_params: Option<impl Into<UsersListPublicSshKeysForAuthenticatedUserParams>>) -> Result<Vec<Key>, UsersListPublicSshKeysForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/keys", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: UsersListPublicSshKeysForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status304),
                404 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersListPublicSshKeysForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersListPublicSshKeysForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set primary email visibility for the authenticated user
    ///
    /// Sets the visibility for your primary email addresses.
    /// 
    /// [GitHub API docs for set_primary_email_visibility_for_authenticated_user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user)
    ///
    /// ---
    pub async fn set_primary_email_visibility_for_authenticated_user_async(&self, body: PatchUsersSetPrimaryEmailVisibilityForAuthenticatedUser) -> Result<Vec<Email>, UsersSetPrimaryEmailVisibilityForAuthenticatedUserError> {

        let request_uri = format!("{}/user/email/visibility", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchUsersSetPrimaryEmailVisibilityForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status304),
                404 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set primary email visibility for the authenticated user
    ///
    /// Sets the visibility for your primary email addresses.
    /// 
    /// [GitHub API docs for set_primary_email_visibility_for_authenticated_user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_primary_email_visibility_for_authenticated_user(&self, body: PatchUsersSetPrimaryEmailVisibilityForAuthenticatedUser) -> Result<Vec<Email>, UsersSetPrimaryEmailVisibilityForAuthenticatedUserError> {

        let request_uri = format!("{}/user/email/visibility", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchUsersSetPrimaryEmailVisibilityForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status304),
                404 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(UsersSetPrimaryEmailVisibilityForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unblock a user
    /// 
    /// [GitHub API docs for unblock](https://docs.github.com/rest/reference/users#unblock-a-user)
    ///
    /// ---
    pub async fn unblock_async(&self, username: &str) -> Result<(), UsersUnblockError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUnblockError::Status304),
                403 => Err(UsersUnblockError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersUnblockError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(UsersUnblockError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersUnblockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unblock a user
    /// 
    /// [GitHub API docs for unblock](https://docs.github.com/rest/reference/users#unblock-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unblock(&self, username: &str) -> Result<(), UsersUnblockError> {

        let request_uri = format!("{}/user/blocks/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUnblockError::Status304),
                403 => Err(UsersUnblockError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersUnblockError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(UsersUnblockError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(UsersUnblockError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unfollow a user
    ///
    /// Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
    /// 
    /// [GitHub API docs for unfollow](https://docs.github.com/rest/reference/users#unfollow-a-user)
    ///
    /// ---
    pub async fn unfollow_async(&self, username: &str) -> Result<(), UsersUnfollowError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUnfollowError::Status304),
                404 => Err(UsersUnfollowError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersUnfollowError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersUnfollowError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersUnfollowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unfollow a user
    ///
    /// Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
    /// 
    /// [GitHub API docs for unfollow](https://docs.github.com/rest/reference/users#unfollow-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unfollow(&self, username: &str) -> Result<(), UsersUnfollowError> {

        let request_uri = format!("{}/user/following/{}", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUnfollowError::Status304),
                404 => Err(UsersUnfollowError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersUnfollowError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersUnfollowError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(UsersUnfollowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update the authenticated user
    ///
    /// **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
    /// 
    /// [GitHub API docs for update_authenticated](https://docs.github.com/rest/reference/users/#update-the-authenticated-user)
    ///
    /// ---
    pub async fn update_authenticated_async(&self, body: PatchUsersUpdateAuthenticated) -> Result<PrivateUser, UsersUpdateAuthenticatedError> {

        let request_uri = format!("{}/user", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchUsersUpdateAuthenticated::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUpdateAuthenticatedError::Status304),
                404 => Err(UsersUpdateAuthenticatedError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(UsersUpdateAuthenticatedError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(UsersUpdateAuthenticatedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(UsersUpdateAuthenticatedError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(UsersUpdateAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update the authenticated user
    ///
    /// **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
    /// 
    /// [GitHub API docs for update_authenticated](https://docs.github.com/rest/reference/users/#update-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_authenticated(&self, body: PatchUsersUpdateAuthenticated) -> Result<PrivateUser, UsersUpdateAuthenticatedError> {

        let request_uri = format!("{}/user", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchUsersUpdateAuthenticated::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(UsersUpdateAuthenticatedError::Status304),
                404 => Err(UsersUpdateAuthenticatedError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(UsersUpdateAuthenticatedError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(UsersUpdateAuthenticatedError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(UsersUpdateAuthenticatedError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(UsersUpdateAuthenticatedError::Generic { code }),
            }
        }
    }

}
