//! Method, error and parameter types for the Repos endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Repos<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Repos {
    Repos { auth }
}

/// Errors for the [Accept a repository invitation](Repos::accept_invitation_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAcceptInvitationForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add app access restrictions](Repos::add_app_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAddAppAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add a repository collaborator](Repos::add_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAddCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when person is already a collaborator")]
    Status204,
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add status check contexts](Repos::add_status_check_contexts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAddStatusCheckContextsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add team access restrictions](Repos::add_team_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAddTeamAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add user access restrictions](Repos::add_user_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposAddUserAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a user is a repository collaborator](Repos::check_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCheckCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if user is not a collaborator")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if vulnerability alerts are enabled for a repository](Repos::check_vulnerability_alerts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCheckVulnerabilityAlertsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if repository is not enabled with vulnerability alerts")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Compare two commits](Repos::compare_commits_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCompareCommitsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an autolink reference for a repository](Repos::create_autolink_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateAutolinkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a commit comment](Repos::create_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create commit signature protection](Repos::create_commit_signature_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateCommitSignatureProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a commit status](Repos::create_commit_status_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateCommitStatusError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a deploy key](Repos::create_deploy_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateDeployKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a deployment](Repos::create_deployment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateDeploymentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Merged branch response")]
    Status202(PostReposCreateDeploymentResponse202),
    #[error("Conflict when there is a merge conflict or the commit&#x27;s status checks failed")]
    Status409,
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a deployment status](Repos::create_deployment_status_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateDeploymentStatusError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a repository dispatch event](Repos::create_dispatch_event_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateDispatchEventError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a repository for the authenticated user](Repos::create_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a fork](Repos::create_fork_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateForkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an organization repository](Repos::create_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update an environment](Repos::create_or_update_environment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateOrUpdateEnvironmentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation error when the environment name is invalid or when &#x60;protected_branches&#x60; and &#x60;custom_branch_policies&#x60; in &#x60;deployment_branch_policy&#x60; are set to the same value")]
    Status422(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update file contents](Repos::create_or_update_file_contents_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateOrUpdateFileContentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status201(FileCommit),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a GitHub Pages site](Repos::create_pages_site_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreatePagesSiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a release](Repos::create_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if the discussion category name is invalid")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a repository using a template](Repos::create_using_template_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateUsingTemplateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a repository webhook](Repos::create_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposCreateWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Decline a repository invitation](Repos::decline_invitation_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeclineInvitationForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Conflict")]
    Status409(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a repository](Repos::delete_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("If an organization owner has configured the organization to prevent members from deleting organization-owned repositories, a member will get this response:")]
    Status403(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Temporary Redirect")]
    Status307(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete access restrictions](Repos::delete_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete admin branch protection](Repos::delete_admin_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteAdminBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an environment](Repos::delete_an_environment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteAnEnvironmentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an autolink reference from a repository](Repos::delete_autolink_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteAutolinkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete branch protection](Repos::delete_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a commit comment](Repos::delete_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete commit signature protection](Repos::delete_commit_signature_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteCommitSignatureProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a deploy key](Repos::delete_deploy_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteDeployKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a deployment](Repos::delete_deployment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteDeploymentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a file](Repos::delete_file_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteFileError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a repository invitation](Repos::delete_invitation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteInvitationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a GitHub Pages site](Repos::delete_pages_site_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeletePagesSiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete pull request review protection](Repos::delete_pull_request_review_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeletePullRequestReviewProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a release](Repos::delete_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a release asset](Repos::delete_release_asset_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteReleaseAssetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a repository webhook](Repos::delete_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDeleteWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable automated security fixes](Repos::disable_automated_security_fixes_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDisableAutomatedSecurityFixesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable Git LFS for a repository](Repos::disable_lfs_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDisableLfsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable vulnerability alerts](Repos::disable_vulnerability_alerts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDisableVulnerabilityAlertsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download a repository archive (tar)](Repos::download_tarball_archive_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDownloadTarballArchiveError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download a repository archive (zip)](Repos::download_zipball_archive_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposDownloadZipballArchiveError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable automated security fixes](Repos::enable_automated_security_fixes_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposEnableAutomatedSecurityFixesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable Git LFS for a repository](Repos::enable_lfs_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposEnableLfsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("We will return a 403 with one of the following messages:  - Git LFS support not enabled because Git LFS is globally disabled. - Git LFS support not enabled because Git LFS is disabled for the root repository in the network. - Git LFS support not enabled because Git LFS is disabled for &lt;owner&gt;.")]
    Status403,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable vulnerability alerts](Repos::enable_vulnerability_alerts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposEnableVulnerabilityAlertsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Generate release notes content for a release](Repos::generate_release_notes_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGenerateReleaseNotesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository](Repos::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get access restrictions](Repos::get_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get admin branch protection](Repos::get_admin_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAdminBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all environments](Repos::get_all_environments_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAllEnvironmentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all status check contexts](Repos::get_all_status_check_contexts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAllStatusCheckContextsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all repository topics](Repos::get_all_topics_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAllTopicsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get apps with access to the protected branch](Repos::get_apps_with_access_to_protected_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAppsWithAccessToProtectedBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an autolink reference of a repository](Repos::get_autolink_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetAutolinkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a branch](Repos::get_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get branch protection](Repos::get_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get repository clones](Repos::get_clones_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetClonesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the weekly commit activity](Repos::get_code_frequency_stats_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCodeFrequencyStatsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Accepted")]
    Status202(HashMap<String, Value>),
    #[error("A header with no content is returned.")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get repository permissions for a user](Repos::get_collaborator_permission_level_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCollaboratorPermissionLevelError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the combined status for a specific reference](Repos::get_combined_status_for_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCombinedStatusForRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a commit](Repos::get_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the last year of commit activity](Repos::get_commit_activity_stats_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCommitActivityStatsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Accepted")]
    Status202(HashMap<String, Value>),
    #[error("A header with no content is returned.")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a commit comment](Repos::get_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get commit signature protection](Repos::get_commit_signature_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCommitSignatureProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get community profile metrics](Repos::get_community_profile_metrics_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetCommunityProfileMetricsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get repository content](Repos::get_content_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetContentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Found")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all contributor commit activity](Repos::get_contributors_stats_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetContributorsStatsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Accepted")]
    Status202(HashMap<String, Value>),
    #[error("A header with no content is returned.")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a deploy key](Repos::get_deploy_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetDeployKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a deployment](Repos::get_deployment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetDeploymentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a deployment status](Repos::get_deployment_status_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetDeploymentStatusError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an environment](Repos::get_environment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetEnvironmentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get latest Pages build](Repos::get_latest_pages_build_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetLatestPagesBuildError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the latest release](Repos::get_latest_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetLatestReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a GitHub Pages site](Repos::get_pages_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetPagesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get GitHub Pages build](Repos::get_pages_build_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetPagesBuildError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a DNS health check for GitHub Pages](Repos::get_pages_health_check_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetPagesHealthCheckError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Empty response")]
    Status202(EmptyObject),
    #[error("Custom domains are not available for GitHub Pages")]
    Status400,
    #[error("There isn&#x27;t a CNAME for this page")]
    Status422,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the weekly commit count](Repos::get_participation_stats_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetParticipationStatsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get pull request review protection](Repos::get_pull_request_review_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetPullRequestReviewProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the hourly commit count for each day](Repos::get_punch_card_stats_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetPunchCardStatsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("A header with no content is returned.")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository README](Repos::get_readme_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetReadmeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository README for a directory](Repos::get_readme_in_directory_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetReadmeInDirectoryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a release](Repos::get_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a release asset](Repos::get_release_asset_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetReleaseAssetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Found")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a release by tag name](Repos::get_release_by_tag_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetReleaseByTagError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get status checks protection](Repos::get_status_checks_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetStatusChecksProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get teams with access to the protected branch](Repos::get_teams_with_access_to_protected_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetTeamsWithAccessToProtectedBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get top referral paths](Repos::get_top_paths_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetTopPathsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get top referral sources](Repos::get_top_referrers_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetTopReferrersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get users with access to the protected branch](Repos::get_users_with_access_to_protected_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetUsersWithAccessToProtectedBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get page views](Repos::get_views_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetViewsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository webhook](Repos::get_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a webhook configuration for a repository](Repos::get_webhook_config_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetWebhookConfigForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a delivery for a repository webhook](Repos::get_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposGetWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List all autolinks of a repository](Repos::list_autolinks_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListAutolinksError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List branches](Repos::list_branches_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListBranchesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List branches for HEAD commit](Repos::list_branches_for_head_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListBranchesForHeadCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository collaborators](Repos::list_collaborators_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListCollaboratorsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List commit comments](Repos::list_comments_for_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListCommentsForCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List commit comments for a repository](Repos::list_commit_comments_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListCommitCommentsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List commit statuses for a reference](Repos::list_commit_statuses_for_ref_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListCommitStatusesForRefError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List commits](Repos::list_commits_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListCommitsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository contributors](Repos::list_contributors_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListContributorsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if repository is empty")]
    Status204,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deploy keys](Repos::list_deploy_keys_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListDeployKeysError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deployment statuses](Repos::list_deployment_statuses_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListDeploymentStatusesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deployments](Repos::list_deployments_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListDeploymentsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories for the authenticated user](Repos::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization repositories](Repos::list_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories for a user](Repos::list_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List forks](Repos::list_forks_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListForksError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository invitations](Repos::list_invitations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListInvitationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository invitations for the authenticated user](Repos::list_invitations_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListInvitationsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository languages](Repos::list_languages_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListLanguagesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List GitHub Pages builds](Repos::list_pages_builds_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListPagesBuildsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public repositories](Repos::list_public_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListPublicError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pull requests associated with a commit](Repos::list_pull_requests_associated_with_commit_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListPullRequestsAssociatedWithCommitError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List release assets](Repos::list_release_assets_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListReleaseAssetsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List releases](Repos::list_releases_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListReleasesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository tags](Repos::list_tags_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListTagsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository teams](Repos::list_teams_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListTeamsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deliveries for a repository webhook](Repos::list_webhook_deliveries_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListWebhookDeliveriesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository webhooks](Repos::list_webhooks_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposListWebhooksError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Merge a branch](Repos::merge_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposMergeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when already merged")]
    Status204,
    #[error("Not Found when the base or head does not exist")]
    Status404,
    #[error("Conflict when there is a merge conflict")]
    Status409,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Sync a fork branch with the upstream repository](Repos::merge_upstream_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposMergeUpstreamError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("The branch could not be synced because of a merge conflict")]
    Status409,
    #[error("The branch could not be synced for some other reason")]
    Status422,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Ping a repository webhook](Repos::ping_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposPingWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Redeliver a delivery for a repository webhook](Repos::redeliver_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRedeliverWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove app access restrictions](Repos::remove_app_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveAppAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a repository collaborator](Repos::remove_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove status check contexts](Repos::remove_status_check_contexts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveStatusCheckContextsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove status check protection](Repos::remove_status_check_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveStatusCheckProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove team access restrictions](Repos::remove_team_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveTeamAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove user access restrictions](Repos::remove_user_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRemoveUserAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Rename a branch](Repos::rename_branch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRenameBranchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Replace all repository topics](Repos::replace_all_topics_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposReplaceAllTopicsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Request a GitHub Pages build](Repos::request_pages_build_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposRequestPagesBuildError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set admin branch protection](Repos::set_admin_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposSetAdminBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set app access restrictions](Repos::set_app_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposSetAppAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set status check contexts](Repos::set_status_check_contexts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposSetStatusCheckContextsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set team access restrictions](Repos::set_team_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposSetTeamAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set user access restrictions](Repos::set_user_access_restrictions_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposSetUserAccessRestrictionsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Test the push repository webhook](Repos::test_push_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposTestPushWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Transfer a repository](Repos::transfer_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposTransferError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a repository](Repos::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Temporary Redirect")]
    Status307(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update branch protection](Repos::update_branch_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateBranchProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a commit comment](Repos::update_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update information about a GitHub Pages site](Repos::update_information_about_pages_site_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateInformationAboutPagesSiteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a repository invitation](Repos::update_invitation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateInvitationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update pull request review protection](Repos::update_pull_request_review_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdatePullRequestReviewProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a release](Repos::update_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if the discussion category name is invalid")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a release asset](Repos::update_release_asset_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateReleaseAssetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update status check protection](Repos::update_status_check_protection_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateStatusCheckProtectionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a repository webhook](Repos::update_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a webhook configuration for a repository](Repos::update_webhook_config_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUpdateWebhookConfigForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Upload a release asset](Repos::upload_release_asset_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReposUploadReleaseAssetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if you upload an asset with the same filename as another uploaded asset")]
    Status422,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Compare two commits](Repos::compare_commits_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposCompareCommitsParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl ReposCompareCommitsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposCompareCommitsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get all repository topics](Repos::get_all_topics_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetAllTopicsParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl ReposGetAllTopicsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposGetAllTopicsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get repository clones](Repos::get_clones_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetClonesParams<'req> {
    /// Must be one of: `day`, `week`.
    per: Option<&'req str>
}

impl<'req> ReposGetClonesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Must be one of: `day`, `week`.
    pub fn per(self, per: &'req str) -> Self {
        Self { 
            per: Some(per),
        }
    }
}

/// Query parameters for the [Get the combined status for a specific reference](Repos::get_combined_status_for_ref_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetCombinedStatusForRefParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposGetCombinedStatusForRefParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposGetCombinedStatusForRefParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get a commit](Repos::get_commit_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetCommitParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl ReposGetCommitParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposGetCommitParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get repository content](Repos::get_content_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetContentParams<'req> {
    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    git_ref: Option<&'req str>
}

impl<'req> ReposGetContentParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    pub fn git_ref(self, git_ref: &'req str) -> Self {
        Self { 
            git_ref: Some(git_ref),
        }
    }
}

/// Query parameters for the [Get a repository README](Repos::get_readme_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetReadmeParams<'req> {
    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    git_ref: Option<&'req str>
}

impl<'req> ReposGetReadmeParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    pub fn git_ref(self, git_ref: &'req str) -> Self {
        Self { 
            git_ref: Some(git_ref),
        }
    }
}

/// Query parameters for the [Get a repository README for a directory](Repos::get_readme_in_directory_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetReadmeInDirectoryParams<'req> {
    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    git_ref: Option<&'req str>
}

impl<'req> ReposGetReadmeInDirectoryParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
    pub fn git_ref(self, git_ref: &'req str) -> Self {
        Self { 
            git_ref: Some(git_ref),
        }
    }
}

/// Query parameters for the [Get page views](Repos::get_views_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposGetViewsParams<'req> {
    /// Must be one of: `day`, `week`.
    per: Option<&'req str>
}

impl<'req> ReposGetViewsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Must be one of: `day`, `week`.
    pub fn per(self, per: &'req str) -> Self {
        Self { 
            per: Some(per),
        }
    }
}

/// Query parameters for the [List all autolinks of a repository](Repos::list_autolinks_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListAutolinksParams {
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListAutolinksParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
        }
    }
}

/// Query parameters for the [List branches](Repos::list_branches_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListBranchesParams {
    /// Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
    protected: Option<bool>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListBranchesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
    pub fn protected(self, protected: bool) -> Self {
        Self { 
            protected: Some(protected),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            protected: self.protected, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            protected: self.protected, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListBranchesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository collaborators](Repos::list_collaborators_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListCollaboratorsParams<'req> {
    /// Filter collaborators returned by their affiliation. Can be one of:   \\* `outside`: All outside collaborators of an organization-owned repository.   \\* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.   \\* `all`: All collaborators the authenticated user can see.
    affiliation: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListCollaboratorsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filter collaborators returned by their affiliation. Can be one of:   \\* `outside`: All outside collaborators of an organization-owned repository.   \\* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.   \\* `all`: All collaborators the authenticated user can see.
    pub fn affiliation(self, affiliation: &'req str) -> Self {
        Self { 
            affiliation: Some(affiliation),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            affiliation: self.affiliation, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            affiliation: self.affiliation, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListCollaboratorsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List commit comments](Repos::list_comments_for_commit_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListCommentsForCommitParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListCommentsForCommitParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListCommentsForCommitParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List commit comments for a repository](Repos::list_commit_comments_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListCommitCommentsForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListCommitCommentsForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListCommitCommentsForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List commit statuses for a reference](Repos::list_commit_statuses_for_ref_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListCommitStatusesForRefParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListCommitStatusesForRefParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListCommitStatusesForRefParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List commits](Repos::list_commits_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListCommitsParams<'req> {
    /// SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
    sha: Option<&'req str>, 
    /// Only commits containing this file path will be returned.
    path: Option<&'req str>, 
    /// GitHub login or email address by which to filter by commit author.
    author: Option<&'req str>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    until: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListCommitsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
    pub fn sha(self, sha: &'req str) -> Self {
        Self { 
            sha: Some(sha),
            path: self.path, 
            author: self.author, 
            since: self.since, 
            until: self.until, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only commits containing this file path will be returned.
    pub fn path(self, path: &'req str) -> Self {
        Self { 
            sha: self.sha, 
            path: Some(path),
            author: self.author, 
            since: self.since, 
            until: self.until, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// GitHub login or email address by which to filter by commit author.
    pub fn author(self, author: &'req str) -> Self {
        Self { 
            sha: self.sha, 
            path: self.path, 
            author: Some(author),
            since: self.since, 
            until: self.until, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            sha: self.sha, 
            path: self.path, 
            author: self.author, 
            since: Some(since),
            until: self.until, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn until(self, until: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            sha: self.sha, 
            path: self.path, 
            author: self.author, 
            since: self.since, 
            until: Some(until),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sha: self.sha, 
            path: self.path, 
            author: self.author, 
            since: self.since, 
            until: self.until, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sha: self.sha, 
            path: self.path, 
            author: self.author, 
            since: self.since, 
            until: self.until, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListCommitsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository contributors](Repos::list_contributors_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListContributorsParams<'req> {
    /// Set to `1` or `true` to include anonymous contributors in results.
    anon: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListContributorsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Set to `1` or `true` to include anonymous contributors in results.
    pub fn anon(self, anon: &'req str) -> Self {
        Self { 
            anon: Some(anon),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            anon: self.anon, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            anon: self.anon, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListContributorsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deploy keys](Repos::list_deploy_keys_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListDeployKeysParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListDeployKeysParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListDeployKeysParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deployment statuses](Repos::list_deployment_statuses_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListDeploymentStatusesParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListDeploymentStatusesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListDeploymentStatusesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deployments](Repos::list_deployments_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListDeploymentsParams<'req> {
    /// The SHA recorded at creation time.
    sha: Option<&'req str>, 
    /// The name of the ref. This can be a branch, tag, or SHA.
    git_ref: Option<&'req str>, 
    /// The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
    task: Option<&'req str>, 
    /// The name of the environment that was deployed to (e.g., `staging` or `production`).
    environment: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListDeploymentsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The SHA recorded at creation time.
    pub fn sha(self, sha: &'req str) -> Self {
        Self { 
            sha: Some(sha),
            git_ref: self.git_ref, 
            task: self.task, 
            environment: self.environment, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The name of the ref. This can be a branch, tag, or SHA.
    pub fn git_ref(self, git_ref: &'req str) -> Self {
        Self { 
            sha: self.sha, 
            git_ref: Some(git_ref),
            task: self.task, 
            environment: self.environment, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
    pub fn task(self, task: &'req str) -> Self {
        Self { 
            sha: self.sha, 
            git_ref: self.git_ref, 
            task: Some(task),
            environment: self.environment, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The name of the environment that was deployed to (e.g., `staging` or `production`).
    pub fn environment(self, environment: &'req str) -> Self {
        Self { 
            sha: self.sha, 
            git_ref: self.git_ref, 
            task: self.task, 
            environment: Some(environment),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sha: self.sha, 
            git_ref: self.git_ref, 
            task: self.task, 
            environment: self.environment, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sha: self.sha, 
            git_ref: self.git_ref, 
            task: self.task, 
            environment: self.environment, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListDeploymentsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories for the authenticated user](Repos::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListForAuthenticatedUserParams<'req> {
    /// Can be one of `all`, `public`, or `private`. Note: For GitHub AE, can be one of `all`, `internal`, or `private`.
    visibility: Option<&'req str>, 
    /// Comma-separated list of values. Can include:   \\* `owner`: Repositories that are owned by the authenticated user.   \\* `collaborator`: Repositories that the user has been added to as a collaborator.   \\* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
    affiliation: Option<&'req str>, 
    /// Can be one of `all`, `owner`, `public`, `private`, `member`. Note: For GitHub AE, can be one of `all`, `owner`, `internal`, `private`, `member`. Default: `all`      Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
    _type: Option<&'req str>, 
    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    sort: Option<&'req str>, 
    /// Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    before: Option<chrono::DateTime<chrono::Utc>>
}

impl<'req> ReposListForAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Can be one of `all`, `public`, or `private`. Note: For GitHub AE, can be one of `all`, `internal`, or `private`.
    pub fn visibility(self, visibility: &'req str) -> Self {
        Self { 
            visibility: Some(visibility),
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Comma-separated list of values. Can include:   \\* `owner`: Repositories that are owned by the authenticated user.   \\* `collaborator`: Repositories that the user has been added to as a collaborator.   \\* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
    pub fn affiliation(self, affiliation: &'req str) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: Some(affiliation),
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Can be one of `all`, `owner`, `public`, `private`, `member`. Note: For GitHub AE, can be one of `all`, `owner`, `internal`, `private`, `member`. Default: `all`      Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
    pub fn _type(self, _type: &'req str) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: Some(_type),
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
            since: self.since, 
            before: self.before, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
            since: self.since, 
            before: self.before, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: Some(since),
            before: self.before, 
        }
    }

    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn before(self, before: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            visibility: self.visibility, 
            affiliation: self.affiliation, 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            before: Some(before),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListForAuthenticatedUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization repositories](Repos::list_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListForOrgParams<'req> {
    /// Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Note: For GitHub AE, can be one of `all`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`. However, the `internal` value is not yet supported when a GitHub App calls this API with an installation access token.
    _type: Option<&'req str>, 
    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    sort: Option<&'req str>, 
    /// Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListForOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Note: For GitHub AE, can be one of `all`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`. However, the `internal` value is not yet supported when a GitHub App calls this API with an installation access token.
    pub fn _type(self, _type: &'req str) -> Self {
        Self { 
            _type: Some(_type),
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            _type: self._type, 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListForOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories for a user](Repos::list_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListForUserParams<'req> {
    /// Can be one of `all`, `owner`, `member`.
    _type: Option<&'req str>, 
    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    sort: Option<&'req str>, 
    /// Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListForUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Can be one of `all`, `owner`, `member`.
    pub fn _type(self, _type: &'req str) -> Self {
        Self { 
            _type: Some(_type),
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be one of `created`, `updated`, `pushed`, `full_name`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            _type: self._type, 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            _type: self._type, 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListForUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List forks](Repos::list_forks_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListForksParams<'req> {
    /// The sort order. Can be either `newest`, `oldest`, or `stargazers`.
    sort: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReposListForksParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The sort order. Can be either `newest`, `oldest`, or `stargazers`.
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListForksParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository invitations](Repos::list_invitations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListInvitationsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListInvitationsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListInvitationsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository invitations for the authenticated user](Repos::list_invitations_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListInvitationsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListInvitationsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListInvitationsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List GitHub Pages builds](Repos::list_pages_builds_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListPagesBuildsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListPagesBuildsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListPagesBuildsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public repositories](Repos::list_public_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListPublicParams {
    /// A repository ID. Only return repositories with an ID greater than this ID.
    since: Option<i32>
}

impl ReposListPublicParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// A repository ID. Only return repositories with an ID greater than this ID.
    pub fn since(self, since: i32) -> Self {
        Self { 
            since: Some(since),
        }
    }
}

/// Query parameters for the [List pull requests associated with a commit](Repos::list_pull_requests_associated_with_commit_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListPullRequestsAssociatedWithCommitParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListPullRequestsAssociatedWithCommitParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListPullRequestsAssociatedWithCommitParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List release assets](Repos::list_release_assets_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListReleaseAssetsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListReleaseAssetsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListReleaseAssetsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List releases](Repos::list_releases_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListReleasesParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListReleasesParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListReleasesParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository tags](Repos::list_tags_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListTagsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListTagsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListTagsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository teams](Repos::list_teams_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListTeamsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListTeamsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListTeamsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deliveries for a repository webhook](Repos::list_webhook_deliveries_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListWebhookDeliveriesParams<'req> {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    cursor: Option<&'req str>
}

impl<'req> ReposListWebhookDeliveriesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            cursor: self.cursor, 
        }
    }

    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    pub fn cursor(self, cursor: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            cursor: Some(cursor),
        }
    }
}

/// Query parameters for the [List repository webhooks](Repos::list_webhooks_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposListWebhooksParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ReposListWebhooksParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReposListWebhooksParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Upload a release asset](Repos::upload_release_asset_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReposUploadReleaseAssetParams<'req> {
    
    name: &'req str, 
    
    label: Option<&'req str>
}

impl<'req> ReposUploadReleaseAssetParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    
    pub fn name(self, name: &'req str) -> Self {
        Self { 
            name: name,
            label: self.label, 
        }
    }

    
    pub fn label(self, label: &'req str) -> Self {
        Self { 
            name: self.name, 
            label: Some(label),
        }
    }
}


impl<'api> Repos<'api> {
    /// ---
    ///
    /// # Accept a repository invitation
    /// 
    /// [GitHub API docs for accept_invitation_for_authenticated_user](https://docs.github.com/rest/reference/repos#accept-a-repository-invitation)
    ///
    /// ---
    pub async fn accept_invitation_for_authenticated_user_async(&self, invitation_id: i32) -> Result<(), ReposAcceptInvitationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repository_invitations/{}", super::GITHUB_BASE_API_URL, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status409(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status304),
                code => Err(ReposAcceptInvitationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Accept a repository invitation
    /// 
    /// [GitHub API docs for accept_invitation_for_authenticated_user](https://docs.github.com/rest/reference/repos#accept-a-repository-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn accept_invitation_for_authenticated_user(&self, invitation_id: i32) -> Result<(), ReposAcceptInvitationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repository_invitations/{}", super::GITHUB_BASE_API_URL, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status409(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                304 => Err(ReposAcceptInvitationForAuthenticatedUserError::Status304),
                code => Err(ReposAcceptInvitationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified apps push access for this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_app_access_restrictions](https://docs.github.com/rest/reference/repos#add-app-access-restrictions)
    ///
    /// ---
    pub async fn add_app_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddAppAccessRestrictions) -> Result<Vec<Integration>, ReposAddAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddAppAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddAppAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposAddAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified apps push access for this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_app_access_restrictions](https://docs.github.com/rest/reference/repos#add-app-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_app_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddAppAccessRestrictions) -> Result<Vec<Integration>, ReposAddAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddAppAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddAppAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposAddAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a repository collaborator
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// For more information on permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the permission being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
    /// 
    /// ```nocompile
    /// Cannot assign {member} permission of {role name}
    /// ```
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://docs.github.com/rest/reference/repos#invitations).
    /// 
    /// **Rate limits**
    /// 
    /// You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
    /// 
    /// [GitHub API docs for add_collaborator](https://docs.github.com/rest/reference/repos#add-a-repository-collaborator)
    ///
    /// ---
    pub async fn add_collaborator_async(&self, owner: &str, repo: &str, username: &str, body: PutReposAddCollaborator) -> Result<RepositoryInvitation, ReposAddCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposAddCollaborator::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposAddCollaboratorError::Status204),
                422 => Err(ReposAddCollaboratorError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposAddCollaboratorError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposAddCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a repository collaborator
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// For more information on permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the permission being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
    /// 
    /// ```nocompile
    /// Cannot assign {member} permission of {role name}
    /// ```
    /// 
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://docs.github.com/rest/reference/repos#invitations).
    /// 
    /// **Rate limits**
    /// 
    /// You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
    /// 
    /// [GitHub API docs for add_collaborator](https://docs.github.com/rest/reference/repos#add-a-repository-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_collaborator(&self, owner: &str, repo: &str, username: &str, body: PutReposAddCollaborator) -> Result<RepositoryInvitation, ReposAddCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposAddCollaborator::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposAddCollaboratorError::Status204),
                422 => Err(ReposAddCollaboratorError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposAddCollaboratorError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposAddCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for add_status_check_contexts](https://docs.github.com/rest/reference/repos#add-status-check-contexts)
    ///
    /// ---
    pub async fn add_status_check_contexts_async(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddStatusCheckContexts) -> Result<Vec<String>, ReposAddStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddStatusCheckContexts::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddStatusCheckContextsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposAddStatusCheckContextsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposAddStatusCheckContextsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposAddStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for add_status_check_contexts](https://docs.github.com/rest/reference/repos#add-status-check-contexts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_status_check_contexts(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddStatusCheckContexts) -> Result<Vec<String>, ReposAddStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddStatusCheckContexts::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddStatusCheckContextsError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposAddStatusCheckContextsError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposAddStatusCheckContextsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposAddStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified teams push access for this branch. You can also give push access to child teams.
    /// 
    /// | Type    | Description                                                                                                                                |
    /// | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
    /// | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_team_access_restrictions](https://docs.github.com/rest/reference/repos#add-team-access-restrictions)
    ///
    /// ---
    pub async fn add_team_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddTeamAccessRestrictions) -> Result<Vec<Team>, ReposAddTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddTeamAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddTeamAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposAddTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified teams push access for this branch. You can also give push access to child teams.
    /// 
    /// | Type    | Description                                                                                                                                |
    /// | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
    /// | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_team_access_restrictions](https://docs.github.com/rest/reference/repos#add-team-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_team_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddTeamAccessRestrictions) -> Result<Vec<Team>, ReposAddTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddTeamAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddTeamAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposAddTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified people push access for this branch.
    /// 
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_user_access_restrictions](https://docs.github.com/rest/reference/repos#add-user-access-restrictions)
    ///
    /// ---
    pub async fn add_user_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposAddUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddUserAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddUserAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposAddUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Grants the specified people push access for this branch.
    /// 
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for add_user_access_restrictions](https://docs.github.com/rest/reference/repos#add-user-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_user_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PostReposAddUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposAddUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposAddUserAccessRestrictions::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposAddUserAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposAddUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is a repository collaborator
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// [GitHub API docs for check_collaborator](https://docs.github.com/rest/reference/repos#check-if-a-user-is-a-repository-collaborator)
    ///
    /// ---
    pub async fn check_collaborator_async(&self, owner: &str, repo: &str, username: &str) -> Result<(), ReposCheckCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCheckCollaboratorError::Status404),
                code => Err(ReposCheckCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is a repository collaborator
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// [GitHub API docs for check_collaborator](https://docs.github.com/rest/reference/repos#check-if-a-user-is-a-repository-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_collaborator(&self, owner: &str, repo: &str, username: &str) -> Result<(), ReposCheckCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCheckCollaboratorError::Status404),
                code => Err(ReposCheckCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if vulnerability alerts are enabled for a repository
    ///
    /// Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for check_vulnerability_alerts](https://docs.github.com/rest/reference/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository)
    ///
    /// ---
    pub async fn check_vulnerability_alerts_async(&self, owner: &str, repo: &str) -> Result<(), ReposCheckVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCheckVulnerabilityAlertsError::Status404),
                code => Err(ReposCheckVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if vulnerability alerts are enabled for a repository
    ///
    /// Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for check_vulnerability_alerts](https://docs.github.com/rest/reference/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_vulnerability_alerts(&self, owner: &str, repo: &str) -> Result<(), ReposCheckVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCheckVulnerabilityAlertsError::Status404),
                code => Err(ReposCheckVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Compare two commits
    ///
    /// The `basehead` param is comprised of two parts: `base` and `head`. Both must be branch names in `repo`. To compare branches across other repositories in the same network as `repo`, use the format `<USERNAME>:branch`.
    /// 
    /// The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
    /// 
    /// The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
    /// 
    /// **Working with large comparisons**
    /// 
    /// To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
    /// 
    /// When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for compare_commits](https://docs.github.com/rest/reference/repos#compare-two-commits)
    ///
    /// ---
    pub async fn compare_commits_async(&self, owner: &str, repo: &str, basehead: &str, query_params: Option<impl Into<ReposCompareCommitsParams>>) -> Result<CommitComparison, ReposCompareCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/compare/{}", super::GITHUB_BASE_API_URL, owner, repo, basehead);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                500 => Err(ReposCompareCommitsError::Status500(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposCompareCommitsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCompareCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Compare two commits
    ///
    /// The `basehead` param is comprised of two parts: `base` and `head`. Both must be branch names in `repo`. To compare branches across other repositories in the same network as `repo`, use the format `<USERNAME>:branch`.
    /// 
    /// The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
    /// 
    /// The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
    /// 
    /// **Working with large comparisons**
    /// 
    /// To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
    /// 
    /// When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for compare_commits](https://docs.github.com/rest/reference/repos#compare-two-commits)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn compare_commits(&self, owner: &str, repo: &str, basehead: &str, query_params: Option<impl Into<ReposCompareCommitsParams>>) -> Result<CommitComparison, ReposCompareCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/compare/{}", super::GITHUB_BASE_API_URL, owner, repo, basehead);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposCompareCommitsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                500 => Err(ReposCompareCommitsError::Status500(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposCompareCommitsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCompareCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an autolink reference for a repository
    ///
    /// Users with admin access to the repository can create an autolink.
    /// 
    /// [GitHub API docs for create_autolink](https://docs.github.com/v3/repos#create-an-autolink)
    ///
    /// ---
    pub async fn create_autolink_async(&self, owner: &str, repo: &str, body: PostReposCreateAutolink) -> Result<Autolink, ReposCreateAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateAutolink::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateAutolinkError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an autolink reference for a repository
    ///
    /// Users with admin access to the repository can create an autolink.
    /// 
    /// [GitHub API docs for create_autolink](https://docs.github.com/v3/repos#create-an-autolink)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_autolink(&self, owner: &str, repo: &str, body: PostReposCreateAutolink) -> Result<Autolink, ReposCreateAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateAutolink::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateAutolinkError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit comment
    ///
    /// Create a comment for a commit using its `:commit_sha`.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_commit_comment](https://docs.github.com/rest/reference/repos#create-a-commit-comment)
    ///
    /// ---
    pub async fn create_commit_comment_async(&self, owner: &str, repo: &str, commit_sha: &str, body: PostReposCreateCommitComment) -> Result<CommitComment, ReposCreateCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/commits/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateCommitComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposCreateCommitCommentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateCommitCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit comment
    ///
    /// Create a comment for a commit using its `:commit_sha`.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_commit_comment](https://docs.github.com/rest/reference/repos#create-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_commit_comment(&self, owner: &str, repo: &str, commit_sha: &str, body: PostReposCreateCommitComment) -> Result<CommitComment, ReposCreateCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/commits/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateCommitComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposCreateCommitCommentError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateCommitCommentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for create_commit_signature_protection](https://docs.github.com/rest/reference/repos#create-commit-signature-protection)
    ///
    /// ---
    pub async fn create_commit_signature_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposCreateCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateCommitSignatureProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for create_commit_signature_protection](https://docs.github.com/rest/reference/repos#create-commit-signature-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_commit_signature_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposCreateCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateCommitSignatureProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit status
    ///
    /// Users with push access in a repository can create commit statuses for a given SHA.
    /// 
    /// Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
    /// 
    /// [GitHub API docs for create_commit_status](https://docs.github.com/rest/reference/repos#create-a-commit-status)
    ///
    /// ---
    pub async fn create_commit_status_async(&self, owner: &str, repo: &str, sha: &str, body: PostReposCreateCommitStatus) -> Result<Status, ReposCreateCommitStatusError> {

        let request_uri = format!("{}/repos/{}/{}/statuses/{}", super::GITHUB_BASE_API_URL, owner, repo, sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateCommitStatus::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposCreateCommitStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a commit status
    ///
    /// Users with push access in a repository can create commit statuses for a given SHA.
    /// 
    /// Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
    /// 
    /// [GitHub API docs for create_commit_status](https://docs.github.com/rest/reference/repos#create-a-commit-status)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_commit_status(&self, owner: &str, repo: &str, sha: &str, body: PostReposCreateCommitStatus) -> Result<Status, ReposCreateCommitStatusError> {

        let request_uri = format!("{}/repos/{}/{}/statuses/{}", super::GITHUB_BASE_API_URL, owner, repo, sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateCommitStatus::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposCreateCommitStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deploy key
    ///
    /// You can create a read-only deploy key.
    /// 
    /// [GitHub API docs for create_deploy_key](https://docs.github.com/rest/reference/repos#create-a-deploy-key)
    ///
    /// ---
    pub async fn create_deploy_key_async(&self, owner: &str, repo: &str, body: PostReposCreateDeployKey) -> Result<DeployKey, ReposCreateDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeployKey::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDeployKeyError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deploy key
    ///
    /// You can create a read-only deploy key.
    /// 
    /// [GitHub API docs for create_deploy_key](https://docs.github.com/rest/reference/repos#create-a-deploy-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_deploy_key(&self, owner: &str, repo: &str, body: PostReposCreateDeployKey) -> Result<DeployKey, ReposCreateDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeployKey::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDeployKeyError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deployment
    ///
    /// Deployments offer a few configurable parameters with certain defaults.
    /// 
    /// The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
    /// before we merge a pull request.
    /// 
    /// The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
    /// multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
    /// makes it easier to track which environments have requested deployments. The default environment is `production`.
    /// 
    /// The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
    /// the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
    /// the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
    /// return a failure response.
    /// 
    /// By default, [commit statuses](https://docs.github.com/rest/reference/repos#statuses) for every submitted context must be in a `success`
    /// state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
    /// specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
    /// not require any contexts or create any commit statuses, the deployment will always succeed.
    /// 
    /// The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
    /// field that will be passed on when a deployment event is dispatched.
    /// 
    /// The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
    /// be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
    /// application with debugging enabled.
    /// 
    /// Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref.
    /// 
    /// #### Merged branch response
    /// You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
    /// a deployment. This auto-merge happens when:
    /// *   Auto-merge option is enabled in the repository
    /// *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
    /// *   There are no merge conflicts
    /// 
    /// If there are no new commits in the base branch, a new request to create a deployment should give a successful
    /// response.
    /// 
    /// #### Merge conflict response
    /// This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
    /// be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
    /// 
    /// #### Failed commit status checks
    /// This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
    /// status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
    /// 
    /// [GitHub API docs for create_deployment](https://docs.github.com/rest/reference/repos#create-a-deployment)
    ///
    /// ---
    pub async fn create_deployment_async(&self, owner: &str, repo: &str, body: PostReposCreateDeployment) -> Result<Deployment, ReposCreateDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeployment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposCreateDeploymentError::Status202(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposCreateDeploymentError::Status409),
                422 => Err(ReposCreateDeploymentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deployment
    ///
    /// Deployments offer a few configurable parameters with certain defaults.
    /// 
    /// The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
    /// before we merge a pull request.
    /// 
    /// The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
    /// multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
    /// makes it easier to track which environments have requested deployments. The default environment is `production`.
    /// 
    /// The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
    /// the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
    /// the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
    /// return a failure response.
    /// 
    /// By default, [commit statuses](https://docs.github.com/rest/reference/repos#statuses) for every submitted context must be in a `success`
    /// state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
    /// specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
    /// not require any contexts or create any commit statuses, the deployment will always succeed.
    /// 
    /// The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
    /// field that will be passed on when a deployment event is dispatched.
    /// 
    /// The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
    /// be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
    /// application with debugging enabled.
    /// 
    /// Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref.
    /// 
    /// #### Merged branch response
    /// You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
    /// a deployment. This auto-merge happens when:
    /// *   Auto-merge option is enabled in the repository
    /// *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
    /// *   There are no merge conflicts
    /// 
    /// If there are no new commits in the base branch, a new request to create a deployment should give a successful
    /// response.
    /// 
    /// #### Merge conflict response
    /// This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
    /// be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
    /// 
    /// #### Failed commit status checks
    /// This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
    /// status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
    /// 
    /// [GitHub API docs for create_deployment](https://docs.github.com/rest/reference/repos#create-a-deployment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_deployment(&self, owner: &str, repo: &str, body: PostReposCreateDeployment) -> Result<Deployment, ReposCreateDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeployment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposCreateDeploymentError::Status202(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposCreateDeploymentError::Status409),
                422 => Err(ReposCreateDeploymentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deployment status
    ///
    /// Users with `push` access can create deployment statuses for a given deployment.
    /// 
    /// GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
    /// 
    /// [GitHub API docs for create_deployment_status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)
    ///
    /// ---
    pub async fn create_deployment_status_async(&self, owner: &str, repo: &str, deployment_id: i32, body: PostReposCreateDeploymentStatus) -> Result<DeploymentStatus, ReposCreateDeploymentStatusError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeploymentStatus::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDeploymentStatusError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateDeploymentStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a deployment status
    ///
    /// Users with `push` access can create deployment statuses for a given deployment.
    /// 
    /// GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
    /// 
    /// [GitHub API docs for create_deployment_status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_deployment_status(&self, owner: &str, repo: &str, deployment_id: i32, body: PostReposCreateDeploymentStatus) -> Result<DeploymentStatus, ReposCreateDeploymentStatusError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDeploymentStatus::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDeploymentStatusError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateDeploymentStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository dispatch event
    ///
    /// You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
    /// 
    /// The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
    /// 
    /// This endpoint requires write access to the repository by providing either:
    /// 
    ///   - Personal access tokens with `repo` scope. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)" in the GitHub Help documentation.
    ///   - GitHub Apps with both `metadata:read` and `contents:read&write` permissions.
    /// 
    /// This input example shows how you can use the `client_payload` as a test to debug your workflow.
    /// 
    /// [GitHub API docs for create_dispatch_event](https://docs.github.com/rest/reference/repos#create-a-repository-dispatch-event)
    ///
    /// ---
    pub async fn create_dispatch_event_async(&self, owner: &str, repo: &str, body: PostReposCreateDispatchEvent) -> Result<(), ReposCreateDispatchEventError> {

        let request_uri = format!("{}/repos/{}/{}/dispatches", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDispatchEvent::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDispatchEventError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateDispatchEventError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository dispatch event
    ///
    /// You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
    /// 
    /// The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
    /// 
    /// This endpoint requires write access to the repository by providing either:
    /// 
    ///   - Personal access tokens with `repo` scope. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)" in the GitHub Help documentation.
    ///   - GitHub Apps with both `metadata:read` and `contents:read&write` permissions.
    /// 
    /// This input example shows how you can use the `client_payload` as a test to debug your workflow.
    /// 
    /// [GitHub API docs for create_dispatch_event](https://docs.github.com/rest/reference/repos#create-a-repository-dispatch-event)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_dispatch_event(&self, owner: &str, repo: &str, body: PostReposCreateDispatchEvent) -> Result<(), ReposCreateDispatchEventError> {

        let request_uri = format!("{}/repos/{}/{}/dispatches", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateDispatchEvent::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateDispatchEventError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateDispatchEventError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository for the authenticated user
    ///
    /// Creates a new repository for the authenticated user.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository.
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user)
    ///
    /// ---
    pub async fn create_for_authenticated_user_async(&self, body: PostReposCreateForAuthenticatedUser) -> Result<Repository, ReposCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repos", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(ReposCreateForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ReposCreateForAuthenticatedUserError::Status304),
                404 => Err(ReposCreateForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposCreateForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ReposCreateForAuthenticatedUserError::Status400(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository for the authenticated user
    ///
    /// Creates a new repository for the authenticated user.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository.
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_authenticated_user(&self, body: PostReposCreateForAuthenticatedUser) -> Result<Repository, ReposCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repos", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(ReposCreateForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                304 => Err(ReposCreateForAuthenticatedUserError::Status304),
                404 => Err(ReposCreateForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposCreateForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                400 => Err(ReposCreateForAuthenticatedUserError::Status400(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a fork
    ///
    /// Create a fork for the authenticated user.
    /// 
    /// **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// 
    /// [GitHub API docs for create_fork](https://docs.github.com/rest/reference/repos#create-a-fork)
    ///
    /// ---
    pub async fn create_fork_async(&self, owner: &str, repo: &str, body: PostReposCreateFork) -> Result<FullRepository, ReposCreateForkError> {

        let request_uri = format!("{}/repos/{}/{}/forks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateFork::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposCreateForkError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateForkError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposCreateForkError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposCreateForkError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateForkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a fork
    ///
    /// Create a fork for the authenticated user.
    /// 
    /// **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// 
    /// [GitHub API docs for create_fork](https://docs.github.com/rest/reference/repos#create-a-fork)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_fork(&self, owner: &str, repo: &str, body: PostReposCreateFork) -> Result<FullRepository, ReposCreateForkError> {

        let request_uri = format!("{}/repos/{}/{}/forks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateFork::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposCreateForkError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateForkError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposCreateForkError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposCreateForkError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateForkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization repository
    ///
    /// Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository
    /// 
    /// [GitHub API docs for create_in_org](https://docs.github.com/rest/reference/repos#create-an-organization-repository)
    ///
    /// ---
    pub async fn create_in_org_async(&self, org: &str, body: PostReposCreateInOrg) -> Result<Repository, ReposCreateInOrgError> {

        let request_uri = format!("{}/orgs/{}/repos", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposCreateInOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateInOrgError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization repository
    ///
    /// Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository
    /// 
    /// [GitHub API docs for create_in_org](https://docs.github.com/rest/reference/repos#create-an-organization-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_in_org(&self, org: &str, body: PostReposCreateInOrg) -> Result<Repository, ReposCreateInOrgError> {

        let request_uri = format!("{}/orgs/{}/repos", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposCreateInOrgError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateInOrgError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an environment
    ///
    /// Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
    /// 
    /// **Note:** Although you can use this operation to specify that only branches that match specified name patterns can deploy to this environment, you must use the UI to set the name patterns. For more information, see "[Environments](/actions/reference/environments#deployment-branches)."
    /// 
    /// **Note:** To create or update secrets for an environment, see "[Secrets](/rest/reference/actions#secrets)."
    /// 
    /// You must authenticate using an access token with the repo scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_or_update_environment](https://docs.github.com/rest/reference/repos#create-or-update-an-environment)
    ///
    /// ---
    pub async fn create_or_update_environment_async(&self, owner: &str, repo: &str, environment_name: &str, body: PutReposCreateOrUpdateEnvironment) -> Result<Environment, ReposCreateOrUpdateEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposCreateOrUpdateEnvironment::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateOrUpdateEnvironmentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateOrUpdateEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an environment
    ///
    /// Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
    /// 
    /// **Note:** Although you can use this operation to specify that only branches that match specified name patterns can deploy to this environment, you must use the UI to set the name patterns. For more information, see "[Environments](/actions/reference/environments#deployment-branches)."
    /// 
    /// **Note:** To create or update secrets for an environment, see "[Secrets](/rest/reference/actions#secrets)."
    /// 
    /// You must authenticate using an access token with the repo scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_or_update_environment](https://docs.github.com/rest/reference/repos#create-or-update-an-environment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_environment(&self, owner: &str, repo: &str, environment_name: &str, body: PutReposCreateOrUpdateEnvironment) -> Result<Environment, ReposCreateOrUpdateEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposCreateOrUpdateEnvironment::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreateOrUpdateEnvironmentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateOrUpdateEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update file contents
    ///
    /// Creates a new file or replaces an existing file in a repository.
    /// 
    /// [GitHub API docs for create_or_update_file_contents](https://docs.github.com/rest/reference/repos#create-or-update-file-contents)
    ///
    /// ---
    pub async fn create_or_update_file_contents_async(&self, owner: &str, repo: &str, path: &str, body: PutReposCreateOrUpdateFileContents) -> Result<FileCommit, ReposCreateOrUpdateFileContentsError> {

        let request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposCreateOrUpdateFileContents::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReposCreateOrUpdateFileContentsError::Status201(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposCreateOrUpdateFileContentsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateOrUpdateFileContentsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposCreateOrUpdateFileContentsError::Status409(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateOrUpdateFileContentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update file contents
    ///
    /// Creates a new file or replaces an existing file in a repository.
    /// 
    /// [GitHub API docs for create_or_update_file_contents](https://docs.github.com/rest/reference/repos#create-or-update-file-contents)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_file_contents(&self, owner: &str, repo: &str, path: &str, body: PutReposCreateOrUpdateFileContents) -> Result<FileCommit, ReposCreateOrUpdateFileContentsError> {

        let request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposCreateOrUpdateFileContents::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReposCreateOrUpdateFileContentsError::Status201(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposCreateOrUpdateFileContentsError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateOrUpdateFileContentsError::Status422(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposCreateOrUpdateFileContentsError::Status409(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateOrUpdateFileContentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GitHub Pages site
    ///
    /// Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
    /// 
    /// [GitHub API docs for create_pages_site](https://docs.github.com/rest/reference/repos#create-a-github-pages-site)
    ///
    /// ---
    pub async fn create_pages_site_async(&self, owner: &str, repo: &str, body: PostReposCreatePagesSite) -> Result<Page, ReposCreatePagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreatePagesSite::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreatePagesSiteError::Status422(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposCreatePagesSiteError::Status409(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreatePagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GitHub Pages site
    ///
    /// Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
    /// 
    /// [GitHub API docs for create_pages_site](https://docs.github.com/rest/reference/repos#create-a-github-pages-site)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_pages_site(&self, owner: &str, repo: &str, body: PostReposCreatePagesSite) -> Result<Page, ReposCreatePagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreatePagesSite::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposCreatePagesSiteError::Status422(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposCreatePagesSiteError::Status409(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreatePagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a release
    ///
    /// Users with push access to the repository can create a release.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_release](https://docs.github.com/rest/reference/repos#create-a-release)
    ///
    /// ---
    pub async fn create_release_async(&self, owner: &str, repo: &str, body: PostReposCreateRelease) -> Result<Release, ReposCreateReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateRelease::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateReleaseError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateReleaseError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a release
    ///
    /// Users with push access to the repository can create a release.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_release](https://docs.github.com/rest/reference/repos#create-a-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_release(&self, owner: &str, repo: &str, body: PostReposCreateRelease) -> Result<Release, ReposCreateReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateRelease::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateReleaseError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateReleaseError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository using a template
    ///
    /// Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. The authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/reference/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository
    /// 
    /// [GitHub API docs for create_using_template](https://docs.github.com/rest/reference/repos#create-a-repository-using-a-template)
    ///
    /// ---
    pub async fn create_using_template_async(&self, template_owner: &str, template_repo: &str, body: PostReposCreateUsingTemplate) -> Result<Repository, ReposCreateUsingTemplateError> {

        let request_uri = format!("{}/repos/{}/{}/generate", super::GITHUB_BASE_API_URL, template_owner, template_repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateUsingTemplate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposCreateUsingTemplateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository using a template
    ///
    /// Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. The authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/reference/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
    /// 
    /// *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
    /// *   `repo` scope to create a private repository
    /// 
    /// [GitHub API docs for create_using_template](https://docs.github.com/rest/reference/repos#create-a-repository-using-a-template)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_using_template(&self, template_owner: &str, template_repo: &str, body: PostReposCreateUsingTemplate) -> Result<Repository, ReposCreateUsingTemplateError> {

        let request_uri = format!("{}/repos/{}/{}/generate", super::GITHUB_BASE_API_URL, template_owner, template_repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateUsingTemplate::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposCreateUsingTemplateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository webhook
    ///
    /// Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
    /// share the same `config` as long as those webhooks do not have any `events` that overlap.
    /// 
    /// [GitHub API docs for create_webhook](https://docs.github.com/rest/reference/repos#create-a-repository-webhook)
    ///
    /// ---
    pub async fn create_webhook_async(&self, owner: &str, repo: &str, body: PostReposCreateWebhook) -> Result<Hook, ReposCreateWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateWebhook::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposCreateWebhookError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposCreateWebhookError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposCreateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository webhook
    ///
    /// Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
    /// share the same `config` as long as those webhooks do not have any `events` that overlap.
    /// 
    /// [GitHub API docs for create_webhook](https://docs.github.com/rest/reference/repos#create-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_webhook(&self, owner: &str, repo: &str, body: PostReposCreateWebhook) -> Result<Hook, ReposCreateWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposCreateWebhook::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposCreateWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposCreateWebhookError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposCreateWebhookError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposCreateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Decline a repository invitation
    /// 
    /// [GitHub API docs for decline_invitation_for_authenticated_user](https://docs.github.com/rest/reference/repos#decline-a-repository-invitation)
    ///
    /// ---
    pub async fn decline_invitation_for_authenticated_user_async(&self, invitation_id: i32) -> Result<(), ReposDeclineInvitationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repository_invitations/{}", super::GITHUB_BASE_API_URL, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status409(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status304),
                404 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeclineInvitationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Decline a repository invitation
    /// 
    /// [GitHub API docs for decline_invitation_for_authenticated_user](https://docs.github.com/rest/reference/repos#decline-a-repository-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn decline_invitation_for_authenticated_user(&self, invitation_id: i32) -> Result<(), ReposDeclineInvitationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/repository_invitations/{}", super::GITHUB_BASE_API_URL, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status409(crate::adapters::to_json(github_response)?)),
                304 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status304),
                404 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposDeclineInvitationForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeclineInvitationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository
    ///
    /// Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.
    /// 
    /// If an organization owner has configured the organization to prevent members from deleting organization-owned
    /// repositories, you will get a `403 Forbidden` response.
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/repos#delete-a-repository)
    ///
    /// ---
    pub async fn delete_async(&self, owner: &str, repo: &str) -> Result<(), ReposDeleteError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposDeleteError::Status403(crate::adapters::to_json_async(github_response).await?)),
                307 => Err(ReposDeleteError::Status307(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposDeleteError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository
    ///
    /// Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.
    /// 
    /// If an organization owner has configured the organization to prevent members from deleting organization-owned
    /// repositories, you will get a `403 Forbidden` response.
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/repos#delete-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete(&self, owner: &str, repo: &str) -> Result<(), ReposDeleteError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposDeleteError::Status403(crate::adapters::to_json(github_response)?)),
                307 => Err(ReposDeleteError::Status307(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposDeleteError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Disables the ability to restrict who can push to this branch.
    /// 
    /// [GitHub API docs for delete_access_restrictions](https://docs.github.com/rest/reference/repos#delete-access-restrictions)
    ///
    /// ---
    pub async fn delete_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Disables the ability to restrict who can push to this branch.
    /// 
    /// [GitHub API docs for delete_access_restrictions](https://docs.github.com/rest/reference/repos#delete-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_access_restrictions(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for delete_admin_branch_protection](https://docs.github.com/rest/reference/repos#delete-admin-branch-protection)
    ///
    /// ---
    pub async fn delete_admin_branch_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteAdminBranchProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for delete_admin_branch_protection](https://docs.github.com/rest/reference/repos#delete-admin-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_admin_branch_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteAdminBranchProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an environment
    ///
    /// You must authenticate using an access token with the repo scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_an_environment](https://docs.github.com/rest/reference/repos#delete-an-environment)
    ///
    /// ---
    pub async fn delete_an_environment_async(&self, owner: &str, repo: &str, environment_name: &str) -> Result<(), ReposDeleteAnEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteAnEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an environment
    ///
    /// You must authenticate using an access token with the repo scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_an_environment](https://docs.github.com/rest/reference/repos#delete-an-environment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_an_environment(&self, owner: &str, repo: &str, environment_name: &str) -> Result<(), ReposDeleteAnEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteAnEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an autolink reference from a repository
    ///
    /// This deletes a single autolink reference by ID that was configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for delete_autolink](https://docs.github.com/v3/repos#delete-autolink)
    ///
    /// ---
    pub async fn delete_autolink_async(&self, owner: &str, repo: &str, autolink_id: i32) -> Result<(), ReposDeleteAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks/{}", super::GITHUB_BASE_API_URL, owner, repo, autolink_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteAutolinkError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an autolink reference from a repository
    ///
    /// This deletes a single autolink reference by ID that was configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for delete_autolink](https://docs.github.com/v3/repos#delete-autolink)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_autolink(&self, owner: &str, repo: &str, autolink_id: i32) -> Result<(), ReposDeleteAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks/{}", super::GITHUB_BASE_API_URL, owner, repo, autolink_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteAutolinkError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for delete_branch_protection](https://docs.github.com/rest/reference/repos#delete-branch-protection)
    ///
    /// ---
    pub async fn delete_branch_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposDeleteBranchProtectionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for delete_branch_protection](https://docs.github.com/rest/reference/repos#delete-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_branch_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposDeleteBranchProtectionError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a commit comment
    /// 
    /// [GitHub API docs for delete_commit_comment](https://docs.github.com/rest/reference/repos#delete-a-commit-comment)
    ///
    /// ---
    pub async fn delete_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), ReposDeleteCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteCommitCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a commit comment
    /// 
    /// [GitHub API docs for delete_commit_comment](https://docs.github.com/rest/reference/repos#delete-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_commit_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<(), ReposDeleteCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteCommitCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for delete_commit_signature_protection](https://docs.github.com/rest/reference/repos#delete-commit-signature-protection)
    ///
    /// ---
    pub async fn delete_commit_signature_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteCommitSignatureProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for delete_commit_signature_protection](https://docs.github.com/rest/reference/repos#delete-commit-signature-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_commit_signature_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeleteCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteCommitSignatureProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a deploy key
    ///
    /// Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
    /// 
    /// [GitHub API docs for delete_deploy_key](https://docs.github.com/rest/reference/repos#delete-a-deploy-key)
    ///
    /// ---
    pub async fn delete_deploy_key_async(&self, owner: &str, repo: &str, key_id: i32) -> Result<(), ReposDeleteDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys/{}", super::GITHUB_BASE_API_URL, owner, repo, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a deploy key
    ///
    /// Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
    /// 
    /// [GitHub API docs for delete_deploy_key](https://docs.github.com/rest/reference/repos#delete-a-deploy-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_deploy_key(&self, owner: &str, repo: &str, key_id: i32) -> Result<(), ReposDeleteDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys/{}", super::GITHUB_BASE_API_URL, owner, repo, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a deployment
    ///
    /// To ensure there can always be an active deployment, you can only delete an _inactive_ deployment. Anyone with `repo` or `repo_deployment` scopes can delete an inactive deployment.
    /// 
    /// To set a deployment as inactive, you must:
    /// 
    /// *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
    /// *   Mark the active deployment as inactive by adding any non-successful deployment status.
    /// 
    /// For more information, see "[Create a deployment](https://docs.github.com/rest/reference/repos/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)."
    /// 
    /// [GitHub API docs for delete_deployment](https://docs.github.com/rest/reference/repos#delete-a-deployment)
    ///
    /// ---
    pub async fn delete_deployment_async(&self, owner: &str, repo: &str, deployment_id: i32) -> Result<(), ReposDeleteDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteDeploymentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposDeleteDeploymentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a deployment
    ///
    /// To ensure there can always be an active deployment, you can only delete an _inactive_ deployment. Anyone with `repo` or `repo_deployment` scopes can delete an inactive deployment.
    /// 
    /// To set a deployment as inactive, you must:
    /// 
    /// *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
    /// *   Mark the active deployment as inactive by adding any non-successful deployment status.
    /// 
    /// For more information, see "[Create a deployment](https://docs.github.com/rest/reference/repos/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)."
    /// 
    /// [GitHub API docs for delete_deployment](https://docs.github.com/rest/reference/repos#delete-a-deployment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_deployment(&self, owner: &str, repo: &str, deployment_id: i32) -> Result<(), ReposDeleteDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteDeploymentError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposDeleteDeploymentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a file
    ///
    /// Deletes a file in a repository.
    /// 
    /// You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
    /// 
    /// The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
    /// 
    /// You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
    /// 
    /// [GitHub API docs for delete_file](https://docs.github.com/rest/reference/repos#delete-a-file)
    ///
    /// ---
    pub async fn delete_file_async(&self, owner: &str, repo: &str, path: &str, body: DeleteReposDeleteFile) -> Result<FileCommit, ReposDeleteFileError> {

        let request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposDeleteFile::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposDeleteFileError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposDeleteFileError::Status404(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposDeleteFileError::Status409(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(ReposDeleteFileError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteFileError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a file
    ///
    /// Deletes a file in a repository.
    /// 
    /// You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
    /// 
    /// The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
    /// 
    /// You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
    /// 
    /// [GitHub API docs for delete_file](https://docs.github.com/rest/reference/repos#delete-a-file)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_file(&self, owner: &str, repo: &str, path: &str, body: DeleteReposDeleteFile) -> Result<FileCommit, ReposDeleteFileError> {

        let request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposDeleteFile::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposDeleteFileError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposDeleteFileError::Status404(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposDeleteFileError::Status409(crate::adapters::to_json(github_response)?)),
                503 => Err(ReposDeleteFileError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteFileError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository invitation
    /// 
    /// [GitHub API docs for delete_invitation](https://docs.github.com/rest/reference/repos#delete-a-repository-invitation)
    ///
    /// ---
    pub async fn delete_invitation_async(&self, owner: &str, repo: &str, invitation_id: i32) -> Result<(), ReposDeleteInvitationError> {

        let request_uri = format!("{}/repos/{}/{}/invitations/{}", super::GITHUB_BASE_API_URL, owner, repo, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository invitation
    /// 
    /// [GitHub API docs for delete_invitation](https://docs.github.com/rest/reference/repos#delete-a-repository-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_invitation(&self, owner: &str, repo: &str, invitation_id: i32) -> Result<(), ReposDeleteInvitationError> {

        let request_uri = format!("{}/repos/{}/{}/invitations/{}", super::GITHUB_BASE_API_URL, owner, repo, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a GitHub Pages site
    /// 
    /// [GitHub API docs for delete_pages_site](https://docs.github.com/rest/reference/repos#delete-a-github-pages-site)
    ///
    /// ---
    pub async fn delete_pages_site_async(&self, owner: &str, repo: &str) -> Result<(), ReposDeletePagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposDeletePagesSiteError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposDeletePagesSiteError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeletePagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a GitHub Pages site
    /// 
    /// [GitHub API docs for delete_pages_site](https://docs.github.com/rest/reference/repos#delete-a-github-pages-site)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_pages_site(&self, owner: &str, repo: &str) -> Result<(), ReposDeletePagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposDeletePagesSiteError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposDeletePagesSiteError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeletePagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for delete_pull_request_review_protection](https://docs.github.com/rest/reference/repos#delete-pull-request-review-protection)
    ///
    /// ---
    pub async fn delete_pull_request_review_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeletePullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeletePullRequestReviewProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeletePullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for delete_pull_request_review_protection](https://docs.github.com/rest/reference/repos#delete-pull-request-review-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_pull_request_review_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposDeletePullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeletePullRequestReviewProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeletePullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a release
    ///
    /// Users with push access to the repository can delete a release.
    /// 
    /// [GitHub API docs for delete_release](https://docs.github.com/rest/reference/repos#delete-a-release)
    ///
    /// ---
    pub async fn delete_release_async(&self, owner: &str, repo: &str, release_id: i32) -> Result<(), ReposDeleteReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a release
    ///
    /// Users with push access to the repository can delete a release.
    /// 
    /// [GitHub API docs for delete_release](https://docs.github.com/rest/reference/repos#delete-a-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_release(&self, owner: &str, repo: &str, release_id: i32) -> Result<(), ReposDeleteReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a release asset
    /// 
    /// [GitHub API docs for delete_release_asset](https://docs.github.com/rest/reference/repos#delete-a-release-asset)
    ///
    /// ---
    pub async fn delete_release_asset_async(&self, owner: &str, repo: &str, asset_id: i32) -> Result<(), ReposDeleteReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a release asset
    /// 
    /// [GitHub API docs for delete_release_asset](https://docs.github.com/rest/reference/repos#delete-a-release-asset)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_release_asset(&self, owner: &str, repo: &str, asset_id: i32) -> Result<(), ReposDeleteReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDeleteReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository webhook
    /// 
    /// [GitHub API docs for delete_webhook](https://docs.github.com/rest/reference/repos#delete-a-repository-webhook)
    ///
    /// ---
    pub async fn delete_webhook_async(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposDeleteWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposDeleteWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository webhook
    /// 
    /// [GitHub API docs for delete_webhook](https://docs.github.com/rest/reference/repos#delete-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_webhook(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposDeleteWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposDeleteWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposDeleteWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable automated security fixes
    ///
    /// Disables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
    /// 
    /// [GitHub API docs for disable_automated_security_fixes](https://docs.github.com/rest/reference/repos#disable-automated-security-fixes)
    ///
    /// ---
    pub async fn disable_automated_security_fixes_async(&self, owner: &str, repo: &str) -> Result<(), ReposDisableAutomatedSecurityFixesError> {

        let request_uri = format!("{}/repos/{}/{}/automated-security-fixes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableAutomatedSecurityFixesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable automated security fixes
    ///
    /// Disables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
    /// 
    /// [GitHub API docs for disable_automated_security_fixes](https://docs.github.com/rest/reference/repos#disable-automated-security-fixes)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_automated_security_fixes(&self, owner: &str, repo: &str) -> Result<(), ReposDisableAutomatedSecurityFixesError> {

        let request_uri = format!("{}/repos/{}/{}/automated-security-fixes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableAutomatedSecurityFixesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable Git LFS for a repository
    /// 
    /// [GitHub API docs for disable_lfs_for_repo](https://docs.github.com/rest/reference/repos#disable-git-lfs-for-a-repository)
    ///
    /// ---
    pub async fn disable_lfs_for_repo_async(&self, owner: &str, repo: &str) -> Result<(), ReposDisableLfsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableLfsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable Git LFS for a repository
    /// 
    /// [GitHub API docs for disable_lfs_for_repo](https://docs.github.com/rest/reference/repos#disable-git-lfs-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_lfs_for_repo(&self, owner: &str, repo: &str) -> Result<(), ReposDisableLfsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableLfsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable vulnerability alerts
    ///
    /// Disables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for disable_vulnerability_alerts](https://docs.github.com/rest/reference/repos#disable-vulnerability-alerts)
    ///
    /// ---
    pub async fn disable_vulnerability_alerts_async(&self, owner: &str, repo: &str) -> Result<(), ReposDisableVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable vulnerability alerts
    ///
    /// Disables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for disable_vulnerability_alerts](https://docs.github.com/rest/reference/repos#disable-vulnerability-alerts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_vulnerability_alerts(&self, owner: &str, repo: &str) -> Result<(), ReposDisableVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposDisableVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a repository archive (tar)
    ///
    /// Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    /// **Note**: For private repositories, these links are temporary and expire after five minutes.
    /// 
    /// [GitHub API docs for download_tarball_archive](https://docs.github.com/rest/reference/repos#download-a-repository-archive)
    ///
    /// ---
    pub async fn download_tarball_archive_async(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), ReposDownloadTarballArchiveError> {

        let request_uri = format!("{}/repos/{}/{}/tarball/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ReposDownloadTarballArchiveError::Status302),
                code => Err(ReposDownloadTarballArchiveError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a repository archive (tar)
    ///
    /// Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    /// **Note**: For private repositories, these links are temporary and expire after five minutes.
    /// 
    /// [GitHub API docs for download_tarball_archive](https://docs.github.com/rest/reference/repos#download-a-repository-archive)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_tarball_archive(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), ReposDownloadTarballArchiveError> {

        let request_uri = format!("{}/repos/{}/{}/tarball/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ReposDownloadTarballArchiveError::Status302),
                code => Err(ReposDownloadTarballArchiveError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a repository archive (zip)
    ///
    /// Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    /// **Note**: For private repositories, these links are temporary and expire after five minutes.
    /// 
    /// [GitHub API docs for download_zipball_archive](https://docs.github.com/rest/reference/repos#download-a-repository-archive)
    ///
    /// ---
    pub async fn download_zipball_archive_async(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), ReposDownloadZipballArchiveError> {

        let request_uri = format!("{}/repos/{}/{}/zipball/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ReposDownloadZipballArchiveError::Status302),
                code => Err(ReposDownloadZipballArchiveError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download a repository archive (zip)
    ///
    /// Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    /// **Note**: For private repositories, these links are temporary and expire after five minutes.
    /// 
    /// [GitHub API docs for download_zipball_archive](https://docs.github.com/rest/reference/repos#download-a-repository-archive)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_zipball_archive(&self, owner: &str, repo: &str, git_ref: &str) -> Result<(), ReposDownloadZipballArchiveError> {

        let request_uri = format!("{}/repos/{}/{}/zipball/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ReposDownloadZipballArchiveError::Status302),
                code => Err(ReposDownloadZipballArchiveError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable automated security fixes
    ///
    /// Enables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
    /// 
    /// [GitHub API docs for enable_automated_security_fixes](https://docs.github.com/rest/reference/repos#enable-automated-security-fixes)
    ///
    /// ---
    pub async fn enable_automated_security_fixes_async(&self, owner: &str, repo: &str) -> Result<(), ReposEnableAutomatedSecurityFixesError> {

        let request_uri = format!("{}/repos/{}/{}/automated-security-fixes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposEnableAutomatedSecurityFixesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable automated security fixes
    ///
    /// Enables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
    /// 
    /// [GitHub API docs for enable_automated_security_fixes](https://docs.github.com/rest/reference/repos#enable-automated-security-fixes)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_automated_security_fixes(&self, owner: &str, repo: &str) -> Result<(), ReposEnableAutomatedSecurityFixesError> {

        let request_uri = format!("{}/repos/{}/{}/automated-security-fixes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposEnableAutomatedSecurityFixesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable Git LFS for a repository
    /// 
    /// [GitHub API docs for enable_lfs_for_repo](https://docs.github.com/rest/reference/repos#enable-git-lfs-for-a-repository)
    ///
    /// ---
    pub async fn enable_lfs_for_repo_async(&self, owner: &str, repo: &str) -> Result<HashMap<String, Value>, ReposEnableLfsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposEnableLfsForRepoError::Status403),
                code => Err(ReposEnableLfsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable Git LFS for a repository
    /// 
    /// [GitHub API docs for enable_lfs_for_repo](https://docs.github.com/rest/reference/repos#enable-git-lfs-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_lfs_for_repo(&self, owner: &str, repo: &str) -> Result<HashMap<String, Value>, ReposEnableLfsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/lfs", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposEnableLfsForRepoError::Status403),
                code => Err(ReposEnableLfsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable vulnerability alerts
    ///
    /// Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for enable_vulnerability_alerts](https://docs.github.com/rest/reference/repos#enable-vulnerability-alerts)
    ///
    /// ---
    pub async fn enable_vulnerability_alerts_async(&self, owner: &str, repo: &str) -> Result<(), ReposEnableVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposEnableVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable vulnerability alerts
    ///
    /// Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
    /// 
    /// [GitHub API docs for enable_vulnerability_alerts](https://docs.github.com/rest/reference/repos#enable-vulnerability-alerts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_vulnerability_alerts(&self, owner: &str, repo: &str) -> Result<(), ReposEnableVulnerabilityAlertsError> {

        let request_uri = format!("{}/repos/{}/{}/vulnerability-alerts", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposEnableVulnerabilityAlertsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Generate release notes content for a release
    ///
    /// Generate a name and body describing a [release](https://docs.github.com/rest/reference/repos#releases). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.
    /// 
    /// [GitHub API docs for generate_release_notes](https://docs.github.com/rest/reference/repos#generate-release-notes)
    ///
    /// ---
    pub async fn generate_release_notes_async(&self, owner: &str, repo: &str, body: PostReposGenerateReleaseNotes) -> Result<ReleaseNotesContent, ReposGenerateReleaseNotesError> {

        let request_uri = format!("{}/repos/{}/{}/releases/generate-notes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposGenerateReleaseNotes::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGenerateReleaseNotesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGenerateReleaseNotesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Generate release notes content for a release
    ///
    /// Generate a name and body describing a [release](https://docs.github.com/rest/reference/repos#releases). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.
    /// 
    /// [GitHub API docs for generate_release_notes](https://docs.github.com/rest/reference/repos#generate-release-notes)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn generate_release_notes(&self, owner: &str, repo: &str, body: PostReposGenerateReleaseNotes) -> Result<ReleaseNotesContent, ReposGenerateReleaseNotesError> {

        let request_uri = format!("{}/repos/{}/{}/releases/generate-notes", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposGenerateReleaseNotes::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGenerateReleaseNotesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGenerateReleaseNotesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository
    ///
    /// The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/repos#get-a-repository)
    ///
    /// ---
    pub async fn get_async(&self, owner: &str, repo: &str) -> Result<FullRepository, ReposGetError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposGetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                301 => Err(ReposGetError::Status301(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository
    ///
    /// The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/repos#get-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, owner: &str, repo: &str) -> Result<FullRepository, ReposGetError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposGetError::Status404(crate::adapters::to_json(github_response)?)),
                301 => Err(ReposGetError::Status301(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists who has access to this protected branch.
    /// 
    /// **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
    /// 
    /// [GitHub API docs for get_access_restrictions](https://docs.github.com/rest/reference/repos#get-access-restrictions)
    ///
    /// ---
    pub async fn get_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchRestrictionPolicy, ReposGetAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAccessRestrictionsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists who has access to this protected branch.
    /// 
    /// **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
    /// 
    /// [GitHub API docs for get_access_restrictions](https://docs.github.com/rest/reference/repos#get-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_access_restrictions(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchRestrictionPolicy, ReposGetAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAccessRestrictionsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_admin_branch_protection](https://docs.github.com/rest/reference/repos#get-admin-branch-protection)
    ///
    /// ---
    pub async fn get_admin_branch_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposGetAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_admin_branch_protection](https://docs.github.com/rest/reference/repos#get-admin-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_admin_branch_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposGetAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all environments
    ///
    /// Get all environments for a repository.
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_all_environments](https://docs.github.com/rest/reference/repos#get-all-environments)
    ///
    /// ---
    pub async fn get_all_environments_async(&self, owner: &str, repo: &str) -> Result<GetReposGetAllEnvironmentsResponse200, ReposGetAllEnvironmentsError> {

        let request_uri = format!("{}/repos/{}/{}/environments", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetAllEnvironmentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all environments
    ///
    /// Get all environments for a repository.
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_all_environments](https://docs.github.com/rest/reference/repos#get-all-environments)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_environments(&self, owner: &str, repo: &str) -> Result<GetReposGetAllEnvironmentsResponse200, ReposGetAllEnvironmentsError> {

        let request_uri = format!("{}/repos/{}/{}/environments", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetAllEnvironmentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_all_status_check_contexts](https://docs.github.com/rest/reference/repos#get-all-status-check-contexts)
    ///
    /// ---
    pub async fn get_all_status_check_contexts_async(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<String>, ReposGetAllStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAllStatusCheckContextsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetAllStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_all_status_check_contexts](https://docs.github.com/rest/reference/repos#get-all-status-check-contexts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_status_check_contexts(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<String>, ReposGetAllStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAllStatusCheckContextsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetAllStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all repository topics
    /// 
    /// [GitHub API docs for get_all_topics](https://docs.github.com/rest/reference/repos#get-all-repository-topics)
    ///
    /// ---
    pub async fn get_all_topics_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetAllTopicsParams>>) -> Result<Topic, ReposGetAllTopicsError> {

        let mut request_uri = format!("{}/repos/{}/{}/topics", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAllTopicsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetAllTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all repository topics
    /// 
    /// [GitHub API docs for get_all_topics](https://docs.github.com/rest/reference/repos#get-all-repository-topics)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_topics(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetAllTopicsParams>>) -> Result<Topic, ReposGetAllTopicsError> {

        let mut request_uri = format!("{}/repos/{}/{}/topics", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetAllTopicsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAllTopicsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetAllTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get apps with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the GitHub Apps that have push access to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// [GitHub API docs for get_apps_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-apps-with-access-to-the-protected-branch)
    ///
    /// ---
    pub async fn get_apps_with_access_to_protected_branch_async(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<Integration>, ReposGetAppsWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAppsWithAccessToProtectedBranchError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetAppsWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get apps with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the GitHub Apps that have push access to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// [GitHub API docs for get_apps_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-apps-with-access-to-the-protected-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_apps_with_access_to_protected_branch(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<Integration>, ReposGetAppsWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAppsWithAccessToProtectedBranchError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetAppsWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an autolink reference of a repository
    ///
    /// This returns a single autolink reference by ID that was configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for get_autolink](https://docs.github.com/v3/repos#get-autolink)
    ///
    /// ---
    pub async fn get_autolink_async(&self, owner: &str, repo: &str, autolink_id: i32) -> Result<Autolink, ReposGetAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks/{}", super::GITHUB_BASE_API_URL, owner, repo, autolink_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAutolinkError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an autolink reference of a repository
    ///
    /// This returns a single autolink reference by ID that was configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for get_autolink](https://docs.github.com/v3/repos#get-autolink)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_autolink(&self, owner: &str, repo: &str, autolink_id: i32) -> Result<Autolink, ReposGetAutolinkError> {

        let request_uri = format!("{}/repos/{}/{}/autolinks/{}", super::GITHUB_BASE_API_URL, owner, repo, autolink_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetAutolinkError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetAutolinkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a branch
    /// 
    /// [GitHub API docs for get_branch](https://docs.github.com/rest/reference/repos#get-a-branch)
    ///
    /// ---
    pub async fn get_branch_async(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchWithProtection, ReposGetBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                301 => Err(ReposGetBranchError::Status301(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(ReposGetBranchError::Status415(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposGetBranchError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a branch
    /// 
    /// [GitHub API docs for get_branch](https://docs.github.com/rest/reference/repos#get-a-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_branch(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchWithProtection, ReposGetBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                301 => Err(ReposGetBranchError::Status301(crate::adapters::to_json(github_response)?)),
                415 => Err(ReposGetBranchError::Status415(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposGetBranchError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_branch_protection](https://docs.github.com/rest/reference/repos#get-branch-protection)
    ///
    /// ---
    pub async fn get_branch_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchProtection, ReposGetBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetBranchProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_branch_protection](https://docs.github.com/rest/reference/repos#get-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_branch_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<BranchProtection, ReposGetBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetBranchProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository clones
    ///
    /// Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    /// 
    /// [GitHub API docs for get_clones](https://docs.github.com/rest/reference/repos#get-repository-clones)
    ///
    /// ---
    pub async fn get_clones_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetClonesParams<'api>>>) -> Result<CloneTraffic, ReposGetClonesError> {

        let mut request_uri = format!("{}/repos/{}/{}/traffic/clones", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetClonesError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetClonesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository clones
    ///
    /// Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    /// 
    /// [GitHub API docs for get_clones](https://docs.github.com/rest/reference/repos#get-repository-clones)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_clones(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetClonesParams<'api>>>) -> Result<CloneTraffic, ReposGetClonesError> {

        let mut request_uri = format!("{}/repos/{}/{}/traffic/clones", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetClonesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetClonesError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetClonesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the weekly commit activity
    ///
    /// Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
    /// 
    /// [GitHub API docs for get_code_frequency_stats](https://docs.github.com/rest/reference/repos#get-the-weekly-commit-activity)
    ///
    /// ---
    pub async fn get_code_frequency_stats_async(&self, owner: &str, repo: &str) -> Result<Vec<CodeFrequencyStat>, ReposGetCodeFrequencyStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/code_frequency", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetCodeFrequencyStatsError::Status202(crate::adapters::to_json_async(github_response).await?)),
                204 => Err(ReposGetCodeFrequencyStatsError::Status204),
                code => Err(ReposGetCodeFrequencyStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the weekly commit activity
    ///
    /// Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
    /// 
    /// [GitHub API docs for get_code_frequency_stats](https://docs.github.com/rest/reference/repos#get-the-weekly-commit-activity)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_code_frequency_stats(&self, owner: &str, repo: &str) -> Result<Vec<CodeFrequencyStat>, ReposGetCodeFrequencyStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/code_frequency", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetCodeFrequencyStatsError::Status202(crate::adapters::to_json(github_response)?)),
                204 => Err(ReposGetCodeFrequencyStatsError::Status204),
                code => Err(ReposGetCodeFrequencyStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository permissions for a user
    ///
    /// Checks the repository permission of a collaborator. The possible repository permissions are `admin`, `write`, `read`, and `none`.
    /// 
    /// [GitHub API docs for get_collaborator_permission_level](https://docs.github.com/rest/reference/repos#get-repository-permissions-for-a-user)
    ///
    /// ---
    pub async fn get_collaborator_permission_level_async(&self, owner: &str, repo: &str, username: &str) -> Result<RepositoryCollaboratorPermission, ReposGetCollaboratorPermissionLevelError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}/permission", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCollaboratorPermissionLevelError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetCollaboratorPermissionLevelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository permissions for a user
    ///
    /// Checks the repository permission of a collaborator. The possible repository permissions are `admin`, `write`, `read`, and `none`.
    /// 
    /// [GitHub API docs for get_collaborator_permission_level](https://docs.github.com/rest/reference/repos#get-repository-permissions-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_collaborator_permission_level(&self, owner: &str, repo: &str, username: &str) -> Result<RepositoryCollaboratorPermission, ReposGetCollaboratorPermissionLevelError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}/permission", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCollaboratorPermissionLevelError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetCollaboratorPermissionLevelError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the combined status for a specific reference
    ///
    /// Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
    /// 
    /// 
    /// Additionally, a combined `state` is returned. The `state` is one of:
    /// 
    /// *   **failure** if any of the contexts report as `error` or `failure`
    /// *   **pending** if there are no statuses or a context is `pending`
    /// *   **success** if the latest status for all contexts is `success`
    /// 
    /// [GitHub API docs for get_combined_status_for_ref](https://docs.github.com/rest/reference/repos#get-the-combined-status-for-a-specific-reference)
    ///
    /// ---
    pub async fn get_combined_status_for_ref_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposGetCombinedStatusForRefParams>>) -> Result<CombinedCommitStatus, ReposGetCombinedStatusForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/status", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCombinedStatusForRefError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetCombinedStatusForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the combined status for a specific reference
    ///
    /// Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
    /// 
    /// 
    /// Additionally, a combined `state` is returned. The `state` is one of:
    /// 
    /// *   **failure** if any of the contexts report as `error` or `failure`
    /// *   **pending** if there are no statuses or a context is `pending`
    /// *   **success** if the latest status for all contexts is `success`
    /// 
    /// [GitHub API docs for get_combined_status_for_ref](https://docs.github.com/rest/reference/repos#get-the-combined-status-for-a-specific-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_combined_status_for_ref(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposGetCombinedStatusForRefParams>>) -> Result<CombinedCommitStatus, ReposGetCombinedStatusForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/status", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetCombinedStatusForRefParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCombinedStatusForRefError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetCombinedStatusForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit
    ///
    /// Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
    /// 
    /// **Note:** If there are more than 300 files in the commit diff, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
    /// 
    /// You can pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to  fetch `diff` and `patch` formats. Diffs with binary data will have no `patch` property.
    /// 
    /// To return only the SHA-1 hash of the commit reference, you can provide the `sha` custom [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) in the `Accept` header. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_commit](https://docs.github.com/rest/reference/repos#get-a-commit)
    ///
    /// ---
    pub async fn get_commit_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposGetCommitParams>>) -> Result<Commit, ReposGetCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposGetCommitError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposGetCommitError::Status404(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(ReposGetCommitError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit
    ///
    /// Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
    /// 
    /// **Note:** If there are more than 300 files in the commit diff, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
    /// 
    /// You can pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to  fetch `diff` and `patch` formats. Diffs with binary data will have no `patch` property.
    /// 
    /// To return only the SHA-1 hash of the commit reference, you can provide the `sha` custom [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) in the `Accept` header. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
    /// 
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for get_commit](https://docs.github.com/rest/reference/repos#get-a-commit)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposGetCommitParams>>) -> Result<Commit, ReposGetCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetCommitParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposGetCommitError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposGetCommitError::Status404(crate::adapters::to_json(github_response)?)),
                500 => Err(ReposGetCommitError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the last year of commit activity
    ///
    /// Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
    /// 
    /// [GitHub API docs for get_commit_activity_stats](https://docs.github.com/rest/reference/repos#get-the-last-year-of-commit-activity)
    ///
    /// ---
    pub async fn get_commit_activity_stats_async(&self, owner: &str, repo: &str) -> Result<Vec<CommitActivity>, ReposGetCommitActivityStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/commit_activity", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetCommitActivityStatsError::Status202(crate::adapters::to_json_async(github_response).await?)),
                204 => Err(ReposGetCommitActivityStatsError::Status204),
                code => Err(ReposGetCommitActivityStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the last year of commit activity
    ///
    /// Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
    /// 
    /// [GitHub API docs for get_commit_activity_stats](https://docs.github.com/rest/reference/repos#get-the-last-year-of-commit-activity)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit_activity_stats(&self, owner: &str, repo: &str) -> Result<Vec<CommitActivity>, ReposGetCommitActivityStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/commit_activity", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetCommitActivityStatsError::Status202(crate::adapters::to_json(github_response)?)),
                204 => Err(ReposGetCommitActivityStatsError::Status204),
                code => Err(ReposGetCommitActivityStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit comment
    /// 
    /// [GitHub API docs for get_commit_comment](https://docs.github.com/rest/reference/repos#get-a-commit-comment)
    ///
    /// ---
    pub async fn get_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32) -> Result<CommitComment, ReposGetCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCommitCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a commit comment
    /// 
    /// [GitHub API docs for get_commit_comment](https://docs.github.com/rest/reference/repos#get-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit_comment(&self, owner: &str, repo: &str, comment_id: i32) -> Result<CommitComment, ReposGetCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCommitCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://help.github.com/articles/signing-commits-with-gpg) in GitHub Help.
    /// 
    /// **Note**: You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for get_commit_signature_protection](https://docs.github.com/rest/reference/repos#get-commit-signature-protection)
    ///
    /// ---
    pub async fn get_commit_signature_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposGetCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCommitSignatureProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://help.github.com/articles/signing-commits-with-gpg) in GitHub Help.
    /// 
    /// **Note**: You must enable branch protection to require signed commits.
    /// 
    /// [GitHub API docs for get_commit_signature_protection](https://docs.github.com/rest/reference/repos#get-commit-signature-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_commit_signature_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposGetCommitSignatureProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_signatures", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetCommitSignatureProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetCommitSignatureProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get community profile metrics
    ///
    /// This endpoint will return all community profile metrics, including an
    /// overall health score, repository description, the presence of documentation, detected
    /// code of conduct, detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
    /// README, and CONTRIBUTING files.
    /// 
    /// The `health_percentage` score is defined as a percentage of how many of
    /// these four documents are present: README, CONTRIBUTING, LICENSE, and
    /// CODE_OF_CONDUCT. For example, if all four documents are present, then
    /// the `health_percentage` is `100`. If only one is present, then the
    /// `health_percentage` is `25`.
    /// 
    /// `content_reports_enabled` is only returned for organization-owned repositories.
    /// 
    /// [GitHub API docs for get_community_profile_metrics](https://docs.github.com/rest/reference/repos#get-community-profile-metrics)
    ///
    /// ---
    pub async fn get_community_profile_metrics_async(&self, owner: &str, repo: &str) -> Result<CommunityProfile, ReposGetCommunityProfileMetricsError> {

        let request_uri = format!("{}/repos/{}/{}/community/profile", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetCommunityProfileMetricsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get community profile metrics
    ///
    /// This endpoint will return all community profile metrics, including an
    /// overall health score, repository description, the presence of documentation, detected
    /// code of conduct, detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
    /// README, and CONTRIBUTING files.
    /// 
    /// The `health_percentage` score is defined as a percentage of how many of
    /// these four documents are present: README, CONTRIBUTING, LICENSE, and
    /// CODE_OF_CONDUCT. For example, if all four documents are present, then
    /// the `health_percentage` is `100`. If only one is present, then the
    /// `health_percentage` is `25`.
    /// 
    /// `content_reports_enabled` is only returned for organization-owned repositories.
    /// 
    /// [GitHub API docs for get_community_profile_metrics](https://docs.github.com/rest/reference/repos#get-community-profile-metrics)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_community_profile_metrics(&self, owner: &str, repo: &str) -> Result<CommunityProfile, ReposGetCommunityProfileMetricsError> {

        let request_uri = format!("{}/repos/{}/{}/community/profile", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetCommunityProfileMetricsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository content
    ///
    /// Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit
    /// `:path`, you will receive the contents of the repository's root directory. See the description below regarding what the API response includes for directories. 
    /// 
    /// Files and symlinks support [a custom media type](https://docs.github.com/rest/reference/repos#custom-media-types) for
    /// retrieving the raw content or rendered HTML (when supported). All content types support [a custom media
    /// type](https://docs.github.com/rest/reference/repos#custom-media-types) to ensure the content is returned in a consistent
    /// object format.
    /// 
    /// **Note**:
    /// *   To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/reference/git#trees).
    /// *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees
    /// API](https://docs.github.com/rest/reference/git#get-a-tree).
    /// *   This API supports files up to 1 megabyte in size.
    /// 
    /// #### If the content is a directory
    /// The response will be an array of objects, one object for each item in the directory.
    /// When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value
    /// _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW).
    /// In the next major version of the API, the type will be returned as "submodule".
    /// 
    /// #### If the content is a symlink 
    /// If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the
    /// API responds with the content of the file (in the format shown in the example. Otherwise, the API responds with an object 
    /// describing the symlink itself.
    /// 
    /// #### If the content is a submodule
    /// The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific
    /// commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out
    /// the submodule at that specific commit.
    /// 
    /// If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the
    /// github.com URLs (`html_url` and `_links["html"]`) will have null values.
    /// 
    /// [GitHub API docs for get_content](https://docs.github.com/rest/reference/repos#get-repository-content)
    ///
    /// ---
    pub async fn get_content_async(&self, owner: &str, repo: &str, path: &str, query_params: Option<impl Into<ReposGetContentParams<'api>>>) -> Result<ContentTree, ReposGetContentError> {

        let mut request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetContentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposGetContentError::Status403(crate::adapters::to_json_async(github_response).await?)),
                302 => Err(ReposGetContentError::Status302),
                code => Err(ReposGetContentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get repository content
    ///
    /// Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit
    /// `:path`, you will receive the contents of the repository's root directory. See the description below regarding what the API response includes for directories. 
    /// 
    /// Files and symlinks support [a custom media type](https://docs.github.com/rest/reference/repos#custom-media-types) for
    /// retrieving the raw content or rendered HTML (when supported). All content types support [a custom media
    /// type](https://docs.github.com/rest/reference/repos#custom-media-types) to ensure the content is returned in a consistent
    /// object format.
    /// 
    /// **Note**:
    /// *   To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/reference/git#trees).
    /// *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees
    /// API](https://docs.github.com/rest/reference/git#get-a-tree).
    /// *   This API supports files up to 1 megabyte in size.
    /// 
    /// #### If the content is a directory
    /// The response will be an array of objects, one object for each item in the directory.
    /// When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value
    /// _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW).
    /// In the next major version of the API, the type will be returned as "submodule".
    /// 
    /// #### If the content is a symlink 
    /// If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the
    /// API responds with the content of the file (in the format shown in the example. Otherwise, the API responds with an object 
    /// describing the symlink itself.
    /// 
    /// #### If the content is a submodule
    /// The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific
    /// commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out
    /// the submodule at that specific commit.
    /// 
    /// If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the
    /// github.com URLs (`html_url` and `_links["html"]`) will have null values.
    /// 
    /// [GitHub API docs for get_content](https://docs.github.com/rest/reference/repos#get-repository-content)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_content(&self, owner: &str, repo: &str, path: &str, query_params: Option<impl Into<ReposGetContentParams<'api>>>) -> Result<ContentTree, ReposGetContentError> {

        let mut request_uri = format!("{}/repos/{}/{}/contents/{}", super::GITHUB_BASE_API_URL, owner, repo, path);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetContentParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetContentError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposGetContentError::Status403(crate::adapters::to_json(github_response)?)),
                302 => Err(ReposGetContentError::Status302),
                code => Err(ReposGetContentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all contributor commit activity
    ///
    /// 
    /// Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
    /// 
    /// *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
    /// *   `a` - Number of additions
    /// *   `d` - Number of deletions
    /// *   `c` - Number of commits
    /// 
    /// [GitHub API docs for get_contributors_stats](https://docs.github.com/rest/reference/repos#get-all-contributor-commit-activity)
    ///
    /// ---
    pub async fn get_contributors_stats_async(&self, owner: &str, repo: &str) -> Result<Vec<ContributorActivity>, ReposGetContributorsStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/contributors", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetContributorsStatsError::Status202(crate::adapters::to_json_async(github_response).await?)),
                204 => Err(ReposGetContributorsStatsError::Status204),
                code => Err(ReposGetContributorsStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all contributor commit activity
    ///
    /// 
    /// Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
    /// 
    /// *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
    /// *   `a` - Number of additions
    /// *   `d` - Number of deletions
    /// *   `c` - Number of commits
    /// 
    /// [GitHub API docs for get_contributors_stats](https://docs.github.com/rest/reference/repos#get-all-contributor-commit-activity)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_contributors_stats(&self, owner: &str, repo: &str) -> Result<Vec<ContributorActivity>, ReposGetContributorsStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/contributors", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetContributorsStatsError::Status202(crate::adapters::to_json(github_response)?)),
                204 => Err(ReposGetContributorsStatsError::Status204),
                code => Err(ReposGetContributorsStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deploy key
    /// 
    /// [GitHub API docs for get_deploy_key](https://docs.github.com/rest/reference/repos#get-a-deploy-key)
    ///
    /// ---
    pub async fn get_deploy_key_async(&self, owner: &str, repo: &str, key_id: i32) -> Result<DeployKey, ReposGetDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys/{}", super::GITHUB_BASE_API_URL, owner, repo, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeployKeyError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deploy key
    /// 
    /// [GitHub API docs for get_deploy_key](https://docs.github.com/rest/reference/repos#get-a-deploy-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_deploy_key(&self, owner: &str, repo: &str, key_id: i32) -> Result<DeployKey, ReposGetDeployKeyError> {

        let request_uri = format!("{}/repos/{}/{}/keys/{}", super::GITHUB_BASE_API_URL, owner, repo, key_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeployKeyError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetDeployKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deployment
    /// 
    /// [GitHub API docs for get_deployment](https://docs.github.com/rest/reference/repos#get-a-deployment)
    ///
    /// ---
    pub async fn get_deployment_async(&self, owner: &str, repo: &str, deployment_id: i32) -> Result<Deployment, ReposGetDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeploymentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deployment
    /// 
    /// [GitHub API docs for get_deployment](https://docs.github.com/rest/reference/repos#get-a-deployment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_deployment(&self, owner: &str, repo: &str, deployment_id: i32) -> Result<Deployment, ReposGetDeploymentError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeploymentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetDeploymentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deployment status
    ///
    /// Users with pull access can view a deployment status for a deployment:
    /// 
    /// [GitHub API docs for get_deployment_status](https://docs.github.com/rest/reference/repos#get-a-deployment-status)
    ///
    /// ---
    pub async fn get_deployment_status_async(&self, owner: &str, repo: &str, deployment_id: i32, status_id: i32) -> Result<DeploymentStatus, ReposGetDeploymentStatusError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id, status_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeploymentStatusError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetDeploymentStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a deployment status
    ///
    /// Users with pull access can view a deployment status for a deployment:
    /// 
    /// [GitHub API docs for get_deployment_status](https://docs.github.com/rest/reference/repos#get-a-deployment-status)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_deployment_status(&self, owner: &str, repo: &str, deployment_id: i32, status_id: i32) -> Result<DeploymentStatus, ReposGetDeploymentStatusError> {

        let request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses/{}", super::GITHUB_BASE_API_URL, owner, repo, deployment_id, status_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetDeploymentStatusError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetDeploymentStatusError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment
    ///
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment](https://docs.github.com/rest/reference/repos#get-an-environment)
    ///
    /// ---
    pub async fn get_environment_async(&self, owner: &str, repo: &str, environment_name: &str) -> Result<Environment, ReposGetEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment
    ///
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment](https://docs.github.com/rest/reference/repos#get-an-environment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_environment(&self, owner: &str, repo: &str, environment_name: &str) -> Result<Environment, ReposGetEnvironmentError> {

        let request_uri = format!("{}/repos/{}/{}/environments/{}", super::GITHUB_BASE_API_URL, owner, repo, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetEnvironmentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get latest Pages build
    /// 
    /// [GitHub API docs for get_latest_pages_build](https://docs.github.com/rest/reference/repos#get-latest-pages-build)
    ///
    /// ---
    pub async fn get_latest_pages_build_async(&self, owner: &str, repo: &str) -> Result<PageBuild, ReposGetLatestPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds/latest", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetLatestPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get latest Pages build
    /// 
    /// [GitHub API docs for get_latest_pages_build](https://docs.github.com/rest/reference/repos#get-latest-pages-build)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_latest_pages_build(&self, owner: &str, repo: &str) -> Result<PageBuild, ReposGetLatestPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds/latest", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetLatestPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the latest release
    ///
    /// View the latest published full release for the repository.
    /// 
    /// The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
    /// 
    /// [GitHub API docs for get_latest_release](https://docs.github.com/rest/reference/repos#get-the-latest-release)
    ///
    /// ---
    pub async fn get_latest_release_async(&self, owner: &str, repo: &str) -> Result<Release, ReposGetLatestReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/latest", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetLatestReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the latest release
    ///
    /// View the latest published full release for the repository.
    /// 
    /// The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
    /// 
    /// [GitHub API docs for get_latest_release](https://docs.github.com/rest/reference/repos#get-the-latest-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_latest_release(&self, owner: &str, repo: &str) -> Result<Release, ReposGetLatestReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/latest", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetLatestReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a GitHub Pages site
    /// 
    /// [GitHub API docs for get_pages](https://docs.github.com/rest/reference/repos#get-a-github-pages-site)
    ///
    /// ---
    pub async fn get_pages_async(&self, owner: &str, repo: &str) -> Result<Page, ReposGetPagesError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetPagesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetPagesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a GitHub Pages site
    /// 
    /// [GitHub API docs for get_pages](https://docs.github.com/rest/reference/repos#get-a-github-pages-site)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_pages(&self, owner: &str, repo: &str) -> Result<Page, ReposGetPagesError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetPagesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetPagesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Pages build
    /// 
    /// [GitHub API docs for get_pages_build](https://docs.github.com/rest/reference/repos#get-github-pages-build)
    ///
    /// ---
    pub async fn get_pages_build_async(&self, owner: &str, repo: &str, build_id: i32) -> Result<PageBuild, ReposGetPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds/{}", super::GITHUB_BASE_API_URL, owner, repo, build_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Pages build
    /// 
    /// [GitHub API docs for get_pages_build](https://docs.github.com/rest/reference/repos#get-github-pages-build)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_pages_build(&self, owner: &str, repo: &str, build_id: i32) -> Result<PageBuild, ReposGetPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds/{}", super::GITHUB_BASE_API_URL, owner, repo, build_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a DNS health check for GitHub Pages
    ///
    /// Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.
    /// 
    /// The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.
    /// 
    /// Users must have admin or owner permissions. GitHub Apps must have the `pages:write` and `administration:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_pages_health_check](https://docs.github.com/rest/reference/repos#get-a-dns-health-check-for-github-pages)
    ///
    /// ---
    pub async fn get_pages_health_check_async(&self, owner: &str, repo: &str) -> Result<PagesHealthCheck, ReposGetPagesHealthCheckError> {

        let request_uri = format!("{}/repos/{}/{}/pages/health", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetPagesHealthCheckError::Status202(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ReposGetPagesHealthCheckError::Status400),
                422 => Err(ReposGetPagesHealthCheckError::Status422),
                404 => Err(ReposGetPagesHealthCheckError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetPagesHealthCheckError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a DNS health check for GitHub Pages
    ///
    /// Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.
    /// 
    /// The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.
    /// 
    /// Users must have admin or owner permissions. GitHub Apps must have the `pages:write` and `administration:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_pages_health_check](https://docs.github.com/rest/reference/repos#get-a-dns-health-check-for-github-pages)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_pages_health_check(&self, owner: &str, repo: &str) -> Result<PagesHealthCheck, ReposGetPagesHealthCheckError> {

        let request_uri = format!("{}/repos/{}/{}/pages/health", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(ReposGetPagesHealthCheckError::Status202(crate::adapters::to_json(github_response)?)),
                400 => Err(ReposGetPagesHealthCheckError::Status400),
                422 => Err(ReposGetPagesHealthCheckError::Status422),
                404 => Err(ReposGetPagesHealthCheckError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetPagesHealthCheckError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the weekly commit count
    ///
    /// Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
    /// 
    /// The array order is oldest week (index 0) to most recent week.
    /// 
    /// [GitHub API docs for get_participation_stats](https://docs.github.com/rest/reference/repos#get-the-weekly-commit-count)
    ///
    /// ---
    pub async fn get_participation_stats_async(&self, owner: &str, repo: &str) -> Result<ParticipationStats, ReposGetParticipationStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/participation", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetParticipationStatsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetParticipationStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the weekly commit count
    ///
    /// Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
    /// 
    /// The array order is oldest week (index 0) to most recent week.
    /// 
    /// [GitHub API docs for get_participation_stats](https://docs.github.com/rest/reference/repos#get-the-weekly-commit-count)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_participation_stats(&self, owner: &str, repo: &str) -> Result<ParticipationStats, ReposGetParticipationStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/participation", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetParticipationStatsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetParticipationStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_pull_request_review_protection](https://docs.github.com/rest/reference/repos#get-pull-request-review-protection)
    ///
    /// ---
    pub async fn get_pull_request_review_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchPullRequestReview, ReposGetPullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetPullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_pull_request_review_protection](https://docs.github.com/rest/reference/repos#get-pull-request-review-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_pull_request_review_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchPullRequestReview, ReposGetPullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetPullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the hourly commit count for each day
    ///
    /// Each array contains the day number, hour number, and number of commits:
    /// 
    /// *   `0-6`: Sunday - Saturday
    /// *   `0-23`: Hour of day
    /// *   Number of commits
    /// 
    /// For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
    /// 
    /// [GitHub API docs for get_punch_card_stats](https://docs.github.com/rest/reference/repos#get-the-hourly-commit-count-for-each-day)
    ///
    /// ---
    pub async fn get_punch_card_stats_async(&self, owner: &str, repo: &str) -> Result<Vec<CodeFrequencyStat>, ReposGetPunchCardStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/punch_card", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposGetPunchCardStatsError::Status204),
                code => Err(ReposGetPunchCardStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the hourly commit count for each day
    ///
    /// Each array contains the day number, hour number, and number of commits:
    /// 
    /// *   `0-6`: Sunday - Saturday
    /// *   `0-23`: Hour of day
    /// *   Number of commits
    /// 
    /// For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
    /// 
    /// [GitHub API docs for get_punch_card_stats](https://docs.github.com/rest/reference/repos#get-the-hourly-commit-count-for-each-day)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_punch_card_stats(&self, owner: &str, repo: &str) -> Result<Vec<CodeFrequencyStat>, ReposGetPunchCardStatsError> {

        let request_uri = format!("{}/repos/{}/{}/stats/punch_card", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposGetPunchCardStatsError::Status204),
                code => Err(ReposGetPunchCardStatsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository README
    ///
    /// Gets the preferred README for a repository.
    /// 
    /// READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
    /// 
    /// [GitHub API docs for get_readme](https://docs.github.com/rest/reference/repos#get-a-repository-readme)
    ///
    /// ---
    pub async fn get_readme_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetReadmeParams<'api>>>) -> Result<ContentFile, ReposGetReadmeError> {

        let mut request_uri = format!("{}/repos/{}/{}/readme", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReadmeError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposGetReadmeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetReadmeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository README
    ///
    /// Gets the preferred README for a repository.
    /// 
    /// READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
    /// 
    /// [GitHub API docs for get_readme](https://docs.github.com/rest/reference/repos#get-a-repository-readme)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_readme(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetReadmeParams<'api>>>) -> Result<ContentFile, ReposGetReadmeError> {

        let mut request_uri = format!("{}/repos/{}/{}/readme", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetReadmeParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReadmeError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposGetReadmeError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetReadmeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository README for a directory
    ///
    /// Gets the README from a repository directory.
    /// 
    /// READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
    /// 
    /// [GitHub API docs for get_readme_in_directory](https://docs.github.com/rest/reference/repos#get-a-repository-directory-readme)
    ///
    /// ---
    pub async fn get_readme_in_directory_async(&self, owner: &str, repo: &str, dir: &str, query_params: Option<impl Into<ReposGetReadmeInDirectoryParams<'api>>>) -> Result<ContentFile, ReposGetReadmeInDirectoryError> {

        let mut request_uri = format!("{}/repos/{}/{}/readme/{}", super::GITHUB_BASE_API_URL, owner, repo, dir);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReadmeInDirectoryError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposGetReadmeInDirectoryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetReadmeInDirectoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository README for a directory
    ///
    /// Gets the README from a repository directory.
    /// 
    /// READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
    /// 
    /// [GitHub API docs for get_readme_in_directory](https://docs.github.com/rest/reference/repos#get-a-repository-directory-readme)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_readme_in_directory(&self, owner: &str, repo: &str, dir: &str, query_params: Option<impl Into<ReposGetReadmeInDirectoryParams<'api>>>) -> Result<ContentFile, ReposGetReadmeInDirectoryError> {

        let mut request_uri = format!("{}/repos/{}/{}/readme/{}", super::GITHUB_BASE_API_URL, owner, repo, dir);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetReadmeInDirectoryParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReadmeInDirectoryError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposGetReadmeInDirectoryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetReadmeInDirectoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release
    ///
    /// **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia).
    /// 
    /// [GitHub API docs for get_release](https://docs.github.com/rest/reference/repos#get-a-release)
    ///
    /// ---
    pub async fn get_release_async(&self, owner: &str, repo: &str, release_id: i32) -> Result<Release, ReposGetReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release
    ///
    /// **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia).
    /// 
    /// [GitHub API docs for get_release](https://docs.github.com/rest/reference/repos#get-a-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_release(&self, owner: &str, repo: &str, release_id: i32) -> Result<Release, ReposGetReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release asset
    ///
    /// To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
    /// 
    /// [GitHub API docs for get_release_asset](https://docs.github.com/rest/reference/repos#get-a-release-asset)
    ///
    /// ---
    pub async fn get_release_asset_async(&self, owner: &str, repo: &str, asset_id: i32) -> Result<ReleaseAsset, ReposGetReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseAssetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(ReposGetReleaseAssetError::Status415(crate::adapters::to_json_async(github_response).await?)),
                302 => Err(ReposGetReleaseAssetError::Status302),
                code => Err(ReposGetReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release asset
    ///
    /// To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
    /// 
    /// [GitHub API docs for get_release_asset](https://docs.github.com/rest/reference/repos#get-a-release-asset)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_release_asset(&self, owner: &str, repo: &str, asset_id: i32) -> Result<ReleaseAsset, ReposGetReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseAssetError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(ReposGetReleaseAssetError::Status415(crate::adapters::to_json(github_response)?)),
                302 => Err(ReposGetReleaseAssetError::Status302),
                code => Err(ReposGetReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release by tag name
    ///
    /// Get a published release with the specified tag.
    /// 
    /// [GitHub API docs for get_release_by_tag](https://docs.github.com/rest/reference/repos#get-a-release-by-tag-name)
    ///
    /// ---
    pub async fn get_release_by_tag_async(&self, owner: &str, repo: &str, tag: &str) -> Result<Release, ReposGetReleaseByTagError> {

        let request_uri = format!("{}/repos/{}/{}/releases/tags/{}", super::GITHUB_BASE_API_URL, owner, repo, tag);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseByTagError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetReleaseByTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a release by tag name
    ///
    /// Get a published release with the specified tag.
    /// 
    /// [GitHub API docs for get_release_by_tag](https://docs.github.com/rest/reference/repos#get-a-release-by-tag-name)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_release_by_tag(&self, owner: &str, repo: &str, tag: &str) -> Result<Release, ReposGetReleaseByTagError> {

        let request_uri = format!("{}/repos/{}/{}/releases/tags/{}", super::GITHUB_BASE_API_URL, owner, repo, tag);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetReleaseByTagError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetReleaseByTagError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get status checks protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_status_checks_protection](https://docs.github.com/rest/reference/repos#get-status-checks-protection)
    ///
    /// ---
    pub async fn get_status_checks_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<StatusCheckPolicy, ReposGetStatusChecksProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetStatusChecksProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetStatusChecksProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get status checks protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for get_status_checks_protection](https://docs.github.com/rest/reference/repos#get-status-checks-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_status_checks_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<StatusCheckPolicy, ReposGetStatusChecksProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetStatusChecksProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetStatusChecksProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get teams with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the teams who have push access to this branch. The list includes child teams.
    /// 
    /// [GitHub API docs for get_teams_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-teams-with-access-to-the-protected-branch)
    ///
    /// ---
    pub async fn get_teams_with_access_to_protected_branch_async(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<Team>, ReposGetTeamsWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetTeamsWithAccessToProtectedBranchError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetTeamsWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get teams with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the teams who have push access to this branch. The list includes child teams.
    /// 
    /// [GitHub API docs for get_teams_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-teams-with-access-to-the-protected-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_teams_with_access_to_protected_branch(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<Team>, ReposGetTeamsWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetTeamsWithAccessToProtectedBranchError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetTeamsWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get top referral paths
    ///
    /// Get the top 10 popular contents over the last 14 days.
    /// 
    /// [GitHub API docs for get_top_paths](https://docs.github.com/rest/reference/repos#get-top-referral-paths)
    ///
    /// ---
    pub async fn get_top_paths_async(&self, owner: &str, repo: &str) -> Result<Vec<ContentTraffic>, ReposGetTopPathsError> {

        let request_uri = format!("{}/repos/{}/{}/traffic/popular/paths", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetTopPathsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetTopPathsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get top referral paths
    ///
    /// Get the top 10 popular contents over the last 14 days.
    /// 
    /// [GitHub API docs for get_top_paths](https://docs.github.com/rest/reference/repos#get-top-referral-paths)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_top_paths(&self, owner: &str, repo: &str) -> Result<Vec<ContentTraffic>, ReposGetTopPathsError> {

        let request_uri = format!("{}/repos/{}/{}/traffic/popular/paths", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetTopPathsError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetTopPathsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get top referral sources
    ///
    /// Get the top 10 referrers over the last 14 days.
    /// 
    /// [GitHub API docs for get_top_referrers](https://docs.github.com/rest/reference/repos#get-top-referral-sources)
    ///
    /// ---
    pub async fn get_top_referrers_async(&self, owner: &str, repo: &str) -> Result<Vec<ReferrerTraffic>, ReposGetTopReferrersError> {

        let request_uri = format!("{}/repos/{}/{}/traffic/popular/referrers", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetTopReferrersError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetTopReferrersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get top referral sources
    ///
    /// Get the top 10 referrers over the last 14 days.
    /// 
    /// [GitHub API docs for get_top_referrers](https://docs.github.com/rest/reference/repos#get-top-referral-sources)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_top_referrers(&self, owner: &str, repo: &str) -> Result<Vec<ReferrerTraffic>, ReposGetTopReferrersError> {

        let request_uri = format!("{}/repos/{}/{}/traffic/popular/referrers", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetTopReferrersError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetTopReferrersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get users with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the people who have push access to this branch.
    /// 
    /// [GitHub API docs for get_users_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-users-with-access-to-the-protected-branch)
    ///
    /// ---
    pub async fn get_users_with_access_to_protected_branch_async(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<SimpleUser>, ReposGetUsersWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetUsersWithAccessToProtectedBranchError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetUsersWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get users with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Lists the people who have push access to this branch.
    /// 
    /// [GitHub API docs for get_users_with_access_to_protected_branch](https://docs.github.com/rest/reference/repos#list-users-with-access-to-the-protected-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_users_with_access_to_protected_branch(&self, owner: &str, repo: &str, branch: &str) -> Result<Vec<SimpleUser>, ReposGetUsersWithAccessToProtectedBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetUsersWithAccessToProtectedBranchError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetUsersWithAccessToProtectedBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get page views
    ///
    /// Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    /// 
    /// [GitHub API docs for get_views](https://docs.github.com/rest/reference/repos#get-page-views)
    ///
    /// ---
    pub async fn get_views_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetViewsParams<'api>>>) -> Result<ViewTraffic, ReposGetViewsError> {

        let mut request_uri = format!("{}/repos/{}/{}/traffic/views", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetViewsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetViewsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get page views
    ///
    /// Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    /// 
    /// [GitHub API docs for get_views](https://docs.github.com/rest/reference/repos#get-page-views)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_views(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposGetViewsParams<'api>>>) -> Result<ViewTraffic, ReposGetViewsError> {

        let mut request_uri = format!("{}/repos/{}/{}/traffic/views", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposGetViewsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposGetViewsError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetViewsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository webhook
    ///
    /// Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/reference/repos#get-a-webhook-configuration-for-a-repository)."
    /// 
    /// [GitHub API docs for get_webhook](https://docs.github.com/rest/reference/repos#get-a-repository-webhook)
    ///
    /// ---
    pub async fn get_webhook_async(&self, owner: &str, repo: &str, hook_id: i32) -> Result<Hook, ReposGetWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository webhook
    ///
    /// Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/reference/repos#get-a-webhook-configuration-for-a-repository)."
    /// 
    /// [GitHub API docs for get_webhook](https://docs.github.com/rest/reference/repos#get-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook(&self, owner: &str, repo: &str, hook_id: i32) -> Result<Hook, ReposGetWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposGetWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for a repository
    ///
    /// Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/reference/orgs#get-a-repository-webhook)."
    /// 
    /// Access tokens must have the `read:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:read` permission.
    /// 
    /// [GitHub API docs for get_webhook_config_for_repo](https://docs.github.com/rest/reference/repos#get-a-webhook-configuration-for-a-repository)
    ///
    /// ---
    pub async fn get_webhook_config_for_repo_async(&self, owner: &str, repo: &str, hook_id: i32) -> Result<WebhookConfig, ReposGetWebhookConfigForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetWebhookConfigForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for a repository
    ///
    /// Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/reference/orgs#get-a-repository-webhook)."
    /// 
    /// Access tokens must have the `read:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:read` permission.
    /// 
    /// [GitHub API docs for get_webhook_config_for_repo](https://docs.github.com/rest/reference/repos#get-a-webhook-configuration-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_config_for_repo(&self, owner: &str, repo: &str, hook_id: i32) -> Result<WebhookConfig, ReposGetWebhookConfigForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposGetWebhookConfigForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a delivery for a repository webhook
    ///
    /// Returns a delivery for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/repos#get-a-delivery-for-a-repository-webhook)
    ///
    /// ---
    pub async fn get_webhook_delivery_async(&self, owner: &str, repo: &str, hook_id: i32, delivery_id: i32) -> Result<HookDelivery, ReposGetWebhookDeliveryError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposGetWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposGetWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a delivery for a repository webhook
    ///
    /// Returns a delivery for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/repos#get-a-delivery-for-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_delivery(&self, owner: &str, repo: &str, hook_id: i32, delivery_id: i32) -> Result<HookDelivery, ReposGetWebhookDeliveryError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposGetWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposGetWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List all autolinks of a repository
    ///
    /// This returns a list of autolinks configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for list_autolinks](https://docs.github.com/v3/repos#list-autolinks)
    ///
    /// ---
    pub async fn list_autolinks_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListAutolinksParams>>) -> Result<Vec<Autolink>, ReposListAutolinksError> {

        let mut request_uri = format!("{}/repos/{}/{}/autolinks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListAutolinksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List all autolinks of a repository
    ///
    /// This returns a list of autolinks configured for the given repository.
    /// 
    /// Information about autolinks are only available to repository administrators.
    /// 
    /// [GitHub API docs for list_autolinks](https://docs.github.com/v3/repos#list-autolinks)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_autolinks(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListAutolinksParams>>) -> Result<Vec<Autolink>, ReposListAutolinksError> {

        let mut request_uri = format!("{}/repos/{}/{}/autolinks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListAutolinksParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListAutolinksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List branches
    /// 
    /// [GitHub API docs for list_branches](https://docs.github.com/rest/reference/repos#list-branches)
    ///
    /// ---
    pub async fn list_branches_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListBranchesParams>>) -> Result<Vec<ShortBranch>, ReposListBranchesError> {

        let mut request_uri = format!("{}/repos/{}/{}/branches", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListBranchesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListBranchesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List branches
    /// 
    /// [GitHub API docs for list_branches](https://docs.github.com/rest/reference/repos#list-branches)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_branches(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListBranchesParams>>) -> Result<Vec<ShortBranch>, ReposListBranchesError> {

        let mut request_uri = format!("{}/repos/{}/{}/branches", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListBranchesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListBranchesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListBranchesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List branches for HEAD commit
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
    /// 
    /// [GitHub API docs for list_branches_for_head_commit](https://docs.github.com/rest/reference/repos#list-branches-for-head-commit)
    ///
    /// ---
    pub async fn list_branches_for_head_commit_async(&self, owner: &str, repo: &str, commit_sha: &str) -> Result<Vec<BranchShort>, ReposListBranchesForHeadCommitError> {

        let request_uri = format!("{}/repos/{}/{}/commits/{}/branches-where-head", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListBranchesForHeadCommitError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListBranchesForHeadCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List branches for HEAD commit
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
    /// 
    /// [GitHub API docs for list_branches_for_head_commit](https://docs.github.com/rest/reference/repos#list-branches-for-head-commit)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_branches_for_head_commit(&self, owner: &str, repo: &str, commit_sha: &str) -> Result<Vec<BranchShort>, ReposListBranchesForHeadCommitError> {

        let request_uri = format!("{}/repos/{}/{}/commits/{}/branches-where-head", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListBranchesForHeadCommitError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListBranchesForHeadCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository collaborators
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// You must have push access to the repository in order to list collaborators.
    /// 
    /// [GitHub API docs for list_collaborators](https://docs.github.com/rest/reference/repos#list-repository-collaborators)
    ///
    /// ---
    pub async fn list_collaborators_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCollaboratorsParams<'api>>>) -> Result<Vec<Collaborator>, ReposListCollaboratorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/collaborators", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListCollaboratorsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository collaborators
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// 
    /// Team members will include the members of child teams.
    /// 
    /// You must have push access to the repository in order to list collaborators.
    /// 
    /// [GitHub API docs for list_collaborators](https://docs.github.com/rest/reference/repos#list-repository-collaborators)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_collaborators(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCollaboratorsParams<'api>>>) -> Result<Vec<Collaborator>, ReposListCollaboratorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/collaborators", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListCollaboratorsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListCollaboratorsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit comments
    ///
    /// Use the `:commit_sha` to specify the commit that will have its comments listed.
    /// 
    /// [GitHub API docs for list_comments_for_commit](https://docs.github.com/rest/reference/repos#list-commit-comments)
    ///
    /// ---
    pub async fn list_comments_for_commit_async(&self, owner: &str, repo: &str, commit_sha: &str, query_params: Option<impl Into<ReposListCommentsForCommitParams>>) -> Result<Vec<CommitComment>, ReposListCommentsForCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListCommentsForCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit comments
    ///
    /// Use the `:commit_sha` to specify the commit that will have its comments listed.
    /// 
    /// [GitHub API docs for list_comments_for_commit](https://docs.github.com/rest/reference/repos#list-commit-comments)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_comments_for_commit(&self, owner: &str, repo: &str, commit_sha: &str, query_params: Option<impl Into<ReposListCommentsForCommitParams>>) -> Result<Vec<CommitComment>, ReposListCommentsForCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/comments", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListCommentsForCommitParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListCommentsForCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit comments for a repository
    ///
    /// Commit Comments use [these custom media types](https://docs.github.com/rest/reference/repos#custom-media-types). You can read more about the use of media types in the API [here](https://docs.github.com/rest/overview/media-types/).
    /// 
    /// Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_commit_comments_for_repo](https://docs.github.com/rest/reference/repos#list-commit-comments-for-a-repository)
    ///
    /// ---
    pub async fn list_commit_comments_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCommitCommentsForRepoParams>>) -> Result<Vec<CommitComment>, ReposListCommitCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListCommitCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit comments for a repository
    ///
    /// Commit Comments use [these custom media types](https://docs.github.com/rest/reference/repos#custom-media-types). You can read more about the use of media types in the API [here](https://docs.github.com/rest/overview/media-types/).
    /// 
    /// Comments are ordered by ascending ID.
    /// 
    /// [GitHub API docs for list_commit_comments_for_repo](https://docs.github.com/rest/reference/repos#list-commit-comments-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_commit_comments_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCommitCommentsForRepoParams>>) -> Result<Vec<CommitComment>, ReposListCommitCommentsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/comments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListCommitCommentsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListCommitCommentsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit statuses for a reference
    ///
    /// Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
    /// 
    /// This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
    /// 
    /// [GitHub API docs for list_commit_statuses_for_ref](https://docs.github.com/rest/reference/repos#list-commit-statuses-for-a-reference)
    ///
    /// ---
    pub async fn list_commit_statuses_for_ref_async(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposListCommitStatusesForRefParams>>) -> Result<Vec<Status>, ReposListCommitStatusesForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                301 => Err(ReposListCommitStatusesForRefError::Status301(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListCommitStatusesForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commit statuses for a reference
    ///
    /// Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
    /// 
    /// This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
    /// 
    /// [GitHub API docs for list_commit_statuses_for_ref](https://docs.github.com/rest/reference/repos#list-commit-statuses-for-a-reference)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_commit_statuses_for_ref(&self, owner: &str, repo: &str, git_ref: &str, query_params: Option<impl Into<ReposListCommitStatusesForRefParams>>) -> Result<Vec<Status>, ReposListCommitStatusesForRefError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, git_ref);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListCommitStatusesForRefParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                301 => Err(ReposListCommitStatusesForRefError::Status301(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListCommitStatusesForRefError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commits
    ///
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/repos#list-commits)
    ///
    /// ---
    pub async fn list_commits_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCommitsParams<'api>>>) -> Result<Vec<Commit>, ReposListCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                500 => Err(ReposListCommitsError::Status500(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ReposListCommitsError::Status400(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposListCommitsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ReposListCommitsError::Status409(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List commits
    ///
    /// **Signature verification object**
    /// 
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    /// 
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// 
    /// These are the possible values for `reason` in the `verification` object:
    /// 
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    /// 
    /// [GitHub API docs for list_commits](https://docs.github.com/rest/reference/repos#list-commits)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_commits(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListCommitsParams<'api>>>) -> Result<Vec<Commit>, ReposListCommitsError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListCommitsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                500 => Err(ReposListCommitsError::Status500(crate::adapters::to_json(github_response)?)),
                400 => Err(ReposListCommitsError::Status400(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposListCommitsError::Status404(crate::adapters::to_json(github_response)?)),
                409 => Err(ReposListCommitsError::Status409(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository contributors
    ///
    /// Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.
    /// 
    /// GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
    /// 
    /// [GitHub API docs for list_contributors](https://docs.github.com/rest/reference/repos#list-repository-contributors)
    ///
    /// ---
    pub async fn list_contributors_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListContributorsParams<'api>>>) -> Result<Vec<Contributor>, ReposListContributorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/contributors", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposListContributorsError::Status204),
                403 => Err(ReposListContributorsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposListContributorsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListContributorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository contributors
    ///
    /// Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.
    /// 
    /// GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
    /// 
    /// [GitHub API docs for list_contributors](https://docs.github.com/rest/reference/repos#list-repository-contributors)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_contributors(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListContributorsParams<'api>>>) -> Result<Vec<Contributor>, ReposListContributorsError> {

        let mut request_uri = format!("{}/repos/{}/{}/contributors", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListContributorsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposListContributorsError::Status204),
                403 => Err(ReposListContributorsError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposListContributorsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListContributorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deploy keys
    /// 
    /// [GitHub API docs for list_deploy_keys](https://docs.github.com/rest/reference/repos#list-deploy-keys)
    ///
    /// ---
    pub async fn list_deploy_keys_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListDeployKeysParams>>) -> Result<Vec<DeployKey>, ReposListDeployKeysError> {

        let mut request_uri = format!("{}/repos/{}/{}/keys", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListDeployKeysError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deploy keys
    /// 
    /// [GitHub API docs for list_deploy_keys](https://docs.github.com/rest/reference/repos#list-deploy-keys)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_deploy_keys(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListDeployKeysParams>>) -> Result<Vec<DeployKey>, ReposListDeployKeysError> {

        let mut request_uri = format!("{}/repos/{}/{}/keys", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListDeployKeysParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListDeployKeysError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deployment statuses
    ///
    /// Users with pull access can view deployment statuses for a deployment:
    /// 
    /// [GitHub API docs for list_deployment_statuses](https://docs.github.com/rest/reference/repos#list-deployment-statuses)
    ///
    /// ---
    pub async fn list_deployment_statuses_async(&self, owner: &str, repo: &str, deployment_id: i32, query_params: Option<impl Into<ReposListDeploymentStatusesParams>>) -> Result<Vec<DeploymentStatus>, ReposListDeploymentStatusesError> {

        let mut request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListDeploymentStatusesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListDeploymentStatusesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deployment statuses
    ///
    /// Users with pull access can view deployment statuses for a deployment:
    /// 
    /// [GitHub API docs for list_deployment_statuses](https://docs.github.com/rest/reference/repos#list-deployment-statuses)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_deployment_statuses(&self, owner: &str, repo: &str, deployment_id: i32, query_params: Option<impl Into<ReposListDeploymentStatusesParams>>) -> Result<Vec<DeploymentStatus>, ReposListDeploymentStatusesError> {

        let mut request_uri = format!("{}/repos/{}/{}/deployments/{}/statuses", super::GITHUB_BASE_API_URL, owner, repo, deployment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListDeploymentStatusesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListDeploymentStatusesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListDeploymentStatusesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deployments
    ///
    /// Simple filtering of deployments is available via query parameters:
    /// 
    /// [GitHub API docs for list_deployments](https://docs.github.com/rest/reference/repos#list-deployments)
    ///
    /// ---
    pub async fn list_deployments_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListDeploymentsParams<'api>>>) -> Result<Vec<Deployment>, ReposListDeploymentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/deployments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListDeploymentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deployments
    ///
    /// Simple filtering of deployments is available via query parameters:
    /// 
    /// [GitHub API docs for list_deployments](https://docs.github.com/rest/reference/repos#list-deployments)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_deployments(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListDeploymentsParams<'api>>>) -> Result<Vec<Deployment>, ReposListDeploymentsError> {

        let mut request_uri = format!("{}/repos/{}/{}/deployments", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListDeploymentsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListDeploymentsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for the authenticated user
    ///
    /// Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/repos#list-repositories-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<ReposListForAuthenticatedUserParams<'api>>>) -> Result<Vec<Repository>, ReposListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/repos", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ReposListForAuthenticatedUserError::Status304),
                403 => Err(ReposListForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ReposListForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for the authenticated user
    ///
    /// Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/repos#list-repositories-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<ReposListForAuthenticatedUserParams<'api>>>) -> Result<Vec<Repository>, ReposListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/repos", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(ReposListForAuthenticatedUserError::Status304),
                403 => Err(ReposListForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ReposListForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization repositories
    ///
    /// Lists repositories for the specified organization.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/repos#list-organization-repositories)
    ///
    /// ---
    pub async fn list_for_org_async(&self, org: &str, query_params: Option<impl Into<ReposListForOrgParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/repos", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization repositories
    ///
    /// Lists repositories for the specified organization.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/repos#list-organization-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_org(&self, org: &str, query_params: Option<impl Into<ReposListForOrgParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/repos", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for a user
    ///
    /// Lists public repositories for the specified user. Note: For GitHub AE, this endpoint will list internal repositories for the specified user.
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/repos#list-repositories-for-a-user)
    ///
    /// ---
    pub async fn list_for_user_async(&self, username: &str, query_params: Option<impl Into<ReposListForUserParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForUserError> {

        let mut request_uri = format!("{}/users/{}/repos", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories for a user
    ///
    /// Lists public repositories for the specified user. Note: For GitHub AE, this endpoint will list internal repositories for the specified user.
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/repos#list-repositories-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_user(&self, username: &str, query_params: Option<impl Into<ReposListForUserParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForUserError> {

        let mut request_uri = format!("{}/users/{}/repos", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List forks
    /// 
    /// [GitHub API docs for list_forks](https://docs.github.com/rest/reference/repos#list-forks)
    ///
    /// ---
    pub async fn list_forks_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListForksParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForksError> {

        let mut request_uri = format!("{}/repos/{}/{}/forks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposListForksError::Status400(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListForksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List forks
    /// 
    /// [GitHub API docs for list_forks](https://docs.github.com/rest/reference/repos#list-forks)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_forks(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListForksParams<'api>>>) -> Result<Vec<MinimalRepository>, ReposListForksError> {

        let mut request_uri = format!("{}/repos/{}/{}/forks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListForksParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposListForksError::Status400(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListForksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository invitations
    ///
    /// When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
    /// 
    /// [GitHub API docs for list_invitations](https://docs.github.com/rest/reference/repos#list-repository-invitations)
    ///
    /// ---
    pub async fn list_invitations_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListInvitationsParams>>) -> Result<Vec<RepositoryInvitation>, ReposListInvitationsError> {

        let mut request_uri = format!("{}/repos/{}/{}/invitations", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository invitations
    ///
    /// When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
    /// 
    /// [GitHub API docs for list_invitations](https://docs.github.com/rest/reference/repos#list-repository-invitations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_invitations(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListInvitationsParams>>) -> Result<Vec<RepositoryInvitation>, ReposListInvitationsError> {

        let mut request_uri = format!("{}/repos/{}/{}/invitations", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListInvitationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository invitations for the authenticated user
    ///
    /// When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
    /// 
    /// [GitHub API docs for list_invitations_for_authenticated_user](https://docs.github.com/rest/reference/repos#list-repository-invitations-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_invitations_for_authenticated_user_async(&self, query_params: Option<impl Into<ReposListInvitationsForAuthenticatedUserParams>>) -> Result<Vec<RepositoryInvitation>, ReposListInvitationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/repository_invitations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ReposListInvitationsForAuthenticatedUserError::Status304),
                404 => Err(ReposListInvitationsForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposListInvitationsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ReposListInvitationsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListInvitationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository invitations for the authenticated user
    ///
    /// When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
    /// 
    /// [GitHub API docs for list_invitations_for_authenticated_user](https://docs.github.com/rest/reference/repos#list-repository-invitations-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_invitations_for_authenticated_user(&self, query_params: Option<impl Into<ReposListInvitationsForAuthenticatedUserParams>>) -> Result<Vec<RepositoryInvitation>, ReposListInvitationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/repository_invitations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListInvitationsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ReposListInvitationsForAuthenticatedUserError::Status304),
                404 => Err(ReposListInvitationsForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposListInvitationsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ReposListInvitationsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListInvitationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository languages
    ///
    /// Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
    /// 
    /// [GitHub API docs for list_languages](https://docs.github.com/rest/reference/repos#list-repository-languages)
    ///
    /// ---
    pub async fn list_languages_async(&self, owner: &str, repo: &str) -> Result<Language, ReposListLanguagesError> {

        let request_uri = format!("{}/repos/{}/{}/languages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListLanguagesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository languages
    ///
    /// Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
    /// 
    /// [GitHub API docs for list_languages](https://docs.github.com/rest/reference/repos#list-repository-languages)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_languages(&self, owner: &str, repo: &str) -> Result<Language, ReposListLanguagesError> {

        let request_uri = format!("{}/repos/{}/{}/languages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListLanguagesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GitHub Pages builds
    /// 
    /// [GitHub API docs for list_pages_builds](https://docs.github.com/rest/reference/repos#list-github-pages-builds)
    ///
    /// ---
    pub async fn list_pages_builds_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListPagesBuildsParams>>) -> Result<Vec<PageBuild>, ReposListPagesBuildsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pages/builds", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListPagesBuildsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List GitHub Pages builds
    /// 
    /// [GitHub API docs for list_pages_builds](https://docs.github.com/rest/reference/repos#list-github-pages-builds)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_pages_builds(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListPagesBuildsParams>>) -> Result<Vec<PageBuild>, ReposListPagesBuildsError> {

        let mut request_uri = format!("{}/repos/{}/{}/pages/builds", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListPagesBuildsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListPagesBuildsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public repositories
    ///
    /// Lists all public repositories in the order that they were created.
    /// 
    /// Note:
    /// - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
    /// - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of repositories.
    /// 
    /// [GitHub API docs for list_public](https://docs.github.com/rest/reference/repos#list-public-repositories)
    ///
    /// ---
    pub async fn list_public_async(&self, query_params: Option<impl Into<ReposListPublicParams>>) -> Result<Vec<MinimalRepository>, ReposListPublicError> {

        let mut request_uri = format!("{}/repositories", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListPublicError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ReposListPublicError::Status304),
                code => Err(ReposListPublicError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public repositories
    ///
    /// Lists all public repositories in the order that they were created.
    /// 
    /// Note:
    /// - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
    /// - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of repositories.
    /// 
    /// [GitHub API docs for list_public](https://docs.github.com/rest/reference/repos#list-public-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public(&self, query_params: Option<impl Into<ReposListPublicParams>>) -> Result<Vec<MinimalRepository>, ReposListPublicError> {

        let mut request_uri = format!("{}/repositories", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListPublicParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposListPublicError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(ReposListPublicError::Status304),
                code => Err(ReposListPublicError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests associated with a commit
    ///
    /// Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, additionally returns open pull requests associated with the commit. The results may include open and closed pull requests. Additional preview headers may be required to see certain details for associated pull requests, such as whether a pull request is in a draft state. For more information about previews that might affect this endpoint, see the [List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests) endpoint.
    /// 
    /// [GitHub API docs for list_pull_requests_associated_with_commit](https://docs.github.com/rest/reference/repos#list-pull-requests-associated-with-a-commit)
    ///
    /// ---
    pub async fn list_pull_requests_associated_with_commit_async(&self, owner: &str, repo: &str, commit_sha: &str, query_params: Option<impl Into<ReposListPullRequestsAssociatedWithCommitParams>>) -> Result<Vec<PullRequestSimple>, ReposListPullRequestsAssociatedWithCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListPullRequestsAssociatedWithCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pull requests associated with a commit
    ///
    /// Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, additionally returns open pull requests associated with the commit. The results may include open and closed pull requests. Additional preview headers may be required to see certain details for associated pull requests, such as whether a pull request is in a draft state. For more information about previews that might affect this endpoint, see the [List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests) endpoint.
    /// 
    /// [GitHub API docs for list_pull_requests_associated_with_commit](https://docs.github.com/rest/reference/repos#list-pull-requests-associated-with-a-commit)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_pull_requests_associated_with_commit(&self, owner: &str, repo: &str, commit_sha: &str, query_params: Option<impl Into<ReposListPullRequestsAssociatedWithCommitParams>>) -> Result<Vec<PullRequestSimple>, ReposListPullRequestsAssociatedWithCommitError> {

        let mut request_uri = format!("{}/repos/{}/{}/commits/{}/pulls", super::GITHUB_BASE_API_URL, owner, repo, commit_sha);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListPullRequestsAssociatedWithCommitParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListPullRequestsAssociatedWithCommitError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List release assets
    /// 
    /// [GitHub API docs for list_release_assets](https://docs.github.com/rest/reference/repos#list-release-assets)
    ///
    /// ---
    pub async fn list_release_assets_async(&self, owner: &str, repo: &str, release_id: i32, query_params: Option<impl Into<ReposListReleaseAssetsParams>>) -> Result<Vec<ReleaseAsset>, ReposListReleaseAssetsError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases/{}/assets", super::GITHUB_BASE_API_URL, owner, repo, release_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListReleaseAssetsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List release assets
    /// 
    /// [GitHub API docs for list_release_assets](https://docs.github.com/rest/reference/repos#list-release-assets)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_release_assets(&self, owner: &str, repo: &str, release_id: i32, query_params: Option<impl Into<ReposListReleaseAssetsParams>>) -> Result<Vec<ReleaseAsset>, ReposListReleaseAssetsError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases/{}/assets", super::GITHUB_BASE_API_URL, owner, repo, release_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListReleaseAssetsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListReleaseAssetsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List releases
    ///
    /// This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/reference/repos#list-repository-tags).
    /// 
    /// Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
    /// 
    /// [GitHub API docs for list_releases](https://docs.github.com/rest/reference/repos#list-releases)
    ///
    /// ---
    pub async fn list_releases_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListReleasesParams>>) -> Result<Vec<Release>, ReposListReleasesError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListReleasesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListReleasesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List releases
    ///
    /// This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/reference/repos#list-repository-tags).
    /// 
    /// Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
    /// 
    /// [GitHub API docs for list_releases](https://docs.github.com/rest/reference/repos#list-releases)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_releases(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListReleasesParams>>) -> Result<Vec<Release>, ReposListReleasesError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListReleasesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListReleasesError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListReleasesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository tags
    /// 
    /// [GitHub API docs for list_tags](https://docs.github.com/rest/reference/repos#list-repository-tags)
    ///
    /// ---
    pub async fn list_tags_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListTagsParams>>) -> Result<Vec<Tag>, ReposListTagsError> {

        let mut request_uri = format!("{}/repos/{}/{}/tags", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListTagsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository tags
    /// 
    /// [GitHub API docs for list_tags](https://docs.github.com/rest/reference/repos#list-repository-tags)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_tags(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListTagsParams>>) -> Result<Vec<Tag>, ReposListTagsError> {

        let mut request_uri = format!("{}/repos/{}/{}/tags", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListTagsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListTagsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository teams
    /// 
    /// [GitHub API docs for list_teams](https://docs.github.com/rest/reference/repos#list-repository-teams)
    ///
    /// ---
    pub async fn list_teams_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListTeamsParams>>) -> Result<Vec<Team>, ReposListTeamsError> {

        let mut request_uri = format!("{}/repos/{}/{}/teams", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListTeamsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository teams
    /// 
    /// [GitHub API docs for list_teams](https://docs.github.com/rest/reference/repos#list-repository-teams)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_teams(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListTeamsParams>>) -> Result<Vec<Team>, ReposListTeamsError> {

        let mut request_uri = format!("{}/repos/{}/{}/teams", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListTeamsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposListTeamsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for a repository webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/repos#list-deliveries-for-a-repository-webhook)
    ///
    /// ---
    pub async fn list_webhook_deliveries_async(&self, owner: &str, repo: &str, hook_id: i32, query_params: Option<impl Into<ReposListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, ReposListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries", super::GITHUB_BASE_API_URL, owner, repo, hook_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposListWebhookDeliveriesError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposListWebhookDeliveriesError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for a repository webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/repos#list-deliveries-for-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_webhook_deliveries(&self, owner: &str, repo: &str, hook_id: i32, query_params: Option<impl Into<ReposListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, ReposListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries", super::GITHUB_BASE_API_URL, owner, repo, hook_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListWebhookDeliveriesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposListWebhookDeliveriesError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposListWebhookDeliveriesError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository webhooks
    /// 
    /// [GitHub API docs for list_webhooks](https://docs.github.com/rest/reference/repos#list-repository-webhooks)
    ///
    /// ---
    pub async fn list_webhooks_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListWebhooksParams>>) -> Result<Vec<Hook>, ReposListWebhooksError> {

        let mut request_uri = format!("{}/repos/{}/{}/hooks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListWebhooksError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposListWebhooksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository webhooks
    /// 
    /// [GitHub API docs for list_webhooks](https://docs.github.com/rest/reference/repos#list-repository-webhooks)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_webhooks(&self, owner: &str, repo: &str, query_params: Option<impl Into<ReposListWebhooksParams>>) -> Result<Vec<Hook>, ReposListWebhooksError> {

        let mut request_uri = format!("{}/repos/{}/{}/hooks", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReposListWebhooksParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposListWebhooksError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposListWebhooksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Merge a branch
    /// 
    /// [GitHub API docs for merge](https://docs.github.com/rest/reference/repos#merge-a-branch)
    ///
    /// ---
    pub async fn merge_async(&self, owner: &str, repo: &str, body: PostReposMerge) -> Result<Commit, ReposMergeError> {

        let request_uri = format!("{}/repos/{}/{}/merges", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposMerge::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposMergeError::Status204),
                404 => Err(ReposMergeError::Status404),
                409 => Err(ReposMergeError::Status409),
                403 => Err(ReposMergeError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposMergeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposMergeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Merge a branch
    /// 
    /// [GitHub API docs for merge](https://docs.github.com/rest/reference/repos#merge-a-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn merge(&self, owner: &str, repo: &str, body: PostReposMerge) -> Result<Commit, ReposMergeError> {

        let request_uri = format!("{}/repos/{}/{}/merges", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposMerge::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ReposMergeError::Status204),
                404 => Err(ReposMergeError::Status404),
                409 => Err(ReposMergeError::Status409),
                403 => Err(ReposMergeError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposMergeError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposMergeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Sync a fork branch with the upstream repository
    ///
    /// Sync a branch of a forked repository to keep it up-to-date with the upstream repository.
    /// 
    /// [GitHub API docs for merge_upstream](https://docs.github.com/rest/reference/repos#sync-a-fork-branch-with-the-upstream-repository)
    ///
    /// ---
    pub async fn merge_upstream_async(&self, owner: &str, repo: &str, body: PostReposMergeUpstream) -> Result<MergedUpstream, ReposMergeUpstreamError> {

        let request_uri = format!("{}/repos/{}/{}/merge-upstream", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposMergeUpstream::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(ReposMergeUpstreamError::Status409),
                422 => Err(ReposMergeUpstreamError::Status422),
                code => Err(ReposMergeUpstreamError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Sync a fork branch with the upstream repository
    ///
    /// Sync a branch of a forked repository to keep it up-to-date with the upstream repository.
    /// 
    /// [GitHub API docs for merge_upstream](https://docs.github.com/rest/reference/repos#sync-a-fork-branch-with-the-upstream-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn merge_upstream(&self, owner: &str, repo: &str, body: PostReposMergeUpstream) -> Result<MergedUpstream, ReposMergeUpstreamError> {

        let request_uri = format!("{}/repos/{}/{}/merge-upstream", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposMergeUpstream::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(ReposMergeUpstreamError::Status409),
                422 => Err(ReposMergeUpstreamError::Status422),
                code => Err(ReposMergeUpstreamError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Ping a repository webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    /// 
    /// [GitHub API docs for ping_webhook](https://docs.github.com/rest/reference/repos#ping-a-repository-webhook)
    ///
    /// ---
    pub async fn ping_webhook_async(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposPingWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/pings", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposPingWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposPingWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Ping a repository webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    /// 
    /// [GitHub API docs for ping_webhook](https://docs.github.com/rest/reference/repos#ping-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn ping_webhook(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposPingWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/pings", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposPingWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposPingWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for a repository webhook
    ///
    /// Redeliver a webhook delivery for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/repos#redeliver-a-delivery-for-a-repository-webhook)
    ///
    /// ---
    pub async fn redeliver_webhook_delivery_async(&self, owner: &str, repo: &str, hook_id: i32, delivery_id: i32) -> Result<HashMap<String, Value>, ReposRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, owner, repo, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for a repository webhook
    ///
    /// Redeliver a webhook delivery for a webhook configured in a repository.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/repos#redeliver-a-delivery-for-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn redeliver_webhook_delivery(&self, owner: &str, repo: &str, hook_id: i32, delivery_id: i32) -> Result<HashMap<String, Value>, ReposRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, owner, repo, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(ReposRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of an app to push to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_app_access_restrictions](https://docs.github.com/rest/reference/repos#remove-app-access-restrictions)
    ///
    /// ---
    pub async fn remove_app_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveAppAccessRestrictions) -> Result<Vec<Integration>, ReposRemoveAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveAppAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveAppAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRemoveAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of an app to push to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_app_access_restrictions](https://docs.github.com/rest/reference/repos#remove-app-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_app_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveAppAccessRestrictions) -> Result<Vec<Integration>, ReposRemoveAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveAppAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveAppAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRemoveAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository collaborator
    /// 
    /// [GitHub API docs for remove_collaborator](https://docs.github.com/rest/reference/repos#remove-a-repository-collaborator)
    ///
    /// ---
    pub async fn remove_collaborator_async(&self, owner: &str, repo: &str, username: &str) -> Result<(), ReposRemoveCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRemoveCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository collaborator
    /// 
    /// [GitHub API docs for remove_collaborator](https://docs.github.com/rest/reference/repos#remove-a-repository-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_collaborator(&self, owner: &str, repo: &str, username: &str) -> Result<(), ReposRemoveCollaboratorError> {

        let request_uri = format!("{}/repos/{}/{}/collaborators/{}", super::GITHUB_BASE_API_URL, owner, repo, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRemoveCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for remove_status_check_contexts](https://docs.github.com/rest/reference/repos#remove-status-check-contexts)
    ///
    /// ---
    pub async fn remove_status_check_contexts_async(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveStatusCheckContexts) -> Result<Vec<String>, ReposRemoveStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveStatusCheckContexts::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposRemoveStatusCheckContextsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposRemoveStatusCheckContextsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRemoveStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for remove_status_check_contexts](https://docs.github.com/rest/reference/repos#remove-status-check-contexts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_status_check_contexts(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveStatusCheckContexts) -> Result<Vec<String>, ReposRemoveStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveStatusCheckContexts::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposRemoveStatusCheckContextsError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposRemoveStatusCheckContextsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRemoveStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for remove_status_check_protection](https://docs.github.com/rest/reference/repos#remove-status-check-protection)
    ///
    /// ---
    pub async fn remove_status_check_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposRemoveStatusCheckProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRemoveStatusCheckProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for remove_status_check_protection](https://docs.github.com/rest/reference/repos#remove-status-check-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_status_check_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<(), ReposRemoveStatusCheckProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRemoveStatusCheckProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of a team to push to this branch. You can also remove push access for child teams.
    /// 
    /// | Type    | Description                                                                                                                                         |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_team_access_restrictions](https://docs.github.com/rest/reference/repos#remove-team-access-restrictions)
    ///
    /// ---
    pub async fn remove_team_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveTeamAccessRestrictions) -> Result<Vec<Team>, ReposRemoveTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveTeamAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveTeamAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRemoveTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of a team to push to this branch. You can also remove push access for child teams.
    /// 
    /// | Type    | Description                                                                                                                                         |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_team_access_restrictions](https://docs.github.com/rest/reference/repos#remove-team-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_team_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveTeamAccessRestrictions) -> Result<Vec<Team>, ReposRemoveTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveTeamAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveTeamAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRemoveTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of a user to push to this branch.
    /// 
    /// | Type    | Description                                                                                                                                   |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_user_access_restrictions](https://docs.github.com/rest/reference/repos#remove-user-access-restrictions)
    ///
    /// ---
    pub async fn remove_user_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposRemoveUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveUserAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveUserAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRemoveUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Removes the ability of a user to push to this branch.
    /// 
    /// | Type    | Description                                                                                                                                   |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for remove_user_access_restrictions](https://docs.github.com/rest/reference/repos#remove-user-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_user_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: DeleteReposRemoveUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposRemoveUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteReposRemoveUserAccessRestrictions::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposRemoveUserAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRemoveUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Rename a branch
    ///
    /// Renames a branch in a repository.
    /// 
    /// **Note:** Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".
    /// 
    /// The permissions required to use this endpoint depends on whether you are renaming the default branch.
    /// 
    /// To rename a non-default branch:
    /// 
    /// * Users must have push access.
    /// * GitHub Apps must have the `contents:write` repository permission.
    /// 
    /// To rename the default branch:
    /// 
    /// * Users must have admin or owner permissions.
    /// * GitHub Apps must have the `administration:write` repository permission.
    /// 
    /// [GitHub API docs for rename_branch](https://docs.github.com/rest/reference/repos#rename-a-branch)
    ///
    /// ---
    pub async fn rename_branch_async(&self, owner: &str, repo: &str, branch: &str, body: PostReposRenameBranch) -> Result<BranchWithProtection, ReposRenameBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/rename", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposRenameBranch::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposRenameBranchError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposRenameBranchError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposRenameBranchError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposRenameBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Rename a branch
    ///
    /// Renames a branch in a repository.
    /// 
    /// **Note:** Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".
    /// 
    /// The permissions required to use this endpoint depends on whether you are renaming the default branch.
    /// 
    /// To rename a non-default branch:
    /// 
    /// * Users must have push access.
    /// * GitHub Apps must have the `contents:write` repository permission.
    /// 
    /// To rename the default branch:
    /// 
    /// * Users must have admin or owner permissions.
    /// * GitHub Apps must have the `administration:write` repository permission.
    /// 
    /// [GitHub API docs for rename_branch](https://docs.github.com/rest/reference/repos#rename-a-branch)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn rename_branch(&self, owner: &str, repo: &str, branch: &str, body: PostReposRenameBranch) -> Result<BranchWithProtection, ReposRenameBranchError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/rename", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposRenameBranch::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposRenameBranchError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposRenameBranchError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposRenameBranchError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposRenameBranchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Replace all repository topics
    /// 
    /// [GitHub API docs for replace_all_topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics)
    ///
    /// ---
    pub async fn replace_all_topics_async(&self, owner: &str, repo: &str, body: PutReposReplaceAllTopics) -> Result<Topic, ReposReplaceAllTopicsError> {

        let request_uri = format!("{}/repos/{}/{}/topics", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposReplaceAllTopics::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposReplaceAllTopicsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposReplaceAllTopicsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposReplaceAllTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Replace all repository topics
    /// 
    /// [GitHub API docs for replace_all_topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn replace_all_topics(&self, owner: &str, repo: &str, body: PutReposReplaceAllTopics) -> Result<Topic, ReposReplaceAllTopicsError> {

        let request_uri = format!("{}/repos/{}/{}/topics", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposReplaceAllTopics::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposReplaceAllTopicsError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposReplaceAllTopicsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposReplaceAllTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Request a GitHub Pages build
    ///
    /// You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
    /// 
    /// Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
    /// 
    /// [GitHub API docs for request_pages_build](https://docs.github.com/rest/reference/repos#request-a-github-pages-build)
    ///
    /// ---
    pub async fn request_pages_build_async(&self, owner: &str, repo: &str) -> Result<PageBuildStatus, ReposRequestPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRequestPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Request a GitHub Pages build
    ///
    /// You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
    /// 
    /// Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
    /// 
    /// [GitHub API docs for request_pages_build](https://docs.github.com/rest/reference/repos#request-a-github-pages-build)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn request_pages_build(&self, owner: &str, repo: &str) -> Result<PageBuildStatus, ReposRequestPagesBuildError> {

        let request_uri = format!("{}/repos/{}/{}/pages/builds", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposRequestPagesBuildError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for set_admin_branch_protection](https://docs.github.com/rest/reference/repos#set-admin-branch-protection)
    ///
    /// ---
    pub async fn set_admin_branch_protection_async(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposSetAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposSetAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for set_admin_branch_protection](https://docs.github.com/rest/reference/repos#set-admin-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_admin_branch_protection(&self, owner: &str, repo: &str, branch: &str) -> Result<ProtectedBranchAdminEnforced, ReposSetAdminBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/enforce_admins", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposSetAdminBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_app_access_restrictions](https://docs.github.com/rest/reference/repos#set-app-access-restrictions)
    ///
    /// ---
    pub async fn set_app_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetAppAccessRestrictions) -> Result<Vec<Integration>, ReposSetAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetAppAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetAppAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposSetAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
    /// 
    /// | Type    | Description                                                                                                                                                |
    /// | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_app_access_restrictions](https://docs.github.com/rest/reference/repos#set-app-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_app_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetAppAccessRestrictions) -> Result<Vec<Integration>, ReposSetAppAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/apps", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetAppAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetAppAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposSetAppAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for set_status_check_contexts](https://docs.github.com/rest/reference/repos#set-status-check-contexts)
    ///
    /// ---
    pub async fn set_status_check_contexts_async(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetStatusCheckContexts) -> Result<Vec<String>, ReposSetStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetStatusCheckContexts::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetStatusCheckContextsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposSetStatusCheckContextsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposSetStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// [GitHub API docs for set_status_check_contexts](https://docs.github.com/rest/reference/repos#set-status-check-contexts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_status_check_contexts(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetStatusCheckContexts) -> Result<Vec<String>, ReposSetStatusCheckContextsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks/contexts", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetStatusCheckContexts::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetStatusCheckContextsError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposSetStatusCheckContextsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposSetStatusCheckContextsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
    /// 
    /// | Type    | Description                                                                                                                                |
    /// | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
    /// | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_team_access_restrictions](https://docs.github.com/rest/reference/repos#set-team-access-restrictions)
    ///
    /// ---
    pub async fn set_team_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetTeamAccessRestrictions) -> Result<Vec<Team>, ReposSetTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetTeamAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetTeamAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposSetTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
    /// 
    /// | Type    | Description                                                                                                                                |
    /// | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
    /// | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_team_access_restrictions](https://docs.github.com/rest/reference/repos#set-team-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_team_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetTeamAccessRestrictions) -> Result<Vec<Team>, ReposSetTeamAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/teams", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetTeamAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetTeamAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposSetTeamAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
    /// 
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_user_access_restrictions](https://docs.github.com/rest/reference/repos#set-user-access-restrictions)
    ///
    /// ---
    pub async fn set_user_access_restrictions_async(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposSetUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetUserAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetUserAccessRestrictionsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposSetUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
    /// 
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    /// 
    /// [GitHub API docs for set_user_access_restrictions](https://docs.github.com/rest/reference/repos#set-user-access-restrictions)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_user_access_restrictions(&self, owner: &str, repo: &str, branch: &str, body: PutReposSetUserAccessRestrictions) -> Result<Vec<SimpleUser>, ReposSetUserAccessRestrictionsError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/restrictions/users", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposSetUserAccessRestrictions::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposSetUserAccessRestrictionsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposSetUserAccessRestrictionsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Test the push repository webhook
    ///
    /// This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
    /// 
    /// **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
    /// 
    /// [GitHub API docs for test_push_webhook](https://docs.github.com/rest/reference/repos#test-the-push-repository-webhook)
    ///
    /// ---
    pub async fn test_push_webhook_async(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposTestPushWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/tests", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposTestPushWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposTestPushWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Test the push repository webhook
    ///
    /// This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
    /// 
    /// **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
    /// 
    /// [GitHub API docs for test_push_webhook](https://docs.github.com/rest/reference/repos#test-the-push-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn test_push_webhook(&self, owner: &str, repo: &str, hook_id: i32) -> Result<(), ReposTestPushWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/tests", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposTestPushWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposTestPushWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Transfer a repository
    ///
    /// A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://help.github.com/articles/about-repository-transfers/).
    /// 
    /// [GitHub API docs for transfer](https://docs.github.com/rest/reference/repos#transfer-a-repository)
    ///
    /// ---
    pub async fn transfer_async(&self, owner: &str, repo: &str, body: PostReposTransfer) -> Result<MinimalRepository, ReposTransferError> {

        let request_uri = format!("{}/repos/{}/{}/transfer", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposTransfer::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposTransferError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Transfer a repository
    ///
    /// A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://help.github.com/articles/about-repository-transfers/).
    /// 
    /// [GitHub API docs for transfer](https://docs.github.com/rest/reference/repos#transfer-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn transfer(&self, owner: &str, repo: &str, body: PostReposTransfer) -> Result<MinimalRepository, ReposTransferError> {

        let request_uri = format!("{}/repos/{}/{}/transfer", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReposTransfer::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposTransferError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository
    ///
    /// **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics) endpoint.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/repos/#update-a-repository)
    ///
    /// ---
    pub async fn update_async(&self, owner: &str, repo: &str, body: PatchReposUpdate) -> Result<FullRepository, ReposUpdateError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                307 => Err(ReposUpdateError::Status307(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ReposUpdateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposUpdateError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository
    ///
    /// **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics) endpoint.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/repos/#update-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, owner: &str, repo: &str, body: PatchReposUpdate) -> Result<FullRepository, ReposUpdateError> {

        let request_uri = format!("{}/repos/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                307 => Err(ReposUpdateError::Status307(crate::adapters::to_json(github_response)?)),
                403 => Err(ReposUpdateError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposUpdateError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Protecting a branch requires admin or owner permissions to the repository.
    /// 
    /// **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
    /// 
    /// **Note**: The list of users, apps, and teams in total is limited to 100 items.
    /// 
    /// [GitHub API docs for update_branch_protection](https://docs.github.com/rest/reference/repos#update-branch-protection)
    ///
    /// ---
    pub async fn update_branch_protection_async(&self, owner: &str, repo: &str, branch: &str, body: PutReposUpdateBranchProtection) -> Result<ProtectedBranch, ReposUpdateBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposUpdateBranchProtection::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposUpdateBranchProtectionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposUpdateBranchProtectionError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposUpdateBranchProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Protecting a branch requires admin or owner permissions to the repository.
    /// 
    /// **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
    /// 
    /// **Note**: The list of users, apps, and teams in total is limited to 100 items.
    /// 
    /// [GitHub API docs for update_branch_protection](https://docs.github.com/rest/reference/repos#update-branch-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_branch_protection(&self, owner: &str, repo: &str, branch: &str, body: PutReposUpdateBranchProtection) -> Result<ProtectedBranch, ReposUpdateBranchProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposUpdateBranchProtection::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ReposUpdateBranchProtectionError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposUpdateBranchProtectionError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposUpdateBranchProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateBranchProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a commit comment
    /// 
    /// [GitHub API docs for update_commit_comment](https://docs.github.com/rest/reference/repos#update-a-commit-comment)
    ///
    /// ---
    pub async fn update_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PatchReposUpdateCommitComment) -> Result<CommitComment, ReposUpdateCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateCommitComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateCommitCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a commit comment
    /// 
    /// [GitHub API docs for update_commit_comment](https://docs.github.com/rest/reference/repos#update-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_commit_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PatchReposUpdateCommitComment) -> Result<CommitComment, ReposUpdateCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateCommitComment::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateCommitCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update information about a GitHub Pages site
    ///
    /// Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    /// 
    /// [GitHub API docs for update_information_about_pages_site](https://docs.github.com/rest/reference/repos#update-information-about-a-github-pages-site)
    ///
    /// ---
    pub async fn update_information_about_pages_site_async(&self, owner: &str, repo: &str, body: PutReposUpdateInformationAboutPagesSite) -> Result<(), ReposUpdateInformationAboutPagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposUpdateInformationAboutPagesSite::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdateInformationAboutPagesSiteError::Status422(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ReposUpdateInformationAboutPagesSiteError::Status400(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateInformationAboutPagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update information about a GitHub Pages site
    ///
    /// Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    /// 
    /// [GitHub API docs for update_information_about_pages_site](https://docs.github.com/rest/reference/repos#update-information-about-a-github-pages-site)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_information_about_pages_site(&self, owner: &str, repo: &str, body: PutReposUpdateInformationAboutPagesSite) -> Result<(), ReposUpdateInformationAboutPagesSiteError> {

        let request_uri = format!("{}/repos/{}/{}/pages", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutReposUpdateInformationAboutPagesSite::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdateInformationAboutPagesSiteError::Status422(crate::adapters::to_json(github_response)?)),
                400 => Err(ReposUpdateInformationAboutPagesSiteError::Status400(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateInformationAboutPagesSiteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository invitation
    /// 
    /// [GitHub API docs for update_invitation](https://docs.github.com/rest/reference/repos#update-a-repository-invitation)
    ///
    /// ---
    pub async fn update_invitation_async(&self, owner: &str, repo: &str, invitation_id: i32, body: PatchReposUpdateInvitation) -> Result<RepositoryInvitation, ReposUpdateInvitationError> {

        let request_uri = format!("{}/repos/{}/{}/invitations/{}", super::GITHUB_BASE_API_URL, owner, repo, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateInvitation::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository invitation
    /// 
    /// [GitHub API docs for update_invitation](https://docs.github.com/rest/reference/repos#update-a-repository-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_invitation(&self, owner: &str, repo: &str, invitation_id: i32, body: PatchReposUpdateInvitation) -> Result<RepositoryInvitation, ReposUpdateInvitationError> {

        let request_uri = format!("{}/repos/{}/{}/invitations/{}", super::GITHUB_BASE_API_URL, owner, repo, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateInvitation::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
    /// 
    /// [GitHub API docs for update_pull_request_review_protection](https://docs.github.com/rest/reference/repos#update-pull-request-review-protection)
    ///
    /// ---
    pub async fn update_pull_request_review_protection_async(&self, owner: &str, repo: &str, branch: &str, body: PatchReposUpdatePullRequestReviewProtection) -> Result<ProtectedBranchPullRequestReview, ReposUpdatePullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdatePullRequestReviewProtection::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdatePullRequestReviewProtectionError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdatePullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
    /// 
    /// [GitHub API docs for update_pull_request_review_protection](https://docs.github.com/rest/reference/repos#update-pull-request-review-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_pull_request_review_protection(&self, owner: &str, repo: &str, branch: &str, body: PatchReposUpdatePullRequestReviewProtection) -> Result<ProtectedBranchPullRequestReview, ReposUpdatePullRequestReviewProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_pull_request_reviews", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdatePullRequestReviewProtection::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdatePullRequestReviewProtectionError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdatePullRequestReviewProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a release
    ///
    /// Users with push access to the repository can edit a release.
    /// 
    /// [GitHub API docs for update_release](https://docs.github.com/rest/reference/repos#update-a-release)
    ///
    /// ---
    pub async fn update_release_async(&self, owner: &str, repo: &str, release_id: i32, body: PatchReposUpdateRelease) -> Result<Release, ReposUpdateReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateRelease::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateReleaseError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a release
    ///
    /// Users with push access to the repository can edit a release.
    /// 
    /// [GitHub API docs for update_release](https://docs.github.com/rest/reference/repos#update-a-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_release(&self, owner: &str, repo: &str, release_id: i32, body: PatchReposUpdateRelease) -> Result<Release, ReposUpdateReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateRelease::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateReleaseError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a release asset
    ///
    /// Users with push access to the repository can edit a release asset.
    /// 
    /// [GitHub API docs for update_release_asset](https://docs.github.com/rest/reference/repos#update-a-release-asset)
    ///
    /// ---
    pub async fn update_release_asset_async(&self, owner: &str, repo: &str, asset_id: i32, body: PatchReposUpdateReleaseAsset) -> Result<ReleaseAsset, ReposUpdateReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateReleaseAsset::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a release asset
    ///
    /// Users with push access to the repository can edit a release asset.
    /// 
    /// [GitHub API docs for update_release_asset](https://docs.github.com/rest/reference/repos#update-a-release-asset)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_release_asset(&self, owner: &str, repo: &str, asset_id: i32, body: PatchReposUpdateReleaseAsset) -> Result<ReleaseAsset, ReposUpdateReleaseAssetError> {

        let request_uri = format!("{}/repos/{}/{}/releases/assets/{}", super::GITHUB_BASE_API_URL, owner, repo, asset_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateReleaseAsset::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for update_status_check_protection](https://docs.github.com/rest/reference/repos#update-status-check-protection)
    ///
    /// ---
    pub async fn update_status_check_protection_async(&self, owner: &str, repo: &str, branch: &str, body: PatchReposUpdateStatusCheckProtection) -> Result<StatusCheckPolicy, ReposUpdateStatusCheckProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateStatusCheckProtection::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateStatusCheckProtectionError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReposUpdateStatusCheckProtectionError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateStatusCheckProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    /// 
    /// Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
    /// 
    /// [GitHub API docs for update_status_check_protection](https://docs.github.com/rest/reference/repos#update-status-check-protection)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_status_check_protection(&self, owner: &str, repo: &str, branch: &str, body: PatchReposUpdateStatusCheckProtection) -> Result<StatusCheckPolicy, ReposUpdateStatusCheckProtectionError> {

        let request_uri = format!("{}/repos/{}/{}/branches/{}/protection/required_status_checks", super::GITHUB_BASE_API_URL, owner, repo, branch);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateStatusCheckProtection::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReposUpdateStatusCheckProtectionError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ReposUpdateStatusCheckProtectionError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateStatusCheckProtectionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository webhook
    ///
    /// Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/reference/repos#update-a-webhook-configuration-for-a-repository)."
    /// 
    /// [GitHub API docs for update_webhook](https://docs.github.com/rest/reference/repos#update-a-repository-webhook)
    ///
    /// ---
    pub async fn update_webhook_async(&self, owner: &str, repo: &str, hook_id: i32, body: PatchReposUpdateWebhook) -> Result<Hook, ReposUpdateWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateWebhook::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdateWebhookError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ReposUpdateWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReposUpdateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a repository webhook
    ///
    /// Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/reference/repos#update-a-webhook-configuration-for-a-repository)."
    /// 
    /// [GitHub API docs for update_webhook](https://docs.github.com/rest/reference/repos#update-a-repository-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_webhook(&self, owner: &str, repo: &str, hook_id: i32, body: PatchReposUpdateWebhook) -> Result<Hook, ReposUpdateWebhookError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateWebhook::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUpdateWebhookError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(ReposUpdateWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReposUpdateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for a repository
    ///
    /// Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/reference/orgs#update-a-repository-webhook)."
    /// 
    /// Access tokens must have the `write:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:write` permission.
    /// 
    /// [GitHub API docs for update_webhook_config_for_repo](https://docs.github.com/rest/reference/repos#update-a-webhook-configuration-for-a-repository)
    ///
    /// ---
    pub async fn update_webhook_config_for_repo_async(&self, owner: &str, repo: &str, hook_id: i32, body: PatchReposUpdateWebhookConfigForRepo) -> Result<WebhookConfig, ReposUpdateWebhookConfigForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateWebhookConfigForRepo::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateWebhookConfigForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for a repository
    ///
    /// Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/reference/orgs#update-a-repository-webhook)."
    /// 
    /// Access tokens must have the `write:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:write` permission.
    /// 
    /// [GitHub API docs for update_webhook_config_for_repo](https://docs.github.com/rest/reference/repos#update-a-webhook-configuration-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_webhook_config_for_repo(&self, owner: &str, repo: &str, hook_id: i32, body: PatchReposUpdateWebhookConfigForRepo) -> Result<WebhookConfig, ReposUpdateWebhookConfigForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, owner, repo, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchReposUpdateWebhookConfigForRepo::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReposUpdateWebhookConfigForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Upload a release asset
    ///
    /// This endpoint makes use of [a Hypermedia relation](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
    /// the response of the [Create a release endpoint](https://docs.github.com/rest/reference/repos#create-a-release) to upload a release asset.
    /// 
    /// You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
    /// 
    /// Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example: 
    /// 
    /// `application/zip`
    /// 
    /// GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
    /// you'll still need to pass your authentication to be able to upload an asset.
    /// 
    /// When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
    /// 
    /// **Notes:**
    /// *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List assets for a release](https://docs.github.com/rest/reference/repos#list-assets-for-a-release)"
    /// endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
    /// 
    /// [GitHub API docs for upload_release_asset](https://docs.github.com/rest/reference/repos#upload-a-release-asset)
    ///
    /// ---
    pub async fn upload_release_asset_async(&self, owner: &str, repo: &str, release_id: i32, query_params: impl Into<ReposUploadReleaseAssetParams<'api>>, body: String) -> Result<ReleaseAsset, ReposUploadReleaseAssetError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases/{}/assets", super::GITHUB_BASE_API_URL, owner, repo, release_id);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: Some(String::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUploadReleaseAssetError::Status422),
                code => Err(ReposUploadReleaseAssetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Upload a release asset
    ///
    /// This endpoint makes use of [a Hypermedia relation](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
    /// the response of the [Create a release endpoint](https://docs.github.com/rest/reference/repos#create-a-release) to upload a release asset.
    /// 
    /// You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
    /// 
    /// Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example: 
    /// 
    /// `application/zip`
    /// 
    /// GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
    /// you'll still need to pass your authentication to be able to upload an asset.
    /// 
    /// When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
    /// 
    /// **Notes:**
    /// *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List assets for a release](https://docs.github.com/rest/reference/repos#list-assets-for-a-release)"
    /// endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
    /// 
    /// [GitHub API docs for upload_release_asset](https://docs.github.com/rest/reference/repos#upload-a-release-asset)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn upload_release_asset(&self, owner: &str, repo: &str, release_id: i32, query_params: impl Into<ReposUploadReleaseAssetParams<'api>>, body: String) -> Result<ReleaseAsset, ReposUploadReleaseAssetError> {

        let mut request_uri = format!("{}/repos/{}/{}/releases/{}/assets", super::GITHUB_BASE_API_URL, owner, repo, release_id);

        request_uri.push_str("?");
        let qp: ReposUploadReleaseAssetParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: Some(String::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ReposUploadReleaseAssetError::Status422),
                code => Err(ReposUploadReleaseAssetError::Generic { code }),
            }
        }
    }

}
