//! Method, error and parameter types for the Reactions endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Reactions<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Reactions {
    Reactions { auth }
}

/// Errors for the [Create reaction for a commit comment](Reactions::create_for_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reaction created")]
    Status201(Reaction),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for an issue](Reactions::create_for_issue_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForIssueError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status201(Reaction),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for an issue comment](Reactions::create_for_issue_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForIssueCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reaction created")]
    Status201(Reaction),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a pull request review comment](Reactions::create_for_pull_request_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForPullRequestReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reaction created")]
    Status201(Reaction),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a release](Reactions::create_for_release_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForReleaseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reaction created")]
    Status201(Reaction),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a team discussion comment](Reactions::create_for_team_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForTeamDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status201(Reaction),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a team discussion comment (Legacy)](Reactions::create_for_team_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForTeamDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a team discussion](Reactions::create_for_team_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForTeamDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status201(Reaction),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create reaction for a team discussion (Legacy)](Reactions::create_for_team_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsCreateForTeamDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a commit comment reaction](Reactions::delete_for_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an issue reaction](Reactions::delete_for_issue_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForIssueError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an issue comment reaction](Reactions::delete_for_issue_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForIssueCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a pull request comment reaction](Reactions::delete_for_pull_request_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForPullRequestCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete team discussion reaction](Reactions::delete_for_team_discussion_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForTeamDiscussionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete team discussion comment reaction](Reactions::delete_for_team_discussion_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteForTeamDiscussionCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a reaction (Legacy)](Reactions::delete_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsDeleteLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a commit comment](Reactions::list_for_commit_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForCommitCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for an issue](Reactions::list_for_issue_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForIssueError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for an issue comment](Reactions::list_for_issue_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForIssueCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a pull request review comment](Reactions::list_for_pull_request_review_comment_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForPullRequestReviewCommentError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a team discussion comment](Reactions::list_for_team_discussion_comment_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForTeamDiscussionCommentInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a team discussion comment (Legacy)](Reactions::list_for_team_discussion_comment_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForTeamDiscussionCommentLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a team discussion](Reactions::list_for_team_discussion_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForTeamDiscussionInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List reactions for a team discussion (Legacy)](Reactions::list_for_team_discussion_legacy_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ReactionsListForTeamDiscussionLegacyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List reactions for a commit comment](Reactions::list_for_commit_comment_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForCommitCommentParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a commit comment.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForCommitCommentParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a commit comment.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForCommitCommentParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for an issue](Reactions::list_for_issue_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForIssueParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForIssueParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForIssueParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for an issue comment](Reactions::list_for_issue_comment_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForIssueCommentParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue comment.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForIssueCommentParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue comment.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForIssueCommentParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for a pull request review comment](Reactions::list_for_pull_request_review_comment_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForPullRequestReviewCommentParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForPullRequestReviewCommentParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForPullRequestReviewCommentParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for a team discussion comment](Reactions::list_for_team_discussion_comment_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForTeamDiscussionCommentInOrgParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForTeamDiscussionCommentInOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForTeamDiscussionCommentInOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for a team discussion comment (Legacy)](Reactions::list_for_team_discussion_comment_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForTeamDiscussionCommentLegacyParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForTeamDiscussionCommentLegacyParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForTeamDiscussionCommentLegacyParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for a team discussion](Reactions::list_for_team_discussion_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForTeamDiscussionInOrgParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForTeamDiscussionInOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForTeamDiscussionInOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List reactions for a team discussion (Legacy)](Reactions::list_for_team_discussion_legacy_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ReactionsListForTeamDiscussionLegacyParams<'req> {
    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
    content: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ReactionsListForTeamDiscussionLegacyParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
    pub fn content(self, content: &'req str) -> Self {
        Self { 
            content: Some(content),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            content: self.content, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ReactionsListForTeamDiscussionLegacyParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Reactions<'api> {
    /// ---
    ///
    /// # Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    /// 
    /// [GitHub API docs for create_for_commit_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-commit-comment)
    ///
    /// ---
    pub async fn create_for_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForCommitComment) -> Result<Reaction, ReactionsCreateForCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForCommitComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForCommitCommentError::Status201(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(ReactionsCreateForCommitCommentError::Status415(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReactionsCreateForCommitCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    /// 
    /// [GitHub API docs for create_for_commit_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_commit_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForCommitComment) -> Result<Reaction, ReactionsCreateForCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForCommitComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForCommitCommentError::Status201(crate::adapters::to_json(github_response)?)),
                415 => Err(ReactionsCreateForCommitCommentError::Status415(crate::adapters::to_json(github_response)?)),
                422 => Err(ReactionsCreateForCommitCommentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/reference/issues/). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    /// 
    /// [GitHub API docs for create_for_issue](https://docs.github.com/rest/reference/reactions#create-reaction-for-an-issue)
    ///
    /// ---
    pub async fn create_for_issue_async(&self, owner: &str, repo: &str, issue_number: i32, body: PostReactionsCreateForIssue) -> Result<Reaction, ReactionsCreateForIssueError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForIssue::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForIssueError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReactionsCreateForIssueError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/reference/issues/). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    /// 
    /// [GitHub API docs for create_for_issue](https://docs.github.com/rest/reference/reactions#create-reaction-for-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_issue(&self, owner: &str, repo: &str, issue_number: i32, body: PostReactionsCreateForIssue) -> Result<Reaction, ReactionsCreateForIssueError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, issue_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForIssue::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForIssueError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(ReactionsCreateForIssueError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    /// 
    /// [GitHub API docs for create_for_issue_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-an-issue-comment)
    ///
    /// ---
    pub async fn create_for_issue_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForIssueComment) -> Result<Reaction, ReactionsCreateForIssueCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForIssueComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForIssueCommentError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReactionsCreateForIssueCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    /// 
    /// [GitHub API docs for create_for_issue_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-an-issue-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_issue_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForIssueComment) -> Result<Reaction, ReactionsCreateForIssueCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForIssueComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForIssueCommentError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(ReactionsCreateForIssueCommentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#comments). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    /// 
    /// [GitHub API docs for create_for_pull_request_review_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-pull-request-review-comment)
    ///
    /// ---
    pub async fn create_for_pull_request_review_comment_async(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForPullRequestReviewComment) -> Result<Reaction, ReactionsCreateForPullRequestReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForPullRequestReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForPullRequestReviewCommentError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReactionsCreateForPullRequestReviewCommentError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForPullRequestReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#comments). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    /// 
    /// [GitHub API docs for create_for_pull_request_review_comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-pull-request-review-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_pull_request_review_comment(&self, owner: &str, repo: &str, comment_id: i32, body: PostReactionsCreateForPullRequestReviewComment) -> Result<Reaction, ReactionsCreateForPullRequestReviewCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForPullRequestReviewComment::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForPullRequestReviewCommentError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(ReactionsCreateForPullRequestReviewCommentError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForPullRequestReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/reference/repos#releases). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    /// 
    /// [GitHub API docs for create_for_release](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-release)
    ///
    /// ---
    pub async fn create_for_release_async(&self, owner: &str, repo: &str, release_id: i32, body: PostReactionsCreateForRelease) -> Result<Reaction, ReactionsCreateForReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForRelease::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForReleaseError::Status201(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ReactionsCreateForReleaseError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/reference/repos#releases). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    /// 
    /// [GitHub API docs for create_for_release](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-release)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_release(&self, owner: &str, repo: &str, release_id: i32, body: PostReactionsCreateForRelease) -> Result<Reaction, ReactionsCreateForReleaseError> {

        let request_uri = format!("{}/repos/{}/{}/releases/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, release_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForRelease::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForReleaseError::Status201(crate::adapters::to_json(github_response)?)),
                422 => Err(ReactionsCreateForReleaseError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForReleaseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    /// 
    /// [GitHub API docs for create_for_team_discussion_comment_in_org](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)
    ///
    /// ---
    pub async fn create_for_team_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, body: PostReactionsCreateForTeamDiscussionCommentInOrg) -> Result<Reaction, ReactionsCreateForTeamDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionCommentInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForTeamDiscussionCommentInOrgError::Status201(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForTeamDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    /// 
    /// [GitHub API docs for create_for_team_discussion_comment_in_org](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_team_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, body: PostReactionsCreateForTeamDiscussionCommentInOrg) -> Result<Reaction, ReactionsCreateForTeamDiscussionCommentInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionCommentInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForTeamDiscussionCommentInOrgError::Status201(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForTeamDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    /// 
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    /// 
    /// [GitHub API docs for create_for_team_discussion_comment_legacy](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-team-discussion-comment-legacy)
    ///
    /// ---
    pub async fn create_for_team_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, comment_number: i32, body: PostReactionsCreateForTeamDiscussionCommentLegacy) -> Result<Reaction, ReactionsCreateForTeamDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionCommentLegacy::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsCreateForTeamDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    /// 
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    /// 
    /// [GitHub API docs for create_for_team_discussion_comment_legacy](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-team-discussion-comment-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_team_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, comment_number: i32, body: PostReactionsCreateForTeamDiscussionCommentLegacy) -> Result<Reaction, ReactionsCreateForTeamDiscussionCommentLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionCommentLegacy::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsCreateForTeamDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    /// 
    /// [GitHub API docs for create_for_team_discussion_in_org](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion)
    ///
    /// ---
    pub async fn create_for_team_discussion_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, body: PostReactionsCreateForTeamDiscussionInOrg) -> Result<Reaction, ReactionsCreateForTeamDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForTeamDiscussionInOrgError::Status201(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsCreateForTeamDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    /// 
    /// [GitHub API docs for create_for_team_discussion_in_org](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_team_discussion_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, body: PostReactionsCreateForTeamDiscussionInOrg) -> Result<Reaction, ReactionsCreateForTeamDiscussionInOrgError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionInOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                201 => Err(ReactionsCreateForTeamDiscussionInOrgError::Status201(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsCreateForTeamDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion) endpoint.
    /// 
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    /// 
    /// [GitHub API docs for create_for_team_discussion_legacy](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-team-discussion-legacy)
    ///
    /// ---
    pub async fn create_for_team_discussion_legacy_async(&self, team_id: i32, discussion_number: i32, body: PostReactionsCreateForTeamDiscussionLegacy) -> Result<Reaction, ReactionsCreateForTeamDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionLegacy::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsCreateForTeamDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create reaction for a team discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion) endpoint.
    /// 
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    /// 
    /// [GitHub API docs for create_for_team_discussion_legacy](https://docs.github.com/rest/reference/reactions/#create-reaction-for-a-team-discussion-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_team_discussion_legacy(&self, team_id: i32, discussion_number: i32, body: PostReactionsCreateForTeamDiscussionLegacy) -> Result<Reaction, ReactionsCreateForTeamDiscussionLegacyError> {

        let request_uri = format!("{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostReactionsCreateForTeamDiscussionLegacy::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsCreateForTeamDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a commit comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
    /// 
    /// [GitHub API docs for delete_for_commit_comment](https://docs.github.com/rest/reference/reactions#delete-a-commit-comment-reaction)
    ///
    /// ---
    pub async fn delete_for_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a commit comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
    /// 
    /// [GitHub API docs for delete_for_commit_comment](https://docs.github.com/rest/reference/reactions#delete-a-commit-comment-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_commit_comment(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForCommitCommentError> {

        let request_uri = format!("{}/repos/{}/{}/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to an [issue](https://docs.github.com/rest/reference/issues/).
    /// 
    /// [GitHub API docs for delete_for_issue](https://docs.github.com/rest/reference/reactions#delete-an-issue-reaction)
    ///
    /// ---
    pub async fn delete_for_issue_async(&self, owner: &str, repo: &str, issue_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForIssueError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to an [issue](https://docs.github.com/rest/reference/issues/).
    /// 
    /// [GitHub API docs for delete_for_issue](https://docs.github.com/rest/reference/reactions#delete-an-issue-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_issue(&self, owner: &str, repo: &str, issue_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForIssueError> {

        let request_uri = format!("{}/repos/{}/{}/issues/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, issue_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
    /// 
    /// [GitHub API docs for delete_for_issue_comment](https://docs.github.com/rest/reference/reactions#delete-an-issue-comment-reaction)
    ///
    /// ---
    pub async fn delete_for_issue_comment_async(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForIssueCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an issue comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
    /// 
    /// [GitHub API docs for delete_for_issue_comment](https://docs.github.com/rest/reference/reactions#delete-an-issue-comment-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_issue_comment(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForIssueCommentError> {

        let request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a pull request comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    /// 
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
    /// 
    /// [GitHub API docs for delete_for_pull_request_comment](https://docs.github.com/rest/reference/reactions#delete-a-pull-request-comment-reaction)
    ///
    /// ---
    pub async fn delete_for_pull_request_comment_async(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForPullRequestCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForPullRequestCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a pull request comment reaction
    ///
    /// **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    /// 
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
    /// 
    /// [GitHub API docs for delete_for_pull_request_comment](https://docs.github.com/rest/reference/reactions#delete-a-pull-request-comment-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_pull_request_comment(&self, owner: &str, repo: &str, comment_id: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForPullRequestCommentError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, owner, repo, comment_id, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForPullRequestCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete team discussion reaction
    ///
    /// **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_for_team_discussion](https://docs.github.com/rest/reference/reactions#delete-team-discussion-reaction)
    ///
    /// ---
    pub async fn delete_for_team_discussion_async(&self, org: &str, team_slug: &str, discussion_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForTeamDiscussionError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForTeamDiscussionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete team discussion reaction
    ///
    /// **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_for_team_discussion](https://docs.github.com/rest/reference/reactions#delete-team-discussion-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_team_discussion(&self, org: &str, team_slug: &str, discussion_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForTeamDiscussionError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForTeamDiscussionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete team discussion comment reaction
    ///
    /// **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_for_team_discussion_comment](https://docs.github.com/rest/reference/reactions#delete-team-discussion-comment-reaction)
    ///
    /// ---
    pub async fn delete_for_team_discussion_comment_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForTeamDiscussionCommentError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForTeamDiscussionCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete team discussion comment reaction
    ///
    /// **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    /// 
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for delete_for_team_discussion_comment](https://docs.github.com/rest/reference/reactions#delete-team-discussion-comment-reaction)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_team_discussion_comment(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, reaction_id: i32) -> Result<(), ReactionsDeleteForTeamDiscussionCommentError> {

        let request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions/{}", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsDeleteForTeamDiscussionCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a reaction (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Reactions API. We recommend migrating your existing code to use the new delete reactions endpoints. For more information, see this [blog post](https://developer.github.com/changes/2020-02-26-new-delete-reactions-endpoints/).
    /// 
    /// OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), when deleting a [team discussion](https://docs.github.com/rest/reference/teams#discussions) or [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments).
    /// 
    /// [GitHub API docs for delete_legacy](https://docs.github.com/rest/reference/reactions/#delete-a-reaction-legacy)
    ///
    /// ---
    pub async fn delete_legacy_async(&self, reaction_id: i32) -> Result<(), ReactionsDeleteLegacyError> {

        let request_uri = format!("{}/reactions/{}", super::GITHUB_BASE_API_URL, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ReactionsDeleteLegacyError::Status304),
                403 => Err(ReactionsDeleteLegacyError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ReactionsDeleteLegacyError::Status401(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ReactionsDeleteLegacyError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsDeleteLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a reaction (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Reactions API. We recommend migrating your existing code to use the new delete reactions endpoints. For more information, see this [blog post](https://developer.github.com/changes/2020-02-26-new-delete-reactions-endpoints/).
    /// 
    /// OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), when deleting a [team discussion](https://docs.github.com/rest/reference/teams#discussions) or [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments).
    /// 
    /// [GitHub API docs for delete_legacy](https://docs.github.com/rest/reference/reactions/#delete-a-reaction-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_legacy(&self, reaction_id: i32) -> Result<(), ReactionsDeleteLegacyError> {

        let request_uri = format!("{}/reactions/{}", super::GITHUB_BASE_API_URL, reaction_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ReactionsDeleteLegacyError::Status304),
                403 => Err(ReactionsDeleteLegacyError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ReactionsDeleteLegacyError::Status401(crate::adapters::to_json(github_response)?)),
                410 => Err(ReactionsDeleteLegacyError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsDeleteLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
    /// 
    /// [GitHub API docs for list_for_commit_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-commit-comment)
    ///
    /// ---
    pub async fn list_for_commit_comment_async(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForCommitCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForCommitCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForCommitCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsListForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
    /// 
    /// [GitHub API docs for list_for_commit_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-commit-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_commit_comment(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForCommitCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForCommitCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForCommitCommentParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForCommitCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsListForCommitCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/reference/issues).
    /// 
    /// [GitHub API docs for list_for_issue](https://docs.github.com/rest/reference/reactions#list-reactions-for-an-issue)
    ///
    /// ---
    pub async fn list_for_issue_async(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<ReactionsListForIssueParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForIssueError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForIssueError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ReactionsListForIssueError::Status410(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsListForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/reference/issues).
    /// 
    /// [GitHub API docs for list_for_issue](https://docs.github.com/rest/reference/reactions#list-reactions-for-an-issue)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_issue(&self, owner: &str, repo: &str, issue_number: i32, query_params: Option<impl Into<ReactionsListForIssueParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForIssueError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, issue_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForIssueParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForIssueError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(ReactionsListForIssueError::Status410(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsListForIssueError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
    /// 
    /// [GitHub API docs for list_for_issue_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-an-issue-comment)
    ///
    /// ---
    pub async fn list_for_issue_comment_async(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForIssueCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForIssueCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForIssueCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsListForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
    /// 
    /// [GitHub API docs for list_for_issue_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-an-issue-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_issue_comment(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForIssueCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForIssueCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/issues/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForIssueCommentParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForIssueCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsListForIssueCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
    /// 
    /// [GitHub API docs for list_for_pull_request_review_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-pull-request-review-comment)
    ///
    /// ---
    pub async fn list_for_pull_request_review_comment_async(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForPullRequestReviewCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForPullRequestReviewCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForPullRequestReviewCommentError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ReactionsListForPullRequestReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
    /// 
    /// [GitHub API docs for list_for_pull_request_review_comment](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-pull-request-review-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_pull_request_review_comment(&self, owner: &str, repo: &str, comment_id: i32, query_params: Option<impl Into<ReactionsListForPullRequestReviewCommentParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForPullRequestReviewCommentError> {

        let mut request_uri = format!("{}/repos/{}/{}/pulls/comments/{}/reactions", super::GITHUB_BASE_API_URL, owner, repo, comment_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForPullRequestReviewCommentParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ReactionsListForPullRequestReviewCommentError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ReactionsListForPullRequestReviewCommentError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments/). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    /// 
    /// [GitHub API docs for list_for_team_discussion_comment_in_org](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment)
    ///
    /// ---
    pub async fn list_for_team_discussion_comment_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionCommentInOrgParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionCommentInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments/). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    /// 
    /// [GitHub API docs for list_for_team_discussion_comment_in_org](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_team_discussion_comment_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, comment_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionCommentInOrgParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionCommentInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number, comment_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForTeamDiscussionCommentInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionCommentInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    /// 
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_team_discussion_comment_legacy](https://docs.github.com/rest/reference/reactions/#list-reactions-for-a-team-discussion-comment-legacy)
    ///
    /// ---
    pub async fn list_for_team_discussion_comment_legacy_async(&self, team_id: i32, discussion_number: i32, comment_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionCommentLegacyParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionCommentLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion comment (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    /// 
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_team_discussion_comment_legacy](https://docs.github.com/rest/reference/reactions/#list-reactions-for-a-team-discussion-comment-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_team_discussion_comment_legacy(&self, team_id: i32, discussion_number: i32, comment_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionCommentLegacyParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionCommentLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/comments/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number, comment_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForTeamDiscussionCommentLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionCommentLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    /// 
    /// [GitHub API docs for list_for_team_discussion_in_org](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion)
    ///
    /// ---
    pub async fn list_for_team_discussion_in_org_async(&self, org: &str, team_slug: &str, discussion_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionInOrgParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    /// 
    /// [GitHub API docs for list_for_team_discussion_in_org](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_team_discussion_in_org(&self, org: &str, team_slug: &str, discussion_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionInOrgParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, org, team_slug, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForTeamDiscussionInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion) endpoint.
    /// 
    /// List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_team_discussion_legacy](https://docs.github.com/rest/reference/reactions/#list-reactions-for-a-team-discussion-legacy)
    ///
    /// ---
    pub async fn list_for_team_discussion_legacy_async(&self, team_id: i32, discussion_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionLegacyParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionLegacyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List reactions for a team discussion (Legacy)
    ///
    /// **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion) endpoint.
    /// 
    /// List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
    /// 
    /// [GitHub API docs for list_for_team_discussion_legacy](https://docs.github.com/rest/reference/reactions/#list-reactions-for-a-team-discussion-legacy)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_team_discussion_legacy(&self, team_id: i32, discussion_number: i32, query_params: Option<impl Into<ReactionsListForTeamDiscussionLegacyParams<'api>>>) -> Result<Vec<Reaction>, ReactionsListForTeamDiscussionLegacyError> {

        let mut request_uri = format!("{}/teams/{}/discussions/{}/reactions", super::GITHUB_BASE_API_URL, team_id, discussion_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ReactionsListForTeamDiscussionLegacyParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ReactionsListForTeamDiscussionLegacyError::Generic { code }),
            }
        }
    }

}
