//! Method, error and parameter types for the Interactions endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Interactions<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Interactions {
    Interactions { auth }
}

/// Errors for the [Get interaction restrictions for your public repositories](Interactions::get_restrictions_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsGetRestrictionsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when there are no restrictions")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get interaction restrictions for an organization](Interactions::get_restrictions_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsGetRestrictionsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get interaction restrictions for a repository](Interactions::get_restrictions_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsGetRestrictionsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove interaction restrictions from your public repositories](Interactions::remove_restrictions_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsRemoveRestrictionsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove interaction restrictions for an organization](Interactions::remove_restrictions_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsRemoveRestrictionsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove interaction restrictions for a repository](Interactions::remove_restrictions_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsRemoveRestrictionsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status409,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set interaction restrictions for your public repositories](Interactions::set_restrictions_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsSetRestrictionsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set interaction restrictions for an organization](Interactions::set_restrictions_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsSetRestrictionsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set interaction restrictions for a repository](Interactions::set_restrictions_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum InteractionsSetRestrictionsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status409,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}



impl<'api> Interactions<'api> {
    /// ---
    ///
    /// # Get interaction restrictions for your public repositories
    ///
    /// Shows which type of GitHub user can interact with your public repositories and when the restriction expires.
    /// 
    /// [GitHub API docs for get_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-your-public-repositories)
    ///
    /// ---
    pub async fn get_restrictions_for_authenticated_user_async(&self) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(InteractionsGetRestrictionsForAuthenticatedUserError::Status204),
                code => Err(InteractionsGetRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get interaction restrictions for your public repositories
    ///
    /// Shows which type of GitHub user can interact with your public repositories and when the restriction expires.
    /// 
    /// [GitHub API docs for get_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-your-public-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_restrictions_for_authenticated_user(&self) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(InteractionsGetRestrictionsForAuthenticatedUserError::Status204),
                code => Err(InteractionsGetRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get interaction restrictions for an organization
    ///
    /// Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
    /// 
    /// [GitHub API docs for get_restrictions_for_org](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-an-organization)
    ///
    /// ---
    pub async fn get_restrictions_for_org_async(&self, org: &str) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsGetRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get interaction restrictions for an organization
    ///
    /// Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
    /// 
    /// [GitHub API docs for get_restrictions_for_org](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_restrictions_for_org(&self, org: &str) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsGetRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get interaction restrictions for a repository
    ///
    /// Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
    /// 
    /// [GitHub API docs for get_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-a-repository)
    ///
    /// ---
    pub async fn get_restrictions_for_repo_async(&self, owner: &str, repo: &str) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsGetRestrictionsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get interaction restrictions for a repository
    ///
    /// Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
    /// 
    /// [GitHub API docs for get_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#get-interaction-restrictions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_restrictions_for_repo(&self, owner: &str, repo: &str) -> Result<GetInteractionsGetRestrictionsForAuthenticatedUserResponse200, InteractionsGetRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsGetRestrictionsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions from your public repositories
    ///
    /// Removes any interaction restrictions from your public repositories.
    /// 
    /// [GitHub API docs for remove_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-from-your-public-repositories)
    ///
    /// ---
    pub async fn remove_restrictions_for_authenticated_user_async(&self) -> Result<(), InteractionsRemoveRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsRemoveRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions from your public repositories
    ///
    /// Removes any interaction restrictions from your public repositories.
    /// 
    /// [GitHub API docs for remove_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-from-your-public-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_restrictions_for_authenticated_user(&self) -> Result<(), InteractionsRemoveRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsRemoveRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions for an organization
    ///
    /// Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
    /// 
    /// [GitHub API docs for remove_restrictions_for_org](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-for-an-organization)
    ///
    /// ---
    pub async fn remove_restrictions_for_org_async(&self, org: &str) -> Result<(), InteractionsRemoveRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsRemoveRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions for an organization
    ///
    /// Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
    /// 
    /// [GitHub API docs for remove_restrictions_for_org](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_restrictions_for_org(&self, org: &str) -> Result<(), InteractionsRemoveRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(InteractionsRemoveRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions for a repository
    ///
    /// Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    /// 
    /// [GitHub API docs for remove_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-for-a-repository)
    ///
    /// ---
    pub async fn remove_restrictions_for_repo_async(&self, owner: &str, repo: &str) -> Result<(), InteractionsRemoveRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(InteractionsRemoveRestrictionsForRepoError::Status409),
                code => Err(InteractionsRemoveRestrictionsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove interaction restrictions for a repository
    ///
    /// Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    /// 
    /// [GitHub API docs for remove_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#remove-interaction-restrictions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_restrictions_for_repo(&self, owner: &str, repo: &str) -> Result<(), InteractionsRemoveRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(InteractionsRemoveRestrictionsForRepoError::Status409),
                code => Err(InteractionsRemoveRestrictionsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for your public repositories
    ///
    /// Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
    /// 
    /// [GitHub API docs for set_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-your-public-repositories)
    ///
    /// ---
    pub async fn set_restrictions_for_authenticated_user_async(&self, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(InteractionsSetRestrictionsForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(InteractionsSetRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for your public repositories
    ///
    /// Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
    /// 
    /// [GitHub API docs for set_restrictions_for_authenticated_user](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-your-public-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_restrictions_for_authenticated_user(&self, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForAuthenticatedUserError> {

        let request_uri = format!("{}/user/interaction-limits", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(InteractionsSetRestrictionsForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(InteractionsSetRestrictionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for an organization
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
    /// 
    /// [GitHub API docs for set_restrictions_for_org](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-an-organization)
    ///
    /// ---
    pub async fn set_restrictions_for_org_async(&self, org: &str, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(InteractionsSetRestrictionsForOrgError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(InteractionsSetRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for an organization
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
    /// 
    /// [GitHub API docs for set_restrictions_for_org](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_restrictions_for_org(&self, org: &str, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForOrgError> {

        let request_uri = format!("{}/orgs/{}/interaction-limits", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(InteractionsSetRestrictionsForOrgError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(InteractionsSetRestrictionsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for a repository
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    /// 
    /// [GitHub API docs for set_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-a-repository)
    ///
    /// ---
    pub async fn set_restrictions_for_repo_async(&self, owner: &str, repo: &str, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(InteractionsSetRestrictionsForRepoError::Status409),
                code => Err(InteractionsSetRestrictionsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set interaction restrictions for a repository
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    /// 
    /// [GitHub API docs for set_restrictions_for_repo](https://docs.github.com/rest/reference/interactions#set-interaction-restrictions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_restrictions_for_repo(&self, owner: &str, repo: &str, body: PutInteractionsSetRestrictionsForAuthenticatedUser) -> Result<InteractionLimitResponse, InteractionsSetRestrictionsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/interaction-limits", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutInteractionsSetRestrictionsForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(InteractionsSetRestrictionsForRepoError::Status409),
                code => Err(InteractionsSetRestrictionsForRepoError::Generic { code }),
            }
        }
    }

}
