//! Method, error and parameter types for the Codespaces endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Codespaces<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Codespaces {
    Codespaces { auth }
}

/// Errors for the [Add a selected repository to a user secret](Codespaces::add_repository_for_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesAddRepositoryForSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List machine types for a codespace](Codespaces::codespace_machines_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesCodespaceMachinesForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a codespace for the authenticated user](Codespaces::create_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesCreateForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when the codespace creation partially failed but is being retried in the background")]
    Status202(Codespace),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update a secret for the authenticated user](Codespaces::create_or_update_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesCreateOrUpdateSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response after successfully updating a secret")]
    Status204,
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a codespace from a pull request](Codespaces::create_with_pr_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesCreateWithPrForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when the codespace creation partially failed but is being retried in the background")]
    Status202(Codespace),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a codespace in a repository](Codespaces::create_with_repo_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesCreateWithRepoForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when the codespace creation partially failed but is being retried in the background")]
    Status202(Codespace),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a codespace for the authenticated user](Codespaces::delete_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesDeleteForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a secret for the authenticated user](Codespaces::delete_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesDeleteSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a codespace for the authenticated user](Codespaces::get_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesGetForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get public key for the authenticated user](Codespaces::get_public_key_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesGetPublicKeyForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a secret for the authenticated user](Codespaces::get_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesGetSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List codespaces for the authenticated user](Codespaces::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List codespaces in a repository for the authenticated user](Codespaces::list_in_repository_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesListInRepositoryForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List selected repositories for a user secret](Codespaces::list_repositories_for_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesListRepositoriesForSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List secrets for the authenticated user](Codespaces::list_secrets_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesListSecretsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a selected repository from a user secret](Codespaces::remove_repository_for_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesRemoveRepositoryForSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List available machine types for a repository](Codespaces::repo_machines_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesRepoMachinesForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set selected repositories for a user secret](Codespaces::set_repositories_for_secret_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesSetRepositoriesForSecretForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Start a codespace for the authenticated user](Codespaces::start_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesStartForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Payment required")]
    Status402(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Stop a codespace for the authenticated user](Codespaces::stop_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesStopForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Internal Error")]
    Status500(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a codespace for the authenticated user](Codespaces::update_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum CodespacesUpdateForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List codespaces for the authenticated user](Codespaces::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodespacesListForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// ID of the Repository to filter on
    repository_id: Option<i32>
}

impl CodespacesListForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
            repository_id: self.repository_id, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
            repository_id: self.repository_id, 
        }
    }

    /// ID of the Repository to filter on
    pub fn repository_id(self, repository_id: i32) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            repository_id: Some(repository_id),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodespacesListForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List codespaces in a repository for the authenticated user](Codespaces::list_in_repository_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodespacesListInRepositoryForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl CodespacesListInRepositoryForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodespacesListInRepositoryForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List secrets for the authenticated user](Codespaces::list_secrets_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodespacesListSecretsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl CodespacesListSecretsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for CodespacesListSecretsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List available machine types for a repository](Codespaces::repo_machines_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct CodespacesRepoMachinesForAuthenticatedUserParams<'req> {
    /// Required. The location to check for available machines.
    location: &'req str
}

impl<'req> CodespacesRepoMachinesForAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Required. The location to check for available machines.
    pub fn location(self, location: &'req str) -> Self {
        Self { 
            location: location,
        }
    }
}


impl<'api> Codespaces<'api> {
    /// ---
    ///
    /// # Add a selected repository to a user secret
    ///
    /// Adds a repository to the selected repositories for a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for add_repository_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#add-a-selected-repository-to-a-user-secret)
    ///
    /// ---
    pub async fn add_repository_for_secret_for_authenticated_user_async(&self, secret_name: &str, repository_id: i32) -> Result<(), CodespacesAddRepositoryForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a selected repository to a user secret
    ///
    /// Adds a repository to the selected repositories for a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for add_repository_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#add-a-selected-repository-to-a-user-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_repository_for_secret_for_authenticated_user(&self, secret_name: &str, repository_id: i32) -> Result<(), CodespacesAddRepositoryForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                500 => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesAddRepositoryForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List machine types for a codespace
    ///
    /// List the machine types a codespace can transition to use.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for codespace_machines_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-machine-types-for-a-codespace)
    ///
    /// ---
    pub async fn codespace_machines_for_authenticated_user_async(&self, codespace_name: &str) -> Result<GetCodespacesCodespaceMachinesForAuthenticatedUserResponse200, CodespacesCodespaceMachinesForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/machines", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status304),
                500 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List machine types for a codespace
    ///
    /// List the machine types a codespace can transition to use.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for codespace_machines_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-machine-types-for-a-codespace)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn codespace_machines_for_authenticated_user(&self, codespace_name: &str) -> Result<GetCodespacesCodespaceMachinesForAuthenticatedUserResponse200, CodespacesCodespaceMachinesForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/machines", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status304),
                500 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesCodespaceMachinesForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace for the authenticated user
    ///
    /// Creates a new codespace, owned by the authenticated user.
    /// 
    /// This endpoint requires either a `repository_id` OR a `pull_request` but not both.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn create_for_authenticated_user_async(&self, body: PostCodespacesCreateForAuthenticatedUser) -> Result<Codespace, CodespacesCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateForAuthenticatedUserError::Status202(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesCreateForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesCreateForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesCreateForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace for the authenticated user
    ///
    /// Creates a new codespace, owned by the authenticated user.
    /// 
    /// This endpoint requires either a `repository_id` OR a `pull_request` but not both.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_authenticated_user(&self, body: PostCodespacesCreateForAuthenticatedUser) -> Result<Codespace, CodespacesCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateForAuthenticatedUserError::Status202(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesCreateForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesCreateForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesCreateForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update a secret for the authenticated user
    ///
    /// Creates or updates a secret for a user's codespace with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access token with the `user` scope to use this endpoint. User must also have Codespaces access to use this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-or-update-a-secret-for-the-authenticated-user)
    ///
    /// ---
    pub async fn create_or_update_secret_for_authenticated_user_async(&self, secret_name: &str, body: PutCodespacesCreateOrUpdateSecretForAuthenticatedUser) -> Result<HashMap<String, Value>, CodespacesCreateOrUpdateSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutCodespacesCreateOrUpdateSecretForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status204),
                422 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update a secret for the authenticated user
    ///
    /// Creates or updates a secret for a user's codespace with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access token with the `user` scope to use this endpoint. User must also have Codespaces access to use this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-or-update-a-secret-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_secret_for_authenticated_user(&self, secret_name: &str, body: PutCodespacesCreateOrUpdateSecretForAuthenticatedUser) -> Result<HashMap<String, Value>, CodespacesCreateOrUpdateSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutCodespacesCreateOrUpdateSecretForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status204),
                422 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesCreateOrUpdateSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace from a pull request
    ///
    /// Creates a codespace owned by the authenticated user for the specified pull request.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_with_pr_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-from-a-pull-request)
    ///
    /// ---
    pub async fn create_with_pr_for_authenticated_user_async(&self, owner: &str, repo: &str, pull_number: i32, body: PostCodespacesCreateWithPrForAuthenticatedUser) -> Result<Codespace, CodespacesCreateWithPrForAuthenticatedUserError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateWithPrForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status202(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesCreateWithPrForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace from a pull request
    ///
    /// Creates a codespace owned by the authenticated user for the specified pull request.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_with_pr_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-from-a-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_with_pr_for_authenticated_user(&self, owner: &str, repo: &str, pull_number: i32, body: PostCodespacesCreateWithPrForAuthenticatedUser) -> Result<Codespace, CodespacesCreateWithPrForAuthenticatedUserError> {

        let request_uri = format!("{}/repos/{}/{}/pulls/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo, pull_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateWithPrForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status202(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesCreateWithPrForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesCreateWithPrForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace in a repository
    ///
    /// Creates a codespace owned by the authenticated user in the specified repository.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_with_repo_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-in-a-repository)
    ///
    /// ---
    pub async fn create_with_repo_for_authenticated_user_async(&self, owner: &str, repo: &str, body: PostCodespacesCreateWithRepoForAuthenticatedUser) -> Result<Codespace, CodespacesCreateWithRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/repos/{}/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateWithRepoForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status202(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a codespace in a repository
    ///
    /// Creates a codespace owned by the authenticated user in the specified repository.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_with_repo_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#create-a-codespace-in-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_with_repo_for_authenticated_user(&self, owner: &str, repo: &str, body: PostCodespacesCreateWithRepoForAuthenticatedUser) -> Result<Codespace, CodespacesCreateWithRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/repos/{}/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostCodespacesCreateWithRepoForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                202 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status202(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesCreateWithRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a codespace for the authenticated user
    ///
    /// Deletes a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#delete-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_for_authenticated_user_async(&self, codespace_name: &str) -> Result<HashMap<String, Value>, CodespacesDeleteForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesDeleteForAuthenticatedUserError::Status304),
                500 => Err(CodespacesDeleteForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesDeleteForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesDeleteForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesDeleteForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesDeleteForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a codespace for the authenticated user
    ///
    /// Deletes a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#delete-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_for_authenticated_user(&self, codespace_name: &str) -> Result<HashMap<String, Value>, CodespacesDeleteForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesDeleteForAuthenticatedUserError::Status304),
                500 => Err(CodespacesDeleteForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesDeleteForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesDeleteForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesDeleteForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesDeleteForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a secret for the authenticated user
    ///
    /// Deletes a secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret. You must authenticate using an access token with the `user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for delete_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#delete-a-secret-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_secret_for_authenticated_user_async(&self, secret_name: &str) -> Result<(), CodespacesDeleteSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesDeleteSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a secret for the authenticated user
    ///
    /// Deletes a secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret. You must authenticate using an access token with the `user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for delete_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#delete-a-secret-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_secret_for_authenticated_user(&self, secret_name: &str) -> Result<(), CodespacesDeleteSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesDeleteSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a codespace for the authenticated user
    ///
    /// Gets information about a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_for_authenticated_user_async(&self, codespace_name: &str) -> Result<Codespace, CodespacesGetForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesGetForAuthenticatedUserError::Status304),
                500 => Err(CodespacesGetForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesGetForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesGetForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesGetForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesGetForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a codespace for the authenticated user
    ///
    /// Gets information about a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_for_authenticated_user(&self, codespace_name: &str) -> Result<Codespace, CodespacesGetForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesGetForAuthenticatedUserError::Status304),
                500 => Err(CodespacesGetForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesGetForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesGetForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesGetForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesGetForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get public key for the authenticated user
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with one of the 'read:user' or 'user' scopes in their personal access token. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for get_public_key_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-public-key-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_public_key_for_authenticated_user_async(&self) -> Result<CodespacesUserPublicKey, CodespacesGetPublicKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/public-key", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesGetPublicKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get public key for the authenticated user
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with one of the 'read:user' or 'user' scopes in their personal access token. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for get_public_key_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-public-key-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_public_key_for_authenticated_user(&self) -> Result<CodespacesUserPublicKey, CodespacesGetPublicKeyForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/public-key", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesGetPublicKeyForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a secret for the authenticated user
    ///
    /// Gets a secret available to a user's codespaces without revealing its encrypted value.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for get_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-a-secret-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_secret_for_authenticated_user_async(&self, secret_name: &str) -> Result<CodespacesSecret, CodespacesGetSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesGetSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a secret for the authenticated user
    ///
    /// Gets a secret available to a user's codespaces without revealing its encrypted value.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for get_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#get-a-secret-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_secret_for_authenticated_user(&self, secret_name: &str) -> Result<CodespacesSecret, CodespacesGetSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesGetSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List codespaces for the authenticated user
    ///
    /// Lists the authenticated user's codespaces.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-codespaces-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<CodespacesListForAuthenticatedUserParams>>) -> Result<GetCodespacesListForAuthenticatedUserResponse200, CodespacesListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/codespaces", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesListForAuthenticatedUserError::Status304),
                500 => Err(CodespacesListForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesListForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesListForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesListForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List codespaces for the authenticated user
    ///
    /// Lists the authenticated user's codespaces.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-codespaces-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<CodespacesListForAuthenticatedUserParams>>) -> Result<GetCodespacesListForAuthenticatedUserResponse200, CodespacesListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/codespaces", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodespacesListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesListForAuthenticatedUserError::Status304),
                500 => Err(CodespacesListForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesListForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesListForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesListForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List codespaces in a repository for the authenticated user
    ///
    /// Lists the codespaces associated to a specified repository and the authenticated user.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_in_repository_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-codespaces-in-a-repository-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_in_repository_for_authenticated_user_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodespacesListInRepositoryForAuthenticatedUserParams>>) -> Result<GetCodespacesListForAuthenticatedUserResponse200, CodespacesListInRepositoryForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                500 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesListInRepositoryForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List codespaces in a repository for the authenticated user
    ///
    /// Lists the codespaces associated to a specified repository and the authenticated user.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_in_repository_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-codespaces-in-a-repository-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_in_repository_for_authenticated_user(&self, owner: &str, repo: &str, query_params: Option<impl Into<CodespacesListInRepositoryForAuthenticatedUserParams>>) -> Result<GetCodespacesListForAuthenticatedUserResponse200, CodespacesListInRepositoryForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/codespaces", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodespacesListInRepositoryForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                500 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesListInRepositoryForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesListInRepositoryForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories for a user secret
    ///
    /// List the repositories that have been granted the ability to use a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for list_repositories_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-selected-repositories-for-a-user-secret)
    ///
    /// ---
    pub async fn list_repositories_for_secret_for_authenticated_user_async(&self, secret_name: &str) -> Result<GetCodespacesListRepositoriesForSecretForAuthenticatedUserResponse200, CodespacesListRepositoriesForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories for a user secret
    ///
    /// List the repositories that have been granted the ability to use a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for list_repositories_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-selected-repositories-for-a-user-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repositories_for_secret_for_authenticated_user(&self, secret_name: &str) -> Result<GetCodespacesListRepositoriesForSecretForAuthenticatedUserResponse200, CodespacesListRepositoriesForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                500 => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesListRepositoriesForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List secrets for the authenticated user
    ///
    /// Lists all secrets available for a user's Codespaces without revealing their
    /// encrypted values.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for list_secrets_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-secrets-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_secrets_for_authenticated_user_async(&self, query_params: Option<impl Into<CodespacesListSecretsForAuthenticatedUserParams>>) -> Result<GetCodespacesListSecretsForAuthenticatedUserResponse200, CodespacesListSecretsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/codespaces/secrets", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesListSecretsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List secrets for the authenticated user
    ///
    /// Lists all secrets available for a user's Codespaces without revealing their
    /// encrypted values.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for list_secrets_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-secrets-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_secrets_for_authenticated_user(&self, query_params: Option<impl Into<CodespacesListSecretsForAuthenticatedUserParams>>) -> Result<GetCodespacesListSecretsForAuthenticatedUserResponse200, CodespacesListSecretsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/codespaces/secrets", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: CodespacesListSecretsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(CodespacesListSecretsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a selected repository from a user secret
    ///
    /// Removes a repository from the selected repositories for a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for remove_repository_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#remove-a-selected-repository-from-a-user-secret)
    ///
    /// ---
    pub async fn remove_repository_for_secret_for_authenticated_user_async(&self, secret_name: &str, repository_id: i32) -> Result<(), CodespacesRemoveRepositoryForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a selected repository from a user secret
    ///
    /// Removes a repository from the selected repositories for a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for remove_repository_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#remove-a-selected-repository-from-a-user-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_repository_for_secret_for_authenticated_user(&self, secret_name: &str, repository_id: i32) -> Result<(), CodespacesRemoveRepositoryForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                500 => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesRemoveRepositoryForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List available machine types for a repository
    ///
    /// List the machine types available for a given repository based on its configuration.
    /// 
    /// Location is required.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for repo_machines_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-available-machine-types-for-a-repository)
    ///
    /// ---
    pub async fn repo_machines_for_authenticated_user_async(&self, owner: &str, repo: &str, query_params: impl Into<CodespacesRepoMachinesForAuthenticatedUserParams<'api>>) -> Result<GetCodespacesCodespaceMachinesForAuthenticatedUserResponse200, CodespacesRepoMachinesForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/codespaces/machines", super::GITHUB_BASE_API_URL, owner, repo);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status304),
                500 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesRepoMachinesForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List available machine types for a repository
    ///
    /// List the machine types available for a given repository based on its configuration.
    /// 
    /// Location is required.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for repo_machines_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#list-available-machine-types-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn repo_machines_for_authenticated_user(&self, owner: &str, repo: &str, query_params: impl Into<CodespacesRepoMachinesForAuthenticatedUserParams<'api>>) -> Result<GetCodespacesCodespaceMachinesForAuthenticatedUserResponse200, CodespacesRepoMachinesForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/codespaces/machines", super::GITHUB_BASE_API_URL, owner, repo);

        request_uri.push_str("?");
        let qp: CodespacesRepoMachinesForAuthenticatedUserParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status304),
                500 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesRepoMachinesForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesRepoMachinesForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories for a user secret
    ///
    /// Select the repositories that will use a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for set_repositories_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#set-selected-repositories-for-a-user-secret)
    ///
    /// ---
    pub async fn set_repositories_for_secret_for_authenticated_user_async(&self, secret_name: &str, body: PutCodespacesSetRepositoriesForSecretForAuthenticatedUser) -> Result<(), CodespacesSetRepositoriesForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutCodespacesSetRepositoriesForSecretForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories for a user secret
    ///
    /// Select the repositories that will use a user's codespace secret.
    /// You must authenticate using an access token with the `user` or `read:user` scope to use this endpoint. User must have Codespaces access to use this endpoint.
    /// 
    /// [GitHub API docs for set_repositories_for_secret_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#set-selected-repositories-for-a-user-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_repositories_for_secret_for_authenticated_user(&self, secret_name: &str, body: PutCodespacesSetRepositoriesForSecretForAuthenticatedUser) -> Result<(), CodespacesSetRepositoriesForSecretForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/secrets/{}/repositories", super::GITHUB_BASE_API_URL, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutCodespacesSetRepositoriesForSecretForAuthenticatedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                500 => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesSetRepositoriesForSecretForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start a codespace for the authenticated user
    ///
    /// Starts a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for start_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#start-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn start_for_authenticated_user_async(&self, codespace_name: &str) -> Result<Codespace, CodespacesStartForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/start", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesStartForAuthenticatedUserError::Status304),
                500 => Err(CodespacesStartForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(CodespacesStartForAuthenticatedUserError::Status400(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesStartForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                402 => Err(CodespacesStartForAuthenticatedUserError::Status402(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesStartForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesStartForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(CodespacesStartForAuthenticatedUserError::Status409(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesStartForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Start a codespace for the authenticated user
    ///
    /// Starts a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for start_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#start-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn start_for_authenticated_user(&self, codespace_name: &str) -> Result<Codespace, CodespacesStartForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/start", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(CodespacesStartForAuthenticatedUserError::Status304),
                500 => Err(CodespacesStartForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                400 => Err(CodespacesStartForAuthenticatedUserError::Status400(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesStartForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                402 => Err(CodespacesStartForAuthenticatedUserError::Status402(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesStartForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesStartForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                409 => Err(CodespacesStartForAuthenticatedUserError::Status409(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesStartForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Stop a codespace for the authenticated user
    ///
    /// Stops a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for stop_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#stop-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn stop_for_authenticated_user_async(&self, codespace_name: &str) -> Result<Codespace, CodespacesStopForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/stop", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                500 => Err(CodespacesStopForAuthenticatedUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(CodespacesStopForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesStopForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesStopForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesStopForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Stop a codespace for the authenticated user
    ///
    /// Stops a user's codespace.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for stop_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#stop-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn stop_for_authenticated_user(&self, codespace_name: &str) -> Result<Codespace, CodespacesStopForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}/stop", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                500 => Err(CodespacesStopForAuthenticatedUserError::Status500(crate::adapters::to_json(github_response)?)),
                401 => Err(CodespacesStopForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesStopForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesStopForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesStopForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a codespace for the authenticated user
    ///
    /// Updates a codespace owned by the authenticated user. Currently only the codespace's machine type can be modified using this endpoint.
    /// 
    /// Once you specify a new machine type it will be applied the next time your codespace is started.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#update-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    pub async fn update_for_authenticated_user_async(&self, codespace_name: &str, body: PatchCodespacesUpdateForAuthenticatedUser) -> Result<Codespace, CodespacesUpdateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchCodespacesUpdateForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesUpdateForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(CodespacesUpdateForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(CodespacesUpdateForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(CodespacesUpdateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a codespace for the authenticated user
    ///
    /// Updates a codespace owned by the authenticated user. Currently only the codespace's machine type can be modified using this endpoint.
    /// 
    /// Once you specify a new machine type it will be applied the next time your codespace is started.
    /// 
    /// You must authenticate using an access token with the `codespace` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_for_authenticated_user](https://docs.github.com/rest/reference/codespaces#update-a-codespace-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_for_authenticated_user(&self, codespace_name: &str, body: PatchCodespacesUpdateForAuthenticatedUser) -> Result<Codespace, CodespacesUpdateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/codespaces/{}", super::GITHUB_BASE_API_URL, codespace_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchCodespacesUpdateForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(CodespacesUpdateForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(CodespacesUpdateForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(CodespacesUpdateForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(CodespacesUpdateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

}
