//! Method, error and parameter types for the Apps endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Apps<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Apps {
    Apps { auth }
}

/// Errors for the [Add a repository to an app installation](Apps::add_repo_to_installation_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsAddRepoToInstallationForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check a token](Apps::check_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsCheckTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a GitHub App from a manifest](Apps::create_from_manifest_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsCreateFromManifestError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an installation access token for an app](Apps::create_installation_access_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsCreateInstallationAccessTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an app authorization](Apps::delete_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsDeleteAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an installation for the authenticated app](Apps::delete_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsDeleteInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an app token](Apps::delete_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsDeleteTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the authenticated app](Apps::get_authenticated_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetAuthenticatedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an app](Apps::get_by_slug_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetBySlugError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an installation for the authenticated app](Apps::get_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization installation for the authenticated app](Apps::get_org_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetOrgInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository installation for the authenticated app](Apps::get_repo_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetRepoInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a subscription plan for an account](Apps::get_subscription_plan_for_account_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetSubscriptionPlanForAccountError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found when the account has not purchased the listing")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a subscription plan for an account (stubbed)](Apps::get_subscription_plan_for_account_stubbed_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetSubscriptionPlanForAccountStubbedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found when the account has not purchased the listing")]
    Status404,
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a user installation for the authenticated app](Apps::get_user_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetUserInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a webhook configuration for an app](Apps::get_webhook_config_for_app_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetWebhookConfigForAppError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a delivery for an app webhook](Apps::get_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsGetWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List accounts for a plan](Apps::list_accounts_for_plan_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListAccountsForPlanError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List accounts for a plan (stubbed)](Apps::list_accounts_for_plan_stubbed_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListAccountsForPlanStubbedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories accessible to the user access token](Apps::list_installation_repos_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListInstallationReposForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List installations for the authenticated app](Apps::list_installations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListInstallationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List app installations accessible to the user access token](Apps::list_installations_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListInstallationsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List plans](Apps::list_plans_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListPlansError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List plans (stubbed)](Apps::list_plans_stubbed_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListPlansStubbedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories accessible to the app installation](Apps::list_repos_accessible_to_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListReposAccessibleToInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List subscriptions for the authenticated user](Apps::list_subscriptions_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListSubscriptionsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List subscriptions for the authenticated user (stubbed)](Apps::list_subscriptions_for_authenticated_user_stubbed_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListSubscriptionsForAuthenticatedUserStubbedError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deliveries for an app webhook](Apps::list_webhook_deliveries_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsListWebhookDeliveriesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Redeliver a delivery for an app webhook](Apps::redeliver_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsRedeliverWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a repository from an app installation](Apps::remove_repo_from_installation_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsRemoveRepoFromInstallationForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Reset a token](Apps::reset_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsResetTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Revoke an installation access token](Apps::revoke_installation_access_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsRevokeInstallationAccessTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a scoped access token](Apps::scope_token_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsScopeTokenError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Suspend an app installation](Apps::suspend_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsSuspendInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unsuspend an app installation](Apps::unsuspend_installation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsUnsuspendInstallationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a webhook configuration for an app](Apps::update_webhook_config_for_app_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum AppsUpdateWebhookConfigForAppError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List accounts for a plan](Apps::list_accounts_for_plan_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListAccountsForPlanParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> AppsListAccountsForPlanParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListAccountsForPlanParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List accounts for a plan (stubbed)](Apps::list_accounts_for_plan_stubbed_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListAccountsForPlanStubbedParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> AppsListAccountsForPlanStubbedParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListAccountsForPlanStubbedParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories accessible to the user access token](Apps::list_installation_repos_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListInstallationReposForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListInstallationReposForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListInstallationReposForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List installations for the authenticated app](Apps::list_installations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListInstallationsParams<'req> {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    
    outdated: Option<&'req str>
}

impl<'req> AppsListInstallationsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
            since: self.since, 
            outdated: self.outdated, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
            since: self.since, 
            outdated: self.outdated, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            since: Some(since),
            outdated: self.outdated, 
        }
    }

    
    pub fn outdated(self, outdated: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            page: self.page, 
            since: self.since, 
            outdated: Some(outdated),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListInstallationsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List app installations accessible to the user access token](Apps::list_installations_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListInstallationsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListInstallationsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListInstallationsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List plans](Apps::list_plans_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListPlansParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListPlansParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListPlansParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List plans (stubbed)](Apps::list_plans_stubbed_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListPlansStubbedParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListPlansStubbedParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListPlansStubbedParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories accessible to the app installation](Apps::list_repos_accessible_to_installation_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListReposAccessibleToInstallationParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListReposAccessibleToInstallationParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListReposAccessibleToInstallationParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List subscriptions for the authenticated user](Apps::list_subscriptions_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListSubscriptionsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListSubscriptionsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListSubscriptionsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List subscriptions for the authenticated user (stubbed)](Apps::list_subscriptions_for_authenticated_user_stubbed_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListSubscriptionsForAuthenticatedUserStubbedParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl AppsListSubscriptionsForAuthenticatedUserStubbedParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for AppsListSubscriptionsForAuthenticatedUserStubbedParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deliveries for an app webhook](Apps::list_webhook_deliveries_async()) endpoint.
#[derive(Default, Serialize)]
pub struct AppsListWebhookDeliveriesParams<'req> {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    cursor: Option<&'req str>
}

impl<'req> AppsListWebhookDeliveriesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            cursor: self.cursor, 
        }
    }

    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    pub fn cursor(self, cursor: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            cursor: Some(cursor),
        }
    }
}


impl<'api> Apps<'api> {
    /// ---
    ///
    /// # Add a repository to an app installation
    ///
    /// Add a single repository to an installation. The authenticated user must have admin access to the repository.
    /// 
    /// You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
    /// 
    /// [GitHub API docs for add_repo_to_installation_for_authenticated_user](https://docs.github.com/rest/reference/apps#add-a-repository-to-an-app-installation)
    ///
    /// ---
    pub async fn add_repo_to_installation_for_authenticated_user_async(&self, installation_id: i32, repository_id: i32) -> Result<(), AppsAddRepoToInstallationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/installations/{}/repositories/{}", super::GITHUB_BASE_API_URL, installation_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status304),
                404 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a repository to an app installation
    ///
    /// Add a single repository to an installation. The authenticated user must have admin access to the repository.
    /// 
    /// You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
    /// 
    /// [GitHub API docs for add_repo_to_installation_for_authenticated_user](https://docs.github.com/rest/reference/apps#add-a-repository-to-an-app-installation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_repo_to_installation_for_authenticated_user(&self, installation_id: i32, repository_id: i32) -> Result<(), AppsAddRepoToInstallationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/installations/{}/repositories/{}", super::GITHUB_BASE_API_URL, installation_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status304),
                404 => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsAddRepoToInstallationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check a token
    ///
    /// OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for check_token](https://docs.github.com/rest/reference/apps#check-a-token)
    ///
    /// ---
    pub async fn check_token_async(&self, client_id: &str, body: PostAppsCheckToken) -> Result<Authorization, AppsCheckTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsCheckToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsCheckTokenError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsCheckTokenError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsCheckTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check a token
    ///
    /// OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for check_token](https://docs.github.com/rest/reference/apps#check-a-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_token(&self, client_id: &str, body: PostAppsCheckToken) -> Result<Authorization, AppsCheckTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsCheckToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsCheckTokenError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsCheckTokenError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsCheckTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GitHub App from a manifest
    ///
    /// Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
    /// 
    /// [GitHub API docs for create_from_manifest](https://docs.github.com/rest/reference/apps#create-a-github-app-from-a-manifest)
    ///
    /// ---
    pub async fn create_from_manifest_async(&self, code: &str, body: HashMap<String, Value>) -> Result<PostAppsCreateFromManifestResponse201, AppsCreateFromManifestError> {

        let request_uri = format!("{}/app-manifests/{}/conversions", super::GITHUB_BASE_API_URL, code);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(HashMap::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsCreateFromManifestError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsCreateFromManifestError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsCreateFromManifestError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a GitHub App from a manifest
    ///
    /// Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
    /// 
    /// [GitHub API docs for create_from_manifest](https://docs.github.com/rest/reference/apps#create-a-github-app-from-a-manifest)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_from_manifest(&self, code: &str, body: HashMap<String, Value>) -> Result<PostAppsCreateFromManifestResponse201, AppsCreateFromManifestError> {

        let request_uri = format!("{}/app-manifests/{}/conversions", super::GITHUB_BASE_API_URL, code);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(HashMap::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsCreateFromManifestError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsCreateFromManifestError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsCreateFromManifestError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an installation access token for an app
    ///
    /// Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for create_installation_access_token](https://docs.github.com/rest/reference/apps/#create-an-installation-access-token-for-an-app)
    ///
    /// ---
    pub async fn create_installation_access_token_async(&self, installation_id: i32, body: PostAppsCreateInstallationAccessToken) -> Result<InstallationToken, AppsCreateInstallationAccessTokenError> {

        let request_uri = format!("{}/app/installations/{}/access_tokens", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsCreateInstallationAccessToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsCreateInstallationAccessTokenError::Status403(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(AppsCreateInstallationAccessTokenError::Status415(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(AppsCreateInstallationAccessTokenError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsCreateInstallationAccessTokenError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsCreateInstallationAccessTokenError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsCreateInstallationAccessTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an installation access token for an app
    ///
    /// Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for create_installation_access_token](https://docs.github.com/rest/reference/apps/#create-an-installation-access-token-for-an-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_installation_access_token(&self, installation_id: i32, body: PostAppsCreateInstallationAccessToken) -> Result<InstallationToken, AppsCreateInstallationAccessTokenError> {

        let request_uri = format!("{}/app/installations/{}/access_tokens", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsCreateInstallationAccessToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsCreateInstallationAccessTokenError::Status403(crate::adapters::to_json(github_response)?)),
                415 => Err(AppsCreateInstallationAccessTokenError::Status415(crate::adapters::to_json(github_response)?)),
                401 => Err(AppsCreateInstallationAccessTokenError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsCreateInstallationAccessTokenError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsCreateInstallationAccessTokenError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsCreateInstallationAccessTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an app authorization
    ///
    /// OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
    /// Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    /// 
    /// [GitHub API docs for delete_authorization](https://docs.github.com/rest/reference/apps#delete-an-app-authorization)
    ///
    /// ---
    pub async fn delete_authorization_async(&self, client_id: &str, body: DeleteAppsDeleteAuthorization) -> Result<(), AppsDeleteAuthorizationError> {

        let request_uri = format!("{}/applications/{}/grant", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteAppsDeleteAuthorization::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsDeleteAuthorizationError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsDeleteAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an app authorization
    ///
    /// OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
    /// Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
    /// 
    /// [GitHub API docs for delete_authorization](https://docs.github.com/rest/reference/apps#delete-an-app-authorization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_authorization(&self, client_id: &str, body: DeleteAppsDeleteAuthorization) -> Result<(), AppsDeleteAuthorizationError> {

        let request_uri = format!("{}/applications/{}/grant", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteAppsDeleteAuthorization::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsDeleteAuthorizationError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsDeleteAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an installation for the authenticated app
    ///
    /// Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/reference/apps/#suspend-an-app-installation)" endpoint.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for delete_installation](https://docs.github.com/rest/reference/apps#delete-an-installation-for-the-authenticated-app)
    ///
    /// ---
    pub async fn delete_installation_async(&self, installation_id: i32) -> Result<(), AppsDeleteInstallationError> {

        let request_uri = format!("{}/app/installations/{}", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsDeleteInstallationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsDeleteInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an installation for the authenticated app
    ///
    /// Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/reference/apps/#suspend-an-app-installation)" endpoint.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for delete_installation](https://docs.github.com/rest/reference/apps#delete-an-installation-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_installation(&self, installation_id: i32) -> Result<(), AppsDeleteInstallationError> {

        let request_uri = format!("{}/app/installations/{}", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsDeleteInstallationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsDeleteInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an app token
    ///
    /// OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
    /// 
    /// [GitHub API docs for delete_token](https://docs.github.com/rest/reference/apps#delete-an-app-token)
    ///
    /// ---
    pub async fn delete_token_async(&self, client_id: &str, body: DeleteAppsDeleteToken) -> Result<(), AppsDeleteTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteAppsDeleteToken::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsDeleteTokenError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsDeleteTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an app token
    ///
    /// OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
    /// 
    /// [GitHub API docs for delete_token](https://docs.github.com/rest/reference/apps#delete-an-app-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_token(&self, client_id: &str, body: DeleteAppsDeleteToken) -> Result<(), AppsDeleteTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(DeleteAppsDeleteToken::from_json(body)?),
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsDeleteTokenError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsDeleteTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the authenticated app
    ///
    /// Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_authenticated](https://docs.github.com/rest/reference/apps#get-the-authenticated-app)
    ///
    /// ---
    pub async fn get_authenticated_async(&self) -> Result<Integration, AppsGetAuthenticatedError> {

        let request_uri = format!("{}/app", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the authenticated app
    ///
    /// Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_authenticated](https://docs.github.com/rest/reference/apps#get-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_authenticated(&self) -> Result<Integration, AppsGetAuthenticatedError> {

        let request_uri = format!("{}/app", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetAuthenticatedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an app
    ///
    /// **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
    /// 
    /// If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for get_by_slug](https://docs.github.com/rest/reference/apps/#get-an-app)
    ///
    /// ---
    pub async fn get_by_slug_async(&self, app_slug: &str) -> Result<Integration, AppsGetBySlugError> {

        let request_uri = format!("{}/apps/{}", super::GITHUB_BASE_API_URL, app_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsGetBySlugError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsGetBySlugError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(AppsGetBySlugError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetBySlugError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an app
    ///
    /// **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
    /// 
    /// If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for get_by_slug](https://docs.github.com/rest/reference/apps/#get-an-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_by_slug(&self, app_slug: &str) -> Result<Integration, AppsGetBySlugError> {

        let request_uri = format!("{}/apps/{}", super::GITHUB_BASE_API_URL, app_slug);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsGetBySlugError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsGetBySlugError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(AppsGetBySlugError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetBySlugError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find an installation's information using the installation id. The installation's account type (`target_type`) will be either an organization or a user account, depending which account the repository belongs to.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_installation](https://docs.github.com/rest/reference/apps#get-an-installation-for-the-authenticated-app)
    ///
    /// ---
    pub async fn get_installation_async(&self, installation_id: i32) -> Result<Installation, AppsGetInstallationError> {

        let request_uri = format!("{}/app/installations/{}", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetInstallationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(AppsGetInstallationError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find an installation's information using the installation id. The installation's account type (`target_type`) will be either an organization or a user account, depending which account the repository belongs to.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_installation](https://docs.github.com/rest/reference/apps#get-an-installation-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_installation(&self, installation_id: i32) -> Result<Installation, AppsGetInstallationError> {

        let request_uri = format!("{}/app/installations/{}", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetInstallationError::Status404(crate::adapters::to_json(github_response)?)),
                415 => Err(AppsGetInstallationError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the organization's installation information.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_org_installation](https://docs.github.com/rest/reference/apps#get-an-organization-installation-for-the-authenticated-app)
    ///
    /// ---
    pub async fn get_org_installation_async(&self, org: &str) -> Result<Installation, AppsGetOrgInstallationError> {

        let request_uri = format!("{}/orgs/{}/installation", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetOrgInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the organization's installation information.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_org_installation](https://docs.github.com/rest/reference/apps#get-an-organization-installation-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_org_installation(&self, org: &str) -> Result<Installation, AppsGetOrgInstallationError> {

        let request_uri = format!("{}/orgs/{}/installation", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetOrgInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_repo_installation](https://docs.github.com/rest/reference/apps#get-a-repository-installation-for-the-authenticated-app)
    ///
    /// ---
    pub async fn get_repo_installation_async(&self, owner: &str, repo: &str) -> Result<Installation, AppsGetRepoInstallationError> {

        let request_uri = format!("{}/repos/{}/{}/installation", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                301 => Err(AppsGetRepoInstallationError::Status301(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsGetRepoInstallationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetRepoInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_repo_installation](https://docs.github.com/rest/reference/apps#get-a-repository-installation-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_repo_installation(&self, owner: &str, repo: &str) -> Result<Installation, AppsGetRepoInstallationError> {

        let request_uri = format!("{}/repos/{}/{}/installation", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                301 => Err(AppsGetRepoInstallationError::Status301(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsGetRepoInstallationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetRepoInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a subscription plan for an account
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for get_subscription_plan_for_account](https://docs.github.com/rest/reference/apps#get-a-subscription-plan-for-an-account)
    ///
    /// ---
    pub async fn get_subscription_plan_for_account_async(&self, account_id: i32) -> Result<MarketplacePurchase, AppsGetSubscriptionPlanForAccountError> {

        let request_uri = format!("{}/marketplace_listing/accounts/{}", super::GITHUB_BASE_API_URL, account_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetSubscriptionPlanForAccountError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(AppsGetSubscriptionPlanForAccountError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetSubscriptionPlanForAccountError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a subscription plan for an account
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for get_subscription_plan_for_account](https://docs.github.com/rest/reference/apps#get-a-subscription-plan-for-an-account)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_subscription_plan_for_account(&self, account_id: i32) -> Result<MarketplacePurchase, AppsGetSubscriptionPlanForAccountError> {

        let request_uri = format!("{}/marketplace_listing/accounts/{}", super::GITHUB_BASE_API_URL, account_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetSubscriptionPlanForAccountError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(AppsGetSubscriptionPlanForAccountError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetSubscriptionPlanForAccountError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a subscription plan for an account (stubbed)
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for get_subscription_plan_for_account_stubbed](https://docs.github.com/rest/reference/apps#get-a-subscription-plan-for-an-account-stubbed)
    ///
    /// ---
    pub async fn get_subscription_plan_for_account_stubbed_async(&self, account_id: i32) -> Result<MarketplacePurchase, AppsGetSubscriptionPlanForAccountStubbedError> {

        let request_uri = format!("{}/marketplace_listing/stubbed/accounts/{}", super::GITHUB_BASE_API_URL, account_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetSubscriptionPlanForAccountStubbedError::Status404),
                401 => Err(AppsGetSubscriptionPlanForAccountStubbedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetSubscriptionPlanForAccountStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a subscription plan for an account (stubbed)
    ///
    /// Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for get_subscription_plan_for_account_stubbed](https://docs.github.com/rest/reference/apps#get-a-subscription-plan-for-an-account-stubbed)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_subscription_plan_for_account_stubbed(&self, account_id: i32) -> Result<MarketplacePurchase, AppsGetSubscriptionPlanForAccountStubbedError> {

        let request_uri = format!("{}/marketplace_listing/stubbed/accounts/{}", super::GITHUB_BASE_API_URL, account_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsGetSubscriptionPlanForAccountStubbedError::Status404),
                401 => Err(AppsGetSubscriptionPlanForAccountStubbedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetSubscriptionPlanForAccountStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the user’s installation information.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_user_installation](https://docs.github.com/rest/reference/apps#get-a-user-installation-for-the-authenticated-app)
    ///
    /// ---
    pub async fn get_user_installation_async(&self, username: &str) -> Result<Installation, AppsGetUserInstallationError> {

        let request_uri = format!("{}/users/{}/installation", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetUserInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a user installation for the authenticated app
    ///
    /// Enables an authenticated GitHub App to find the user’s installation information.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_user_installation](https://docs.github.com/rest/reference/apps#get-a-user-installation-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_user_installation(&self, username: &str) -> Result<Installation, AppsGetUserInstallationError> {

        let request_uri = format!("{}/users/{}/installation", super::GITHUB_BASE_API_URL, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetUserInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for an app
    ///
    /// Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_webhook_config_for_app](https://docs.github.com/rest/reference/apps#get-a-webhook-configuration-for-an-app)
    ///
    /// ---
    pub async fn get_webhook_config_for_app_async(&self) -> Result<WebhookConfig, AppsGetWebhookConfigForAppError> {

        let request_uri = format!("{}/app/hook/config", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetWebhookConfigForAppError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for an app
    ///
    /// Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_webhook_config_for_app](https://docs.github.com/rest/reference/apps#get-a-webhook-configuration-for-an-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_config_for_app(&self) -> Result<WebhookConfig, AppsGetWebhookConfigForAppError> {

        let request_uri = format!("{}/app/hook/config", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsGetWebhookConfigForAppError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a delivery for an app webhook
    ///
    /// Returns a delivery for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/apps#get-a-delivery-for-an-app-webhook)
    ///
    /// ---
    pub async fn get_webhook_delivery_async(&self, delivery_id: i32) -> Result<HookDelivery, AppsGetWebhookDeliveryError> {

        let request_uri = format!("{}/app/hook/deliveries/{}", super::GITHUB_BASE_API_URL, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsGetWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsGetWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a delivery for an app webhook
    ///
    /// Returns a delivery for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/apps#get-a-delivery-for-an-app-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_delivery(&self, delivery_id: i32) -> Result<HookDelivery, AppsGetWebhookDeliveryError> {

        let request_uri = format!("{}/app/hook/deliveries/{}", super::GITHUB_BASE_API_URL, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsGetWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsGetWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List accounts for a plan
    ///
    /// Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_accounts_for_plan](https://docs.github.com/rest/reference/apps#list-accounts-for-a-plan)
    ///
    /// ---
    pub async fn list_accounts_for_plan_async(&self, plan_id: i32, query_params: Option<impl Into<AppsListAccountsForPlanParams<'api>>>) -> Result<Vec<MarketplacePurchase>, AppsListAccountsForPlanError> {

        let mut request_uri = format!("{}/marketplace_listing/plans/{}/accounts", super::GITHUB_BASE_API_URL, plan_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListAccountsForPlanError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsListAccountsForPlanError::Status422(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(AppsListAccountsForPlanError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListAccountsForPlanError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List accounts for a plan
    ///
    /// Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_accounts_for_plan](https://docs.github.com/rest/reference/apps#list-accounts-for-a-plan)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_accounts_for_plan(&self, plan_id: i32, query_params: Option<impl Into<AppsListAccountsForPlanParams<'api>>>) -> Result<Vec<MarketplacePurchase>, AppsListAccountsForPlanError> {

        let mut request_uri = format!("{}/marketplace_listing/plans/{}/accounts", super::GITHUB_BASE_API_URL, plan_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListAccountsForPlanParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListAccountsForPlanError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsListAccountsForPlanError::Status422(crate::adapters::to_json(github_response)?)),
                401 => Err(AppsListAccountsForPlanError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListAccountsForPlanError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List accounts for a plan (stubbed)
    ///
    /// Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_accounts_for_plan_stubbed](https://docs.github.com/rest/reference/apps#list-accounts-for-a-plan-stubbed)
    ///
    /// ---
    pub async fn list_accounts_for_plan_stubbed_async(&self, plan_id: i32, query_params: Option<impl Into<AppsListAccountsForPlanStubbedParams<'api>>>) -> Result<Vec<MarketplacePurchase>, AppsListAccountsForPlanStubbedError> {

        let mut request_uri = format!("{}/marketplace_listing/stubbed/plans/{}/accounts", super::GITHUB_BASE_API_URL, plan_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsListAccountsForPlanStubbedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListAccountsForPlanStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List accounts for a plan (stubbed)
    ///
    /// Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_accounts_for_plan_stubbed](https://docs.github.com/rest/reference/apps#list-accounts-for-a-plan-stubbed)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_accounts_for_plan_stubbed(&self, plan_id: i32, query_params: Option<impl Into<AppsListAccountsForPlanStubbedParams<'api>>>) -> Result<Vec<MarketplacePurchase>, AppsListAccountsForPlanStubbedError> {

        let mut request_uri = format!("{}/marketplace_listing/stubbed/plans/{}/accounts", super::GITHUB_BASE_API_URL, plan_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListAccountsForPlanStubbedParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsListAccountsForPlanStubbedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListAccountsForPlanStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories accessible to the user access token
    ///
    /// List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
    /// 
    /// The access the user has to each repository is included in the hash under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installation_repos_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-repositories-accessible-to-the-user-access-token)
    ///
    /// ---
    pub async fn list_installation_repos_for_authenticated_user_async(&self, installation_id: i32, query_params: Option<impl Into<AppsListInstallationReposForAuthenticatedUserParams>>) -> Result<GetAppsListInstallationReposForAuthenticatedUserResponse200, AppsListInstallationReposForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/installations/{}/repositories", super::GITHUB_BASE_API_URL, installation_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListInstallationReposForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(AppsListInstallationReposForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(AppsListInstallationReposForAuthenticatedUserError::Status304),
                code => Err(AppsListInstallationReposForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories accessible to the user access token
    ///
    /// List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
    /// 
    /// The access the user has to each repository is included in the hash under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installation_repos_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-repositories-accessible-to-the-user-access-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_installation_repos_for_authenticated_user(&self, installation_id: i32, query_params: Option<impl Into<AppsListInstallationReposForAuthenticatedUserParams>>) -> Result<GetAppsListInstallationReposForAuthenticatedUserResponse200, AppsListInstallationReposForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/installations/{}/repositories", super::GITHUB_BASE_API_URL, installation_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListInstallationReposForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListInstallationReposForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(AppsListInstallationReposForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(AppsListInstallationReposForAuthenticatedUserError::Status304),
                code => Err(AppsListInstallationReposForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List installations for the authenticated app
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// The permissions the installation has are included under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installations](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)
    ///
    /// ---
    pub async fn list_installations_async(&self, query_params: Option<impl Into<AppsListInstallationsParams<'api>>>) -> Result<Vec<Installation>, AppsListInstallationsError> {

        let mut request_uri = format!("{}/app/installations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsListInstallationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List installations for the authenticated app
    ///
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// The permissions the installation has are included under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installations](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_installations(&self, query_params: Option<impl Into<AppsListInstallationsParams<'api>>>) -> Result<Vec<Installation>, AppsListInstallationsError> {

        let mut request_uri = format!("{}/app/installations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListInstallationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsListInstallationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List app installations accessible to the user access token
    ///
    /// Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    /// 
    /// You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// You can find the permissions for the installation under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installations_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-app-installations-accessible-to-the-user-access-token)
    ///
    /// ---
    pub async fn list_installations_for_authenticated_user_async(&self, query_params: Option<impl Into<AppsListInstallationsForAuthenticatedUserParams>>) -> Result<GetAppsListInstallationsForAuthenticatedUserResponse200, AppsListInstallationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/installations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListInstallationsForAuthenticatedUserError::Status304),
                403 => Err(AppsListInstallationsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(AppsListInstallationsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(AppsListInstallationsForAuthenticatedUserError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListInstallationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List app installations accessible to the user access token
    ///
    /// Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    /// 
    /// You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
    /// 
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    /// 
    /// You can find the permissions for the installation under the `permissions` key.
    /// 
    /// [GitHub API docs for list_installations_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-app-installations-accessible-to-the-user-access-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_installations_for_authenticated_user(&self, query_params: Option<impl Into<AppsListInstallationsForAuthenticatedUserParams>>) -> Result<GetAppsListInstallationsForAuthenticatedUserResponse200, AppsListInstallationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/installations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListInstallationsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListInstallationsForAuthenticatedUserError::Status304),
                403 => Err(AppsListInstallationsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(AppsListInstallationsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                415 => Err(AppsListInstallationsForAuthenticatedUserError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListInstallationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List plans
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_plans](https://docs.github.com/rest/reference/apps#list-plans)
    ///
    /// ---
    pub async fn list_plans_async(&self, query_params: Option<impl Into<AppsListPlansParams>>) -> Result<Vec<MarketplaceListingPlan>, AppsListPlansError> {

        let mut request_uri = format!("{}/marketplace_listing/plans", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListPlansError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(AppsListPlansError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListPlansError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List plans
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_plans](https://docs.github.com/rest/reference/apps#list-plans)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_plans(&self, query_params: Option<impl Into<AppsListPlansParams>>) -> Result<Vec<MarketplaceListingPlan>, AppsListPlansError> {

        let mut request_uri = format!("{}/marketplace_listing/plans", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListPlansParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsListPlansError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(AppsListPlansError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListPlansError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List plans (stubbed)
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_plans_stubbed](https://docs.github.com/rest/reference/apps#list-plans-stubbed)
    ///
    /// ---
    pub async fn list_plans_stubbed_async(&self, query_params: Option<impl Into<AppsListPlansStubbedParams>>) -> Result<Vec<MarketplaceListingPlan>, AppsListPlansStubbedError> {

        let mut request_uri = format!("{}/marketplace_listing/stubbed/plans", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsListPlansStubbedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListPlansStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List plans (stubbed)
    ///
    /// Lists all plans that are part of your GitHub Marketplace listing.
    /// 
    /// GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
    /// 
    /// [GitHub API docs for list_plans_stubbed](https://docs.github.com/rest/reference/apps#list-plans-stubbed)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_plans_stubbed(&self, query_params: Option<impl Into<AppsListPlansStubbedParams>>) -> Result<Vec<MarketplaceListingPlan>, AppsListPlansStubbedError> {

        let mut request_uri = format!("{}/marketplace_listing/stubbed/plans", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListPlansStubbedParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsListPlansStubbedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListPlansStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories accessible to the app installation
    ///
    /// List repositories that an app installation can access.
    /// 
    /// You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for list_repos_accessible_to_installation](https://docs.github.com/rest/reference/apps#list-repositories-accessible-to-the-app-installation)
    ///
    /// ---
    pub async fn list_repos_accessible_to_installation_async(&self, query_params: Option<impl Into<AppsListReposAccessibleToInstallationParams>>) -> Result<GetAppsListReposAccessibleToInstallationResponse200, AppsListReposAccessibleToInstallationError> {

        let mut request_uri = format!("{}/installation/repositories", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsListReposAccessibleToInstallationError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(AppsListReposAccessibleToInstallationError::Status304),
                401 => Err(AppsListReposAccessibleToInstallationError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListReposAccessibleToInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories accessible to the app installation
    ///
    /// List repositories that an app installation can access.
    /// 
    /// You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for list_repos_accessible_to_installation](https://docs.github.com/rest/reference/apps#list-repositories-accessible-to-the-app-installation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_accessible_to_installation(&self, query_params: Option<impl Into<AppsListReposAccessibleToInstallationParams>>) -> Result<GetAppsListReposAccessibleToInstallationResponse200, AppsListReposAccessibleToInstallationError> {

        let mut request_uri = format!("{}/installation/repositories", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListReposAccessibleToInstallationParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsListReposAccessibleToInstallationError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(AppsListReposAccessibleToInstallationError::Status304),
                401 => Err(AppsListReposAccessibleToInstallationError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListReposAccessibleToInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List subscriptions for the authenticated user
    ///
    /// Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
    /// 
    /// [GitHub API docs for list_subscriptions_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-subscriptions-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_subscriptions_for_authenticated_user_async(&self, query_params: Option<impl Into<AppsListSubscriptionsForAuthenticatedUserParams>>) -> Result<Vec<UserMarketplacePurchase>, AppsListSubscriptionsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/marketplace_purchases", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status304),
                401 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListSubscriptionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List subscriptions for the authenticated user
    ///
    /// Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
    /// 
    /// [GitHub API docs for list_subscriptions_for_authenticated_user](https://docs.github.com/rest/reference/apps#list-subscriptions-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_subscriptions_for_authenticated_user(&self, query_params: Option<impl Into<AppsListSubscriptionsForAuthenticatedUserParams>>) -> Result<Vec<UserMarketplacePurchase>, AppsListSubscriptionsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/marketplace_purchases", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListSubscriptionsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status304),
                401 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsListSubscriptionsForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListSubscriptionsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List subscriptions for the authenticated user (stubbed)
    ///
    /// Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
    /// 
    /// [GitHub API docs for list_subscriptions_for_authenticated_user_stubbed](https://docs.github.com/rest/reference/apps#list-subscriptions-for-the-authenticated-user-stubbed)
    ///
    /// ---
    pub async fn list_subscriptions_for_authenticated_user_stubbed_async(&self, query_params: Option<impl Into<AppsListSubscriptionsForAuthenticatedUserStubbedParams>>) -> Result<Vec<UserMarketplacePurchase>, AppsListSubscriptionsForAuthenticatedUserStubbedError> {

        let mut request_uri = format!("{}/user/marketplace_purchases/stubbed", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Status304),
                401 => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List subscriptions for the authenticated user (stubbed)
    ///
    /// Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
    /// 
    /// [GitHub API docs for list_subscriptions_for_authenticated_user_stubbed](https://docs.github.com/rest/reference/apps#list-subscriptions-for-the-authenticated-user-stubbed)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_subscriptions_for_authenticated_user_stubbed(&self, query_params: Option<impl Into<AppsListSubscriptionsForAuthenticatedUserStubbedParams>>) -> Result<Vec<UserMarketplacePurchase>, AppsListSubscriptionsForAuthenticatedUserStubbedError> {

        let mut request_uri = format!("{}/user/marketplace_purchases/stubbed", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListSubscriptionsForAuthenticatedUserStubbedParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Status304),
                401 => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListSubscriptionsForAuthenticatedUserStubbedError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for an app webhook
    ///
    /// Returns a list of webhook deliveries for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/apps#list-deliveries-for-an-app-webhook)
    ///
    /// ---
    pub async fn list_webhook_deliveries_async(&self, query_params: Option<impl Into<AppsListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, AppsListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/app/hook/deliveries", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsListWebhookDeliveriesError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsListWebhookDeliveriesError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for an app webhook
    ///
    /// Returns a list of webhook deliveries for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/apps#list-deliveries-for-an-app-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_webhook_deliveries(&self, query_params: Option<impl Into<AppsListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, AppsListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/app/hook/deliveries", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: AppsListWebhookDeliveriesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsListWebhookDeliveriesError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsListWebhookDeliveriesError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for an app webhook
    ///
    /// Redeliver a delivery for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/apps#redeliver-a-delivery-for-an-app-webhook)
    ///
    /// ---
    pub async fn redeliver_webhook_delivery_async(&self, delivery_id: i32) -> Result<HashMap<String, Value>, AppsRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/app/hook/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for an app webhook
    ///
    /// Redeliver a delivery for the webhook configured for a GitHub App.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/apps#redeliver-a-delivery-for-an-app-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn redeliver_webhook_delivery(&self, delivery_id: i32) -> Result<HashMap<String, Value>, AppsRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/app/hook/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(AppsRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from an app installation
    ///
    /// Remove a single repository from an installation. The authenticated user must have admin access to the repository.
    /// 
    /// You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
    /// 
    /// [GitHub API docs for remove_repo_from_installation_for_authenticated_user](https://docs.github.com/rest/reference/apps#remove-a-repository-from-an-app-installation)
    ///
    /// ---
    pub async fn remove_repo_from_installation_for_authenticated_user_async(&self, installation_id: i32, repository_id: i32) -> Result<(), AppsRemoveRepoFromInstallationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/installations/{}/repositories/{}", super::GITHUB_BASE_API_URL, installation_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status304),
                404 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a repository from an app installation
    ///
    /// Remove a single repository from an installation. The authenticated user must have admin access to the repository.
    /// 
    /// You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
    /// 
    /// [GitHub API docs for remove_repo_from_installation_for_authenticated_user](https://docs.github.com/rest/reference/apps#remove-a-repository-from-an-app-installation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_repo_from_installation_for_authenticated_user(&self, installation_id: i32, repository_id: i32) -> Result<(), AppsRemoveRepoFromInstallationForAuthenticatedUserError> {

        let request_uri = format!("{}/user/installations/{}/repositories/{}", super::GITHUB_BASE_API_URL, installation_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status304),
                404 => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsRemoveRepoFromInstallationForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Reset a token
    ///
    /// OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for reset_token](https://docs.github.com/rest/reference/apps#reset-a-token)
    ///
    /// ---
    pub async fn reset_token_async(&self, client_id: &str, body: PatchAppsResetToken) -> Result<Authorization, AppsResetTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchAppsResetToken::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsResetTokenError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsResetTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Reset a token
    ///
    /// OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for reset_token](https://docs.github.com/rest/reference/apps#reset-a-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn reset_token(&self, client_id: &str, body: PatchAppsResetToken) -> Result<Authorization, AppsResetTokenError> {

        let request_uri = format!("{}/applications/{}/token", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchAppsResetToken::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(AppsResetTokenError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsResetTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Revoke an installation access token
    ///
    /// Revokes the installation token you're using to authenticate as an installation and access this endpoint.
    /// 
    /// Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
    /// 
    /// You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for revoke_installation_access_token](https://docs.github.com/rest/reference/apps#revoke-an-installation-access-token)
    ///
    /// ---
    pub async fn revoke_installation_access_token_async(&self) -> Result<(), AppsRevokeInstallationAccessTokenError> {

        let request_uri = format!("{}/installation/token", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsRevokeInstallationAccessTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Revoke an installation access token
    ///
    /// Revokes the installation token you're using to authenticate as an installation and access this endpoint.
    /// 
    /// Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
    /// 
    /// You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
    /// 
    /// [GitHub API docs for revoke_installation_access_token](https://docs.github.com/rest/reference/apps#revoke-an-installation-access-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn revoke_installation_access_token(&self) -> Result<(), AppsRevokeInstallationAccessTokenError> {

        let request_uri = format!("{}/installation/token", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsRevokeInstallationAccessTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a scoped access token
    ///
    /// Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for scope_token](https://docs.github.com/rest/reference/apps#create-a-scoped-access-token)
    ///
    /// ---
    pub async fn scope_token_async(&self, client_id: &str, body: PostAppsScopeToken) -> Result<Authorization, AppsScopeTokenError> {

        let request_uri = format!("{}/applications/{}/token/scoped", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsScopeToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsScopeTokenError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(AppsScopeTokenError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(AppsScopeTokenError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(AppsScopeTokenError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsScopeTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a scoped access token
    ///
    /// Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
    /// 
    /// [GitHub API docs for scope_token](https://docs.github.com/rest/reference/apps#create-a-scoped-access-token)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn scope_token(&self, client_id: &str, body: PostAppsScopeToken) -> Result<Authorization, AppsScopeTokenError> {

        let request_uri = format!("{}/applications/{}/token/scoped", super::GITHUB_BASE_API_URL, client_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostAppsScopeToken::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(AppsScopeTokenError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(AppsScopeTokenError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(AppsScopeTokenError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(AppsScopeTokenError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(AppsScopeTokenError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Suspend an app installation
    ///
    /// Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for suspend_installation](https://docs.github.com/rest/reference/apps#suspend-an-app-installation)
    ///
    /// ---
    pub async fn suspend_installation_async(&self, installation_id: i32) -> Result<(), AppsSuspendInstallationError> {

        let request_uri = format!("{}/app/installations/{}/suspended", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsSuspendInstallationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsSuspendInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Suspend an app installation
    ///
    /// Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for suspend_installation](https://docs.github.com/rest/reference/apps#suspend-an-app-installation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn suspend_installation(&self, installation_id: i32) -> Result<(), AppsSuspendInstallationError> {

        let request_uri = format!("{}/app/installations/{}/suspended", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsSuspendInstallationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsSuspendInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unsuspend an app installation
    ///
    /// Removes a GitHub App installation suspension.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for unsuspend_installation](https://docs.github.com/rest/reference/apps#unsuspend-an-app-installation)
    ///
    /// ---
    pub async fn unsuspend_installation_async(&self, installation_id: i32) -> Result<(), AppsUnsuspendInstallationError> {

        let request_uri = format!("{}/app/installations/{}/suspended", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsUnsuspendInstallationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(AppsUnsuspendInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unsuspend an app installation
    ///
    /// Removes a GitHub App installation suspension.
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for unsuspend_installation](https://docs.github.com/rest/reference/apps#unsuspend-an-app-installation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unsuspend_installation(&self, installation_id: i32) -> Result<(), AppsUnsuspendInstallationError> {

        let request_uri = format!("{}/app/installations/{}/suspended", super::GITHUB_BASE_API_URL, installation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(AppsUnsuspendInstallationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(AppsUnsuspendInstallationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for an app
    ///
    /// Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for update_webhook_config_for_app](https://docs.github.com/rest/reference/apps#update-a-webhook-configuration-for-an-app)
    ///
    /// ---
    pub async fn update_webhook_config_for_app_async(&self, body: PatchAppsUpdateWebhookConfigForApp) -> Result<WebhookConfig, AppsUpdateWebhookConfigForAppError> {

        let request_uri = format!("{}/app/hook/config", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchAppsUpdateWebhookConfigForApp::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(AppsUpdateWebhookConfigForAppError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for an app
    ///
    /// Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
    /// 
    /// You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
    /// 
    /// [GitHub API docs for update_webhook_config_for_app](https://docs.github.com/rest/reference/apps#update-a-webhook-configuration-for-an-app)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_webhook_config_for_app(&self, body: PatchAppsUpdateWebhookConfigForApp) -> Result<WebhookConfig, AppsUpdateWebhookConfigForAppError> {

        let request_uri = format!("{}/app/hook/config", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchAppsUpdateWebhookConfigForApp::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(AppsUpdateWebhookConfigForAppError::Generic { code }),
            }
        }
    }

}
