//! Method, error and parameter types for the Projects endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Projects<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Projects {
    Projects { auth }
}

/// Errors for the [Add project collaborator](Projects::add_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsAddCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a project card](Projects::create_card_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsCreateCardError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(PostProjectsCreateCardResponse422),
    #[error("Response")]
    Status503(PostProjectsCreateCardResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a project column](Projects::create_column_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsCreateColumnError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a user project](Projects::create_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsCreateForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an organization project](Projects::create_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsCreateForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a repository project](Projects::create_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsCreateForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a project](Projects::delete_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsDeleteError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(PatchProjectsUpdateResponse403),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a project card](Projects::delete_card_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsDeleteCardError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(PatchProjectsUpdateResponse403),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a project column](Projects::delete_column_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsDeleteColumnError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a project](Projects::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a project card](Projects::get_card_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsGetCardError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a project column](Projects::get_column_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsGetColumnError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get project permission for a user](Projects::get_permission_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsGetPermissionForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List project cards](Projects::list_cards_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListCardsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List project collaborators](Projects::list_collaborators_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListCollaboratorsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List project columns](Projects::list_columns_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListColumnsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization projects](Projects::list_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository projects](Projects::list_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List user projects](Projects::list_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsListForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Move a project card](Projects::move_card_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsMoveCardError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(PostProjectsMoveCardResponse403),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Response")]
    Status503(PostProjectsCreateCardResponse503),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Move a project column](Projects::move_column_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsMoveColumnError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove user as a collaborator](Projects::remove_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsRemoveCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a project](Projects::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if the authenticated user does not have access to the project")]
    Status404,
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(PatchProjectsUpdateResponse403),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Gone")]
    Status410(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an existing project card](Projects::update_card_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsUpdateCardError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationErrorSimple),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an existing project column](Projects::update_column_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ProjectsUpdateColumnError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List project cards](Projects::list_cards_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListCardsParams<'req> {
    /// Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
    archived_state: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ProjectsListCardsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
    pub fn archived_state(self, archived_state: &'req str) -> Self {
        Self { 
            archived_state: Some(archived_state),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            archived_state: self.archived_state, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            archived_state: self.archived_state, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListCardsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List project collaborators](Projects::list_collaborators_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListCollaboratorsParams<'req> {
    /// Filters the collaborators by their affiliation. Can be one of:   \\* `outside`: Outside collaborators of a project that are not a member of the project's organization.   \\* `direct`: Collaborators with permissions to a project, regardless of organization membership status.   \\* `all`: All collaborators the authenticated user can see.
    affiliation: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ProjectsListCollaboratorsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters the collaborators by their affiliation. Can be one of:   \\* `outside`: Outside collaborators of a project that are not a member of the project's organization.   \\* `direct`: Collaborators with permissions to a project, regardless of organization membership status.   \\* `all`: All collaborators the authenticated user can see.
    pub fn affiliation(self, affiliation: &'req str) -> Self {
        Self { 
            affiliation: Some(affiliation),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            affiliation: self.affiliation, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            affiliation: self.affiliation, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListCollaboratorsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List project columns](Projects::list_columns_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListColumnsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ProjectsListColumnsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListColumnsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization projects](Projects::list_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListForOrgParams<'req> {
    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ProjectsListForOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListForOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository projects](Projects::list_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListForRepoParams<'req> {
    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ProjectsListForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List user projects](Projects::list_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ProjectsListForUserParams<'req> {
    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    state: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ProjectsListForUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ProjectsListForUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Projects<'api> {
    /// ---
    ///
    /// # Add project collaborator
    ///
    /// Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator.
    /// 
    /// [GitHub API docs for add_collaborator](https://docs.github.com/rest/reference/projects#add-project-collaborator)
    ///
    /// ---
    pub async fn add_collaborator_async(&self, project_id: i32, username: &str, body: PutProjectsAddCollaborator) -> Result<(), ProjectsAddCollaboratorError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutProjectsAddCollaborator::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsAddCollaboratorError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsAddCollaboratorError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ProjectsAddCollaboratorError::Status304),
                403 => Err(ProjectsAddCollaboratorError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsAddCollaboratorError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsAddCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add project collaborator
    ///
    /// Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator.
    /// 
    /// [GitHub API docs for add_collaborator](https://docs.github.com/rest/reference/projects#add-project-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_collaborator(&self, project_id: i32, username: &str, body: PutProjectsAddCollaborator) -> Result<(), ProjectsAddCollaboratorError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutProjectsAddCollaborator::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsAddCollaboratorError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsAddCollaboratorError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(ProjectsAddCollaboratorError::Status304),
                403 => Err(ProjectsAddCollaboratorError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsAddCollaboratorError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsAddCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a project card
    /// 
    /// [GitHub API docs for create_card](https://docs.github.com/rest/reference/projects#create-a-project-card)
    ///
    /// ---
    pub async fn create_card_async(&self, column_id: i32, body: PostProjectsCreateCard) -> Result<ProjectCard, ProjectsCreateCardError> {

        let request_uri = format!("{}/projects/columns/{}/cards", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateCard::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateCardError::Status304),
                403 => Err(ProjectsCreateCardError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsCreateCardError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsCreateCardError::Status422(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(ProjectsCreateCardError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsCreateCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a project card
    /// 
    /// [GitHub API docs for create_card](https://docs.github.com/rest/reference/projects#create-a-project-card)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_card(&self, column_id: i32, body: PostProjectsCreateCard) -> Result<ProjectCard, ProjectsCreateCardError> {

        let request_uri = format!("{}/projects/columns/{}/cards", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateCard::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateCardError::Status304),
                403 => Err(ProjectsCreateCardError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsCreateCardError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsCreateCardError::Status422(crate::adapters::to_json(github_response)?)),
                503 => Err(ProjectsCreateCardError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsCreateCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a project column
    /// 
    /// [GitHub API docs for create_column](https://docs.github.com/rest/reference/projects#create-a-project-column)
    ///
    /// ---
    pub async fn create_column_async(&self, project_id: i32, body: PostProjectsCreateColumn) -> Result<ProjectColumn, ProjectsCreateColumnError> {

        let request_uri = format!("{}/projects/{}/columns", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateColumn::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateColumnError::Status304),
                403 => Err(ProjectsCreateColumnError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsCreateColumnError::Status422(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsCreateColumnError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsCreateColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a project column
    /// 
    /// [GitHub API docs for create_column](https://docs.github.com/rest/reference/projects#create-a-project-column)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_column(&self, project_id: i32, body: PostProjectsCreateColumn) -> Result<ProjectColumn, ProjectsCreateColumnError> {

        let request_uri = format!("{}/projects/{}/columns", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateColumn::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateColumnError::Status304),
                403 => Err(ProjectsCreateColumnError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsCreateColumnError::Status422(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsCreateColumnError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsCreateColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a user project
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/projects#create-a-user-project)
    ///
    /// ---
    pub async fn create_for_authenticated_user_async(&self, body: PostProjectsCreateForAuthenticatedUser) -> Result<Project, ProjectsCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/projects", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateForAuthenticatedUserError::Status304),
                403 => Err(ProjectsCreateForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsCreateForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                415 => Err(ProjectsCreateForAuthenticatedUserError::Status415(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsCreateForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a user project
    /// 
    /// [GitHub API docs for create_for_authenticated_user](https://docs.github.com/rest/reference/projects#create-a-user-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_authenticated_user(&self, body: PostProjectsCreateForAuthenticatedUser) -> Result<Project, ProjectsCreateForAuthenticatedUserError> {

        let request_uri = format!("{}/user/projects", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForAuthenticatedUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsCreateForAuthenticatedUserError::Status304),
                403 => Err(ProjectsCreateForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsCreateForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                415 => Err(ProjectsCreateForAuthenticatedUserError::Status415(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsCreateForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsCreateForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization project
    ///
    /// Creates an organization project board. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for create_for_org](https://docs.github.com/rest/reference/projects#create-an-organization-project)
    ///
    /// ---
    pub async fn create_for_org_async(&self, org: &str, body: PostProjectsCreateForOrg) -> Result<Project, ProjectsCreateForOrgError> {

        let request_uri = format!("{}/orgs/{}/projects", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsCreateForOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ProjectsCreateForOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsCreateForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ProjectsCreateForOrgError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsCreateForOrgError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsCreateForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization project
    ///
    /// Creates an organization project board. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for create_for_org](https://docs.github.com/rest/reference/projects#create-an-organization-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_org(&self, org: &str, body: PostProjectsCreateForOrg) -> Result<Project, ProjectsCreateForOrgError> {

        let request_uri = format!("{}/orgs/{}/projects", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsCreateForOrgError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(ProjectsCreateForOrgError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsCreateForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(ProjectsCreateForOrgError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsCreateForOrgError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsCreateForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository project
    ///
    /// Creates a repository project board. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for create_for_repo](https://docs.github.com/rest/reference/projects#create-a-repository-project)
    ///
    /// ---
    pub async fn create_for_repo_async(&self, owner: &str, repo: &str, body: PostProjectsCreateForRepo) -> Result<Project, ProjectsCreateForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/projects", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForRepo::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsCreateForRepoError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ProjectsCreateForRepoError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsCreateForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ProjectsCreateForRepoError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsCreateForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsCreateForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a repository project
    ///
    /// Creates a repository project board. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for create_for_repo](https://docs.github.com/rest/reference/projects#create-a-repository-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_for_repo(&self, owner: &str, repo: &str, body: PostProjectsCreateForRepo) -> Result<Project, ProjectsCreateForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/projects", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsCreateForRepo::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsCreateForRepoError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(ProjectsCreateForRepoError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsCreateForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(ProjectsCreateForRepoError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsCreateForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsCreateForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project
    ///
    /// Deletes a project board. Returns a `404 Not Found` status if projects are disabled.
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/projects#delete-a-project)
    ///
    /// ---
    pub async fn delete_async(&self, project_id: i32) -> Result<(), ProjectsDeleteError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteError::Status304),
                403 => Err(ProjectsDeleteError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsDeleteError::Status401(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ProjectsDeleteError::Status410(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsDeleteError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project
    ///
    /// Deletes a project board. Returns a `404 Not Found` status if projects are disabled.
    /// 
    /// [GitHub API docs for delete](https://docs.github.com/rest/reference/projects#delete-a-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete(&self, project_id: i32) -> Result<(), ProjectsDeleteError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteError::Status304),
                403 => Err(ProjectsDeleteError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsDeleteError::Status401(crate::adapters::to_json(github_response)?)),
                410 => Err(ProjectsDeleteError::Status410(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsDeleteError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsDeleteError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project card
    /// 
    /// [GitHub API docs for delete_card](https://docs.github.com/rest/reference/projects#delete-a-project-card)
    ///
    /// ---
    pub async fn delete_card_async(&self, card_id: i32) -> Result<(), ProjectsDeleteCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteCardError::Status304),
                403 => Err(ProjectsDeleteCardError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsDeleteCardError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsDeleteCardError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsDeleteCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project card
    /// 
    /// [GitHub API docs for delete_card](https://docs.github.com/rest/reference/projects#delete-a-project-card)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_card(&self, card_id: i32) -> Result<(), ProjectsDeleteCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteCardError::Status304),
                403 => Err(ProjectsDeleteCardError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsDeleteCardError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsDeleteCardError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsDeleteCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project column
    /// 
    /// [GitHub API docs for delete_column](https://docs.github.com/rest/reference/projects#delete-a-project-column)
    ///
    /// ---
    pub async fn delete_column_async(&self, column_id: i32) -> Result<(), ProjectsDeleteColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteColumnError::Status304),
                403 => Err(ProjectsDeleteColumnError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsDeleteColumnError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsDeleteColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a project column
    /// 
    /// [GitHub API docs for delete_column](https://docs.github.com/rest/reference/projects#delete-a-project-column)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_column(&self, column_id: i32) -> Result<(), ProjectsDeleteColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsDeleteColumnError::Status304),
                403 => Err(ProjectsDeleteColumnError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsDeleteColumnError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsDeleteColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project
    ///
    /// Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/projects#get-a-project)
    ///
    /// ---
    pub async fn get_async(&self, project_id: i32) -> Result<Project, ProjectsGetError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetError::Status304),
                403 => Err(ProjectsGetError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsGetError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project
    ///
    /// Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/projects#get-a-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, project_id: i32) -> Result<Project, ProjectsGetError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetError::Status304),
                403 => Err(ProjectsGetError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsGetError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project card
    /// 
    /// [GitHub API docs for get_card](https://docs.github.com/rest/reference/projects#get-a-project-card)
    ///
    /// ---
    pub async fn get_card_async(&self, card_id: i32) -> Result<ProjectCard, ProjectsGetCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetCardError::Status304),
                403 => Err(ProjectsGetCardError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsGetCardError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsGetCardError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsGetCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project card
    /// 
    /// [GitHub API docs for get_card](https://docs.github.com/rest/reference/projects#get-a-project-card)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_card(&self, card_id: i32) -> Result<ProjectCard, ProjectsGetCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetCardError::Status304),
                403 => Err(ProjectsGetCardError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsGetCardError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsGetCardError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsGetCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project column
    /// 
    /// [GitHub API docs for get_column](https://docs.github.com/rest/reference/projects#get-a-project-column)
    ///
    /// ---
    pub async fn get_column_async(&self, column_id: i32) -> Result<ProjectColumn, ProjectsGetColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetColumnError::Status304),
                403 => Err(ProjectsGetColumnError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsGetColumnError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsGetColumnError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsGetColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a project column
    /// 
    /// [GitHub API docs for get_column](https://docs.github.com/rest/reference/projects#get-a-project-column)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_column(&self, column_id: i32) -> Result<ProjectColumn, ProjectsGetColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsGetColumnError::Status304),
                403 => Err(ProjectsGetColumnError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsGetColumnError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsGetColumnError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsGetColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get project permission for a user
    ///
    /// Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level.
    /// 
    /// [GitHub API docs for get_permission_for_user](https://docs.github.com/rest/reference/projects#get-project-permission-for-a-user)
    ///
    /// ---
    pub async fn get_permission_for_user_async(&self, project_id: i32, username: &str) -> Result<ProjectCollaboratorPermission, ProjectsGetPermissionForUserError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}/permission", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsGetPermissionForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsGetPermissionForUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ProjectsGetPermissionForUserError::Status304),
                403 => Err(ProjectsGetPermissionForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsGetPermissionForUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsGetPermissionForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get project permission for a user
    ///
    /// Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level.
    /// 
    /// [GitHub API docs for get_permission_for_user](https://docs.github.com/rest/reference/projects#get-project-permission-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_permission_for_user(&self, project_id: i32, username: &str) -> Result<ProjectCollaboratorPermission, ProjectsGetPermissionForUserError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}/permission", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsGetPermissionForUserError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsGetPermissionForUserError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(ProjectsGetPermissionForUserError::Status304),
                403 => Err(ProjectsGetPermissionForUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsGetPermissionForUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsGetPermissionForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project cards
    /// 
    /// [GitHub API docs for list_cards](https://docs.github.com/rest/reference/projects#list-project-cards)
    ///
    /// ---
    pub async fn list_cards_async(&self, column_id: i32, query_params: Option<impl Into<ProjectsListCardsParams<'api>>>) -> Result<Vec<ProjectCard>, ProjectsListCardsError> {

        let mut request_uri = format!("{}/projects/columns/{}/cards", super::GITHUB_BASE_API_URL, column_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsListCardsError::Status304),
                403 => Err(ProjectsListCardsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsListCardsError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListCardsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project cards
    /// 
    /// [GitHub API docs for list_cards](https://docs.github.com/rest/reference/projects#list-project-cards)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_cards(&self, column_id: i32, query_params: Option<impl Into<ProjectsListCardsParams<'api>>>) -> Result<Vec<ProjectCard>, ProjectsListCardsError> {

        let mut request_uri = format!("{}/projects/columns/{}/cards", super::GITHUB_BASE_API_URL, column_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListCardsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsListCardsError::Status304),
                403 => Err(ProjectsListCardsError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsListCardsError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListCardsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project collaborators
    ///
    /// Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators.
    /// 
    /// [GitHub API docs for list_collaborators](https://docs.github.com/rest/reference/projects#list-project-collaborators)
    ///
    /// ---
    pub async fn list_collaborators_async(&self, project_id: i32, query_params: Option<impl Into<ProjectsListCollaboratorsParams<'api>>>) -> Result<Vec<SimpleUser>, ProjectsListCollaboratorsError> {

        let mut request_uri = format!("{}/projects/{}/collaborators", super::GITHUB_BASE_API_URL, project_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsListCollaboratorsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsListCollaboratorsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ProjectsListCollaboratorsError::Status304),
                403 => Err(ProjectsListCollaboratorsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsListCollaboratorsError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project collaborators
    ///
    /// Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators.
    /// 
    /// [GitHub API docs for list_collaborators](https://docs.github.com/rest/reference/projects#list-project-collaborators)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_collaborators(&self, project_id: i32, query_params: Option<impl Into<ProjectsListCollaboratorsParams<'api>>>) -> Result<Vec<SimpleUser>, ProjectsListCollaboratorsError> {

        let mut request_uri = format!("{}/projects/{}/collaborators", super::GITHUB_BASE_API_URL, project_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListCollaboratorsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsListCollaboratorsError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsListCollaboratorsError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(ProjectsListCollaboratorsError::Status304),
                403 => Err(ProjectsListCollaboratorsError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsListCollaboratorsError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project columns
    /// 
    /// [GitHub API docs for list_columns](https://docs.github.com/rest/reference/projects#list-project-columns)
    ///
    /// ---
    pub async fn list_columns_async(&self, project_id: i32, query_params: Option<impl Into<ProjectsListColumnsParams>>) -> Result<Vec<ProjectColumn>, ProjectsListColumnsError> {

        let mut request_uri = format!("{}/projects/{}/columns", super::GITHUB_BASE_API_URL, project_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsListColumnsError::Status304),
                403 => Err(ProjectsListColumnsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsListColumnsError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListColumnsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List project columns
    /// 
    /// [GitHub API docs for list_columns](https://docs.github.com/rest/reference/projects#list-project-columns)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_columns(&self, project_id: i32, query_params: Option<impl Into<ProjectsListColumnsParams>>) -> Result<Vec<ProjectColumn>, ProjectsListColumnsError> {

        let mut request_uri = format!("{}/projects/{}/columns", super::GITHUB_BASE_API_URL, project_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListColumnsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsListColumnsError::Status304),
                403 => Err(ProjectsListColumnsError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsListColumnsError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListColumnsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization projects
    ///
    /// Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/projects#list-organization-projects)
    ///
    /// ---
    pub async fn list_for_org_async(&self, org: &str, query_params: Option<impl Into<ProjectsListForOrgParams<'api>>>) -> Result<Vec<Project>, ProjectsListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/projects", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ProjectsListForOrgError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization projects
    ///
    /// Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for list_for_org](https://docs.github.com/rest/reference/projects#list-organization-projects)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_org(&self, org: &str, query_params: Option<impl Into<ProjectsListForOrgParams<'api>>>) -> Result<Vec<Project>, ProjectsListForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/projects", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ProjectsListForOrgError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository projects
    ///
    /// Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for list_for_repo](https://docs.github.com/rest/reference/projects#list-repository-projects)
    ///
    /// ---
    pub async fn list_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ProjectsListForRepoParams<'api>>>) -> Result<Vec<Project>, ProjectsListForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/projects", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsListForRepoError::Status401(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ProjectsListForRepoError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsListForRepoError::Status404(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ProjectsListForRepoError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsListForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository projects
    ///
    /// Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for list_for_repo](https://docs.github.com/rest/reference/projects#list-repository-projects)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ProjectsListForRepoParams<'api>>>) -> Result<Vec<Project>, ProjectsListForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/projects", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                401 => Err(ProjectsListForRepoError::Status401(crate::adapters::to_json(github_response)?)),
                403 => Err(ProjectsListForRepoError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsListForRepoError::Status404(crate::adapters::to_json(github_response)?)),
                410 => Err(ProjectsListForRepoError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsListForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user projects
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/projects#list-user-projects)
    ///
    /// ---
    pub async fn list_for_user_async(&self, username: &str, query_params: Option<impl Into<ProjectsListForUserParams<'api>>>) -> Result<Vec<Project>, ProjectsListForUserError> {

        let mut request_uri = format!("{}/users/{}/projects", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ProjectsListForUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List user projects
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/projects#list-user-projects)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_user(&self, username: &str, query_params: Option<impl Into<ProjectsListForUserParams<'api>>>) -> Result<Vec<Project>, ProjectsListForUserError> {

        let mut request_uri = format!("{}/users/{}/projects", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ProjectsListForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ProjectsListForUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Move a project card
    /// 
    /// [GitHub API docs for move_card](https://docs.github.com/rest/reference/projects#move-a-project-card)
    ///
    /// ---
    pub async fn move_card_async(&self, card_id: i32, body: PostProjectsMoveCard) -> Result<HashMap<String, Value>, ProjectsMoveCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}/moves", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsMoveCard::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsMoveCardError::Status304),
                403 => Err(ProjectsMoveCardError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsMoveCardError::Status401(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(ProjectsMoveCardError::Status503(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsMoveCardError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsMoveCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Move a project card
    /// 
    /// [GitHub API docs for move_card](https://docs.github.com/rest/reference/projects#move-a-project-card)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn move_card(&self, card_id: i32, body: PostProjectsMoveCard) -> Result<HashMap<String, Value>, ProjectsMoveCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}/moves", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsMoveCard::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsMoveCardError::Status304),
                403 => Err(ProjectsMoveCardError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsMoveCardError::Status401(crate::adapters::to_json(github_response)?)),
                503 => Err(ProjectsMoveCardError::Status503(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsMoveCardError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsMoveCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Move a project column
    /// 
    /// [GitHub API docs for move_column](https://docs.github.com/rest/reference/projects#move-a-project-column)
    ///
    /// ---
    pub async fn move_column_async(&self, column_id: i32, body: PostProjectsMoveColumn) -> Result<HashMap<String, Value>, ProjectsMoveColumnError> {

        let request_uri = format!("{}/projects/columns/{}/moves", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsMoveColumn::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsMoveColumnError::Status304),
                403 => Err(ProjectsMoveColumnError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsMoveColumnError::Status422(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsMoveColumnError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsMoveColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Move a project column
    /// 
    /// [GitHub API docs for move_column](https://docs.github.com/rest/reference/projects#move-a-project-column)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn move_column(&self, column_id: i32, body: PostProjectsMoveColumn) -> Result<HashMap<String, Value>, ProjectsMoveColumnError> {

        let request_uri = format!("{}/projects/columns/{}/moves", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostProjectsMoveColumn::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsMoveColumnError::Status304),
                403 => Err(ProjectsMoveColumnError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsMoveColumnError::Status422(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsMoveColumnError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsMoveColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove user as a collaborator
    ///
    /// Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator.
    /// 
    /// [GitHub API docs for remove_collaborator](https://docs.github.com/rest/reference/projects#remove-project-collaborator)
    ///
    /// ---
    pub async fn remove_collaborator_async(&self, project_id: i32, username: &str) -> Result<(), ProjectsRemoveCollaboratorError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsRemoveCollaboratorError::Status304),
                404 => Err(ProjectsRemoveCollaboratorError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ProjectsRemoveCollaboratorError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsRemoveCollaboratorError::Status422(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsRemoveCollaboratorError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsRemoveCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove user as a collaborator
    ///
    /// Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator.
    /// 
    /// [GitHub API docs for remove_collaborator](https://docs.github.com/rest/reference/projects#remove-project-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_collaborator(&self, project_id: i32, username: &str) -> Result<(), ProjectsRemoveCollaboratorError> {

        let request_uri = format!("{}/projects/{}/collaborators/{}", super::GITHUB_BASE_API_URL, project_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsRemoveCollaboratorError::Status304),
                404 => Err(ProjectsRemoveCollaboratorError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ProjectsRemoveCollaboratorError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsRemoveCollaboratorError::Status422(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsRemoveCollaboratorError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsRemoveCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a project
    ///
    /// Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/projects#update-a-project)
    ///
    /// ---
    pub async fn update_async(&self, project_id: i32, body: PatchProjectsUpdate) -> Result<Project, ProjectsUpdateError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsUpdateError::Status404),
                304 => Err(ProjectsUpdateError::Status304),
                403 => Err(ProjectsUpdateError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsUpdateError::Status401(crate::adapters::to_json_async(github_response).await?)),
                410 => Err(ProjectsUpdateError::Status410(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a project
    ///
    /// Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/projects#update-a-project)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, project_id: i32, body: PatchProjectsUpdate) -> Result<Project, ProjectsUpdateError> {

        let request_uri = format!("{}/projects/{}", super::GITHUB_BASE_API_URL, project_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ProjectsUpdateError::Status404),
                304 => Err(ProjectsUpdateError::Status304),
                403 => Err(ProjectsUpdateError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsUpdateError::Status401(crate::adapters::to_json(github_response)?)),
                410 => Err(ProjectsUpdateError::Status410(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing project card
    /// 
    /// [GitHub API docs for update_card](https://docs.github.com/rest/reference/projects#update-a-project-card)
    ///
    /// ---
    pub async fn update_card_async(&self, card_id: i32, body: PatchProjectsUpdateCard) -> Result<ProjectCard, ProjectsUpdateCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdateCard::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsUpdateCardError::Status304),
                403 => Err(ProjectsUpdateCardError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsUpdateCardError::Status401(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ProjectsUpdateCardError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ProjectsUpdateCardError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsUpdateCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing project card
    /// 
    /// [GitHub API docs for update_card](https://docs.github.com/rest/reference/projects#update-a-project-card)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_card(&self, card_id: i32, body: PatchProjectsUpdateCard) -> Result<ProjectCard, ProjectsUpdateCardError> {

        let request_uri = format!("{}/projects/columns/cards/{}", super::GITHUB_BASE_API_URL, card_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdateCard::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsUpdateCardError::Status304),
                403 => Err(ProjectsUpdateCardError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsUpdateCardError::Status401(crate::adapters::to_json(github_response)?)),
                404 => Err(ProjectsUpdateCardError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(ProjectsUpdateCardError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsUpdateCardError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing project column
    /// 
    /// [GitHub API docs for update_column](https://docs.github.com/rest/reference/projects#update-a-project-column)
    ///
    /// ---
    pub async fn update_column_async(&self, column_id: i32, body: PatchProjectsUpdateColumn) -> Result<ProjectColumn, ProjectsUpdateColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdateColumn::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsUpdateColumnError::Status304),
                403 => Err(ProjectsUpdateColumnError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ProjectsUpdateColumnError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ProjectsUpdateColumnError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an existing project column
    /// 
    /// [GitHub API docs for update_column](https://docs.github.com/rest/reference/projects#update-a-project-column)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_column(&self, column_id: i32, body: PatchProjectsUpdateColumn) -> Result<ProjectColumn, ProjectsUpdateColumnError> {

        let request_uri = format!("{}/projects/columns/{}", super::GITHUB_BASE_API_URL, column_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchProjectsUpdateColumn::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ProjectsUpdateColumnError::Status304),
                403 => Err(ProjectsUpdateColumnError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ProjectsUpdateColumnError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ProjectsUpdateColumnError::Generic { code }),
            }
        }
    }

}
