//! Method, error and parameter types for the Orgs endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Orgs<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Orgs {
    Orgs { auth }
}

/// Errors for the [Block a user from an organization](Orgs::block_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsBlockUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Cancel an organization invitation](Orgs::cancel_invitation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCancelInvitationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check if a user is blocked by an organization](Orgs::check_blocked_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCheckBlockedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("If the user is not blocked:")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check organization membership for a user](Orgs::check_membership_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCheckMembershipForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if requester is not an organization member")]
    Status302,
    #[error("Not Found if requester is an organization member and user is not a member")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Check public organization membership for a user](Orgs::check_public_membership_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCheckPublicMembershipForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if user is not a public member")]
    Status404,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Convert an organization member to outside collaborator](Orgs::convert_member_to_outside_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsConvertMemberToOutsideCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("User was converted")]
    Status204,
    #[error("Forbidden if user is the last owner of the organization or not a member of the organization")]
    Status403,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an organization invitation](Orgs::create_invitation_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCreateInvitationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create an organization webhook](Orgs::create_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsCreateWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an organization webhook](Orgs::delete_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsDeleteWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization](Orgs::get_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the audit log for an organization](Orgs::get_audit_log_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetAuditLogError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization membership for the authenticated user](Orgs::get_membership_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetMembershipForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get organization membership for a user](Orgs::get_membership_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetMembershipForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization webhook](Orgs::get_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a webhook configuration for an organization](Orgs::get_webhook_config_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetWebhookConfigForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a webhook delivery for an organization webhook](Orgs::get_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsGetWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organizations](Orgs::list_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List app installations for an organization](Orgs::list_app_installations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListAppInstallationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List users blocked by an organization](Orgs::list_blocked_users_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListBlockedUsersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Preview header missing")]
    Status415(PostProjectsCreateForAuthenticatedUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List failed organization invitations](Orgs::list_failed_invitations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListFailedInvitationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organizations for the authenticated user](Orgs::list_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organizations for a user](Orgs::list_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization invitation teams](Orgs::list_invitation_teams_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListInvitationTeamsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization members](Orgs::list_members_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListMembersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response if requester is not an organization member")]
    Status302,
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization memberships for the authenticated user](Orgs::list_memberships_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListMembershipsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List outside collaborators for an organization](Orgs::list_outside_collaborators_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListOutsideCollaboratorsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List pending organization invitations](Orgs::list_pending_invitations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListPendingInvitationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public organization members](Orgs::list_public_members_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListPublicMembersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List SAML SSO authorizations for an organization](Orgs::list_saml_sso_authorizations_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListSamlSsoAuthorizationsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List deliveries for an organization webhook](Orgs::list_webhook_deliveries_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListWebhookDeliveriesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization webhooks](Orgs::list_webhooks_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsListWebhooksError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Ping an organization webhook](Orgs::ping_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsPingWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Redeliver a delivery for an organization webhook](Orgs::redeliver_webhook_delivery_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRedeliverWebhookDeliveryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Bad Request")]
    Status400(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove an organization member](Orgs::remove_member_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRemoveMemberError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove organization membership for a user](Orgs::remove_membership_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRemoveMembershipForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove outside collaborator from an organization](Orgs::remove_outside_collaborator_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRemoveOutsideCollaboratorError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Unprocessable Entity if user is a member of the organization")]
    Status422(PutTeamsAddOrUpdateProjectPermissionsLegacyResponse403),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove public organization membership for the authenticated user](Orgs::remove_public_membership_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRemovePublicMembershipForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a SAML SSO authorization for an organization](Orgs::remove_saml_sso_authorization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsRemoveSamlSsoAuthorizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set organization membership for a user](Orgs::set_membership_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsSetMembershipForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set public organization membership for the authenticated user](Orgs::set_public_membership_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsSetPublicMembershipForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unblock a user from an organization](Orgs::unblock_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsUnblockUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an organization](Orgs::update_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsUpdateError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(PostProjectsCreateCardResponse422),
    #[error("Conflict")]
    Status409(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an organization membership for the authenticated user](Orgs::update_membership_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsUpdateMembershipForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an organization webhook](Orgs::update_webhook_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsUpdateWebhookError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a webhook configuration for an organization](Orgs::update_webhook_config_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum OrgsUpdateWebhookConfigForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get the audit log for an organization](Orgs::get_audit_log_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsGetAuditLogParams<'req> {
    /// A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log).
    phrase: Option<&'req str>, 
    /// The event types to include:  - `web` - returns web (non-Git) events - `git` - returns Git events - `all` - returns both web and Git events  The default is `web`.
    include: Option<&'req str>, 
    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.
    after: Option<&'req str>, 
    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor.
    before: Option<&'req str>, 
    /// The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.  The default is `desc`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> OrgsGetAuditLogParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log).
    pub fn phrase(self, phrase: &'req str) -> Self {
        Self { 
            phrase: Some(phrase),
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The event types to include:  - `web` - returns web (non-Git) events - `git` - returns Git events - `all` - returns both web and Git events  The default is `web`.
    pub fn include(self, include: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: Some(include),
            after: self.after, 
            before: self.before, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.
    pub fn after(self, after: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: Some(after),
            before: self.before, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor.
    pub fn before(self, before: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: Some(before),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.  The default is `desc`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsGetAuditLogParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organizations](Orgs::list_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListParams {
    /// An organization ID. Only return organizations with an ID greater than this ID.
    since: Option<i32>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl OrgsListParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// An organization ID. Only return organizations with an ID greater than this ID.
    pub fn since(self, since: i32) -> Self {
        Self { 
            since: Some(since),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            since: self.since, 
            per_page: Some(per_page),
        }
    }
}

/// Query parameters for the [List app installations for an organization](Orgs::list_app_installations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListAppInstallationsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListAppInstallationsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListAppInstallationsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List failed organization invitations](Orgs::list_failed_invitations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListFailedInvitationsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListFailedInvitationsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListFailedInvitationsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organizations for the authenticated user](Orgs::list_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organizations for a user](Orgs::list_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization invitation teams](Orgs::list_invitation_teams_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListInvitationTeamsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListInvitationTeamsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListInvitationTeamsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization members](Orgs::list_members_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListMembersParams<'req> {
    /// Filter members returned in the list. Can be one of:   \\* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.   \\* `all` - All members the authenticated user can see.
    filter: Option<&'req str>, 
    /// Filter members returned by their role. Can be one of:   \\* `all` - All members of the organization, regardless of role.   \\* `admin` - Organization owners.   \\* `member` - Non-owner organization members.
    role: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> OrgsListMembersParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filter members returned in the list. Can be one of:   \\* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.   \\* `all` - All members the authenticated user can see.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            role: self.role, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Filter members returned by their role. Can be one of:   \\* `all` - All members of the organization, regardless of role.   \\* `admin` - Organization owners.   \\* `member` - Non-owner organization members.
    pub fn role(self, role: &'req str) -> Self {
        Self { 
            filter: self.filter, 
            role: Some(role),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            role: self.role, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            role: self.role, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListMembersParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization memberships for the authenticated user](Orgs::list_memberships_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListMembershipsForAuthenticatedUserParams<'req> {
    /// Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
    state: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> OrgsListMembershipsForAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            state: Some(state),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            state: self.state, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListMembershipsForAuthenticatedUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List outside collaborators for an organization](Orgs::list_outside_collaborators_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListOutsideCollaboratorsParams<'req> {
    /// Filter the list of outside collaborators. Can be one of:   \\* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.   \\* `all`: All outside collaborators.
    filter: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> OrgsListOutsideCollaboratorsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filter the list of outside collaborators. Can be one of:   \\* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.   \\* `all`: All outside collaborators.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListOutsideCollaboratorsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List pending organization invitations](Orgs::list_pending_invitations_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListPendingInvitationsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListPendingInvitationsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListPendingInvitationsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public organization members](Orgs::list_public_members_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListPublicMembersParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListPublicMembersParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListPublicMembersParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List deliveries for an organization webhook](Orgs::list_webhook_deliveries_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListWebhookDeliveriesParams<'req> {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    cursor: Option<&'req str>
}

impl<'req> OrgsListWebhookDeliveriesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            cursor: self.cursor, 
        }
    }

    /// Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors.
    pub fn cursor(self, cursor: &'req str) -> Self {
        Self { 
            per_page: self.per_page, 
            cursor: Some(cursor),
        }
    }
}

/// Query parameters for the [List organization webhooks](Orgs::list_webhooks_async()) endpoint.
#[derive(Default, Serialize)]
pub struct OrgsListWebhooksParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl OrgsListWebhooksParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for OrgsListWebhooksParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Orgs<'api> {
    /// ---
    ///
    /// # Block a user from an organization
    /// 
    /// [GitHub API docs for block_user](https://docs.github.com/rest/reference/orgs#block-a-user-from-an-organization)
    ///
    /// ---
    pub async fn block_user_async(&self, org: &str, username: &str) -> Result<(), OrgsBlockUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsBlockUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsBlockUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Block a user from an organization
    /// 
    /// [GitHub API docs for block_user](https://docs.github.com/rest/reference/orgs#block-a-user-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn block_user(&self, org: &str, username: &str) -> Result<(), OrgsBlockUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsBlockUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsBlockUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    /// 
    /// [GitHub API docs for cancel_invitation](https://docs.github.com/rest/reference/orgs#cancel-an-organization-invitation)
    ///
    /// ---
    pub async fn cancel_invitation_async(&self, org: &str, invitation_id: i32) -> Result<(), OrgsCancelInvitationError> {

        let request_uri = format!("{}/orgs/{}/invitations/{}", super::GITHUB_BASE_API_URL, org, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCancelInvitationError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsCancelInvitationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsCancelInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Cancel an organization invitation
    ///
    /// Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    /// 
    /// [GitHub API docs for cancel_invitation](https://docs.github.com/rest/reference/orgs#cancel-an-organization-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn cancel_invitation(&self, org: &str, invitation_id: i32) -> Result<(), OrgsCancelInvitationError> {

        let request_uri = format!("{}/orgs/{}/invitations/{}", super::GITHUB_BASE_API_URL, org, invitation_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCancelInvitationError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsCancelInvitationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsCancelInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is blocked by an organization
    /// 
    /// [GitHub API docs for check_blocked_user](https://docs.github.com/rest/reference/orgs#check-if-a-user-is-blocked-by-an-organization)
    ///
    /// ---
    pub async fn check_blocked_user_async(&self, org: &str, username: &str) -> Result<(), OrgsCheckBlockedUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsCheckBlockedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsCheckBlockedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a user is blocked by an organization
    /// 
    /// [GitHub API docs for check_blocked_user](https://docs.github.com/rest/reference/orgs#check-if-a-user-is-blocked-by-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_blocked_user(&self, org: &str, username: &str) -> Result<(), OrgsCheckBlockedUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsCheckBlockedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsCheckBlockedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check organization membership for a user
    ///
    /// Check if a user is, publicly or privately, a member of the organization.
    /// 
    /// [GitHub API docs for check_membership_for_user](https://docs.github.com/rest/reference/orgs#check-organization-membership-for-a-user)
    ///
    /// ---
    pub async fn check_membership_for_user_async(&self, org: &str, username: &str) -> Result<(), OrgsCheckMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(OrgsCheckMembershipForUserError::Status302),
                404 => Err(OrgsCheckMembershipForUserError::Status404),
                code => Err(OrgsCheckMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check organization membership for a user
    ///
    /// Check if a user is, publicly or privately, a member of the organization.
    /// 
    /// [GitHub API docs for check_membership_for_user](https://docs.github.com/rest/reference/orgs#check-organization-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_membership_for_user(&self, org: &str, username: &str) -> Result<(), OrgsCheckMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(OrgsCheckMembershipForUserError::Status302),
                404 => Err(OrgsCheckMembershipForUserError::Status404),
                code => Err(OrgsCheckMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check public organization membership for a user
    /// 
    /// [GitHub API docs for check_public_membership_for_user](https://docs.github.com/rest/reference/orgs#check-public-organization-membership-for-a-user)
    ///
    /// ---
    pub async fn check_public_membership_for_user_async(&self, org: &str, username: &str) -> Result<(), OrgsCheckPublicMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsCheckPublicMembershipForUserError::Status404),
                code => Err(OrgsCheckPublicMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check public organization membership for a user
    /// 
    /// [GitHub API docs for check_public_membership_for_user](https://docs.github.com/rest/reference/orgs#check-public-organization-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_public_membership_for_user(&self, org: &str, username: &str) -> Result<(), OrgsCheckPublicMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsCheckPublicMembershipForUserError::Status404),
                code => Err(OrgsCheckPublicMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Convert an organization member to outside collaborator
    ///
    /// When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://help.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)".
    /// 
    /// [GitHub API docs for convert_member_to_outside_collaborator](https://docs.github.com/rest/reference/orgs#convert-an-organization-member-to-outside-collaborator)
    ///
    /// ---
    pub async fn convert_member_to_outside_collaborator_async(&self, org: &str, username: &str) -> Result<HashMap<String, Value>, OrgsConvertMemberToOutsideCollaboratorError> {

        let request_uri = format!("{}/orgs/{}/outside_collaborators/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status204),
                403 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status403),
                404 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsConvertMemberToOutsideCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Convert an organization member to outside collaborator
    ///
    /// When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://help.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)".
    /// 
    /// [GitHub API docs for convert_member_to_outside_collaborator](https://docs.github.com/rest/reference/orgs#convert-an-organization-member-to-outside-collaborator)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn convert_member_to_outside_collaborator(&self, org: &str, username: &str) -> Result<HashMap<String, Value>, OrgsConvertMemberToOutsideCollaboratorError> {

        let request_uri = format!("{}/orgs/{}/outside_collaborators/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status204),
                403 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status403),
                404 => Err(OrgsConvertMemberToOutsideCollaboratorError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsConvertMemberToOutsideCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_invitation](https://docs.github.com/rest/reference/orgs#create-an-organization-invitation)
    ///
    /// ---
    pub async fn create_invitation_async(&self, org: &str, body: PostOrgsCreateInvitation) -> Result<OrganizationInvitation, OrgsCreateInvitationError> {

        let request_uri = format!("{}/orgs/{}/invitations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOrgsCreateInvitation::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCreateInvitationError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsCreateInvitationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsCreateInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization invitation
    ///
    /// Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
    /// 
    /// This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
    /// 
    /// [GitHub API docs for create_invitation](https://docs.github.com/rest/reference/orgs#create-an-organization-invitation)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_invitation(&self, org: &str, body: PostOrgsCreateInvitation) -> Result<OrganizationInvitation, OrgsCreateInvitationError> {

        let request_uri = format!("{}/orgs/{}/invitations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOrgsCreateInvitation::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCreateInvitationError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsCreateInvitationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsCreateInvitationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization webhook
    ///
    /// Here's how you can create a hook that posts payloads in JSON format:
    /// 
    /// [GitHub API docs for create_webhook](https://docs.github.com/rest/reference/orgs#create-an-organization-webhook)
    ///
    /// ---
    pub async fn create_webhook_async(&self, org: &str, body: PostOrgsCreateWebhook) -> Result<OrgHook, OrgsCreateWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOrgsCreateWebhook::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCreateWebhookError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsCreateWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsCreateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create an organization webhook
    ///
    /// Here's how you can create a hook that posts payloads in JSON format:
    /// 
    /// [GitHub API docs for create_webhook](https://docs.github.com/rest/reference/orgs#create-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_webhook(&self, org: &str, body: PostOrgsCreateWebhook) -> Result<OrgHook, OrgsCreateWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostOrgsCreateWebhook::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsCreateWebhookError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsCreateWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsCreateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization webhook
    /// 
    /// [GitHub API docs for delete_webhook](https://docs.github.com/rest/reference/orgs#delete-an-organization-webhook)
    ///
    /// ---
    pub async fn delete_webhook_async(&self, org: &str, hook_id: i32) -> Result<(), OrgsDeleteWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsDeleteWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsDeleteWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization webhook
    /// 
    /// [GitHub API docs for delete_webhook](https://docs.github.com/rest/reference/orgs#delete-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_webhook(&self, org: &str, hook_id: i32) -> Result<(), OrgsDeleteWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsDeleteWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsDeleteWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization
    ///
    /// To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    /// 
    /// GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub plan. See "[Authenticating with GitHub Apps](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub plan information' below."
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/orgs#get-an-organization)
    ///
    /// ---
    pub async fn get_async(&self, org: &str) -> Result<OrganizationFull, OrgsGetError> {

        let request_uri = format!("{}/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization
    ///
    /// To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
    /// 
    /// GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub plan. See "[Authenticating with GitHub Apps](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub plan information' below."
    /// 
    /// [GitHub API docs for get](https://docs.github.com/rest/reference/orgs#get-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get(&self, org: &str) -> Result<OrganizationFull, OrgsGetError> {

        let request_uri = format!("{}/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsGetError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the audit log for an organization
    ///
    /// Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
    /// 
    /// To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_audit_log](https://docs.github.com/rest/reference/orgs#get-audit-log)
    ///
    /// ---
    pub async fn get_audit_log_async(&self, org: &str, query_params: Option<impl Into<OrgsGetAuditLogParams<'api>>>) -> Result<Vec<AuditLogEvent>, OrgsGetAuditLogError> {

        let mut request_uri = format!("{}/orgs/{}/audit-log", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsGetAuditLogError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the audit log for an organization
    ///
    /// Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
    /// 
    /// To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_audit_log](https://docs.github.com/rest/reference/orgs#get-audit-log)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_audit_log(&self, org: &str, query_params: Option<impl Into<OrgsGetAuditLogParams<'api>>>) -> Result<Vec<AuditLogEvent>, OrgsGetAuditLogError> {

        let mut request_uri = format!("{}/orgs/{}/audit-log", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsGetAuditLogParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsGetAuditLogError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization membership for the authenticated user
    /// 
    /// [GitHub API docs for get_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#get-an-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_membership_for_authenticated_user_async(&self, org: &str) -> Result<OrgMembership, OrgsGetMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/user/memberships/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsGetMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsGetMembershipForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsGetMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization membership for the authenticated user
    /// 
    /// [GitHub API docs for get_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#get-an-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_membership_for_authenticated_user(&self, org: &str) -> Result<OrgMembership, OrgsGetMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/user/memberships/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsGetMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsGetMembershipForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsGetMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get organization membership for a user
    ///
    /// In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
    /// 
    /// [GitHub API docs for get_membership_for_user](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user)
    ///
    /// ---
    pub async fn get_membership_for_user_async(&self, org: &str, username: &str) -> Result<OrgMembership, OrgsGetMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetMembershipForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(OrgsGetMembershipForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsGetMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get organization membership for a user
    ///
    /// In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
    /// 
    /// [GitHub API docs for get_membership_for_user](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_membership_for_user(&self, org: &str, username: &str) -> Result<OrgMembership, OrgsGetMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetMembershipForUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(OrgsGetMembershipForUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsGetMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)."
    /// 
    /// [GitHub API docs for get_webhook](https://docs.github.com/rest/reference/orgs#get-an-organization-webhook)
    ///
    /// ---
    pub async fn get_webhook_async(&self, org: &str, hook_id: i32) -> Result<OrgHook, OrgsGetWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsGetWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization webhook
    ///
    /// Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)."
    /// 
    /// [GitHub API docs for get_webhook](https://docs.github.com/rest/reference/orgs#get-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook(&self, org: &str, hook_id: i32) -> Result<OrgHook, OrgsGetWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsGetWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsGetWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
    /// 
    /// Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
    /// 
    /// [GitHub API docs for get_webhook_config_for_org](https://docs.github.com/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)
    ///
    /// ---
    pub async fn get_webhook_config_for_org_async(&self, org: &str, hook_id: i32) -> Result<WebhookConfig, OrgsGetWebhookConfigForOrgError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsGetWebhookConfigForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook configuration for an organization
    ///
    /// Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
    /// 
    /// Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
    /// 
    /// [GitHub API docs for get_webhook_config_for_org](https://docs.github.com/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_config_for_org(&self, org: &str, hook_id: i32) -> Result<WebhookConfig, OrgsGetWebhookConfigForOrgError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsGetWebhookConfigForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/orgs#get-a-webhook-delivery-for-an-organization-webhook)
    ///
    /// ---
    pub async fn get_webhook_delivery_async(&self, org: &str, hook_id: i32, delivery_id: i32) -> Result<HookDelivery, OrgsGetWebhookDeliveryError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/deliveries/{}", super::GITHUB_BASE_API_URL, org, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsGetWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OrgsGetWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a webhook delivery for an organization webhook
    ///
    /// Returns a delivery for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for get_webhook_delivery](https://docs.github.com/rest/reference/orgs#get-a-webhook-delivery-for-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_webhook_delivery(&self, org: &str, hook_id: i32, delivery_id: i32) -> Result<HookDelivery, OrgsGetWebhookDeliveryError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/deliveries/{}", super::GITHUB_BASE_API_URL, org, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsGetWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(OrgsGetWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsGetWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations
    ///
    /// Lists all organizations, in the order that they were created on GitHub.
    /// 
    /// **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/orgs#list-organizations)
    ///
    /// ---
    pub async fn list_async(&self, query_params: Option<impl Into<OrgsListParams>>) -> Result<Vec<OrganizationSimple>, OrgsListError> {

        let mut request_uri = format!("{}/organizations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListError::Status304),
                code => Err(OrgsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations
    ///
    /// Lists all organizations, in the order that they were created on GitHub.
    /// 
    /// **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
    /// 
    /// [GitHub API docs for list](https://docs.github.com/rest/reference/orgs#list-organizations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list(&self, query_params: Option<impl Into<OrgsListParams>>) -> Result<Vec<OrganizationSimple>, OrgsListError> {

        let mut request_uri = format!("{}/organizations", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListError::Status304),
                code => Err(OrgsListError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_app_installations](https://docs.github.com/rest/reference/orgs#list-app-installations-for-an-organization)
    ///
    /// ---
    pub async fn list_app_installations_async(&self, org: &str, query_params: Option<impl Into<OrgsListAppInstallationsParams>>) -> Result<GetAppsListInstallationsForAuthenticatedUserResponse200, OrgsListAppInstallationsError> {

        let mut request_uri = format!("{}/orgs/{}/installations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListAppInstallationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List app installations for an organization
    ///
    /// Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_app_installations](https://docs.github.com/rest/reference/orgs#list-app-installations-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_app_installations(&self, org: &str, query_params: Option<impl Into<OrgsListAppInstallationsParams>>) -> Result<GetAppsListInstallationsForAuthenticatedUserResponse200, OrgsListAppInstallationsError> {

        let mut request_uri = format!("{}/orgs/{}/installations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListAppInstallationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListAppInstallationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    /// 
    /// [GitHub API docs for list_blocked_users](https://docs.github.com/rest/reference/orgs#list-users-blocked-by-an-organization)
    ///
    /// ---
    pub async fn list_blocked_users_async(&self, org: &str) -> Result<Vec<SimpleUser>, OrgsListBlockedUsersError> {

        let request_uri = format!("{}/orgs/{}/blocks", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                415 => Err(OrgsListBlockedUsersError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListBlockedUsersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List users blocked by an organization
    ///
    /// List the users blocked by an organization.
    /// 
    /// [GitHub API docs for list_blocked_users](https://docs.github.com/rest/reference/orgs#list-users-blocked-by-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_blocked_users(&self, org: &str) -> Result<Vec<SimpleUser>, OrgsListBlockedUsersError> {

        let request_uri = format!("{}/orgs/{}/blocks", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                415 => Err(OrgsListBlockedUsersError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListBlockedUsersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    /// 
    /// [GitHub API docs for list_failed_invitations](https://docs.github.com/rest/reference/orgs#list-failed-organization-invitations)
    ///
    /// ---
    pub async fn list_failed_invitations_async(&self, org: &str, query_params: Option<impl Into<OrgsListFailedInvitationsParams>>) -> Result<Vec<OrganizationInvitation>, OrgsListFailedInvitationsError> {

        let mut request_uri = format!("{}/orgs/{}/failed_invitations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListFailedInvitationsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListFailedInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List failed organization invitations
    ///
    /// The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.
    /// 
    /// [GitHub API docs for list_failed_invitations](https://docs.github.com/rest/reference/orgs#list-failed-organization-invitations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_failed_invitations(&self, org: &str, query_params: Option<impl Into<OrgsListFailedInvitationsParams>>) -> Result<Vec<OrganizationInvitation>, OrgsListFailedInvitationsError> {

        let mut request_uri = format!("{}/orgs/{}/failed_invitations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListFailedInvitationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListFailedInvitationsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListFailedInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations for the authenticated user
    ///
    /// List organizations for the authenticated user.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_for_authenticated_user_async(&self, query_params: Option<impl Into<OrgsListForAuthenticatedUserParams>>) -> Result<Vec<OrganizationSimple>, OrgsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/orgs", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListForAuthenticatedUserError::Status304),
                403 => Err(OrgsListForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OrgsListForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations for the authenticated user
    ///
    /// List organizations for the authenticated user.
    /// 
    /// **OAuth scope requirements**
    /// 
    /// This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
    /// 
    /// [GitHub API docs for list_for_authenticated_user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_authenticated_user(&self, query_params: Option<impl Into<OrgsListForAuthenticatedUserParams>>) -> Result<Vec<OrganizationSimple>, OrgsListForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/orgs", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListForAuthenticatedUserError::Status304),
                403 => Err(OrgsListForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OrgsListForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations for a user
    ///
    /// List [public organization memberships](https://help.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
    /// 
    /// This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user) API instead.
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/orgs#list-organizations-for-a-user)
    ///
    /// ---
    pub async fn list_for_user_async(&self, username: &str, query_params: Option<impl Into<OrgsListForUserParams>>) -> Result<Vec<OrganizationSimple>, OrgsListForUserError> {

        let mut request_uri = format!("{}/users/{}/orgs", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organizations for a user
    ///
    /// List [public organization memberships](https://help.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
    /// 
    /// This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user) API instead.
    /// 
    /// [GitHub API docs for list_for_user](https://docs.github.com/rest/reference/orgs#list-organizations-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_for_user(&self, username: &str, query_params: Option<impl Into<OrgsListForUserParams>>) -> Result<Vec<OrganizationSimple>, OrgsListForUserError> {

        let mut request_uri = format!("{}/users/{}/orgs", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    /// 
    /// [GitHub API docs for list_invitation_teams](https://docs.github.com/rest/reference/orgs#list-organization-invitation-teams)
    ///
    /// ---
    pub async fn list_invitation_teams_async(&self, org: &str, invitation_id: i32, query_params: Option<impl Into<OrgsListInvitationTeamsParams>>) -> Result<Vec<Team>, OrgsListInvitationTeamsError> {

        let mut request_uri = format!("{}/orgs/{}/invitations/{}/teams", super::GITHUB_BASE_API_URL, org, invitation_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListInvitationTeamsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListInvitationTeamsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization invitation teams
    ///
    /// List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
    /// 
    /// [GitHub API docs for list_invitation_teams](https://docs.github.com/rest/reference/orgs#list-organization-invitation-teams)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_invitation_teams(&self, org: &str, invitation_id: i32, query_params: Option<impl Into<OrgsListInvitationTeamsParams>>) -> Result<Vec<Team>, OrgsListInvitationTeamsError> {

        let mut request_uri = format!("{}/orgs/{}/invitations/{}/teams", super::GITHUB_BASE_API_URL, org, invitation_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListInvitationTeamsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListInvitationTeamsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListInvitationTeamsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    /// 
    /// [GitHub API docs for list_members](https://docs.github.com/rest/reference/orgs#list-organization-members)
    ///
    /// ---
    pub async fn list_members_async(&self, org: &str, query_params: Option<impl Into<OrgsListMembersParams<'api>>>) -> Result<Vec<SimpleUser>, OrgsListMembersError> {

        let mut request_uri = format!("{}/orgs/{}/members", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(OrgsListMembersError::Status302),
                422 => Err(OrgsListMembersError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListMembersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization members
    ///
    /// List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
    /// 
    /// [GitHub API docs for list_members](https://docs.github.com/rest/reference/orgs#list-organization-members)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_members(&self, org: &str, query_params: Option<impl Into<OrgsListMembersParams<'api>>>) -> Result<Vec<SimpleUser>, OrgsListMembersError> {

        let mut request_uri = format!("{}/orgs/{}/members", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListMembersParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(OrgsListMembersError::Status302),
                422 => Err(OrgsListMembersError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListMembersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization memberships for the authenticated user
    /// 
    /// [GitHub API docs for list_memberships_for_authenticated_user](https://docs.github.com/rest/reference/orgs#list-organization-memberships-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_memberships_for_authenticated_user_async(&self, query_params: Option<impl Into<OrgsListMembershipsForAuthenticatedUserParams<'api>>>) -> Result<Vec<OrgMembership>, OrgsListMembershipsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/memberships/orgs", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListMembershipsForAuthenticatedUserError::Status304),
                403 => Err(OrgsListMembershipsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(OrgsListMembershipsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OrgsListMembershipsForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListMembershipsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization memberships for the authenticated user
    /// 
    /// [GitHub API docs for list_memberships_for_authenticated_user](https://docs.github.com/rest/reference/orgs#list-organization-memberships-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_memberships_for_authenticated_user(&self, query_params: Option<impl Into<OrgsListMembershipsForAuthenticatedUserParams<'api>>>) -> Result<Vec<OrgMembership>, OrgsListMembershipsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/memberships/orgs", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListMembershipsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(OrgsListMembershipsForAuthenticatedUserError::Status304),
                403 => Err(OrgsListMembershipsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(OrgsListMembershipsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(OrgsListMembershipsForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListMembershipsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List outside collaborators for an organization
    ///
    /// List all users who are outside collaborators of an organization.
    /// 
    /// [GitHub API docs for list_outside_collaborators](https://docs.github.com/rest/reference/orgs#list-outside-collaborators-for-an-organization)
    ///
    /// ---
    pub async fn list_outside_collaborators_async(&self, org: &str, query_params: Option<impl Into<OrgsListOutsideCollaboratorsParams<'api>>>) -> Result<Vec<SimpleUser>, OrgsListOutsideCollaboratorsError> {

        let mut request_uri = format!("{}/orgs/{}/outside_collaborators", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListOutsideCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List outside collaborators for an organization
    ///
    /// List all users who are outside collaborators of an organization.
    /// 
    /// [GitHub API docs for list_outside_collaborators](https://docs.github.com/rest/reference/orgs#list-outside-collaborators-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_outside_collaborators(&self, org: &str, query_params: Option<impl Into<OrgsListOutsideCollaboratorsParams<'api>>>) -> Result<Vec<SimpleUser>, OrgsListOutsideCollaboratorsError> {

        let mut request_uri = format!("{}/orgs/{}/outside_collaborators", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListOutsideCollaboratorsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListOutsideCollaboratorsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// [GitHub API docs for list_pending_invitations](https://docs.github.com/rest/reference/orgs#list-pending-organization-invitations)
    ///
    /// ---
    pub async fn list_pending_invitations_async(&self, org: &str, query_params: Option<impl Into<OrgsListPendingInvitationsParams>>) -> Result<Vec<OrganizationInvitation>, OrgsListPendingInvitationsError> {

        let mut request_uri = format!("{}/orgs/{}/invitations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListPendingInvitationsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListPendingInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List pending organization invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    /// 
    /// [GitHub API docs for list_pending_invitations](https://docs.github.com/rest/reference/orgs#list-pending-organization-invitations)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_pending_invitations(&self, org: &str, query_params: Option<impl Into<OrgsListPendingInvitationsParams>>) -> Result<Vec<OrganizationInvitation>, OrgsListPendingInvitationsError> {

        let mut request_uri = format!("{}/orgs/{}/invitations", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListPendingInvitationsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListPendingInvitationsError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListPendingInvitationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public organization members
    ///
    /// Members of an organization can choose to have their membership publicized or not.
    /// 
    /// [GitHub API docs for list_public_members](https://docs.github.com/rest/reference/orgs#list-public-organization-members)
    ///
    /// ---
    pub async fn list_public_members_async(&self, org: &str, query_params: Option<impl Into<OrgsListPublicMembersParams>>) -> Result<Vec<SimpleUser>, OrgsListPublicMembersError> {

        let mut request_uri = format!("{}/orgs/{}/public_members", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListPublicMembersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public organization members
    ///
    /// Members of an organization can choose to have their membership publicized or not.
    /// 
    /// [GitHub API docs for list_public_members](https://docs.github.com/rest/reference/orgs#list-public-organization-members)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_members(&self, org: &str, query_params: Option<impl Into<OrgsListPublicMembersParams>>) -> Result<Vec<SimpleUser>, OrgsListPublicMembersError> {

        let mut request_uri = format!("{}/orgs/{}/public_members", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListPublicMembersParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListPublicMembersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SAML SSO authorizations for an organization
    ///
    /// Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
    /// 
    /// An authenticated organization owner with the `read:org` scope can list all credential authorizations for an organization that uses SAML single sign-on (SSO). The credentials are either personal access tokens or SSH keys that organization members have authorized for the organization. For more information, see [About authentication with SAML single sign-on](https://help.github.com/en/articles/about-authentication-with-saml-single-sign-on).
    /// 
    /// [GitHub API docs for list_saml_sso_authorizations](https://docs.github.com/rest/reference/orgs#list-saml-sso-authorizations-for-an-organization)
    ///
    /// ---
    pub async fn list_saml_sso_authorizations_async(&self, org: &str) -> Result<Vec<CredentialAuthorization>, OrgsListSamlSsoAuthorizationsError> {

        let request_uri = format!("{}/orgs/{}/credential-authorizations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListSamlSsoAuthorizationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SAML SSO authorizations for an organization
    ///
    /// Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
    /// 
    /// An authenticated organization owner with the `read:org` scope can list all credential authorizations for an organization that uses SAML single sign-on (SSO). The credentials are either personal access tokens or SSH keys that organization members have authorized for the organization. For more information, see [About authentication with SAML single sign-on](https://help.github.com/en/articles/about-authentication-with-saml-single-sign-on).
    /// 
    /// [GitHub API docs for list_saml_sso_authorizations](https://docs.github.com/rest/reference/orgs#list-saml-sso-authorizations-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_saml_sso_authorizations(&self, org: &str) -> Result<Vec<CredentialAuthorization>, OrgsListSamlSsoAuthorizationsError> {

        let request_uri = format!("{}/orgs/{}/credential-authorizations", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsListSamlSsoAuthorizationsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/orgs#list-deliveries-for-an-organization-webhook)
    ///
    /// ---
    pub async fn list_webhook_deliveries_async(&self, org: &str, hook_id: i32, query_params: Option<impl Into<OrgsListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, OrgsListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/orgs/{}/hooks/{}/deliveries", super::GITHUB_BASE_API_URL, org, hook_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsListWebhookDeliveriesError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OrgsListWebhookDeliveriesError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List deliveries for an organization webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for list_webhook_deliveries](https://docs.github.com/rest/reference/orgs#list-deliveries-for-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_webhook_deliveries(&self, org: &str, hook_id: i32, query_params: Option<impl Into<OrgsListWebhookDeliveriesParams<'api>>>) -> Result<Vec<HookDeliveryItem>, OrgsListWebhookDeliveriesError> {

        let mut request_uri = format!("{}/orgs/{}/hooks/{}/deliveries", super::GITHUB_BASE_API_URL, org, hook_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListWebhookDeliveriesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsListWebhookDeliveriesError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(OrgsListWebhookDeliveriesError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListWebhookDeliveriesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization webhooks
    /// 
    /// [GitHub API docs for list_webhooks](https://docs.github.com/rest/reference/orgs#list-organization-webhooks)
    ///
    /// ---
    pub async fn list_webhooks_async(&self, org: &str, query_params: Option<impl Into<OrgsListWebhooksParams>>) -> Result<Vec<OrgHook>, OrgsListWebhooksError> {

        let mut request_uri = format!("{}/orgs/{}/hooks", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListWebhooksError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsListWebhooksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization webhooks
    /// 
    /// [GitHub API docs for list_webhooks](https://docs.github.com/rest/reference/orgs#list-organization-webhooks)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_webhooks(&self, org: &str, query_params: Option<impl Into<OrgsListWebhooksParams>>) -> Result<Vec<OrgHook>, OrgsListWebhooksError> {

        let mut request_uri = format!("{}/orgs/{}/hooks", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: OrgsListWebhooksParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsListWebhooksError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsListWebhooksError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    /// 
    /// [GitHub API docs for ping_webhook](https://docs.github.com/rest/reference/orgs#ping-an-organization-webhook)
    ///
    /// ---
    pub async fn ping_webhook_async(&self, org: &str, hook_id: i32) -> Result<(), OrgsPingWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/pings", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsPingWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsPingWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Ping an organization webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    /// 
    /// [GitHub API docs for ping_webhook](https://docs.github.com/rest/reference/orgs#ping-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn ping_webhook(&self, org: &str, hook_id: i32) -> Result<(), OrgsPingWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/pings", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsPingWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsPingWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/orgs#redeliver-a-delivery-for-an-organization-webhook)
    ///
    /// ---
    pub async fn redeliver_webhook_delivery_async(&self, org: &str, hook_id: i32, delivery_id: i32) -> Result<HashMap<String, Value>, OrgsRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, org, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OrgsRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Redeliver a delivery for an organization webhook
    ///
    /// Redeliver a delivery for a webhook configured in an organization.
    /// 
    /// [GitHub API docs for redeliver_webhook_delivery](https://docs.github.com/rest/reference/orgs#redeliver-a-delivery-for-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn redeliver_webhook_delivery(&self, org: &str, hook_id: i32, delivery_id: i32) -> Result<HashMap<String, Value>, OrgsRedeliverWebhookDeliveryError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/deliveries/{}/attempts", super::GITHUB_BASE_API_URL, org, hook_id, delivery_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                400 => Err(OrgsRedeliverWebhookDeliveryError::Status400(crate::adapters::to_json(github_response)?)),
                422 => Err(OrgsRedeliverWebhookDeliveryError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsRedeliverWebhookDeliveryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove an organization member
    ///
    /// Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
    /// 
    /// [GitHub API docs for remove_member](https://docs.github.com/rest/reference/orgs#remove-an-organization-member)
    ///
    /// ---
    pub async fn remove_member_async(&self, org: &str, username: &str) -> Result<(), OrgsRemoveMemberError> {

        let request_uri = format!("{}/orgs/{}/members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsRemoveMemberError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsRemoveMemberError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove an organization member
    ///
    /// Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
    /// 
    /// [GitHub API docs for remove_member](https://docs.github.com/rest/reference/orgs#remove-an-organization-member)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_member(&self, org: &str, username: &str) -> Result<(), OrgsRemoveMemberError> {

        let request_uri = format!("{}/orgs/{}/members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsRemoveMemberError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsRemoveMemberError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove organization membership for a user
    ///
    /// In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
    /// 
    /// If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
    /// 
    /// [GitHub API docs for remove_membership_for_user](https://docs.github.com/rest/reference/orgs#remove-organization-membership-for-a-user)
    ///
    /// ---
    pub async fn remove_membership_for_user_async(&self, org: &str, username: &str) -> Result<(), OrgsRemoveMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsRemoveMembershipForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsRemoveMembershipForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsRemoveMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove organization membership for a user
    ///
    /// In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
    /// 
    /// If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
    /// 
    /// [GitHub API docs for remove_membership_for_user](https://docs.github.com/rest/reference/orgs#remove-organization-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_membership_for_user(&self, org: &str, username: &str) -> Result<(), OrgsRemoveMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsRemoveMembershipForUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsRemoveMembershipForUserError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsRemoveMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove outside collaborator from an organization
    ///
    /// Removing a user from this list will remove them from all the organization's repositories.
    /// 
    /// [GitHub API docs for remove_outside_collaborator](https://docs.github.com/rest/reference/orgs#remove-outside-collaborator-from-an-organization)
    ///
    /// ---
    pub async fn remove_outside_collaborator_async(&self, org: &str, username: &str) -> Result<(), OrgsRemoveOutsideCollaboratorError> {

        let request_uri = format!("{}/orgs/{}/outside_collaborators/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsRemoveOutsideCollaboratorError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsRemoveOutsideCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove outside collaborator from an organization
    ///
    /// Removing a user from this list will remove them from all the organization's repositories.
    /// 
    /// [GitHub API docs for remove_outside_collaborator](https://docs.github.com/rest/reference/orgs#remove-outside-collaborator-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_outside_collaborator(&self, org: &str, username: &str) -> Result<(), OrgsRemoveOutsideCollaboratorError> {

        let request_uri = format!("{}/orgs/{}/outside_collaborators/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsRemoveOutsideCollaboratorError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsRemoveOutsideCollaboratorError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove public organization membership for the authenticated user
    /// 
    /// [GitHub API docs for remove_public_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#remove-public-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    pub async fn remove_public_membership_for_authenticated_user_async(&self, org: &str, username: &str) -> Result<(), OrgsRemovePublicMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsRemovePublicMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove public organization membership for the authenticated user
    /// 
    /// [GitHub API docs for remove_public_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#remove-public-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_public_membership_for_authenticated_user(&self, org: &str, username: &str) -> Result<(), OrgsRemovePublicMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsRemovePublicMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a SAML SSO authorization for an organization
    ///
    /// Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
    /// 
    /// An authenticated organization owner with the `admin:org` scope can remove a credential authorization for an organization that uses SAML SSO. Once you remove someone's credential authorization, they will need to create a new personal access token or SSH key and authorize it for the organization they want to access.
    /// 
    /// [GitHub API docs for remove_saml_sso_authorization](https://docs.github.com/rest/reference/orgs#remove-a-saml-sso-authorization-for-an-organization)
    ///
    /// ---
    pub async fn remove_saml_sso_authorization_async(&self, org: &str, credential_id: i32) -> Result<(), OrgsRemoveSamlSsoAuthorizationError> {

        let request_uri = format!("{}/orgs/{}/credential-authorizations/{}", super::GITHUB_BASE_API_URL, org, credential_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsRemoveSamlSsoAuthorizationError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsRemoveSamlSsoAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a SAML SSO authorization for an organization
    ///
    /// Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
    /// 
    /// An authenticated organization owner with the `admin:org` scope can remove a credential authorization for an organization that uses SAML SSO. Once you remove someone's credential authorization, they will need to create a new personal access token or SSH key and authorize it for the organization they want to access.
    /// 
    /// [GitHub API docs for remove_saml_sso_authorization](https://docs.github.com/rest/reference/orgs#remove-a-saml-sso-authorization-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_saml_sso_authorization(&self, org: &str, credential_id: i32) -> Result<(), OrgsRemoveSamlSsoAuthorizationError> {

        let request_uri = format!("{}/orgs/{}/credential-authorizations/{}", super::GITHUB_BASE_API_URL, org, credential_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(OrgsRemoveSamlSsoAuthorizationError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsRemoveSamlSsoAuthorizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set organization membership for a user
    ///
    /// Only authenticated organization owners can add a member to the organization or update the member's role.
    /// 
    /// *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
    ///     
    /// *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
    /// 
    /// **Rate limits**
    /// 
    /// To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
    /// 
    /// [GitHub API docs for set_membership_for_user](https://docs.github.com/rest/reference/orgs#set-organization-membership-for-a-user)
    ///
    /// ---
    pub async fn set_membership_for_user_async(&self, org: &str, username: &str, body: PutOrgsSetMembershipForUser) -> Result<OrgMembership, OrgsSetMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOrgsSetMembershipForUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsSetMembershipForUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(OrgsSetMembershipForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsSetMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set organization membership for a user
    ///
    /// Only authenticated organization owners can add a member to the organization or update the member's role.
    /// 
    /// *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
    ///     
    /// *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
    /// 
    /// **Rate limits**
    /// 
    /// To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
    /// 
    /// [GitHub API docs for set_membership_for_user](https://docs.github.com/rest/reference/orgs#set-organization-membership-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_membership_for_user(&self, org: &str, username: &str, body: PutOrgsSetMembershipForUser) -> Result<OrgMembership, OrgsSetMembershipForUserError> {

        let request_uri = format!("{}/orgs/{}/memberships/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutOrgsSetMembershipForUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsSetMembershipForUserError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(OrgsSetMembershipForUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsSetMembershipForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set public organization membership for the authenticated user
    ///
    /// The user can publicize their own membership. (A user cannot publicize the membership for another user.)
    /// 
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for set_public_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#set-public-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    pub async fn set_public_membership_for_authenticated_user_async(&self, org: &str, username: &str) -> Result<(), OrgsSetPublicMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsSetPublicMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsSetPublicMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set public organization membership for the authenticated user
    ///
    /// The user can publicize their own membership. (A user cannot publicize the membership for another user.)
    /// 
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for set_public_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#set-public-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_public_membership_for_authenticated_user(&self, org: &str, username: &str) -> Result<(), OrgsSetPublicMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/orgs/{}/public_members/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsSetPublicMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsSetPublicMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unblock a user from an organization
    /// 
    /// [GitHub API docs for unblock_user](https://docs.github.com/rest/reference/orgs#unblock-a-user-from-an-organization)
    ///
    /// ---
    pub async fn unblock_user_async(&self, org: &str, username: &str) -> Result<(), OrgsUnblockUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsUnblockUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unblock a user from an organization
    /// 
    /// [GitHub API docs for unblock_user](https://docs.github.com/rest/reference/orgs#unblock-a-user-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unblock_user(&self, org: &str, username: &str) -> Result<(), OrgsUnblockUserError> {

        let request_uri = format!("{}/orgs/{}/blocks/{}", super::GITHUB_BASE_API_URL, org, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsUnblockUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization
    ///
    /// **Parameter Deprecation Notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    /// 
    /// Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/orgs/#update-an-organization)
    ///
    /// ---
    pub async fn update_async(&self, org: &str, body: PatchOrgsUpdate) -> Result<OrganizationFull, OrgsUpdateError> {

        let request_uri = format!("{}/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsUpdateError::Status422(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(OrgsUpdateError::Status409(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization
    ///
    /// **Parameter Deprecation Notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
    /// 
    /// Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
    /// 
    /// [GitHub API docs for update](https://docs.github.com/rest/reference/orgs/#update-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update(&self, org: &str, body: PatchOrgsUpdate) -> Result<OrganizationFull, OrgsUpdateError> {

        let request_uri = format!("{}/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdate::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsUpdateError::Status422(crate::adapters::to_json(github_response)?)),
                409 => Err(OrgsUpdateError::Status409(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsUpdateError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization membership for the authenticated user
    /// 
    /// [GitHub API docs for update_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#update-an-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    pub async fn update_membership_for_authenticated_user_async(&self, org: &str, body: PatchOrgsUpdateMembershipForAuthenticatedUser) -> Result<OrgMembership, OrgsUpdateMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/user/memberships/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateMembershipForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsUpdateMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization membership for the authenticated user
    /// 
    /// [GitHub API docs for update_membership_for_authenticated_user](https://docs.github.com/rest/reference/orgs#update-an-organization-membership-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_membership_for_authenticated_user(&self, org: &str, body: PatchOrgsUpdateMembershipForAuthenticatedUser) -> Result<OrgMembership, OrgsUpdateMembershipForAuthenticatedUserError> {

        let request_uri = format!("{}/user/memberships/orgs/{}", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateMembershipForAuthenticatedUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                422 => Err(OrgsUpdateMembershipForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsUpdateMembershipForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)."
    /// 
    /// [GitHub API docs for update_webhook](https://docs.github.com/rest/reference/orgs#update-an-organization-webhook)
    ///
    /// ---
    pub async fn update_webhook_async(&self, org: &str, hook_id: i32, body: PatchOrgsUpdateWebhook) -> Result<OrgHook, OrgsUpdateWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateWebhook::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsUpdateWebhookError::Status422(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(OrgsUpdateWebhookError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(OrgsUpdateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an organization webhook
    ///
    /// Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)."
    /// 
    /// [GitHub API docs for update_webhook](https://docs.github.com/rest/reference/orgs#update-an-organization-webhook)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_webhook(&self, org: &str, hook_id: i32, body: PatchOrgsUpdateWebhook) -> Result<OrgHook, OrgsUpdateWebhookError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateWebhook::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(OrgsUpdateWebhookError::Status422(crate::adapters::to_json(github_response)?)),
                404 => Err(OrgsUpdateWebhookError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(OrgsUpdateWebhookError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
    /// 
    /// Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
    /// 
    /// [GitHub API docs for update_webhook_config_for_org](https://docs.github.com/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)
    ///
    /// ---
    pub async fn update_webhook_config_for_org_async(&self, org: &str, hook_id: i32, body: PatchOrgsUpdateWebhookConfigForOrg) -> Result<WebhookConfig, OrgsUpdateWebhookConfigForOrgError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateWebhookConfigForOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsUpdateWebhookConfigForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a webhook configuration for an organization
    ///
    /// Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
    /// 
    /// Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
    /// 
    /// [GitHub API docs for update_webhook_config_for_org](https://docs.github.com/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_webhook_config_for_org(&self, org: &str, hook_id: i32, body: PatchOrgsUpdateWebhookConfigForOrg) -> Result<WebhookConfig, OrgsUpdateWebhookConfigForOrgError> {

        let request_uri = format!("{}/orgs/{}/hooks/{}/config", super::GITHUB_BASE_API_URL, org, hook_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchOrgsUpdateWebhookConfigForOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(OrgsUpdateWebhookConfigForOrgError::Generic { code }),
            }
        }
    }

}
