//! Method, error and parameter types for the Actions endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Actions<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Actions {
    Actions { auth }
}

/// Errors for the [Add repository access to a self-hosted runner group in an organization](Actions::add_repo_access_to_self_hosted_runner_group_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add selected repository to an organization secret](Actions::add_selected_repo_to_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsAddSelectedRepoToOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Conflict when visibility type is not set to selected")]
    Status409,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add a self-hosted runner to a group for an organization](Actions::add_self_hosted_runner_to_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsAddSelfHostedRunnerToGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Approve a workflow run for a fork pull request](Actions::approve_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsApproveWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Cancel a workflow run](Actions::cancel_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCancelWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update an environment secret](Actions::create_or_update_environment_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateOrUpdateEnvironmentSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when updating a secret")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update an organization secret](Actions::create_or_update_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateOrUpdateOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when updating a secret")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create or update a repository secret](Actions::create_or_update_repo_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateOrUpdateRepoSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response when updating a secret")]
    Status204,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a registration token for an organization](Actions::create_registration_token_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateRegistrationTokenForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a registration token for a repository](Actions::create_registration_token_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateRegistrationTokenForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a remove token for an organization](Actions::create_remove_token_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateRemoveTokenForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a remove token for a repository](Actions::create_remove_token_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateRemoveTokenForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a self-hosted runner group for an organization](Actions::create_self_hosted_runner_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateSelfHostedRunnerGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a workflow dispatch event](Actions::create_workflow_dispatch_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsCreateWorkflowDispatchError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an artifact](Actions::delete_artifact_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteArtifactError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an environment secret](Actions::delete_environment_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteEnvironmentSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete an organization secret](Actions::delete_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a repository secret](Actions::delete_repo_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteRepoSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a self-hosted runner from an organization](Actions::delete_self_hosted_runner_from_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteSelfHostedRunnerFromOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a self-hosted runner from a repository](Actions::delete_self_hosted_runner_from_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteSelfHostedRunnerFromRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a self-hosted runner group from an organization](Actions::delete_self_hosted_runner_group_from_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteSelfHostedRunnerGroupFromOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a workflow run](Actions::delete_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete workflow run logs](Actions::delete_workflow_run_logs_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDeleteWorkflowRunLogsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable a selected repository for GitHub Actions in an organization](Actions::disable_selected_repository_github_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDisableSelectedRepositoryGithubActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable a workflow](Actions::disable_workflow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDisableWorkflowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download an artifact](Actions::download_artifact_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDownloadArtifactError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download job logs for a workflow run](Actions::download_job_logs_for_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDownloadJobLogsForWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download workflow run attempt logs](Actions::download_workflow_run_attempt_logs_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDownloadWorkflowRunAttemptLogsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Download workflow run logs](Actions::download_workflow_run_logs_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsDownloadWorkflowRunLogsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Response")]
    Status302,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable a selected repository for GitHub Actions in an organization](Actions::enable_selected_repository_github_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsEnableSelectedRepositoryGithubActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable a workflow](Actions::enable_workflow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsEnableWorkflowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get allowed actions for an organization](Actions::get_allowed_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetAllowedActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get allowed actions for a repository](Actions::get_allowed_actions_repository_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetAllowedActionsRepositoryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an artifact](Actions::get_artifact_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetArtifactError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an environment public key](Actions::get_environment_public_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetEnvironmentPublicKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an environment secret](Actions::get_environment_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetEnvironmentSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get GitHub Actions permissions for an organization](Actions::get_github_actions_permissions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetGithubActionsPermissionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get GitHub Actions permissions for a repository](Actions::get_github_actions_permissions_repository_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetGithubActionsPermissionsRepositoryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a job for a workflow run](Actions::get_job_for_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetJobForWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization public key](Actions::get_org_public_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetOrgPublicKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get an organization secret](Actions::get_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get pending deployments for a workflow run](Actions::get_pending_deployments_for_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetPendingDeploymentsForRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository public key](Actions::get_repo_public_key_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetRepoPublicKeyError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository secret](Actions::get_repo_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetRepoSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the review history for a workflow run](Actions::get_reviews_for_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetReviewsForRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a self-hosted runner for an organization](Actions::get_self_hosted_runner_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetSelfHostedRunnerForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a self-hosted runner for a repository](Actions::get_self_hosted_runner_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetSelfHostedRunnerForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a self-hosted runner group for an organization](Actions::get_self_hosted_runner_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetSelfHostedRunnerGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a workflow](Actions::get_workflow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetWorkflowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a workflow run](Actions::get_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a workflow run attempt](Actions::get_workflow_run_attempt_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetWorkflowRunAttemptError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get workflow run usage](Actions::get_workflow_run_usage_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetWorkflowRunUsageError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get workflow usage](Actions::get_workflow_usage_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsGetWorkflowUsageError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List artifacts for a repository](Actions::list_artifacts_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListArtifactsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List environment secrets](Actions::list_environment_secrets_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListEnvironmentSecretsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List jobs for a workflow run](Actions::list_jobs_for_workflow_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListJobsForWorkflowRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List jobs for a workflow run attempt](Actions::list_jobs_for_workflow_run_attempt_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListJobsForWorkflowRunAttemptError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization secrets](Actions::list_org_secrets_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListOrgSecretsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository access to a self-hosted runner group in an organization](Actions::list_repo_access_to_self_hosted_runner_group_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListRepoAccessToSelfHostedRunnerGroupInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository secrets](Actions::list_repo_secrets_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListRepoSecretsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository workflows](Actions::list_repo_workflows_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListRepoWorkflowsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List runner applications for an organization](Actions::list_runner_applications_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListRunnerApplicationsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List runner applications for a repository](Actions::list_runner_applications_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListRunnerApplicationsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List selected repositories for an organization secret](Actions::list_selected_repos_for_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelectedReposForOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List selected repositories enabled for GitHub Actions in an organization](Actions::list_selected_repositories_enabled_github_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runner groups for an organization](Actions::list_self_hosted_runner_groups_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelfHostedRunnerGroupsForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runners for an organization](Actions::list_self_hosted_runners_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelfHostedRunnersForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runners for a repository](Actions::list_self_hosted_runners_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelfHostedRunnersForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runners in a group for an organization](Actions::list_self_hosted_runners_in_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListSelfHostedRunnersInGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List workflow run artifacts](Actions::list_workflow_run_artifacts_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListWorkflowRunArtifactsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List workflow runs](Actions::list_workflow_runs_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListWorkflowRunsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List workflow runs for a repository](Actions::list_workflow_runs_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsListWorkflowRunsForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Re-run a workflow](Actions::re_run_workflow_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsReRunWorkflowError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove repository access to a self-hosted runner group in an organization](Actions::remove_repo_access_to_self_hosted_runner_group_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove selected repository from an organization secret](Actions::remove_selected_repo_from_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsRemoveSelectedRepoFromOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Conflict when visibility type not set to selected")]
    Status409,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a self-hosted runner from a group for an organization](Actions::remove_self_hosted_runner_from_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsRemoveSelfHostedRunnerFromGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Review pending deployments for a workflow run](Actions::review_pending_deployments_for_run_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsReviewPendingDeploymentsForRunError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set allowed actions for an organization](Actions::set_allowed_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetAllowedActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set allowed actions for a repository](Actions::set_allowed_actions_repository_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetAllowedActionsRepositoryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set GitHub Actions permissions for an organization](Actions::set_github_actions_permissions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetGithubActionsPermissionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set GitHub Actions permissions for a repository](Actions::set_github_actions_permissions_repository_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetGithubActionsPermissionsRepositoryError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set repository access for a self-hosted runner group in an organization](Actions::set_repo_access_to_self_hosted_runner_group_in_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set selected repositories for an organization secret](Actions::set_selected_repos_for_org_secret_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetSelectedReposForOrgSecretError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set selected repositories enabled for GitHub Actions in an organization](Actions::set_selected_repositories_enabled_github_actions_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetSelectedRepositoriesEnabledGithubActionsOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set self-hosted runners in a group for an organization](Actions::set_self_hosted_runners_in_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsSetSelfHostedRunnersInGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a self-hosted runner group for an organization](Actions::update_self_hosted_runner_group_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActionsUpdateSelfHostedRunnerGroupForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get a workflow run](Actions::get_workflow_run_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsGetWorkflowRunParams {
    /// If `true` pull requests are omitted from the response (empty array).
    exclude_pull_requests: Option<bool>
}

impl ActionsGetWorkflowRunParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// If `true` pull requests are omitted from the response (empty array).
    pub fn exclude_pull_requests(self, exclude_pull_requests: bool) -> Self {
        Self { 
            exclude_pull_requests: Some(exclude_pull_requests),
        }
    }
}

/// Query parameters for the [Get a workflow run attempt](Actions::get_workflow_run_attempt_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsGetWorkflowRunAttemptParams {
    /// If `true` pull requests are omitted from the response (empty array).
    exclude_pull_requests: Option<bool>
}

impl ActionsGetWorkflowRunAttemptParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// If `true` pull requests are omitted from the response (empty array).
    pub fn exclude_pull_requests(self, exclude_pull_requests: bool) -> Self {
        Self { 
            exclude_pull_requests: Some(exclude_pull_requests),
        }
    }
}

/// Query parameters for the [List artifacts for a repository](Actions::list_artifacts_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListArtifactsForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListArtifactsForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListArtifactsForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List environment secrets](Actions::list_environment_secrets_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListEnvironmentSecretsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListEnvironmentSecretsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListEnvironmentSecretsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List jobs for a workflow run](Actions::list_jobs_for_workflow_run_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListJobsForWorkflowRunParams<'req> {
    /// Filters jobs by their `completed_at` timestamp. Can be one of:   \\* `latest`: Returns jobs from the most recent execution of the workflow run.   \\* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
    filter: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ActionsListJobsForWorkflowRunParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Filters jobs by their `completed_at` timestamp. Can be one of:   \\* `latest`: Returns jobs from the most recent execution of the workflow run.   \\* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            filter: Some(filter),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            filter: self.filter, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            filter: self.filter, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListJobsForWorkflowRunParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List jobs for a workflow run attempt](Actions::list_jobs_for_workflow_run_attempt_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListJobsForWorkflowRunAttemptParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListJobsForWorkflowRunAttemptParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListJobsForWorkflowRunAttemptParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization secrets](Actions::list_org_secrets_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListOrgSecretsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListOrgSecretsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListOrgSecretsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository access to a self-hosted runner group in an organization](Actions::list_repo_access_to_self_hosted_runner_group_in_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository secrets](Actions::list_repo_secrets_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListRepoSecretsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListRepoSecretsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListRepoSecretsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository workflows](Actions::list_repo_workflows_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListRepoWorkflowsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListRepoWorkflowsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListRepoWorkflowsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List selected repositories for an organization secret](Actions::list_selected_repos_for_org_secret_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelectedReposForOrgSecretParams {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl ActionsListSelectedReposForOrgSecretParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelectedReposForOrgSecretParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List selected repositories enabled for GitHub Actions in an organization](Actions::list_selected_repositories_enabled_github_actions_organization_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runner groups for an organization](Actions::list_self_hosted_runner_groups_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelfHostedRunnerGroupsForOrgParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListSelfHostedRunnerGroupsForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelfHostedRunnerGroupsForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runners for an organization](Actions::list_self_hosted_runners_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelfHostedRunnersForOrgParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListSelfHostedRunnersForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelfHostedRunnersForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runners for a repository](Actions::list_self_hosted_runners_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelfHostedRunnersForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListSelfHostedRunnersForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelfHostedRunnersForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runners in a group for an organization](Actions::list_self_hosted_runners_in_group_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListSelfHostedRunnersInGroupForOrgParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListSelfHostedRunnersInGroupForOrgParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListSelfHostedRunnersInGroupForOrgParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List workflow run artifacts](Actions::list_workflow_run_artifacts_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListWorkflowRunArtifactsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActionsListWorkflowRunArtifactsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListWorkflowRunArtifactsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List workflow runs](Actions::list_workflow_runs_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListWorkflowRunsParams<'req> {
    /// Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
    actor: Option<&'req str>, 
    /// Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
    branch: Option<&'req str>, 
    /// Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see \"[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows).\"
    event: Option<&'req str>, 
    /// Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. For a list of the possible `status` and `conclusion` options, see \"[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run).\"
    status: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    
    created: Option<chrono::DateTime<chrono::Utc>>, 
    /// If `true` pull requests are omitted from the response (empty array).
    exclude_pull_requests: Option<bool>
}

impl<'req> ActionsListWorkflowRunsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
    pub fn actor(self, actor: &'req str) -> Self {
        Self { 
            actor: Some(actor),
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
    pub fn branch(self, branch: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: Some(branch),
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see \"[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows).\"
    pub fn event(self, event: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: Some(event),
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. For a list of the possible `status` and `conclusion` options, see \"[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run).\"
    pub fn status(self, status: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: Some(status),
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: Some(per_page),
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: Some(page),
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    
    pub fn created(self, created: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: Some(created),
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// If `true` pull requests are omitted from the response (empty array).
    pub fn exclude_pull_requests(self, exclude_pull_requests: bool) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: Some(exclude_pull_requests),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListWorkflowRunsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List workflow runs for a repository](Actions::list_workflow_runs_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActionsListWorkflowRunsForRepoParams<'req> {
    /// Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
    actor: Option<&'req str>, 
    /// Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
    branch: Option<&'req str>, 
    /// Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see \"[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows).\"
    event: Option<&'req str>, 
    /// Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. For a list of the possible `status` and `conclusion` options, see \"[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run).\"
    status: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    
    created: Option<chrono::DateTime<chrono::Utc>>, 
    /// If `true` pull requests are omitted from the response (empty array).
    exclude_pull_requests: Option<bool>
}

impl<'req> ActionsListWorkflowRunsForRepoParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
    pub fn actor(self, actor: &'req str) -> Self {
        Self { 
            actor: Some(actor),
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
    pub fn branch(self, branch: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: Some(branch),
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see \"[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows).\"
    pub fn event(self, event: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: Some(event),
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. For a list of the possible `status` and `conclusion` options, see \"[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run).\"
    pub fn status(self, status: &'req str) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: Some(status),
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: Some(per_page),
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: Some(page),
            created: self.created, 
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    
    pub fn created(self, created: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: Some(created),
            exclude_pull_requests: self.exclude_pull_requests, 
        }
    }

    /// If `true` pull requests are omitted from the response (empty array).
    pub fn exclude_pull_requests(self, exclude_pull_requests: bool) -> Self {
        Self { 
            actor: self.actor, 
            branch: self.branch, 
            event: self.event, 
            status: self.status, 
            per_page: self.per_page, 
            page: self.page, 
            created: self.created, 
            exclude_pull_requests: Some(exclude_pull_requests),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActionsListWorkflowRunsForRepoParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Actions<'api> {
    /// ---
    ///
    /// # Add repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#add-repository-acess-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    pub async fn add_repo_access_to_self_hosted_runner_group_in_org_async(&self, org: &str, runner_group_id: i32, repository_id: i32) -> Result<(), ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#add-repository-acess-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_repo_access_to_self_hosted_runner_group_in_org(&self, org: &str, runner_group_id: i32, repository_id: i32) -> Result<(), ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsAddRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for add_selected_repo_to_org_secret](https://docs.github.com/rest/reference/actions#add-selected-repository-to-an-organization-secret)
    ///
    /// ---
    pub async fn add_selected_repo_to_org_secret_async(&self, org: &str, secret_name: &str, repository_id: i32) -> Result<(), ActionsAddSelectedRepoToOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(ActionsAddSelectedRepoToOrgSecretError::Status409),
                code => Err(ActionsAddSelectedRepoToOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for add_selected_repo_to_org_secret](https://docs.github.com/rest/reference/actions#add-selected-repository-to-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_selected_repo_to_org_secret(&self, org: &str, secret_name: &str, repository_id: i32) -> Result<(), ActionsAddSelectedRepoToOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(ActionsAddSelectedRepoToOrgSecretError::Status409),
                code => Err(ActionsAddSelectedRepoToOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a self-hosted runner to a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Adds a self-hosted runner to a runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_self_hosted_runner_to_group_for_org](https://docs.github.com/rest/reference/actions#add-a-self-hosted-runner-to-a-group-for-an-organization)
    ///
    /// ---
    pub async fn add_self_hosted_runner_to_group_for_org_async(&self, org: &str, runner_group_id: i32, runner_id: i32) -> Result<(), ActionsAddSelfHostedRunnerToGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsAddSelfHostedRunnerToGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a self-hosted runner to a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Adds a self-hosted runner to a runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_self_hosted_runner_to_group_for_org](https://docs.github.com/rest/reference/actions#add-a-self-hosted-runner-to-a-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_self_hosted_runner_to_group_for_org(&self, org: &str, runner_group_id: i32, runner_id: i32) -> Result<(), ActionsAddSelfHostedRunnerToGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsAddSelfHostedRunnerToGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Approve a workflow run for a fork pull request
    ///
    /// Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for approve_workflow_run](https://docs.github.com/rest/reference/actions#approve-a-workflow-run-for-a-fork-pull-request)
    ///
    /// ---
    pub async fn approve_workflow_run_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<EmptyObject, ActionsApproveWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/approve", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActionsApproveWorkflowRunError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ActionsApproveWorkflowRunError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActionsApproveWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Approve a workflow run for a fork pull request
    ///
    /// Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for approve_workflow_run](https://docs.github.com/rest/reference/actions#approve-a-workflow-run-for-a-fork-pull-request)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn approve_workflow_run(&self, owner: &str, repo: &str, run_id: i32) -> Result<EmptyObject, ActionsApproveWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/approve", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActionsApproveWorkflowRunError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ActionsApproveWorkflowRunError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ActionsApproveWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Cancel a workflow run
    ///
    /// Cancels a workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for cancel_workflow_run](https://docs.github.com/rest/reference/actions#cancel-a-workflow-run)
    ///
    /// ---
    pub async fn cancel_workflow_run_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<HashMap<String, Value>, ActionsCancelWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/cancel", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCancelWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Cancel a workflow run
    ///
    /// Cancels a workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for cancel_workflow_run](https://docs.github.com/rest/reference/actions#cancel-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn cancel_workflow_run(&self, owner: &str, repo: &str, run_id: i32) -> Result<HashMap<String, Value>, ActionsCancelWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/cancel", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCancelWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an environment secret
    ///
    /// Creates or updates an environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
    /// this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_environment_secret](https://docs.github.com/rest/reference/actions#create-or-update-an-environment-secret)
    ///
    /// ---
    pub async fn create_or_update_environment_secret_async(&self, repository_id: i32, environment_name: &str, secret_name: &str, body: PutActionsCreateOrUpdateEnvironmentSecret) -> Result<EmptyObject, ActionsCreateOrUpdateEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateEnvironmentSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateEnvironmentSecretError::Status204),
                code => Err(ActionsCreateOrUpdateEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an environment secret
    ///
    /// Creates or updates an environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
    /// this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_environment_secret](https://docs.github.com/rest/reference/actions#create-or-update-an-environment-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_environment_secret(&self, repository_id: i32, environment_name: &str, secret_name: &str, body: PutActionsCreateOrUpdateEnvironmentSecret) -> Result<EmptyObject, ActionsCreateOrUpdateEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateEnvironmentSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateEnvironmentSecretError::Status204),
                code => Err(ActionsCreateOrUpdateEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
    /// use this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_org_secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret)
    ///
    /// ---
    pub async fn create_or_update_org_secret_async(&self, org: &str, secret_name: &str, body: PutActionsCreateOrUpdateOrgSecret) -> Result<EmptyObject, ActionsCreateOrUpdateOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateOrgSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateOrgSecretError::Status204),
                code => Err(ActionsCreateOrUpdateOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
    /// use this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_org_secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_org_secret(&self, org: &str, secret_name: &str, body: PutActionsCreateOrUpdateOrgSecret) -> Result<EmptyObject, ActionsCreateOrUpdateOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateOrgSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateOrgSecretError::Status204),
                code => Err(ActionsCreateOrUpdateOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
    /// this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_repo_secret](https://docs.github.com/rest/reference/actions#create-or-update-a-repository-secret)
    ///
    /// ---
    pub async fn create_or_update_repo_secret_async(&self, owner: &str, repo: &str, secret_name: &str, body: PutActionsCreateOrUpdateRepoSecret) -> Result<HashMap<String, Value>, ActionsCreateOrUpdateRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateRepoSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateRepoSecretError::Status204),
                code => Err(ActionsCreateOrUpdateRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
    /// token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
    /// this endpoint.
    /// 
    /// #### Example encrypting a secret using Node.js
    /// 
    /// Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
    /// 
    /// ```nocompile
    /// const sodium = require('tweetsodium');
    /// 
    /// const key = "base64-encoded-public-key";
    /// const value = "plain-text-secret";
    /// 
    /// // Convert the message and key to Uint8Array's (Buffer implements that interface)
    /// const messageBytes = Buffer.from(value);
    /// const keyBytes = Buffer.from(key, 'base64');
    /// 
    /// // Encrypt using LibSodium.
    /// const encryptedBytes = sodium.seal(messageBytes, keyBytes);
    /// 
    /// // Base64 the encrypted secret
    /// const encrypted = Buffer.from(encryptedBytes).toString('base64');
    /// 
    /// console.log(encrypted);
    /// ```
    /// 
    /// 
    /// #### Example encrypting a secret using Python
    /// 
    /// Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
    /// 
    /// ```nocompile
    /// from base64 import b64encode
    /// from nacl import encoding, public
    /// 
    /// def encrypt(public_key: str, secret_value: str) -> str:
    ///   """Encrypt a Unicode string using the public key."""
    ///   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
    ///   sealed_box = public.SealedBox(public_key)
    ///   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
    ///   return b64encode(encrypted).decode("utf-8")
    /// ```
    /// 
    /// #### Example encrypting a secret using C#
    /// 
    /// Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
    /// 
    /// ```nocompile
    /// var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
    /// var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
    /// 
    /// var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
    /// 
    /// Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
    /// ```
    /// 
    /// #### Example encrypting a secret using Ruby
    /// 
    /// Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
    /// 
    /// ```ruby,nocompile
    /// require "rbnacl"
    /// require "base64"
    /// 
    /// key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
    /// public_key = RbNaCl::PublicKey.new(key)
    /// 
    /// box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
    /// encrypted_secret = box.encrypt("my_secret")
    /// 
    /// # Print the base64 encoded secret
    /// puts Base64.strict_encode64(encrypted_secret)
    /// ```
    /// 
    /// [GitHub API docs for create_or_update_repo_secret](https://docs.github.com/rest/reference/actions#create-or-update-a-repository-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_or_update_repo_secret(&self, owner: &str, repo: &str, secret_name: &str, body: PutActionsCreateOrUpdateRepoSecret) -> Result<HashMap<String, Value>, ActionsCreateOrUpdateRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsCreateOrUpdateRepoSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                204 => Err(ActionsCreateOrUpdateRepoSecretError::Status204),
                code => Err(ActionsCreateOrUpdateRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for an organization
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    /// 
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_org](https://docs.github.com/rest/reference/actions#create-a-registration-token-for-an-organization)
    ///
    /// ---
    pub async fn create_registration_token_for_org_async(&self, org: &str) -> Result<AuthenticationToken, ActionsCreateRegistrationTokenForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRegistrationTokenForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for an organization
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    /// 
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/octo-org --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_org](https://docs.github.com/rest/reference/actions#create-a-registration-token-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_registration_token_for_org(&self, org: &str) -> Result<AuthenticationToken, ActionsCreateRegistrationTokenForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRegistrationTokenForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for a repository
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour. You must authenticate
    /// using an access token with the `repo` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    ///  
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/octo-org/octo-repo-artifacts --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_repo](https://docs.github.com/rest/reference/actions#create-a-registration-token-for-a-repository)
    ///
    /// ---
    pub async fn create_registration_token_for_repo_async(&self, owner: &str, repo: &str) -> Result<AuthenticationToken, ActionsCreateRegistrationTokenForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRegistrationTokenForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for a repository
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour. You must authenticate
    /// using an access token with the `repo` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    ///  
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/octo-org/octo-repo-artifacts --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_repo](https://docs.github.com/rest/reference/actions#create-a-registration-token-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_registration_token_for_repo(&self, owner: &str, repo: &str) -> Result<AuthenticationToken, ActionsCreateRegistrationTokenForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRegistrationTokenForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for an organization
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    /// 
    /// To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
    /// endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_org](https://docs.github.com/rest/reference/actions#create-a-remove-token-for-an-organization)
    ///
    /// ---
    pub async fn create_remove_token_for_org_async(&self, org: &str) -> Result<AuthenticationToken, ActionsCreateRemoveTokenForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRemoveTokenForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for an organization
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    /// 
    /// To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
    /// endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_org](https://docs.github.com/rest/reference/actions#create-a-remove-token-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_remove_token_for_org(&self, org: &str) -> Result<AuthenticationToken, ActionsCreateRemoveTokenForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRemoveTokenForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for a repository
    ///
    /// Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour.
    /// You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    ///  
    /// To remove your self-hosted runner from a repository, replace TOKEN with the remove token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_repo](https://docs.github.com/rest/reference/actions#create-a-remove-token-for-a-repository)
    ///
    /// ---
    pub async fn create_remove_token_for_repo_async(&self, owner: &str, repo: &str) -> Result<AuthenticationToken, ActionsCreateRemoveTokenForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRemoveTokenForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for a repository
    ///
    /// Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour.
    /// You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    ///  
    /// To remove your self-hosted runner from a repository, replace TOKEN with the remove token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_repo](https://docs.github.com/rest/reference/actions#create-a-remove-token-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_remove_token_for_repo(&self, owner: &str, repo: &str) -> Result<AuthenticationToken, ActionsCreateRemoveTokenForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateRemoveTokenForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Creates a new self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#create-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    pub async fn create_self_hosted_runner_group_for_org_async(&self, org: &str, body: PostActionsCreateSelfHostedRunnerGroupForOrg) -> Result<RunnerGroupsOrg, ActionsCreateSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsCreateSelfHostedRunnerGroupForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Creates a new self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#create-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_self_hosted_runner_group_for_org(&self, org: &str, body: PostActionsCreateSelfHostedRunnerGroupForOrg) -> Result<RunnerGroupsOrg, ActionsCreateSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsCreateSelfHostedRunnerGroupForOrg::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a workflow dispatch event
    ///
    /// You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)."
    /// 
    /// [GitHub API docs for create_workflow_dispatch](https://docs.github.com/rest/reference/actions#create-a-workflow-dispatch-event)
    ///
    /// ---
    pub async fn create_workflow_dispatch_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId, body: PostActionsCreateWorkflowDispatch) -> Result<(), ActionsCreateWorkflowDispatchError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/dispatches", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsCreateWorkflowDispatch::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateWorkflowDispatchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a workflow dispatch event
    ///
    /// You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)."
    /// 
    /// [GitHub API docs for create_workflow_dispatch](https://docs.github.com/rest/reference/actions#create-a-workflow-dispatch-event)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_workflow_dispatch(&self, owner: &str, repo: &str, workflow_id: WorkflowId, body: PostActionsCreateWorkflowDispatch) -> Result<(), ActionsCreateWorkflowDispatchError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/dispatches", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsCreateWorkflowDispatch::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsCreateWorkflowDispatchError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an artifact
    ///
    /// Deletes an artifact for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_artifact](https://docs.github.com/rest/reference/actions#delete-an-artifact)
    ///
    /// ---
    pub async fn delete_artifact_async(&self, owner: &str, repo: &str, artifact_id: i32) -> Result<(), ActionsDeleteArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an artifact
    ///
    /// Deletes an artifact for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_artifact](https://docs.github.com/rest/reference/actions#delete-an-artifact)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_artifact(&self, owner: &str, repo: &str, artifact_id: i32) -> Result<(), ActionsDeleteArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an environment secret
    ///
    /// Deletes a secret in an environment using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_environment_secret](https://docs.github.com/rest/reference/actions#delete-an-environment-secret)
    ///
    /// ---
    pub async fn delete_environment_secret_async(&self, repository_id: i32, environment_name: &str, secret_name: &str) -> Result<(), ActionsDeleteEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an environment secret
    ///
    /// Deletes a secret in an environment using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_environment_secret](https://docs.github.com/rest/reference/actions#delete-an-environment-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_environment_secret(&self, repository_id: i32, environment_name: &str, secret_name: &str) -> Result<(), ActionsDeleteEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_org_secret](https://docs.github.com/rest/reference/actions#delete-an-organization-secret)
    ///
    /// ---
    pub async fn delete_org_secret_async(&self, org: &str, secret_name: &str) -> Result<(), ActionsDeleteOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_org_secret](https://docs.github.com/rest/reference/actions#delete-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_org_secret(&self, org: &str, secret_name: &str) -> Result<(), ActionsDeleteOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_repo_secret](https://docs.github.com/rest/reference/actions#delete-a-repository-secret)
    ///
    /// ---
    pub async fn delete_repo_secret_async(&self, owner: &str, repo: &str, secret_name: &str) -> Result<(), ActionsDeleteRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_repo_secret](https://docs.github.com/rest/reference/actions#delete-a-repository-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_repo_secret(&self, owner: &str, repo: &str, secret_name: &str) -> Result<(), ActionsDeleteRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from an organization
    ///
    /// Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_org](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-from-an-organization)
    ///
    /// ---
    pub async fn delete_self_hosted_runner_from_org_async(&self, org: &str, runner_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerFromOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, org, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from an organization
    ///
    /// Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_org](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_self_hosted_runner_from_org(&self, org: &str, runner_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerFromOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, org, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from a repository
    ///
    /// Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `repo`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_repo](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-from-a-repository)
    ///
    /// ---
    pub async fn delete_self_hosted_runner_from_repo_async(&self, owner: &str, repo: &str, runner_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerFromRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, owner, repo, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerFromRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from a repository
    ///
    /// Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `repo`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_repo](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-from-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_self_hosted_runner_from_repo(&self, owner: &str, repo: &str, runner_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerFromRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, owner, repo, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerFromRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner group from an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Deletes a self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_group_from_org](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-group-from-an-organization)
    ///
    /// ---
    pub async fn delete_self_hosted_runner_group_from_org_async(&self, org: &str, runner_group_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerGroupFromOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerGroupFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner group from an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Deletes a self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_group_from_org](https://docs.github.com/rest/reference/actions#delete-a-self-hosted-runner-group-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_self_hosted_runner_group_from_org(&self, org: &str, runner_group_id: i32) -> Result<(), ActionsDeleteSelfHostedRunnerGroupFromOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteSelfHostedRunnerGroupFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a workflow run
    ///
    /// Delete a specific workflow run. Anyone with write access to the repository can use this endpoint. If the repository is
    /// private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:write` permission to use
    /// this endpoint.
    /// 
    /// [GitHub API docs for delete_workflow_run](https://docs.github.com/rest/reference/actions#delete-a-workflow-run)
    ///
    /// ---
    pub async fn delete_workflow_run_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDeleteWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a workflow run
    ///
    /// Delete a specific workflow run. Anyone with write access to the repository can use this endpoint. If the repository is
    /// private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:write` permission to use
    /// this endpoint.
    /// 
    /// [GitHub API docs for delete_workflow_run](https://docs.github.com/rest/reference/actions#delete-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_workflow_run(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDeleteWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete workflow run logs
    ///
    /// Deletes all logs for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_workflow_run_logs](https://docs.github.com/rest/reference/actions#delete-workflow-run-logs)
    ///
    /// ---
    pub async fn delete_workflow_run_logs_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDeleteWorkflowRunLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteWorkflowRunLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete workflow run logs
    ///
    /// Deletes all logs for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for delete_workflow_run_logs](https://docs.github.com/rest/reference/actions#delete-workflow-run-logs)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_workflow_run_logs(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDeleteWorkflowRunLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDeleteWorkflowRunLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for disable_selected_repository_github_actions_organization](https://docs.github.com/rest/reference/actions#disable-a-selected-repository-for-github-actions-in-an-organization)
    ///
    /// ---
    pub async fn disable_selected_repository_github_actions_organization_async(&self, org: &str, repository_id: i32) -> Result<(), ActionsDisableSelectedRepositoryGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories/{}", super::GITHUB_BASE_API_URL, org, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDisableSelectedRepositoryGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a selected repository for GitHub Actions in an organization
    ///
    /// Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for disable_selected_repository_github_actions_organization](https://docs.github.com/rest/reference/actions#disable-a-selected-repository-for-github-actions-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_selected_repository_github_actions_organization(&self, org: &str, repository_id: i32) -> Result<(), ActionsDisableSelectedRepositoryGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories/{}", super::GITHUB_BASE_API_URL, org, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDisableSelectedRepositoryGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a workflow
    ///
    /// Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for disable_workflow](https://docs.github.com/rest/reference/actions#disable-a-workflow)
    ///
    /// ---
    pub async fn disable_workflow_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<(), ActionsDisableWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/disable", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDisableWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a workflow
    ///
    /// Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for disable_workflow](https://docs.github.com/rest/reference/actions#disable-a-workflow)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_workflow(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<(), ActionsDisableWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/disable", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsDisableWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download an artifact
    ///
    /// Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
    /// the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to
    /// the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_artifact](https://docs.github.com/rest/reference/actions#download-an-artifact)
    ///
    /// ---
    pub async fn download_artifact_async(&self, owner: &str, repo: &str, artifact_id: i32, archive_format: &str) -> Result<(), ActionsDownloadArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id, archive_format);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadArtifactError::Status302),
                code => Err(ActionsDownloadArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download an artifact
    ///
    /// Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
    /// the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to
    /// the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_artifact](https://docs.github.com/rest/reference/actions#download-an-artifact)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_artifact(&self, owner: &str, repo: &str, artifact_id: i32, archive_format: &str) -> Result<(), ActionsDownloadArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id, archive_format);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadArtifactError::Status302),
                code => Err(ActionsDownloadArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download job logs for a workflow run
    ///
    /// Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
    /// for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can
    /// use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must
    /// have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_job_logs_for_workflow_run](https://docs.github.com/rest/reference/actions#download-job-logs-for-a-workflow-run)
    ///
    /// ---
    pub async fn download_job_logs_for_workflow_run_async(&self, owner: &str, repo: &str, job_id: i32) -> Result<(), ActionsDownloadJobLogsForWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/jobs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, job_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadJobLogsForWorkflowRunError::Status302),
                code => Err(ActionsDownloadJobLogsForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download job logs for a workflow run
    ///
    /// Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
    /// for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can
    /// use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must
    /// have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_job_logs_for_workflow_run](https://docs.github.com/rest/reference/actions#download-job-logs-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_job_logs_for_workflow_run(&self, owner: &str, repo: &str, job_id: i32) -> Result<(), ActionsDownloadJobLogsForWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/jobs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, job_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadJobLogsForWorkflowRunError::Status302),
                code => Err(ActionsDownloadJobLogsForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download workflow run attempt logs
    ///
    /// Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
    /// 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to
    /// the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_workflow_run_attempt_logs](https://docs.github.com/rest/reference/actions#download-workflow-run-attempt-logs)
    ///
    /// ---
    pub async fn download_workflow_run_attempt_logs_async(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32) -> Result<(), ActionsDownloadWorkflowRunAttemptLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadWorkflowRunAttemptLogsError::Status302),
                code => Err(ActionsDownloadWorkflowRunAttemptLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download workflow run attempt logs
    ///
    /// Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
    /// 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to
    /// the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_workflow_run_attempt_logs](https://docs.github.com/rest/reference/actions#download-workflow-run-attempt-logs)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_workflow_run_attempt_logs(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32) -> Result<(), ActionsDownloadWorkflowRunAttemptLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadWorkflowRunAttemptLogsError::Status302),
                code => Err(ActionsDownloadWorkflowRunAttemptLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download workflow run logs
    ///
    /// Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
    /// `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use
    /// this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have
    /// the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_workflow_run_logs](https://docs.github.com/rest/reference/actions#download-workflow-run-logs)
    ///
    /// ---
    pub async fn download_workflow_run_logs_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDownloadWorkflowRunLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadWorkflowRunLogsError::Status302),
                code => Err(ActionsDownloadWorkflowRunLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Download workflow run logs
    ///
    /// Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
    /// `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use
    /// this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have
    /// the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for download_workflow_run_logs](https://docs.github.com/rest/reference/actions#download-workflow-run-logs)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn download_workflow_run_logs(&self, owner: &str, repo: &str, run_id: i32) -> Result<(), ActionsDownloadWorkflowRunLogsError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/logs", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                302 => Err(ActionsDownloadWorkflowRunLogsError::Status302),
                code => Err(ActionsDownloadWorkflowRunLogsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for enable_selected_repository_github_actions_organization](https://docs.github.com/rest/reference/actions#enable-a-selected-repository-for-github-actions-in-an-organization)
    ///
    /// ---
    pub async fn enable_selected_repository_github_actions_organization_async(&self, org: &str, repository_id: i32) -> Result<(), ActionsEnableSelectedRepositoryGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories/{}", super::GITHUB_BASE_API_URL, org, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsEnableSelectedRepositoryGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a selected repository for GitHub Actions in an organization
    ///
    /// Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for enable_selected_repository_github_actions_organization](https://docs.github.com/rest/reference/actions#enable-a-selected-repository-for-github-actions-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_selected_repository_github_actions_organization(&self, org: &str, repository_id: i32) -> Result<(), ActionsEnableSelectedRepositoryGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories/{}", super::GITHUB_BASE_API_URL, org, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsEnableSelectedRepositoryGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a workflow
    ///
    /// Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for enable_workflow](https://docs.github.com/rest/reference/actions#enable-a-workflow)
    ///
    /// ---
    pub async fn enable_workflow_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<(), ActionsEnableWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/enable", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsEnableWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a workflow
    ///
    /// Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for enable_workflow](https://docs.github.com/rest/reference/actions#enable-a-workflow)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_workflow(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<(), ActionsEnableWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/enable", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsEnableWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for an organization
    ///
    /// Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for get_allowed_actions_organization](https://docs.github.com/rest/reference/actions#get-allowed-actions-for-an-organization)
    ///
    /// ---
    pub async fn get_allowed_actions_organization_async(&self, org: &str) -> Result<PutActionsSetAllowedActionsRepository, ActionsGetAllowedActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetAllowedActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for an organization
    ///
    /// Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for get_allowed_actions_organization](https://docs.github.com/rest/reference/actions#get-allowed-actions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_allowed_actions_organization(&self, org: &str) -> Result<PutActionsSetAllowedActionsRepository, ActionsGetAllowedActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetAllowedActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for a repository
    ///
    /// Gets the settings for selected actions that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for get_allowed_actions_repository](https://docs.github.com/rest/reference/actions#get-allowed-actions-for-a-repository)
    ///
    /// ---
    pub async fn get_allowed_actions_repository_async(&self, owner: &str, repo: &str) -> Result<PutActionsSetAllowedActionsRepository, ActionsGetAllowedActionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetAllowedActionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for a repository
    ///
    /// Gets the settings for selected actions that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for get_allowed_actions_repository](https://docs.github.com/rest/reference/actions#get-allowed-actions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_allowed_actions_repository(&self, owner: &str, repo: &str) -> Result<PutActionsSetAllowedActionsRepository, ActionsGetAllowedActionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetAllowedActionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an artifact
    ///
    /// Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_artifact](https://docs.github.com/rest/reference/actions#get-an-artifact)
    ///
    /// ---
    pub async fn get_artifact_async(&self, owner: &str, repo: &str, artifact_id: i32) -> Result<Artifact, ActionsGetArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an artifact
    ///
    /// Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_artifact](https://docs.github.com/rest/reference/actions#get-an-artifact)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_artifact(&self, owner: &str, repo: &str, artifact_id: i32) -> Result<Artifact, ActionsGetArtifactError> {

        let request_uri = format!("{}/repos/{}/{}/actions/artifacts/{}", super::GITHUB_BASE_API_URL, owner, repo, artifact_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetArtifactError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment public key
    ///
    /// Get the public key for an environment, which you need to encrypt environment secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment_public_key](https://docs.github.com/rest/reference/actions#get-an-environment-public-key)
    ///
    /// ---
    pub async fn get_environment_public_key_async(&self, repository_id: i32, environment_name: &str) -> Result<ActionsPublicKey, ActionsGetEnvironmentPublicKeyError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/public-key", super::GITHUB_BASE_API_URL, repository_id, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetEnvironmentPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment public key
    ///
    /// Get the public key for an environment, which you need to encrypt environment secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment_public_key](https://docs.github.com/rest/reference/actions#get-an-environment-public-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_environment_public_key(&self, repository_id: i32, environment_name: &str) -> Result<ActionsPublicKey, ActionsGetEnvironmentPublicKeyError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/public-key", super::GITHUB_BASE_API_URL, repository_id, environment_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetEnvironmentPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment secret
    ///
    /// Gets a single environment secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment_secret](https://docs.github.com/rest/reference/actions#get-an-environment-secret)
    ///
    /// ---
    pub async fn get_environment_secret_async(&self, repository_id: i32, environment_name: &str, secret_name: &str) -> Result<ActionsSecret, ActionsGetEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an environment secret
    ///
    /// Gets a single environment secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_environment_secret](https://docs.github.com/rest/reference/actions#get-an-environment-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_environment_secret(&self, repository_id: i32, environment_name: &str, secret_name: &str) -> Result<ActionsSecret, ActionsGetEnvironmentSecretError> {

        let request_uri = format!("{}/repositories/{}/environments/{}/secrets/{}", super::GITHUB_BASE_API_URL, repository_id, environment_name, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetEnvironmentSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_organization](https://docs.github.com/rest/reference/actions#get-github-actions-permissions-for-an-organization)
    ///
    /// ---
    pub async fn get_github_actions_permissions_organization_async(&self, org: &str) -> Result<ActionsOrganizationPermissions, ActionsGetGithubActionsPermissionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetGithubActionsPermissionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for an organization
    ///
    /// Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_organization](https://docs.github.com/rest/reference/actions#get-github-actions-permissions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_github_actions_permissions_organization(&self, org: &str) -> Result<ActionsOrganizationPermissions, ActionsGetGithubActionsPermissionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetGithubActionsPermissionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for a repository
    ///
    /// Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions allowed to run in the repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this
    /// endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_repository](https://docs.github.com/rest/reference/actions#get-github-actions-permissions-for-a-repository)
    ///
    /// ---
    pub async fn get_github_actions_permissions_repository_async(&self, owner: &str, repo: &str) -> Result<ActionsRepositoryPermissions, ActionsGetGithubActionsPermissionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetGithubActionsPermissionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for a repository
    ///
    /// Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions allowed to run in the repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this
    /// endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_repository](https://docs.github.com/rest/reference/actions#get-github-actions-permissions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_github_actions_permissions_repository(&self, owner: &str, repo: &str) -> Result<ActionsRepositoryPermissions, ActionsGetGithubActionsPermissionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetGithubActionsPermissionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a job for a workflow run
    ///
    /// Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_job_for_workflow_run](https://docs.github.com/rest/reference/actions#get-a-job-for-a-workflow-run)
    ///
    /// ---
    pub async fn get_job_for_workflow_run_async(&self, owner: &str, repo: &str, job_id: i32) -> Result<Job, ActionsGetJobForWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/jobs/{}", super::GITHUB_BASE_API_URL, owner, repo, job_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetJobForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a job for a workflow run
    ///
    /// Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_job_for_workflow_run](https://docs.github.com/rest/reference/actions#get-a-job-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_job_for_workflow_run(&self, owner: &str, repo: &str, job_id: i32) -> Result<Job, ActionsGetJobForWorkflowRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/jobs/{}", super::GITHUB_BASE_API_URL, owner, repo, job_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetJobForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_org_public_key](https://docs.github.com/rest/reference/actions#get-an-organization-public-key)
    ///
    /// ---
    pub async fn get_org_public_key_async(&self, org: &str) -> Result<ActionsPublicKey, ActionsGetOrgPublicKeyError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/public-key", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetOrgPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_org_public_key](https://docs.github.com/rest/reference/actions#get-an-organization-public-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_org_public_key(&self, org: &str) -> Result<ActionsPublicKey, ActionsGetOrgPublicKeyError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/public-key", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetOrgPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_org_secret](https://docs.github.com/rest/reference/actions#get-an-organization-secret)
    ///
    /// ---
    pub async fn get_org_secret_async(&self, org: &str, secret_name: &str) -> Result<OrganizationActionsSecret, ActionsGetOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_org_secret](https://docs.github.com/rest/reference/actions#get-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_org_secret(&self, org: &str, secret_name: &str) -> Result<OrganizationActionsSecret, ActionsGetOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get pending deployments for a workflow run
    ///
    /// Get all deployment environments for a workflow run that are waiting for protection rules to pass.
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_pending_deployments_for_run](https://docs.github.com/rest/reference/actions#get-pending-deployments-for-a-workflow-run)
    ///
    /// ---
    pub async fn get_pending_deployments_for_run_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<Vec<PendingDeployment>, ActionsGetPendingDeploymentsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/pending_deployments", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetPendingDeploymentsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get pending deployments for a workflow run
    ///
    /// Get all deployment environments for a workflow run that are waiting for protection rules to pass.
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_pending_deployments_for_run](https://docs.github.com/rest/reference/actions#get-pending-deployments-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_pending_deployments_for_run(&self, owner: &str, repo: &str, run_id: i32) -> Result<Vec<PendingDeployment>, ActionsGetPendingDeploymentsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/pending_deployments", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetPendingDeploymentsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_repo_public_key](https://docs.github.com/rest/reference/actions#get-a-repository-public-key)
    ///
    /// ---
    pub async fn get_repo_public_key_async(&self, owner: &str, repo: &str) -> Result<ActionsPublicKey, ActionsGetRepoPublicKeyError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/public-key", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetRepoPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_repo_public_key](https://docs.github.com/rest/reference/actions#get-a-repository-public-key)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_repo_public_key(&self, owner: &str, repo: &str) -> Result<ActionsPublicKey, ActionsGetRepoPublicKeyError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/public-key", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetRepoPublicKeyError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_repo_secret](https://docs.github.com/rest/reference/actions#get-a-repository-secret)
    ///
    /// ---
    pub async fn get_repo_secret_async(&self, owner: &str, repo: &str, secret_name: &str) -> Result<ActionsSecret, ActionsGetRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_repo_secret](https://docs.github.com/rest/reference/actions#get-a-repository-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_repo_secret(&self, owner: &str, repo: &str, secret_name: &str) -> Result<ActionsSecret, ActionsGetRepoSecretError> {

        let request_uri = format!("{}/repos/{}/{}/actions/secrets/{}", super::GITHUB_BASE_API_URL, owner, repo, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetRepoSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the review history for a workflow run
    ///
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_reviews_for_run](https://docs.github.com/rest/reference/actions#get-the-review-history-for-a-workflow-run)
    ///
    /// ---
    pub async fn get_reviews_for_run_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<Vec<EnvironmentApprovals>, ActionsGetReviewsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/approvals", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetReviewsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the review history for a workflow run
    ///
    /// Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_reviews_for_run](https://docs.github.com/rest/reference/actions#get-the-review-history-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_reviews_for_run(&self, owner: &str, repo: &str, run_id: i32) -> Result<Vec<EnvironmentApprovals>, ActionsGetReviewsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/approvals", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetReviewsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for an organization
    ///
    /// Gets a specific self-hosted runner configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_org](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-for-an-organization)
    ///
    /// ---
    pub async fn get_self_hosted_runner_for_org_async(&self, org: &str, runner_id: i32) -> Result<Runner, ActionsGetSelfHostedRunnerForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, org, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for an organization
    ///
    /// Gets a specific self-hosted runner configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_org](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_self_hosted_runner_for_org(&self, org: &str, runner_id: i32) -> Result<Runner, ActionsGetSelfHostedRunnerForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, org, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for a repository
    ///
    /// Gets a specific self-hosted runner configured in a repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this
    /// endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_repo](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-for-a-repository)
    ///
    /// ---
    pub async fn get_self_hosted_runner_for_repo_async(&self, owner: &str, repo: &str, runner_id: i32) -> Result<Runner, ActionsGetSelfHostedRunnerForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, owner, repo, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for a repository
    ///
    /// Gets a specific self-hosted runner configured in a repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this
    /// endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_repo](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_self_hosted_runner_for_repo(&self, owner: &str, repo: &str, runner_id: i32) -> Result<Runner, ActionsGetSelfHostedRunnerForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, owner, repo, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Gets a specific self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    pub async fn get_self_hosted_runner_group_for_org_async(&self, org: &str, runner_group_id: i32) -> Result<RunnerGroupsOrg, ActionsGetSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Gets a specific self-hosted runner group for an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#get-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_self_hosted_runner_group_for_org(&self, org: &str, runner_group_id: i32) -> Result<RunnerGroupsOrg, ActionsGetSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow
    ///
    /// Gets a specific workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow](https://docs.github.com/rest/reference/actions#get-a-workflow)
    ///
    /// ---
    pub async fn get_workflow_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<Workflow, ActionsGetWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow
    ///
    /// Gets a specific workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow](https://docs.github.com/rest/reference/actions#get-a-workflow)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_workflow(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<Workflow, ActionsGetWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow run
    ///
    /// Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run](https://docs.github.com/rest/reference/actions#get-a-workflow-run)
    ///
    /// ---
    pub async fn get_workflow_run_async(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsGetWorkflowRunParams>>) -> Result<WorkflowRun, ActionsGetWorkflowRunError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow run
    ///
    /// Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run](https://docs.github.com/rest/reference/actions#get-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_workflow_run(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsGetWorkflowRunParams>>) -> Result<WorkflowRun, ActionsGetWorkflowRunError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsGetWorkflowRunParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow run attempt
    ///
    /// Gets a specific workflow run attempt. Anyone with read access to the repository
    /// can use this endpoint. If the repository is private you must use an access token
    /// with the `repo` scope. GitHub Apps must have the `actions:read` permission to
    /// use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run_attempt](https://docs.github.com/rest/reference/actions#get-a-workflow-run-attempt)
    ///
    /// ---
    pub async fn get_workflow_run_attempt_async(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32, query_params: Option<impl Into<ActionsGetWorkflowRunAttemptParams>>) -> Result<WorkflowRun, ActionsGetWorkflowRunAttemptError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunAttemptError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a workflow run attempt
    ///
    /// Gets a specific workflow run attempt. Anyone with read access to the repository
    /// can use this endpoint. If the repository is private you must use an access token
    /// with the `repo` scope. GitHub Apps must have the `actions:read` permission to
    /// use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run_attempt](https://docs.github.com/rest/reference/actions#get-a-workflow-run-attempt)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_workflow_run_attempt(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32, query_params: Option<impl Into<ActionsGetWorkflowRunAttemptParams>>) -> Result<WorkflowRun, ActionsGetWorkflowRunAttemptError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsGetWorkflowRunAttemptParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunAttemptError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get workflow run usage
    ///
    /// Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run_usage](https://docs.github.com/rest/reference/actions#get-workflow-run-usage)
    ///
    /// ---
    pub async fn get_workflow_run_usage_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<WorkflowRunUsage, ActionsGetWorkflowRunUsageError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/timing", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunUsageError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get workflow run usage
    ///
    /// Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_run_usage](https://docs.github.com/rest/reference/actions#get-workflow-run-usage)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_workflow_run_usage(&self, owner: &str, repo: &str, run_id: i32) -> Result<WorkflowRunUsage, ActionsGetWorkflowRunUsageError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/timing", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowRunUsageError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get workflow usage
    ///
    /// Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    /// 
    /// You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_usage](https://docs.github.com/rest/reference/actions#get-workflow-usage)
    ///
    /// ---
    pub async fn get_workflow_usage_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<WorkflowUsage, ActionsGetWorkflowUsageError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/timing", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowUsageError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get workflow usage
    ///
    /// Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
    /// 
    /// You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for get_workflow_usage](https://docs.github.com/rest/reference/actions#get-workflow-usage)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_workflow_usage(&self, owner: &str, repo: &str, workflow_id: WorkflowId) -> Result<WorkflowUsage, ActionsGetWorkflowUsageError> {

        let request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/timing", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsGetWorkflowUsageError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List artifacts for a repository
    ///
    /// Lists all artifacts for a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_artifacts_for_repo](https://docs.github.com/rest/reference/actions#list-artifacts-for-a-repository)
    ///
    /// ---
    pub async fn list_artifacts_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListArtifactsForRepoParams>>) -> Result<GetActionsListWorkflowRunArtifactsResponse200, ActionsListArtifactsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/artifacts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListArtifactsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List artifacts for a repository
    ///
    /// Lists all artifacts for a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_artifacts_for_repo](https://docs.github.com/rest/reference/actions#list-artifacts-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_artifacts_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListArtifactsForRepoParams>>) -> Result<GetActionsListWorkflowRunArtifactsResponse200, ActionsListArtifactsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/artifacts", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListArtifactsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListArtifactsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List environment secrets
    ///
    /// Lists all secrets available in an environment without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_environment_secrets](https://docs.github.com/rest/reference/actions#list-environment-secrets)
    ///
    /// ---
    pub async fn list_environment_secrets_async(&self, repository_id: i32, environment_name: &str, query_params: Option<impl Into<ActionsListEnvironmentSecretsParams>>) -> Result<GetActionsListEnvironmentSecretsResponse200, ActionsListEnvironmentSecretsError> {

        let mut request_uri = format!("{}/repositories/{}/environments/{}/secrets", super::GITHUB_BASE_API_URL, repository_id, environment_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListEnvironmentSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List environment secrets
    ///
    /// Lists all secrets available in an environment without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_environment_secrets](https://docs.github.com/rest/reference/actions#list-environment-secrets)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_environment_secrets(&self, repository_id: i32, environment_name: &str, query_params: Option<impl Into<ActionsListEnvironmentSecretsParams>>) -> Result<GetActionsListEnvironmentSecretsResponse200, ActionsListEnvironmentSecretsError> {

        let mut request_uri = format!("{}/repositories/{}/environments/{}/secrets", super::GITHUB_BASE_API_URL, repository_id, environment_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListEnvironmentSecretsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListEnvironmentSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List jobs for a workflow run
    ///
    /// Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// [GitHub API docs for list_jobs_for_workflow_run](https://docs.github.com/rest/reference/actions#list-jobs-for-a-workflow-run)
    ///
    /// ---
    pub async fn list_jobs_for_workflow_run_async(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsListJobsForWorkflowRunParams<'api>>>) -> Result<GetActionsListJobsForWorkflowRunResponse200, ActionsListJobsForWorkflowRunError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/jobs", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListJobsForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List jobs for a workflow run
    ///
    /// Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// [GitHub API docs for list_jobs_for_workflow_run](https://docs.github.com/rest/reference/actions#list-jobs-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_jobs_for_workflow_run(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsListJobsForWorkflowRunParams<'api>>>) -> Result<GetActionsListJobsForWorkflowRunResponse200, ActionsListJobsForWorkflowRunError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/jobs", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListJobsForWorkflowRunParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListJobsForWorkflowRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List jobs for a workflow run attempt
    ///
    /// Lists jobs for a specific workflow run attempt. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// [GitHub API docs for list_jobs_for_workflow_run_attempt](https://docs.github.com/rest/reference/actions#list-jobs-for-a-workflow-run-attempt)
    ///
    /// ---
    pub async fn list_jobs_for_workflow_run_attempt_async(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32, query_params: Option<impl Into<ActionsListJobsForWorkflowRunAttemptParams>>) -> Result<GetActionsListJobsForWorkflowRunResponse200, ActionsListJobsForWorkflowRunAttemptError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}/jobs", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActionsListJobsForWorkflowRunAttemptError::Status404(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActionsListJobsForWorkflowRunAttemptError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List jobs for a workflow run attempt
    ///
    /// Lists jobs for a specific workflow run attempt. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// [GitHub API docs for list_jobs_for_workflow_run_attempt](https://docs.github.com/rest/reference/actions#list-jobs-for-a-workflow-run-attempt)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_jobs_for_workflow_run_attempt(&self, owner: &str, repo: &str, run_id: i32, attempt_number: i32, query_params: Option<impl Into<ActionsListJobsForWorkflowRunAttemptParams>>) -> Result<GetActionsListJobsForWorkflowRunResponse200, ActionsListJobsForWorkflowRunAttemptError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/attempts/{}/jobs", super::GITHUB_BASE_API_URL, owner, repo, run_id, attempt_number);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListJobsForWorkflowRunAttemptParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActionsListJobsForWorkflowRunAttemptError::Status404(crate::adapters::to_json(github_response)?)),
                code => Err(ActionsListJobsForWorkflowRunAttemptError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_org_secrets](https://docs.github.com/rest/reference/actions#list-organization-secrets)
    ///
    /// ---
    pub async fn list_org_secrets_async(&self, org: &str, query_params: Option<impl Into<ActionsListOrgSecretsParams>>) -> Result<GetActionsListOrgSecretsResponse200, ActionsListOrgSecretsError> {

        let mut request_uri = format!("{}/orgs/{}/actions/secrets", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListOrgSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_org_secrets](https://docs.github.com/rest/reference/actions#list-organization-secrets)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_org_secrets(&self, org: &str, query_params: Option<impl Into<ActionsListOrgSecretsParams>>) -> Result<GetActionsListOrgSecretsResponse200, ActionsListOrgSecretsError> {

        let mut request_uri = format!("{}/orgs/{}/actions/secrets", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListOrgSecretsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListOrgSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists the repositories with access to a self-hosted runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#list-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    pub async fn list_repo_access_to_self_hosted_runner_group_in_org_async(&self, org: &str, runner_group_id: i32, query_params: Option<impl Into<ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams>>) -> Result<GetActionsListRepoAccessToSelfHostedRunnerGroupInOrgResponse200, ActionsListRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories", super::GITHUB_BASE_API_URL, org, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists the repositories with access to a self-hosted runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#list-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repo_access_to_self_hosted_runner_group_in_org(&self, org: &str, runner_group_id: i32, query_params: Option<impl Into<ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams>>) -> Result<GetActionsListRepoAccessToSelfHostedRunnerGroupInOrgResponse200, ActionsListRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories", super::GITHUB_BASE_API_URL, org, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListRepoAccessToSelfHostedRunnerGroupInOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_secrets](https://docs.github.com/rest/reference/actions#list-repository-secrets)
    ///
    /// ---
    pub async fn list_repo_secrets_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListRepoSecretsParams>>) -> Result<GetActionsListEnvironmentSecretsResponse200, ActionsListRepoSecretsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/secrets", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_secrets](https://docs.github.com/rest/reference/actions#list-repository-secrets)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repo_secrets(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListRepoSecretsParams>>) -> Result<GetActionsListEnvironmentSecretsResponse200, ActionsListRepoSecretsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/secrets", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListRepoSecretsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoSecretsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository workflows
    ///
    /// Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_workflows](https://docs.github.com/rest/reference/actions#list-repository-workflows)
    ///
    /// ---
    pub async fn list_repo_workflows_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListRepoWorkflowsParams>>) -> Result<GetActionsListRepoWorkflowsResponse200, ActionsListRepoWorkflowsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/workflows", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoWorkflowsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository workflows
    ///
    /// Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_repo_workflows](https://docs.github.com/rest/reference/actions#list-repository-workflows)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repo_workflows(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListRepoWorkflowsParams>>) -> Result<GetActionsListRepoWorkflowsResponse200, ActionsListRepoWorkflowsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/workflows", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListRepoWorkflowsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRepoWorkflowsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for an organization
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_org](https://docs.github.com/rest/reference/actions#list-runner-applications-for-an-organization)
    ///
    /// ---
    pub async fn list_runner_applications_for_org_async(&self, org: &str) -> Result<Vec<RunnerApplication>, ActionsListRunnerApplicationsForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRunnerApplicationsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for an organization
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_org](https://docs.github.com/rest/reference/actions#list-runner-applications-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_runner_applications_for_org(&self, org: &str) -> Result<Vec<RunnerApplication>, ActionsListRunnerApplicationsForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRunnerApplicationsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for a repository
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_repo](https://docs.github.com/rest/reference/actions#list-runner-applications-for-a-repository)
    ///
    /// ---
    pub async fn list_runner_applications_for_repo_async(&self, owner: &str, repo: &str) -> Result<Vec<RunnerApplication>, ActionsListRunnerApplicationsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRunnerApplicationsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for a repository
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_repo](https://docs.github.com/rest/reference/actions#list-runner-applications-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_runner_applications_for_repo(&self, owner: &str, repo: &str) -> Result<Vec<RunnerApplication>, ActionsListRunnerApplicationsForRepoError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListRunnerApplicationsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_selected_repos_for_org_secret](https://docs.github.com/rest/reference/actions#list-selected-repositories-for-an-organization-secret)
    ///
    /// ---
    pub async fn list_selected_repos_for_org_secret_async(&self, org: &str, secret_name: &str, query_params: Option<impl Into<ActionsListSelectedReposForOrgSecretParams>>) -> Result<GetActionsListSelectedReposForOrgSecretResponse200, ActionsListSelectedReposForOrgSecretError> {

        let mut request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories", super::GITHUB_BASE_API_URL, org, secret_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelectedReposForOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_selected_repos_for_org_secret](https://docs.github.com/rest/reference/actions#list-selected-repositories-for-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_selected_repos_for_org_secret(&self, org: &str, secret_name: &str, query_params: Option<impl Into<ActionsListSelectedReposForOrgSecretParams>>) -> Result<GetActionsListSelectedReposForOrgSecretResponse200, ActionsListSelectedReposForOrgSecretError> {

        let mut request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories", super::GITHUB_BASE_API_URL, org, secret_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelectedReposForOrgSecretParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelectedReposForOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for list_selected_repositories_enabled_github_actions_organization](https://docs.github.com/rest/reference/actions#list-selected-repositories-enabled-for-github-actions-in-an-organization)
    ///
    /// ---
    pub async fn list_selected_repositories_enabled_github_actions_organization_async(&self, org: &str, query_params: Option<impl Into<ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams>>) -> Result<GetActionsListSelectedRepositoriesEnabledGithubActionsOrganizationResponse200, ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationError> {

        let mut request_uri = format!("{}/orgs/{}/actions/permissions/repositories", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected repositories enabled for GitHub Actions in an organization
    ///
    /// Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for list_selected_repositories_enabled_github_actions_organization](https://docs.github.com/rest/reference/actions#list-selected-repositories-enabled-for-github-actions-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_selected_repositories_enabled_github_actions_organization(&self, org: &str, query_params: Option<impl Into<ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams>>) -> Result<GetActionsListSelectedRepositoriesEnabledGithubActionsOrganizationResponse200, ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationError> {

        let mut request_uri = format!("{}/orgs/{}/actions/permissions/repositories", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelectedRepositoriesEnabledGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runner groups for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runner_groups_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runner-groups-for-an-organization)
    ///
    /// ---
    pub async fn list_self_hosted_runner_groups_for_org_async(&self, org: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnerGroupsForOrgParams>>) -> Result<GetActionsListSelfHostedRunnerGroupsForOrgResponse200, ActionsListSelfHostedRunnerGroupsForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnerGroupsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runner groups for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runner_groups_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runner-groups-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runner_groups_for_org(&self, org: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnerGroupsForOrgParams>>) -> Result<GetActionsListSelfHostedRunnerGroupsForOrgResponse200, ActionsListSelfHostedRunnerGroupsForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelfHostedRunnerGroupsForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnerGroupsForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for an organization
    ///
    /// Lists all self-hosted runners configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-for-an-organization)
    ///
    /// ---
    pub async fn list_self_hosted_runners_for_org_async(&self, org: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnersForOrgParams>>) -> Result<GetActionsListSelfHostedRunnersForRepoResponse200, ActionsListSelfHostedRunnersForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runners", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for an organization
    ///
    /// Lists all self-hosted runners configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runners_for_org(&self, org: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnersForOrgParams>>) -> Result<GetActionsListSelfHostedRunnersForRepoResponse200, ActionsListSelfHostedRunnersForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runners", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelfHostedRunnersForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for a repository
    ///
    /// Lists all self-hosted runners configured in a repository. You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_repo](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-for-a-repository)
    ///
    /// ---
    pub async fn list_self_hosted_runners_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnersForRepoParams>>) -> Result<GetActionsListSelfHostedRunnersForRepoResponse200, ActionsListSelfHostedRunnersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runners", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for a repository
    ///
    /// Lists all self-hosted runners configured in a repository. You must authenticate using an access token with the `repo` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_repo](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runners_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListSelfHostedRunnersForRepoParams>>) -> Result<GetActionsListSelfHostedRunnersForRepoResponse200, ActionsListSelfHostedRunnersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runners", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelfHostedRunnersForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners in a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists self-hosted runners that are in a specific organization group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_in_group_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-in-a-group-for-an-organization)
    ///
    /// ---
    pub async fn list_self_hosted_runners_in_group_for_org_async(&self, org: &str, runner_group_id: i32, query_params: Option<impl Into<ActionsListSelfHostedRunnersInGroupForOrgParams>>) -> Result<GetActionsListSelfHostedRunnersInGroupForOrgResponse200, ActionsListSelfHostedRunnersInGroupForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, org, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersInGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners in a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Lists self-hosted runners that are in a specific organization group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_in_group_for_org](https://docs.github.com/rest/reference/actions#list-self-hosted-runners-in-a-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runners_in_group_for_org(&self, org: &str, runner_group_id: i32, query_params: Option<impl Into<ActionsListSelfHostedRunnersInGroupForOrgParams>>) -> Result<GetActionsListSelfHostedRunnersInGroupForOrgResponse200, ActionsListSelfHostedRunnersInGroupForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, org, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListSelfHostedRunnersInGroupForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListSelfHostedRunnersInGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow run artifacts
    ///
    /// Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_workflow_run_artifacts](https://docs.github.com/rest/reference/actions#list-workflow-run-artifacts)
    ///
    /// ---
    pub async fn list_workflow_run_artifacts_async(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsListWorkflowRunArtifactsParams>>) -> Result<GetActionsListWorkflowRunArtifactsResponse200, ActionsListWorkflowRunArtifactsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/artifacts", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunArtifactsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow run artifacts
    ///
    /// Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_workflow_run_artifacts](https://docs.github.com/rest/reference/actions#list-workflow-run-artifacts)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_workflow_run_artifacts(&self, owner: &str, repo: &str, run_id: i32, query_params: Option<impl Into<ActionsListWorkflowRunArtifactsParams>>) -> Result<GetActionsListWorkflowRunArtifactsResponse200, ActionsListWorkflowRunArtifactsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs/{}/artifacts", super::GITHUB_BASE_API_URL, owner, repo, run_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListWorkflowRunArtifactsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunArtifactsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow runs
    ///
    /// List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// 
    /// [GitHub API docs for list_workflow_runs](https://docs.github.com/rest/reference/actions#list-workflow-runs)
    ///
    /// ---
    pub async fn list_workflow_runs_async(&self, owner: &str, repo: &str, workflow_id: WorkflowId, query_params: Option<impl Into<ActionsListWorkflowRunsParams<'api>>>) -> Result<GetActionsListWorkflowRunsResponse200, ActionsListWorkflowRunsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/runs", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow runs
    ///
    /// List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
    /// 
    /// [GitHub API docs for list_workflow_runs](https://docs.github.com/rest/reference/actions#list-workflow-runs)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_workflow_runs(&self, owner: &str, repo: &str, workflow_id: WorkflowId, query_params: Option<impl Into<ActionsListWorkflowRunsParams<'api>>>) -> Result<GetActionsListWorkflowRunsResponse200, ActionsListWorkflowRunsError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/workflows/{}/runs", super::GITHUB_BASE_API_URL, owner, repo, workflow_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListWorkflowRunsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow runs for a repository
    ///
    /// Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_workflow_runs_for_repo](https://docs.github.com/rest/reference/actions#list-workflow-runs-for-a-repository)
    ///
    /// ---
    pub async fn list_workflow_runs_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListWorkflowRunsForRepoParams<'api>>>) -> Result<GetActionsListWorkflowRunsResponse200, ActionsListWorkflowRunsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List workflow runs for a repository
    ///
    /// Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
    /// 
    /// Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
    /// 
    /// [GitHub API docs for list_workflow_runs_for_repo](https://docs.github.com/rest/reference/actions#list-workflow-runs-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_workflow_runs_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActionsListWorkflowRunsForRepoParams<'api>>>) -> Result<GetActionsListWorkflowRunsResponse200, ActionsListWorkflowRunsForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/actions/runs", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActionsListWorkflowRunsForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsListWorkflowRunsForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Re-run a workflow
    ///
    /// Re-runs your workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for re_run_workflow](https://docs.github.com/rest/reference/actions#re-run-a-workflow)
    ///
    /// ---
    pub async fn re_run_workflow_async(&self, owner: &str, repo: &str, run_id: i32) -> Result<HashMap<String, Value>, ActionsReRunWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/rerun", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsReRunWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Re-run a workflow
    ///
    /// Re-runs your workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
    /// 
    /// [GitHub API docs for re_run_workflow](https://docs.github.com/rest/reference/actions#re-run-a-workflow)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn re_run_workflow(&self, owner: &str, repo: &str, run_id: i32) -> Result<HashMap<String, Value>, ActionsReRunWorkflowError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/rerun", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsReRunWorkflowError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    pub async fn remove_repo_access_to_self_hosted_runner_group_in_org_async(&self, org: &str, runner_group_id: i32, repository_id: i32) -> Result<(), ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove repository access to a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_repo_access_to_self_hosted_runner_group_in_org(&self, org: &str, runner_group_id: i32, repository_id: i32) -> Result<(), ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsRemoveRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for remove_selected_repo_from_org_secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret)
    ///
    /// ---
    pub async fn remove_selected_repo_from_org_secret_async(&self, org: &str, secret_name: &str, repository_id: i32) -> Result<(), ActionsRemoveSelectedRepoFromOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                409 => Err(ActionsRemoveSelectedRepoFromOrgSecretError::Status409),
                code => Err(ActionsRemoveSelectedRepoFromOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for remove_selected_repo_from_org_secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_selected_repo_from_org_secret(&self, org: &str, secret_name: &str, repository_id: i32) -> Result<(), ActionsRemoveSelectedRepoFromOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories/{}", super::GITHUB_BASE_API_URL, org, secret_name, repository_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                409 => Err(ActionsRemoveSelectedRepoFromOrgSecretError::Status409),
                code => Err(ActionsRemoveSelectedRepoFromOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a self-hosted runner from a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_self_hosted_runner_from_group_for_org](https://docs.github.com/rest/reference/actions#remove-a-self-hosted-runner-from-a-group-for-an-organization)
    ///
    /// ---
    pub async fn remove_self_hosted_runner_from_group_for_org_async(&self, org: &str, runner_group_id: i32, runner_id: i32) -> Result<(), ActionsRemoveSelfHostedRunnerFromGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsRemoveSelfHostedRunnerFromGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a self-hosted runner from a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// 
    /// Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_self_hosted_runner_from_group_for_org](https://docs.github.com/rest/reference/actions#remove-a-self-hosted-runner-from-a-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_self_hosted_runner_from_group_for_org(&self, org: &str, runner_group_id: i32, runner_id: i32) -> Result<(), ActionsRemoveSelfHostedRunnerFromGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, org, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsRemoveSelfHostedRunnerFromGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Review pending deployments for a workflow run
    ///
    /// Approve or reject pending deployments that are waiting on approval by a required reviewer.
    /// 
    /// Anyone with read access to the repository contents and deployments can use this endpoint.
    /// 
    /// [GitHub API docs for review_pending_deployments_for_run](https://docs.github.com/rest/reference/actions#review-pending-deployments-for-a-workflow-run)
    ///
    /// ---
    pub async fn review_pending_deployments_for_run_async(&self, owner: &str, repo: &str, run_id: i32, body: PostActionsReviewPendingDeploymentsForRun) -> Result<Vec<Deployment>, ActionsReviewPendingDeploymentsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/pending_deployments", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsReviewPendingDeploymentsForRun::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsReviewPendingDeploymentsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Review pending deployments for a workflow run
    ///
    /// Approve or reject pending deployments that are waiting on approval by a required reviewer.
    /// 
    /// Anyone with read access to the repository contents and deployments can use this endpoint.
    /// 
    /// [GitHub API docs for review_pending_deployments_for_run](https://docs.github.com/rest/reference/actions#review-pending-deployments-for-a-workflow-run)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn review_pending_deployments_for_run(&self, owner: &str, repo: &str, run_id: i32, body: PostActionsReviewPendingDeploymentsForRun) -> Result<Vec<Deployment>, ActionsReviewPendingDeploymentsForRunError> {

        let request_uri = format!("{}/repos/{}/{}/actions/runs/{}/pending_deployments", super::GITHUB_BASE_API_URL, owner, repo, run_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostActionsReviewPendingDeploymentsForRun::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsReviewPendingDeploymentsForRunError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for an organization
    ///
    /// Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
    /// 
    /// To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_allowed_actions_organization](https://docs.github.com/rest/reference/actions#set-allowed-actions-for-an-organization)
    ///
    /// ---
    pub async fn set_allowed_actions_organization_async(&self, org: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), ActionsSetAllowedActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetAllowedActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for an organization
    ///
    /// Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
    /// 
    /// To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_allowed_actions_organization](https://docs.github.com/rest/reference/actions#set-allowed-actions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_allowed_actions_organization(&self, org: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), ActionsSetAllowedActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetAllowedActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for a repository
    ///
    /// Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    /// 
    /// If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings.
    /// 
    /// To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for set_allowed_actions_repository](https://docs.github.com/rest/reference/actions#set-allowed-actions-for-a-repository)
    ///
    /// ---
    pub async fn set_allowed_actions_repository_async(&self, owner: &str, repo: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), ActionsSetAllowedActionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetAllowedActionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for a repository
    ///
    /// Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
    /// 
    /// If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings.
    /// 
    /// To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for set_allowed_actions_repository](https://docs.github.com/rest/reference/actions#set-allowed-actions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_allowed_actions_repository(&self, owner: &str, repo: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), ActionsSetAllowedActionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetAllowedActionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
    /// 
    /// If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_organization](https://docs.github.com/rest/reference/actions#set-github-actions-permissions-for-an-organization)
    ///
    /// ---
    pub async fn set_github_actions_permissions_organization_async(&self, org: &str, body: PutActionsSetGithubActionsPermissionsOrganization) -> Result<(), ActionsSetGithubActionsPermissionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetGithubActionsPermissionsOrganization::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetGithubActionsPermissionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for an organization
    ///
    /// Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
    /// 
    /// If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_organization](https://docs.github.com/rest/reference/actions#set-github-actions-permissions-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_github_actions_permissions_organization(&self, org: &str, body: PutActionsSetGithubActionsPermissionsOrganization) -> Result<(), ActionsSetGithubActionsPermissionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetGithubActionsPermissionsOrganization::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetGithubActionsPermissionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for a repository
    ///
    /// Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.
    /// 
    /// If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_repository](https://docs.github.com/rest/reference/actions#set-github-actions-permissions-for-a-repository)
    ///
    /// ---
    pub async fn set_github_actions_permissions_repository_async(&self, owner: &str, repo: &str, body: PutActionsSetGithubActionsPermissionsRepository) -> Result<(), ActionsSetGithubActionsPermissionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetGithubActionsPermissionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetGithubActionsPermissionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for a repository
    ///
    /// Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.
    /// 
    /// If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.
    /// 
    /// You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_repository](https://docs.github.com/rest/reference/actions#set-github-actions-permissions-for-a-repository)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_github_actions_permissions_repository(&self, owner: &str, repo: &str, body: PutActionsSetGithubActionsPermissionsRepository) -> Result<(), ActionsSetGithubActionsPermissionsRepositoryError> {

        let request_uri = format!("{}/repos/{}/{}/actions/permissions", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetGithubActionsPermissionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetGithubActionsPermissionsRepositoryError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set repository access for a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#set-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    pub async fn set_repo_access_to_self_hosted_runner_group_in_org_async(&self, org: &str, runner_group_id: i32, body: PutActionsSetRepoAccessToSelfHostedRunnerGroupInOrg) -> Result<(), ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetRepoAccessToSelfHostedRunnerGroupInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set repository access for a self-hosted runner group in an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_repo_access_to_self_hosted_runner_group_in_org](https://docs.github.com/rest/reference/actions#set-repository-access-to-a-self-hosted-runner-group-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_repo_access_to_self_hosted_runner_group_in_org(&self, org: &str, runner_group_id: i32, body: PutActionsSetRepoAccessToSelfHostedRunnerGroupInOrg) -> Result<(), ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/repositories", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetRepoAccessToSelfHostedRunnerGroupInOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetRepoAccessToSelfHostedRunnerGroupInOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for set_selected_repos_for_org_secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret)
    ///
    /// ---
    pub async fn set_selected_repos_for_org_secret_async(&self, org: &str, secret_name: &str, body: PutActionsSetSelectedReposForOrgSecret) -> Result<(), ActionsSetSelectedReposForOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelectedReposForOrgSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelectedReposForOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
    /// 
    /// [GitHub API docs for set_selected_repos_for_org_secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_selected_repos_for_org_secret(&self, org: &str, secret_name: &str, body: PutActionsSetSelectedReposForOrgSecret) -> Result<(), ActionsSetSelectedReposForOrgSecretError> {

        let request_uri = format!("{}/orgs/{}/actions/secrets/{}/repositories", super::GITHUB_BASE_API_URL, org, secret_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelectedReposForOrgSecret::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelectedReposForOrgSecretError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_selected_repositories_enabled_github_actions_organization](https://docs.github.com/rest/reference/actions#set-selected-repositories-enabled-for-github-actions-in-an-organization)
    ///
    /// ---
    pub async fn set_selected_repositories_enabled_github_actions_organization_async(&self, org: &str, body: PutActionsSetSelectedRepositoriesEnabledGithubActionsOrganization) -> Result<(), ActionsSetSelectedRepositoriesEnabledGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelectedRepositoriesEnabledGithubActionsOrganization::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelectedRepositoriesEnabledGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected repositories enabled for GitHub Actions in an organization
    ///
    /// Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
    /// 
    /// [GitHub API docs for set_selected_repositories_enabled_github_actions_organization](https://docs.github.com/rest/reference/actions#set-selected-repositories-enabled-for-github-actions-in-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_selected_repositories_enabled_github_actions_organization(&self, org: &str, body: PutActionsSetSelectedRepositoriesEnabledGithubActionsOrganization) -> Result<(), ActionsSetSelectedRepositoriesEnabledGithubActionsOrganizationError> {

        let request_uri = format!("{}/orgs/{}/actions/permissions/repositories", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelectedRepositoriesEnabledGithubActionsOrganization::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelectedRepositoriesEnabledGithubActionsOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set self-hosted runners in a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Replaces the list of self-hosted runners that are part of an organization runner group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_self_hosted_runners_in_group_for_org](https://docs.github.com/rest/reference/actions#set-self-hosted-runners-in-a-group-for-an-organization)
    ///
    /// ---
    pub async fn set_self_hosted_runners_in_group_for_org_async(&self, org: &str, runner_group_id: i32, body: PutActionsSetSelfHostedRunnersInGroupForOrg) -> Result<(), ActionsSetSelfHostedRunnersInGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelfHostedRunnersInGroupForOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelfHostedRunnersInGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set self-hosted runners in a group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Replaces the list of self-hosted runners that are part of an organization runner group.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_self_hosted_runners_in_group_for_org](https://docs.github.com/rest/reference/actions#set-self-hosted-runners-in-a-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_self_hosted_runners_in_group_for_org(&self, org: &str, runner_group_id: i32, body: PutActionsSetSelfHostedRunnersInGroupForOrg) -> Result<(), ActionsSetSelfHostedRunnersInGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetSelfHostedRunnersInGroupForOrg::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsSetSelfHostedRunnersInGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Updates the `name` and `visibility` of a self-hosted runner group in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#update-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    pub async fn update_self_hosted_runner_group_for_org_async(&self, org: &str, runner_group_id: i32, body: PatchActionsUpdateSelfHostedRunnerGroupForOrg) -> Result<RunnerGroupsOrg, ActionsUpdateSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchActionsUpdateSelfHostedRunnerGroupForOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsUpdateSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a self-hosted runner group for an organization
    ///
    /// The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
    /// 
    /// Updates the `name` and `visibility` of a self-hosted runner group in an organization.
    /// 
    /// You must authenticate using an access token with the `admin:org` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_self_hosted_runner_group_for_org](https://docs.github.com/rest/reference/actions#update-a-self-hosted-runner-group-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_self_hosted_runner_group_for_org(&self, org: &str, runner_group_id: i32, body: PatchActionsUpdateSelfHostedRunnerGroupForOrg) -> Result<RunnerGroupsOrg, ActionsUpdateSelfHostedRunnerGroupForOrgError> {

        let request_uri = format!("{}/orgs/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, org, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchActionsUpdateSelfHostedRunnerGroupForOrg::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActionsUpdateSelfHostedRunnerGroupForOrgError::Generic { code }),
            }
        }
    }

}
