//! Method, error and parameter types for the Search endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Search<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Search {
    Search { auth }
}

/// Errors for the [Search code](Search::code_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchCodeError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search commits](Search::commits_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchCommitsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search issues and pull requests](Search::issues_and_pull_requests_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchIssuesAndPullRequestsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search labels](Search::labels_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchLabelsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search repositories](Search::repos_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchReposError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search topics](Search::topics_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchTopicsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Preview header missing")]
    Status415(GetProjectsListForUserResponse415),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Search users](Search::users_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum SearchUsersError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Search code](Search::code_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchCodeParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching code](https://help.github.com/articles/searching-code/)\" for a detailed list of qualifiers.
    q: &'req str, 
    /// Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchCodeParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching code](https://help.github.com/articles/searching-code/)\" for a detailed list of qualifiers.
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchCodeParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search commits](Search::commits_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchCommitsParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching commits](https://help.github.com/articles/searching-commits/)\" for a detailed list of qualifiers.
    q: &'req str, 
    /// Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchCommitsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching commits](https://help.github.com/articles/searching-commits/)\" for a detailed list of qualifiers.
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchCommitsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search issues and pull requests](Search::issues_and_pull_requests_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchIssuesAndPullRequestsParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)\" for a detailed list of qualifiers.
    q: &'req str, 
    /// Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchIssuesAndPullRequestsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)\" for a detailed list of qualifiers.
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchIssuesAndPullRequestsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search labels](Search::labels_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchLabelsParams<'req> {
    /// The id of the repository.
    repository_id: i32, 
    /// The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
    q: &'req str, 
    /// Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchLabelsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The id of the repository.
    pub fn repository_id(self, repository_id: i32) -> Self {
        Self { 
            repository_id: repository_id,
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            repository_id: self.repository_id, 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            repository_id: self.repository_id, 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            repository_id: self.repository_id, 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            repository_id: self.repository_id, 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            repository_id: self.repository_id, 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchLabelsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search repositories](Search::repos_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchReposParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)\" for a detailed list of qualifiers.
    q: &'req str, 
    /// Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchReposParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)\" for a detailed list of qualifiers.
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchReposParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search topics](Search::topics_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchTopicsParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
    q: &'req str, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchTopicsParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchTopicsParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Search users](Search::users_async()) endpoint.
#[derive(Default, Serialize)]
pub struct SearchUsersParams<'req> {
    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching users](https://help.github.com/articles/searching-users/)\" for a detailed list of qualifiers.
    q: &'req str, 
    /// Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    sort: Option<&'req str>, 
    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    order: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> SearchUsersParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See \"[Searching users](https://help.github.com/articles/searching-users/)\" for a detailed list of qualifiers.
    pub fn q(self, q: &'req str) -> Self {
        Self { 
            q: q,
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: Some(sort),
            order: self.order, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: Some(order),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            q: self.q, 
            sort: self.sort, 
            order: self.order, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for SearchUsersParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Search<'api> {
    /// ---
    ///
    /// # Search code
    ///
    /// Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
    /// 
    /// `q=addClass+in:file+language:js+repo:jquery/jquery`
    /// 
    /// This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
    /// 
    /// #### Considerations for code search
    /// 
    /// Due to the complexity of searching code, there are a few restrictions on how searches are performed:
    /// 
    /// *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
    /// *   Only files smaller than 384 KB are searchable.
    /// *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
    /// language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
    /// 
    /// [GitHub API docs for code](https://docs.github.com/rest/reference/search#search-code)
    ///
    /// ---
    pub async fn code_async(&self, query_params: impl Into<SearchCodeParams<'api>>) -> Result<GetSearchCodeResponse200, SearchCodeError> {

        let mut request_uri = format!("{}/search/code", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchCodeError::Status304),
                503 => Err(SearchCodeError::Status503(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(SearchCodeError::Status422(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(SearchCodeError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchCodeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search code
    ///
    /// Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
    /// 
    /// `q=addClass+in:file+language:js+repo:jquery/jquery`
    /// 
    /// This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
    /// 
    /// #### Considerations for code search
    /// 
    /// Due to the complexity of searching code, there are a few restrictions on how searches are performed:
    /// 
    /// *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
    /// *   Only files smaller than 384 KB are searchable.
    /// *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
    /// language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
    /// 
    /// [GitHub API docs for code](https://docs.github.com/rest/reference/search#search-code)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn code(&self, query_params: impl Into<SearchCodeParams<'api>>) -> Result<GetSearchCodeResponse200, SearchCodeError> {

        let mut request_uri = format!("{}/search/code", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchCodeParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchCodeError::Status304),
                503 => Err(SearchCodeError::Status503(crate::adapters::to_json(github_response)?)),
                422 => Err(SearchCodeError::Status422(crate::adapters::to_json(github_response)?)),
                403 => Err(SearchCodeError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(SearchCodeError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search commits
    ///
    /// Find commits via various criteria on the default branch (usually `master`). This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
    /// metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
    /// 
    /// `q=repo:octocat/Spoon-Knife+css`
    /// 
    /// [GitHub API docs for commits](https://docs.github.com/rest/reference/search#search-commits)
    ///
    /// The `commits_async` endpoint is enabled with the `cloak` cargo feature.
    ///
    /// ---
    #[cfg(feature = "cloak")]
    pub async fn commits_async(&self, query_params: impl Into<SearchCommitsParams<'api>>) -> Result<GetSearchCommitsResponse200, SearchCommitsError> {

        let mut request_uri = format!("{}/search/commits", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.cloak-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchCommitsError::Status304),
                415 => Err(SearchCommitsError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search commits
    ///
    /// Find commits via various criteria on the default branch (usually `master`). This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
    /// metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
    /// 
    /// `q=repo:octocat/Spoon-Knife+css`
    /// 
    /// [GitHub API docs for commits](https://docs.github.com/rest/reference/search#search-commits)
    ///
    /// The `commits` endpoint is enabled with the `cloak` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "cloak")]
    pub fn commits(&self, query_params: impl Into<SearchCommitsParams<'api>>) -> Result<GetSearchCommitsResponse200, SearchCommitsError> {

        let mut request_uri = format!("{}/search/commits", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchCommitsParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.cloak-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchCommitsError::Status304),
                415 => Err(SearchCommitsError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(SearchCommitsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search issues and pull requests
    ///
    /// Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
    /// search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
    /// 
    /// `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
    /// 
    /// This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
    /// 
    /// **Note:** For [user-to-server](https://docs.github.com/developers/apps/identifying-and-authorizing-users-for-github-apps#user-to-server-requests) GitHub App requests, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
    /// 
    /// [GitHub API docs for issues_and_pull_requests](https://docs.github.com/rest/reference/search#search-issues-and-pull-requests)
    ///
    /// ---
    pub async fn issues_and_pull_requests_async(&self, query_params: impl Into<SearchIssuesAndPullRequestsParams<'api>>) -> Result<GetSearchIssuesAndPullRequestsResponse200, SearchIssuesAndPullRequestsError> {

        let mut request_uri = format!("{}/search/issues", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                503 => Err(SearchIssuesAndPullRequestsError::Status503(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(SearchIssuesAndPullRequestsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(SearchIssuesAndPullRequestsError::Status304),
                403 => Err(SearchIssuesAndPullRequestsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchIssuesAndPullRequestsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search issues and pull requests
    ///
    /// Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
    /// search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
    /// 
    /// `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
    /// 
    /// This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
    /// 
    /// **Note:** For [user-to-server](https://docs.github.com/developers/apps/identifying-and-authorizing-users-for-github-apps#user-to-server-requests) GitHub App requests, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
    /// 
    /// [GitHub API docs for issues_and_pull_requests](https://docs.github.com/rest/reference/search#search-issues-and-pull-requests)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn issues_and_pull_requests(&self, query_params: impl Into<SearchIssuesAndPullRequestsParams<'api>>) -> Result<GetSearchIssuesAndPullRequestsResponse200, SearchIssuesAndPullRequestsError> {

        let mut request_uri = format!("{}/search/issues", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchIssuesAndPullRequestsParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                503 => Err(SearchIssuesAndPullRequestsError::Status503(crate::adapters::to_json(github_response)?)),
                422 => Err(SearchIssuesAndPullRequestsError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(SearchIssuesAndPullRequestsError::Status304),
                403 => Err(SearchIssuesAndPullRequestsError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(SearchIssuesAndPullRequestsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search labels
    ///
    /// Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
    /// 
    /// `q=bug+defect+enhancement&repository_id=64778136`
    /// 
    /// The labels that best match the query appear first in the search results.
    /// 
    /// [GitHub API docs for labels](https://docs.github.com/rest/reference/search#search-labels)
    ///
    /// ---
    pub async fn labels_async(&self, query_params: impl Into<SearchLabelsParams<'api>>) -> Result<GetSearchLabelsResponse200, SearchLabelsError> {

        let mut request_uri = format!("{}/search/labels", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchLabelsError::Status304),
                404 => Err(SearchLabelsError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(SearchLabelsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(SearchLabelsError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search labels
    ///
    /// Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
    /// 
    /// `q=bug+defect+enhancement&repository_id=64778136`
    /// 
    /// The labels that best match the query appear first in the search results.
    /// 
    /// [GitHub API docs for labels](https://docs.github.com/rest/reference/search#search-labels)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn labels(&self, query_params: impl Into<SearchLabelsParams<'api>>) -> Result<GetSearchLabelsResponse200, SearchLabelsError> {

        let mut request_uri = format!("{}/search/labels", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchLabelsParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchLabelsError::Status304),
                404 => Err(SearchLabelsError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(SearchLabelsError::Status403(crate::adapters::to_json(github_response)?)),
                422 => Err(SearchLabelsError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(SearchLabelsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search repositories
    ///
    /// Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
    /// 
    /// `q=tetris+language:assembly&sort=stars&order=desc`
    /// 
    /// This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
    /// 
    /// When you include the `mercy` preview header, you can also search for multiple topics by adding more `topic:` instances. For example, your query might look like this:
    /// 
    /// `q=topic:ruby+topic:rails`
    /// 
    /// [GitHub API docs for repos](https://docs.github.com/rest/reference/search#search-repositories)
    ///
    /// The `repos_async` endpoint is enabled with the `mercy` cargo feature.
    ///
    /// ---
    #[cfg(feature = "mercy")]
    pub async fn repos_async(&self, query_params: impl Into<SearchReposParams<'api>>) -> Result<GetSearchReposResponse200, SearchReposError> {

        let mut request_uri = format!("{}/search/repositories", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mercy-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                503 => Err(SearchReposError::Status503(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(SearchReposError::Status422(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(SearchReposError::Status304),
                code => Err(SearchReposError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search repositories
    ///
    /// Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
    /// 
    /// `q=tetris+language:assembly&sort=stars&order=desc`
    /// 
    /// This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
    /// 
    /// When you include the `mercy` preview header, you can also search for multiple topics by adding more `topic:` instances. For example, your query might look like this:
    /// 
    /// `q=topic:ruby+topic:rails`
    /// 
    /// [GitHub API docs for repos](https://docs.github.com/rest/reference/search#search-repositories)
    ///
    /// The `repos` endpoint is enabled with the `mercy` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "mercy")]
    pub fn repos(&self, query_params: impl Into<SearchReposParams<'api>>) -> Result<GetSearchReposResponse200, SearchReposError> {

        let mut request_uri = format!("{}/search/repositories", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchReposParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mercy-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                503 => Err(SearchReposError::Status503(crate::adapters::to_json(github_response)?)),
                422 => Err(SearchReposError::Status422(crate::adapters::to_json(github_response)?)),
                304 => Err(SearchReposError::Status304),
                code => Err(SearchReposError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search topics
    ///
    /// Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination). See "[Searching topics](https://help.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
    /// 
    /// When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
    /// 
    /// `q=ruby+is:featured`
    /// 
    /// This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
    /// 
    /// [GitHub API docs for topics](https://docs.github.com/rest/reference/search#search-topics)
    ///
    /// The `topics_async` endpoint is enabled with the `mercy` cargo feature.
    ///
    /// ---
    #[cfg(feature = "mercy")]
    pub async fn topics_async(&self, query_params: impl Into<SearchTopicsParams<'api>>) -> Result<GetSearchTopicsResponse200, SearchTopicsError> {

        let mut request_uri = format!("{}/search/topics", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mercy-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchTopicsError::Status304),
                415 => Err(SearchTopicsError::Status415(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search topics
    ///
    /// Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination). See "[Searching topics](https://help.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
    /// 
    /// When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
    /// 
    /// `q=ruby+is:featured`
    /// 
    /// This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
    /// 
    /// [GitHub API docs for topics](https://docs.github.com/rest/reference/search#search-topics)
    ///
    /// The `topics` endpoint is enabled with the `mercy` cargo feature.
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    #[cfg(feature = "mercy")]
    pub fn topics(&self, query_params: impl Into<SearchTopicsParams<'api>>) -> Result<GetSearchTopicsResponse200, SearchTopicsError> {

        let mut request_uri = format!("{}/search/topics", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchTopicsParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![("Accept", "application/vnd.github.mercy-preview+json"), ]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchTopicsError::Status304),
                415 => Err(SearchTopicsError::Status415(crate::adapters::to_json(github_response)?)),
                code => Err(SearchTopicsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search users
    ///
    /// Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for users, you can get text match metadata for the issue **login**, **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you're looking for a list of popular users, you might try this query:
    /// 
    /// `q=tom+repos:%3E42+followers:%3E1000`
    /// 
    /// This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
    /// 
    /// [GitHub API docs for users](https://docs.github.com/rest/reference/search#search-users)
    ///
    /// ---
    pub async fn users_async(&self, query_params: impl Into<SearchUsersParams<'api>>) -> Result<GetSearchUsersResponse200, SearchUsersError> {

        let mut request_uri = format!("{}/search/users", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        request_uri.push_str(&serde_urlencoded::to_string(query_params.into())?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchUsersError::Status304),
                503 => Err(SearchUsersError::Status503(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(SearchUsersError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(SearchUsersError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Search users
    ///
    /// Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
    /// 
    /// When searching for users, you can get text match metadata for the issue **login**, **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
    /// 
    /// For example, if you're looking for a list of popular users, you might try this query:
    /// 
    /// `q=tom+repos:%3E42+followers:%3E1000`
    /// 
    /// This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
    /// 
    /// [GitHub API docs for users](https://docs.github.com/rest/reference/search#search-users)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn users(&self, query_params: impl Into<SearchUsersParams<'api>>) -> Result<GetSearchUsersResponse200, SearchUsersError> {

        let mut request_uri = format!("{}/search/users", super::GITHUB_BASE_API_URL);

        request_uri.push_str("?");
        let qp: SearchUsersParams = query_params.into();
        request_uri.push_str(&serde_urlencoded::to_string(qp)?);

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(SearchUsersError::Status304),
                503 => Err(SearchUsersError::Status503(crate::adapters::to_json(github_response)?)),
                422 => Err(SearchUsersError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(SearchUsersError::Generic { code }),
            }
        }
    }

}
