//! Method, error and parameter types for the Scim endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Scim<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Scim {
    Scim { auth }
}

/// Errors for the [Delete a SCIM user from an organization](Scim::delete_user_from_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimDeleteUserFromOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get SCIM provisioning information for a user](Scim::get_provisioning_information_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimGetProvisioningInformationForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List SCIM provisioned identities](Scim::list_provisioned_identities_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimListProvisionedIdentitiesError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Bad Request")]
    Status400(ScimError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Provision and invite a SCIM user](Scim::provision_and_invite_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimProvisionAndInviteUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Internal Error")]
    Status500(ScimError),
    #[error("Conflict")]
    Status409(ScimError),
    #[error("Bad Request")]
    Status400(ScimError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a provisioned organization membership](Scim::set_information_for_provisioned_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimSetInformationForProvisionedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an attribute for a SCIM user](Scim::update_attribute_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ScimUpdateAttributeForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Resource not found")]
    Status404(ScimError),
    #[error("Forbidden")]
    Status403(ScimError),
    #[error("Bad Request")]
    Status400(ScimError),
    #[error("Response")]
    Status429(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List SCIM provisioned identities](Scim::list_provisioned_identities_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ScimListProvisionedIdentitiesParams<'req> {
    /// Used for pagination: the index of the first result to return.
    start_index: Option<i32>, 
    /// Used for pagination: the number of results to return.
    count: Option<i32>, 
    /// Filters results using the equals query parameter operator (`eq`). You can filter results that are equal to `id`, `userName`, `emails`, and `external_id`. For example, to search for an identity with the `userName` Octocat, you would use this query:  `?filter=userName%20eq%20\\\"Octocat\\\"`.  To filter results for the identity with the email `octocat@github.com`, you would use this query:  `?filter=emails%20eq%20\\\"octocat@github.com\\\"`.
    filter: Option<&'req str>
}

impl<'req> ScimListProvisionedIdentitiesParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Used for pagination: the index of the first result to return.
    pub fn start_index(self, start_index: i32) -> Self {
        Self { 
            start_index: Some(start_index),
            count: self.count, 
            filter: self.filter, 
        }
    }

    /// Used for pagination: the number of results to return.
    pub fn count(self, count: i32) -> Self {
        Self { 
            start_index: self.start_index, 
            count: Some(count),
            filter: self.filter, 
        }
    }

    /// Filters results using the equals query parameter operator (`eq`). You can filter results that are equal to `id`, `userName`, `emails`, and `external_id`. For example, to search for an identity with the `userName` Octocat, you would use this query:  `?filter=userName%20eq%20\\\"Octocat\\\"`.  To filter results for the identity with the email `octocat@github.com`, you would use this query:  `?filter=emails%20eq%20\\\"octocat@github.com\\\"`.
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            start_index: self.start_index, 
            count: self.count, 
            filter: Some(filter),
        }
    }
}


impl<'api> Scim<'api> {
    /// ---
    ///
    /// # Delete a SCIM user from an organization
    /// 
    /// [GitHub API docs for delete_user_from_org](https://docs.github.com/rest/reference/scim#delete-a-scim-user-from-an-organization)
    ///
    /// ---
    pub async fn delete_user_from_org_async(&self, org: &str, scim_user_id: &str) -> Result<(), ScimDeleteUserFromOrgError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ScimDeleteUserFromOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimDeleteUserFromOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ScimDeleteUserFromOrgError::Status304),
                code => Err(ScimDeleteUserFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a SCIM user from an organization
    /// 
    /// [GitHub API docs for delete_user_from_org](https://docs.github.com/rest/reference/scim#delete-a-scim-user-from-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_user_from_org(&self, org: &str, scim_user_id: &str) -> Result<(), ScimDeleteUserFromOrgError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ScimDeleteUserFromOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimDeleteUserFromOrgError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(ScimDeleteUserFromOrgError::Status304),
                code => Err(ScimDeleteUserFromOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for a user
    /// 
    /// [GitHub API docs for get_provisioning_information_for_user](https://docs.github.com/rest/reference/scim#get-scim-provisioning-information-for-a-user)
    ///
    /// ---
    pub async fn get_provisioning_information_for_user_async(&self, org: &str, scim_user_id: &str) -> Result<ScimUser, ScimGetProvisioningInformationForUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ScimGetProvisioningInformationForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimGetProvisioningInformationForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ScimGetProvisioningInformationForUserError::Status304),
                code => Err(ScimGetProvisioningInformationForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for a user
    /// 
    /// [GitHub API docs for get_provisioning_information_for_user](https://docs.github.com/rest/reference/scim#get-scim-provisioning-information-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_provisioning_information_for_user(&self, org: &str, scim_user_id: &str) -> Result<ScimUser, ScimGetProvisioningInformationForUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ScimGetProvisioningInformationForUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimGetProvisioningInformationForUserError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(ScimGetProvisioningInformationForUserError::Status304),
                code => Err(ScimGetProvisioningInformationForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SCIM provisioned identities
    ///
    /// Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.
    /// 
    /// When a user with a SAML-provisioned external identity leaves (or is removed from) an organization, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
    ///   - When a user with a SCIM-provisioned external identity is removed from an organization, the account's metadata is preserved to allow the user to re-join the organization in the future.
    ///   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
    ///   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
    /// 
    /// The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
    /// 
    /// 1. The user is granted access by the IdP and is not a member of the GitHub organization.
    /// 
    /// 1. The user attempts to access the GitHub organization and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
    /// 
    /// 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
    ///    - If the user signs in, their GitHub account is linked to this entry.
    ///    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub organization, and the external identity `null` entry remains in place.
    /// 
    /// [GitHub API docs for list_provisioned_identities](https://docs.github.com/rest/reference/scim#list-scim-provisioned-identities)
    ///
    /// ---
    pub async fn list_provisioned_identities_async(&self, org: &str, query_params: Option<impl Into<ScimListProvisionedIdentitiesParams<'api>>>) -> Result<ScimUserList, ScimListProvisionedIdentitiesError> {

        let mut request_uri = format!("{}/scim/v2/organizations/{}/Users", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimListProvisionedIdentitiesError::Status304),
                404 => Err(ScimListProvisionedIdentitiesError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimListProvisionedIdentitiesError::Status403(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ScimListProvisionedIdentitiesError::Status400(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ScimListProvisionedIdentitiesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SCIM provisioned identities
    ///
    /// Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.
    /// 
    /// When a user with a SAML-provisioned external identity leaves (or is removed from) an organization, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
    ///   - When a user with a SCIM-provisioned external identity is removed from an organization, the account's metadata is preserved to allow the user to re-join the organization in the future.
    ///   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
    ///   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
    /// 
    /// The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
    /// 
    /// 1. The user is granted access by the IdP and is not a member of the GitHub organization.
    /// 
    /// 1. The user attempts to access the GitHub organization and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
    /// 
    /// 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
    ///    - If the user signs in, their GitHub account is linked to this entry.
    ///    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub organization, and the external identity `null` entry remains in place.
    /// 
    /// [GitHub API docs for list_provisioned_identities](https://docs.github.com/rest/reference/scim#list-scim-provisioned-identities)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_provisioned_identities(&self, org: &str, query_params: Option<impl Into<ScimListProvisionedIdentitiesParams<'api>>>) -> Result<ScimUserList, ScimListProvisionedIdentitiesError> {

        let mut request_uri = format!("{}/scim/v2/organizations/{}/Users", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ScimListProvisionedIdentitiesParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimListProvisionedIdentitiesError::Status304),
                404 => Err(ScimListProvisionedIdentitiesError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimListProvisionedIdentitiesError::Status403(crate::adapters::to_json(github_response)?)),
                400 => Err(ScimListProvisionedIdentitiesError::Status400(crate::adapters::to_json(github_response)?)),
                code => Err(ScimListProvisionedIdentitiesError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision and invite a SCIM user
    ///
    /// Provision organization membership for a user, and send an activation email to the email address.
    /// 
    /// [GitHub API docs for provision_and_invite_user](https://docs.github.com/rest/reference/scim#provision-and-invite-a-scim-user)
    ///
    /// ---
    pub async fn provision_and_invite_user_async(&self, org: &str, body: PostScimProvisionAndInviteUser) -> Result<ScimUser, ScimProvisionAndInviteUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostScimProvisionAndInviteUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimProvisionAndInviteUserError::Status304),
                404 => Err(ScimProvisionAndInviteUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimProvisionAndInviteUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                500 => Err(ScimProvisionAndInviteUserError::Status500(crate::adapters::to_json_async(github_response).await?)),
                409 => Err(ScimProvisionAndInviteUserError::Status409(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ScimProvisionAndInviteUserError::Status400(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ScimProvisionAndInviteUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision and invite a SCIM user
    ///
    /// Provision organization membership for a user, and send an activation email to the email address.
    /// 
    /// [GitHub API docs for provision_and_invite_user](https://docs.github.com/rest/reference/scim#provision-and-invite-a-scim-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn provision_and_invite_user(&self, org: &str, body: PostScimProvisionAndInviteUser) -> Result<ScimUser, ScimProvisionAndInviteUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users", super::GITHUB_BASE_API_URL, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostScimProvisionAndInviteUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimProvisionAndInviteUserError::Status304),
                404 => Err(ScimProvisionAndInviteUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimProvisionAndInviteUserError::Status403(crate::adapters::to_json(github_response)?)),
                500 => Err(ScimProvisionAndInviteUserError::Status500(crate::adapters::to_json(github_response)?)),
                409 => Err(ScimProvisionAndInviteUserError::Status409(crate::adapters::to_json(github_response)?)),
                400 => Err(ScimProvisionAndInviteUserError::Status400(crate::adapters::to_json(github_response)?)),
                code => Err(ScimProvisionAndInviteUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a provisioned organization membership
    ///
    /// Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user) endpoint instead.
    /// 
    /// You must at least provide the required values for the user: `userName`, `name`, and `emails`.
    /// 
    /// **Warning:** Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_user](https://docs.github.com/rest/reference/scim#set-scim-information-for-a-provisioned-user)
    ///
    /// ---
    pub async fn set_information_for_provisioned_user_async(&self, org: &str, scim_user_id: &str, body: PutScimSetInformationForProvisionedUser) -> Result<ScimUser, ScimSetInformationForProvisionedUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutScimSetInformationForProvisionedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimSetInformationForProvisionedUserError::Status304),
                404 => Err(ScimSetInformationForProvisionedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimSetInformationForProvisionedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ScimSetInformationForProvisionedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a provisioned organization membership
    ///
    /// Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user) endpoint instead.
    /// 
    /// You must at least provide the required values for the user: `userName`, `name`, and `emails`.
    /// 
    /// **Warning:** Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_user](https://docs.github.com/rest/reference/scim#set-scim-information-for-a-provisioned-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_information_for_provisioned_user(&self, org: &str, scim_user_id: &str, body: PutScimSetInformationForProvisionedUser) -> Result<ScimUser, ScimSetInformationForProvisionedUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutScimSetInformationForProvisionedUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimSetInformationForProvisionedUserError::Status304),
                404 => Err(ScimSetInformationForProvisionedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimSetInformationForProvisionedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ScimSetInformationForProvisionedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM user
    ///
    /// Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
    /// 
    /// **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
    /// 
    /// ```nocompile
    /// {
    ///   "Operations":[{
    ///     "op":"replace",
    ///     "value":{
    ///       "active":false
    ///     }
    ///   }]
    /// }
    /// ```
    /// 
    /// [GitHub API docs for update_attribute_for_user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user)
    ///
    /// ---
    pub async fn update_attribute_for_user_async(&self, org: &str, scim_user_id: &str, body: PatchScimUpdateAttributeForUser) -> Result<ScimUser, ScimUpdateAttributeForUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchScimUpdateAttributeForUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimUpdateAttributeForUserError::Status304),
                404 => Err(ScimUpdateAttributeForUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ScimUpdateAttributeForUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                400 => Err(ScimUpdateAttributeForUserError::Status400(crate::adapters::to_json_async(github_response).await?)),
                429 => Err(ScimUpdateAttributeForUserError::Status429(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ScimUpdateAttributeForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM user
    ///
    /// Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
    /// 
    /// **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
    /// 
    /// ```nocompile
    /// {
    ///   "Operations":[{
    ///     "op":"replace",
    ///     "value":{
    ///       "active":false
    ///     }
    ///   }]
    /// }
    /// ```
    /// 
    /// [GitHub API docs for update_attribute_for_user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_attribute_for_user(&self, org: &str, scim_user_id: &str, body: PatchScimUpdateAttributeForUser) -> Result<ScimUser, ScimUpdateAttributeForUserError> {

        let request_uri = format!("{}/scim/v2/organizations/{}/Users/{}", super::GITHUB_BASE_API_URL, org, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchScimUpdateAttributeForUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ScimUpdateAttributeForUserError::Status304),
                404 => Err(ScimUpdateAttributeForUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ScimUpdateAttributeForUserError::Status403(crate::adapters::to_json(github_response)?)),
                400 => Err(ScimUpdateAttributeForUserError::Status400(crate::adapters::to_json(github_response)?)),
                429 => Err(ScimUpdateAttributeForUserError::Status429(crate::adapters::to_json(github_response)?)),
                code => Err(ScimUpdateAttributeForUserError::Generic { code }),
            }
        }
    }

}
