//! Method, error and parameter types for the Packages endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Packages<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Packages {
    Packages { auth }
}

/// Errors for the [Delete a package for the authenticated user](Packages::delete_package_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesDeletePackageForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a package for an organization](Packages::delete_package_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesDeletePackageForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a package version for the authenticated user](Packages::delete_package_version_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesDeletePackageVersionForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete package version for an organization](Packages::delete_package_version_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesDeletePackageVersionForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all package versions for a package owned by the authenticated user](Packages::get_all_package_versions_for_package_owned_by_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all package versions for a package owned by an organization](Packages::get_all_package_versions_for_package_owned_by_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetAllPackageVersionsForPackageOwnedByOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get all package versions for a package owned by a user](Packages::get_all_package_versions_for_package_owned_by_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetAllPackageVersionsForPackageOwnedByUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package for the authenticated user](Packages::get_package_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package for an organization](Packages::get_package_for_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageForOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package for a user](Packages::get_package_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package version for the authenticated user](Packages::get_package_version_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageVersionForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package version for an organization](Packages::get_package_version_for_organization_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageVersionForOrganizationError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a package version for a user](Packages::get_package_version_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesGetPackageVersionForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Restore a package for the authenticated user](Packages::restore_package_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesRestorePackageForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Restore a package for an organization](Packages::restore_package_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesRestorePackageForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Restore a package version for the authenticated user](Packages::restore_package_version_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesRestorePackageVersionForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Restore package version for an organization](Packages::restore_package_version_for_org_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum PackagesRestorePackageVersionForOrgError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get all package versions for a package owned by the authenticated user](Packages::get_all_package_versions_for_package_owned_by_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams<'req> {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// The state of the package, either active or deleted.
    state: Option<&'req str>
}

impl<'req> PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
            state: self.state, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
            state: self.state, 
        }
    }

    /// The state of the package, either active or deleted.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            page: self.page, 
            per_page: self.per_page, 
            state: Some(state),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get all package versions for a package owned by an organization](Packages::get_all_package_versions_for_package_owned_by_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PackagesGetAllPackageVersionsForPackageOwnedByOrgParams<'req> {
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// The state of the package, either active or deleted.
    state: Option<&'req str>
}

impl<'req> PackagesGetAllPackageVersionsForPackageOwnedByOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            page: Some(page),
            per_page: self.per_page, 
            state: self.state, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            page: self.page, 
            per_page: Some(per_page),
            state: self.state, 
        }
    }

    /// The state of the package, either active or deleted.
    pub fn state(self, state: &'req str) -> Self {
        Self { 
            page: self.page, 
            per_page: self.per_page, 
            state: Some(state),
        }
    }
}

impl<'enc> From<&'enc PerPage> for PackagesGetAllPackageVersionsForPackageOwnedByOrgParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Restore a package for the authenticated user](Packages::restore_package_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PackagesRestorePackageForAuthenticatedUserParams<'req> {
    /// package token
    token: Option<&'req str>
}

impl<'req> PackagesRestorePackageForAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// package token
    pub fn token(self, token: &'req str) -> Self {
        Self { 
            token: Some(token),
        }
    }
}

/// Query parameters for the [Restore a package for an organization](Packages::restore_package_for_org_async()) endpoint.
#[derive(Default, Serialize)]
pub struct PackagesRestorePackageForOrgParams<'req> {
    /// package token
    token: Option<&'req str>
}

impl<'req> PackagesRestorePackageForOrgParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// package token
    pub fn token(self, token: &'req str) -> Self {
        Self { 
            token: Some(token),
        }
    }
}


impl<'api> Packages<'api> {
    /// ---
    ///
    /// # Delete a package for the authenticated user
    ///
    /// Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:delete` scopes.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for delete_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#delete-a-package-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_package_for_authenticated_user_async(&self, package_type: &str, package_name: &str) -> Result<(), PackagesDeletePackageForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesDeletePackageForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesDeletePackageForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesDeletePackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a package for the authenticated user
    ///
    /// Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:delete` scopes.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for delete_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#delete-a-package-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_package_for_authenticated_user(&self, package_type: &str, package_name: &str) -> Result<(), PackagesDeletePackageForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesDeletePackageForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesDeletePackageForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesDeletePackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a package for an organization
    ///
    /// Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
    /// 
    /// [GitHub API docs for delete_package_for_org](https://docs.github.com/rest/reference/packages#delete-a-package-for-an-organization)
    ///
    /// ---
    pub async fn delete_package_for_org_async(&self, package_type: &str, package_name: &str, org: &str) -> Result<(), PackagesDeletePackageForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesDeletePackageForOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesDeletePackageForOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesDeletePackageForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a package for an organization
    ///
    /// Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
    /// 
    /// [GitHub API docs for delete_package_for_org](https://docs.github.com/rest/reference/packages#delete-a-package-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_package_for_org(&self, package_type: &str, package_name: &str, org: &str) -> Result<(), PackagesDeletePackageForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesDeletePackageForOrgError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesDeletePackageForOrgError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesDeletePackageForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a package version for the authenticated user
    ///
    /// Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for delete_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#delete-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    pub async fn delete_package_version_for_authenticated_user_async(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<(), PackagesDeletePackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a package version for the authenticated user
    ///
    /// Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for delete_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#delete-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_package_version_for_authenticated_user(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<(), PackagesDeletePackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesDeletePackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete package version for an organization
    ///
    /// Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
    /// 
    /// [GitHub API docs for delete_package_version_for_org](https://docs.github.com/rest/reference/packages#delete-a-package-version-for-an-organization)
    ///
    /// ---
    pub async fn delete_package_version_for_org_async(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<(), PackagesDeletePackageVersionForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageVersionForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesDeletePackageVersionForOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesDeletePackageVersionForOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesDeletePackageVersionForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete package version for an organization
    ///
    /// Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
    /// 
    /// [GitHub API docs for delete_package_version_for_org](https://docs.github.com/rest/reference/packages#delete-a-package-version-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_package_version_for_org(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<(), PackagesDeletePackageVersionForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesDeletePackageVersionForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesDeletePackageVersionForOrgError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesDeletePackageVersionForOrgError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesDeletePackageVersionForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by the authenticated user
    ///
    /// Returns all package versions for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_authenticated_user](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-the-authenticated-user)
    ///
    /// ---
    pub async fn get_all_package_versions_for_package_owned_by_authenticated_user_async(&self, package_type: &str, package_name: &str, query_params: Option<impl Into<PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams<'api>>>) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by the authenticated user
    ///
    /// Returns all package versions for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_authenticated_user](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_package_versions_for_package_owned_by_authenticated_user(&self, package_type: &str, package_name: &str, query_params: Option<impl Into<PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams<'api>>>) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by an organization
    ///
    /// Returns all package versions for a package owned by an organization.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_org](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-an-organization)
    ///
    /// ---
    pub async fn get_all_package_versions_for_package_owned_by_org_async(&self, package_type: &str, package_name: &str, org: &str, query_params: Option<impl Into<PackagesGetAllPackageVersionsForPackageOwnedByOrgParams<'api>>>) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByOrgError> {

        let mut request_uri = format!("{}/orgs/{}/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by an organization
    ///
    /// Returns all package versions for a package owned by an organization.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_org](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_package_versions_for_package_owned_by_org(&self, package_type: &str, package_name: &str, org: &str, query_params: Option<impl Into<PackagesGetAllPackageVersionsForPackageOwnedByOrgParams<'api>>>) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByOrgError> {

        let mut request_uri = format!("{}/orgs/{}/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PackagesGetAllPackageVersionsForPackageOwnedByOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by a user
    ///
    /// Returns all package versions for a public package owned by a specified user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_user](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-a-user)
    ///
    /// ---
    pub async fn get_all_package_versions_for_package_owned_by_user_async(&self, package_type: &str, package_name: &str, username: &str) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get all package versions for a package owned by a user
    ///
    /// Returns all package versions for a public package owned by a specified user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_all_package_versions_for_package_owned_by_user](https://docs.github.com/rest/reference/packages#get-all-package-versions-for-a-package-owned-by-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_all_package_versions_for_package_owned_by_user(&self, package_type: &str, package_name: &str, username: &str) -> Result<Vec<PackageVersion>, PackagesGetAllPackageVersionsForPackageOwnedByUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}/versions", super::GITHUB_BASE_API_URL, package_type, package_name, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesGetAllPackageVersionsForPackageOwnedByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for the authenticated user
    ///
    /// Gets a specific package for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#get-a-package-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_package_for_authenticated_user_async(&self, package_type: &str, package_name: &str) -> Result<Package, PackagesGetPackageForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for the authenticated user
    ///
    /// Gets a specific package for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#get-a-package-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_for_authenticated_user(&self, package_type: &str, package_name: &str) -> Result<Package, PackagesGetPackageForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for an organization
    ///
    /// Gets a specific package in an organization.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_organization](https://docs.github.com/rest/reference/packages#get-a-package-for-an-organization)
    ///
    /// ---
    pub async fn get_package_for_organization_async(&self, package_type: &str, package_name: &str, org: &str) -> Result<Package, PackagesGetPackageForOrganizationError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for an organization
    ///
    /// Gets a specific package in an organization.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_organization](https://docs.github.com/rest/reference/packages#get-a-package-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_for_organization(&self, package_type: &str, package_name: &str, org: &str) -> Result<Package, PackagesGetPackageForOrganizationError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for a user
    ///
    /// Gets a specific package metadata for a public package owned by a user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_user](https://docs.github.com/rest/reference/packages#get-a-package-for-a-user)
    ///
    /// ---
    pub async fn get_package_for_user_async(&self, package_type: &str, package_name: &str, username: &str) -> Result<Package, PackagesGetPackageForUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package for a user
    ///
    /// Gets a specific package metadata for a public package owned by a user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_for_user](https://docs.github.com/rest/reference/packages#get-a-package-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_for_user(&self, package_type: &str, package_name: &str, username: &str) -> Result<Package, PackagesGetPackageForUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}", super::GITHUB_BASE_API_URL, package_type, package_name, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for the authenticated user
    ///
    /// Gets a specific package version for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#get-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_package_version_for_authenticated_user_async(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<PackageVersion, PackagesGetPackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for the authenticated user
    ///
    /// Gets a specific package version for a package owned by the authenticated user.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#get-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_version_for_authenticated_user(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<PackageVersion, PackagesGetPackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for an organization
    ///
    /// Gets a specific package version in an organization.
    /// 
    /// You must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_organization](https://docs.github.com/rest/reference/packages#get-a-package-version-for-an-organization)
    ///
    /// ---
    pub async fn get_package_version_for_organization_async(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<PackageVersion, PackagesGetPackageVersionForOrganizationError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for an organization
    ///
    /// Gets a specific package version in an organization.
    /// 
    /// You must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_organization](https://docs.github.com/rest/reference/packages#get-a-package-version-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_version_for_organization(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<PackageVersion, PackagesGetPackageVersionForOrganizationError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForOrganizationError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for a user
    ///
    /// Gets a specific package version for a public package owned by a specified user.
    /// 
    /// At this time, to use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_user](https://docs.github.com/rest/reference/packages#get-a-package-version-for-a-user)
    ///
    /// ---
    pub async fn get_package_version_for_user_async(&self, package_type: &str, package_name: &str, package_version_id: i32, username: &str) -> Result<PackageVersion, PackagesGetPackageVersionForUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a package version for a user
    ///
    /// Gets a specific package version for a public package owned by a specified user.
    /// 
    /// At this time, to use this endpoint, you must authenticate using an access token with the `packages:read` scope.
    /// If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for get_package_version_for_user](https://docs.github.com/rest/reference/packages#get-a-package-version-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_package_version_for_user(&self, package_type: &str, package_name: &str, package_version_id: i32, username: &str) -> Result<PackageVersion, PackagesGetPackageVersionForUserError> {

        let request_uri = format!("{}/users/{}/packages/{}/{}/versions/{}", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id, username);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(PackagesGetPackageVersionForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package for the authenticated user
    ///
    /// Restores a package owned by the authenticated user.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for restore_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#restore-a-package-for-the-authenticated-user)
    ///
    /// ---
    pub async fn restore_package_for_authenticated_user_async(&self, package_type: &str, package_name: &str, query_params: Option<impl Into<PackagesRestorePackageForAuthenticatedUserParams<'api>>>) -> Result<(), PackagesRestorePackageForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/packages/{}/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesRestorePackageForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesRestorePackageForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesRestorePackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package for the authenticated user
    ///
    /// Restores a package owned by the authenticated user.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for restore_package_for_authenticated_user](https://docs.github.com/rest/reference/packages#restore-a-package-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn restore_package_for_authenticated_user(&self, package_type: &str, package_name: &str, query_params: Option<impl Into<PackagesRestorePackageForAuthenticatedUserParams<'api>>>) -> Result<(), PackagesRestorePackageForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/packages/{}/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PackagesRestorePackageForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesRestorePackageForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesRestorePackageForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesRestorePackageForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package for an organization
    ///
    /// Restores an entire package in an organization.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
    /// 
    /// [GitHub API docs for restore_package_for_org](https://docs.github.com/rest/reference/packages#restore-a-package-for-an-organization)
    ///
    /// ---
    pub async fn restore_package_for_org_async(&self, package_type: &str, package_name: &str, org: &str, query_params: Option<impl Into<PackagesRestorePackageForOrgParams<'api>>>) -> Result<(), PackagesRestorePackageForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/packages/{}/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesRestorePackageForOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesRestorePackageForOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesRestorePackageForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package for an organization
    ///
    /// Restores an entire package in an organization.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
    /// 
    /// [GitHub API docs for restore_package_for_org](https://docs.github.com/rest/reference/packages#restore-a-package-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn restore_package_for_org(&self, package_type: &str, package_name: &str, org: &str, query_params: Option<impl Into<PackagesRestorePackageForOrgParams<'api>>>) -> Result<(), PackagesRestorePackageForOrgError> {

        let mut request_uri = format!("{}/orgs/{}/packages/{}/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: PackagesRestorePackageForOrgParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesRestorePackageForOrgError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesRestorePackageForOrgError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesRestorePackageForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package version for the authenticated user
    ///
    /// Restores a package version owned by the authenticated user.
    /// 
    /// You can restore a deleted package version under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for restore_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#restore-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    pub async fn restore_package_version_for_authenticated_user_async(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<(), PackagesRestorePackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore a package version for the authenticated user
    ///
    /// Restores a package version owned by the authenticated user.
    /// 
    /// You can restore a deleted package version under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
    /// 
    /// [GitHub API docs for restore_package_version_for_authenticated_user](https://docs.github.com/rest/reference/packages#restore-a-package-version-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn restore_package_version_for_authenticated_user(&self, package_type: &str, package_name: &str, package_version_id: i32) -> Result<(), PackagesRestorePackageVersionForAuthenticatedUserError> {

        let request_uri = format!("{}/user/packages/{}/{}/versions/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesRestorePackageVersionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore package version for an organization
    ///
    /// Restores a specific package version in an organization.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
    /// 
    /// [GitHub API docs for restore_package_version_for_org](https://docs.github.com/rest/reference/packages#restore-a-package-version-for-an-organization)
    ///
    /// ---
    pub async fn restore_package_version_for_org_async(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<(), PackagesRestorePackageVersionForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageVersionForOrgError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(PackagesRestorePackageVersionForOrgError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(PackagesRestorePackageVersionForOrgError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(PackagesRestorePackageVersionForOrgError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Restore package version for an organization
    ///
    /// Restores a specific package version in an organization.
    /// 
    /// You can restore a deleted package under the following conditions:
    ///   - The package was deleted within the last 30 days.
    ///   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
    /// 
    /// To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
    /// - If `package_type` is not `container`, your token must also include the `repo` scope.
    /// - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
    /// 
    /// [GitHub API docs for restore_package_version_for_org](https://docs.github.com/rest/reference/packages#restore-a-package-version-for-an-organization)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn restore_package_version_for_org(&self, package_type: &str, package_name: &str, org: &str, package_version_id: i32) -> Result<(), PackagesRestorePackageVersionForOrgError> {

        let request_uri = format!("{}/orgs/{}/packages/{}/{}/versions/{}/restore", super::GITHUB_BASE_API_URL, package_type, package_name, org, package_version_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(PackagesRestorePackageVersionForOrgError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(PackagesRestorePackageVersionForOrgError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(PackagesRestorePackageVersionForOrgError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(PackagesRestorePackageVersionForOrgError::Generic { code }),
            }
        }
    }

}
