//! Method, error and parameter types for the EnterpriseAdmin endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct EnterpriseAdmin<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> EnterpriseAdmin {
    EnterpriseAdmin { auth }
}

/// Errors for the [Add organization access to a self-hosted runner group in an enterprise](EnterpriseAdmin::add_org_access_to_self_hosted_runner_group_in_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Add a self-hosted runner to a group for an enterprise](EnterpriseAdmin::add_self_hosted_runner_to_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminAddSelfHostedRunnerToGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a registration token for an enterprise](EnterpriseAdmin::create_registration_token_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminCreateRegistrationTokenForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a remove token for an enterprise](EnterpriseAdmin::create_remove_token_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminCreateRemoveTokenForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Create a self-hosted runner group for an enterprise](EnterpriseAdmin::create_self_hosted_runner_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a SCIM group from an enterprise](EnterpriseAdmin::delete_scim_group_from_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminDeleteScimGroupFromEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a self-hosted runner from an enterprise](EnterpriseAdmin::delete_self_hosted_runner_from_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a self-hosted runner group from an enterprise](EnterpriseAdmin::delete_self_hosted_runner_group_from_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a SCIM user from an enterprise](EnterpriseAdmin::delete_user_from_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminDeleteUserFromEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Disable a selected organization for GitHub Actions in an enterprise](EnterpriseAdmin::disable_selected_organization_github_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminDisableSelectedOrganizationGithubActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Enable a selected organization for GitHub Actions in an enterprise](EnterpriseAdmin::enable_selected_organization_github_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminEnableSelectedOrganizationGithubActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get allowed actions for an enterprise](EnterpriseAdmin::get_allowed_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetAllowedActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get the audit log for an enterprise](EnterpriseAdmin::get_audit_log_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetAuditLogError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get GitHub Actions permissions for an enterprise](EnterpriseAdmin::get_github_actions_permissions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetGithubActionsPermissionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get SCIM provisioning information for an enterprise group](EnterpriseAdmin::get_provisioning_information_for_enterprise_group_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetProvisioningInformationForEnterpriseGroupError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get SCIM provisioning information for an enterprise user](EnterpriseAdmin::get_provisioning_information_for_enterprise_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetProvisioningInformationForEnterpriseUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a self-hosted runner for an enterprise](EnterpriseAdmin::get_self_hosted_runner_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetSelfHostedRunnerForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a self-hosted runner group for an enterprise](EnterpriseAdmin::get_self_hosted_runner_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization access to a self-hosted runner group in an enterprise](EnterpriseAdmin::list_org_access_to_self_hosted_runner_group_in_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List provisioned SCIM groups for an enterprise](EnterpriseAdmin::list_provisioned_groups_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListProvisionedGroupsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List SCIM provisioned identities for an enterprise](EnterpriseAdmin::list_provisioned_identities_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListProvisionedIdentitiesEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List runner applications for an enterprise](EnterpriseAdmin::list_runner_applications_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListRunnerApplicationsForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List selected organizations enabled for GitHub Actions in an enterprise](EnterpriseAdmin::list_selected_organizations_enabled_github_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runner groups for an enterprise](EnterpriseAdmin::list_self_hosted_runner_groups_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runners for an enterprise](EnterpriseAdmin::list_self_hosted_runners_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListSelfHostedRunnersForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List self-hosted runners in a group for an enterprise](EnterpriseAdmin::list_self_hosted_runners_in_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Provision a SCIM enterprise group and invite users](EnterpriseAdmin::provision_and_invite_enterprise_group_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminProvisionAndInviteEnterpriseGroupError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Provision and invite a SCIM enterprise user](EnterpriseAdmin::provision_and_invite_enterprise_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminProvisionAndInviteEnterpriseUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove organization access to a self-hosted runner group in an enterprise](EnterpriseAdmin::remove_org_access_to_self_hosted_runner_group_in_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Remove a self-hosted runner from a group for an enterprise](EnterpriseAdmin::remove_self_hosted_runner_from_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set allowed actions for an enterprise](EnterpriseAdmin::set_allowed_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetAllowedActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set GitHub Actions permissions for an enterprise](EnterpriseAdmin::set_github_actions_permissions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetGithubActionsPermissionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set SCIM information for a provisioned enterprise group](EnterpriseAdmin::set_information_for_provisioned_enterprise_group_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetInformationForProvisionedEnterpriseGroupError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set SCIM information for a provisioned enterprise user](EnterpriseAdmin::set_information_for_provisioned_enterprise_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetInformationForProvisionedEnterpriseUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set organization access for a self-hosted runner group in an enterprise](EnterpriseAdmin::set_org_access_to_self_hosted_runner_group_in_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set selected organizations enabled for GitHub Actions in an enterprise](EnterpriseAdmin::set_selected_organizations_enabled_github_actions_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set self-hosted runners in a group for an enterprise](EnterpriseAdmin::set_self_hosted_runners_in_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminSetSelfHostedRunnersInGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an attribute for a SCIM enterprise group](EnterpriseAdmin::update_attribute_for_enterprise_group_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminUpdateAttributeForEnterpriseGroupError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update an attribute for a SCIM enterprise user](EnterpriseAdmin::update_attribute_for_enterprise_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminUpdateAttributeForEnterpriseUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Update a self-hosted runner group for an enterprise](EnterpriseAdmin::update_self_hosted_runner_group_for_enterprise_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [Get the audit log for an enterprise](EnterpriseAdmin::get_audit_log_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminGetAuditLogParams<'req> {
    /// A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log).
    phrase: Option<&'req str>, 
    /// The event types to include:  - `web` - returns web (non-Git) events - `git` - returns Git events - `all` - returns both web and Git events  The default is `web`.
    include: Option<&'req str>, 
    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.
    after: Option<&'req str>, 
    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor.
    before: Option<&'req str>, 
    /// The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.  The default is `desc`.
    order: Option<&'req str>, 
    /// Page number of the results to fetch.
    page: Option<u16>, 
    /// Results per page (max 100)
    per_page: Option<u16>
}

impl<'req> EnterpriseAdminGetAuditLogParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log).
    pub fn phrase(self, phrase: &'req str) -> Self {
        Self { 
            phrase: Some(phrase),
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// The event types to include:  - `web` - returns web (non-Git) events - `git` - returns Git events - `all` - returns both web and Git events  The default is `web`.
    pub fn include(self, include: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: Some(include),
            after: self.after, 
            before: self.before, 
            order: self.order, 
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.
    pub fn after(self, after: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: Some(after),
            before: self.before, 
            order: self.order, 
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor.
    pub fn before(self, before: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: Some(before),
            order: self.order, 
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.  The default is `desc`.
    pub fn order(self, order: &'req str) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: Some(order),
            page: self.page, 
            per_page: self.per_page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            page: Some(page),
            per_page: self.per_page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            phrase: self.phrase, 
            include: self.include, 
            after: self.after, 
            before: self.before, 
            order: self.order, 
            page: self.page, 
            per_page: Some(per_page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminGetAuditLogParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [Get SCIM provisioning information for an enterprise group](EnterpriseAdmin::get_provisioning_information_for_enterprise_group_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminGetProvisioningInformationForEnterpriseGroupParams<'req> {
    /// Attributes to exclude.
    excluded_attributes: Option<&'req str>
}

impl<'req> EnterpriseAdminGetProvisioningInformationForEnterpriseGroupParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Attributes to exclude.
    pub fn excluded_attributes(self, excluded_attributes: &'req str) -> Self {
        Self { 
            excluded_attributes: Some(excluded_attributes),
        }
    }
}

/// Query parameters for the [List organization access to a self-hosted runner group in an enterprise](EnterpriseAdmin::list_org_access_to_self_hosted_runner_group_in_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List provisioned SCIM groups for an enterprise](EnterpriseAdmin::list_provisioned_groups_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListProvisionedGroupsEnterpriseParams<'req> {
    /// Used for pagination: the index of the first result to return.
    start_index: Option<i32>, 
    /// Used for pagination: the number of results to return.
    count: Option<i32>, 
    /// filter results
    filter: Option<&'req str>, 
    /// attributes to exclude
    excluded_attributes: Option<&'req str>
}

impl<'req> EnterpriseAdminListProvisionedGroupsEnterpriseParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Used for pagination: the index of the first result to return.
    pub fn start_index(self, start_index: i32) -> Self {
        Self { 
            start_index: Some(start_index),
            count: self.count, 
            filter: self.filter, 
            excluded_attributes: self.excluded_attributes, 
        }
    }

    /// Used for pagination: the number of results to return.
    pub fn count(self, count: i32) -> Self {
        Self { 
            start_index: self.start_index, 
            count: Some(count),
            filter: self.filter, 
            excluded_attributes: self.excluded_attributes, 
        }
    }

    /// filter results
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            start_index: self.start_index, 
            count: self.count, 
            filter: Some(filter),
            excluded_attributes: self.excluded_attributes, 
        }
    }

    /// attributes to exclude
    pub fn excluded_attributes(self, excluded_attributes: &'req str) -> Self {
        Self { 
            start_index: self.start_index, 
            count: self.count, 
            filter: self.filter, 
            excluded_attributes: Some(excluded_attributes),
        }
    }
}

/// Query parameters for the [List SCIM provisioned identities for an enterprise](EnterpriseAdmin::list_provisioned_identities_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListProvisionedIdentitiesEnterpriseParams<'req> {
    /// Used for pagination: the index of the first result to return.
    start_index: Option<i32>, 
    /// Used for pagination: the number of results to return.
    count: Option<i32>, 
    /// filter results
    filter: Option<&'req str>
}

impl<'req> EnterpriseAdminListProvisionedIdentitiesEnterpriseParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// Used for pagination: the index of the first result to return.
    pub fn start_index(self, start_index: i32) -> Self {
        Self { 
            start_index: Some(start_index),
            count: self.count, 
            filter: self.filter, 
        }
    }

    /// Used for pagination: the number of results to return.
    pub fn count(self, count: i32) -> Self {
        Self { 
            start_index: self.start_index, 
            count: Some(count),
            filter: self.filter, 
        }
    }

    /// filter results
    pub fn filter(self, filter: &'req str) -> Self {
        Self { 
            start_index: self.start_index, 
            count: self.count, 
            filter: Some(filter),
        }
    }
}

/// Query parameters for the [List selected organizations enabled for GitHub Actions in an enterprise](EnterpriseAdmin::list_selected_organizations_enabled_github_actions_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runner groups for an enterprise](EnterpriseAdmin::list_self_hosted_runner_groups_for_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runners for an enterprise](EnterpriseAdmin::list_self_hosted_runners_for_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListSelfHostedRunnersForEnterpriseParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl EnterpriseAdminListSelfHostedRunnersForEnterpriseParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminListSelfHostedRunnersForEnterpriseParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List self-hosted runners in a group for an enterprise](EnterpriseAdmin::list_self_hosted_runners_in_group_for_enterprise_async()) endpoint.
#[derive(Default, Serialize)]
pub struct EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> EnterpriseAdmin<'api> {
    /// ---
    ///
    /// # Add organization access to a self-hosted runner group in an enterprise
    ///
    /// Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    pub async fn add_org_access_to_self_hosted_runner_group_in_enterprise_async(&self, enterprise: &str, runner_group_id: i32, org_id: i32) -> Result<(), EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add organization access to a self-hosted runner group in an enterprise
    ///
    /// Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_org_access_to_self_hosted_runner_group_in_enterprise(&self, enterprise: &str, runner_group_id: i32, org_id: i32) -> Result<(), EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminAddOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a self-hosted runner to a group for an enterprise
    ///
    /// Adds a self-hosted runner to a runner group configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_self_hosted_runner_to_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#add-a-self-hosted-runner-to-a-group-for-an-enterprise)
    ///
    /// ---
    pub async fn add_self_hosted_runner_to_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32, runner_id: i32) -> Result<(), EnterpriseAdminAddSelfHostedRunnerToGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminAddSelfHostedRunnerToGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Add a self-hosted runner to a group for an enterprise
    ///
    /// Adds a self-hosted runner to a runner group configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise`
    /// scope to use this endpoint.
    /// 
    /// [GitHub API docs for add_self_hosted_runner_to_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#add-a-self-hosted-runner-to-a-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn add_self_hosted_runner_to_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32, runner_id: i32) -> Result<(), EnterpriseAdminAddSelfHostedRunnerToGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminAddSelfHostedRunnerToGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for an enterprise
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    /// 
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-a-registration-token-for-an-enterprise)
    ///
    /// ---
    pub async fn create_registration_token_for_enterprise_async(&self, enterprise: &str) -> Result<AuthenticationToken, EnterpriseAdminCreateRegistrationTokenForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateRegistrationTokenForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a registration token for an enterprise
    ///
    /// Returns a token that you can pass to the `config` script. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// #### Example using registration token
    /// 
    /// Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_registration_token_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-a-registration-token-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_registration_token_for_enterprise(&self, enterprise: &str) -> Result<AuthenticationToken, EnterpriseAdminCreateRegistrationTokenForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/registration-token", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateRegistrationTokenForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for an enterprise
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    /// 
    /// To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
    /// endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-a-remove-token-for-an-enterprise)
    ///
    /// ---
    pub async fn create_remove_token_for_enterprise_async(&self, enterprise: &str) -> Result<AuthenticationToken, EnterpriseAdminCreateRemoveTokenForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateRemoveTokenForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a remove token for an enterprise
    ///
    /// Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// #### Example using remove token
    /// 
    /// To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
    /// endpoint.
    /// 
    /// ```nocompile
    /// ./config.sh remove --token TOKEN
    /// ```
    /// 
    /// [GitHub API docs for create_remove_token_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-a-remove-token-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_remove_token_for_enterprise(&self, enterprise: &str) -> Result<AuthenticationToken, EnterpriseAdminCreateRemoveTokenForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/remove-token", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateRemoveTokenForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a self-hosted runner group for an enterprise
    ///
    /// Creates a new self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    pub async fn create_self_hosted_runner_group_for_enterprise_async(&self, enterprise: &str, body: PostEnterpriseAdminCreateSelfHostedRunnerGroupForEnterprise) -> Result<RunnerGroupsEnterprise, EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminCreateSelfHostedRunnerGroupForEnterprise::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Create a self-hosted runner group for an enterprise
    ///
    /// Creates a new self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for create_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#create-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn create_self_hosted_runner_group_for_enterprise(&self, enterprise: &str, body: PostEnterpriseAdminCreateSelfHostedRunnerGroupForEnterprise) -> Result<RunnerGroupsEnterprise, EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminCreateSelfHostedRunnerGroupForEnterprise::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminCreateSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a SCIM group from an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for delete_scim_group_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-scim-group-from-an-enterprise)
    ///
    /// ---
    pub async fn delete_scim_group_from_enterprise_async(&self, enterprise: &str, scim_group_id: &str) -> Result<(), EnterpriseAdminDeleteScimGroupFromEnterpriseError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteScimGroupFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a SCIM group from an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for delete_scim_group_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-scim-group-from-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_scim_group_from_enterprise(&self, enterprise: &str, scim_group_id: &str) -> Result<(), EnterpriseAdminDeleteScimGroupFromEnterpriseError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteScimGroupFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from an enterprise
    ///
    /// Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-self-hosted-runner-from-an-enterprise)
    ///
    /// ---
    pub async fn delete_self_hosted_runner_from_enterprise_async(&self, enterprise: &str, runner_id: i32) -> Result<(), EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner from an enterprise
    ///
    /// Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-self-hosted-runner-from-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_self_hosted_runner_from_enterprise(&self, enterprise: &str, runner_id: i32) -> Result<(), EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteSelfHostedRunnerFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner group from an enterprise
    ///
    /// Deletes a self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_group_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-self-hosted-runner-group-from-an-enterprise)
    ///
    /// ---
    pub async fn delete_self_hosted_runner_group_from_enterprise_async(&self, enterprise: &str, runner_group_id: i32) -> Result<(), EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a self-hosted runner group from an enterprise
    ///
    /// Deletes a self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for delete_self_hosted_runner_group_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-self-hosted-runner-group-from-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_self_hosted_runner_group_from_enterprise(&self, enterprise: &str, runner_group_id: i32) -> Result<(), EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteSelfHostedRunnerGroupFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a SCIM user from an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for delete_user_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-scim-user-from-an-enterprise)
    ///
    /// ---
    pub async fn delete_user_from_enterprise_async(&self, enterprise: &str, scim_user_id: &str) -> Result<(), EnterpriseAdminDeleteUserFromEnterpriseError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteUserFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a SCIM user from an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for delete_user_from_enterprise](https://docs.github.com/rest/reference/enterprise-admin#delete-a-scim-user-from-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_user_from_enterprise(&self, enterprise: &str, scim_user_id: &str) -> Result<(), EnterpriseAdminDeleteUserFromEnterpriseError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDeleteUserFromEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a selected organization for GitHub Actions in an enterprise
    ///
    /// Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for disable_selected_organization_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#disable-a-selected-organization-for-github-actions-in-an-enterprise)
    ///
    /// ---
    pub async fn disable_selected_organization_github_actions_enterprise_async(&self, enterprise: &str, org_id: i32) -> Result<(), EnterpriseAdminDisableSelectedOrganizationGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDisableSelectedOrganizationGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Disable a selected organization for GitHub Actions in an enterprise
    ///
    /// Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for disable_selected_organization_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#disable-a-selected-organization-for-github-actions-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn disable_selected_organization_github_actions_enterprise(&self, enterprise: &str, org_id: i32) -> Result<(), EnterpriseAdminDisableSelectedOrganizationGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminDisableSelectedOrganizationGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a selected organization for GitHub Actions in an enterprise
    ///
    /// Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for enable_selected_organization_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#enable-a-selected-organization-for-github-actions-in-an-enterprise)
    ///
    /// ---
    pub async fn enable_selected_organization_github_actions_enterprise_async(&self, enterprise: &str, org_id: i32) -> Result<(), EnterpriseAdminEnableSelectedOrganizationGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminEnableSelectedOrganizationGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Enable a selected organization for GitHub Actions in an enterprise
    ///
    /// Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for enable_selected_organization_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#enable-a-selected-organization-for-github-actions-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn enable_selected_organization_github_actions_enterprise(&self, enterprise: &str, org_id: i32) -> Result<(), EnterpriseAdminEnableSelectedOrganizationGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminEnableSelectedOrganizationGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for an enterprise
    ///
    /// Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_allowed_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-allowed-actions-for-an-enterprise)
    ///
    /// ---
    pub async fn get_allowed_actions_enterprise_async(&self, enterprise: &str) -> Result<PutActionsSetAllowedActionsRepository, EnterpriseAdminGetAllowedActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetAllowedActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get allowed actions for an enterprise
    ///
    /// Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_allowed_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-allowed-actions-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_allowed_actions_enterprise(&self, enterprise: &str) -> Result<PutActionsSetAllowedActionsRepository, EnterpriseAdminGetAllowedActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetAllowedActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the audit log for an enterprise
    ///
    /// Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope.
    /// 
    /// [GitHub API docs for get_audit_log](https://docs.github.com/rest/reference/enterprise-admin#get-the-audit-log-for-an-enterprise)
    ///
    /// ---
    pub async fn get_audit_log_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminGetAuditLogParams<'api>>>) -> Result<Vec<AuditLogEvent>, EnterpriseAdminGetAuditLogError> {

        let mut request_uri = format!("{}/enterprises/{}/audit-log", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetAuditLogError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get the audit log for an enterprise
    ///
    /// Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope.
    /// 
    /// [GitHub API docs for get_audit_log](https://docs.github.com/rest/reference/enterprise-admin#get-the-audit-log-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_audit_log(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminGetAuditLogParams<'api>>>) -> Result<Vec<AuditLogEvent>, EnterpriseAdminGetAuditLogError> {

        let mut request_uri = format!("{}/enterprises/{}/audit-log", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminGetAuditLogParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetAuditLogError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for an enterprise
    ///
    /// Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-github-actions-permissions-for-an-enterprise)
    ///
    /// ---
    pub async fn get_github_actions_permissions_enterprise_async(&self, enterprise: &str) -> Result<ActionsEnterprisePermissions, EnterpriseAdminGetGithubActionsPermissionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetGithubActionsPermissionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get GitHub Actions permissions for an enterprise
    ///
    /// Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_github_actions_permissions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-github-actions-permissions-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_github_actions_permissions_enterprise(&self, enterprise: &str) -> Result<ActionsEnterprisePermissions, EnterpriseAdminGetGithubActionsPermissionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetGithubActionsPermissionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for an enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for get_provisioning_information_for_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise-group)
    ///
    /// ---
    pub async fn get_provisioning_information_for_enterprise_group_async(&self, enterprise: &str, scim_group_id: &str, query_params: Option<impl Into<EnterpriseAdminGetProvisioningInformationForEnterpriseGroupParams<'api>>>) -> Result<ScimEnterpriseGroup, EnterpriseAdminGetProvisioningInformationForEnterpriseGroupError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetProvisioningInformationForEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for an enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for get_provisioning_information_for_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise-group)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_provisioning_information_for_enterprise_group(&self, enterprise: &str, scim_group_id: &str, query_params: Option<impl Into<EnterpriseAdminGetProvisioningInformationForEnterpriseGroupParams<'api>>>) -> Result<ScimEnterpriseGroup, EnterpriseAdminGetProvisioningInformationForEnterpriseGroupError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminGetProvisioningInformationForEnterpriseGroupParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetProvisioningInformationForEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for an enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for get_provisioning_information_for_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise-user)
    ///
    /// ---
    pub async fn get_provisioning_information_for_enterprise_user_async(&self, enterprise: &str, scim_user_id: &str) -> Result<ScimEnterpriseUser, EnterpriseAdminGetProvisioningInformationForEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetProvisioningInformationForEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get SCIM provisioning information for an enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for get_provisioning_information_for_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#get-scim-provisioning-information-for-an-enterprise-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_provisioning_information_for_enterprise_user(&self, enterprise: &str, scim_user_id: &str) -> Result<ScimEnterpriseUser, EnterpriseAdminGetProvisioningInformationForEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetProvisioningInformationForEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for an enterprise
    ///
    /// Gets a specific self-hosted runner configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-a-self-hosted-runner-for-an-enterprise)
    ///
    /// ---
    pub async fn get_self_hosted_runner_for_enterprise_async(&self, enterprise: &str, runner_id: i32) -> Result<Runner, EnterpriseAdminGetSelfHostedRunnerForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetSelfHostedRunnerForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner for an enterprise
    ///
    /// Gets a specific self-hosted runner configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-a-self-hosted-runner-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_self_hosted_runner_for_enterprise(&self, enterprise: &str, runner_id: i32) -> Result<Runner, EnterpriseAdminGetSelfHostedRunnerForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetSelfHostedRunnerForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner group for an enterprise
    ///
    /// Gets a specific self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-a-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    pub async fn get_self_hosted_runner_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32) -> Result<RunnerGroupsEnterprise, EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a self-hosted runner group for an enterprise
    ///
    /// Gets a specific self-hosted runner group for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for get_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#get-a-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_self_hosted_runner_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32) -> Result<RunnerGroupsEnterprise, EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminGetSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization access to a self-hosted runner group in an enterprise
    ///
    /// Lists the organizations with access to a self-hosted runner group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-organization-access-to-a-self-hosted-runner-group-in-a-enterprise)
    ///
    /// ---
    pub async fn list_org_access_to_self_hosted_runner_group_in_enterprise_async(&self, enterprise: &str, runner_group_id: i32, query_params: Option<impl Into<EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams>>) -> Result<GetEnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponse200, EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization access to a self-hosted runner group in an enterprise
    ///
    /// Lists the organizations with access to a self-hosted runner group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-organization-access-to-a-self-hosted-runner-group-in-a-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_org_access_to_self_hosted_runner_group_in_enterprise(&self, enterprise: &str, runner_group_id: i32, query_params: Option<impl Into<EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams>>) -> Result<GetEnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponse200, EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List provisioned SCIM groups for an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for list_provisioned_groups_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-provisioned-scim-groups-for-an-enterprise)
    ///
    /// ---
    pub async fn list_provisioned_groups_enterprise_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListProvisionedGroupsEnterpriseParams<'api>>>) -> Result<ScimGroupListEnterprise, EnterpriseAdminListProvisionedGroupsEnterpriseError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Groups", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListProvisionedGroupsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List provisioned SCIM groups for an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// [GitHub API docs for list_provisioned_groups_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-provisioned-scim-groups-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_provisioned_groups_enterprise(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListProvisionedGroupsEnterpriseParams<'api>>>) -> Result<ScimGroupListEnterprise, EnterpriseAdminListProvisionedGroupsEnterpriseError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Groups", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListProvisionedGroupsEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListProvisionedGroupsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SCIM provisioned identities for an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Retrieves a paginated list of all provisioned enterprise members, including pending invitations.
    /// 
    /// When a user with a SAML-provisioned external identity leaves (or is removed from) an enterprise, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
    ///   - When a user with a SCIM-provisioned external identity is removed from an enterprise, the account's metadata is preserved to allow the user to re-join the organization in the future.
    ///   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
    ///   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
    /// 
    /// The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
    /// 
    /// 1. The user is granted access by the IdP and is not a member of the GitHub enterprise.
    /// 
    /// 1. The user attempts to access the GitHub enterprise and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
    /// 
    /// 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
    ///    - If the user signs in, their GitHub account is linked to this entry.
    ///    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub enterprise, and the external identity `null` entry remains in place.
    /// 
    /// [GitHub API docs for list_provisioned_identities_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-scim-provisioned-identities-for-an-enterprise)
    ///
    /// ---
    pub async fn list_provisioned_identities_enterprise_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListProvisionedIdentitiesEnterpriseParams<'api>>>) -> Result<ScimUserListEnterprise, EnterpriseAdminListProvisionedIdentitiesEnterpriseError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Users", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListProvisionedIdentitiesEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List SCIM provisioned identities for an enterprise
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Retrieves a paginated list of all provisioned enterprise members, including pending invitations.
    /// 
    /// When a user with a SAML-provisioned external identity leaves (or is removed from) an enterprise, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
    ///   - When a user with a SCIM-provisioned external identity is removed from an enterprise, the account's metadata is preserved to allow the user to re-join the organization in the future.
    ///   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
    ///   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
    /// 
    /// The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
    /// 
    /// 1. The user is granted access by the IdP and is not a member of the GitHub enterprise.
    /// 
    /// 1. The user attempts to access the GitHub enterprise and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
    /// 
    /// 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
    ///    - If the user signs in, their GitHub account is linked to this entry.
    ///    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub enterprise, and the external identity `null` entry remains in place.
    /// 
    /// [GitHub API docs for list_provisioned_identities_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-scim-provisioned-identities-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_provisioned_identities_enterprise(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListProvisionedIdentitiesEnterpriseParams<'api>>>) -> Result<ScimUserListEnterprise, EnterpriseAdminListProvisionedIdentitiesEnterpriseError> {

        let mut request_uri = format!("{}/scim/v2/enterprises/{}/Users", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListProvisionedIdentitiesEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListProvisionedIdentitiesEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for an enterprise
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-runner-applications-for-an-enterprise)
    ///
    /// ---
    pub async fn list_runner_applications_for_enterprise_async(&self, enterprise: &str) -> Result<Vec<RunnerApplication>, EnterpriseAdminListRunnerApplicationsForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListRunnerApplicationsForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List runner applications for an enterprise
    ///
    /// Lists binaries for the runner application that you can download and run.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_runner_applications_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-runner-applications-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_runner_applications_for_enterprise(&self, enterprise: &str) -> Result<Vec<RunnerApplication>, EnterpriseAdminListRunnerApplicationsForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runners/downloads", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListRunnerApplicationsForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected organizations enabled for GitHub Actions in an enterprise
    ///
    /// Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_selected_organizations_enabled_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-selected-organizations-enabled-for-github-actions-in-an-enterprise)
    ///
    /// ---
    pub async fn list_selected_organizations_enabled_github_actions_enterprise_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams>>) -> Result<GetEnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponse200, EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/permissions/organizations", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List selected organizations enabled for GitHub Actions in an enterprise
    ///
    /// Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_selected_organizations_enabled_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-selected-organizations-enabled-for-github-actions-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_selected_organizations_enabled_github_actions_enterprise(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams>>) -> Result<GetEnterpriseAdminListOrgAccessToSelfHostedRunnerGroupInEnterpriseResponse200, EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/permissions/organizations", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelectedOrganizationsEnabledGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runner groups for an enterprise
    ///
    /// Lists all self-hosted runner groups for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runner_groups_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runner-groups-for-an-enterprise)
    ///
    /// ---
    pub async fn list_self_hosted_runner_groups_for_enterprise_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams>>) -> Result<GetEnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseResponse200, EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runner groups for an enterprise
    ///
    /// Lists all self-hosted runner groups for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runner_groups_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runner-groups-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runner_groups_for_enterprise(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams>>) -> Result<GetEnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseResponse200, EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnerGroupsForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for an enterprise
    ///
    /// Lists all self-hosted runners configured for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runners-for-an-enterprise)
    ///
    /// ---
    pub async fn list_self_hosted_runners_for_enterprise_async(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnersForEnterpriseParams>>) -> Result<GetEnterpriseAdminListSelfHostedRunnersForEnterpriseResponse200, EnterpriseAdminListSelfHostedRunnersForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runners", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnersForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners for an enterprise
    ///
    /// Lists all self-hosted runners configured for an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runners-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runners_for_enterprise(&self, enterprise: &str, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnersForEnterpriseParams>>) -> Result<GetEnterpriseAdminListSelfHostedRunnersForEnterpriseResponse200, EnterpriseAdminListSelfHostedRunnersForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runners", super::GITHUB_BASE_API_URL, enterprise);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListSelfHostedRunnersForEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnersForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners in a group for an enterprise
    ///
    /// Lists the self-hosted runners that are in a specific enterprise group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_in_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runners-in-a-group-for-an-enterprise)
    ///
    /// ---
    pub async fn list_self_hosted_runners_in_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams>>) -> Result<GetActionsListSelfHostedRunnersInGroupForOrgResponse200, EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List self-hosted runners in a group for an enterprise
    ///
    /// Lists the self-hosted runners that are in a specific enterprise group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for list_self_hosted_runners_in_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#list-self-hosted-runners-in-a-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_self_hosted_runners_in_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32, query_params: Option<impl Into<EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams>>) -> Result<GetActionsListSelfHostedRunnersInGroupForOrgResponse200, EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseError> {

        let mut request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminListSelfHostedRunnersInGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision a SCIM enterprise group and invite users
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Provision an enterprise group, and invite users to the group. This sends invitation emails to the email address of the invited users to join the GitHub organization that the SCIM group corresponds to.
    /// 
    /// [GitHub API docs for provision_and_invite_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#provision-a-scim-enterprise-group-and-invite-users)
    ///
    /// ---
    pub async fn provision_and_invite_enterprise_group_async(&self, enterprise: &str, body: PostEnterpriseAdminProvisionAndInviteEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminProvisionAndInviteEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminProvisionAndInviteEnterpriseGroup::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminProvisionAndInviteEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision a SCIM enterprise group and invite users
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Provision an enterprise group, and invite users to the group. This sends invitation emails to the email address of the invited users to join the GitHub organization that the SCIM group corresponds to.
    /// 
    /// [GitHub API docs for provision_and_invite_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#provision-a-scim-enterprise-group-and-invite-users)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn provision_and_invite_enterprise_group(&self, enterprise: &str, body: PostEnterpriseAdminProvisionAndInviteEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminProvisionAndInviteEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminProvisionAndInviteEnterpriseGroup::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminProvisionAndInviteEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision and invite a SCIM enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Provision enterprise membership for a user, and send organization invitation emails to the email address.
    /// 
    /// You can optionally include the groups a user will be invited to join. If you do not provide a list of `groups`, the user is provisioned for the enterprise, but no organization invitation emails will be sent.
    /// 
    /// [GitHub API docs for provision_and_invite_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#provision-and-invite-a-scim-enterprise-user)
    ///
    /// ---
    pub async fn provision_and_invite_enterprise_user_async(&self, enterprise: &str, body: PostEnterpriseAdminProvisionAndInviteEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminProvisionAndInviteEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminProvisionAndInviteEnterpriseUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminProvisionAndInviteEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Provision and invite a SCIM enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Provision enterprise membership for a user, and send organization invitation emails to the email address.
    /// 
    /// You can optionally include the groups a user will be invited to join. If you do not provide a list of `groups`, the user is provisioned for the enterprise, but no organization invitation emails will be sent.
    /// 
    /// [GitHub API docs for provision_and_invite_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#provision-and-invite-a-scim-enterprise-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn provision_and_invite_enterprise_user(&self, enterprise: &str, body: PostEnterpriseAdminProvisionAndInviteEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminProvisionAndInviteEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PostEnterpriseAdminProvisionAndInviteEnterpriseUser::from_json(body)?),
            method: "POST",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminProvisionAndInviteEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove organization access to a self-hosted runner group in an enterprise
    ///
    /// Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    pub async fn remove_org_access_to_self_hosted_runner_group_in_enterprise_async(&self, enterprise: &str, runner_group_id: i32, org_id: i32) -> Result<(), EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove organization access to a self-hosted runner group in an enterprise
    ///
    /// Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_org_access_to_self_hosted_runner_group_in_enterprise(&self, enterprise: &str, runner_group_id: i32, org_id: i32) -> Result<(), EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, org_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminRemoveOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a self-hosted runner from a group for an enterprise
    ///
    /// Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_self_hosted_runner_from_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#remove-a-self-hosted-runner-from-a-group-for-an-enterprise)
    ///
    /// ---
    pub async fn remove_self_hosted_runner_from_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32, runner_id: i32) -> Result<(), EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Remove a self-hosted runner from a group for an enterprise
    ///
    /// Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for remove_self_hosted_runner_from_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#remove-a-self-hosted-runner-from-a-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn remove_self_hosted_runner_from_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32, runner_id: i32) -> Result<(), EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id, runner_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminRemoveSelfHostedRunnerFromGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for an enterprise
    ///
    /// Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_allowed_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-allowed-actions-for-an-enterprise)
    ///
    /// ---
    pub async fn set_allowed_actions_enterprise_async(&self, enterprise: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), EnterpriseAdminSetAllowedActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetAllowedActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set allowed actions for an enterprise
    ///
    /// Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_allowed_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-allowed-actions-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_allowed_actions_enterprise(&self, enterprise: &str, body: PutActionsSetAllowedActionsRepository) -> Result<(), EnterpriseAdminSetAllowedActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/selected-actions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActionsSetAllowedActionsRepository::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetAllowedActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for an enterprise
    ///
    /// Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-github-actions-permissions-for-an-enterprise)
    ///
    /// ---
    pub async fn set_github_actions_permissions_enterprise_async(&self, enterprise: &str, body: PutEnterpriseAdminSetGithubActionsPermissionsEnterprise) -> Result<(), EnterpriseAdminSetGithubActionsPermissionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetGithubActionsPermissionsEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetGithubActionsPermissionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set GitHub Actions permissions for an enterprise
    ///
    /// Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_github_actions_permissions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-github-actions-permissions-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_github_actions_permissions_enterprise(&self, enterprise: &str, body: PutEnterpriseAdminSetGithubActionsPermissionsEnterprise) -> Result<(), EnterpriseAdminSetGithubActionsPermissionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetGithubActionsPermissionsEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetGithubActionsPermissionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set SCIM information for a provisioned enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Replaces an existing provisioned group’s information. You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-group)
    ///
    /// ---
    pub async fn set_information_for_provisioned_enterprise_group_async(&self, enterprise: &str, scim_group_id: &str, body: PutEnterpriseAdminSetInformationForProvisionedEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminSetInformationForProvisionedEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetInformationForProvisionedEnterpriseGroup::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetInformationForProvisionedEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set SCIM information for a provisioned enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Replaces an existing provisioned group’s information. You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-group)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_information_for_provisioned_enterprise_group(&self, enterprise: &str, scim_group_id: &str, body: PutEnterpriseAdminSetInformationForProvisionedEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminSetInformationForProvisionedEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetInformationForProvisionedEnterpriseGroup::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetInformationForProvisionedEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set SCIM information for a provisioned enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](#update-an-attribute-for-an-enterprise-scim-user) endpoint instead.
    /// 
    /// You must at least provide the required values for the user: `userName`, `name`, and `emails`.
    /// 
    /// **Warning:** Setting `active: false` removes the user from the enterprise, deletes the external identity, and deletes the associated `{scim_user_id}`.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-user)
    ///
    /// ---
    pub async fn set_information_for_provisioned_enterprise_user_async(&self, enterprise: &str, scim_user_id: &str, body: PutEnterpriseAdminSetInformationForProvisionedEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminSetInformationForProvisionedEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetInformationForProvisionedEnterpriseUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetInformationForProvisionedEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set SCIM information for a provisioned enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](#update-an-attribute-for-an-enterprise-scim-user) endpoint instead.
    /// 
    /// You must at least provide the required values for the user: `userName`, `name`, and `emails`.
    /// 
    /// **Warning:** Setting `active: false` removes the user from the enterprise, deletes the external identity, and deletes the associated `{scim_user_id}`.
    /// 
    /// [GitHub API docs for set_information_for_provisioned_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#set-scim-information-for-a-provisioned-enterprise-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_information_for_provisioned_enterprise_user(&self, enterprise: &str, scim_user_id: &str, body: PutEnterpriseAdminSetInformationForProvisionedEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminSetInformationForProvisionedEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetInformationForProvisionedEnterpriseUser::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetInformationForProvisionedEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set organization access for a self-hosted runner group in an enterprise
    ///
    /// Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    pub async fn set_org_access_to_self_hosted_runner_group_in_enterprise_async(&self, enterprise: &str, runner_group_id: i32, body: PutEnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterprise) -> Result<(), EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set organization access for a self-hosted runner group in an enterprise
    ///
    /// Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_org_access_to_self_hosted_runner_group_in_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-organization-access-to-a-self-hosted-runner-group-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_org_access_to_self_hosted_runner_group_in_enterprise(&self, enterprise: &str, runner_group_id: i32, body: PutEnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterprise) -> Result<(), EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/organizations", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetOrgAccessToSelfHostedRunnerGroupInEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected organizations enabled for GitHub Actions in an enterprise
    ///
    /// Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_selected_organizations_enabled_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-selected-organizations-enabled-for-github-actions-in-an-enterprise)
    ///
    /// ---
    pub async fn set_selected_organizations_enabled_github_actions_enterprise_async(&self, enterprise: &str, body: PutEnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterprise) -> Result<(), EnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set selected organizations enabled for GitHub Actions in an enterprise
    ///
    /// Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_selected_organizations_enabled_github_actions_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-selected-organizations-enabled-for-github-actions-in-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_selected_organizations_enabled_github_actions_enterprise(&self, enterprise: &str, body: PutEnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterprise) -> Result<(), EnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/permissions/organizations", super::GITHUB_BASE_API_URL, enterprise);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetSelectedOrganizationsEnabledGithubActionsEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set self-hosted runners in a group for an enterprise
    ///
    /// Replaces the list of self-hosted runners that are part of an enterprise runner group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_self_hosted_runners_in_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-self-hosted-runners-in-a-group-for-an-enterprise)
    ///
    /// ---
    pub async fn set_self_hosted_runners_in_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32, body: PutEnterpriseAdminSetSelfHostedRunnersInGroupForEnterprise) -> Result<(), EnterpriseAdminSetSelfHostedRunnersInGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetSelfHostedRunnersInGroupForEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetSelfHostedRunnersInGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set self-hosted runners in a group for an enterprise
    ///
    /// Replaces the list of self-hosted runners that are part of an enterprise runner group.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for set_self_hosted_runners_in_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#set-self-hosted-runners-in-a-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_self_hosted_runners_in_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32, body: PutEnterpriseAdminSetSelfHostedRunnersInGroupForEnterprise) -> Result<(), EnterpriseAdminSetSelfHostedRunnersInGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}/runners", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutEnterpriseAdminSetSelfHostedRunnersInGroupForEnterprise::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminSetSelfHostedRunnersInGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Allows you to change a provisioned group’s individual attributes. To change a group’s values, you must provide a specific Operations JSON format that contains at least one of the add, remove, or replace operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// [GitHub API docs for update_attribute_for_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-group)
    ///
    /// ---
    pub async fn update_attribute_for_enterprise_group_async(&self, enterprise: &str, scim_group_id: &str, body: PatchEnterpriseAdminUpdateAttributeForEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminUpdateAttributeForEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateAttributeForEnterpriseGroup::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateAttributeForEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM enterprise group
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Allows you to change a provisioned group’s individual attributes. To change a group’s values, you must provide a specific Operations JSON format that contains at least one of the add, remove, or replace operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// [GitHub API docs for update_attribute_for_enterprise_group](https://docs.github.com/rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-group)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_attribute_for_enterprise_group(&self, enterprise: &str, scim_group_id: &str, body: PatchEnterpriseAdminUpdateAttributeForEnterpriseGroup) -> Result<ScimEnterpriseGroup, EnterpriseAdminUpdateAttributeForEnterpriseGroupError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Groups/{}", super::GITHUB_BASE_API_URL, enterprise, scim_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateAttributeForEnterpriseGroup::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateAttributeForEnterpriseGroupError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
    /// 
    /// **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the enterprise, deletes the external identity, and deletes the associated `:scim_user_id`.
    /// 
    /// ```nocompile
    /// {
    ///   "Operations":[{
    ///     "op":"replace",
    ///     "value":{
    ///       "active":false
    ///     }
    ///   }]
    /// }
    /// ```
    /// 
    /// [GitHub API docs for update_attribute_for_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-user)
    ///
    /// ---
    pub async fn update_attribute_for_enterprise_user_async(&self, enterprise: &str, scim_user_id: &str, body: PatchEnterpriseAdminUpdateAttributeForEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminUpdateAttributeForEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateAttributeForEnterpriseUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateAttributeForEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update an attribute for a SCIM enterprise user
    ///
    /// **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
    /// 
    /// Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
    /// 
    /// **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
    /// 
    /// **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the enterprise, deletes the external identity, and deletes the associated `:scim_user_id`.
    /// 
    /// ```nocompile
    /// {
    ///   "Operations":[{
    ///     "op":"replace",
    ///     "value":{
    ///       "active":false
    ///     }
    ///   }]
    /// }
    /// ```
    /// 
    /// [GitHub API docs for update_attribute_for_enterprise_user](https://docs.github.com/rest/reference/enterprise-admin#update-an-attribute-for-a-scim-enterprise-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_attribute_for_enterprise_user(&self, enterprise: &str, scim_user_id: &str, body: PatchEnterpriseAdminUpdateAttributeForEnterpriseUser) -> Result<ScimEnterpriseUser, EnterpriseAdminUpdateAttributeForEnterpriseUserError> {

        let request_uri = format!("{}/scim/v2/enterprises/{}/Users/{}", super::GITHUB_BASE_API_URL, enterprise, scim_user_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateAttributeForEnterpriseUser::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateAttributeForEnterpriseUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a self-hosted runner group for an enterprise
    ///
    /// Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#update-a-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    pub async fn update_self_hosted_runner_group_for_enterprise_async(&self, enterprise: &str, runner_group_id: i32, body: PatchEnterpriseAdminUpdateSelfHostedRunnerGroupForEnterprise) -> Result<RunnerGroupsEnterprise, EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateSelfHostedRunnerGroupForEnterprise::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Update a self-hosted runner group for an enterprise
    ///
    /// Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
    /// 
    /// You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
    /// 
    /// [GitHub API docs for update_self_hosted_runner_group_for_enterprise](https://docs.github.com/rest/reference/enterprise-admin#update-a-self-hosted-runner-group-for-an-enterprise)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn update_self_hosted_runner_group_for_enterprise(&self, enterprise: &str, runner_group_id: i32, body: PatchEnterpriseAdminUpdateSelfHostedRunnerGroupForEnterprise) -> Result<RunnerGroupsEnterprise, EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseError> {

        let request_uri = format!("{}/enterprises/{}/actions/runner-groups/{}", super::GITHUB_BASE_API_URL, enterprise, runner_group_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PatchEnterpriseAdminUpdateSelfHostedRunnerGroupForEnterprise::from_json(body)?),
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(EnterpriseAdminUpdateSelfHostedRunnerGroupForEnterpriseError::Generic { code }),
            }
        }
    }

}
