//! Method, error and parameter types for the Activity endpoint.
#![allow(
    unused_imports,
)]
/* 
 * GitHub v3 REST API
 *
 * GitHub's v3 REST API.
 *
 * OpenAPI spec version: 1.1.4
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use serde::Deserialize;

use crate::adapters::{AdapterError, FromJson, GitHubRequest, GitHubRequestBuilder, GitHubResponseExt};
use crate::auth::Auth;
use crate::models::*;

use super::PerPage;

use std::collections::HashMap;
use serde_json::value::Value;

pub struct Activity<'api> {
    auth: &'api Auth
}

pub fn new(auth: &Auth) -> Activity {
    Activity { auth }
}

/// Errors for the [Check if a repository is starred by the authenticated user](Activity::check_repo_is_starred_by_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityCheckRepoIsStarredByAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if this repository is not starred by you")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a repository subscription](Activity::delete_repo_subscription_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityDeleteRepoSubscriptionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Delete a thread subscription](Activity::delete_thread_subscription_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityDeleteThreadSubscriptionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get feeds](Activity::get_feeds_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityGetFeedsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a repository subscription](Activity::get_repo_subscription_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityGetRepoSubscriptionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not Found if you don&#x27;t subscribe to the repository")]
    Status404,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a thread](Activity::get_thread_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityGetThreadError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Get a thread subscription for the authenticated user](Activity::get_thread_subscription_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityGetThreadSubscriptionForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List events for the authenticated user](Activity::list_events_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListEventsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List notifications for the authenticated user](Activity::list_notifications_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListNotificationsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List organization events for the authenticated user](Activity::list_org_events_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListOrgEventsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public events](Activity::list_public_events_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListPublicEventsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Service unavailable")]
    Status503(GetSearchUsersResponse503),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public events for a network of repositories](Activity::list_public_events_for_repo_network_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListPublicEventsForRepoNetworkError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Moved permanently")]
    Status301(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public events for a user](Activity::list_public_events_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListPublicEventsForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public organization events](Activity::list_public_org_events_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListPublicOrgEventsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List events received by the authenticated user](Activity::list_received_events_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListReceivedEventsForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List public events received by a user](Activity::list_received_public_events_for_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListReceivedPublicEventsForUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository events](Activity::list_repo_events_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListRepoEventsError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repository notifications for the authenticated user](Activity::list_repo_notifications_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListRepoNotificationsForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories starred by the authenticated user](Activity::list_repos_starred_by_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListReposStarredByAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories starred by a user](Activity::list_repos_starred_by_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListReposStarredByUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories watched by a user](Activity::list_repos_watched_by_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListReposWatchedByUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List stargazers](Activity::list_stargazers_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListStargazersForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Validation failed")]
    Status422(ValidationError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List repositories watched by the authenticated user](Activity::list_watched_repos_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListWatchedReposForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [List watchers](Activity::list_watchers_for_repo_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityListWatchersForRepoError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Mark notifications as read](Activity::mark_notifications_as_read_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityMarkNotificationsAsReadError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reset Content")]
    Status205,
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Mark repository notifications as read](Activity::mark_repo_notifications_as_read_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityMarkRepoNotificationsAsReadError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Reset Content")]
    Status205,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Mark a thread as read](Activity::mark_thread_as_read_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityMarkThreadAsReadError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set a repository subscription](Activity::set_repo_subscription_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivitySetRepoSubscriptionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Set a thread subscription](Activity::set_thread_subscription_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivitySetThreadSubscriptionError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Star a repository for the authenticated user](Activity::star_repo_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityStarRepoForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}

/// Errors for the [Unstar a repository for the authenticated user](Activity::unstar_repo_for_authenticated_user_async()) endpoint.
#[derive(Debug, thiserror::Error)]
pub enum ActivityUnstarRepoForAuthenticatedUserError {
    #[error(transparent)]
    AdapterError(#[from] AdapterError),
    #[error(transparent)]
    SerdeJson(#[from] serde_json::Error),
    #[error(transparent)]
    SerdeUrl(#[from] serde_urlencoded::ser::Error),


    // -- endpoint errors

    #[error("Resource not found")]
    Status404(BasicError),
    #[error("Requires authentication")]
    Status401(BasicError),
    #[error("Not modified")]
    Status304,
    #[error("Forbidden")]
    Status403(BasicError),
    #[error("Status code: {}", code)]
    Generic { code: u16 },
}


/// Query parameters for the [List events for the authenticated user](Activity::list_events_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListEventsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListEventsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListEventsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List notifications for the authenticated user](Activity::list_notifications_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListNotificationsForAuthenticatedUserParams {
    /// If `true`, show notifications marked as read.
    all: Option<bool>, 
    /// If `true`, only shows notifications in which the user is directly participating or mentioned.
    participating: Option<bool>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    before: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListNotificationsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// If `true`, show notifications marked as read.
    pub fn all(self, all: bool) -> Self {
        Self { 
            all: Some(all),
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// If `true`, only shows notifications in which the user is directly participating or mentioned.
    pub fn participating(self, participating: bool) -> Self {
        Self { 
            all: self.all, 
            participating: Some(participating),
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: Some(since),
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn before(self, before: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: Some(before),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListNotificationsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List organization events for the authenticated user](Activity::list_org_events_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListOrgEventsForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListOrgEventsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListOrgEventsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public events](Activity::list_public_events_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListPublicEventsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListPublicEventsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListPublicEventsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public events for a network of repositories](Activity::list_public_events_for_repo_network_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListPublicEventsForRepoNetworkParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListPublicEventsForRepoNetworkParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListPublicEventsForRepoNetworkParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public events for a user](Activity::list_public_events_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListPublicEventsForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListPublicEventsForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListPublicEventsForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public organization events](Activity::list_public_org_events_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListPublicOrgEventsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListPublicOrgEventsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListPublicOrgEventsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List events received by the authenticated user](Activity::list_received_events_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListReceivedEventsForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListReceivedEventsForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListReceivedEventsForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List public events received by a user](Activity::list_received_public_events_for_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListReceivedPublicEventsForUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListReceivedPublicEventsForUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListReceivedPublicEventsForUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository events](Activity::list_repo_events_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListRepoEventsParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListRepoEventsParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListRepoEventsParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repository notifications for the authenticated user](Activity::list_repo_notifications_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListRepoNotificationsForAuthenticatedUserParams {
    /// If `true`, show notifications marked as read.
    all: Option<bool>, 
    /// If `true`, only shows notifications in which the user is directly participating or mentioned.
    participating: Option<bool>, 
    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    since: Option<chrono::DateTime<chrono::Utc>>, 
    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    before: Option<chrono::DateTime<chrono::Utc>>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListRepoNotificationsForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// If `true`, show notifications marked as read.
    pub fn all(self, all: bool) -> Self {
        Self { 
            all: Some(all),
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// If `true`, only shows notifications in which the user is directly participating or mentioned.
    pub fn participating(self, participating: bool) -> Self {
        Self { 
            all: self.all, 
            participating: Some(participating),
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn since(self, since: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: Some(since),
            before: self.before, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
    pub fn before(self, before: chrono::DateTime<chrono::Utc>) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: Some(before),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            all: self.all, 
            participating: self.participating, 
            since: self.since, 
            before: self.before, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListRepoNotificationsForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories starred by the authenticated user](Activity::list_repos_starred_by_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListReposStarredByAuthenticatedUserParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ActivityListReposStarredByAuthenticatedUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListReposStarredByAuthenticatedUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories starred by a user](Activity::list_repos_starred_by_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListReposStarredByUserParams<'req> {
    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    sort: Option<&'req str>, 
    /// One of `asc` (ascending) or `desc` (descending).
    direction: Option<&'req str>, 
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl<'req> ActivityListReposStarredByUserParams<'req> {
    pub fn new() -> Self {
        Self::default()
    }

    /// One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
    pub fn sort(self, sort: &'req str) -> Self {
        Self { 
            sort: Some(sort),
            direction: self.direction, 
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// One of `asc` (ascending) or `desc` (descending).
    pub fn direction(self, direction: &'req str) -> Self {
        Self { 
            sort: self.sort, 
            direction: Some(direction),
            per_page: self.per_page, 
            page: self.page, 
        }
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            sort: self.sort, 
            direction: self.direction, 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListReposStarredByUserParams<'enc> {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories watched by a user](Activity::list_repos_watched_by_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListReposWatchedByUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListReposWatchedByUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListReposWatchedByUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List stargazers](Activity::list_stargazers_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListStargazersForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListStargazersForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListStargazersForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List repositories watched by the authenticated user](Activity::list_watched_repos_for_authenticated_user_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListWatchedReposForAuthenticatedUserParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListWatchedReposForAuthenticatedUserParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListWatchedReposForAuthenticatedUserParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}
/// Query parameters for the [List watchers](Activity::list_watchers_for_repo_async()) endpoint.
#[derive(Default, Serialize)]
pub struct ActivityListWatchersForRepoParams {
    /// Results per page (max 100)
    per_page: Option<u16>, 
    /// Page number of the results to fetch.
    page: Option<u16>
}

impl ActivityListWatchersForRepoParams {
    pub fn new() -> Self {
        Self::default()
    }

    /// Results per page (max 100)
    pub fn per_page(self, per_page: u16) -> Self {
        Self { 
            per_page: Some(per_page),
            page: self.page, 
        }
    }

    /// Page number of the results to fetch.
    pub fn page(self, page: u16) -> Self {
        Self { 
            per_page: self.per_page, 
            page: Some(page),
        }
    }
}

impl<'enc> From<&'enc PerPage> for ActivityListWatchersForRepoParams {
    fn from(per_page: &'enc PerPage) -> Self {
        Self {
            per_page: Some(per_page.per_page),
            page: Some(per_page.page),
            ..Default::default()
        }
    }
}

impl<'api> Activity<'api> {
    /// ---
    ///
    /// # Check if a repository is starred by the authenticated user
    /// 
    /// [GitHub API docs for check_repo_is_starred_by_authenticated_user](https://docs.github.com/rest/reference/activity#check-if-a-repository-is-starred-by-the-authenticated-user)
    ///
    /// ---
    pub async fn check_repo_is_starred_by_authenticated_user_async(&self, owner: &str, repo: &str) -> Result<(), ActivityCheckRepoIsStarredByAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status304),
                403 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Check if a repository is starred by the authenticated user
    /// 
    /// [GitHub API docs for check_repo_is_starred_by_authenticated_user](https://docs.github.com/rest/reference/activity#check-if-a-repository-is-starred-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn check_repo_is_starred_by_authenticated_user(&self, owner: &str, repo: &str) -> Result<(), ActivityCheckRepoIsStarredByAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                304 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status304),
                403 => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityCheckRepoIsStarredByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository subscription
    ///
    /// This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/reference/activity#set-a-repository-subscription).
    /// 
    /// [GitHub API docs for delete_repo_subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription)
    ///
    /// ---
    pub async fn delete_repo_subscription_async(&self, owner: &str, repo: &str) -> Result<(), ActivityDeleteRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityDeleteRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a repository subscription
    ///
    /// This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/reference/activity#set-a-repository-subscription).
    /// 
    /// [GitHub API docs for delete_repo_subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_repo_subscription(&self, owner: &str, repo: &str) -> Result<(), ActivityDeleteRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityDeleteRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a thread subscription
    ///
    /// Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`.
    /// 
    /// [GitHub API docs for delete_thread_subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription)
    ///
    /// ---
    pub async fn delete_thread_subscription_async(&self, thread_id: i32) -> Result<(), ActivityDeleteThreadSubscriptionError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityDeleteThreadSubscriptionError::Status304),
                403 => Err(ActivityDeleteThreadSubscriptionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityDeleteThreadSubscriptionError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityDeleteThreadSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Delete a thread subscription
    ///
    /// Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`.
    /// 
    /// [GitHub API docs for delete_thread_subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn delete_thread_subscription(&self, thread_id: i32) -> Result<(), ActivityDeleteThreadSubscriptionError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityDeleteThreadSubscriptionError::Status304),
                403 => Err(ActivityDeleteThreadSubscriptionError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityDeleteThreadSubscriptionError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityDeleteThreadSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get feeds
    ///
    /// GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
    /// 
    /// *   **Timeline**: The GitHub global public timeline
    /// *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia)
    /// *   **Current user public**: The public timeline for the authenticated user
    /// *   **Current user**: The private timeline for the authenticated user
    /// *   **Current user actor**: The private timeline for activity created by the authenticated user
    /// *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
    /// *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
    /// 
    /// **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
    /// 
    /// [GitHub API docs for get_feeds](https://docs.github.com/rest/reference/activity#get-feeds)
    ///
    /// ---
    pub async fn get_feeds_async(&self) -> Result<Feed, ActivityGetFeedsError> {

        let request_uri = format!("{}/feeds", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityGetFeedsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get feeds
    ///
    /// GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
    /// 
    /// *   **Timeline**: The GitHub global public timeline
    /// *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia)
    /// *   **Current user public**: The public timeline for the authenticated user
    /// *   **Current user**: The private timeline for the authenticated user
    /// *   **Current user actor**: The private timeline for activity created by the authenticated user
    /// *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
    /// *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
    /// 
    /// **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
    /// 
    /// [GitHub API docs for get_feeds](https://docs.github.com/rest/reference/activity#get-feeds)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_feeds(&self) -> Result<Feed, ActivityGetFeedsError> {

        let request_uri = format!("{}/feeds", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityGetFeedsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository subscription
    /// 
    /// [GitHub API docs for get_repo_subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription)
    ///
    /// ---
    pub async fn get_repo_subscription_async(&self, owner: &str, repo: &str) -> Result<RepositorySubscription, ActivityGetRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityGetRepoSubscriptionError::Status404),
                403 => Err(ActivityGetRepoSubscriptionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityGetRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a repository subscription
    /// 
    /// [GitHub API docs for get_repo_subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_repo_subscription(&self, owner: &str, repo: &str) -> Result<RepositorySubscription, ActivityGetRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityGetRepoSubscriptionError::Status404),
                403 => Err(ActivityGetRepoSubscriptionError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityGetRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a thread
    /// 
    /// [GitHub API docs for get_thread](https://docs.github.com/rest/reference/activity#get-a-thread)
    ///
    /// ---
    pub async fn get_thread_async(&self, thread_id: i32) -> Result<Thread, ActivityGetThreadError> {

        let request_uri = format!("{}/notifications/threads/{}", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityGetThreadError::Status304),
                403 => Err(ActivityGetThreadError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityGetThreadError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityGetThreadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a thread
    /// 
    /// [GitHub API docs for get_thread](https://docs.github.com/rest/reference/activity#get-a-thread)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_thread(&self, thread_id: i32) -> Result<Thread, ActivityGetThreadError> {

        let request_uri = format!("{}/notifications/threads/{}", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityGetThreadError::Status304),
                403 => Err(ActivityGetThreadError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityGetThreadError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityGetThreadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a thread subscription for the authenticated user
    ///
    /// This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription).
    /// 
    /// Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
    /// 
    /// [GitHub API docs for get_thread_subscription_for_authenticated_user](https://docs.github.com/rest/reference/activity#get-a-thread-subscription-for-the-authenticated-user)
    ///
    /// ---
    pub async fn get_thread_subscription_for_authenticated_user_async(&self, thread_id: i32) -> Result<ThreadSubscription, ActivityGetThreadSubscriptionForAuthenticatedUserError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status304),
                403 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Get a thread subscription for the authenticated user
    ///
    /// This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription).
    /// 
    /// Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
    /// 
    /// [GitHub API docs for get_thread_subscription_for_authenticated_user](https://docs.github.com/rest/reference/activity#get-a-thread-subscription-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn get_thread_subscription_for_authenticated_user(&self, thread_id: i32) -> Result<ThreadSubscription, ActivityGetThreadSubscriptionForAuthenticatedUserError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status304),
                403 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityGetThreadSubscriptionForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List events for the authenticated user
    ///
    /// If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
    /// 
    /// [GitHub API docs for list_events_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-events-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_events_for_authenticated_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListEventsForAuthenticatedUserParams>>) -> Result<Vec<Event>, ActivityListEventsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/users/{}/events", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListEventsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List events for the authenticated user
    ///
    /// If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
    /// 
    /// [GitHub API docs for list_events_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-events-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_events_for_authenticated_user(&self, username: &str, query_params: Option<impl Into<ActivityListEventsForAuthenticatedUserParams>>) -> Result<Vec<Event>, ActivityListEventsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/users/{}/events", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListEventsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListEventsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List notifications for the authenticated user
    ///
    /// List all notifications for the current user, sorted by most recently updated.
    /// 
    /// [GitHub API docs for list_notifications_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_notifications_for_authenticated_user_async(&self, query_params: Option<impl Into<ActivityListNotificationsForAuthenticatedUserParams>>) -> Result<Vec<Thread>, ActivityListNotificationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/notifications", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListNotificationsForAuthenticatedUserError::Status304),
                403 => Err(ActivityListNotificationsForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityListNotificationsForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                422 => Err(ActivityListNotificationsForAuthenticatedUserError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListNotificationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List notifications for the authenticated user
    ///
    /// List all notifications for the current user, sorted by most recently updated.
    /// 
    /// [GitHub API docs for list_notifications_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_notifications_for_authenticated_user(&self, query_params: Option<impl Into<ActivityListNotificationsForAuthenticatedUserParams>>) -> Result<Vec<Thread>, ActivityListNotificationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/notifications", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListNotificationsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListNotificationsForAuthenticatedUserError::Status304),
                403 => Err(ActivityListNotificationsForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityListNotificationsForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                422 => Err(ActivityListNotificationsForAuthenticatedUserError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListNotificationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization events for the authenticated user
    ///
    /// This is the user's organization dashboard. You must be authenticated as the user to view this.
    /// 
    /// [GitHub API docs for list_org_events_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-organization-events-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_org_events_for_authenticated_user_async(&self, username: &str, org: &str, query_params: Option<impl Into<ActivityListOrgEventsForAuthenticatedUserParams>>) -> Result<Vec<Event>, ActivityListOrgEventsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/users/{}/events/orgs/{}", super::GITHUB_BASE_API_URL, username, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListOrgEventsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List organization events for the authenticated user
    ///
    /// This is the user's organization dashboard. You must be authenticated as the user to view this.
    /// 
    /// [GitHub API docs for list_org_events_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-organization-events-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_org_events_for_authenticated_user(&self, username: &str, org: &str, query_params: Option<impl Into<ActivityListOrgEventsForAuthenticatedUserParams>>) -> Result<Vec<Event>, ActivityListOrgEventsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/users/{}/events/orgs/{}", super::GITHUB_BASE_API_URL, username, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListOrgEventsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListOrgEventsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events
    ///
    /// We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
    /// 
    /// [GitHub API docs for list_public_events](https://docs.github.com/rest/reference/activity#list-public-events)
    ///
    /// ---
    pub async fn list_public_events_async(&self, query_params: Option<impl Into<ActivityListPublicEventsParams>>) -> Result<Vec<Event>, ActivityListPublicEventsError> {

        let mut request_uri = format!("{}/events", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListPublicEventsError::Status304),
                403 => Err(ActivityListPublicEventsError::Status403(crate::adapters::to_json_async(github_response).await?)),
                503 => Err(ActivityListPublicEventsError::Status503(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListPublicEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events
    ///
    /// We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
    /// 
    /// [GitHub API docs for list_public_events](https://docs.github.com/rest/reference/activity#list-public-events)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_events(&self, query_params: Option<impl Into<ActivityListPublicEventsParams>>) -> Result<Vec<Event>, ActivityListPublicEventsError> {

        let mut request_uri = format!("{}/events", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListPublicEventsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListPublicEventsError::Status304),
                403 => Err(ActivityListPublicEventsError::Status403(crate::adapters::to_json(github_response)?)),
                503 => Err(ActivityListPublicEventsError::Status503(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListPublicEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events for a network of repositories
    /// 
    /// [GitHub API docs for list_public_events_for_repo_network](https://docs.github.com/rest/reference/activity#list-public-events-for-a-network-of-repositories)
    ///
    /// ---
    pub async fn list_public_events_for_repo_network_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListPublicEventsForRepoNetworkParams>>) -> Result<Vec<Event>, ActivityListPublicEventsForRepoNetworkError> {

        let mut request_uri = format!("{}/networks/{}/{}/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityListPublicEventsForRepoNetworkError::Status404(crate::adapters::to_json_async(github_response).await?)),
                403 => Err(ActivityListPublicEventsForRepoNetworkError::Status403(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ActivityListPublicEventsForRepoNetworkError::Status304),
                301 => Err(ActivityListPublicEventsForRepoNetworkError::Status301(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListPublicEventsForRepoNetworkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events for a network of repositories
    /// 
    /// [GitHub API docs for list_public_events_for_repo_network](https://docs.github.com/rest/reference/activity#list-public-events-for-a-network-of-repositories)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_events_for_repo_network(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListPublicEventsForRepoNetworkParams>>) -> Result<Vec<Event>, ActivityListPublicEventsForRepoNetworkError> {

        let mut request_uri = format!("{}/networks/{}/{}/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListPublicEventsForRepoNetworkParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityListPublicEventsForRepoNetworkError::Status404(crate::adapters::to_json(github_response)?)),
                403 => Err(ActivityListPublicEventsForRepoNetworkError::Status403(crate::adapters::to_json(github_response)?)),
                304 => Err(ActivityListPublicEventsForRepoNetworkError::Status304),
                301 => Err(ActivityListPublicEventsForRepoNetworkError::Status301(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListPublicEventsForRepoNetworkError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events for a user
    /// 
    /// [GitHub API docs for list_public_events_for_user](https://docs.github.com/rest/reference/activity#list-public-events-for-a-user)
    ///
    /// ---
    pub async fn list_public_events_for_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListPublicEventsForUserParams>>) -> Result<Vec<Event>, ActivityListPublicEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/events/public", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListPublicEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events for a user
    /// 
    /// [GitHub API docs for list_public_events_for_user](https://docs.github.com/rest/reference/activity#list-public-events-for-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_events_for_user(&self, username: &str, query_params: Option<impl Into<ActivityListPublicEventsForUserParams>>) -> Result<Vec<Event>, ActivityListPublicEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/events/public", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListPublicEventsForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListPublicEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public organization events
    /// 
    /// [GitHub API docs for list_public_org_events](https://docs.github.com/rest/reference/activity#list-public-organization-events)
    ///
    /// ---
    pub async fn list_public_org_events_async(&self, org: &str, query_params: Option<impl Into<ActivityListPublicOrgEventsParams>>) -> Result<Vec<Event>, ActivityListPublicOrgEventsError> {

        let mut request_uri = format!("{}/orgs/{}/events", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListPublicOrgEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public organization events
    /// 
    /// [GitHub API docs for list_public_org_events](https://docs.github.com/rest/reference/activity#list-public-organization-events)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_public_org_events(&self, org: &str, query_params: Option<impl Into<ActivityListPublicOrgEventsParams>>) -> Result<Vec<Event>, ActivityListPublicOrgEventsError> {

        let mut request_uri = format!("{}/orgs/{}/events", super::GITHUB_BASE_API_URL, org);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListPublicOrgEventsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListPublicOrgEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List events received by the authenticated user
    ///
    /// These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
    /// 
    /// [GitHub API docs for list_received_events_for_user](https://docs.github.com/rest/reference/activity#list-events-received-by-the-authenticated-user)
    ///
    /// ---
    pub async fn list_received_events_for_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListReceivedEventsForUserParams>>) -> Result<Vec<Event>, ActivityListReceivedEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/received_events", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReceivedEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List events received by the authenticated user
    ///
    /// These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
    /// 
    /// [GitHub API docs for list_received_events_for_user](https://docs.github.com/rest/reference/activity#list-events-received-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_received_events_for_user(&self, username: &str, query_params: Option<impl Into<ActivityListReceivedEventsForUserParams>>) -> Result<Vec<Event>, ActivityListReceivedEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/received_events", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListReceivedEventsForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReceivedEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events received by a user
    /// 
    /// [GitHub API docs for list_received_public_events_for_user](https://docs.github.com/rest/reference/activity#list-public-events-received-by-a-user)
    ///
    /// ---
    pub async fn list_received_public_events_for_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListReceivedPublicEventsForUserParams>>) -> Result<Vec<Event>, ActivityListReceivedPublicEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/received_events/public", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReceivedPublicEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List public events received by a user
    /// 
    /// [GitHub API docs for list_received_public_events_for_user](https://docs.github.com/rest/reference/activity#list-public-events-received-by-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_received_public_events_for_user(&self, username: &str, query_params: Option<impl Into<ActivityListReceivedPublicEventsForUserParams>>) -> Result<Vec<Event>, ActivityListReceivedPublicEventsForUserError> {

        let mut request_uri = format!("{}/users/{}/received_events/public", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListReceivedPublicEventsForUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReceivedPublicEventsForUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository events
    /// 
    /// [GitHub API docs for list_repo_events](https://docs.github.com/rest/reference/activity#list-repository-events)
    ///
    /// ---
    pub async fn list_repo_events_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListRepoEventsParams>>) -> Result<Vec<Event>, ActivityListRepoEventsError> {

        let mut request_uri = format!("{}/repos/{}/{}/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListRepoEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository events
    /// 
    /// [GitHub API docs for list_repo_events](https://docs.github.com/rest/reference/activity#list-repository-events)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repo_events(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListRepoEventsParams>>) -> Result<Vec<Event>, ActivityListRepoEventsError> {

        let mut request_uri = format!("{}/repos/{}/{}/events", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListRepoEventsParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListRepoEventsError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository notifications for the authenticated user
    ///
    /// List all notifications for the current user.
    /// 
    /// [GitHub API docs for list_repo_notifications_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user)
    ///
    /// ---
    pub async fn list_repo_notifications_for_authenticated_user_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListRepoNotificationsForAuthenticatedUserParams>>) -> Result<Vec<Thread>, ActivityListRepoNotificationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/notifications", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListRepoNotificationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repository notifications for the authenticated user
    ///
    /// List all notifications for the current user.
    /// 
    /// [GitHub API docs for list_repo_notifications_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repo_notifications_for_authenticated_user(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListRepoNotificationsForAuthenticatedUserParams>>) -> Result<Vec<Thread>, ActivityListRepoNotificationsForAuthenticatedUserError> {

        let mut request_uri = format!("{}/repos/{}/{}/notifications", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListRepoNotificationsForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListRepoNotificationsForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories starred by the authenticated user
    ///
    /// Lists repositories the authenticated user has starred.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_repos_starred_by_authenticated_user](https://docs.github.com/rest/reference/activity#list-repositories-starred-by-the-authenticated-user)
    ///
    /// ---
    pub async fn list_repos_starred_by_authenticated_user_async(&self, query_params: Option<impl Into<ActivityListReposStarredByAuthenticatedUserParams<'api>>>) -> Result<Vec<Repository>, ActivityListReposStarredByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/starred", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListReposStarredByAuthenticatedUserError::Status304),
                403 => Err(ActivityListReposStarredByAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityListReposStarredByAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListReposStarredByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories starred by the authenticated user
    ///
    /// Lists repositories the authenticated user has starred.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_repos_starred_by_authenticated_user](https://docs.github.com/rest/reference/activity#list-repositories-starred-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_starred_by_authenticated_user(&self, query_params: Option<impl Into<ActivityListReposStarredByAuthenticatedUserParams<'api>>>) -> Result<Vec<Repository>, ActivityListReposStarredByAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/starred", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListReposStarredByAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListReposStarredByAuthenticatedUserError::Status304),
                403 => Err(ActivityListReposStarredByAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityListReposStarredByAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListReposStarredByAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories starred by a user
    ///
    /// Lists repositories a user has starred.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_repos_starred_by_user](https://docs.github.com/rest/reference/activity#list-repositories-starred-by-a-user)
    ///
    /// ---
    pub async fn list_repos_starred_by_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListReposStarredByUserParams<'api>>>) -> Result<GetActivityListReposStarredByUserResponse200, ActivityListReposStarredByUserError> {

        let mut request_uri = format!("{}/users/{}/starred", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReposStarredByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories starred by a user
    ///
    /// Lists repositories a user has starred.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_repos_starred_by_user](https://docs.github.com/rest/reference/activity#list-repositories-starred-by-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_starred_by_user(&self, username: &str, query_params: Option<impl Into<ActivityListReposStarredByUserParams<'api>>>) -> Result<GetActivityListReposStarredByUserResponse200, ActivityListReposStarredByUserError> {

        let mut request_uri = format!("{}/users/{}/starred", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListReposStarredByUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReposStarredByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories watched by a user
    ///
    /// Lists repositories a user is watching.
    /// 
    /// [GitHub API docs for list_repos_watched_by_user](https://docs.github.com/rest/reference/activity#list-repositories-watched-by-a-user)
    ///
    /// ---
    pub async fn list_repos_watched_by_user_async(&self, username: &str, query_params: Option<impl Into<ActivityListReposWatchedByUserParams>>) -> Result<Vec<MinimalRepository>, ActivityListReposWatchedByUserError> {

        let mut request_uri = format!("{}/users/{}/subscriptions", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReposWatchedByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories watched by a user
    ///
    /// Lists repositories a user is watching.
    /// 
    /// [GitHub API docs for list_repos_watched_by_user](https://docs.github.com/rest/reference/activity#list-repositories-watched-by-a-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_repos_watched_by_user(&self, username: &str, query_params: Option<impl Into<ActivityListReposWatchedByUserParams>>) -> Result<Vec<MinimalRepository>, ActivityListReposWatchedByUserError> {

        let mut request_uri = format!("{}/users/{}/subscriptions", super::GITHUB_BASE_API_URL, username);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListReposWatchedByUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListReposWatchedByUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List stargazers
    ///
    /// Lists the people that have starred the repository.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_stargazers_for_repo](https://docs.github.com/rest/reference/activity#list-stargazers)
    ///
    /// ---
    pub async fn list_stargazers_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListStargazersForRepoParams>>) -> Result<GetActivityListStargazersForRepoResponse200, ActivityListStargazersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/stargazers", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                422 => Err(ActivityListStargazersForRepoError::Status422(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListStargazersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List stargazers
    ///
    /// Lists the people that have starred the repository.
    /// 
    /// You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
    /// 
    /// [GitHub API docs for list_stargazers_for_repo](https://docs.github.com/rest/reference/activity#list-stargazers)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_stargazers_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListStargazersForRepoParams>>) -> Result<GetActivityListStargazersForRepoResponse200, ActivityListStargazersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/stargazers", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListStargazersForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                422 => Err(ActivityListStargazersForRepoError::Status422(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListStargazersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories watched by the authenticated user
    ///
    /// Lists repositories the authenticated user is watching.
    /// 
    /// [GitHub API docs for list_watched_repos_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-repositories-watched-by-the-authenticated-user)
    ///
    /// ---
    pub async fn list_watched_repos_for_authenticated_user_async(&self, query_params: Option<impl Into<ActivityListWatchedReposForAuthenticatedUserParams>>) -> Result<Vec<MinimalRepository>, ActivityListWatchedReposForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/subscriptions", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status304),
                403 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityListWatchedReposForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List repositories watched by the authenticated user
    ///
    /// Lists repositories the authenticated user is watching.
    /// 
    /// [GitHub API docs for list_watched_repos_for_authenticated_user](https://docs.github.com/rest/reference/activity#list-repositories-watched-by-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_watched_repos_for_authenticated_user(&self, query_params: Option<impl Into<ActivityListWatchedReposForAuthenticatedUserParams>>) -> Result<Vec<MinimalRepository>, ActivityListWatchedReposForAuthenticatedUserError> {

        let mut request_uri = format!("{}/user/subscriptions", super::GITHUB_BASE_API_URL);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListWatchedReposForAuthenticatedUserParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status304),
                403 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityListWatchedReposForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityListWatchedReposForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List watchers
    ///
    /// Lists the people watching the specified repository.
    /// 
    /// [GitHub API docs for list_watchers_for_repo](https://docs.github.com/rest/reference/activity#list-watchers)
    ///
    /// ---
    pub async fn list_watchers_for_repo_async(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListWatchersForRepoParams>>) -> Result<Vec<SimpleUser>, ActivityListWatchersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/subscribers", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            request_uri.push_str(&serde_urlencoded::to_string(params.into())?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListWatchersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # List watchers
    ///
    /// Lists the people watching the specified repository.
    /// 
    /// [GitHub API docs for list_watchers_for_repo](https://docs.github.com/rest/reference/activity#list-watchers)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn list_watchers_for_repo(&self, owner: &str, repo: &str, query_params: Option<impl Into<ActivityListWatchersForRepoParams>>) -> Result<Vec<SimpleUser>, ActivityListWatchersForRepoError> {

        let mut request_uri = format!("{}/repos/{}/{}/subscribers", super::GITHUB_BASE_API_URL, owner, repo);

        if let Some(params) = query_params {
            request_uri.push_str("?");
            let qp: ActivityListWatchersForRepoParams = params.into();
            request_uri.push_str(&serde_urlencoded::to_string(qp)?);
        }

        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "GET",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivityListWatchersForRepoError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark notifications as read
    ///
    /// Marks all notifications as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    /// 
    /// [GitHub API docs for mark_notifications_as_read](https://docs.github.com/rest/reference/activity#mark-notifications-as-read)
    ///
    /// ---
    pub async fn mark_notifications_as_read_async(&self, body: PutActivityMarkNotificationsAsRead) -> Result<PostReposCreateDeploymentResponse202, ActivityMarkNotificationsAsReadError> {

        let request_uri = format!("{}/notifications", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivityMarkNotificationsAsRead::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                205 => Err(ActivityMarkNotificationsAsReadError::Status205),
                304 => Err(ActivityMarkNotificationsAsReadError::Status304),
                403 => Err(ActivityMarkNotificationsAsReadError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityMarkNotificationsAsReadError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityMarkNotificationsAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark notifications as read
    ///
    /// Marks all notifications as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    /// 
    /// [GitHub API docs for mark_notifications_as_read](https://docs.github.com/rest/reference/activity#mark-notifications-as-read)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn mark_notifications_as_read(&self, body: PutActivityMarkNotificationsAsRead) -> Result<PostReposCreateDeploymentResponse202, ActivityMarkNotificationsAsReadError> {

        let request_uri = format!("{}/notifications", super::GITHUB_BASE_API_URL);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivityMarkNotificationsAsRead::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                205 => Err(ActivityMarkNotificationsAsReadError::Status205),
                304 => Err(ActivityMarkNotificationsAsReadError::Status304),
                403 => Err(ActivityMarkNotificationsAsReadError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityMarkNotificationsAsReadError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityMarkNotificationsAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark repository notifications as read
    ///
    /// Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    /// 
    /// [GitHub API docs for mark_repo_notifications_as_read](https://docs.github.com/rest/reference/activity#mark-repository-notifications-as-read)
    ///
    /// ---
    pub async fn mark_repo_notifications_as_read_async(&self, owner: &str, repo: &str, body: PutActivityMarkRepoNotificationsAsRead) -> Result<PutPullsUpdateBranchResponse202, ActivityMarkRepoNotificationsAsReadError> {

        let request_uri = format!("{}/repos/{}/{}/notifications", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivityMarkRepoNotificationsAsRead::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                205 => Err(ActivityMarkRepoNotificationsAsReadError::Status205),
                code => Err(ActivityMarkRepoNotificationsAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark repository notifications as read
    ///
    /// Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    /// 
    /// [GitHub API docs for mark_repo_notifications_as_read](https://docs.github.com/rest/reference/activity#mark-repository-notifications-as-read)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn mark_repo_notifications_as_read(&self, owner: &str, repo: &str, body: PutActivityMarkRepoNotificationsAsRead) -> Result<PutPullsUpdateBranchResponse202, ActivityMarkRepoNotificationsAsReadError> {

        let request_uri = format!("{}/repos/{}/{}/notifications", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivityMarkRepoNotificationsAsRead::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                205 => Err(ActivityMarkRepoNotificationsAsReadError::Status205),
                code => Err(ActivityMarkRepoNotificationsAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark a thread as read
    /// 
    /// [GitHub API docs for mark_thread_as_read](https://docs.github.com/rest/reference/activity#mark-a-thread-as-read)
    ///
    /// ---
    pub async fn mark_thread_as_read_async(&self, thread_id: i32) -> Result<(), ActivityMarkThreadAsReadError> {

        let request_uri = format!("{}/notifications/threads/{}", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityMarkThreadAsReadError::Status304),
                403 => Err(ActivityMarkThreadAsReadError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityMarkThreadAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Mark a thread as read
    /// 
    /// [GitHub API docs for mark_thread_as_read](https://docs.github.com/rest/reference/activity#mark-a-thread-as-read)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn mark_thread_as_read(&self, thread_id: i32) -> Result<(), ActivityMarkThreadAsReadError> {

        let request_uri = format!("{}/notifications/threads/{}", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PATCH",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivityMarkThreadAsReadError::Status304),
                403 => Err(ActivityMarkThreadAsReadError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityMarkThreadAsReadError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set a repository subscription
    ///
    /// If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription) completely.
    /// 
    /// [GitHub API docs for set_repo_subscription](https://docs.github.com/rest/reference/activity#set-a-repository-subscription)
    ///
    /// ---
    pub async fn set_repo_subscription_async(&self, owner: &str, repo: &str, body: PutActivitySetRepoSubscription) -> Result<RepositorySubscription, ActivitySetRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivitySetRepoSubscription::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                code => Err(ActivitySetRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set a repository subscription
    ///
    /// If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription) completely.
    /// 
    /// [GitHub API docs for set_repo_subscription](https://docs.github.com/rest/reference/activity#set-a-repository-subscription)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_repo_subscription(&self, owner: &str, repo: &str, body: PutActivitySetRepoSubscription) -> Result<RepositorySubscription, ActivitySetRepoSubscriptionError> {

        let request_uri = format!("{}/repos/{}/{}/subscription", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivitySetRepoSubscription::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                code => Err(ActivitySetRepoSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set a thread subscription
    ///
    /// If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
    /// 
    /// You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
    /// 
    /// Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription) endpoint.
    /// 
    /// [GitHub API docs for set_thread_subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription)
    ///
    /// ---
    pub async fn set_thread_subscription_async(&self, thread_id: i32, body: PutActivitySetThreadSubscription) -> Result<ThreadSubscription, ActivitySetThreadSubscriptionError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivitySetThreadSubscription::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivitySetThreadSubscriptionError::Status304),
                403 => Err(ActivitySetThreadSubscriptionError::Status403(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivitySetThreadSubscriptionError::Status401(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivitySetThreadSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Set a thread subscription
    ///
    /// If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
    /// 
    /// You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
    /// 
    /// Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription) endpoint.
    /// 
    /// [GitHub API docs for set_thread_subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn set_thread_subscription(&self, thread_id: i32, body: PutActivitySetThreadSubscription) -> Result<ThreadSubscription, ActivitySetThreadSubscriptionError> {

        let request_uri = format!("{}/notifications/threads/{}/subscription", super::GITHUB_BASE_API_URL, thread_id);


        let req = GitHubRequest {
            uri: request_uri,
            body: Some(PutActivitySetThreadSubscription::from_json(body)?),
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                304 => Err(ActivitySetThreadSubscriptionError::Status304),
                403 => Err(ActivitySetThreadSubscriptionError::Status403(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivitySetThreadSubscriptionError::Status401(crate::adapters::to_json(github_response)?)),
                code => Err(ActivitySetThreadSubscriptionError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Star a repository for the authenticated user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for star_repo_for_authenticated_user](https://docs.github.com/rest/reference/activity#star-a-repository-for-the-authenticated-user)
    ///
    /// ---
    pub async fn star_repo_for_authenticated_user_async(&self, owner: &str, repo: &str) -> Result<(), ActivityStarRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                403 => Err(ActivityStarRepoForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                404 => Err(ActivityStarRepoForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityStarRepoForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ActivityStarRepoForAuthenticatedUserError::Status304),
                code => Err(ActivityStarRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Star a repository for the authenticated user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
    /// 
    /// [GitHub API docs for star_repo_for_authenticated_user](https://docs.github.com/rest/reference/activity#star-a-repository-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn star_repo_for_authenticated_user(&self, owner: &str, repo: &str) -> Result<(), ActivityStarRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "PUT",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                403 => Err(ActivityStarRepoForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                404 => Err(ActivityStarRepoForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityStarRepoForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                304 => Err(ActivityStarRepoForAuthenticatedUserError::Status304),
                code => Err(ActivityStarRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unstar a repository for the authenticated user
    /// 
    /// [GitHub API docs for unstar_repo_for_authenticated_user](https://docs.github.com/rest/reference/activity#unstar-a-repository-for-the-authenticated-user)
    ///
    /// ---
    pub async fn unstar_repo_for_authenticated_user_async(&self, owner: &str, repo: &str) -> Result<(), ActivityUnstarRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch_async(request).await?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json_async(github_response).await?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status404(crate::adapters::to_json_async(github_response).await?)),
                401 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status401(crate::adapters::to_json_async(github_response).await?)),
                304 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status304),
                403 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status403(crate::adapters::to_json_async(github_response).await?)),
                code => Err(ActivityUnstarRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

    /// ---
    ///
    /// # Unstar a repository for the authenticated user
    /// 
    /// [GitHub API docs for unstar_repo_for_authenticated_user](https://docs.github.com/rest/reference/activity#unstar-a-repository-for-the-authenticated-user)
    ///
    /// ---
    #[cfg(not(target_arch = "wasm32"))]
    pub fn unstar_repo_for_authenticated_user(&self, owner: &str, repo: &str) -> Result<(), ActivityUnstarRepoForAuthenticatedUserError> {

        let request_uri = format!("{}/user/starred/{}/{}", super::GITHUB_BASE_API_URL, owner, repo);


        let req = GitHubRequest {
            uri: request_uri,
            body: None,
            method: "DELETE",
            headers: vec![]
        };

        let request = GitHubRequestBuilder::build(req, self.auth)?;

        // --

        let github_response = crate::adapters::fetch(request)?;

        // --

        if github_response.is_success() {
            Ok(crate::adapters::to_json(github_response)?)
        } else {
            match github_response.status_code() {
                404 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status404(crate::adapters::to_json(github_response)?)),
                401 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status401(crate::adapters::to_json(github_response)?)),
                304 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status304),
                403 => Err(ActivityUnstarRepoForAuthenticatedUserError::Status403(crate::adapters::to_json(github_response)?)),
                code => Err(ActivityUnstarRepoForAuthenticatedUserError::Generic { code }),
            }
        }
    }

}
