//! Command line program to convert a roadmap from a named YAML input
//! file to SVG, written to the standard output.
//!
//! Example
//!
//! ~~~sh
//! roadmap2svg foo.yaml > foo.svg
//! ~~~
//!
//! The command line program mostly exists just to make it easier to
//! test the library crate. It is expected that serious use of the
//! crate will be as a library.

use roadmap::from_yaml;
use std::fs::File;
use std::io::Read;
use std::path::PathBuf;
use structopt::StructOpt;
use anyhow::Result;

const LABEL_WIDTH: usize = 30;

#[derive(Debug, StructOpt)]
#[structopt(
    name = "roadmap2dot",
    about = "Create a dot graph of a roadmap in YAML"
)]
struct Opt {
    // The input filename.
    #[structopt(parse(from_os_str))]
    filename: PathBuf,
}

fn main() -> Result<()> {
    let opt = Opt::from_args();
    let mut text = String::new();
    let mut f = File::open(opt.filename)?;
    f.read_to_string(&mut text)?;

    let mut r = from_yaml(&text)?;
    r.set_missing_statuses();
    println!("{}", r.format_as_dot(LABEL_WIDTH).unwrap());

    Ok(())
}
