use crate::args::DIR;
use std::default::Default;
use std::path::Path;

use koit_toml::{format::Toml, FileDatabase};
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Deserialize, Serialize, Debug)]
pub struct Config {
  pub udp: String,
  pub ws: String,
}

type TomlDb = FileDatabase<Config, Toml>;

lazy_static! {
  pub static ref CONFIG: TomlDb = futures::executor::block_on(async {
    let p = Path::new(&*DIR).join("config.toml");
    TomlDb::load_from_path_or_default(p).await.unwrap()
  });
}
