use async_std::prelude::*;
use rand::Rng;
//use log::info;
//use std::net::SocketAddr;

use crate::{config::CONFIG, udp, ws};

pub async fn boot() {
  let config = CONFIG.get_data_lock().read().await.clone();
  macro_rules! get {
    ($key: tt, $default: expr) => {{
      let mut key = config.$key;

      if key.chars().count() == 0 {
        CONFIG
          .write(|c| {
            key = $default();
            c.$key = key.clone();
          })
          .await;
        CONFIG.save().await.unwrap();
      }
      key
    }};
  }

  let _ = (udp::listen(&get!(udp, || format!(
    "0.0.0.0:{}",
    rand::thread_rng().gen_range(10000..30000)
  ))))
  .join(ws::listen(&get!(ws, || "0.0.0.0:9981".to_string())))
  .await;
}
