# 人民网络开发路线图

重构互联网是一个浩大的工程，可以将其细分为一些小任务

## 第一步：基于UDP的高性能文件实时同步工具

用户场景 ::

  电脑上用迅雷下载了电影，自动传输到安卓电视盒子挂载的移动硬盘上

分发流程 ::

添加文件


1. 监控目录自动添加文件
2. 分发文件
3. 删除本地文件（可选，可以获取每个文件的镜像数量，每传输完成一个客户，就触发下)

可以标识哪些文件是增量更新的，这样避免反复重传

主要特性 ::
  
* 为大文件的传输而优化（参考 [Tsunami-UDP](https://www.infoq.cn/news/2014/10/tsunami-udp-cloud) 、[镭速传输](https://www.raysync.cn/) ）
  * 无状态，每个UDP包都是自描述的
  * 乱序发送，收到之后用稀疏文件写入，只要网速不大于文件写入速度，就不会有的[背压](https://lotabout.me/2020/Back-Pressure/)
  * 延时大!=网速慢，丢包大!=网速慢；接收方每秒给发送方回报收了哪些包，发送方会发送等量的包，另外还有个类似tcp的成功+1，失败减半的系统，试图探测包容量的极限
* 可以实现尾部增量更新（如果一个文件只进行了尾部的追加写入，那么只传输尾部部分）
* 可以设置监控的文件后缀
* 可以类似.git/ignore，设置忽略哪些文件
* 文件更变后，会开始实时同步
  * 基于blake3和merkle tree进行文件变化检测（会根据大小+最后更新时间缓存），同样，基于这个做文件传输完成后的校验
  * 文件传输的优先级按修改时间从远到近排序
  * 为避免反复重传下载中的任务，会监控文件，如果5秒都没有修改，才会开始尝试同步，如果在更新的过程中文件又发生的修改，那么终端传输就等待10秒再重试，然后是等待20秒，30秒...最多等待1分钟
* 可以定义文件传输开始前和完成后的钩子，钩子是一个JS脚本，默认放在文件夹的 `.rmw/hook/cp.before.js`, `.rmw/hook/cp.after.js`（可以执行一些操作，比如删除源文件，这个文件会被忽略同步），也可以设置全局的钩子

流程循环 ::

  * 更新文件后通知客户端
  * 文件拆分为1MB一个的小区块，每个区块计算一个blake3，以blake3+文件大小为唯一标识符
  * 客户端反馈需要哪些文件（如果路径冲突，反馈已有文件的大小和blake3，方便实现增量传输）
  * 客户端接收一个成功后的反馈


次优先级的需求::

* 可选的身份认证
* 可选的加密传输

## 第二步: 实现对等网的自动打洞

## 第三步: 实现分布式路由查找

## 第四步: 实现一个基于以上系统的去中心化的文件订阅系统

## 第五步: 基于文件系统，做一个聊天软件的前端


