use rmw_upnp::daemon;
use std::process::exit;

#[async_std::main]
async fn main() {
  let port = 23087;
  let duration = 60;
  daemon(
    "rmw upnp test",
    port,
    duration,
    Box::new(move |gateway, ext_port, ip| {
      println!(
        "upnp success: ( {}:{} -> {}:{} )",
        gateway, ext_port, ip, port
      );
      exit(0);
    }),
    Box::new(|err| {
      println!("upnp error: {}", err);
      exit(0);
    }),
  )
  .await;
}
