use luau_src::vm as raw;

#[repr(transparent)]
pub struct Luau(pub *mut raw::lua_State);

impl Drop for Luau {
	fn drop(&mut self) {
		unsafe { raw::lua_close(self.0) }
	}
}

impl Default for Luau {
	fn default() -> Self {
		Self::new()
	}
}
