///////////////////////////////////////////////
//                                           //
//                     !                     //
//   This file is automatically generated!   //
//           Do not directly edit!           //
//                                           //
///////////////////////////////////////////////

newtype_enum! {
    /// A League of Legends champion.
    ///
    /// This newtype acts as a C-like enum; each variant corresponds to an
    /// integer value. Using a newtype allows _unknown_ variants to be
    /// represented. This is important when Riot adds new champions.
    ///
    /// Field | Name | Identifier | Id
    /// ---|---|---|---
    /// `AATROX` | "Aatrox" | "Aatrox" | 266
    /// `AHRI` | "Ahri" | "Ahri" | 103
    /// `AKALI` | "Akali" | "Akali" | 84
    /// `AKSHAN` | "Akshan" | "Akshan" | 166
    /// `ALISTAR` | "Alistar" | "Alistar" | 12
    /// `AMUMU` | "Amumu" | "Amumu" | 32
    /// `ANIVIA` | "Anivia" | "Anivia" | 34
    /// `ANNIE` | "Annie" | "Annie" | 1
    /// `APHELIOS` | "Aphelios" | "Aphelios" | 523
    /// `ASHE` | "Ashe" | "Ashe" | 22
    /// `AURELION_SOL` | "Aurelion Sol" | "AurelionSol" | 136
    /// `AZIR` | "Azir" | "Azir" | 268
    /// `BARD` | "Bard" | "Bard" | 432
    /// `BLITZCRANK` | "Blitzcrank" | "Blitzcrank" | 53
    /// `BRAND` | "Brand" | "Brand" | 63
    /// `BRAUM` | "Braum" | "Braum" | 201
    /// `CAITLYN` | "Caitlyn" | "Caitlyn" | 51
    /// `CAMILLE` | "Camille" | "Camille" | 164
    /// `CASSIOPEIA` | "Cassiopeia" | "Cassiopeia" | 69
    /// `CHO_GATH` | "Cho'Gath" | "Chogath" | 31
    /// `CORKI` | "Corki" | "Corki" | 42
    /// `DARIUS` | "Darius" | "Darius" | 122
    /// `DIANA` | "Diana" | "Diana" | 131
    /// `DR_MUNDO` | "Dr. Mundo" | "DrMundo" | 36
    /// `DRAVEN` | "Draven" | "Draven" | 119
    /// `EKKO` | "Ekko" | "Ekko" | 245
    /// `ELISE` | "Elise" | "Elise" | 60
    /// `EVELYNN` | "Evelynn" | "Evelynn" | 28
    /// `EZREAL` | "Ezreal" | "Ezreal" | 81
    /// `FIDDLESTICKS` | "Fiddlesticks" | "FiddleSticks" | 9
    /// `FIORA` | "Fiora" | "Fiora" | 114
    /// `FIZZ` | "Fizz" | "Fizz" | 105
    /// `GALIO` | "Galio" | "Galio" | 3
    /// `GANGPLANK` | "Gangplank" | "Gangplank" | 41
    /// `GAREN` | "Garen" | "Garen" | 86
    /// `GNAR` | "Gnar" | "Gnar" | 150
    /// `GRAGAS` | "Gragas" | "Gragas" | 79
    /// `GRAVES` | "Graves" | "Graves" | 104
    /// `GWEN` | "Gwen" | "Gwen" | 887
    /// `HECARIM` | "Hecarim" | "Hecarim" | 120
    /// `HEIMERDINGER` | "Heimerdinger" | "Heimerdinger" | 74
    /// `ILLAOI` | "Illaoi" | "Illaoi" | 420
    /// `IRELIA` | "Irelia" | "Irelia" | 39
    /// `IVERN` | "Ivern" | "Ivern" | 427
    /// `JANNA` | "Janna" | "Janna" | 40
    /// `JARVAN_IV` | "Jarvan IV" | "JarvanIV" | 59
    /// `JAX` | "Jax" | "Jax" | 24
    /// `JAYCE` | "Jayce" | "Jayce" | 126
    /// `JHIN` | "Jhin" | "Jhin" | 202
    /// `JINX` | "Jinx" | "Jinx" | 222
    /// `KAI_SA` | "Kai'Sa" | "Kaisa" | 145
    /// `KALISTA` | "Kalista" | "Kalista" | 429
    /// `KARMA` | "Karma" | "Karma" | 43
    /// `KARTHUS` | "Karthus" | "Karthus" | 30
    /// `KASSADIN` | "Kassadin" | "Kassadin" | 38
    /// `KATARINA` | "Katarina" | "Katarina" | 55
    /// `KAYLE` | "Kayle" | "Kayle" | 10
    /// `KAYN` | "Kayn" | "Kayn" | 141
    /// `KENNEN` | "Kennen" | "Kennen" | 85
    /// `KHA_ZIX` | "Kha'Zix" | "Khazix" | 121
    /// `KINDRED` | "Kindred" | "Kindred" | 203
    /// `KLED` | "Kled" | "Kled" | 240
    /// `KOG_MAW` | "Kog'Maw" | "KogMaw" | 96
    /// `LE_BLANC` | "LeBlanc" | "Leblanc" | 7
    /// `LEE_SIN` | "Lee Sin" | "LeeSin" | 64
    /// `LEONA` | "Leona" | "Leona" | 89
    /// `LILLIA` | "Lillia" | "Lillia" | 876
    /// `LISSANDRA` | "Lissandra" | "Lissandra" | 127
    /// `LUCIAN` | "Lucian" | "Lucian" | 236
    /// `LULU` | "Lulu" | "Lulu" | 117
    /// `LUX` | "Lux" | "Lux" | 99
    /// `MALPHITE` | "Malphite" | "Malphite" | 54
    /// `MALZAHAR` | "Malzahar" | "Malzahar" | 90
    /// `MAOKAI` | "Maokai" | "Maokai" | 57
    /// `MASTER_YI` | "Master Yi" | "MasterYi" | 11
    /// `MISS_FORTUNE` | "Miss Fortune" | "MissFortune" | 21
    /// `MORDEKAISER` | "Mordekaiser" | "Mordekaiser" | 82
    /// `MORGANA` | "Morgana" | "Morgana" | 25
    /// `NAMI` | "Nami" | "Nami" | 267
    /// `NASUS` | "Nasus" | "Nasus" | 75
    /// `NAUTILUS` | "Nautilus" | "Nautilus" | 111
    /// `NEEKO` | "Neeko" | "Neeko" | 518
    /// `NIDALEE` | "Nidalee" | "Nidalee" | 76
    /// `NOCTURNE` | "Nocturne" | "Nocturne" | 56
    /// `NUNU_WILLUMP` | "Nunu & Willump" | "Nunu" | 20
    /// `OLAF` | "Olaf" | "Olaf" | 2
    /// `ORIANNA` | "Orianna" | "Orianna" | 61
    /// `ORNN` | "Ornn" | "Ornn" | 516
    /// `PANTHEON` | "Pantheon" | "Pantheon" | 80
    /// `POPPY` | "Poppy" | "Poppy" | 78
    /// `PYKE` | "Pyke" | "Pyke" | 555
    /// `QIYANA` | "Qiyana" | "Qiyana" | 246
    /// `QUINN` | "Quinn" | "Quinn" | 133
    /// `RAKAN` | "Rakan" | "Rakan" | 497
    /// `RAMMUS` | "Rammus" | "Rammus" | 33
    /// `REK_SAI` | "Rek'Sai" | "RekSai" | 421
    /// `RELL` | "Rell" | "Rell" | 526
    /// `RENEKTON` | "Renekton" | "Renekton" | 58
    /// `RENGAR` | "Rengar" | "Rengar" | 107
    /// `RIVEN` | "Riven" | "Riven" | 92
    /// `RUMBLE` | "Rumble" | "Rumble" | 68
    /// `RYZE` | "Ryze" | "Ryze" | 13
    /// `SAMIRA` | "Samira" | "Samira" | 360
    /// `SEJUANI` | "Sejuani" | "Sejuani" | 113
    /// `SENNA` | "Senna" | "Senna" | 235
    /// `SERAPHINE` | "Seraphine" | "Seraphine" | 147
    /// `SETT` | "Sett" | "Sett" | 875
    /// `SHACO` | "Shaco" | "Shaco" | 35
    /// `SHEN` | "Shen" | "Shen" | 98
    /// `SHYVANA` | "Shyvana" | "Shyvana" | 102
    /// `SINGED` | "Singed" | "Singed" | 27
    /// `SION` | "Sion" | "Sion" | 14
    /// `SIVIR` | "Sivir" | "Sivir" | 15
    /// `SKARNER` | "Skarner" | "Skarner" | 72
    /// `SONA` | "Sona" | "Sona" | 37
    /// `SORAKA` | "Soraka" | "Soraka" | 16
    /// `SWAIN` | "Swain" | "Swain" | 50
    /// `SYLAS` | "Sylas" | "Sylas" | 517
    /// `SYNDRA` | "Syndra" | "Syndra" | 134
    /// `TAHM_KENCH` | "Tahm Kench" | "TahmKench" | 223
    /// `TALIYAH` | "Taliyah" | "Taliyah" | 163
    /// `TALON` | "Talon" | "Talon" | 91
    /// `TARIC` | "Taric" | "Taric" | 44
    /// `TEEMO` | "Teemo" | "Teemo" | 17
    /// `THRESH` | "Thresh" | "Thresh" | 412
    /// `TRISTANA` | "Tristana" | "Tristana" | 18
    /// `TRUNDLE` | "Trundle" | "Trundle" | 48
    /// `TRYNDAMERE` | "Tryndamere" | "Tryndamere" | 23
    /// `TWISTED_FATE` | "Twisted Fate" | "TwistedFate" | 4
    /// `TWITCH` | "Twitch" | "Twitch" | 29
    /// `UDYR` | "Udyr" | "Udyr" | 77
    /// `URGOT` | "Urgot" | "Urgot" | 6
    /// `VARUS` | "Varus" | "Varus" | 110
    /// `VAYNE` | "Vayne" | "Vayne" | 67
    /// `VEIGAR` | "Veigar" | "Veigar" | 45
    /// `VEL_KOZ` | "Vel'Koz" | "Velkoz" | 161
    /// `VEX` | "Vex" | "Vex" | 711
    /// `VI` | "Vi" | "Vi" | 254
    /// `VIEGO` | "Viego" | "Viego" | 234
    /// `VIKTOR` | "Viktor" | "Viktor" | 112
    /// `VLADIMIR` | "Vladimir" | "Vladimir" | 8
    /// `VOLIBEAR` | "Volibear" | "Volibear" | 106
    /// `WARWICK` | "Warwick" | "Warwick" | 19
    /// `WUKONG` | "Wukong" | "MonkeyKing" | 62
    /// `XAYAH` | "Xayah" | "Xayah" | 498
    /// `XERATH` | "Xerath" | "Xerath" | 101
    /// `XIN_ZHAO` | "Xin Zhao" | "XinZhao" | 5
    /// `YASUO` | "Yasuo" | "Yasuo" | 157
    /// `YONE` | "Yone" | "Yone" | 777
    /// `YORICK` | "Yorick" | "Yorick" | 83
    /// `YUUMI` | "Yuumi" | "Yuumi" | 350
    /// `ZAC` | "Zac" | "Zac" | 154
    /// `ZED` | "Zed" | "Zed" | 238
    /// `ZIGGS` | "Ziggs" | "Ziggs" | 115
    /// `ZILEAN` | "Zilean" | "Zilean" | 26
    /// `ZOE` | "Zoe" | "Zoe" | 142
    /// `ZYRA` | "Zyra" | "Zyra" | 143
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(transparent)]
    pub newtype_enum Champion(i16) {
        /// `266`.
        AATROX = 266,
        /// `103`.
        AHRI = 103,
        /// `84`.
        AKALI = 84,
        /// `166`.
        AKSHAN = 166,
        /// `12`.
        ALISTAR = 12,
        /// `32`.
        AMUMU = 32,
        /// `34`.
        ANIVIA = 34,
        /// `1`.
        ANNIE = 1,
        /// `523`.
        APHELIOS = 523,
        /// `22`.
        ASHE = 22,
        /// `136`.
        AURELION_SOL = 136,
        /// `268`.
        AZIR = 268,
        /// `432`.
        BARD = 432,
        /// `53`.
        BLITZCRANK = 53,
        /// `63`.
        BRAND = 63,
        /// `201`.
        BRAUM = 201,
        /// `51`.
        CAITLYN = 51,
        /// `164`.
        CAMILLE = 164,
        /// `69`.
        CASSIOPEIA = 69,
        /// `31`.
        CHO_GATH = 31,
        /// `42`.
        CORKI = 42,
        /// `122`.
        DARIUS = 122,
        /// `131`.
        DIANA = 131,
        /// `36`.
        DR_MUNDO = 36,
        /// `119`.
        DRAVEN = 119,
        /// `245`.
        EKKO = 245,
        /// `60`.
        ELISE = 60,
        /// `28`.
        EVELYNN = 28,
        /// `81`.
        EZREAL = 81,
        /// `9`.
        FIDDLESTICKS = 9,
        /// `114`.
        FIORA = 114,
        /// `105`.
        FIZZ = 105,
        /// `3`.
        GALIO = 3,
        /// `41`.
        GANGPLANK = 41,
        /// `86`.
        GAREN = 86,
        /// `150`.
        GNAR = 150,
        /// `79`.
        GRAGAS = 79,
        /// `104`.
        GRAVES = 104,
        /// `887`.
        GWEN = 887,
        /// `120`.
        HECARIM = 120,
        /// `74`.
        HEIMERDINGER = 74,
        /// `420`.
        ILLAOI = 420,
        /// `39`.
        IRELIA = 39,
        /// `427`.
        IVERN = 427,
        /// `40`.
        JANNA = 40,
        /// `59`.
        JARVAN_IV = 59,
        /// `24`.
        JAX = 24,
        /// `126`.
        JAYCE = 126,
        /// `202`.
        JHIN = 202,
        /// `222`.
        JINX = 222,
        /// `145`.
        KAI_SA = 145,
        /// `429`.
        KALISTA = 429,
        /// `43`.
        KARMA = 43,
        /// `30`.
        KARTHUS = 30,
        /// `38`.
        KASSADIN = 38,
        /// `55`.
        KATARINA = 55,
        /// `10`.
        KAYLE = 10,
        /// `141`.
        KAYN = 141,
        /// `85`.
        KENNEN = 85,
        /// `121`.
        KHA_ZIX = 121,
        /// `203`.
        KINDRED = 203,
        /// `240`.
        KLED = 240,
        /// `96`.
        KOG_MAW = 96,
        /// `7`.
        LE_BLANC = 7,
        /// `64`.
        LEE_SIN = 64,
        /// `89`.
        LEONA = 89,
        /// `876`.
        LILLIA = 876,
        /// `127`.
        LISSANDRA = 127,
        /// `236`.
        LUCIAN = 236,
        /// `117`.
        LULU = 117,
        /// `99`.
        LUX = 99,
        /// `54`.
        MALPHITE = 54,
        /// `90`.
        MALZAHAR = 90,
        /// `57`.
        MAOKAI = 57,
        /// `11`.
        MASTER_YI = 11,
        /// `21`.
        MISS_FORTUNE = 21,
        /// `82`.
        MORDEKAISER = 82,
        /// `25`.
        MORGANA = 25,
        /// `267`.
        NAMI = 267,
        /// `75`.
        NASUS = 75,
        /// `111`.
        NAUTILUS = 111,
        /// `518`.
        NEEKO = 518,
        /// `76`.
        NIDALEE = 76,
        /// `56`.
        NOCTURNE = 56,
        /// `20`.
        NUNU_WILLUMP = 20,
        /// `2`.
        OLAF = 2,
        /// `61`.
        ORIANNA = 61,
        /// `516`.
        ORNN = 516,
        /// `80`.
        PANTHEON = 80,
        /// `78`.
        POPPY = 78,
        /// `555`.
        PYKE = 555,
        /// `246`.
        QIYANA = 246,
        /// `133`.
        QUINN = 133,
        /// `497`.
        RAKAN = 497,
        /// `33`.
        RAMMUS = 33,
        /// `421`.
        REK_SAI = 421,
        /// `526`.
        RELL = 526,
        /// `58`.
        RENEKTON = 58,
        /// `107`.
        RENGAR = 107,
        /// `92`.
        RIVEN = 92,
        /// `68`.
        RUMBLE = 68,
        /// `13`.
        RYZE = 13,
        /// `360`.
        SAMIRA = 360,
        /// `113`.
        SEJUANI = 113,
        /// `235`.
        SENNA = 235,
        /// `147`.
        SERAPHINE = 147,
        /// `875`.
        SETT = 875,
        /// `35`.
        SHACO = 35,
        /// `98`.
        SHEN = 98,
        /// `102`.
        SHYVANA = 102,
        /// `27`.
        SINGED = 27,
        /// `14`.
        SION = 14,
        /// `15`.
        SIVIR = 15,
        /// `72`.
        SKARNER = 72,
        /// `37`.
        SONA = 37,
        /// `16`.
        SORAKA = 16,
        /// `50`.
        SWAIN = 50,
        /// `517`.
        SYLAS = 517,
        /// `134`.
        SYNDRA = 134,
        /// `223`.
        TAHM_KENCH = 223,
        /// `163`.
        TALIYAH = 163,
        /// `91`.
        TALON = 91,
        /// `44`.
        TARIC = 44,
        /// `17`.
        TEEMO = 17,
        /// `412`.
        THRESH = 412,
        /// `18`.
        TRISTANA = 18,
        /// `48`.
        TRUNDLE = 48,
        /// `23`.
        TRYNDAMERE = 23,
        /// `4`.
        TWISTED_FATE = 4,
        /// `29`.
        TWITCH = 29,
        /// `77`.
        UDYR = 77,
        /// `6`.
        URGOT = 6,
        /// `110`.
        VARUS = 110,
        /// `67`.
        VAYNE = 67,
        /// `45`.
        VEIGAR = 45,
        /// `161`.
        VEL_KOZ = 161,
        /// `711`.
        VEX = 711,
        /// `254`.
        VI = 254,
        /// `234`.
        VIEGO = 234,
        /// `112`.
        VIKTOR = 112,
        /// `8`.
        VLADIMIR = 8,
        /// `106`.
        VOLIBEAR = 106,
        /// `19`.
        WARWICK = 19,
        /// `62`.
        WUKONG = 62,
        /// `498`.
        XAYAH = 498,
        /// `101`.
        XERATH = 101,
        /// `5`.
        XIN_ZHAO = 5,
        /// `157`.
        YASUO = 157,
        /// `777`.
        YONE = 777,
        /// `83`.
        YORICK = 83,
        /// `350`.
        YUUMI = 350,
        /// `154`.
        ZAC = 154,
        /// `238`.
        ZED = 238,
        /// `115`.
        ZIGGS = 115,
        /// `26`.
        ZILEAN = 26,
        /// `142`.
        ZOE = 142,
        /// `143`.
        ZYRA = 143,
    }
}

impl Champion {
    /// The champion's name (`en_US` localization).
    pub const fn name(self) -> Option<&'static str> {
        match self {
            Self::AATROX       => Some("Aatrox"),
            Self::AHRI         => Some("Ahri"),
            Self::AKALI        => Some("Akali"),
            Self::AKSHAN       => Some("Akshan"),
            Self::ALISTAR      => Some("Alistar"),
            Self::AMUMU        => Some("Amumu"),
            Self::ANIVIA       => Some("Anivia"),
            Self::ANNIE        => Some("Annie"),
            Self::APHELIOS     => Some("Aphelios"),
            Self::ASHE         => Some("Ashe"),
            Self::AURELION_SOL => Some("Aurelion Sol"),
            Self::AZIR         => Some("Azir"),
            Self::BARD         => Some("Bard"),
            Self::BLITZCRANK   => Some("Blitzcrank"),
            Self::BRAND        => Some("Brand"),
            Self::BRAUM        => Some("Braum"),
            Self::CAITLYN      => Some("Caitlyn"),
            Self::CAMILLE      => Some("Camille"),
            Self::CASSIOPEIA   => Some("Cassiopeia"),
            Self::CHO_GATH     => Some("Cho'Gath"),
            Self::CORKI        => Some("Corki"),
            Self::DARIUS       => Some("Darius"),
            Self::DIANA        => Some("Diana"),
            Self::DR_MUNDO     => Some("Dr. Mundo"),
            Self::DRAVEN       => Some("Draven"),
            Self::EKKO         => Some("Ekko"),
            Self::ELISE        => Some("Elise"),
            Self::EVELYNN      => Some("Evelynn"),
            Self::EZREAL       => Some("Ezreal"),
            Self::FIDDLESTICKS => Some("Fiddlesticks"),
            Self::FIORA        => Some("Fiora"),
            Self::FIZZ         => Some("Fizz"),
            Self::GALIO        => Some("Galio"),
            Self::GANGPLANK    => Some("Gangplank"),
            Self::GAREN        => Some("Garen"),
            Self::GNAR         => Some("Gnar"),
            Self::GRAGAS       => Some("Gragas"),
            Self::GRAVES       => Some("Graves"),
            Self::GWEN         => Some("Gwen"),
            Self::HECARIM      => Some("Hecarim"),
            Self::HEIMERDINGER => Some("Heimerdinger"),
            Self::ILLAOI       => Some("Illaoi"),
            Self::IRELIA       => Some("Irelia"),
            Self::IVERN        => Some("Ivern"),
            Self::JANNA        => Some("Janna"),
            Self::JARVAN_IV    => Some("Jarvan IV"),
            Self::JAX          => Some("Jax"),
            Self::JAYCE        => Some("Jayce"),
            Self::JHIN         => Some("Jhin"),
            Self::JINX         => Some("Jinx"),
            Self::KAI_SA       => Some("Kai'Sa"),
            Self::KALISTA      => Some("Kalista"),
            Self::KARMA        => Some("Karma"),
            Self::KARTHUS      => Some("Karthus"),
            Self::KASSADIN     => Some("Kassadin"),
            Self::KATARINA     => Some("Katarina"),
            Self::KAYLE        => Some("Kayle"),
            Self::KAYN         => Some("Kayn"),
            Self::KENNEN       => Some("Kennen"),
            Self::KHA_ZIX      => Some("Kha'Zix"),
            Self::KINDRED      => Some("Kindred"),
            Self::KLED         => Some("Kled"),
            Self::KOG_MAW      => Some("Kog'Maw"),
            Self::LE_BLANC     => Some("LeBlanc"),
            Self::LEE_SIN      => Some("Lee Sin"),
            Self::LEONA        => Some("Leona"),
            Self::LILLIA       => Some("Lillia"),
            Self::LISSANDRA    => Some("Lissandra"),
            Self::LUCIAN       => Some("Lucian"),
            Self::LULU         => Some("Lulu"),
            Self::LUX          => Some("Lux"),
            Self::MALPHITE     => Some("Malphite"),
            Self::MALZAHAR     => Some("Malzahar"),
            Self::MAOKAI       => Some("Maokai"),
            Self::MASTER_YI    => Some("Master Yi"),
            Self::MISS_FORTUNE => Some("Miss Fortune"),
            Self::MORDEKAISER  => Some("Mordekaiser"),
            Self::MORGANA      => Some("Morgana"),
            Self::NAMI         => Some("Nami"),
            Self::NASUS        => Some("Nasus"),
            Self::NAUTILUS     => Some("Nautilus"),
            Self::NEEKO        => Some("Neeko"),
            Self::NIDALEE      => Some("Nidalee"),
            Self::NOCTURNE     => Some("Nocturne"),
            Self::NUNU_WILLUMP => Some("Nunu & Willump"),
            Self::OLAF         => Some("Olaf"),
            Self::ORIANNA      => Some("Orianna"),
            Self::ORNN         => Some("Ornn"),
            Self::PANTHEON     => Some("Pantheon"),
            Self::POPPY        => Some("Poppy"),
            Self::PYKE         => Some("Pyke"),
            Self::QIYANA       => Some("Qiyana"),
            Self::QUINN        => Some("Quinn"),
            Self::RAKAN        => Some("Rakan"),
            Self::RAMMUS       => Some("Rammus"),
            Self::REK_SAI      => Some("Rek'Sai"),
            Self::RELL         => Some("Rell"),
            Self::RENEKTON     => Some("Renekton"),
            Self::RENGAR       => Some("Rengar"),
            Self::RIVEN        => Some("Riven"),
            Self::RUMBLE       => Some("Rumble"),
            Self::RYZE         => Some("Ryze"),
            Self::SAMIRA       => Some("Samira"),
            Self::SEJUANI      => Some("Sejuani"),
            Self::SENNA        => Some("Senna"),
            Self::SERAPHINE    => Some("Seraphine"),
            Self::SETT         => Some("Sett"),
            Self::SHACO        => Some("Shaco"),
            Self::SHEN         => Some("Shen"),
            Self::SHYVANA      => Some("Shyvana"),
            Self::SINGED       => Some("Singed"),
            Self::SION         => Some("Sion"),
            Self::SIVIR        => Some("Sivir"),
            Self::SKARNER      => Some("Skarner"),
            Self::SONA         => Some("Sona"),
            Self::SORAKA       => Some("Soraka"),
            Self::SWAIN        => Some("Swain"),
            Self::SYLAS        => Some("Sylas"),
            Self::SYNDRA       => Some("Syndra"),
            Self::TAHM_KENCH   => Some("Tahm Kench"),
            Self::TALIYAH      => Some("Taliyah"),
            Self::TALON        => Some("Talon"),
            Self::TARIC        => Some("Taric"),
            Self::TEEMO        => Some("Teemo"),
            Self::THRESH       => Some("Thresh"),
            Self::TRISTANA     => Some("Tristana"),
            Self::TRUNDLE      => Some("Trundle"),
            Self::TRYNDAMERE   => Some("Tryndamere"),
            Self::TWISTED_FATE => Some("Twisted Fate"),
            Self::TWITCH       => Some("Twitch"),
            Self::UDYR         => Some("Udyr"),
            Self::URGOT        => Some("Urgot"),
            Self::VARUS        => Some("Varus"),
            Self::VAYNE        => Some("Vayne"),
            Self::VEIGAR       => Some("Veigar"),
            Self::VEL_KOZ      => Some("Vel'Koz"),
            Self::VEX          => Some("Vex"),
            Self::VI           => Some("Vi"),
            Self::VIEGO        => Some("Viego"),
            Self::VIKTOR       => Some("Viktor"),
            Self::VLADIMIR     => Some("Vladimir"),
            Self::VOLIBEAR     => Some("Volibear"),
            Self::WARWICK      => Some("Warwick"),
            Self::WUKONG       => Some("Wukong"),
            Self::XAYAH        => Some("Xayah"),
            Self::XERATH       => Some("Xerath"),
            Self::XIN_ZHAO     => Some("Xin Zhao"),
            Self::YASUO        => Some("Yasuo"),
            Self::YONE         => Some("Yone"),
            Self::YORICK       => Some("Yorick"),
            Self::YUUMI        => Some("Yuumi"),
            Self::ZAC          => Some("Zac"),
            Self::ZED          => Some("Zed"),
            Self::ZIGGS        => Some("Ziggs"),
            Self::ZILEAN       => Some("Zilean"),
            Self::ZOE          => Some("Zoe"),
            Self::ZYRA         => Some("Zyra"),
            _ => None,
        }
    }

    /// The champion's identifier key. Somtimes called "key", "identifier", or "alias".
    /// This is mainly used in DDragon paths.
    ///
    /// This is generally the `en_US` name with spaces and punctuation removed,
    /// capitalization preserved, however the follow are exceptions:
    ///
    /// Field | Name | Identifier | Id
    /// ---|---|---|---
    /// `CHO_GATH` | "Cho'Gath" | "Chogath" | 31
    /// `FIDDLESTICKS` | "Fiddlesticks" | "FiddleSticks" | 9
    /// `KAI_SA` | "Kai'Sa" | "Kaisa" | 145
    /// `KHA_ZIX` | "Kha'Zix" | "Khazix" | 121
    /// `LE_BLANC` | "LeBlanc" | "Leblanc" | 7
    /// `NUNU_WILLUMP` | "Nunu & Willump" | "Nunu" | 20
    /// `VEL_KOZ` | "Vel'Koz" | "Velkoz" | 161
    /// `WUKONG` | "Wukong" | "MonkeyKing" | 62
    pub const fn identifier(self) -> Option<&'static str> {
        match self {
            Self::AATROX       => Some("Aatrox"),
            Self::AHRI         => Some("Ahri"),
            Self::AKALI        => Some("Akali"),
            Self::AKSHAN       => Some("Akshan"),
            Self::ALISTAR      => Some("Alistar"),
            Self::AMUMU        => Some("Amumu"),
            Self::ANIVIA       => Some("Anivia"),
            Self::ANNIE        => Some("Annie"),
            Self::APHELIOS     => Some("Aphelios"),
            Self::ASHE         => Some("Ashe"),
            Self::AURELION_SOL => Some("AurelionSol"),
            Self::AZIR         => Some("Azir"),
            Self::BARD         => Some("Bard"),
            Self::BLITZCRANK   => Some("Blitzcrank"),
            Self::BRAND        => Some("Brand"),
            Self::BRAUM        => Some("Braum"),
            Self::CAITLYN      => Some("Caitlyn"),
            Self::CAMILLE      => Some("Camille"),
            Self::CASSIOPEIA   => Some("Cassiopeia"),
            Self::CHO_GATH     => Some("Chogath"),
            Self::CORKI        => Some("Corki"),
            Self::DARIUS       => Some("Darius"),
            Self::DIANA        => Some("Diana"),
            Self::DR_MUNDO     => Some("DrMundo"),
            Self::DRAVEN       => Some("Draven"),
            Self::EKKO         => Some("Ekko"),
            Self::ELISE        => Some("Elise"),
            Self::EVELYNN      => Some("Evelynn"),
            Self::EZREAL       => Some("Ezreal"),
            Self::FIDDLESTICKS => Some("FiddleSticks"),
            Self::FIORA        => Some("Fiora"),
            Self::FIZZ         => Some("Fizz"),
            Self::GALIO        => Some("Galio"),
            Self::GANGPLANK    => Some("Gangplank"),
            Self::GAREN        => Some("Garen"),
            Self::GNAR         => Some("Gnar"),
            Self::GRAGAS       => Some("Gragas"),
            Self::GRAVES       => Some("Graves"),
            Self::GWEN         => Some("Gwen"),
            Self::HECARIM      => Some("Hecarim"),
            Self::HEIMERDINGER => Some("Heimerdinger"),
            Self::ILLAOI       => Some("Illaoi"),
            Self::IRELIA       => Some("Irelia"),
            Self::IVERN        => Some("Ivern"),
            Self::JANNA        => Some("Janna"),
            Self::JARVAN_IV    => Some("JarvanIV"),
            Self::JAX          => Some("Jax"),
            Self::JAYCE        => Some("Jayce"),
            Self::JHIN         => Some("Jhin"),
            Self::JINX         => Some("Jinx"),
            Self::KAI_SA       => Some("Kaisa"),
            Self::KALISTA      => Some("Kalista"),
            Self::KARMA        => Some("Karma"),
            Self::KARTHUS      => Some("Karthus"),
            Self::KASSADIN     => Some("Kassadin"),
            Self::KATARINA     => Some("Katarina"),
            Self::KAYLE        => Some("Kayle"),
            Self::KAYN         => Some("Kayn"),
            Self::KENNEN       => Some("Kennen"),
            Self::KHA_ZIX      => Some("Khazix"),
            Self::KINDRED      => Some("Kindred"),
            Self::KLED         => Some("Kled"),
            Self::KOG_MAW      => Some("KogMaw"),
            Self::LE_BLANC     => Some("Leblanc"),
            Self::LEE_SIN      => Some("LeeSin"),
            Self::LEONA        => Some("Leona"),
            Self::LILLIA       => Some("Lillia"),
            Self::LISSANDRA    => Some("Lissandra"),
            Self::LUCIAN       => Some("Lucian"),
            Self::LULU         => Some("Lulu"),
            Self::LUX          => Some("Lux"),
            Self::MALPHITE     => Some("Malphite"),
            Self::MALZAHAR     => Some("Malzahar"),
            Self::MAOKAI       => Some("Maokai"),
            Self::MASTER_YI    => Some("MasterYi"),
            Self::MISS_FORTUNE => Some("MissFortune"),
            Self::MORDEKAISER  => Some("Mordekaiser"),
            Self::MORGANA      => Some("Morgana"),
            Self::NAMI         => Some("Nami"),
            Self::NASUS        => Some("Nasus"),
            Self::NAUTILUS     => Some("Nautilus"),
            Self::NEEKO        => Some("Neeko"),
            Self::NIDALEE      => Some("Nidalee"),
            Self::NOCTURNE     => Some("Nocturne"),
            Self::NUNU_WILLUMP => Some("Nunu"),
            Self::OLAF         => Some("Olaf"),
            Self::ORIANNA      => Some("Orianna"),
            Self::ORNN         => Some("Ornn"),
            Self::PANTHEON     => Some("Pantheon"),
            Self::POPPY        => Some("Poppy"),
            Self::PYKE         => Some("Pyke"),
            Self::QIYANA       => Some("Qiyana"),
            Self::QUINN        => Some("Quinn"),
            Self::RAKAN        => Some("Rakan"),
            Self::RAMMUS       => Some("Rammus"),
            Self::REK_SAI      => Some("RekSai"),
            Self::RELL         => Some("Rell"),
            Self::RENEKTON     => Some("Renekton"),
            Self::RENGAR       => Some("Rengar"),
            Self::RIVEN        => Some("Riven"),
            Self::RUMBLE       => Some("Rumble"),
            Self::RYZE         => Some("Ryze"),
            Self::SAMIRA       => Some("Samira"),
            Self::SEJUANI      => Some("Sejuani"),
            Self::SENNA        => Some("Senna"),
            Self::SERAPHINE    => Some("Seraphine"),
            Self::SETT         => Some("Sett"),
            Self::SHACO        => Some("Shaco"),
            Self::SHEN         => Some("Shen"),
            Self::SHYVANA      => Some("Shyvana"),
            Self::SINGED       => Some("Singed"),
            Self::SION         => Some("Sion"),
            Self::SIVIR        => Some("Sivir"),
            Self::SKARNER      => Some("Skarner"),
            Self::SONA         => Some("Sona"),
            Self::SORAKA       => Some("Soraka"),
            Self::SWAIN        => Some("Swain"),
            Self::SYLAS        => Some("Sylas"),
            Self::SYNDRA       => Some("Syndra"),
            Self::TAHM_KENCH   => Some("TahmKench"),
            Self::TALIYAH      => Some("Taliyah"),
            Self::TALON        => Some("Talon"),
            Self::TARIC        => Some("Taric"),
            Self::TEEMO        => Some("Teemo"),
            Self::THRESH       => Some("Thresh"),
            Self::TRISTANA     => Some("Tristana"),
            Self::TRUNDLE      => Some("Trundle"),
            Self::TRYNDAMERE   => Some("Tryndamere"),
            Self::TWISTED_FATE => Some("TwistedFate"),
            Self::TWITCH       => Some("Twitch"),
            Self::UDYR         => Some("Udyr"),
            Self::URGOT        => Some("Urgot"),
            Self::VARUS        => Some("Varus"),
            Self::VAYNE        => Some("Vayne"),
            Self::VEIGAR       => Some("Veigar"),
            Self::VEL_KOZ      => Some("Velkoz"),
            Self::VEX          => Some("Vex"),
            Self::VI           => Some("Vi"),
            Self::VIEGO        => Some("Viego"),
            Self::VIKTOR       => Some("Viktor"),
            Self::VLADIMIR     => Some("Vladimir"),
            Self::VOLIBEAR     => Some("Volibear"),
            Self::WARWICK      => Some("Warwick"),
            Self::WUKONG       => Some("MonkeyKing"),
            Self::XAYAH        => Some("Xayah"),
            Self::XERATH       => Some("Xerath"),
            Self::XIN_ZHAO     => Some("XinZhao"),
            Self::YASUO        => Some("Yasuo"),
            Self::YONE         => Some("Yone"),
            Self::YORICK       => Some("Yorick"),
            Self::YUUMI        => Some("Yuumi"),
            Self::ZAC          => Some("Zac"),
            Self::ZED          => Some("Zed"),
            Self::ZIGGS        => Some("Ziggs"),
            Self::ZILEAN       => Some("Zilean"),
            Self::ZOE          => Some("Zoe"),
            Self::ZYRA         => Some("Zyra"),
            _ => None,
        }
    }

    /// https://github.com/MingweiSamuel/Riven/issues/36
    pub(crate) fn serialize_result<S>(
        val: &Result<Self, std::num::TryFromIntError>,
        serializer: S,
    ) -> Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::Serialize;
        val.unwrap_or(Champion(-1)).serialize(serializer)
    }

    /// https://github.com/MingweiSamuel/Riven/issues/36
    pub(crate) fn deserialize_result<'de, D>(
        deserializer: D,
    ) -> Result<Result<Self, std::num::TryFromIntError>, D::Error>
    where
        D: serde::de::Deserializer<'de>,
    {
        use std::convert::TryInto;
        <i64 as serde::de::Deserialize>::deserialize(deserializer).map(|id| id.try_into().map(Self))
    }
}

#[derive(Debug)]
pub struct ParseChampionError([char; 4]);
impl std::fmt::Display for ParseChampionError {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        let s: String = self.0.iter().copied().take_while(|&c| '\0' != c).collect();
        write!(f, "Failed to parse unknown champion prefix: {:?}", s)
    }
}
impl std::error::Error for ParseChampionError {}

impl std::str::FromStr for Champion {
    type Err = ParseChampionError;
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        let mut chars = ['\0'; 4];
        s.chars()
            .take(4)
            .filter(|c| c.is_ascii_alphanumeric())
            .map(|c| c.to_ascii_uppercase())
            .enumerate()
            .for_each(|(i, c)| chars[i] = c);
        match chars {
            /* AATR */ [ 'A',  'A',  'T',  'R'] => Ok(Champion::AATROX),
            /* AHRI */ [ 'A',  'H',  'R',  'I'] => Ok(Champion::AHRI),
            /* AKAL */ [ 'A',  'K',  'A',  'L'] => Ok(Champion::AKALI),
            /* AKSH */ [ 'A',  'K',  'S',  'H'] => Ok(Champion::AKSHAN),
            /* ALIS */ [ 'A',  'L',  'I',  'S'] => Ok(Champion::ALISTAR),
            /* AMUM */ [ 'A',  'M',  'U',  'M'] => Ok(Champion::AMUMU),
            /* ANIV */ [ 'A',  'N',  'I',  'V'] => Ok(Champion::ANIVIA),
            /* ANNI */ [ 'A',  'N',  'N',  'I'] => Ok(Champion::ANNIE),
            /* APHE */ [ 'A',  'P',  'H',  'E'] => Ok(Champion::APHELIOS),
            /* ASHE */ [ 'A',  'S',  'H',  'E'] => Ok(Champion::ASHE),
            /* AURE */ [ 'A',  'U',  'R',  'E'] => Ok(Champion::AURELION_SOL),
            /* AZIR */ [ 'A',  'Z',  'I',  'R'] => Ok(Champion::AZIR),
            /* BARD */ [ 'B',  'A',  'R',  'D'] => Ok(Champion::BARD),
            /* BLIT */ [ 'B',  'L',  'I',  'T'] => Ok(Champion::BLITZCRANK),
            /* BRAN */ [ 'B',  'R',  'A',  'N'] => Ok(Champion::BRAND),
            /* BRAU */ [ 'B',  'R',  'A',  'U'] => Ok(Champion::BRAUM),
            /* CAIT */ [ 'C',  'A',  'I',  'T'] => Ok(Champion::CAITLYN),
            /* CAMI */ [ 'C',  'A',  'M',  'I'] => Ok(Champion::CAMILLE),
            /* CASS */ [ 'C',  'A',  'S',  'S'] => Ok(Champion::CASSIOPEIA),
            /* CHOG */ [ 'C',  'H',  'O',  'G'] => Ok(Champion::CHO_GATH),
            /* CHO  */ [ 'C',  'H',  'O', '\0'] => Ok(Champion::CHO_GATH),
            /* CORK */ [ 'C',  'O',  'R',  'K'] => Ok(Champion::CORKI),
            /* DARI */ [ 'D',  'A',  'R',  'I'] => Ok(Champion::DARIUS),
            /* DIAN */ [ 'D',  'I',  'A',  'N'] => Ok(Champion::DIANA),
            /* DRMU */ [ 'D',  'R',  'M',  'U'] => Ok(Champion::DR_MUNDO),
            /* DR   */ [ 'D',  'R', '\0', '\0'] => Ok(Champion::DR_MUNDO),
            /* DRAV */ [ 'D',  'R',  'A',  'V'] => Ok(Champion::DRAVEN),
            /* EKKO */ [ 'E',  'K',  'K',  'O'] => Ok(Champion::EKKO),
            /* ELIS */ [ 'E',  'L',  'I',  'S'] => Ok(Champion::ELISE),
            /* EVEL */ [ 'E',  'V',  'E',  'L'] => Ok(Champion::EVELYNN),
            /* EZRE */ [ 'E',  'Z',  'R',  'E'] => Ok(Champion::EZREAL),
            /* FIDD */ [ 'F',  'I',  'D',  'D'] => Ok(Champion::FIDDLESTICKS),
            /* FIOR */ [ 'F',  'I',  'O',  'R'] => Ok(Champion::FIORA),
            /* FIZZ */ [ 'F',  'I',  'Z',  'Z'] => Ok(Champion::FIZZ),
            /* GALI */ [ 'G',  'A',  'L',  'I'] => Ok(Champion::GALIO),
            /* GANG */ [ 'G',  'A',  'N',  'G'] => Ok(Champion::GANGPLANK),
            /* GARE */ [ 'G',  'A',  'R',  'E'] => Ok(Champion::GAREN),
            /* GNAR */ [ 'G',  'N',  'A',  'R'] => Ok(Champion::GNAR),
            /* GRAG */ [ 'G',  'R',  'A',  'G'] => Ok(Champion::GRAGAS),
            /* GRAV */ [ 'G',  'R',  'A',  'V'] => Ok(Champion::GRAVES),
            /* GWEN */ [ 'G',  'W',  'E',  'N'] => Ok(Champion::GWEN),
            /* HECA */ [ 'H',  'E',  'C',  'A'] => Ok(Champion::HECARIM),
            /* HEIM */ [ 'H',  'E',  'I',  'M'] => Ok(Champion::HEIMERDINGER),
            /* ILLA */ [ 'I',  'L',  'L',  'A'] => Ok(Champion::ILLAOI),
            /* IREL */ [ 'I',  'R',  'E',  'L'] => Ok(Champion::IRELIA),
            /* IVER */ [ 'I',  'V',  'E',  'R'] => Ok(Champion::IVERN),
            /* JANN */ [ 'J',  'A',  'N',  'N'] => Ok(Champion::JANNA),
            /* JARV */ [ 'J',  'A',  'R',  'V'] => Ok(Champion::JARVAN_IV),
            /* JAX  */ [ 'J',  'A',  'X', '\0'] => Ok(Champion::JAX),
            /* JAYC */ [ 'J',  'A',  'Y',  'C'] => Ok(Champion::JAYCE),
            /* JHIN */ [ 'J',  'H',  'I',  'N'] => Ok(Champion::JHIN),
            /* JINX */ [ 'J',  'I',  'N',  'X'] => Ok(Champion::JINX),
            /* KAIS */ [ 'K',  'A',  'I',  'S'] => Ok(Champion::KAI_SA),
            /* KAI  */ [ 'K',  'A',  'I', '\0'] => Ok(Champion::KAI_SA),
            /* KALI */ [ 'K',  'A',  'L',  'I'] => Ok(Champion::KALISTA),
            /* KARM */ [ 'K',  'A',  'R',  'M'] => Ok(Champion::KARMA),
            /* KART */ [ 'K',  'A',  'R',  'T'] => Ok(Champion::KARTHUS),
            /* KASS */ [ 'K',  'A',  'S',  'S'] => Ok(Champion::KASSADIN),
            /* KATA */ [ 'K',  'A',  'T',  'A'] => Ok(Champion::KATARINA),
            /* KAYL */ [ 'K',  'A',  'Y',  'L'] => Ok(Champion::KAYLE),
            /* KAYN */ [ 'K',  'A',  'Y',  'N'] => Ok(Champion::KAYN),
            /* KENN */ [ 'K',  'E',  'N',  'N'] => Ok(Champion::KENNEN),
            /* KHAZ */ [ 'K',  'H',  'A',  'Z'] => Ok(Champion::KHA_ZIX),
            /* KHA  */ [ 'K',  'H',  'A', '\0'] => Ok(Champion::KHA_ZIX),
            /* KIND */ [ 'K',  'I',  'N',  'D'] => Ok(Champion::KINDRED),
            /* KLED */ [ 'K',  'L',  'E',  'D'] => Ok(Champion::KLED),
            /* KOGM */ [ 'K',  'O',  'G',  'M'] => Ok(Champion::KOG_MAW),
            /* KOG  */ [ 'K',  'O',  'G', '\0'] => Ok(Champion::KOG_MAW),
            /* LEBL */ [ 'L',  'E',  'B',  'L'] => Ok(Champion::LE_BLANC),
            /* LEES */ [ 'L',  'E',  'E',  'S'] => Ok(Champion::LEE_SIN),
            /* LEE  */ [ 'L',  'E',  'E', '\0'] => Ok(Champion::LEE_SIN),
            /* LEON */ [ 'L',  'E',  'O',  'N'] => Ok(Champion::LEONA),
            /* LILL */ [ 'L',  'I',  'L',  'L'] => Ok(Champion::LILLIA),
            /* LISS */ [ 'L',  'I',  'S',  'S'] => Ok(Champion::LISSANDRA),
            /* LUCI */ [ 'L',  'U',  'C',  'I'] => Ok(Champion::LUCIAN),
            /* LULU */ [ 'L',  'U',  'L',  'U'] => Ok(Champion::LULU),
            /* LUX  */ [ 'L',  'U',  'X', '\0'] => Ok(Champion::LUX),
            /* MALP */ [ 'M',  'A',  'L',  'P'] => Ok(Champion::MALPHITE),
            /* MALZ */ [ 'M',  'A',  'L',  'Z'] => Ok(Champion::MALZAHAR),
            /* MAOK */ [ 'M',  'A',  'O',  'K'] => Ok(Champion::MAOKAI),
            /* MAST */ [ 'M',  'A',  'S',  'T'] => Ok(Champion::MASTER_YI),
            /* MISS */ [ 'M',  'I',  'S',  'S'] => Ok(Champion::MISS_FORTUNE),
            /* MORD */ [ 'M',  'O',  'R',  'D'] => Ok(Champion::MORDEKAISER),
            /* MORG */ [ 'M',  'O',  'R',  'G'] => Ok(Champion::MORGANA),
            /* NAMI */ [ 'N',  'A',  'M',  'I'] => Ok(Champion::NAMI),
            /* NASU */ [ 'N',  'A',  'S',  'U'] => Ok(Champion::NASUS),
            /* NAUT */ [ 'N',  'A',  'U',  'T'] => Ok(Champion::NAUTILUS),
            /* NEEK */ [ 'N',  'E',  'E',  'K'] => Ok(Champion::NEEKO),
            /* NIDA */ [ 'N',  'I',  'D',  'A'] => Ok(Champion::NIDALEE),
            /* NOCT */ [ 'N',  'O',  'C',  'T'] => Ok(Champion::NOCTURNE),
            /* NUNU */ [ 'N',  'U',  'N',  'U'] => Ok(Champion::NUNU_WILLUMP),
            /* OLAF */ [ 'O',  'L',  'A',  'F'] => Ok(Champion::OLAF),
            /* ORIA */ [ 'O',  'R',  'I',  'A'] => Ok(Champion::ORIANNA),
            /* ORNN */ [ 'O',  'R',  'N',  'N'] => Ok(Champion::ORNN),
            /* PANT */ [ 'P',  'A',  'N',  'T'] => Ok(Champion::PANTHEON),
            /* POPP */ [ 'P',  'O',  'P',  'P'] => Ok(Champion::POPPY),
            /* PYKE */ [ 'P',  'Y',  'K',  'E'] => Ok(Champion::PYKE),
            /* QIYA */ [ 'Q',  'I',  'Y',  'A'] => Ok(Champion::QIYANA),
            /* QUIN */ [ 'Q',  'U',  'I',  'N'] => Ok(Champion::QUINN),
            /* RAKA */ [ 'R',  'A',  'K',  'A'] => Ok(Champion::RAKAN),
            /* RAMM */ [ 'R',  'A',  'M',  'M'] => Ok(Champion::RAMMUS),
            /* REKS */ [ 'R',  'E',  'K',  'S'] => Ok(Champion::REK_SAI),
            /* REK  */ [ 'R',  'E',  'K', '\0'] => Ok(Champion::REK_SAI),
            /* RELL */ [ 'R',  'E',  'L',  'L'] => Ok(Champion::RELL),
            /* RENE */ [ 'R',  'E',  'N',  'E'] => Ok(Champion::RENEKTON),
            /* RENG */ [ 'R',  'E',  'N',  'G'] => Ok(Champion::RENGAR),
            /* RIVE */ [ 'R',  'I',  'V',  'E'] => Ok(Champion::RIVEN),
            /* RUMB */ [ 'R',  'U',  'M',  'B'] => Ok(Champion::RUMBLE),
            /* RYZE */ [ 'R',  'Y',  'Z',  'E'] => Ok(Champion::RYZE),
            /* SAMI */ [ 'S',  'A',  'M',  'I'] => Ok(Champion::SAMIRA),
            /* SEJU */ [ 'S',  'E',  'J',  'U'] => Ok(Champion::SEJUANI),
            /* SENN */ [ 'S',  'E',  'N',  'N'] => Ok(Champion::SENNA),
            /* SERA */ [ 'S',  'E',  'R',  'A'] => Ok(Champion::SERAPHINE),
            /* SETT */ [ 'S',  'E',  'T',  'T'] => Ok(Champion::SETT),
            /* SHAC */ [ 'S',  'H',  'A',  'C'] => Ok(Champion::SHACO),
            /* SHEN */ [ 'S',  'H',  'E',  'N'] => Ok(Champion::SHEN),
            /* SHYV */ [ 'S',  'H',  'Y',  'V'] => Ok(Champion::SHYVANA),
            /* SING */ [ 'S',  'I',  'N',  'G'] => Ok(Champion::SINGED),
            /* SION */ [ 'S',  'I',  'O',  'N'] => Ok(Champion::SION),
            /* SIVI */ [ 'S',  'I',  'V',  'I'] => Ok(Champion::SIVIR),
            /* SKAR */ [ 'S',  'K',  'A',  'R'] => Ok(Champion::SKARNER),
            /* SONA */ [ 'S',  'O',  'N',  'A'] => Ok(Champion::SONA),
            /* SORA */ [ 'S',  'O',  'R',  'A'] => Ok(Champion::SORAKA),
            /* SWAI */ [ 'S',  'W',  'A',  'I'] => Ok(Champion::SWAIN),
            /* SYLA */ [ 'S',  'Y',  'L',  'A'] => Ok(Champion::SYLAS),
            /* SYND */ [ 'S',  'Y',  'N',  'D'] => Ok(Champion::SYNDRA),
            /* TAHM */ [ 'T',  'A',  'H',  'M'] => Ok(Champion::TAHM_KENCH),
            /* TALI */ [ 'T',  'A',  'L',  'I'] => Ok(Champion::TALIYAH),
            /* TALO */ [ 'T',  'A',  'L',  'O'] => Ok(Champion::TALON),
            /* TARI */ [ 'T',  'A',  'R',  'I'] => Ok(Champion::TARIC),
            /* TEEM */ [ 'T',  'E',  'E',  'M'] => Ok(Champion::TEEMO),
            /* THRE */ [ 'T',  'H',  'R',  'E'] => Ok(Champion::THRESH),
            /* TRIS */ [ 'T',  'R',  'I',  'S'] => Ok(Champion::TRISTANA),
            /* TRUN */ [ 'T',  'R',  'U',  'N'] => Ok(Champion::TRUNDLE),
            /* TRYN */ [ 'T',  'R',  'Y',  'N'] => Ok(Champion::TRYNDAMERE),
            /* TWIS */ [ 'T',  'W',  'I',  'S'] => Ok(Champion::TWISTED_FATE),
            /* TWIT */ [ 'T',  'W',  'I',  'T'] => Ok(Champion::TWITCH),
            /* UDYR */ [ 'U',  'D',  'Y',  'R'] => Ok(Champion::UDYR),
            /* URGO */ [ 'U',  'R',  'G',  'O'] => Ok(Champion::URGOT),
            /* VARU */ [ 'V',  'A',  'R',  'U'] => Ok(Champion::VARUS),
            /* VAYN */ [ 'V',  'A',  'Y',  'N'] => Ok(Champion::VAYNE),
            /* VEIG */ [ 'V',  'E',  'I',  'G'] => Ok(Champion::VEIGAR),
            /* VELK */ [ 'V',  'E',  'L',  'K'] => Ok(Champion::VEL_KOZ),
            /* VEL  */ [ 'V',  'E',  'L', '\0'] => Ok(Champion::VEL_KOZ),
            /* VEX  */ [ 'V',  'E',  'X', '\0'] => Ok(Champion::VEX),
            /* VI   */ [ 'V',  'I', '\0', '\0'] => Ok(Champion::VI),
            /* VIEG */ [ 'V',  'I',  'E',  'G'] => Ok(Champion::VIEGO),
            /* VIKT */ [ 'V',  'I',  'K',  'T'] => Ok(Champion::VIKTOR),
            /* VLAD */ [ 'V',  'L',  'A',  'D'] => Ok(Champion::VLADIMIR),
            /* VOLI */ [ 'V',  'O',  'L',  'I'] => Ok(Champion::VOLIBEAR),
            /* WARW */ [ 'W',  'A',  'R',  'W'] => Ok(Champion::WARWICK),
            /* WUKO */ [ 'W',  'U',  'K',  'O'] => Ok(Champion::WUKONG),
            /* MONK */ [ 'M',  'O',  'N',  'K'] => Ok(Champion::WUKONG),
            /* XAYA */ [ 'X',  'A',  'Y',  'A'] => Ok(Champion::XAYAH),
            /* XERA */ [ 'X',  'E',  'R',  'A'] => Ok(Champion::XERATH),
            /* XINZ */ [ 'X',  'I',  'N',  'Z'] => Ok(Champion::XIN_ZHAO),
            /* XIN  */ [ 'X',  'I',  'N', '\0'] => Ok(Champion::XIN_ZHAO),
            /* YASU */ [ 'Y',  'A',  'S',  'U'] => Ok(Champion::YASUO),
            /* YONE */ [ 'Y',  'O',  'N',  'E'] => Ok(Champion::YONE),
            /* YORI */ [ 'Y',  'O',  'R',  'I'] => Ok(Champion::YORICK),
            /* YUUM */ [ 'Y',  'U',  'U',  'M'] => Ok(Champion::YUUMI),
            /* ZAC  */ [ 'Z',  'A',  'C', '\0'] => Ok(Champion::ZAC),
            /* ZED  */ [ 'Z',  'E',  'D', '\0'] => Ok(Champion::ZED),
            /* ZIGG */ [ 'Z',  'I',  'G',  'G'] => Ok(Champion::ZIGGS),
            /* ZILE */ [ 'Z',  'I',  'L',  'E'] => Ok(Champion::ZILEAN),
            /* ZOE  */ [ 'Z',  'O',  'E', '\0'] => Ok(Champion::ZOE),
            /* ZYRA */ [ 'Z',  'Y',  'R',  'A'] => Ok(Champion::ZYRA),
            unknown => Err(ParseChampionError(unknown)),
        }
    }
}

impl std::convert::TryFrom<&str> for Champion {
    type Error = <Self as std::str::FromStr>::Err;
    fn try_from(value: &str) -> Result<Self, Self::Error> {
        <Self as std::str::FromStr>::from_str(value)
    }
}
