///////////////////////////////////////////////
//                                           //
//                     !                     //
//   This file is automatically generated!   //
//           Do not directly edit!           //
//                                           //
///////////////////////////////////////////////

// http://www.mingweisamuel.com/riotapi-schema/tool/
// Version 653f68e2d03da44548ff93bc4ffe558e5e70e906

//! Automatically generated endpoint handles.

use crate::models::*;

use std::future::Future;
use std::vec::Vec;

#[cfg(feature="tracing")]
use tracing::Instrument;
use reqwest::Method;

use crate::Result;
use crate::consts::{ RegionalRoute, PlatformRoute, ValPlatformRoute };
use crate::riot_api::RiotApi;

impl RiotApi {
    /// Returns a handle for accessing [AccountV1](crate::endpoints::AccountV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#account-v1" target="_blank">`account-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn account_v1(&self) -> AccountV1 {
        AccountV1 { base: self }
    }
    /// Returns a handle for accessing [ChampionMasteryV4](crate::endpoints::ChampionMasteryV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#champion-mastery-v4" target="_blank">`champion-mastery-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn champion_mastery_v4(&self) -> ChampionMasteryV4 {
        ChampionMasteryV4 { base: self }
    }
    /// Returns a handle for accessing [ChampionV3](crate::endpoints::ChampionV3) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#champion-v3" target="_blank">`champion-v3`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn champion_v3(&self) -> ChampionV3 {
        ChampionV3 { base: self }
    }
    /// Returns a handle for accessing [ClashV1](crate::endpoints::ClashV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#clash-v1" target="_blank">`clash-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn clash_v1(&self) -> ClashV1 {
        ClashV1 { base: self }
    }
    /// Returns a handle for accessing [LeagueExpV4](crate::endpoints::LeagueExpV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#league-exp-v4" target="_blank">`league-exp-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn league_exp_v4(&self) -> LeagueExpV4 {
        LeagueExpV4 { base: self }
    }
    /// Returns a handle for accessing [LeagueV4](crate::endpoints::LeagueV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#league-v4" target="_blank">`league-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn league_v4(&self) -> LeagueV4 {
        LeagueV4 { base: self }
    }
    /// Returns a handle for accessing [LolStatusV3](crate::endpoints::LolStatusV3) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lol-status-v3" target="_blank">`lol-status-v3`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lol_status_v3(&self) -> LolStatusV3 {
        LolStatusV3 { base: self }
    }
    /// Returns a handle for accessing [LolStatusV4](crate::endpoints::LolStatusV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lol-status-v4" target="_blank">`lol-status-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lol_status_v4(&self) -> LolStatusV4 {
        LolStatusV4 { base: self }
    }
    /// Returns a handle for accessing [LorDeckV1](crate::endpoints::LorDeckV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-deck-v1" target="_blank">`lor-deck-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_deck_v1(&self) -> LorDeckV1 {
        LorDeckV1 { base: self }
    }
    /// Returns a handle for accessing [LorInventoryV1](crate::endpoints::LorInventoryV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-inventory-v1" target="_blank">`lor-inventory-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_inventory_v1(&self) -> LorInventoryV1 {
        LorInventoryV1 { base: self }
    }
    /// Returns a handle for accessing [LorMatchV1](crate::endpoints::LorMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-match-v1" target="_blank">`lor-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_match_v1(&self) -> LorMatchV1 {
        LorMatchV1 { base: self }
    }
    /// Returns a handle for accessing [LorRankedV1](crate::endpoints::LorRankedV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-ranked-v1" target="_blank">`lor-ranked-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_ranked_v1(&self) -> LorRankedV1 {
        LorRankedV1 { base: self }
    }
    /// Returns a handle for accessing [LorStatusV1](crate::endpoints::LorStatusV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-status-v1" target="_blank">`lor-status-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_status_v1(&self) -> LorStatusV1 {
        LorStatusV1 { base: self }
    }
    /// Returns a handle for accessing [MatchV4](crate::endpoints::MatchV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#match-v4" target="_blank">`match-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn match_v4(&self) -> MatchV4 {
        MatchV4 { base: self }
    }
    /// Returns a handle for accessing [MatchV5](crate::endpoints::MatchV5) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#match-v5" target="_blank">`match-v5`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn match_v5(&self) -> MatchV5 {
        MatchV5 { base: self }
    }
    /// Returns a handle for accessing [SpectatorV4](crate::endpoints::SpectatorV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#spectator-v4" target="_blank">`spectator-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn spectator_v4(&self) -> SpectatorV4 {
        SpectatorV4 { base: self }
    }
    /// Returns a handle for accessing [SummonerV4](crate::endpoints::SummonerV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#summoner-v4" target="_blank">`summoner-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn summoner_v4(&self) -> SummonerV4 {
        SummonerV4 { base: self }
    }
    /// Returns a handle for accessing [TftLeagueV1](crate::endpoints::TftLeagueV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-league-v1" target="_blank">`tft-league-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_league_v1(&self) -> TftLeagueV1 {
        TftLeagueV1 { base: self }
    }
    /// Returns a handle for accessing [TftMatchV1](crate::endpoints::TftMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-match-v1" target="_blank">`tft-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_match_v1(&self) -> TftMatchV1 {
        TftMatchV1 { base: self }
    }
    /// Returns a handle for accessing [TftSummonerV1](crate::endpoints::TftSummonerV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-summoner-v1" target="_blank">`tft-summoner-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_summoner_v1(&self) -> TftSummonerV1 {
        TftSummonerV1 { base: self }
    }
    /// Returns a handle for accessing [ThirdPartyCodeV4](crate::endpoints::ThirdPartyCodeV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#third-party-code-v4" target="_blank">`third-party-code-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn third_party_code_v4(&self) -> ThirdPartyCodeV4 {
        ThirdPartyCodeV4 { base: self }
    }
    /// Returns a handle for accessing [TournamentStubV4](crate::endpoints::TournamentStubV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tournament-stub-v4" target="_blank">`tournament-stub-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tournament_stub_v4(&self) -> TournamentStubV4 {
        TournamentStubV4 { base: self }
    }
    /// Returns a handle for accessing [TournamentV4](crate::endpoints::TournamentV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tournament-v4" target="_blank">`tournament-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tournament_v4(&self) -> TournamentV4 {
        TournamentV4 { base: self }
    }
    /// Returns a handle for accessing [ValContentV1](crate::endpoints::ValContentV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-content-v1" target="_blank">`val-content-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_content_v1(&self) -> ValContentV1 {
        ValContentV1 { base: self }
    }
    /// Returns a handle for accessing [ValMatchV1](crate::endpoints::ValMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-match-v1" target="_blank">`val-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_match_v1(&self) -> ValMatchV1 {
        ValMatchV1 { base: self }
    }
    /// Returns a handle for accessing [ValRankedV1](crate::endpoints::ValRankedV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-ranked-v1" target="_blank">`val-ranked-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_ranked_v1(&self) -> ValRankedV1 {
        ValRankedV1 { base: self }
    }
    /// Returns a handle for accessing [ValStatusV1](crate::endpoints::ValStatusV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-status-v1" target="_blank">`val-status-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_status_v1(&self) -> ValStatusV1 {
        ValStatusV1 { base: self }
    }
}

/// AccountV1 endpoints handle, accessed by calling [`account_v1()`](crate::RiotApi::account_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#account-v1" target="_blank">`account-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct AccountV1<'a> {
    base: &'a RiotApi,
}
impl<'a> AccountV1<'a> {
    /// Get account by puuid
    /// # Parameters
    /// * `route` - Route to query.
    /// * `puuid` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getByPuuid" target="_blank">`account-v1.getByPuuid`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, route: RegionalRoute, puuid: &str)
        -> impl Future<Output = Result<account_v1::Account>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/riot/account/v1/accounts/by-puuid/{}", puuid));
        let future = self.base.execute_val::<account_v1::Account>("account-v1.getByPuuid", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("account-v1.getByPuuid"));
        future
    }

    /// Get account by riot id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tag_line` (required, in path) - When querying for a player by their riot id, the gameName and tagLine query params are required. However not all accounts have a gameName and tagLine associated so these fields may not be included in the response.
    /// * `game_name` (required, in path) - When querying for a player by their riot id, the gameName and tagLine query params are required. However not all accounts have a gameName and tagLine associated so these fields may not be included in the response.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getByRiotId" target="_blank">`account-v1.getByRiotId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_riot_id(&self, route: RegionalRoute, game_name: &str, tag_line: &str)
        -> impl Future<Output = Result<Option<account_v1::Account>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/riot/account/v1/accounts/by-riot-id/{}/{}", game_name, tag_line));
        let future = self.base.execute_opt::<account_v1::Account>("account-v1.getByRiotId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("account-v1.getByRiotId"));
        future
    }

    /// Get account by access token
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (required, in header)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getByAccessToken" target="_blank">`account-v1.getByAccessToken`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_access_token(&self, route: RegionalRoute, authorization: &str)
        -> impl Future<Output = Result<account_v1::Account>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/riot/account/v1/accounts/me");
        let request = request.header("Authorization", authorization);
        let future = self.base.execute_val::<account_v1::Account>("account-v1.getByAccessToken", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("account-v1.getByAccessToken"));
        future
    }

    /// Get active shard for a player
    /// # Parameters
    /// * `route` - Route to query.
    /// * `game` (required, in path)
    /// * `puuid` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getActiveShard" target="_blank">`account-v1.getActiveShard`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_active_shard(&self, route: RegionalRoute, game: &str, puuid: &str)
        -> impl Future<Output = Result<Option<account_v1::ActiveShard>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/riot/account/v1/active-shards/by-game/{}/by-puuid/{}", game, puuid));
        let future = self.base.execute_opt::<account_v1::ActiveShard>("account-v1.getActiveShard", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("account-v1.getActiveShard"));
        future
    }

}

/// ChampionMasteryV4 endpoints handle, accessed by calling [`champion_mastery_v4()`](crate::RiotApi::champion_mastery_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#champion-mastery-v4" target="_blank">`champion-mastery-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ChampionMasteryV4<'a> {
    base: &'a RiotApi,
}
impl<'a> ChampionMasteryV4<'a> {
    /// Get all champion mastery entries sorted by number of champion points descending,
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path) - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getAllChampionMasteries" target="_blank">`champion-mastery-v4.getAllChampionMasteries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_all_champion_masteries(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Vec<champion_mastery_v4::ChampionMastery>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/champion-mastery/v4/champion-masteries/by-summoner/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<Vec<champion_mastery_v4::ChampionMastery>>("champion-mastery-v4.getAllChampionMasteries", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("champion-mastery-v4.getAllChampionMasteries"));
        future
    }

    /// Get a champion mastery by player ID and champion ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `champion_id` (required, in path) - Champion ID to retrieve Champion Mastery for
    /// * `encrypted_summoner_id` (required, in path) - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getChampionMastery" target="_blank">`champion-mastery-v4.getChampionMastery`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_mastery(&self, route: PlatformRoute, encrypted_summoner_id: &str, champion_id: crate::consts::Champion)
        -> impl Future<Output = Result<Option<champion_mastery_v4::ChampionMastery>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/champion-mastery/v4/champion-masteries/by-summoner/{}/by-champion/{}", encrypted_summoner_id, champion_id));
        let future = self.base.execute_opt::<champion_mastery_v4::ChampionMastery>("champion-mastery-v4.getChampionMastery", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("champion-mastery-v4.getChampionMastery"));
        future
    }

    /// Get a player's total champion mastery score, which is the sum of individual champion mastery levels.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path) - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getChampionMasteryScore" target="_blank">`champion-mastery-v4.getChampionMasteryScore`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_mastery_score(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/champion-mastery/v4/scores/by-summoner/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<i32>("champion-mastery-v4.getChampionMasteryScore", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("champion-mastery-v4.getChampionMasteryScore"));
        future
    }

}

/// ChampionV3 endpoints handle, accessed by calling [`champion_v3()`](crate::RiotApi::champion_v3) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#champion-v3" target="_blank">`champion-v3`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ChampionV3<'a> {
    base: &'a RiotApi,
}
impl<'a> ChampionV3<'a> {
    /// Returns champion rotations, including free-to-play and low-level free-to-play rotations (REST)
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-v3/GET_getChampionInfo" target="_blank">`champion-v3.getChampionInfo`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_info(&self, route: PlatformRoute)
        -> impl Future<Output = Result<champion_v3::ChampionInfo>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/platform/v3/champion-rotations");
        let future = self.base.execute_val::<champion_v3::ChampionInfo>("champion-v3.getChampionInfo", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("champion-v3.getChampionInfo"));
        future
    }

}

/// ClashV1 endpoints handle, accessed by calling [`clash_v1()`](crate::RiotApi::clash_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#clash-v1" target="_blank">`clash-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ClashV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ClashV1<'a> {
    /// Get players by summoner ID.
    /// ## Implementation Notes
    /// This endpoint returns a list of active Clash players for a given summoner ID. If a summoner registers for multiple tournaments at the same time (e.g., Saturday and Sunday) then both registrations would appear in this list.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `summoner_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getPlayersBySummoner" target="_blank">`clash-v1.getPlayersBySummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_players_by_summoner(&self, route: PlatformRoute, summoner_id: &str)
        -> impl Future<Output = Result<Vec<clash_v1::Player>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/clash/v1/players/by-summoner/{}", summoner_id));
        let future = self.base.execute_val::<Vec<clash_v1::Player>>("clash-v1.getPlayersBySummoner", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("clash-v1.getPlayersBySummoner"));
        future
    }

    /// Get team by ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `team_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTeamById" target="_blank">`clash-v1.getTeamById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_team_by_id(&self, route: PlatformRoute, team_id: &str)
        -> impl Future<Output = Result<Option<clash_v1::Team>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/clash/v1/teams/{}", team_id));
        let future = self.base.execute_opt::<clash_v1::Team>("clash-v1.getTeamById", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("clash-v1.getTeamById"));
        future
    }

    /// Get all active or upcoming tournaments.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournaments" target="_blank">`clash-v1.getTournaments`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournaments(&self, route: PlatformRoute)
        -> impl Future<Output = Result<Vec<clash_v1::Tournament>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/clash/v1/tournaments");
        let future = self.base.execute_val::<Vec<clash_v1::Tournament>>("clash-v1.getTournaments", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("clash-v1.getTournaments"));
        future
    }

    /// Get tournament by team ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `team_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournamentByTeam" target="_blank">`clash-v1.getTournamentByTeam`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_by_team(&self, route: PlatformRoute, team_id: &str)
        -> impl Future<Output = Result<Option<clash_v1::Tournament>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/clash/v1/tournaments/by-team/{}", team_id));
        let future = self.base.execute_opt::<clash_v1::Tournament>("clash-v1.getTournamentByTeam", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("clash-v1.getTournamentByTeam"));
        future
    }

    /// Get tournament by ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournamentById" target="_blank">`clash-v1.getTournamentById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_by_id(&self, route: PlatformRoute, tournament_id: i32)
        -> impl Future<Output = Result<Option<clash_v1::Tournament>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/clash/v1/tournaments/{}", tournament_id));
        let future = self.base.execute_opt::<clash_v1::Tournament>("clash-v1.getTournamentById", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("clash-v1.getTournamentById"));
        future
    }

}

/// LeagueExpV4 endpoints handle, accessed by calling [`league_exp_v4()`](crate::RiotApi::league_exp_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#league-exp-v4" target="_blank">`league-exp-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LeagueExpV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LeagueExpV4<'a> {
    /// Get all the league entries.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path) - Note that the queue value must be a valid ranked queue.
    /// * `tier` (required, in path)
    /// * `division` (required, in path)
    /// * `page` (optional, in query) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-exp-v4/GET_getLeagueEntries" target="_blank">`league-exp-v4.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, route: PlatformRoute, queue: crate::consts::QueueType, tier: crate::consts::Tier, division: crate::consts::Division, page: Option<i32>)
        -> impl Future<Output = Result<Vec<league_exp_v4::LeagueEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league-exp/v4/entries/{}/{}/{}", queue, tier, division));
        let mut request = request; if let Some(page) = page { request = request.query(&[ ("page", page) ]); }
        let future = self.base.execute_val::<Vec<league_exp_v4::LeagueEntry>>("league-exp-v4.getLeagueEntries", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-exp-v4.getLeagueEntries"));
        future
    }

}

/// LeagueV4 endpoints handle, accessed by calling [`league_v4()`](crate::RiotApi::league_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#league-v4" target="_blank">`league-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LeagueV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LeagueV4<'a> {
    /// Get the challenger league for given queue.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getChallengerLeague" target="_blank">`league-v4.getChallengerLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_challenger_league(&self, route: PlatformRoute, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/challengerleagues/by-queue/{}", queue));
        let future = self.base.execute_val::<league_v4::LeagueList>("league-v4.getChallengerLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getChallengerLeague"));
        future
    }

    /// Get league entries in all queues for a given summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueEntriesForSummoner" target="_blank">`league-v4.getLeagueEntriesForSummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries_for_summoner(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Vec<league_v4::LeagueEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/entries/by-summoner/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<Vec<league_v4::LeagueEntry>>("league-v4.getLeagueEntriesForSummoner", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getLeagueEntriesForSummoner"));
        future
    }

    /// Get all the league entries.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `division` (required, in path)
    /// * `tier` (required, in path)
    /// * `queue` (required, in path) - Note that the queue value must be a valid ranked queue.
    /// * `page` (optional, in query) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueEntries" target="_blank">`league-v4.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, route: PlatformRoute, queue: crate::consts::QueueType, tier: crate::consts::Tier, division: crate::consts::Division, page: Option<i32>)
        -> impl Future<Output = Result<Vec<league_v4::LeagueEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/entries/{}/{}/{}", queue, tier, division));
        let mut request = request; if let Some(page) = page { request = request.query(&[ ("page", page) ]); }
        let future = self.base.execute_val::<Vec<league_v4::LeagueEntry>>("league-v4.getLeagueEntries", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getLeagueEntries"));
        future
    }

    /// Get the grandmaster league of a specific queue.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getGrandmasterLeague" target="_blank">`league-v4.getGrandmasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_grandmaster_league(&self, route: PlatformRoute, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/grandmasterleagues/by-queue/{}", queue));
        let future = self.base.execute_val::<league_v4::LeagueList>("league-v4.getGrandmasterLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getGrandmasterLeague"));
        future
    }

    /// Get league with given ID, including inactive entries.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `league_id` (required, in path) - The UUID of the league.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueById" target="_blank">`league-v4.getLeagueById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_by_id(&self, route: PlatformRoute, league_id: &str)
        -> impl Future<Output = Result<Option<league_v4::LeagueList>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/leagues/{}", league_id));
        let future = self.base.execute_opt::<league_v4::LeagueList>("league-v4.getLeagueById", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getLeagueById"));
        future
    }

    /// Get the master league for given queue.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getMasterLeague" target="_blank">`league-v4.getMasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_master_league(&self, route: PlatformRoute, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/league/v4/masterleagues/by-queue/{}", queue));
        let future = self.base.execute_val::<league_v4::LeagueList>("league-v4.getMasterLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("league-v4.getMasterLeague"));
        future
    }

}

/// LolStatusV3 endpoints handle, accessed by calling [`lol_status_v3()`](crate::RiotApi::lol_status_v3) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lol-status-v3" target="_blank">`lol-status-v3`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LolStatusV3<'a> {
    base: &'a RiotApi,
}
impl<'a> LolStatusV3<'a> {
    /// Get League of Legends status for the given shard.
    /// ## Rate Limit Notes
    /// Requests to this API are not counted against the application Rate Limits.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lol-status-v3/GET_getShardData" target="_blank">`lol-status-v3.getShardData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_shard_data(&self, route: PlatformRoute)
        -> impl Future<Output = Result<lol_status_v3::ShardStatus>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/status/v3/shard-data");
        let future = self.base.execute_val::<lol_status_v3::ShardStatus>("lol-status-v3.getShardData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lol-status-v3.getShardData"));
        future
    }

}

/// LolStatusV4 endpoints handle, accessed by calling [`lol_status_v4()`](crate::RiotApi::lol_status_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lol-status-v4" target="_blank">`lol-status-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LolStatusV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LolStatusV4<'a> {
    /// Get League of Legends status for the given platform.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lol-status-v4/GET_getPlatformData" target="_blank">`lol-status-v4.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, route: PlatformRoute)
        -> impl Future<Output = Result<lol_status_v4::PlatformData>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/status/v4/platform-data");
        let future = self.base.execute_val::<lol_status_v4::PlatformData>("lol-status-v4.getPlatformData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lol-status-v4.getPlatformData"));
        future
    }

}

/// LorDeckV1 endpoints handle, accessed by calling [`lor_deck_v1()`](crate::RiotApi::lor_deck_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-deck-v1" target="_blank">`lor-deck-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LorDeckV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorDeckV1<'a> {
    /// Get a list of the calling user's decks.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (required, in header)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-deck-v1/GET_getDecks" target="_blank">`lor-deck-v1.getDecks`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_decks(&self, route: RegionalRoute, authorization: &str)
        -> impl Future<Output = Result<Vec<lor_deck_v1::Deck>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lor/deck/v1/decks/me");
        let request = request.header("Authorization", authorization);
        let future = self.base.execute_val::<Vec<lor_deck_v1::Deck>>("lor-deck-v1.getDecks", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-deck-v1.getDecks"));
        future
    }

    /// Create a new deck for the calling user.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (required, in header)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-deck-v1/POST_createDeck" target="_blank">`lor-deck-v1.createDeck`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn create_deck(&self, route: RegionalRoute, body: &lor_deck_v1::NewDeck, authorization: &str)
        -> impl Future<Output = Result<String>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lor/deck/v1/decks/me");
        let request = request.header("Authorization", authorization);
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<String>("lor-deck-v1.createDeck", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-deck-v1.createDeck"));
        future
    }

}

/// LorInventoryV1 endpoints handle, accessed by calling [`lor_inventory_v1()`](crate::RiotApi::lor_inventory_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-inventory-v1" target="_blank">`lor-inventory-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LorInventoryV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorInventoryV1<'a> {
    /// Return a list of cards owned by the calling user.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (required, in header)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-inventory-v1/GET_getCards" target="_blank">`lor-inventory-v1.getCards`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_cards(&self, route: RegionalRoute, authorization: &str)
        -> impl Future<Output = Result<Vec<lor_inventory_v1::Card>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lor/inventory/v1/cards/me");
        let request = request.header("Authorization", authorization);
        let future = self.base.execute_val::<Vec<lor_inventory_v1::Card>>("lor-inventory-v1.getCards", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-inventory-v1.getCards"));
        future
    }

}

/// LorMatchV1 endpoints handle, accessed by calling [`lor_match_v1()`](crate::RiotApi::lor_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-match-v1" target="_blank">`lor-match-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LorMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorMatchV1<'a> {
    /// Get a list of match ids by PUUID
    /// # Parameters
    /// * `route` - Route to query.
    /// * `puuid` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-match-v1/GET_getMatchIdsByPUUID" target="_blank">`lor-match-v1.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, route: RegionalRoute, puuid: &str)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lor/match/v1/matches/by-puuid/{}/ids", puuid));
        let future = self.base.execute_val::<Vec<String>>("lor-match-v1.getMatchIdsByPUUID", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-match-v1.getMatchIdsByPUUID"));
        future
    }

    /// Get match by id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-match-v1/GET_getMatch" target="_blank">`lor-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, route: RegionalRoute, match_id: &str)
        -> impl Future<Output = Result<lor_match_v1::Match>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lor/match/v1/matches/{}", match_id));
        let future = self.base.execute_val::<lor_match_v1::Match>("lor-match-v1.getMatch", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-match-v1.getMatch"));
        future
    }

}

/// LorRankedV1 endpoints handle, accessed by calling [`lor_ranked_v1()`](crate::RiotApi::lor_ranked_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-ranked-v1" target="_blank">`lor-ranked-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LorRankedV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorRankedV1<'a> {
    /// Get the players in Master tier.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-ranked-v1/GET_getLeaderboards" target="_blank">`lor-ranked-v1.getLeaderboards`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_leaderboards(&self, route: RegionalRoute)
        -> impl Future<Output = Result<lor_ranked_v1::Leaderboard>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lor/ranked/v1/leaderboards");
        let future = self.base.execute_val::<lor_ranked_v1::Leaderboard>("lor-ranked-v1.getLeaderboards", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-ranked-v1.getLeaderboards"));
        future
    }

}

/// LorStatusV1 endpoints handle, accessed by calling [`lor_status_v1()`](crate::RiotApi::lor_status_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-status-v1" target="_blank">`lor-status-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct LorStatusV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorStatusV1<'a> {
    /// Get Legends of Runeterra status for the given platform.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-status-v1/GET_getPlatformData" target="_blank">`lor-status-v1.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, route: RegionalRoute)
        -> impl Future<Output = Result<lor_status_v1::PlatformData>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lor/status/v1/platform-data");
        let future = self.base.execute_val::<lor_status_v1::PlatformData>("lor-status-v1.getPlatformData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("lor-status-v1.getPlatformData"));
        future
    }

}

/// MatchV4 endpoints handle, accessed by calling [`match_v4()`](crate::RiotApi::match_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#match-v4" target="_blank">`match-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct MatchV4<'a> {
    base: &'a RiotApi,
}
impl<'a> MatchV4<'a> {
    /// Get match IDs by tournament code.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The tournament code.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v4/GET_getMatchIdsByTournamentCode" target="_blank">`match-v4.getMatchIdsByTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_tournament_code(&self, route: PlatformRoute, tournament_code: &str)
        -> impl Future<Output = Result<Vec<i64>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v4/matches/by-tournament-code/{}/ids", tournament_code));
        let future = self.base.execute_val::<Vec<i64>>("match-v4.getMatchIdsByTournamentCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v4.getMatchIdsByTournamentCode"));
        future
    }

    /// Get match by match ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path) - The match ID.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v4/GET_getMatch" target="_blank">`match-v4.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, route: PlatformRoute, match_id: i64)
        -> impl Future<Output = Result<Option<match_v4::Match>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v4/matches/{}", match_id));
        let future = self.base.execute_opt::<match_v4::Match>("match-v4.getMatch", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v4.getMatch"));
        future
    }

    /// Get match by match ID and tournament code.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The tournament code.
    /// * `match_id` (required, in path) - The match ID.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v4/GET_getMatchByTournamentCode" target="_blank">`match-v4.getMatchByTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_by_tournament_code(&self, route: PlatformRoute, match_id: i64, tournament_code: &str)
        -> impl Future<Output = Result<match_v4::Match>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v4/matches/{}/by-tournament-code/{}", match_id, tournament_code));
        let future = self.base.execute_val::<match_v4::Match>("match-v4.getMatchByTournamentCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v4.getMatchByTournamentCode"));
        future
    }

    /// Get matchlist for games played on given account ID and platform ID and filtered using given filter parameters, if any.
    /// ## Implementation Notes
    /// A number of optional parameters are provided for filtering. It is up to the caller to ensure that the combination of filter parameters provided is valid for the requested account, otherwise, no matches may be returned.
    ///
    /// If beginIndex is specified, but not endIndex, then endIndex defaults to beginIndex+100. If endIndex is specified, but not beginIndex, then beginIndex defaults to 0. If both are specified, then endIndex must be greater than beginIndex. The maximum range allowed is 100, otherwise a 400 error code is returned.
    ///
    /// If beginTime is specified, but not endTime, then endTime defaults to the the current unix timestamp in milliseconds (the maximum time range limitation is not observed in this specific case). If endTime is specified, but not beginTime, then beginTime defaults to the start of the account's match history returning a 400 due to the maximum time range limitation. If both are specified, then endTime should be greater than beginTime. The maximum time range allowed is one week, otherwise a 400 error code is returned.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_account_id` (required, in path) - The account ID.
    /// * `champion` (optional, in query) - Set of champion IDs for filtering the matchlist.
    /// * `queue` (optional, in query) - Set of queue IDs for filtering the matchlist.
    /// * `season` (optional, in query) - [DEPRECATED] This field should not be considered reliable for the purposes of filtering matches by season.
    /// * `end_time` (optional, in query) - The end time to use for filtering matchlist specified as epoch milliseconds. If beginTime is specified, but not endTime, then endTime defaults to the the current unix timestamp in milliseconds (the maximum time range limitation is not observed in this specific case). If endTime is specified, but not beginTime, then beginTime defaults to the start of the account's match history returning a 400 due to the maximum time range limitation. If both are specified, then endTime should be greater than beginTime. The maximum time range allowed is one week, otherwise a 400 error code is returned.
    /// * `begin_time` (optional, in query) - The begin time to use for filtering matchlist specified as epoch milliseconds. If beginTime is specified, but not endTime, then endTime defaults to the the current unix timestamp in milliseconds (the maximum time range limitation is not observed in this specific case). If endTime is specified, but not beginTime, then beginTime defaults to the start of the account's match history returning a 400 due to the maximum time range limitation. If both are specified, then endTime should be greater than beginTime. The maximum time range allowed is one week, otherwise a 400 error code is returned.
    /// * `end_index` (optional, in query) - The end index to use for filtering matchlist. If beginIndex is specified, but not endIndex, then endIndex defaults to beginIndex+100. If endIndex is specified, but not beginIndex, then beginIndex defaults to 0. If both are specified, then endIndex must be greater than beginIndex. The maximum range allowed is 100, otherwise a 400 error code is returned.
    /// * `begin_index` (optional, in query) - The begin index to use for filtering matchlist.  If beginIndex is specified, but not endIndex, then endIndex defaults to beginIndex+100. If endIndex is specified, but not beginIndex, then beginIndex defaults to 0. If both are specified, then endIndex must be greater than beginIndex. The maximum range allowed is 100, otherwise a 400 error code is returned.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v4/GET_getMatchlist" target="_blank">`match-v4.getMatchlist`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_matchlist(&self, route: PlatformRoute, encrypted_account_id: &str, begin_time: Option<i64>, begin_index: Option<i32>, champion: Option<&[crate::consts::Champion]>, end_time: Option<i64>, end_index: Option<i32>, queue: Option<&[crate::consts::Queue]>, season: Option<&[crate::consts::Season]>)
        -> impl Future<Output = Result<Option<match_v4::Matchlist>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v4/matchlists/by-account/{}", encrypted_account_id));
        let mut request = request; if let Some(begin_time) = begin_time { request = request.query(&[ ("beginTime", begin_time) ]); }
        let mut request = request; if let Some(begin_index) = begin_index { request = request.query(&[ ("beginIndex", begin_index) ]); }
        let mut request = request; if let Some(champion) = champion { request = request.query(&*champion.iter().map(|w| ( "champion", w )).collect::<Vec<_>>()); }
        let mut request = request; if let Some(end_time) = end_time { request = request.query(&[ ("endTime", end_time) ]); }
        let mut request = request; if let Some(end_index) = end_index { request = request.query(&[ ("endIndex", end_index) ]); }
        let mut request = request; if let Some(queue) = queue { request = request.query(&*queue.iter().map(|w| ( "queue", w )).collect::<Vec<_>>()); }
        let mut request = request; if let Some(season) = season { request = request.query(&*season.iter().map(|w| ( "season", w )).collect::<Vec<_>>()); }
        let future = self.base.execute_opt::<match_v4::Matchlist>("match-v4.getMatchlist", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v4.getMatchlist"));
        future
    }

    /// Get match timeline by match ID.
    /// ## Implementation Notes
    /// Not all matches have timeline data.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path) - The match ID.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v4/GET_getMatchTimeline" target="_blank">`match-v4.getMatchTimeline`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_timeline(&self, route: PlatformRoute, match_id: i64)
        -> impl Future<Output = Result<Option<match_v4::MatchTimeline>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v4/timelines/by-match/{}", match_id));
        let future = self.base.execute_opt::<match_v4::MatchTimeline>("match-v4.getMatchTimeline", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v4.getMatchTimeline"));
        future
    }

}

/// MatchV5 endpoints handle, accessed by calling [`match_v5()`](crate::RiotApi::match_v5) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#match-v5" target="_blank">`match-v5`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct MatchV5<'a> {
    base: &'a RiotApi,
}
impl<'a> MatchV5<'a> {
    /// Get a list of match ids by puuid
    /// # Parameters
    /// * `route` - Route to query.
    /// * `puuid` (required, in path)
    /// * `queue` (optional, in query) - Filter the list of match ids by a specific queue id. This filter is mutually inclusive of the type filter meaning any match ids returned must match both the queue and type filters.
    /// * `type` (optional, in query) - Filter the list of match ids by the type of match. This filter is mutually inclusive of the queue filter meaning any match ids returned must match both the queue and type filters.
    /// * `start` (optional, in query) - Defaults to 0. Start index.
    /// * `count` (optional, in query) - Defaults to 20. Valid values: 0 to 100. Number of match ids to return.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getMatchIdsByPUUID" target="_blank">`match-v5.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, route: RegionalRoute, puuid: &str, count: Option<i32>, queue: Option<i32>, start: Option<i32>, r#type: Option<&str>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v5/matches/by-puuid/{}/ids", puuid));
        let mut request = request; if let Some(count) = count { request = request.query(&[ ("count", count) ]); }
        let mut request = request; if let Some(queue) = queue { request = request.query(&[ ("queue", queue) ]); }
        let mut request = request; if let Some(start) = start { request = request.query(&[ ("start", start) ]); }
        let mut request = request; if let Some(r#type) = r#type { request = request.query(&[ ("type", r#type) ]); }
        let future = self.base.execute_val::<Vec<String>>("match-v5.getMatchIdsByPUUID", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v5.getMatchIdsByPUUID"));
        future
    }

    /// Get a match by match id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getMatch" target="_blank">`match-v5.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, route: RegionalRoute, match_id: &str)
        -> impl Future<Output = Result<Option<match_v5::Match>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v5/matches/{}", match_id));
        let future = self.base.execute_opt::<match_v5::Match>("match-v5.getMatch", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v5.getMatch"));
        future
    }

    /// Get a match timeline by match id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getTimeline" target="_blank">`match-v5.getTimeline`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_timeline(&self, route: RegionalRoute, match_id: &str)
        -> impl Future<Output = Result<Option<match_v5::MatchTimeline>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/match/v5/matches/{}/timeline", match_id));
        let future = self.base.execute_opt::<match_v5::MatchTimeline>("match-v5.getTimeline", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("match-v5.getTimeline"));
        future
    }

}

/// SpectatorV4 endpoints handle, accessed by calling [`spectator_v4()`](crate::RiotApi::spectator_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#spectator-v4" target="_blank">`spectator-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct SpectatorV4<'a> {
    base: &'a RiotApi,
}
impl<'a> SpectatorV4<'a> {
    /// Get current game information for the given summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path) - The ID of the summoner.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#spectator-v4/GET_getCurrentGameInfoBySummoner" target="_blank">`spectator-v4.getCurrentGameInfoBySummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_current_game_info_by_summoner(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Option<spectator_v4::CurrentGameInfo>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/spectator/v4/active-games/by-summoner/{}", encrypted_summoner_id));
        let future = self.base.execute_opt::<spectator_v4::CurrentGameInfo>("spectator-v4.getCurrentGameInfoBySummoner", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("spectator-v4.getCurrentGameInfoBySummoner"));
        future
    }

    /// Get list of featured games.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#spectator-v4/GET_getFeaturedGames" target="_blank">`spectator-v4.getFeaturedGames`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_featured_games(&self, route: PlatformRoute)
        -> impl Future<Output = Result<spectator_v4::FeaturedGames>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/spectator/v4/featured-games");
        let future = self.base.execute_val::<spectator_v4::FeaturedGames>("spectator-v4.getFeaturedGames", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("spectator-v4.getFeaturedGames"));
        future
    }

}

/// SummonerV4 endpoints handle, accessed by calling [`summoner_v4()`](crate::RiotApi::summoner_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#summoner-v4" target="_blank">`summoner-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct SummonerV4<'a> {
    base: &'a RiotApi,
}
impl<'a> SummonerV4<'a> {
    /// Get a summoner by account ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_account_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getByAccountId" target="_blank">`summoner-v4.getByAccountId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_account_id(&self, route: PlatformRoute, encrypted_account_id: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/summoner/v4/summoners/by-account/{}", encrypted_account_id));
        let future = self.base.execute_val::<summoner_v4::Summoner>("summoner-v4.getByAccountId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("summoner-v4.getByAccountId"));
        future
    }

    /// Get a summoner by summoner name.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `summoner_name` (required, in path) - Summoner Name
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getBySummonerName" target="_blank">`summoner-v4.getBySummonerName`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_name(&self, route: PlatformRoute, summoner_name: &str)
        -> impl Future<Output = Result<Option<summoner_v4::Summoner>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/summoner/v4/summoners/by-name/{}", summoner_name));
        let future = self.base.execute_opt::<summoner_v4::Summoner>("summoner-v4.getBySummonerName", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("summoner-v4.getBySummonerName"));
        future
    }

    /// Get a summoner by PUUID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_puuid` (required, in path) - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getByPUUID" target="_blank">`summoner-v4.getByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, route: PlatformRoute, encrypted_puuid: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/summoner/v4/summoners/by-puuid/{}", encrypted_puuid));
        let future = self.base.execute_val::<summoner_v4::Summoner>("summoner-v4.getByPUUID", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("summoner-v4.getByPUUID"));
        future
    }

    /// Get a summoner by access token.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (optional, in header) - Bearer token
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getByAccessToken" target="_blank">`summoner-v4.getByAccessToken`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_access_token(&self, route: PlatformRoute, authorization: Option<&str>)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/lol/summoner/v4/summoners/me");
        let mut request = request; if let Some(authorization) = authorization { request = request.header("Authorization", authorization); }
        let future = self.base.execute_val::<summoner_v4::Summoner>("summoner-v4.getByAccessToken", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("summoner-v4.getByAccessToken"));
        future
    }

    /// Get a summoner by summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path) - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getBySummonerId" target="_blank">`summoner-v4.getBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_id(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/summoner/v4/summoners/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<summoner_v4::Summoner>("summoner-v4.getBySummonerId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("summoner-v4.getBySummonerId"));
        future
    }

}

/// TftLeagueV1 endpoints handle, accessed by calling [`tft_league_v1()`](crate::RiotApi::tft_league_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-league-v1" target="_blank">`tft-league-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct TftLeagueV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftLeagueV1<'a> {
    /// Get the challenger league.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getChallengerLeague" target="_blank">`tft-league-v1.getChallengerLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_challenger_league(&self, route: PlatformRoute)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/tft/league/v1/challenger");
        let future = self.base.execute_val::<tft_league_v1::LeagueList>("tft-league-v1.getChallengerLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getChallengerLeague"));
        future
    }

    /// Get league entries for a given summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `summoner_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueEntriesForSummoner" target="_blank">`tft-league-v1.getLeagueEntriesForSummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries_for_summoner(&self, route: PlatformRoute, summoner_id: &str)
        -> impl Future<Output = Result<Vec<tft_league_v1::LeagueEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/league/v1/entries/by-summoner/{}", summoner_id));
        let future = self.base.execute_val::<Vec<tft_league_v1::LeagueEntry>>("tft-league-v1.getLeagueEntriesForSummoner", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getLeagueEntriesForSummoner"));
        future
    }

    /// Get all the league entries.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tier` (required, in path)
    /// * `division` (required, in path)
    /// * `page` (optional, in query) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueEntries" target="_blank">`tft-league-v1.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, route: PlatformRoute, tier: &str, division: &str, page: Option<i32>)
        -> impl Future<Output = Result<Vec<tft_league_v1::LeagueEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/league/v1/entries/{}/{}", tier, division));
        let mut request = request; if let Some(page) = page { request = request.query(&[ ("page", page) ]); }
        let future = self.base.execute_val::<Vec<tft_league_v1::LeagueEntry>>("tft-league-v1.getLeagueEntries", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getLeagueEntries"));
        future
    }

    /// Get the grandmaster league.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getGrandmasterLeague" target="_blank">`tft-league-v1.getGrandmasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_grandmaster_league(&self, route: PlatformRoute)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/tft/league/v1/grandmaster");
        let future = self.base.execute_val::<tft_league_v1::LeagueList>("tft-league-v1.getGrandmasterLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getGrandmasterLeague"));
        future
    }

    /// Get league with given ID, including inactive entries.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `league_id` (required, in path) - The UUID of the league.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueById" target="_blank">`tft-league-v1.getLeagueById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_by_id(&self, route: PlatformRoute, league_id: &str)
        -> impl Future<Output = Result<Option<tft_league_v1::LeagueList>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/league/v1/leagues/{}", league_id));
        let future = self.base.execute_opt::<tft_league_v1::LeagueList>("tft-league-v1.getLeagueById", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getLeagueById"));
        future
    }

    /// Get the master league.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getMasterLeague" target="_blank">`tft-league-v1.getMasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_master_league(&self, route: PlatformRoute)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/tft/league/v1/master");
        let future = self.base.execute_val::<tft_league_v1::LeagueList>("tft-league-v1.getMasterLeague", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getMasterLeague"));
        future
    }

    /// Get the top rated ladder for given queue
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getTopRatedLadder" target="_blank">`tft-league-v1.getTopRatedLadder`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_top_rated_ladder(&self, route: PlatformRoute, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<Vec<tft_league_v1::TopRatedLadderEntry>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/league/v1/rated-ladders/{}/top", queue));
        let future = self.base.execute_val::<Vec<tft_league_v1::TopRatedLadderEntry>>("tft-league-v1.getTopRatedLadder", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-league-v1.getTopRatedLadder"));
        future
    }

}

/// TftMatchV1 endpoints handle, accessed by calling [`tft_match_v1()`](crate::RiotApi::tft_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-match-v1" target="_blank">`tft-match-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct TftMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftMatchV1<'a> {
    /// Get a list of match ids by PUUID
    /// # Parameters
    /// * `route` - Route to query.
    /// * `puuid` (required, in path)
    /// * `count` (optional, in query) - Defaults to 20.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-match-v1/GET_getMatchIdsByPUUID" target="_blank">`tft-match-v1.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, route: RegionalRoute, puuid: &str, count: Option<i32>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/match/v1/matches/by-puuid/{}/ids", puuid));
        let mut request = request; if let Some(count) = count { request = request.query(&[ ("count", count) ]); }
        let future = self.base.execute_val::<Vec<String>>("tft-match-v1.getMatchIdsByPUUID", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-match-v1.getMatchIdsByPUUID"));
        future
    }

    /// Get a match by match id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-match-v1/GET_getMatch" target="_blank">`tft-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, route: RegionalRoute, match_id: &str)
        -> impl Future<Output = Result<Option<tft_match_v1::Match>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/match/v1/matches/{}", match_id));
        let future = self.base.execute_opt::<tft_match_v1::Match>("tft-match-v1.getMatch", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-match-v1.getMatch"));
        future
    }

}

/// TftSummonerV1 endpoints handle, accessed by calling [`tft_summoner_v1()`](crate::RiotApi::tft_summoner_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-summoner-v1" target="_blank">`tft-summoner-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct TftSummonerV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftSummonerV1<'a> {
    /// Get a summoner by account ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_account_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getByAccountId" target="_blank">`tft-summoner-v1.getByAccountId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_account_id(&self, route: PlatformRoute, encrypted_account_id: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/summoner/v1/summoners/by-account/{}", encrypted_account_id));
        let future = self.base.execute_val::<tft_summoner_v1::Summoner>("tft-summoner-v1.getByAccountId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-summoner-v1.getByAccountId"));
        future
    }

    /// Get a summoner by summoner name.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `summoner_name` (required, in path) - Summoner Name
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getBySummonerName" target="_blank">`tft-summoner-v1.getBySummonerName`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_name(&self, route: PlatformRoute, summoner_name: &str)
        -> impl Future<Output = Result<Option<tft_summoner_v1::Summoner>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/summoner/v1/summoners/by-name/{}", summoner_name));
        let future = self.base.execute_opt::<tft_summoner_v1::Summoner>("tft-summoner-v1.getBySummonerName", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-summoner-v1.getBySummonerName"));
        future
    }

    /// Get a summoner by PUUID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_puuid` (required, in path) - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getByPUUID" target="_blank">`tft-summoner-v1.getByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, route: PlatformRoute, encrypted_puuid: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/summoner/v1/summoners/by-puuid/{}", encrypted_puuid));
        let future = self.base.execute_val::<tft_summoner_v1::Summoner>("tft-summoner-v1.getByPUUID", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-summoner-v1.getByPUUID"));
        future
    }

    /// Get a summoner by access token.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `authorization` (optional, in header) - Bearer token.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getByAccessToken" target="_blank">`tft-summoner-v1.getByAccessToken`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_access_token(&self, route: PlatformRoute, authorization: Option<&str>)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/tft/summoner/v1/summoners/me");
        let mut request = request; if let Some(authorization) = authorization { request = request.header("Authorization", authorization); }
        let future = self.base.execute_val::<tft_summoner_v1::Summoner>("tft-summoner-v1.getByAccessToken", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-summoner-v1.getByAccessToken"));
        future
    }

    /// Get a summoner by summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path) - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getBySummonerId" target="_blank">`tft-summoner-v1.getBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_id(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/tft/summoner/v1/summoners/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<tft_summoner_v1::Summoner>("tft-summoner-v1.getBySummonerId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tft-summoner-v1.getBySummonerId"));
        future
    }

}

/// ThirdPartyCodeV4 endpoints handle, accessed by calling [`third_party_code_v4()`](crate::RiotApi::third_party_code_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#third-party-code-v4" target="_blank">`third-party-code-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ThirdPartyCodeV4<'a> {
    base: &'a RiotApi,
}
impl<'a> ThirdPartyCodeV4<'a> {
    /// Get third party code for a given summoner ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `encrypted_summoner_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#third-party-code-v4/GET_getThirdPartyCodeBySummonerId" target="_blank">`third-party-code-v4.getThirdPartyCodeBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_third_party_code_by_summoner_id(&self, route: PlatformRoute, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<String>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/platform/v4/third-party-code/by-summoner/{}", encrypted_summoner_id));
        let future = self.base.execute_val::<String>("third-party-code-v4.getThirdPartyCodeBySummonerId", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("third-party-code-v4.getThirdPartyCodeBySummonerId"));
        future
    }

}

/// TournamentStubV4 endpoints handle, accessed by calling [`tournament_stub_v4()`](crate::RiotApi::tournament_stub_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tournament-stub-v4" target="_blank">`tournament-stub-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct TournamentStubV4<'a> {
    base: &'a RiotApi,
}
impl<'a> TournamentStubV4<'a> {
    /// Create a mock tournament code for the given tournament.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `count` (optional, in query) - The number of codes to create (max 1000)
    /// * `tournament_id` (required, in query) - The tournament ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-stub-v4/POST_createTournamentCode" target="_blank">`tournament-stub-v4.createTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn create_tournament_code(&self, route: RegionalRoute, body: &tournament_stub_v4::TournamentCodeParameters, tournament_id: i64, count: Option<i32>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament-stub/v4/codes");
        let request = request.query(&[ ("tournamentId", tournament_id) ]);
        let mut request = request; if let Some(count) = count { request = request.query(&[ ("count", count) ]); }
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<Vec<String>>("tournament-stub-v4.createTournamentCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-stub-v4.createTournamentCode"));
        future
    }

    /// Gets a mock list of lobby events by tournament code.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The short code to look up lobby events for
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-stub-v4/GET_getLobbyEventsByCode" target="_blank">`tournament-stub-v4.getLobbyEventsByCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_lobby_events_by_code(&self, route: RegionalRoute, tournament_code: &str)
        -> impl Future<Output = Result<tournament_stub_v4::LobbyEventWrapper>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/tournament-stub/v4/lobby-events/by-code/{}", tournament_code));
        let future = self.base.execute_val::<tournament_stub_v4::LobbyEventWrapper>("tournament-stub-v4.getLobbyEventsByCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-stub-v4.getLobbyEventsByCode"));
        future
    }

    /// Creates a mock tournament provider and returns its ID.
    /// ## Implementation Notes
    /// Providers will need to call this endpoint first to register their callback URL and their API key with the tournament system before any other tournament provider endpoints will work.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-stub-v4/POST_registerProviderData" target="_blank">`tournament-stub-v4.registerProviderData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn register_provider_data(&self, route: RegionalRoute, body: &tournament_stub_v4::ProviderRegistrationParameters)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament-stub/v4/providers");
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<i32>("tournament-stub-v4.registerProviderData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-stub-v4.registerProviderData"));
        future
    }

    /// Creates a mock tournament and returns its ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-stub-v4/POST_registerTournament" target="_blank">`tournament-stub-v4.registerTournament`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn register_tournament(&self, route: RegionalRoute, body: &tournament_stub_v4::TournamentRegistrationParameters)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament-stub/v4/tournaments");
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<i32>("tournament-stub-v4.registerTournament", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-stub-v4.registerTournament"));
        future
    }

}

/// TournamentV4 endpoints handle, accessed by calling [`tournament_v4()`](crate::RiotApi::tournament_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tournament-v4" target="_blank">`tournament-v4`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct TournamentV4<'a> {
    base: &'a RiotApi,
}
impl<'a> TournamentV4<'a> {
    /// Create a tournament code for the given tournament.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `count` (optional, in query) - The number of codes to create (max 1000)
    /// * `tournament_id` (required, in query) - The tournament ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/POST_createTournamentCode" target="_blank">`tournament-v4.createTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn create_tournament_code(&self, route: RegionalRoute, body: &tournament_v4::TournamentCodeParameters, tournament_id: i64, count: Option<i32>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament/v4/codes");
        let request = request.query(&[ ("tournamentId", tournament_id) ]);
        let mut request = request; if let Some(count) = count { request = request.query(&[ ("count", count) ]); }
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<Vec<String>>("tournament-v4.createTournamentCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.createTournamentCode"));
        future
    }

    /// Returns the tournament code DTO associated with a tournament code string.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The tournament code string.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/GET_getTournamentCode" target="_blank">`tournament-v4.getTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_code(&self, route: RegionalRoute, tournament_code: &str)
        -> impl Future<Output = Result<tournament_v4::TournamentCode>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/tournament/v4/codes/{}", tournament_code));
        let future = self.base.execute_val::<tournament_v4::TournamentCode>("tournament-v4.getTournamentCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.getTournamentCode"));
        future
    }

    /// Update the pick type, map, spectator type, or allowed summoners for a code.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The tournament code to update
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/PUT_updateCode" target="_blank">`tournament-v4.updateCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn update_code(&self, route: RegionalRoute, body: &tournament_v4::TournamentCodeUpdateParameters, tournament_code: &str)
        -> impl Future<Output = Result<()>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::PUT, route_str, &format!("/lol/tournament/v4/codes/{}", tournament_code));
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute("tournament-v4.updateCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.updateCode"));
        future
    }

    /// Gets a list of lobby events by tournament code.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `tournament_code` (required, in path) - The short code to look up lobby events for
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/GET_getLobbyEventsByCode" target="_blank">`tournament-v4.getLobbyEventsByCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_lobby_events_by_code(&self, route: RegionalRoute, tournament_code: &str)
        -> impl Future<Output = Result<tournament_v4::LobbyEventWrapper>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/lol/tournament/v4/lobby-events/by-code/{}", tournament_code));
        let future = self.base.execute_val::<tournament_v4::LobbyEventWrapper>("tournament-v4.getLobbyEventsByCode", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.getLobbyEventsByCode"));
        future
    }

    /// Creates a tournament provider and returns its ID.
    /// ## Implementation Notes
    /// Providers will need to call this endpoint first to register their callback URL and their API key with the tournament system before any other tournament provider endpoints will work.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/POST_registerProviderData" target="_blank">`tournament-v4.registerProviderData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn register_provider_data(&self, route: RegionalRoute, body: &tournament_v4::ProviderRegistrationParameters)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament/v4/providers");
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<i32>("tournament-v4.registerProviderData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.registerProviderData"));
        future
    }

    /// Creates a tournament and returns its ID.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/POST_registerTournament" target="_blank">`tournament-v4.registerTournament`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn register_tournament(&self, route: RegionalRoute, body: &tournament_v4::TournamentRegistrationParameters)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::POST, route_str, "/lol/tournament/v4/tournaments");
        let request = request.body(serde_json::ser::to_vec(body).unwrap());
        let future = self.base.execute_val::<i32>("tournament-v4.registerTournament", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("tournament-v4.registerTournament"));
        future
    }

}

/// ValContentV1 endpoints handle, accessed by calling [`val_content_v1()`](crate::RiotApi::val_content_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-content-v1" target="_blank">`val-content-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ValContentV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValContentV1<'a> {
    /// Get content optionally filtered by locale
    /// # Parameters
    /// * `route` - Route to query.
    /// * `locale` (optional, in query)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-content-v1/GET_getContent" target="_blank">`val-content-v1.getContent`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_content(&self, route: ValPlatformRoute, locale: Option<&str>)
        -> impl Future<Output = Result<val_content_v1::Content>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/val/content/v1/contents");
        let mut request = request; if let Some(locale) = locale { request = request.query(&[ ("locale", locale) ]); }
        let future = self.base.execute_val::<val_content_v1::Content>("val-content-v1.getContent", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-content-v1.getContent"));
        future
    }

}

/// ValMatchV1 endpoints handle, accessed by calling [`val_match_v1()`](crate::RiotApi::val_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-match-v1" target="_blank">`val-match-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ValMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValMatchV1<'a> {
    /// Get match by id
    /// # Parameters
    /// * `route` - Route to query.
    /// * `match_id` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getMatch" target="_blank">`val-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, route: ValPlatformRoute, match_id: &str)
        -> impl Future<Output = Result<Option<val_match_v1::Match>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/val/match/v1/matches/{}", match_id));
        let future = self.base.execute_opt::<val_match_v1::Match>("val-match-v1.getMatch", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-match-v1.getMatch"));
        future
    }

    /// Get matchlist for games played by puuid
    /// # Parameters
    /// * `route` - Route to query.
    /// * `puuid` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getMatchlist" target="_blank">`val-match-v1.getMatchlist`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_matchlist(&self, route: ValPlatformRoute, puuid: &str)
        -> impl Future<Output = Result<val_match_v1::Matchlist>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/val/match/v1/matchlists/by-puuid/{}", puuid));
        let future = self.base.execute_val::<val_match_v1::Matchlist>("val-match-v1.getMatchlist", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-match-v1.getMatchlist"));
        future
    }

    /// Get recent matches
    /// ## Implementation Notes
    /// Returns a list of match ids that have completed in the last 10 minutes for live regions and 12 hours for the esports routing value. NA/LATAM/BR share a match history deployment. As such, recent matches will return a combined list of matches from those three regions. Requests are load balanced so you may see some inconsistencies as matches are added/removed from the list.
    /// # Parameters
    /// * `route` - Route to query.
    /// * `queue` (required, in path)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getRecent" target="_blank">`val-match-v1.getRecent`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_recent(&self, route: ValPlatformRoute, queue: &str)
        -> impl Future<Output = Result<val_match_v1::RecentMatches>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/val/match/v1/recent-matches/by-queue/{}", queue));
        let future = self.base.execute_val::<val_match_v1::RecentMatches>("val-match-v1.getRecent", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-match-v1.getRecent"));
        future
    }

}

/// ValRankedV1 endpoints handle, accessed by calling [`val_ranked_v1()`](crate::RiotApi::val_ranked_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-ranked-v1" target="_blank">`val-ranked-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ValRankedV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValRankedV1<'a> {
    /// Get leaderboard for the competitive queue
    /// # Parameters
    /// * `route` - Route to query.
    /// * `act_id` (required, in path) - Act ids can be found using the val-content API.
    /// * `size` (optional, in query) - Defaults to 200. Valid values: 1 to 200.
    /// * `start_index` (optional, in query) - Defaults to 0.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-ranked-v1/GET_getLeaderboard" target="_blank">`val-ranked-v1.getLeaderboard`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_leaderboard(&self, route: ValPlatformRoute, act_id: &str, size: Option<i32>, start_index: Option<i32>)
        -> impl Future<Output = Result<Option<val_ranked_v1::Leaderboard>>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, &format!("/val/ranked/v1/leaderboards/by-act/{}", act_id));
        let mut request = request; if let Some(size) = size { request = request.query(&[ ("size", size) ]); }
        let mut request = request; if let Some(start_index) = start_index { request = request.query(&[ ("startIndex", start_index) ]); }
        let future = self.base.execute_opt::<val_ranked_v1::Leaderboard>("val-ranked-v1.getLeaderboard", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-ranked-v1.getLeaderboard"));
        future
    }

}

/// ValStatusV1 endpoints handle, accessed by calling [`val_status_v1()`](crate::RiotApi::val_status_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-status-v1" target="_blank">`val-status-v1`</a>
///
/// Note: this struct is automatically generated.
#[repr(transparent)]
pub struct ValStatusV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValStatusV1<'a> {
    /// Get VALORANT status for the given platform.
    /// # Parameters
    /// * `route` - Route to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-status-v1/GET_getPlatformData" target="_blank">`val-status-v1.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, route: ValPlatformRoute)
        -> impl Future<Output = Result<val_status_v1::PlatformData>> + 'a
    {
        let route_str = route.into();
        let request = self.base.request(Method::GET, route_str, "/val/status/v1/platform-data");
        let future = self.base.execute_val::<val_status_v1::PlatformData>("val-status-v1.getPlatformData", route_str, request);
        #[cfg(feature = "tracing")]
        let future = future.instrument(tracing::info_span!("val-status-v1.getPlatformData"));
        future
    }

}
