///////////////////////////////////////////////
//                                           //
//                     !                     //
//   This file is automatically generated!   //
//           Do not directly edit!           //
//                                           //
///////////////////////////////////////////////

use serde::{ Serialize, Deserialize };

newtype_enum! {
    /// A League of Legends champion.
    ///
    /// This newtype acts as a C-like enum; each variant corresponds to an
    /// integer value. Using a newtype allows _unknown_ variants to be
    /// represented. This is important when Riot adds new champions.
    ///
    /// Field | Name | Identifier | Id
    /// ---|---|---|---
    /// `AATROX` | "Aatrox" | "Aatrox" | 266
    /// `AHRI` | "Ahri" | "Ahri" | 103
    /// `AKALI` | "Akali" | "Akali" | 84
    /// `AKSHAN` | "Akshan" | "Akshan" | 166
    /// `ALISTAR` | "Alistar" | "Alistar" | 12
    /// `AMUMU` | "Amumu" | "Amumu" | 32
    /// `ANIVIA` | "Anivia" | "Anivia" | 34
    /// `ANNIE` | "Annie" | "Annie" | 1
    /// `APHELIOS` | "Aphelios" | "Aphelios" | 523
    /// `ASHE` | "Ashe" | "Ashe" | 22
    /// `AURELION_SOL` | "Aurelion Sol" | "AurelionSol" | 136
    /// `AZIR` | "Azir" | "Azir" | 268
    /// `BARD` | "Bard" | "Bard" | 432
    /// `BLITZCRANK` | "Blitzcrank" | "Blitzcrank" | 53
    /// `BRAND` | "Brand" | "Brand" | 63
    /// `BRAUM` | "Braum" | "Braum" | 201
    /// `CAITLYN` | "Caitlyn" | "Caitlyn" | 51
    /// `CAMILLE` | "Camille" | "Camille" | 164
    /// `CASSIOPEIA` | "Cassiopeia" | "Cassiopeia" | 69
    /// `CHO_GATH` | "Cho'Gath" | "Chogath" | 31
    /// `CORKI` | "Corki" | "Corki" | 42
    /// `DARIUS` | "Darius" | "Darius" | 122
    /// `DIANA` | "Diana" | "Diana" | 131
    /// `DR_MUNDO` | "Dr. Mundo" | "DrMundo" | 36
    /// `DRAVEN` | "Draven" | "Draven" | 119
    /// `EKKO` | "Ekko" | "Ekko" | 245
    /// `ELISE` | "Elise" | "Elise" | 60
    /// `EVELYNN` | "Evelynn" | "Evelynn" | 28
    /// `EZREAL` | "Ezreal" | "Ezreal" | 81
    /// `FIDDLESTICKS` | "Fiddlesticks" | "FiddleSticks" | 9
    /// `FIORA` | "Fiora" | "Fiora" | 114
    /// `FIZZ` | "Fizz" | "Fizz" | 105
    /// `GALIO` | "Galio" | "Galio" | 3
    /// `GANGPLANK` | "Gangplank" | "Gangplank" | 41
    /// `GAREN` | "Garen" | "Garen" | 86
    /// `GNAR` | "Gnar" | "Gnar" | 150
    /// `GRAGAS` | "Gragas" | "Gragas" | 79
    /// `GRAVES` | "Graves" | "Graves" | 104
    /// `GWEN` | "Gwen" | "Gwen" | 887
    /// `HECARIM` | "Hecarim" | "Hecarim" | 120
    /// `HEIMERDINGER` | "Heimerdinger" | "Heimerdinger" | 74
    /// `ILLAOI` | "Illaoi" | "Illaoi" | 420
    /// `IRELIA` | "Irelia" | "Irelia" | 39
    /// `IVERN` | "Ivern" | "Ivern" | 427
    /// `JANNA` | "Janna" | "Janna" | 40
    /// `JARVAN_IV` | "Jarvan IV" | "JarvanIV" | 59
    /// `JAX` | "Jax" | "Jax" | 24
    /// `JAYCE` | "Jayce" | "Jayce" | 126
    /// `JHIN` | "Jhin" | "Jhin" | 202
    /// `JINX` | "Jinx" | "Jinx" | 222
    /// `KAI_SA` | "Kai'Sa" | "Kaisa" | 145
    /// `KALISTA` | "Kalista" | "Kalista" | 429
    /// `KARMA` | "Karma" | "Karma" | 43
    /// `KARTHUS` | "Karthus" | "Karthus" | 30
    /// `KASSADIN` | "Kassadin" | "Kassadin" | 38
    /// `KATARINA` | "Katarina" | "Katarina" | 55
    /// `KAYLE` | "Kayle" | "Kayle" | 10
    /// `KAYN` | "Kayn" | "Kayn" | 141
    /// `KENNEN` | "Kennen" | "Kennen" | 85
    /// `KHA_ZIX` | "Kha'Zix" | "Khazix" | 121
    /// `KINDRED` | "Kindred" | "Kindred" | 203
    /// `KLED` | "Kled" | "Kled" | 240
    /// `KOG_MAW` | "Kog'Maw" | "KogMaw" | 96
    /// `LE_BLANC` | "LeBlanc" | "Leblanc" | 7
    /// `LEE_SIN` | "Lee Sin" | "LeeSin" | 64
    /// `LEONA` | "Leona" | "Leona" | 89
    /// `LILLIA` | "Lillia" | "Lillia" | 876
    /// `LISSANDRA` | "Lissandra" | "Lissandra" | 127
    /// `LUCIAN` | "Lucian" | "Lucian" | 236
    /// `LULU` | "Lulu" | "Lulu" | 117
    /// `LUX` | "Lux" | "Lux" | 99
    /// `MALPHITE` | "Malphite" | "Malphite" | 54
    /// `MALZAHAR` | "Malzahar" | "Malzahar" | 90
    /// `MAOKAI` | "Maokai" | "Maokai" | 57
    /// `MASTER_YI` | "Master Yi" | "MasterYi" | 11
    /// `MISS_FORTUNE` | "Miss Fortune" | "MissFortune" | 21
    /// `MORDEKAISER` | "Mordekaiser" | "Mordekaiser" | 82
    /// `MORGANA` | "Morgana" | "Morgana" | 25
    /// `NAMI` | "Nami" | "Nami" | 267
    /// `NASUS` | "Nasus" | "Nasus" | 75
    /// `NAUTILUS` | "Nautilus" | "Nautilus" | 111
    /// `NEEKO` | "Neeko" | "Neeko" | 518
    /// `NIDALEE` | "Nidalee" | "Nidalee" | 76
    /// `NOCTURNE` | "Nocturne" | "Nocturne" | 56
    /// `NUNU_WILLUMP` | "Nunu & Willump" | "Nunu" | 20
    /// `OLAF` | "Olaf" | "Olaf" | 2
    /// `ORIANNA` | "Orianna" | "Orianna" | 61
    /// `ORNN` | "Ornn" | "Ornn" | 516
    /// `PANTHEON` | "Pantheon" | "Pantheon" | 80
    /// `POPPY` | "Poppy" | "Poppy" | 78
    /// `PYKE` | "Pyke" | "Pyke" | 555
    /// `QIYANA` | "Qiyana" | "Qiyana" | 246
    /// `QUINN` | "Quinn" | "Quinn" | 133
    /// `RAKAN` | "Rakan" | "Rakan" | 497
    /// `RAMMUS` | "Rammus" | "Rammus" | 33
    /// `REK_SAI` | "Rek'Sai" | "RekSai" | 421
    /// `RELL` | "Rell" | "Rell" | 526
    /// `RENEKTON` | "Renekton" | "Renekton" | 58
    /// `RENGAR` | "Rengar" | "Rengar" | 107
    /// `RIVEN` | "Riven" | "Riven" | 92
    /// `RUMBLE` | "Rumble" | "Rumble" | 68
    /// `RYZE` | "Ryze" | "Ryze" | 13
    /// `SAMIRA` | "Samira" | "Samira" | 360
    /// `SEJUANI` | "Sejuani" | "Sejuani" | 113
    /// `SENNA` | "Senna" | "Senna" | 235
    /// `SERAPHINE` | "Seraphine" | "Seraphine" | 147
    /// `SETT` | "Sett" | "Sett" | 875
    /// `SHACO` | "Shaco" | "Shaco" | 35
    /// `SHEN` | "Shen" | "Shen" | 98
    /// `SHYVANA` | "Shyvana" | "Shyvana" | 102
    /// `SINGED` | "Singed" | "Singed" | 27
    /// `SION` | "Sion" | "Sion" | 14
    /// `SIVIR` | "Sivir" | "Sivir" | 15
    /// `SKARNER` | "Skarner" | "Skarner" | 72
    /// `SONA` | "Sona" | "Sona" | 37
    /// `SORAKA` | "Soraka" | "Soraka" | 16
    /// `SWAIN` | "Swain" | "Swain" | 50
    /// `SYLAS` | "Sylas" | "Sylas" | 517
    /// `SYNDRA` | "Syndra" | "Syndra" | 134
    /// `TAHM_KENCH` | "Tahm Kench" | "TahmKench" | 223
    /// `TALIYAH` | "Taliyah" | "Taliyah" | 163
    /// `TALON` | "Talon" | "Talon" | 91
    /// `TARIC` | "Taric" | "Taric" | 44
    /// `TEEMO` | "Teemo" | "Teemo" | 17
    /// `THRESH` | "Thresh" | "Thresh" | 412
    /// `TRISTANA` | "Tristana" | "Tristana" | 18
    /// `TRUNDLE` | "Trundle" | "Trundle" | 48
    /// `TRYNDAMERE` | "Tryndamere" | "Tryndamere" | 23
    /// `TWISTED_FATE` | "Twisted Fate" | "TwistedFate" | 4
    /// `TWITCH` | "Twitch" | "Twitch" | 29
    /// `UDYR` | "Udyr" | "Udyr" | 77
    /// `URGOT` | "Urgot" | "Urgot" | 6
    /// `VARUS` | "Varus" | "Varus" | 110
    /// `VAYNE` | "Vayne" | "Vayne" | 67
    /// `VEIGAR` | "Veigar" | "Veigar" | 45
    /// `VEL_KOZ` | "Vel'Koz" | "Velkoz" | 161
    /// `VI` | "Vi" | "Vi" | 254
    /// `VIEGO` | "Viego" | "Viego" | 234
    /// `VIKTOR` | "Viktor" | "Viktor" | 112
    /// `VLADIMIR` | "Vladimir" | "Vladimir" | 8
    /// `VOLIBEAR` | "Volibear" | "Volibear" | 106
    /// `WARWICK` | "Warwick" | "Warwick" | 19
    /// `WUKONG` | "Wukong" | "MonkeyKing" | 62
    /// `XAYAH` | "Xayah" | "Xayah" | 498
    /// `XERATH` | "Xerath" | "Xerath" | 101
    /// `XIN_ZHAO` | "Xin Zhao" | "XinZhao" | 5
    /// `YASUO` | "Yasuo" | "Yasuo" | 157
    /// `YONE` | "Yone" | "Yone" | 777
    /// `YORICK` | "Yorick" | "Yorick" | 83
    /// `YUUMI` | "Yuumi" | "Yuumi" | 350
    /// `ZAC` | "Zac" | "Zac" | 154
    /// `ZED` | "Zed" | "Zed" | 238
    /// `ZIGGS` | "Ziggs" | "Ziggs" | 115
    /// `ZILEAN` | "Zilean" | "Zilean" | 26
    /// `ZOE` | "Zoe" | "Zoe" | 142
    /// `ZYRA` | "Zyra" | "Zyra" | 143
    #[derive(Serialize, Deserialize)]
    #[serde(transparent)]
    pub newtype_enum Champion(i16) {
        AATROX = 266,
        AHRI = 103,
        AKALI = 84,
        AKSHAN = 166,
        ALISTAR = 12,
        AMUMU = 32,
        ANIVIA = 34,
        ANNIE = 1,
        APHELIOS = 523,
        ASHE = 22,
        AURELION_SOL = 136,
        AZIR = 268,
        BARD = 432,
        BLITZCRANK = 53,
        BRAND = 63,
        BRAUM = 201,
        CAITLYN = 51,
        CAMILLE = 164,
        CASSIOPEIA = 69,
        CHO_GATH = 31,
        CORKI = 42,
        DARIUS = 122,
        DIANA = 131,
        DR_MUNDO = 36,
        DRAVEN = 119,
        EKKO = 245,
        ELISE = 60,
        EVELYNN = 28,
        EZREAL = 81,
        FIDDLESTICKS = 9,
        FIORA = 114,
        FIZZ = 105,
        GALIO = 3,
        GANGPLANK = 41,
        GAREN = 86,
        GNAR = 150,
        GRAGAS = 79,
        GRAVES = 104,
        GWEN = 887,
        HECARIM = 120,
        HEIMERDINGER = 74,
        ILLAOI = 420,
        IRELIA = 39,
        IVERN = 427,
        JANNA = 40,
        JARVAN_IV = 59,
        JAX = 24,
        JAYCE = 126,
        JHIN = 202,
        JINX = 222,
        KAI_SA = 145,
        KALISTA = 429,
        KARMA = 43,
        KARTHUS = 30,
        KASSADIN = 38,
        KATARINA = 55,
        KAYLE = 10,
        KAYN = 141,
        KENNEN = 85,
        KHA_ZIX = 121,
        KINDRED = 203,
        KLED = 240,
        KOG_MAW = 96,
        LE_BLANC = 7,
        LEE_SIN = 64,
        LEONA = 89,
        LILLIA = 876,
        LISSANDRA = 127,
        LUCIAN = 236,
        LULU = 117,
        LUX = 99,
        MALPHITE = 54,
        MALZAHAR = 90,
        MAOKAI = 57,
        MASTER_YI = 11,
        MISS_FORTUNE = 21,
        MORDEKAISER = 82,
        MORGANA = 25,
        NAMI = 267,
        NASUS = 75,
        NAUTILUS = 111,
        NEEKO = 518,
        NIDALEE = 76,
        NOCTURNE = 56,
        NUNU_WILLUMP = 20,
        OLAF = 2,
        ORIANNA = 61,
        ORNN = 516,
        PANTHEON = 80,
        POPPY = 78,
        PYKE = 555,
        QIYANA = 246,
        QUINN = 133,
        RAKAN = 497,
        RAMMUS = 33,
        REK_SAI = 421,
        RELL = 526,
        RENEKTON = 58,
        RENGAR = 107,
        RIVEN = 92,
        RUMBLE = 68,
        RYZE = 13,
        SAMIRA = 360,
        SEJUANI = 113,
        SENNA = 235,
        SERAPHINE = 147,
        SETT = 875,
        SHACO = 35,
        SHEN = 98,
        SHYVANA = 102,
        SINGED = 27,
        SION = 14,
        SIVIR = 15,
        SKARNER = 72,
        SONA = 37,
        SORAKA = 16,
        SWAIN = 50,
        SYLAS = 517,
        SYNDRA = 134,
        TAHM_KENCH = 223,
        TALIYAH = 163,
        TALON = 91,
        TARIC = 44,
        TEEMO = 17,
        THRESH = 412,
        TRISTANA = 18,
        TRUNDLE = 48,
        TRYNDAMERE = 23,
        TWISTED_FATE = 4,
        TWITCH = 29,
        UDYR = 77,
        URGOT = 6,
        VARUS = 110,
        VAYNE = 67,
        VEIGAR = 45,
        VEL_KOZ = 161,
        VI = 254,
        VIEGO = 234,
        VIKTOR = 112,
        VLADIMIR = 8,
        VOLIBEAR = 106,
        WARWICK = 19,
        WUKONG = 62,
        XAYAH = 498,
        XERATH = 101,
        XIN_ZHAO = 5,
        YASUO = 157,
        YONE = 777,
        YORICK = 83,
        YUUMI = 350,
        ZAC = 154,
        ZED = 238,
        ZIGGS = 115,
        ZILEAN = 26,
        ZOE = 142,
        ZYRA = 143,
    }
}

impl Champion {
    /// The champion's name (`en_US` localization).
    pub const fn name(self) -> Option<&'static str> {
        match self {
            Self::AATROX       => Some("Aatrox"),
            Self::AHRI         => Some("Ahri"),
            Self::AKALI        => Some("Akali"),
            Self::AKSHAN       => Some("Akshan"),
            Self::ALISTAR      => Some("Alistar"),
            Self::AMUMU        => Some("Amumu"),
            Self::ANIVIA       => Some("Anivia"),
            Self::ANNIE        => Some("Annie"),
            Self::APHELIOS     => Some("Aphelios"),
            Self::ASHE         => Some("Ashe"),
            Self::AURELION_SOL => Some("Aurelion Sol"),
            Self::AZIR         => Some("Azir"),
            Self::BARD         => Some("Bard"),
            Self::BLITZCRANK   => Some("Blitzcrank"),
            Self::BRAND        => Some("Brand"),
            Self::BRAUM        => Some("Braum"),
            Self::CAITLYN      => Some("Caitlyn"),
            Self::CAMILLE      => Some("Camille"),
            Self::CASSIOPEIA   => Some("Cassiopeia"),
            Self::CHO_GATH     => Some("Cho'Gath"),
            Self::CORKI        => Some("Corki"),
            Self::DARIUS       => Some("Darius"),
            Self::DIANA        => Some("Diana"),
            Self::DR_MUNDO     => Some("Dr. Mundo"),
            Self::DRAVEN       => Some("Draven"),
            Self::EKKO         => Some("Ekko"),
            Self::ELISE        => Some("Elise"),
            Self::EVELYNN      => Some("Evelynn"),
            Self::EZREAL       => Some("Ezreal"),
            Self::FIDDLESTICKS => Some("Fiddlesticks"),
            Self::FIORA        => Some("Fiora"),
            Self::FIZZ         => Some("Fizz"),
            Self::GALIO        => Some("Galio"),
            Self::GANGPLANK    => Some("Gangplank"),
            Self::GAREN        => Some("Garen"),
            Self::GNAR         => Some("Gnar"),
            Self::GRAGAS       => Some("Gragas"),
            Self::GRAVES       => Some("Graves"),
            Self::GWEN         => Some("Gwen"),
            Self::HECARIM      => Some("Hecarim"),
            Self::HEIMERDINGER => Some("Heimerdinger"),
            Self::ILLAOI       => Some("Illaoi"),
            Self::IRELIA       => Some("Irelia"),
            Self::IVERN        => Some("Ivern"),
            Self::JANNA        => Some("Janna"),
            Self::JARVAN_IV    => Some("Jarvan IV"),
            Self::JAX          => Some("Jax"),
            Self::JAYCE        => Some("Jayce"),
            Self::JHIN         => Some("Jhin"),
            Self::JINX         => Some("Jinx"),
            Self::KAI_SA       => Some("Kai'Sa"),
            Self::KALISTA      => Some("Kalista"),
            Self::KARMA        => Some("Karma"),
            Self::KARTHUS      => Some("Karthus"),
            Self::KASSADIN     => Some("Kassadin"),
            Self::KATARINA     => Some("Katarina"),
            Self::KAYLE        => Some("Kayle"),
            Self::KAYN         => Some("Kayn"),
            Self::KENNEN       => Some("Kennen"),
            Self::KHA_ZIX      => Some("Kha'Zix"),
            Self::KINDRED      => Some("Kindred"),
            Self::KLED         => Some("Kled"),
            Self::KOG_MAW      => Some("Kog'Maw"),
            Self::LE_BLANC     => Some("LeBlanc"),
            Self::LEE_SIN      => Some("Lee Sin"),
            Self::LEONA        => Some("Leona"),
            Self::LILLIA       => Some("Lillia"),
            Self::LISSANDRA    => Some("Lissandra"),
            Self::LUCIAN       => Some("Lucian"),
            Self::LULU         => Some("Lulu"),
            Self::LUX          => Some("Lux"),
            Self::MALPHITE     => Some("Malphite"),
            Self::MALZAHAR     => Some("Malzahar"),
            Self::MAOKAI       => Some("Maokai"),
            Self::MASTER_YI    => Some("Master Yi"),
            Self::MISS_FORTUNE => Some("Miss Fortune"),
            Self::MORDEKAISER  => Some("Mordekaiser"),
            Self::MORGANA      => Some("Morgana"),
            Self::NAMI         => Some("Nami"),
            Self::NASUS        => Some("Nasus"),
            Self::NAUTILUS     => Some("Nautilus"),
            Self::NEEKO        => Some("Neeko"),
            Self::NIDALEE      => Some("Nidalee"),
            Self::NOCTURNE     => Some("Nocturne"),
            Self::NUNU_WILLUMP => Some("Nunu & Willump"),
            Self::OLAF         => Some("Olaf"),
            Self::ORIANNA      => Some("Orianna"),
            Self::ORNN         => Some("Ornn"),
            Self::PANTHEON     => Some("Pantheon"),
            Self::POPPY        => Some("Poppy"),
            Self::PYKE         => Some("Pyke"),
            Self::QIYANA       => Some("Qiyana"),
            Self::QUINN        => Some("Quinn"),
            Self::RAKAN        => Some("Rakan"),
            Self::RAMMUS       => Some("Rammus"),
            Self::REK_SAI      => Some("Rek'Sai"),
            Self::RELL         => Some("Rell"),
            Self::RENEKTON     => Some("Renekton"),
            Self::RENGAR       => Some("Rengar"),
            Self::RIVEN        => Some("Riven"),
            Self::RUMBLE       => Some("Rumble"),
            Self::RYZE         => Some("Ryze"),
            Self::SAMIRA       => Some("Samira"),
            Self::SEJUANI      => Some("Sejuani"),
            Self::SENNA        => Some("Senna"),
            Self::SERAPHINE    => Some("Seraphine"),
            Self::SETT         => Some("Sett"),
            Self::SHACO        => Some("Shaco"),
            Self::SHEN         => Some("Shen"),
            Self::SHYVANA      => Some("Shyvana"),
            Self::SINGED       => Some("Singed"),
            Self::SION         => Some("Sion"),
            Self::SIVIR        => Some("Sivir"),
            Self::SKARNER      => Some("Skarner"),
            Self::SONA         => Some("Sona"),
            Self::SORAKA       => Some("Soraka"),
            Self::SWAIN        => Some("Swain"),
            Self::SYLAS        => Some("Sylas"),
            Self::SYNDRA       => Some("Syndra"),
            Self::TAHM_KENCH   => Some("Tahm Kench"),
            Self::TALIYAH      => Some("Taliyah"),
            Self::TALON        => Some("Talon"),
            Self::TARIC        => Some("Taric"),
            Self::TEEMO        => Some("Teemo"),
            Self::THRESH       => Some("Thresh"),
            Self::TRISTANA     => Some("Tristana"),
            Self::TRUNDLE      => Some("Trundle"),
            Self::TRYNDAMERE   => Some("Tryndamere"),
            Self::TWISTED_FATE => Some("Twisted Fate"),
            Self::TWITCH       => Some("Twitch"),
            Self::UDYR         => Some("Udyr"),
            Self::URGOT        => Some("Urgot"),
            Self::VARUS        => Some("Varus"),
            Self::VAYNE        => Some("Vayne"),
            Self::VEIGAR       => Some("Veigar"),
            Self::VEL_KOZ      => Some("Vel'Koz"),
            Self::VI           => Some("Vi"),
            Self::VIEGO        => Some("Viego"),
            Self::VIKTOR       => Some("Viktor"),
            Self::VLADIMIR     => Some("Vladimir"),
            Self::VOLIBEAR     => Some("Volibear"),
            Self::WARWICK      => Some("Warwick"),
            Self::WUKONG       => Some("Wukong"),
            Self::XAYAH        => Some("Xayah"),
            Self::XERATH       => Some("Xerath"),
            Self::XIN_ZHAO     => Some("Xin Zhao"),
            Self::YASUO        => Some("Yasuo"),
            Self::YONE         => Some("Yone"),
            Self::YORICK       => Some("Yorick"),
            Self::YUUMI        => Some("Yuumi"),
            Self::ZAC          => Some("Zac"),
            Self::ZED          => Some("Zed"),
            Self::ZIGGS        => Some("Ziggs"),
            Self::ZILEAN       => Some("Zilean"),
            Self::ZOE          => Some("Zoe"),
            Self::ZYRA         => Some("Zyra"),
            _ => None,
        }
    }

    /// The champion's identifier key. Somtimes called "key", "identifier", or "alias".
    /// This is mainly used in DDragon paths.
    ///
    /// This is generally the `en_US` name with spaces and punctuation removed,
    /// capitalization preserved, however the follow are exceptions:
    ///
    /// Field | Name | Identifier | Id
    /// ---|---|---|---
    /// `CHO_GATH` | "Cho'Gath" | "Chogath" | 31
    /// `FIDDLESTICKS` | "Fiddlesticks" | "FiddleSticks" | 9
    /// `KAI_SA` | "Kai'Sa" | "Kaisa" | 145
    /// `KHA_ZIX` | "Kha'Zix" | "Khazix" | 121
    /// `LE_BLANC` | "LeBlanc" | "Leblanc" | 7
    /// `NUNU_WILLUMP` | "Nunu & Willump" | "Nunu" | 20
    /// `VEL_KOZ` | "Vel'Koz" | "Velkoz" | 161
    /// `WUKONG` | "Wukong" | "MonkeyKing" | 62
    pub const fn identifier(self) -> Option<&'static str> {
        match self {
            Self::AATROX       => Some("Aatrox"),
            Self::AHRI         => Some("Ahri"),
            Self::AKALI        => Some("Akali"),
            Self::AKSHAN       => Some("Akshan"),
            Self::ALISTAR      => Some("Alistar"),
            Self::AMUMU        => Some("Amumu"),
            Self::ANIVIA       => Some("Anivia"),
            Self::ANNIE        => Some("Annie"),
            Self::APHELIOS     => Some("Aphelios"),
            Self::ASHE         => Some("Ashe"),
            Self::AURELION_SOL => Some("AurelionSol"),
            Self::AZIR         => Some("Azir"),
            Self::BARD         => Some("Bard"),
            Self::BLITZCRANK   => Some("Blitzcrank"),
            Self::BRAND        => Some("Brand"),
            Self::BRAUM        => Some("Braum"),
            Self::CAITLYN      => Some("Caitlyn"),
            Self::CAMILLE      => Some("Camille"),
            Self::CASSIOPEIA   => Some("Cassiopeia"),
            Self::CHO_GATH     => Some("Chogath"),
            Self::CORKI        => Some("Corki"),
            Self::DARIUS       => Some("Darius"),
            Self::DIANA        => Some("Diana"),
            Self::DR_MUNDO     => Some("DrMundo"),
            Self::DRAVEN       => Some("Draven"),
            Self::EKKO         => Some("Ekko"),
            Self::ELISE        => Some("Elise"),
            Self::EVELYNN      => Some("Evelynn"),
            Self::EZREAL       => Some("Ezreal"),
            Self::FIDDLESTICKS => Some("FiddleSticks"),
            Self::FIORA        => Some("Fiora"),
            Self::FIZZ         => Some("Fizz"),
            Self::GALIO        => Some("Galio"),
            Self::GANGPLANK    => Some("Gangplank"),
            Self::GAREN        => Some("Garen"),
            Self::GNAR         => Some("Gnar"),
            Self::GRAGAS       => Some("Gragas"),
            Self::GRAVES       => Some("Graves"),
            Self::GWEN         => Some("Gwen"),
            Self::HECARIM      => Some("Hecarim"),
            Self::HEIMERDINGER => Some("Heimerdinger"),
            Self::ILLAOI       => Some("Illaoi"),
            Self::IRELIA       => Some("Irelia"),
            Self::IVERN        => Some("Ivern"),
            Self::JANNA        => Some("Janna"),
            Self::JARVAN_IV    => Some("JarvanIV"),
            Self::JAX          => Some("Jax"),
            Self::JAYCE        => Some("Jayce"),
            Self::JHIN         => Some("Jhin"),
            Self::JINX         => Some("Jinx"),
            Self::KAI_SA       => Some("Kaisa"),
            Self::KALISTA      => Some("Kalista"),
            Self::KARMA        => Some("Karma"),
            Self::KARTHUS      => Some("Karthus"),
            Self::KASSADIN     => Some("Kassadin"),
            Self::KATARINA     => Some("Katarina"),
            Self::KAYLE        => Some("Kayle"),
            Self::KAYN         => Some("Kayn"),
            Self::KENNEN       => Some("Kennen"),
            Self::KHA_ZIX      => Some("Khazix"),
            Self::KINDRED      => Some("Kindred"),
            Self::KLED         => Some("Kled"),
            Self::KOG_MAW      => Some("KogMaw"),
            Self::LE_BLANC     => Some("Leblanc"),
            Self::LEE_SIN      => Some("LeeSin"),
            Self::LEONA        => Some("Leona"),
            Self::LILLIA       => Some("Lillia"),
            Self::LISSANDRA    => Some("Lissandra"),
            Self::LUCIAN       => Some("Lucian"),
            Self::LULU         => Some("Lulu"),
            Self::LUX          => Some("Lux"),
            Self::MALPHITE     => Some("Malphite"),
            Self::MALZAHAR     => Some("Malzahar"),
            Self::MAOKAI       => Some("Maokai"),
            Self::MASTER_YI    => Some("MasterYi"),
            Self::MISS_FORTUNE => Some("MissFortune"),
            Self::MORDEKAISER  => Some("Mordekaiser"),
            Self::MORGANA      => Some("Morgana"),
            Self::NAMI         => Some("Nami"),
            Self::NASUS        => Some("Nasus"),
            Self::NAUTILUS     => Some("Nautilus"),
            Self::NEEKO        => Some("Neeko"),
            Self::NIDALEE      => Some("Nidalee"),
            Self::NOCTURNE     => Some("Nocturne"),
            Self::NUNU_WILLUMP => Some("Nunu"),
            Self::OLAF         => Some("Olaf"),
            Self::ORIANNA      => Some("Orianna"),
            Self::ORNN         => Some("Ornn"),
            Self::PANTHEON     => Some("Pantheon"),
            Self::POPPY        => Some("Poppy"),
            Self::PYKE         => Some("Pyke"),
            Self::QIYANA       => Some("Qiyana"),
            Self::QUINN        => Some("Quinn"),
            Self::RAKAN        => Some("Rakan"),
            Self::RAMMUS       => Some("Rammus"),
            Self::REK_SAI      => Some("RekSai"),
            Self::RELL         => Some("Rell"),
            Self::RENEKTON     => Some("Renekton"),
            Self::RENGAR       => Some("Rengar"),
            Self::RIVEN        => Some("Riven"),
            Self::RUMBLE       => Some("Rumble"),
            Self::RYZE         => Some("Ryze"),
            Self::SAMIRA       => Some("Samira"),
            Self::SEJUANI      => Some("Sejuani"),
            Self::SENNA        => Some("Senna"),
            Self::SERAPHINE    => Some("Seraphine"),
            Self::SETT         => Some("Sett"),
            Self::SHACO        => Some("Shaco"),
            Self::SHEN         => Some("Shen"),
            Self::SHYVANA      => Some("Shyvana"),
            Self::SINGED       => Some("Singed"),
            Self::SION         => Some("Sion"),
            Self::SIVIR        => Some("Sivir"),
            Self::SKARNER      => Some("Skarner"),
            Self::SONA         => Some("Sona"),
            Self::SORAKA       => Some("Soraka"),
            Self::SWAIN        => Some("Swain"),
            Self::SYLAS        => Some("Sylas"),
            Self::SYNDRA       => Some("Syndra"),
            Self::TAHM_KENCH   => Some("TahmKench"),
            Self::TALIYAH      => Some("Taliyah"),
            Self::TALON        => Some("Talon"),
            Self::TARIC        => Some("Taric"),
            Self::TEEMO        => Some("Teemo"),
            Self::THRESH       => Some("Thresh"),
            Self::TRISTANA     => Some("Tristana"),
            Self::TRUNDLE      => Some("Trundle"),
            Self::TRYNDAMERE   => Some("Tryndamere"),
            Self::TWISTED_FATE => Some("TwistedFate"),
            Self::TWITCH       => Some("Twitch"),
            Self::UDYR         => Some("Udyr"),
            Self::URGOT        => Some("Urgot"),
            Self::VARUS        => Some("Varus"),
            Self::VAYNE        => Some("Vayne"),
            Self::VEIGAR       => Some("Veigar"),
            Self::VEL_KOZ      => Some("Velkoz"),
            Self::VI           => Some("Vi"),
            Self::VIEGO        => Some("Viego"),
            Self::VIKTOR       => Some("Viktor"),
            Self::VLADIMIR     => Some("Vladimir"),
            Self::VOLIBEAR     => Some("Volibear"),
            Self::WARWICK      => Some("Warwick"),
            Self::WUKONG       => Some("MonkeyKing"),
            Self::XAYAH        => Some("Xayah"),
            Self::XERATH       => Some("Xerath"),
            Self::XIN_ZHAO     => Some("XinZhao"),
            Self::YASUO        => Some("Yasuo"),
            Self::YONE         => Some("Yone"),
            Self::YORICK       => Some("Yorick"),
            Self::YUUMI        => Some("Yuumi"),
            Self::ZAC          => Some("Zac"),
            Self::ZED          => Some("Zed"),
            Self::ZIGGS        => Some("Ziggs"),
            Self::ZILEAN       => Some("Zilean"),
            Self::ZOE          => Some("Zoe"),
            Self::ZYRA         => Some("Zyra"),
            _ => None,
        }
    }
}

impl std::str::FromStr for Champion {
    type Err = ();
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s.chars()
            .take(4)
            .filter(|c| c.is_ascii_alphanumeric())
            .fold(0_u32, |hash, next| hash * 256 + u32::from(next))
        {
            0x41415452 /* AATR */ => Ok(Champion::AATROX),
            0x41485249 /* AHRI */ => Ok(Champion::AHRI),
            0x414b414c /* AKAL */ => Ok(Champion::AKALI),
            0x414b5348 /* AKSH */ => Ok(Champion::AKSHAN),
            0x414c4953 /* ALIS */ => Ok(Champion::ALISTAR),
            0x414d554d /* AMUM */ => Ok(Champion::AMUMU),
            0x414e4956 /* ANIV */ => Ok(Champion::ANIVIA),
            0x414e4e49 /* ANNI */ => Ok(Champion::ANNIE),
            0x41504845 /* APHE */ => Ok(Champion::APHELIOS),
            0x41534845 /* ASHE */ => Ok(Champion::ASHE),
            0x41555245 /* AURE */ => Ok(Champion::AURELION_SOL),
            0x415a4952 /* AZIR */ => Ok(Champion::AZIR),
            0x42415244 /* BARD */ => Ok(Champion::BARD),
            0x424c4954 /* BLIT */ => Ok(Champion::BLITZCRANK),
            0x4252414e /* BRAN */ => Ok(Champion::BRAND),
            0x42524155 /* BRAU */ => Ok(Champion::BRAUM),
            0x43414954 /* CAIT */ => Ok(Champion::CAITLYN),
            0x43414d49 /* CAMI */ => Ok(Champion::CAMILLE),
            0x43415353 /* CASS */ => Ok(Champion::CASSIOPEIA),
            0x43484f47 /* CHOG */ => Ok(Champion::CHO_GATH),
            0x43484f   /* CHO  */ => Ok(Champion::CHO_GATH),
            0x434f524b /* CORK */ => Ok(Champion::CORKI),
            0x44415249 /* DARI */ => Ok(Champion::DARIUS),
            0x4449414e /* DIAN */ => Ok(Champion::DIANA),
            0x44524d55 /* DRMU */ => Ok(Champion::DR_MUNDO),
            0x4452     /* DR   */ => Ok(Champion::DR_MUNDO),
            0x44524156 /* DRAV */ => Ok(Champion::DRAVEN),
            0x454b4b4f /* EKKO */ => Ok(Champion::EKKO),
            0x454c4953 /* ELIS */ => Ok(Champion::ELISE),
            0x4556454c /* EVEL */ => Ok(Champion::EVELYNN),
            0x455a5245 /* EZRE */ => Ok(Champion::EZREAL),
            0x46494444 /* FIDD */ => Ok(Champion::FIDDLESTICKS),
            0x46494f52 /* FIOR */ => Ok(Champion::FIORA),
            0x46495a5a /* FIZZ */ => Ok(Champion::FIZZ),
            0x47414c49 /* GALI */ => Ok(Champion::GALIO),
            0x47414e47 /* GANG */ => Ok(Champion::GANGPLANK),
            0x47415245 /* GARE */ => Ok(Champion::GAREN),
            0x474e4152 /* GNAR */ => Ok(Champion::GNAR),
            0x47524147 /* GRAG */ => Ok(Champion::GRAGAS),
            0x47524156 /* GRAV */ => Ok(Champion::GRAVES),
            0x4757454e /* GWEN */ => Ok(Champion::GWEN),
            0x48454341 /* HECA */ => Ok(Champion::HECARIM),
            0x4845494d /* HEIM */ => Ok(Champion::HEIMERDINGER),
            0x494c4c41 /* ILLA */ => Ok(Champion::ILLAOI),
            0x4952454c /* IREL */ => Ok(Champion::IRELIA),
            0x49564552 /* IVER */ => Ok(Champion::IVERN),
            0x4a414e4e /* JANN */ => Ok(Champion::JANNA),
            0x4a415256 /* JARV */ => Ok(Champion::JARVAN_IV),
            0x4a4158   /* JAX  */ => Ok(Champion::JAX),
            0x4a415943 /* JAYC */ => Ok(Champion::JAYCE),
            0x4a48494e /* JHIN */ => Ok(Champion::JHIN),
            0x4a494e58 /* JINX */ => Ok(Champion::JINX),
            0x4b414953 /* KAIS */ => Ok(Champion::KAI_SA),
            0x4b4149   /* KAI  */ => Ok(Champion::KAI_SA),
            0x4b414c49 /* KALI */ => Ok(Champion::KALISTA),
            0x4b41524d /* KARM */ => Ok(Champion::KARMA),
            0x4b415254 /* KART */ => Ok(Champion::KARTHUS),
            0x4b415353 /* KASS */ => Ok(Champion::KASSADIN),
            0x4b415441 /* KATA */ => Ok(Champion::KATARINA),
            0x4b41594c /* KAYL */ => Ok(Champion::KAYLE),
            0x4b41594e /* KAYN */ => Ok(Champion::KAYN),
            0x4b454e4e /* KENN */ => Ok(Champion::KENNEN),
            0x4b48415a /* KHAZ */ => Ok(Champion::KHA_ZIX),
            0x4b4841   /* KHA  */ => Ok(Champion::KHA_ZIX),
            0x4b494e44 /* KIND */ => Ok(Champion::KINDRED),
            0x4b4c4544 /* KLED */ => Ok(Champion::KLED),
            0x4b4f474d /* KOGM */ => Ok(Champion::KOG_MAW),
            0x4b4f47   /* KOG  */ => Ok(Champion::KOG_MAW),
            0x4c45424c /* LEBL */ => Ok(Champion::LE_BLANC),
            0x4c454553 /* LEES */ => Ok(Champion::LEE_SIN),
            0x4c4545   /* LEE  */ => Ok(Champion::LEE_SIN),
            0x4c454f4e /* LEON */ => Ok(Champion::LEONA),
            0x4c494c4c /* LILL */ => Ok(Champion::LILLIA),
            0x4c495353 /* LISS */ => Ok(Champion::LISSANDRA),
            0x4c554349 /* LUCI */ => Ok(Champion::LUCIAN),
            0x4c554c55 /* LULU */ => Ok(Champion::LULU),
            0x4c5558   /* LUX  */ => Ok(Champion::LUX),
            0x4d414c50 /* MALP */ => Ok(Champion::MALPHITE),
            0x4d414c5a /* MALZ */ => Ok(Champion::MALZAHAR),
            0x4d414f4b /* MAOK */ => Ok(Champion::MAOKAI),
            0x4d415354 /* MAST */ => Ok(Champion::MASTER_YI),
            0x4d495353 /* MISS */ => Ok(Champion::MISS_FORTUNE),
            0x4d4f5244 /* MORD */ => Ok(Champion::MORDEKAISER),
            0x4d4f5247 /* MORG */ => Ok(Champion::MORGANA),
            0x4e414d49 /* NAMI */ => Ok(Champion::NAMI),
            0x4e415355 /* NASU */ => Ok(Champion::NASUS),
            0x4e415554 /* NAUT */ => Ok(Champion::NAUTILUS),
            0x4e45454b /* NEEK */ => Ok(Champion::NEEKO),
            0x4e494441 /* NIDA */ => Ok(Champion::NIDALEE),
            0x4e4f4354 /* NOCT */ => Ok(Champion::NOCTURNE),
            0x4e554e55 /* NUNU */ => Ok(Champion::NUNU_WILLUMP),
            0x4f4c4146 /* OLAF */ => Ok(Champion::OLAF),
            0x4f524941 /* ORIA */ => Ok(Champion::ORIANNA),
            0x4f524e4e /* ORNN */ => Ok(Champion::ORNN),
            0x50414e54 /* PANT */ => Ok(Champion::PANTHEON),
            0x504f5050 /* POPP */ => Ok(Champion::POPPY),
            0x50594b45 /* PYKE */ => Ok(Champion::PYKE),
            0x51495941 /* QIYA */ => Ok(Champion::QIYANA),
            0x5155494e /* QUIN */ => Ok(Champion::QUINN),
            0x52414b41 /* RAKA */ => Ok(Champion::RAKAN),
            0x52414d4d /* RAMM */ => Ok(Champion::RAMMUS),
            0x52454b53 /* REKS */ => Ok(Champion::REK_SAI),
            0x52454b   /* REK  */ => Ok(Champion::REK_SAI),
            0x52454c4c /* RELL */ => Ok(Champion::RELL),
            0x52454e45 /* RENE */ => Ok(Champion::RENEKTON),
            0x52454e47 /* RENG */ => Ok(Champion::RENGAR),
            0x52495645 /* RIVE */ => Ok(Champion::RIVEN),
            0x52554d42 /* RUMB */ => Ok(Champion::RUMBLE),
            0x52595a45 /* RYZE */ => Ok(Champion::RYZE),
            0x53414d49 /* SAMI */ => Ok(Champion::SAMIRA),
            0x53454a55 /* SEJU */ => Ok(Champion::SEJUANI),
            0x53454e4e /* SENN */ => Ok(Champion::SENNA),
            0x53455241 /* SERA */ => Ok(Champion::SERAPHINE),
            0x53455454 /* SETT */ => Ok(Champion::SETT),
            0x53484143 /* SHAC */ => Ok(Champion::SHACO),
            0x5348454e /* SHEN */ => Ok(Champion::SHEN),
            0x53485956 /* SHYV */ => Ok(Champion::SHYVANA),
            0x53494e47 /* SING */ => Ok(Champion::SINGED),
            0x53494f4e /* SION */ => Ok(Champion::SION),
            0x53495649 /* SIVI */ => Ok(Champion::SIVIR),
            0x534b4152 /* SKAR */ => Ok(Champion::SKARNER),
            0x534f4e41 /* SONA */ => Ok(Champion::SONA),
            0x534f5241 /* SORA */ => Ok(Champion::SORAKA),
            0x53574149 /* SWAI */ => Ok(Champion::SWAIN),
            0x53594c41 /* SYLA */ => Ok(Champion::SYLAS),
            0x53594e44 /* SYND */ => Ok(Champion::SYNDRA),
            0x5441484d /* TAHM */ => Ok(Champion::TAHM_KENCH),
            0x54414c49 /* TALI */ => Ok(Champion::TALIYAH),
            0x54414c4f /* TALO */ => Ok(Champion::TALON),
            0x54415249 /* TARI */ => Ok(Champion::TARIC),
            0x5445454d /* TEEM */ => Ok(Champion::TEEMO),
            0x54485245 /* THRE */ => Ok(Champion::THRESH),
            0x54524953 /* TRIS */ => Ok(Champion::TRISTANA),
            0x5452554e /* TRUN */ => Ok(Champion::TRUNDLE),
            0x5452594e /* TRYN */ => Ok(Champion::TRYNDAMERE),
            0x54574953 /* TWIS */ => Ok(Champion::TWISTED_FATE),
            0x54574954 /* TWIT */ => Ok(Champion::TWITCH),
            0x55445952 /* UDYR */ => Ok(Champion::UDYR),
            0x5552474f /* URGO */ => Ok(Champion::URGOT),
            0x56415255 /* VARU */ => Ok(Champion::VARUS),
            0x5641594e /* VAYN */ => Ok(Champion::VAYNE),
            0x56454947 /* VEIG */ => Ok(Champion::VEIGAR),
            0x56454c4b /* VELK */ => Ok(Champion::VEL_KOZ),
            0x56454c   /* VEL  */ => Ok(Champion::VEL_KOZ),
            0x5649     /* VI   */ => Ok(Champion::VI),
            0x56494547 /* VIEG */ => Ok(Champion::VIEGO),
            0x56494b54 /* VIKT */ => Ok(Champion::VIKTOR),
            0x564c4144 /* VLAD */ => Ok(Champion::VLADIMIR),
            0x564f4c49 /* VOLI */ => Ok(Champion::VOLIBEAR),
            0x57415257 /* WARW */ => Ok(Champion::WARWICK),
            0x57554b4f /* WUKO */ => Ok(Champion::WUKONG),
            0x4d4f4e4b /* MONK */ => Ok(Champion::WUKONG),
            0x58415941 /* XAYA */ => Ok(Champion::XAYAH),
            0x58455241 /* XERA */ => Ok(Champion::XERATH),
            0x58494e5a /* XINZ */ => Ok(Champion::XIN_ZHAO),
            0x58494e   /* XIN  */ => Ok(Champion::XIN_ZHAO),
            0x59415355 /* YASU */ => Ok(Champion::YASUO),
            0x594f4e45 /* YONE */ => Ok(Champion::YONE),
            0x594f5249 /* YORI */ => Ok(Champion::YORICK),
            0x5955554d /* YUUM */ => Ok(Champion::YUUMI),
            0x5a4143   /* ZAC  */ => Ok(Champion::ZAC),
            0x5a4544   /* ZED  */ => Ok(Champion::ZED),
            0x5a494747 /* ZIGG */ => Ok(Champion::ZIGGS),
            0x5a494c45 /* ZILE */ => Ok(Champion::ZILEAN),
            0x5a4f45   /* ZOE  */ => Ok(Champion::ZOE),
            0x5a595241 /* ZYRA */ => Ok(Champion::ZYRA),
            _ => Err(()),
        }
    }
}

impl std::convert::TryFrom<&str> for Champion {
    type Error = <Self as std::str::FromStr>::Err;
    fn try_from(value: &str) -> Result<Self, Self::Error> {
        <Self as std::str::FromStr>::from_str(value)
    }
}
