///////////////////////////////////////////////
//                                           //
//                     !                     //
//   This file is automatically generated!   //
//           Do not directly edit!           //
//                                           //
///////////////////////////////////////////////

// http://www.mingweisamuel.com/riotapi-schema/tool/
// Version 1f61128ea79f3d07bd47c2f585e9f22905bed753

//! Automatically generated endpoint handles.

use crate::models::*;

use std::future::Future;
use std::vec::Vec;

use url::form_urlencoded::Serializer;

use crate::Result;
use crate::consts::Region;
use crate::riot_api::RiotApi;

impl RiotApi {
    /// Returns a handle for accessing [AccountV1](crate::endpoints::AccountV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#account-v1" target="_blank">`account-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn account_v1(&self) -> AccountV1 {
        AccountV1 { base: self }
    }
    /// Returns a handle for accessing [ChampionMasteryV4](crate::endpoints::ChampionMasteryV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#champion-mastery-v4" target="_blank">`champion-mastery-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn champion_mastery_v4(&self) -> ChampionMasteryV4 {
        ChampionMasteryV4 { base: self }
    }
    /// Returns a handle for accessing [ChampionV3](crate::endpoints::ChampionV3) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#champion-v3" target="_blank">`champion-v3`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn champion_v3(&self) -> ChampionV3 {
        ChampionV3 { base: self }
    }
    /// Returns a handle for accessing [ClashV1](crate::endpoints::ClashV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#clash-v1" target="_blank">`clash-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn clash_v1(&self) -> ClashV1 {
        ClashV1 { base: self }
    }
    /// Returns a handle for accessing [LeagueExpV4](crate::endpoints::LeagueExpV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#league-exp-v4" target="_blank">`league-exp-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn league_exp_v4(&self) -> LeagueExpV4 {
        LeagueExpV4 { base: self }
    }
    /// Returns a handle for accessing [LeagueV4](crate::endpoints::LeagueV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#league-v4" target="_blank">`league-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn league_v4(&self) -> LeagueV4 {
        LeagueV4 { base: self }
    }
    /// Returns a handle for accessing [LolStatusV3](crate::endpoints::LolStatusV3) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lol-status-v3" target="_blank">`lol-status-v3`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lol_status_v3(&self) -> LolStatusV3 {
        LolStatusV3 { base: self }
    }
    /// Returns a handle for accessing [LolStatusV4](crate::endpoints::LolStatusV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lol-status-v4" target="_blank">`lol-status-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lol_status_v4(&self) -> LolStatusV4 {
        LolStatusV4 { base: self }
    }
    /// Returns a handle for accessing [LorDeckV1](crate::endpoints::LorDeckV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-deck-v1" target="_blank">`lor-deck-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_deck_v1(&self) -> LorDeckV1 {
        LorDeckV1 { base: self }
    }
    /// Returns a handle for accessing [LorInventoryV1](crate::endpoints::LorInventoryV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-inventory-v1" target="_blank">`lor-inventory-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_inventory_v1(&self) -> LorInventoryV1 {
        LorInventoryV1 { base: self }
    }
    /// Returns a handle for accessing [LorMatchV1](crate::endpoints::LorMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-match-v1" target="_blank">`lor-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_match_v1(&self) -> LorMatchV1 {
        LorMatchV1 { base: self }
    }
    /// Returns a handle for accessing [LorRankedV1](crate::endpoints::LorRankedV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-ranked-v1" target="_blank">`lor-ranked-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_ranked_v1(&self) -> LorRankedV1 {
        LorRankedV1 { base: self }
    }
    /// Returns a handle for accessing [LorStatusV1](crate::endpoints::LorStatusV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#lor-status-v1" target="_blank">`lor-status-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn lor_status_v1(&self) -> LorStatusV1 {
        LorStatusV1 { base: self }
    }
    /// Returns a handle for accessing [MatchV5](crate::endpoints::MatchV5) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#match-v5" target="_blank">`match-v5`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn match_v5(&self) -> MatchV5 {
        MatchV5 { base: self }
    }
    /// Returns a handle for accessing [SpectatorV4](crate::endpoints::SpectatorV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#spectator-v4" target="_blank">`spectator-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn spectator_v4(&self) -> SpectatorV4 {
        SpectatorV4 { base: self }
    }
    /// Returns a handle for accessing [SummonerV4](crate::endpoints::SummonerV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#summoner-v4" target="_blank">`summoner-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn summoner_v4(&self) -> SummonerV4 {
        SummonerV4 { base: self }
    }
    /// Returns a handle for accessing [TftLeagueV1](crate::endpoints::TftLeagueV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-league-v1" target="_blank">`tft-league-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_league_v1(&self) -> TftLeagueV1 {
        TftLeagueV1 { base: self }
    }
    /// Returns a handle for accessing [TftMatchV1](crate::endpoints::TftMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-match-v1" target="_blank">`tft-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_match_v1(&self) -> TftMatchV1 {
        TftMatchV1 { base: self }
    }
    /// Returns a handle for accessing [TftSummonerV1](crate::endpoints::TftSummonerV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tft-summoner-v1" target="_blank">`tft-summoner-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tft_summoner_v1(&self) -> TftSummonerV1 {
        TftSummonerV1 { base: self }
    }
    /// Returns a handle for accessing [ThirdPartyCodeV4](crate::endpoints::ThirdPartyCodeV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#third-party-code-v4" target="_blank">`third-party-code-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn third_party_code_v4(&self) -> ThirdPartyCodeV4 {
        ThirdPartyCodeV4 { base: self }
    }
    /// Returns a handle for accessing [TournamentStubV4](crate::endpoints::TournamentStubV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tournament-stub-v4" target="_blank">`tournament-stub-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tournament_stub_v4(&self) -> TournamentStubV4 {
        TournamentStubV4 { base: self }
    }
    /// Returns a handle for accessing [TournamentV4](crate::endpoints::TournamentV4) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#tournament-v4" target="_blank">`tournament-v4`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn tournament_v4(&self) -> TournamentV4 {
        TournamentV4 { base: self }
    }
    /// Returns a handle for accessing [ValContentV1](crate::endpoints::ValContentV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-content-v1" target="_blank">`val-content-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_content_v1(&self) -> ValContentV1 {
        ValContentV1 { base: self }
    }
    /// Returns a handle for accessing [ValMatchV1](crate::endpoints::ValMatchV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-match-v1" target="_blank">`val-match-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_match_v1(&self) -> ValMatchV1 {
        ValMatchV1 { base: self }
    }
    /// Returns a handle for accessing [ValRankedV1](crate::endpoints::ValRankedV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-ranked-v1" target="_blank">`val-ranked-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_ranked_v1(&self) -> ValRankedV1 {
        ValRankedV1 { base: self }
    }
    /// Returns a handle for accessing [ValStatusV1](crate::endpoints::ValStatusV1) endpoints.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/apis#val-status-v1" target="_blank">`val-status-v1`</a>
    ///
    /// Note: this method is automatically generated.
    #[inline]
    pub fn val_status_v1(&self) -> ValStatusV1 {
        ValStatusV1 { base: self }
    }
}

/// AccountV1 endpoints handle, accessed by calling [`account_v1()`](crate::RiotApi::account_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#account-v1" target="_blank">`account-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct AccountV1<'a> {
    base: &'a RiotApi,
}
impl<'a> AccountV1<'a> {
    /// Get account by puuid
    /// # Parameters
    /// * `region` - Region to query.
    /// * `puuid`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getByPuuid" target="_blank">`account-v1.getByPuuid`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, region: Region, puuid: &str)
        -> impl Future<Output = Result<account_v1::Account>> + 'a
    {
        let path_string = format!("/riot/account/v1/accounts/by-puuid/{}", puuid);
        self.base.get::<account_v1::Account>("account-v1.getByPuuid", region.into(), path_string, None)
    }

    /// Get account by riot id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tagLine` - When querying for a player by their riot id, the gameName and tagLine query params are required. However not all accounts have a gameName and tagLine associated so these fields may not be included in the response.
    /// * `gameName` - When querying for a player by their riot id, the gameName and tagLine query params are required. However not all accounts have a gameName and tagLine associated so these fields may not be included in the response.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getByRiotId" target="_blank">`account-v1.getByRiotId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_riot_id(&self, region: Region, game_name: &str, tag_line: &str)
        -> impl Future<Output = Result<Option<account_v1::Account>>> + 'a
    {
        let path_string = format!("/riot/account/v1/accounts/by-riot-id/{}/{}", game_name, tag_line);
        self.base.get_optional::<account_v1::Account>("account-v1.getByRiotId", region.into(), path_string, None)
    }

    /// Get active shard for a player
    /// # Parameters
    /// * `region` - Region to query.
    /// * `game`
    /// * `puuid`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#account-v1/GET_getActiveShard" target="_blank">`account-v1.getActiveShard`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_active_shard(&self, region: Region, game: &str, puuid: &str)
        -> impl Future<Output = Result<Option<account_v1::ActiveShard>>> + 'a
    {
        let path_string = format!("/riot/account/v1/active-shards/by-game/{}/by-puuid/{}", game, puuid);
        self.base.get_optional::<account_v1::ActiveShard>("account-v1.getActiveShard", region.into(), path_string, None)
    }

}

/// ChampionMasteryV4 endpoints handle, accessed by calling [`champion_mastery_v4()`](crate::RiotApi::champion_mastery_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#champion-mastery-v4" target="_blank">`champion-mastery-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct ChampionMasteryV4<'a> {
    base: &'a RiotApi,
}
impl<'a> ChampionMasteryV4<'a> {
    /// Get all champion mastery entries sorted by number of champion points descending,
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId` - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getAllChampionMasteries" target="_blank">`champion-mastery-v4.getAllChampionMasteries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_all_champion_masteries(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Vec<champion_mastery_v4::ChampionMastery>>> + 'a
    {
        let path_string = format!("/lol/champion-mastery/v4/champion-masteries/by-summoner/{}", encrypted_summoner_id);
        self.base.get::<Vec<champion_mastery_v4::ChampionMastery>>("champion-mastery-v4.getAllChampionMasteries", region.into(), path_string, None)
    }

    /// Get a champion mastery by player ID and champion ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `championId` - Champion ID to retrieve Champion Mastery for
    /// * `encryptedSummonerId` - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getChampionMastery" target="_blank">`champion-mastery-v4.getChampionMastery`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_mastery(&self, region: Region, encrypted_summoner_id: &str, champion_id: crate::consts::Champion)
        -> impl Future<Output = Result<Option<champion_mastery_v4::ChampionMastery>>> + 'a
    {
        let path_string = format!("/lol/champion-mastery/v4/champion-masteries/by-summoner/{}/by-champion/{}", encrypted_summoner_id, champion_id);
        self.base.get_optional::<champion_mastery_v4::ChampionMastery>("champion-mastery-v4.getChampionMastery", region.into(), path_string, None)
    }

    /// Get a player's total champion mastery score, which is the sum of individual champion mastery levels.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId` - Summoner ID associated with the player
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-mastery-v4/GET_getChampionMasteryScore" target="_blank">`champion-mastery-v4.getChampionMasteryScore`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_mastery_score(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<i32>> + 'a
    {
        let path_string = format!("/lol/champion-mastery/v4/scores/by-summoner/{}", encrypted_summoner_id);
        self.base.get::<i32>("champion-mastery-v4.getChampionMasteryScore", region.into(), path_string, None)
    }

}

/// ChampionV3 endpoints handle, accessed by calling [`champion_v3()`](crate::RiotApi::champion_v3) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#champion-v3" target="_blank">`champion-v3`</a>
///
/// Note: this struct is automatically generated.
pub struct ChampionV3<'a> {
    base: &'a RiotApi,
}
impl<'a> ChampionV3<'a> {
    /// Returns champion rotations, including free-to-play and low-level free-to-play rotations (REST)
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#champion-v3/GET_getChampionInfo" target="_blank">`champion-v3.getChampionInfo`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_champion_info(&self, region: Region)
        -> impl Future<Output = Result<champion_v3::ChampionInfo>> + 'a
    {
        let path_string = "/lol/platform/v3/champion-rotations".to_owned();
        self.base.get::<champion_v3::ChampionInfo>("champion-v3.getChampionInfo", region.into(), path_string, None)
    }

}

/// ClashV1 endpoints handle, accessed by calling [`clash_v1()`](crate::RiotApi::clash_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#clash-v1" target="_blank">`clash-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct ClashV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ClashV1<'a> {
    /// Get players by summoner ID.
    /// ## Implementation Notes
    /// This endpoint returns a list of active Clash players for a given summoner ID. If a summoner registers for multiple tournaments at the same time (e.g., Saturday and Sunday) then both registrations would appear in this list.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `summonerId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getPlayersBySummoner" target="_blank">`clash-v1.getPlayersBySummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_players_by_summoner(&self, region: Region, summoner_id: &str)
        -> impl Future<Output = Result<Vec<clash_v1::Player>>> + 'a
    {
        let path_string = format!("/lol/clash/v1/players/by-summoner/{}", summoner_id);
        self.base.get::<Vec<clash_v1::Player>>("clash-v1.getPlayersBySummoner", region.into(), path_string, None)
    }

    /// Get team by ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `teamId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTeamById" target="_blank">`clash-v1.getTeamById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_team_by_id(&self, region: Region, team_id: &str)
        -> impl Future<Output = Result<Option<clash_v1::Team>>> + 'a
    {
        let path_string = format!("/lol/clash/v1/teams/{}", team_id);
        self.base.get_optional::<clash_v1::Team>("clash-v1.getTeamById", region.into(), path_string, None)
    }

    /// Get all active or upcoming tournaments.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournaments" target="_blank">`clash-v1.getTournaments`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournaments(&self, region: Region)
        -> impl Future<Output = Result<Vec<clash_v1::Tournament>>> + 'a
    {
        let path_string = "/lol/clash/v1/tournaments".to_owned();
        self.base.get::<Vec<clash_v1::Tournament>>("clash-v1.getTournaments", region.into(), path_string, None)
    }

    /// Get tournament by team ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `teamId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournamentByTeam" target="_blank">`clash-v1.getTournamentByTeam`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_by_team(&self, region: Region, team_id: &str)
        -> impl Future<Output = Result<Option<clash_v1::Tournament>>> + 'a
    {
        let path_string = format!("/lol/clash/v1/tournaments/by-team/{}", team_id);
        self.base.get_optional::<clash_v1::Tournament>("clash-v1.getTournamentByTeam", region.into(), path_string, None)
    }

    /// Get tournament by ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tournamentId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#clash-v1/GET_getTournamentById" target="_blank">`clash-v1.getTournamentById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_by_id(&self, region: Region, tournament_id: i32)
        -> impl Future<Output = Result<Option<clash_v1::Tournament>>> + 'a
    {
        let path_string = format!("/lol/clash/v1/tournaments/{}", tournament_id);
        self.base.get_optional::<clash_v1::Tournament>("clash-v1.getTournamentById", region.into(), path_string, None)
    }

}

/// LeagueExpV4 endpoints handle, accessed by calling [`league_exp_v4()`](crate::RiotApi::league_exp_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#league-exp-v4" target="_blank">`league-exp-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct LeagueExpV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LeagueExpV4<'a> {
    /// Get all the league entries.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue` - Note that the queue value must be a valid ranked queue.
    /// * `tier`
    /// * `division`
    /// * `page` (optional) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-exp-v4/GET_getLeagueEntries" target="_blank">`league-exp-v4.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, region: Region, queue: crate::consts::QueueType, tier: crate::consts::Tier, division: crate::consts::Division, page: Option<i32>)
        -> impl Future<Output = Result<Vec<league_exp_v4::LeagueEntry>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(page) = page { query_params.append_pair("page", &*page.to_string()); };
        let query_string = query_params.finish();
        let path_string = format!("/lol/league-exp/v4/entries/{}/{}/{}", queue, tier, division);
        self.base.get::<Vec<league_exp_v4::LeagueEntry>>("league-exp-v4.getLeagueEntries", region.into(), path_string, Some(query_string))
    }

}

/// LeagueV4 endpoints handle, accessed by calling [`league_v4()`](crate::RiotApi::league_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#league-v4" target="_blank">`league-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct LeagueV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LeagueV4<'a> {
    /// Get the challenger league for given queue.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getChallengerLeague" target="_blank">`league-v4.getChallengerLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_challenger_league(&self, region: Region, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let path_string = format!("/lol/league/v4/challengerleagues/by-queue/{}", queue);
        self.base.get::<league_v4::LeagueList>("league-v4.getChallengerLeague", region.into(), path_string, None)
    }

    /// Get league entries in all queues for a given summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueEntriesForSummoner" target="_blank">`league-v4.getLeagueEntriesForSummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries_for_summoner(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Vec<league_v4::LeagueEntry>>> + 'a
    {
        let path_string = format!("/lol/league/v4/entries/by-summoner/{}", encrypted_summoner_id);
        self.base.get::<Vec<league_v4::LeagueEntry>>("league-v4.getLeagueEntriesForSummoner", region.into(), path_string, None)
    }

    /// Get all the league entries.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `division`
    /// * `tier`
    /// * `queue` - Note that the queue value must be a valid ranked queue.
    /// * `page` (optional) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueEntries" target="_blank">`league-v4.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, region: Region, queue: crate::consts::QueueType, tier: crate::consts::Tier, division: crate::consts::Division, page: Option<i32>)
        -> impl Future<Output = Result<Vec<league_v4::LeagueEntry>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(page) = page { query_params.append_pair("page", &*page.to_string()); };
        let query_string = query_params.finish();
        let path_string = format!("/lol/league/v4/entries/{}/{}/{}", queue, tier, division);
        self.base.get::<Vec<league_v4::LeagueEntry>>("league-v4.getLeagueEntries", region.into(), path_string, Some(query_string))
    }

    /// Get the grandmaster league of a specific queue.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getGrandmasterLeague" target="_blank">`league-v4.getGrandmasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_grandmaster_league(&self, region: Region, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let path_string = format!("/lol/league/v4/grandmasterleagues/by-queue/{}", queue);
        self.base.get::<league_v4::LeagueList>("league-v4.getGrandmasterLeague", region.into(), path_string, None)
    }

    /// Get league with given ID, including inactive entries.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `leagueId` - The UUID of the league.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getLeagueById" target="_blank">`league-v4.getLeagueById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_by_id(&self, region: Region, league_id: &str)
        -> impl Future<Output = Result<Option<league_v4::LeagueList>>> + 'a
    {
        let path_string = format!("/lol/league/v4/leagues/{}", league_id);
        self.base.get_optional::<league_v4::LeagueList>("league-v4.getLeagueById", region.into(), path_string, None)
    }

    /// Get the master league for given queue.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#league-v4/GET_getMasterLeague" target="_blank">`league-v4.getMasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_master_league(&self, region: Region, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<league_v4::LeagueList>> + 'a
    {
        let path_string = format!("/lol/league/v4/masterleagues/by-queue/{}", queue);
        self.base.get::<league_v4::LeagueList>("league-v4.getMasterLeague", region.into(), path_string, None)
    }

}

/// LolStatusV3 endpoints handle, accessed by calling [`lol_status_v3()`](crate::RiotApi::lol_status_v3) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lol-status-v3" target="_blank">`lol-status-v3`</a>
///
/// Note: this struct is automatically generated.
pub struct LolStatusV3<'a> {
    base: &'a RiotApi,
}
impl<'a> LolStatusV3<'a> {
    /// Get League of Legends status for the given shard.
    /// ## Rate Limit Notes
    /// Requests to this API are not counted against the application Rate Limits.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lol-status-v3/GET_getShardData" target="_blank">`lol-status-v3.getShardData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_shard_data(&self, region: Region)
        -> impl Future<Output = Result<lol_status_v3::ShardStatus>> + 'a
    {
        let path_string = "/lol/status/v3/shard-data".to_owned();
        self.base.get::<lol_status_v3::ShardStatus>("lol-status-v3.getShardData", region.into(), path_string, None)
    }

}

/// LolStatusV4 endpoints handle, accessed by calling [`lol_status_v4()`](crate::RiotApi::lol_status_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lol-status-v4" target="_blank">`lol-status-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct LolStatusV4<'a> {
    base: &'a RiotApi,
}
impl<'a> LolStatusV4<'a> {
    /// Get League of Legends status for the given platform.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lol-status-v4/GET_getPlatformData" target="_blank">`lol-status-v4.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, region: Region)
        -> impl Future<Output = Result<lol_status_v4::PlatformData>> + 'a
    {
        let path_string = "/lol/status/v4/platform-data".to_owned();
        self.base.get::<lol_status_v4::PlatformData>("lol-status-v4.getPlatformData", region.into(), path_string, None)
    }

}

/// LorDeckV1 endpoints handle, accessed by calling [`lor_deck_v1()`](crate::RiotApi::lor_deck_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-deck-v1" target="_blank">`lor-deck-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct LorDeckV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorDeckV1<'a> {
}

/// LorInventoryV1 endpoints handle, accessed by calling [`lor_inventory_v1()`](crate::RiotApi::lor_inventory_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-inventory-v1" target="_blank">`lor-inventory-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct LorInventoryV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorInventoryV1<'a> {
}

/// LorMatchV1 endpoints handle, accessed by calling [`lor_match_v1()`](crate::RiotApi::lor_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-match-v1" target="_blank">`lor-match-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct LorMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorMatchV1<'a> {
    /// Get a list of match ids by PUUID
    /// # Parameters
    /// * `region` - Region to query.
    /// * `puuid`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-match-v1/GET_getMatchIdsByPUUID" target="_blank">`lor-match-v1.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, region: Region, puuid: &str)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let path_string = format!("/lor/match/v1/matches/by-puuid/{}/ids", puuid);
        self.base.get::<Vec<String>>("lor-match-v1.getMatchIdsByPUUID", region.into(), path_string, None)
    }

    /// Get match by id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `matchId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-match-v1/GET_getMatch" target="_blank">`lor-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, region: Region, match_id: &str)
        -> impl Future<Output = Result<lor_match_v1::Match>> + 'a
    {
        let path_string = format!("/lor/match/v1/matches/{}", match_id);
        self.base.get::<lor_match_v1::Match>("lor-match-v1.getMatch", region.into(), path_string, None)
    }

}

/// LorRankedV1 endpoints handle, accessed by calling [`lor_ranked_v1()`](crate::RiotApi::lor_ranked_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-ranked-v1" target="_blank">`lor-ranked-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct LorRankedV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorRankedV1<'a> {
    /// Get the players in Master tier.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-ranked-v1/GET_getLeaderboards" target="_blank">`lor-ranked-v1.getLeaderboards`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_leaderboards(&self, region: Region)
        -> impl Future<Output = Result<lor_ranked_v1::Leaderboard>> + 'a
    {
        let path_string = "/lor/ranked/v1/leaderboards".to_owned();
        self.base.get::<lor_ranked_v1::Leaderboard>("lor-ranked-v1.getLeaderboards", region.into(), path_string, None)
    }

}

/// LorStatusV1 endpoints handle, accessed by calling [`lor_status_v1()`](crate::RiotApi::lor_status_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#lor-status-v1" target="_blank">`lor-status-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct LorStatusV1<'a> {
    base: &'a RiotApi,
}
impl<'a> LorStatusV1<'a> {
    /// Get Legends of Runeterra status for the given platform.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#lor-status-v1/GET_getPlatformData" target="_blank">`lor-status-v1.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, region: Region)
        -> impl Future<Output = Result<lor_status_v1::PlatformData>> + 'a
    {
        let path_string = "/lor/status/v1/platform-data".to_owned();
        self.base.get::<lor_status_v1::PlatformData>("lor-status-v1.getPlatformData", region.into(), path_string, None)
    }

}

/// MatchV5 endpoints handle, accessed by calling [`match_v5()`](crate::RiotApi::match_v5) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#match-v5" target="_blank">`match-v5`</a>
///
/// Note: this struct is automatically generated.
pub struct MatchV5<'a> {
    base: &'a RiotApi,
}
impl<'a> MatchV5<'a> {
    /// Get a list of match ids by puuid
    /// # Parameters
    /// * `region` - Region to query.
    /// * `puuid`
    /// * `startTime` (optional) - Epoch timestamp in seconds. The matchlist started storing timestamps on June 16th, 2021. Any matches played before June 16th, 2021 won't be included in the results if the startTime filter is set.
    /// * `endTime` (optional) - Epoch timestamp in seconds.
    /// * `queue` (optional) - Filter the list of match ids by a specific queue id. This filter is mutually inclusive of the type filter meaning any match ids returned must match both the queue and type filters.
    /// * `type` (optional) - Filter the list of match ids by the type of match. This filter is mutually inclusive of the queue filter meaning any match ids returned must match both the queue and type filters.
    /// * `start` (optional) - Defaults to 0. Start index.
    /// * `count` (optional) - Defaults to 20. Valid values: 0 to 100. Number of match ids to return.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getMatchIdsByPUUID" target="_blank">`match-v5.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, region: Region, puuid: &str, count: Option<i32>, end_time: Option<i64>, queue: Option<crate::consts::Queue>, start_time: Option<i64>, start: Option<i32>, r#type: Option<&str>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(count) = count { query_params.append_pair("count", &*count.to_string()); };
        if let Some(end_time) = end_time { query_params.append_pair("endTime", &*end_time.to_string()); };
        if let Some(queue) = queue { query_params.append_pair("queue", &*Into::<u16>::into(queue).to_string()); };
        if let Some(start_time) = start_time { query_params.append_pair("startTime", &*start_time.to_string()); };
        if let Some(start) = start { query_params.append_pair("start", &*start.to_string()); };
        if let Some(r#type) = r#type { query_params.append_pair("type", r#type); };
        let query_string = query_params.finish();
        let path_string = format!("/lol/match/v5/matches/by-puuid/{}/ids", puuid);
        self.base.get::<Vec<String>>("match-v5.getMatchIdsByPUUID", region.into(), path_string, Some(query_string))
    }

    /// Get a match by match id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `matchId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getMatch" target="_blank">`match-v5.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, region: Region, match_id: &str)
        -> impl Future<Output = Result<Option<match_v5::Match>>> + 'a
    {
        let path_string = format!("/lol/match/v5/matches/{}", match_id);
        self.base.get_optional::<match_v5::Match>("match-v5.getMatch", region.into(), path_string, None)
    }

    /// Get a match timeline by match id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `matchId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#match-v5/GET_getTimeline" target="_blank">`match-v5.getTimeline`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_timeline(&self, region: Region, match_id: &str)
        -> impl Future<Output = Result<Option<match_v5::MatchTimeline>>> + 'a
    {
        let path_string = format!("/lol/match/v5/matches/{}/timeline", match_id);
        self.base.get_optional::<match_v5::MatchTimeline>("match-v5.getTimeline", region.into(), path_string, None)
    }

}

/// SpectatorV4 endpoints handle, accessed by calling [`spectator_v4()`](crate::RiotApi::spectator_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#spectator-v4" target="_blank">`spectator-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct SpectatorV4<'a> {
    base: &'a RiotApi,
}
impl<'a> SpectatorV4<'a> {
    /// Get current game information for the given summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId` - The ID of the summoner.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#spectator-v4/GET_getCurrentGameInfoBySummoner" target="_blank">`spectator-v4.getCurrentGameInfoBySummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_current_game_info_by_summoner(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<Option<spectator_v4::CurrentGameInfo>>> + 'a
    {
        let path_string = format!("/lol/spectator/v4/active-games/by-summoner/{}", encrypted_summoner_id);
        self.base.get_optional::<spectator_v4::CurrentGameInfo>("spectator-v4.getCurrentGameInfoBySummoner", region.into(), path_string, None)
    }

    /// Get list of featured games.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#spectator-v4/GET_getFeaturedGames" target="_blank">`spectator-v4.getFeaturedGames`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_featured_games(&self, region: Region)
        -> impl Future<Output = Result<spectator_v4::FeaturedGames>> + 'a
    {
        let path_string = "/lol/spectator/v4/featured-games".to_owned();
        self.base.get::<spectator_v4::FeaturedGames>("spectator-v4.getFeaturedGames", region.into(), path_string, None)
    }

}

/// SummonerV4 endpoints handle, accessed by calling [`summoner_v4()`](crate::RiotApi::summoner_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#summoner-v4" target="_blank">`summoner-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct SummonerV4<'a> {
    base: &'a RiotApi,
}
impl<'a> SummonerV4<'a> {
    /// Get a summoner by account ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedAccountId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getByAccountId" target="_blank">`summoner-v4.getByAccountId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_account_id(&self, region: Region, encrypted_account_id: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let path_string = format!("/lol/summoner/v4/summoners/by-account/{}", encrypted_account_id);
        self.base.get::<summoner_v4::Summoner>("summoner-v4.getByAccountId", region.into(), path_string, None)
    }

    /// Get a summoner by summoner name.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `summonerName` - Summoner Name
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getBySummonerName" target="_blank">`summoner-v4.getBySummonerName`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_name(&self, region: Region, summoner_name: &str)
        -> impl Future<Output = Result<Option<summoner_v4::Summoner>>> + 'a
    {
        let path_string = format!("/lol/summoner/v4/summoners/by-name/{}", summoner_name);
        self.base.get_optional::<summoner_v4::Summoner>("summoner-v4.getBySummonerName", region.into(), path_string, None)
    }

    /// Get a summoner by PUUID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedPUUID` - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getByPUUID" target="_blank">`summoner-v4.getByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, region: Region, encrypted_puuid: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let path_string = format!("/lol/summoner/v4/summoners/by-puuid/{}", encrypted_puuid);
        self.base.get::<summoner_v4::Summoner>("summoner-v4.getByPUUID", region.into(), path_string, None)
    }

    /// Get a summoner by summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId` - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#summoner-v4/GET_getBySummonerId" target="_blank">`summoner-v4.getBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_id(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<summoner_v4::Summoner>> + 'a
    {
        let path_string = format!("/lol/summoner/v4/summoners/{}", encrypted_summoner_id);
        self.base.get::<summoner_v4::Summoner>("summoner-v4.getBySummonerId", region.into(), path_string, None)
    }

}

/// TftLeagueV1 endpoints handle, accessed by calling [`tft_league_v1()`](crate::RiotApi::tft_league_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-league-v1" target="_blank">`tft-league-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct TftLeagueV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftLeagueV1<'a> {
    /// Get the challenger league.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getChallengerLeague" target="_blank">`tft-league-v1.getChallengerLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_challenger_league(&self, region: Region)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let path_string = "/tft/league/v1/challenger".to_owned();
        self.base.get::<tft_league_v1::LeagueList>("tft-league-v1.getChallengerLeague", region.into(), path_string, None)
    }

    /// Get league entries for a given summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `summonerId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueEntriesForSummoner" target="_blank">`tft-league-v1.getLeagueEntriesForSummoner`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries_for_summoner(&self, region: Region, summoner_id: &str)
        -> impl Future<Output = Result<Vec<tft_league_v1::LeagueEntry>>> + 'a
    {
        let path_string = format!("/tft/league/v1/entries/by-summoner/{}", summoner_id);
        self.base.get::<Vec<tft_league_v1::LeagueEntry>>("tft-league-v1.getLeagueEntriesForSummoner", region.into(), path_string, None)
    }

    /// Get all the league entries.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tier`
    /// * `division`
    /// * `page` (optional) - Defaults to 1. Starts with page 1.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueEntries" target="_blank">`tft-league-v1.getLeagueEntries`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_entries(&self, region: Region, tier: crate::consts::Tier, division: &str, page: Option<i32>)
        -> impl Future<Output = Result<Vec<tft_league_v1::LeagueEntry>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(page) = page { query_params.append_pair("page", &*page.to_string()); };
        let query_string = query_params.finish();
        let path_string = format!("/tft/league/v1/entries/{}/{}", tier, division);
        self.base.get::<Vec<tft_league_v1::LeagueEntry>>("tft-league-v1.getLeagueEntries", region.into(), path_string, Some(query_string))
    }

    /// Get the grandmaster league.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getGrandmasterLeague" target="_blank">`tft-league-v1.getGrandmasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_grandmaster_league(&self, region: Region)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let path_string = "/tft/league/v1/grandmaster".to_owned();
        self.base.get::<tft_league_v1::LeagueList>("tft-league-v1.getGrandmasterLeague", region.into(), path_string, None)
    }

    /// Get league with given ID, including inactive entries.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `leagueId` - The UUID of the league.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getLeagueById" target="_blank">`tft-league-v1.getLeagueById`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_league_by_id(&self, region: Region, league_id: &str)
        -> impl Future<Output = Result<Option<tft_league_v1::LeagueList>>> + 'a
    {
        let path_string = format!("/tft/league/v1/leagues/{}", league_id);
        self.base.get_optional::<tft_league_v1::LeagueList>("tft-league-v1.getLeagueById", region.into(), path_string, None)
    }

    /// Get the master league.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getMasterLeague" target="_blank">`tft-league-v1.getMasterLeague`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_master_league(&self, region: Region)
        -> impl Future<Output = Result<tft_league_v1::LeagueList>> + 'a
    {
        let path_string = "/tft/league/v1/master".to_owned();
        self.base.get::<tft_league_v1::LeagueList>("tft-league-v1.getMasterLeague", region.into(), path_string, None)
    }

    /// Get the top rated ladder for given queue
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-league-v1/GET_getTopRatedLadder" target="_blank">`tft-league-v1.getTopRatedLadder`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_top_rated_ladder(&self, region: Region, queue: crate::consts::QueueType)
        -> impl Future<Output = Result<Vec<tft_league_v1::TopRatedLadderEntry>>> + 'a
    {
        let path_string = format!("/tft/league/v1/rated-ladders/{}/top", queue);
        self.base.get::<Vec<tft_league_v1::TopRatedLadderEntry>>("tft-league-v1.getTopRatedLadder", region.into(), path_string, None)
    }

}

/// TftMatchV1 endpoints handle, accessed by calling [`tft_match_v1()`](crate::RiotApi::tft_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-match-v1" target="_blank">`tft-match-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct TftMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftMatchV1<'a> {
    /// Get a list of match ids by PUUID
    /// # Parameters
    /// * `region` - Region to query.
    /// * `puuid`
    /// * `count` (optional) - Defaults to 20.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-match-v1/GET_getMatchIdsByPUUID" target="_blank">`tft-match-v1.getMatchIdsByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match_ids_by_puuid(&self, region: Region, puuid: &str, count: Option<i32>)
        -> impl Future<Output = Result<Vec<String>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(count) = count { query_params.append_pair("count", &*count.to_string()); };
        let query_string = query_params.finish();
        let path_string = format!("/tft/match/v1/matches/by-puuid/{}/ids", puuid);
        self.base.get::<Vec<String>>("tft-match-v1.getMatchIdsByPUUID", region.into(), path_string, Some(query_string))
    }

    /// Get a match by match id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `matchId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-match-v1/GET_getMatch" target="_blank">`tft-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, region: Region, match_id: &str)
        -> impl Future<Output = Result<Option<tft_match_v1::Match>>> + 'a
    {
        let path_string = format!("/tft/match/v1/matches/{}", match_id);
        self.base.get_optional::<tft_match_v1::Match>("tft-match-v1.getMatch", region.into(), path_string, None)
    }

}

/// TftSummonerV1 endpoints handle, accessed by calling [`tft_summoner_v1()`](crate::RiotApi::tft_summoner_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tft-summoner-v1" target="_blank">`tft-summoner-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct TftSummonerV1<'a> {
    base: &'a RiotApi,
}
impl<'a> TftSummonerV1<'a> {
    /// Get a summoner by account ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedAccountId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getByAccountId" target="_blank">`tft-summoner-v1.getByAccountId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_account_id(&self, region: Region, encrypted_account_id: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let path_string = format!("/tft/summoner/v1/summoners/by-account/{}", encrypted_account_id);
        self.base.get::<tft_summoner_v1::Summoner>("tft-summoner-v1.getByAccountId", region.into(), path_string, None)
    }

    /// Get a summoner by summoner name.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `summonerName` - Summoner Name
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getBySummonerName" target="_blank">`tft-summoner-v1.getBySummonerName`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_name(&self, region: Region, summoner_name: &str)
        -> impl Future<Output = Result<Option<tft_summoner_v1::Summoner>>> + 'a
    {
        let path_string = format!("/tft/summoner/v1/summoners/by-name/{}", summoner_name);
        self.base.get_optional::<tft_summoner_v1::Summoner>("tft-summoner-v1.getBySummonerName", region.into(), path_string, None)
    }

    /// Get a summoner by PUUID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedPUUID` - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getByPUUID" target="_blank">`tft-summoner-v1.getByPUUID`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_puuid(&self, region: Region, encrypted_puuid: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let path_string = format!("/tft/summoner/v1/summoners/by-puuid/{}", encrypted_puuid);
        self.base.get::<tft_summoner_v1::Summoner>("tft-summoner-v1.getByPUUID", region.into(), path_string, None)
    }

    /// Get a summoner by summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId` - Summoner ID
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tft-summoner-v1/GET_getBySummonerId" target="_blank">`tft-summoner-v1.getBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_by_summoner_id(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<tft_summoner_v1::Summoner>> + 'a
    {
        let path_string = format!("/tft/summoner/v1/summoners/{}", encrypted_summoner_id);
        self.base.get::<tft_summoner_v1::Summoner>("tft-summoner-v1.getBySummonerId", region.into(), path_string, None)
    }

}

/// ThirdPartyCodeV4 endpoints handle, accessed by calling [`third_party_code_v4()`](crate::RiotApi::third_party_code_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#third-party-code-v4" target="_blank">`third-party-code-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct ThirdPartyCodeV4<'a> {
    base: &'a RiotApi,
}
impl<'a> ThirdPartyCodeV4<'a> {
    /// Get third party code for a given summoner ID.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `encryptedSummonerId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#third-party-code-v4/GET_getThirdPartyCodeBySummonerId" target="_blank">`third-party-code-v4.getThirdPartyCodeBySummonerId`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_third_party_code_by_summoner_id(&self, region: Region, encrypted_summoner_id: &str)
        -> impl Future<Output = Result<String>> + 'a
    {
        let path_string = format!("/lol/platform/v4/third-party-code/by-summoner/{}", encrypted_summoner_id);
        self.base.get::<String>("third-party-code-v4.getThirdPartyCodeBySummonerId", region.into(), path_string, None)
    }

}

/// TournamentStubV4 endpoints handle, accessed by calling [`tournament_stub_v4()`](crate::RiotApi::tournament_stub_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tournament-stub-v4" target="_blank">`tournament-stub-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct TournamentStubV4<'a> {
    base: &'a RiotApi,
}
impl<'a> TournamentStubV4<'a> {
    /// Gets a mock list of lobby events by tournament code.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tournamentCode` - The short code to look up lobby events for
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-stub-v4/GET_getLobbyEventsByCode" target="_blank">`tournament-stub-v4.getLobbyEventsByCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_lobby_events_by_code(&self, region: Region, tournament_code: &str)
        -> impl Future<Output = Result<tournament_stub_v4::LobbyEventWrapper>> + 'a
    {
        let path_string = format!("/lol/tournament-stub/v4/lobby-events/by-code/{}", tournament_code);
        self.base.get::<tournament_stub_v4::LobbyEventWrapper>("tournament-stub-v4.getLobbyEventsByCode", region.into(), path_string, None)
    }

}

/// TournamentV4 endpoints handle, accessed by calling [`tournament_v4()`](crate::RiotApi::tournament_v4) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#tournament-v4" target="_blank">`tournament-v4`</a>
///
/// Note: this struct is automatically generated.
pub struct TournamentV4<'a> {
    base: &'a RiotApi,
}
impl<'a> TournamentV4<'a> {
    /// Returns the tournament code DTO associated with a tournament code string.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tournamentCode` - The tournament code string.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/GET_getTournamentCode" target="_blank">`tournament-v4.getTournamentCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_tournament_code(&self, region: Region, tournament_code: &str)
        -> impl Future<Output = Result<tournament_v4::TournamentCode>> + 'a
    {
        let path_string = format!("/lol/tournament/v4/codes/{}", tournament_code);
        self.base.get::<tournament_v4::TournamentCode>("tournament-v4.getTournamentCode", region.into(), path_string, None)
    }

    /// Gets a list of lobby events by tournament code.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `tournamentCode` - The short code to look up lobby events for
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#tournament-v4/GET_getLobbyEventsByCode" target="_blank">`tournament-v4.getLobbyEventsByCode`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_lobby_events_by_code(&self, region: Region, tournament_code: &str)
        -> impl Future<Output = Result<tournament_v4::LobbyEventWrapper>> + 'a
    {
        let path_string = format!("/lol/tournament/v4/lobby-events/by-code/{}", tournament_code);
        self.base.get::<tournament_v4::LobbyEventWrapper>("tournament-v4.getLobbyEventsByCode", region.into(), path_string, None)
    }

}

/// ValContentV1 endpoints handle, accessed by calling [`val_content_v1()`](crate::RiotApi::val_content_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-content-v1" target="_blank">`val-content-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct ValContentV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValContentV1<'a> {
    /// Get content optionally filtered by locale
    /// # Parameters
    /// * `region` - Region to query.
    /// * `locale` (optional)
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-content-v1/GET_getContent" target="_blank">`val-content-v1.getContent`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_content(&self, region: Region, locale: Option<&str>)
        -> impl Future<Output = Result<val_content_v1::Content>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(locale) = locale { query_params.append_pair("locale", locale); };
        let query_string = query_params.finish();
        let path_string = "/val/content/v1/contents".to_owned();
        self.base.get::<val_content_v1::Content>("val-content-v1.getContent", region.into(), path_string, Some(query_string))
    }

}

/// ValMatchV1 endpoints handle, accessed by calling [`val_match_v1()`](crate::RiotApi::val_match_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-match-v1" target="_blank">`val-match-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct ValMatchV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValMatchV1<'a> {
    /// Get match by id
    /// # Parameters
    /// * `region` - Region to query.
    /// * `matchId`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getMatch" target="_blank">`val-match-v1.getMatch`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_match(&self, region: Region, match_id: &str)
        -> impl Future<Output = Result<Option<val_match_v1::Match>>> + 'a
    {
        let path_string = format!("/val/match/v1/matches/{}", match_id);
        self.base.get_optional::<val_match_v1::Match>("val-match-v1.getMatch", region.into(), path_string, None)
    }

    /// Get matchlist for games played by puuid
    /// # Parameters
    /// * `region` - Region to query.
    /// * `puuid`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getMatchlist" target="_blank">`val-match-v1.getMatchlist`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_matchlist(&self, region: Region, puuid: &str)
        -> impl Future<Output = Result<val_match_v1::Matchlist>> + 'a
    {
        let path_string = format!("/val/match/v1/matchlists/by-puuid/{}", puuid);
        self.base.get::<val_match_v1::Matchlist>("val-match-v1.getMatchlist", region.into(), path_string, None)
    }

    /// Get recent matches
    /// ## Implementation Notes
    /// Returns a list of match ids that have completed in the last 10 minutes for live regions and 12 hours for the esports routing value. NA/LATAM/BR share a match history deployment. As such, recent matches will return a combined list of matches from those three regions. Requests are load balanced so you may see some inconsistencies as matches are added/removed from the list.
    /// # Parameters
    /// * `region` - Region to query.
    /// * `queue`
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-match-v1/GET_getRecent" target="_blank">`val-match-v1.getRecent`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_recent(&self, region: Region, queue: &str)
        -> impl Future<Output = Result<val_match_v1::RecentMatches>> + 'a
    {
        let path_string = format!("/val/match/v1/recent-matches/by-queue/{}", queue);
        self.base.get::<val_match_v1::RecentMatches>("val-match-v1.getRecent", region.into(), path_string, None)
    }

}

/// ValRankedV1 endpoints handle, accessed by calling [`val_ranked_v1()`](crate::RiotApi::val_ranked_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-ranked-v1" target="_blank">`val-ranked-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct ValRankedV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValRankedV1<'a> {
    /// Get leaderboard for the competitive queue
    /// # Parameters
    /// * `region` - Region to query.
    /// * `actId` - Act ids can be found using the val-content API.
    /// * `size` (optional) - Defaults to 200. Valid values: 1 to 200.
    /// * `startIndex` (optional) - Defaults to 0.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-ranked-v1/GET_getLeaderboard" target="_blank">`val-ranked-v1.getLeaderboard`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_leaderboard(&self, region: Region, act_id: &str, size: Option<i32>, start_index: Option<i32>)
        -> impl Future<Output = Result<Option<val_ranked_v1::Leaderboard>>> + 'a
    {
        let mut query_params = Serializer::new(String::new());
        if let Some(size) = size { query_params.append_pair("size", &*size.to_string()); };
        if let Some(start_index) = start_index { query_params.append_pair("startIndex", &*start_index.to_string()); };
        let query_string = query_params.finish();
        let path_string = format!("/val/ranked/v1/leaderboards/by-act/{}", act_id);
        self.base.get_optional::<val_ranked_v1::Leaderboard>("val-ranked-v1.getLeaderboard", region.into(), path_string, Some(query_string))
    }

}

/// ValStatusV1 endpoints handle, accessed by calling [`val_status_v1()`](crate::RiotApi::val_status_v1) on a [`RiotApi`](crate::RiotApi) instance.
/// # Riot Developer API Reference
/// <a href="https://developer.riotgames.com/apis#val-status-v1" target="_blank">`val-status-v1`</a>
///
/// Note: this struct is automatically generated.
pub struct ValStatusV1<'a> {
    base: &'a RiotApi,
}
impl<'a> ValStatusV1<'a> {
    /// Get VALORANT status for the given platform.
    /// # Parameters
    /// * `region` - Region to query.
    /// # Riot Developer API Reference
    /// <a href="https://developer.riotgames.com/api-methods/#val-status-v1/GET_getPlatformData" target="_blank">`val-status-v1.getPlatformData`</a>
    ///
    /// Note: this method is automatically generated.
    pub fn get_platform_data(&self, region: Region)
        -> impl Future<Output = Result<val_status_v1::PlatformData>> + 'a
    {
        let path_string = "/val/status/v1/platform-data".to_owned();
        self.base.get::<val_status_v1::PlatformData>("val-status-v1.getPlatformData", region.into(), path_string, None)
    }

}
