///////////////////////////////////////////////
//                                           //
//                     !                     //
//   This file is automatically generated!   //
//           Do not directly edit!           //
//                                           //
///////////////////////////////////////////////

// http://www.mingweisamuel.com/riotapi-schema/tool/
// Version f60af07c98f05dffdaf81262f9b01f97fe94a3a1

//! Data transfer structs.
//!
//! Separated into separate modules for each endpoint.
//! Several modules contain structs with the same name, so be sure to use the right ones.
//!
//! Note: these modules are automatically generated.

/// Data structs used by [`AccountV1`](crate::endpoints::AccountV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod account_v1 {
    /// Account data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Account {
        #[serde(rename = "puuid")]
        pub puuid: String,
        /// This field may be excluded from the response if the account doesn't have a gameName.
        #[serde(rename = "gameName")]
        pub game_name: Option<String>,
        /// This field may be excluded from the response if the account doesn't have a tagLine.
        #[serde(rename = "tagLine")]
        pub tag_line: Option<String>,
    }
    /// ActiveShard data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ActiveShard {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "game")]
        pub game: String,
        #[serde(rename = "activeShard")]
        pub active_shard: String,
    }
}

/// Data structs used by [`ChampionMasteryV4`](crate::endpoints::ChampionMasteryV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod champion_mastery_v4 {
    /// ChampionMastery data object.
    /// # Description
    /// This object contains single Champion Mastery information for player and champion combination.
    ///
    /// Note: This struct is automatically generated
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ChampionMastery {
        /// Number of points needed to achieve next level. Zero if player reached maximum champion level for this champion.
        #[serde(rename = "championPointsUntilNextLevel")]
        pub champion_points_until_next_level: i64,
        /// Is chest granted for this champion or not in current season.
        #[serde(rename = "chestGranted")]
        pub chest_granted: bool,
        /// Champion ID for this entry.
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// Last time this champion was played by this player - in Unix milliseconds time format.
        #[serde(rename = "lastPlayTime")]
        pub last_play_time: i64,
        /// Champion level for specified player and champion combination.
        #[serde(rename = "championLevel")]
        pub champion_level: i32,
        /// Summoner ID for this entry. (Encrypted)
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        /// Total number of champion points for this player and champion combination - they are used to determine championLevel.
        #[serde(rename = "championPoints")]
        pub champion_points: i32,
        /// Number of points earned since current level has been achieved.
        #[serde(rename = "championPointsSinceLastLevel")]
        pub champion_points_since_last_level: i64,
        /// The token earned for this champion at the current championLevel. When the championLevel is advanced the tokensEarned resets to 0.
        #[serde(rename = "tokensEarned")]
        pub tokens_earned: i32,
    }
}

/// Data structs used by [`ChampionV3`](crate::endpoints::ChampionV3).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod champion_v3 {
    /// ChampionInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ChampionInfo {
        #[serde(rename = "maxNewPlayerLevel")]
        pub max_new_player_level: i32,
        #[serde(rename = "freeChampionIdsForNewPlayers")]
        pub free_champion_ids_for_new_players: std::vec::Vec<crate::consts::Champion>,
        #[serde(rename = "freeChampionIds")]
        pub free_champion_ids: std::vec::Vec<crate::consts::Champion>,
    }
}

/// Data structs used by [`ClashV1`](crate::endpoints::ClashV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod clash_v1 {
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "teamId")]
        pub team_id: Option<String>,
        /// (Legal values:  UNSELECTED,  FILL,  TOP,  JUNGLE,  MIDDLE,  BOTTOM,  UTILITY)
        #[serde(rename = "position")]
        pub position: String,
        /// (Legal values:  CAPTAIN,  MEMBER)
        #[serde(rename = "role")]
        pub role: String,
    }
    /// Team data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Team {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "tournamentId")]
        pub tournament_id: i32,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "iconId")]
        pub icon_id: i32,
        #[serde(rename = "tier")]
        pub tier: i32,
        /// Summoner ID of the team captain.
        #[serde(rename = "captain")]
        pub captain: String,
        #[serde(rename = "abbreviation")]
        pub abbreviation: String,
        /// Team members.
        #[serde(rename = "players")]
        pub players: std::vec::Vec<Player>,
    }
    /// Tournament data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Tournament {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "themeId")]
        pub theme_id: i32,
        #[serde(rename = "nameKey")]
        pub name_key: String,
        #[serde(rename = "nameKeySecondary")]
        pub name_key_secondary: String,
        /// Tournament phase.
        #[serde(rename = "schedule")]
        pub schedule: std::vec::Vec<TournamentPhase>,
    }
    /// TournamentPhase data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentPhase {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "registrationTime")]
        pub registration_time: i64,
        #[serde(rename = "startTime")]
        pub start_time: i64,
        #[serde(rename = "cancelled")]
        pub cancelled: bool,
    }
}

/// Data structs used by [`LeagueExpV4`](crate::endpoints::LeagueExpV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod league_exp_v4 {
    /// LeagueEntry data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueEntry {
        #[serde(rename = "leagueId")]
        pub league_id: String,
        /// Player's summonerId (Encrypted)
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "queueType")]
        pub queue_type: crate::consts::QueueType,
        #[serde(rename = "tier")]
        pub tier: crate::consts::Tier,
        /// The player's division within a tier.
        #[serde(rename = "rank")]
        pub rank: crate::consts::Division,
        #[serde(rename = "leaguePoints")]
        pub league_points: i32,
        /// Winning team on Summoners Rift. First placement in Teamfight Tactics.
        #[serde(rename = "wins")]
        pub wins: i32,
        /// Losing team on Summoners Rift. Second through eighth placement in Teamfight Tactics.
        #[serde(rename = "losses")]
        pub losses: i32,
        #[serde(rename = "hotStreak")]
        pub hot_streak: bool,
        #[serde(rename = "veteran")]
        pub veteran: bool,
        #[serde(rename = "freshBlood")]
        pub fresh_blood: bool,
        #[serde(rename = "inactive")]
        pub inactive: bool,
        #[serde(rename = "miniSeries")]
        pub mini_series: Option<MiniSeries>,
    }
    /// MiniSeries data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MiniSeries {
        #[serde(rename = "losses")]
        pub losses: i32,
        #[serde(rename = "progress")]
        pub progress: String,
        #[serde(rename = "target")]
        pub target: i32,
        #[serde(rename = "wins")]
        pub wins: i32,
    }
}

/// Data structs used by [`LeagueV4`](crate::endpoints::LeagueV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod league_v4 {
    /// LeagueList data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueList {
        #[serde(rename = "leagueId")]
        pub league_id: String,
        #[serde(rename = "entries")]
        pub entries: std::vec::Vec<LeagueItem>,
        #[serde(rename = "tier")]
        pub tier: crate::consts::Tier,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "queue")]
        pub queue: crate::consts::QueueType,
    }
    /// LeagueItem data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueItem {
        #[serde(rename = "freshBlood")]
        pub fresh_blood: bool,
        /// Winning team on Summoners Rift.
        #[serde(rename = "wins")]
        pub wins: i32,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "miniSeries")]
        pub mini_series: Option<MiniSeries>,
        #[serde(rename = "inactive")]
        pub inactive: bool,
        #[serde(rename = "veteran")]
        pub veteran: bool,
        #[serde(rename = "hotStreak")]
        pub hot_streak: bool,
        #[serde(rename = "rank")]
        pub rank: crate::consts::Division,
        #[serde(rename = "leaguePoints")]
        pub league_points: i32,
        /// Losing team on Summoners Rift.
        #[serde(rename = "losses")]
        pub losses: i32,
        /// Player's encrypted summonerId.
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
    }
    /// MiniSeries data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MiniSeries {
        #[serde(rename = "losses")]
        pub losses: i32,
        #[serde(rename = "progress")]
        pub progress: String,
        #[serde(rename = "target")]
        pub target: i32,
        #[serde(rename = "wins")]
        pub wins: i32,
    }
    /// LeagueEntry data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueEntry {
        #[serde(rename = "leagueId")]
        pub league_id: String,
        /// Player's encrypted summonerId.
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "queueType")]
        pub queue_type: crate::consts::QueueType,
        #[serde(rename = "tier")]
        pub tier: crate::consts::Tier,
        /// The player's division within a tier.
        #[serde(rename = "rank")]
        pub rank: crate::consts::Division,
        #[serde(rename = "leaguePoints")]
        pub league_points: i32,
        /// Winning team on Summoners Rift.
        #[serde(rename = "wins")]
        pub wins: i32,
        /// Losing team on Summoners Rift.
        #[serde(rename = "losses")]
        pub losses: i32,
        #[serde(rename = "hotStreak")]
        pub hot_streak: bool,
        #[serde(rename = "veteran")]
        pub veteran: bool,
        #[serde(rename = "freshBlood")]
        pub fresh_blood: bool,
        #[serde(rename = "inactive")]
        pub inactive: bool,
        #[serde(rename = "miniSeries")]
        pub mini_series: Option<MiniSeries>,
    }
}

/// Data structs used by [`LolStatusV3`](crate::endpoints::LolStatusV3).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lol_status_v3 {
    /// ShardStatus data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ShardStatus {
        #[serde(rename = "locales")]
        pub locales: std::vec::Vec<String>,
        #[serde(rename = "hostname")]
        pub hostname: String,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "services")]
        pub services: std::vec::Vec<Service>,
        #[serde(rename = "slug")]
        pub slug: String,
        #[serde(rename = "region_tag")]
        pub region_tag: String,
    }
    /// Service data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Service {
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "slug")]
        pub slug: String,
        #[serde(rename = "status")]
        pub status: String,
        #[serde(rename = "incidents")]
        pub incidents: std::vec::Vec<Incident>,
    }
    /// Incident data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Incident {
        #[serde(rename = "id")]
        pub id: i64,
        #[serde(rename = "active")]
        pub active: bool,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "updates")]
        pub updates: std::vec::Vec<Message>,
    }
    /// Message data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Message {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "author")]
        pub author: String,
        #[serde(rename = "heading")]
        pub heading: String,
        #[serde(rename = "content")]
        pub content: String,
        #[serde(rename = "severity")]
        pub severity: String,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
        #[serde(rename = "translations")]
        pub translations: std::vec::Vec<Translation>,
    }
    /// Translation data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Translation {
        #[serde(rename = "updated_at")]
        pub updated_at: String,
        #[serde(rename = "locale")]
        pub locale: String,
        #[serde(rename = "content")]
        pub content: String,
    }
}

/// Data structs used by [`LolStatusV4`](crate::endpoints::LolStatusV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lol_status_v4 {
    /// PlatformData data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlatformData {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "locales")]
        pub locales: std::vec::Vec<String>,
        #[serde(rename = "maintenances")]
        pub maintenances: std::vec::Vec<Status>,
        #[serde(rename = "incidents")]
        pub incidents: std::vec::Vec<Status>,
    }
    /// Status data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Status {
        #[serde(rename = "id")]
        pub id: i32,
        /// (Legal values:  scheduled,  in_progress,  complete)
        #[serde(rename = "maintenance_status")]
        pub maintenance_status: String,
        /// (Legal values:  info,  warning,  critical)
        #[serde(rename = "incident_severity")]
        pub incident_severity: String,
        #[serde(rename = "titles")]
        pub titles: std::vec::Vec<Content>,
        #[serde(rename = "updates")]
        pub updates: std::vec::Vec<Update>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "archive_at")]
        pub archive_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
        /// (Legal values: windows, macos, android, ios, ps4, xbone, switch)
        #[serde(rename = "platforms")]
        pub platforms: std::vec::Vec<String>,
    }
    /// Content data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Content {
        #[serde(rename = "locale")]
        pub locale: String,
        #[serde(rename = "content")]
        pub content: String,
    }
    /// Update data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Update {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "author")]
        pub author: String,
        #[serde(rename = "publish")]
        pub publish: bool,
        /// (Legal values: riotclient, riotstatus, game)
        #[serde(rename = "publish_locations")]
        pub publish_locations: std::vec::Vec<String>,
        #[serde(rename = "translations")]
        pub translations: std::vec::Vec<Content>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
    }
}

/// Data structs used by [`LorDeckV1`](crate::endpoints::LorDeckV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lor_deck_v1 {
    /// Deck data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Deck {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "code")]
        pub code: String,
    }
    /// NewDeck data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct NewDeck {
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "code")]
        pub code: String,
    }
}

/// Data structs used by [`LorInventoryV1`](crate::endpoints::LorInventoryV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lor_inventory_v1 {
    /// Card data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Card {
        #[serde(rename = "code")]
        pub code: String,
        #[serde(rename = "count")]
        pub count: String,
    }
}

/// Data structs used by [`LorMatchV1`](crate::endpoints::LorMatchV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lor_match_v1 {
    /// Match data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Match {
        /// Match metadata.
        #[serde(rename = "metadata")]
        pub metadata: Metadata,
        /// Match info.
        #[serde(rename = "info")]
        pub info: Info,
    }
    /// Metadata data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Metadata {
        /// Match data version.
        #[serde(rename = "data_version")]
        pub data_version: String,
        /// Match id.
        #[serde(rename = "match_id")]
        pub match_id: String,
        /// A list of participant PUUIDs.
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<String>,
    }
    /// Info data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Info {
        /// (Legal values:  Constructed,  Expeditions,  Tutorial)
        #[serde(rename = "game_mode")]
        pub game_mode: String,
        /// (Legal values:  Ranked,  Normal,  AI,  Tutorial,  VanillaTrial,  Singleton,  StandardGauntlet)
        #[serde(rename = "game_type")]
        pub game_type: String,
        #[serde(rename = "game_start_time_utc")]
        pub game_start_time_utc: String,
        #[serde(rename = "game_version")]
        pub game_version: String,
        #[serde(rename = "players")]
        pub players: std::vec::Vec<Player>,
        /// Total turns taken by both players.
        #[serde(rename = "total_turn_count")]
        pub total_turn_count: i32,
    }
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "deck_id")]
        pub deck_id: String,
        /// Code for the deck played. Refer to LOR documentation for details on deck codes.
        #[serde(rename = "deck_code")]
        pub deck_code: String,
        #[serde(rename = "factions")]
        pub factions: std::vec::Vec<String>,
        #[serde(rename = "game_outcome")]
        pub game_outcome: String,
        /// The order in which the players took turns.
        #[serde(rename = "order_of_play")]
        pub order_of_play: i32,
    }
}

/// Data structs used by [`LorRankedV1`](crate::endpoints::LorRankedV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lor_ranked_v1 {
    /// Leaderboard data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Leaderboard {
        /// A list of players in Master tier.
        #[serde(rename = "players")]
        pub players: std::vec::Vec<Player>,
    }
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "rank")]
        pub rank: i32,
        /// League points.
        #[serde(rename = "lp")]
        pub lp: i32,
    }
}

/// Data structs used by [`LorStatusV1`](crate::endpoints::LorStatusV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod lor_status_v1 {
    /// PlatformData data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlatformData {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "locales")]
        pub locales: std::vec::Vec<String>,
        #[serde(rename = "maintenances")]
        pub maintenances: std::vec::Vec<Status>,
        #[serde(rename = "incidents")]
        pub incidents: std::vec::Vec<Status>,
    }
    /// Status data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Status {
        #[serde(rename = "id")]
        pub id: i32,
        /// (Legal values:  scheduled,  in_progress,  complete)
        #[serde(rename = "maintenance_status")]
        pub maintenance_status: String,
        /// (Legal values:  info,  warning,  critical)
        #[serde(rename = "incident_severity")]
        pub incident_severity: String,
        #[serde(rename = "titles")]
        pub titles: std::vec::Vec<Content>,
        #[serde(rename = "updates")]
        pub updates: std::vec::Vec<Update>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "archive_at")]
        pub archive_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
        /// (Legal values: windows, macos, android, ios, ps4, xbone, switch)
        #[serde(rename = "platforms")]
        pub platforms: std::vec::Vec<String>,
    }
    /// Content data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Content {
        #[serde(rename = "locale")]
        pub locale: String,
        #[serde(rename = "content")]
        pub content: String,
    }
    /// Update data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Update {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "author")]
        pub author: String,
        #[serde(rename = "publish")]
        pub publish: bool,
        /// (Legal values: riotclient, riotstatus, game)
        #[serde(rename = "publish_locations")]
        pub publish_locations: std::vec::Vec<String>,
        #[serde(rename = "translations")]
        pub translations: std::vec::Vec<Content>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
    }
}

/// Data structs used by [`MatchV4`](crate::endpoints::MatchV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod match_v4 {
    /// Match data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Match {
        #[serde(rename = "gameId")]
        pub game_id: i64,
        /// Participant identity information. Participant identity information is purposefully excluded for custom games.
        #[serde(rename = "participantIdentities")]
        pub participant_identities: std::vec::Vec<ParticipantIdentity>,
        /// Please refer to the Game Constants documentation.
        #[serde(rename = "queueId")]
        pub queue_id: crate::consts::Queue,
        /// Please refer to the Game Constants documentation.
        #[serde(rename = "gameType")]
        pub game_type: crate::consts::GameType,
        /// Match duration in seconds.
        #[serde(rename = "gameDuration")]
        pub game_duration: i64,
        /// Team information.
        #[serde(rename = "teams")]
        pub teams: std::vec::Vec<TeamStats>,
        /// Platform where the match was played.
        #[serde(rename = "platformId")]
        pub platform_id: String,
        /// Designates the timestamp when champion select ended and the loading screen appeared, NOT when the game timer was at 0:00.
        #[serde(rename = "gameCreation")]
        pub game_creation: i64,
        /// Please refer to the Game Constants documentation.
        #[serde(rename = "seasonId")]
        pub season_id: crate::consts::Season,
        /// The major.minor version typically indicates the patch the match was played on.
        #[serde(rename = "gameVersion")]
        pub game_version: String,
        /// Please refer to the Game Constants documentation.
        #[serde(rename = "mapId")]
        pub map_id: crate::consts::Map,
        /// Please refer to the Game Constants documentation.
        #[serde(rename = "gameMode")]
        pub game_mode: crate::consts::GameMode,
        /// Participant information.
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<Participant>,
    }
    /// ParticipantIdentity data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ParticipantIdentity {
        #[serde(rename = "participantId")]
        pub participant_id: i32,
        /// Player information not included in the response for custom matches. Custom matches are considered private unless a tournament code was used to create the match.
        #[serde(rename = "player")]
        pub player: Player,
    }
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        #[serde(rename = "profileIcon")]
        pub profile_icon: i32,
        /// Player's original accountId.
        #[serde(rename = "accountId")]
        pub account_id: String,
        #[serde(rename = "matchHistoryUri")]
        pub match_history_uri: String,
        /// Player's current accountId when the match was played.
        #[serde(rename = "currentAccountId")]
        pub current_account_id: String,
        /// Player's current platformId when the match was played.
        #[serde(rename = "currentPlatformId")]
        pub current_platform_id: String,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        /// Player's summonerId (Encrypted)
        #[serde(rename = "summonerId")]
        pub summoner_id: Option<String>,
        /// Player's original platformId.
        #[serde(rename = "platformId")]
        pub platform_id: String,
    }
    /// TeamStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TeamStats {
        /// Number of towers the team destroyed.
        #[serde(rename = "towerKills")]
        pub tower_kills: i32,
        /// Number of times the team killed Rift Herald.
        #[serde(rename = "riftHeraldKills")]
        pub rift_herald_kills: i32,
        /// Flag indicating whether or not the team scored the first blood.
        #[serde(rename = "firstBlood")]
        pub first_blood: bool,
        /// Number of inhibitors the team destroyed.
        #[serde(rename = "inhibitorKills")]
        pub inhibitor_kills: i32,
        /// If match queueId has a draft, contains banned champion data, otherwise empty.
        #[serde(rename = "bans")]
        pub bans: std::vec::Vec<TeamBans>,
        /// Flag indicating whether or not the team scored the first Baron kill.
        #[serde(rename = "firstBaron")]
        pub first_baron: bool,
        /// Flag indicating whether or not the team scored the first Dragon kill.
        #[serde(rename = "firstDragon")]
        pub first_dragon: bool,
        /// For Dominion matches, specifies the points the team had at game end.
        #[serde(rename = "dominionVictoryScore")]
        pub dominion_victory_score: i32,
        /// Number of times the team killed Dragon.
        #[serde(rename = "dragonKills")]
        pub dragon_kills: i32,
        /// Number of times the team killed Baron.
        #[serde(rename = "baronKills")]
        pub baron_kills: i32,
        /// Flag indicating whether or not the team destroyed the first inhibitor.
        #[serde(rename = "firstInhibitor")]
        pub first_inhibitor: bool,
        /// Flag indicating whether or not the team destroyed the first tower.
        #[serde(rename = "firstTower")]
        pub first_tower: bool,
        /// Number of times the team killed Vilemaw.
        #[serde(rename = "vilemawKills")]
        pub vilemaw_kills: i32,
        /// Flag indicating whether or not the team scored the first Rift Herald kill.
        #[serde(rename = "firstRiftHerald")]
        pub first_rift_herald: bool,
        /// 100 for blue side. 200 for red side.
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        /// String indicating whether or not the team won. There are only two values visibile in public match history.<br>
        /// (Legal values:  Fail,  Win)
        #[serde(rename = "win")]
        pub win: Option<String>,
    }
    /// TeamBans data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TeamBans {
        /// Banned championId.
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// Turn during which the champion was banned.
        #[serde(rename = "pickTurn")]
        pub pick_turn: i32,
    }
    /// Participant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Participant {
        #[serde(rename = "participantId")]
        pub participant_id: i32,
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// List of legacy Rune information. Not included for matches played with Runes Reforged.
        #[serde(rename = "runes")]
        pub runes: Option<std::vec::Vec<Rune>>,
        /// Participant statistics.
        #[serde(rename = "stats")]
        pub stats: ParticipantStats,
        /// 100 for blue side. 200 for red side.
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        /// Participant timeline data.
        #[serde(rename = "timeline")]
        pub timeline: Option<ParticipantTimeline>,
        /// First Summoner Spell id.
        #[serde(rename = "spell1Id")]
        pub spell1_id: i32,
        /// Second Summoner Spell id.
        #[serde(rename = "spell2Id")]
        pub spell2_id: i32,
        /// Highest ranked tier achieved for the previous season in a specific subset of queueIds, if any, otherwise null. Used to display border in game loading screen. Please refer to the Ranked Info documentation.<br>
        /// (Legal values:  CHALLENGER,  MASTER,  DIAMOND,  PLATINUM,  GOLD,  SILVER,  BRONZE,  UNRANKED)
        #[serde(rename = "highestAchievedSeasonTier")]
        pub highest_achieved_season_tier: Option<crate::consts::Tier>,
        /// List of legacy Mastery information. Not included for matches played with Runes Reforged.
        #[serde(rename = "masteries")]
        pub masteries: Option<std::vec::Vec<Mastery>>,
    }
    /// Rune data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Rune {
        #[serde(rename = "runeId")]
        pub rune_id: i32,
        #[serde(rename = "rank")]
        pub rank: i32,
    }
    /// ParticipantStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ParticipantStats {
        #[serde(rename = "item0")]
        pub item0: i32,
        #[serde(rename = "item2")]
        pub item2: i32,
        #[serde(rename = "totalUnitsHealed")]
        pub total_units_healed: i32,
        #[serde(rename = "item1")]
        pub item1: i32,
        #[serde(rename = "largestMultiKill")]
        pub largest_multi_kill: i32,
        #[serde(rename = "goldEarned")]
        pub gold_earned: i32,
        #[serde(rename = "firstInhibitorKill")]
        pub first_inhibitor_kill: Option<bool>,
        #[serde(rename = "physicalDamageTaken")]
        pub physical_damage_taken: i64,
        #[serde(rename = "nodeNeutralizeAssist")]
        pub node_neutralize_assist: Option<i32>,
        #[serde(rename = "totalPlayerScore")]
        pub total_player_score: Option<i32>,
        #[serde(rename = "champLevel")]
        pub champ_level: i32,
        #[serde(rename = "damageDealtToObjectives")]
        pub damage_dealt_to_objectives: i64,
        #[serde(rename = "totalDamageTaken")]
        pub total_damage_taken: i64,
        #[serde(rename = "neutralMinionsKilled")]
        pub neutral_minions_killed: i32,
        #[serde(rename = "deaths")]
        pub deaths: i32,
        #[serde(rename = "tripleKills")]
        pub triple_kills: i32,
        #[serde(rename = "magicDamageDealtToChampions")]
        pub magic_damage_dealt_to_champions: i64,
        #[serde(rename = "wardsKilled")]
        pub wards_killed: Option<i32>,
        #[serde(rename = "pentaKills")]
        pub penta_kills: i32,
        #[serde(rename = "damageSelfMitigated")]
        pub damage_self_mitigated: i64,
        #[serde(rename = "largestCriticalStrike")]
        pub largest_critical_strike: i32,
        #[serde(rename = "nodeNeutralize")]
        pub node_neutralize: Option<i32>,
        #[serde(rename = "totalTimeCrowdControlDealt")]
        pub total_time_crowd_control_dealt: i32,
        #[serde(rename = "firstTowerKill")]
        pub first_tower_kill: Option<bool>,
        #[serde(rename = "magicDamageDealt")]
        pub magic_damage_dealt: i64,
        #[serde(rename = "totalScoreRank")]
        pub total_score_rank: Option<i32>,
        #[serde(rename = "nodeCapture")]
        pub node_capture: Option<i32>,
        #[serde(rename = "wardsPlaced")]
        pub wards_placed: Option<i32>,
        #[serde(rename = "totalDamageDealt")]
        pub total_damage_dealt: i64,
        #[serde(rename = "timeCCingOthers")]
        pub time_c_cing_others: i64,
        #[serde(rename = "magicalDamageTaken")]
        pub magical_damage_taken: i64,
        #[serde(rename = "largestKillingSpree")]
        pub largest_killing_spree: i32,
        #[serde(rename = "totalDamageDealtToChampions")]
        pub total_damage_dealt_to_champions: i64,
        #[serde(rename = "physicalDamageDealtToChampions")]
        pub physical_damage_dealt_to_champions: i64,
        #[serde(rename = "neutralMinionsKilledTeamJungle")]
        pub neutral_minions_killed_team_jungle: Option<i32>,
        #[serde(rename = "totalMinionsKilled")]
        pub total_minions_killed: i32,
        #[serde(rename = "firstInhibitorAssist")]
        pub first_inhibitor_assist: Option<bool>,
        #[serde(rename = "visionWardsBoughtInGame")]
        pub vision_wards_bought_in_game: i32,
        #[serde(rename = "objectivePlayerScore")]
        pub objective_player_score: Option<i32>,
        #[serde(rename = "kills")]
        pub kills: i32,
        #[serde(rename = "firstTowerAssist")]
        pub first_tower_assist: Option<bool>,
        #[serde(rename = "combatPlayerScore")]
        pub combat_player_score: Option<i32>,
        #[serde(rename = "inhibitorKills")]
        pub inhibitor_kills: Option<i32>,
        #[serde(rename = "turretKills")]
        pub turret_kills: Option<i32>,
        #[serde(rename = "participantId")]
        pub participant_id: i32,
        #[serde(rename = "trueDamageTaken")]
        pub true_damage_taken: i64,
        #[serde(rename = "firstBloodAssist")]
        pub first_blood_assist: Option<bool>,
        #[serde(rename = "nodeCaptureAssist")]
        pub node_capture_assist: Option<i32>,
        #[serde(rename = "assists")]
        pub assists: i32,
        #[serde(rename = "teamObjective")]
        pub team_objective: Option<i32>,
        #[serde(rename = "altarsNeutralized")]
        pub altars_neutralized: Option<i32>,
        #[serde(rename = "goldSpent")]
        pub gold_spent: i32,
        #[serde(rename = "damageDealtToTurrets")]
        pub damage_dealt_to_turrets: i64,
        #[serde(rename = "altarsCaptured")]
        pub altars_captured: Option<i32>,
        #[serde(rename = "win")]
        pub win: bool,
        #[serde(rename = "totalHeal")]
        pub total_heal: i64,
        #[serde(rename = "unrealKills")]
        pub unreal_kills: i32,
        #[serde(rename = "visionScore")]
        pub vision_score: Option<i64>,
        #[serde(rename = "physicalDamageDealt")]
        pub physical_damage_dealt: i64,
        #[serde(rename = "firstBloodKill")]
        pub first_blood_kill: Option<bool>,
        #[serde(rename = "longestTimeSpentLiving")]
        pub longest_time_spent_living: i32,
        #[serde(rename = "killingSprees")]
        pub killing_sprees: i32,
        #[serde(rename = "sightWardsBoughtInGame")]
        pub sight_wards_bought_in_game: Option<i32>,
        #[serde(rename = "trueDamageDealtToChampions")]
        pub true_damage_dealt_to_champions: i64,
        #[serde(rename = "neutralMinionsKilledEnemyJungle")]
        pub neutral_minions_killed_enemy_jungle: Option<i32>,
        #[serde(rename = "doubleKills")]
        pub double_kills: i32,
        #[serde(rename = "trueDamageDealt")]
        pub true_damage_dealt: i64,
        #[serde(rename = "quadraKills")]
        pub quadra_kills: i32,
        #[serde(rename = "item4")]
        pub item4: i32,
        #[serde(rename = "item3")]
        pub item3: i32,
        #[serde(rename = "item6")]
        pub item6: i32,
        #[serde(rename = "item5")]
        pub item5: i32,
        #[serde(rename = "playerScore0")]
        pub player_score0: Option<i32>,
        #[serde(rename = "playerScore1")]
        pub player_score1: Option<i32>,
        #[serde(rename = "playerScore2")]
        pub player_score2: Option<i32>,
        #[serde(rename = "playerScore3")]
        pub player_score3: Option<i32>,
        #[serde(rename = "playerScore4")]
        pub player_score4: Option<i32>,
        #[serde(rename = "playerScore5")]
        pub player_score5: Option<i32>,
        #[serde(rename = "playerScore6")]
        pub player_score6: Option<i32>,
        #[serde(rename = "playerScore7")]
        pub player_score7: Option<i32>,
        #[serde(rename = "playerScore8")]
        pub player_score8: Option<i32>,
        #[serde(rename = "playerScore9")]
        pub player_score9: Option<i32>,
        /// Primary path keystone rune.
        #[serde(rename = "perk0")]
        pub perk0: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk0Var1")]
        pub perk0_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk0Var2")]
        pub perk0_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk0Var3")]
        pub perk0_var3: Option<i32>,
        /// Primary path rune.
        #[serde(rename = "perk1")]
        pub perk1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk1Var1")]
        pub perk1_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk1Var2")]
        pub perk1_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk1Var3")]
        pub perk1_var3: Option<i32>,
        /// Primary path rune.
        #[serde(rename = "perk2")]
        pub perk2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk2Var1")]
        pub perk2_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk2Var2")]
        pub perk2_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk2Var3")]
        pub perk2_var3: Option<i32>,
        /// Primary path rune.
        #[serde(rename = "perk3")]
        pub perk3: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk3Var1")]
        pub perk3_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk3Var2")]
        pub perk3_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk3Var3")]
        pub perk3_var3: Option<i32>,
        /// Secondary path rune.
        #[serde(rename = "perk4")]
        pub perk4: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk4Var1")]
        pub perk4_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk4Var2")]
        pub perk4_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk4Var3")]
        pub perk4_var3: Option<i32>,
        /// Secondary path rune.
        #[serde(rename = "perk5")]
        pub perk5: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk5Var1")]
        pub perk5_var1: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk5Var2")]
        pub perk5_var2: Option<i32>,
        /// Post game rune stats.
        #[serde(rename = "perk5Var3")]
        pub perk5_var3: Option<i32>,
        /// Primary rune path
        #[serde(rename = "perkPrimaryStyle")]
        pub perk_primary_style: Option<i32>,
        /// Secondary rune path
        #[serde(rename = "perkSubStyle")]
        pub perk_sub_style: Option<i32>,
        /// Stat rune
        #[serde(rename = "statPerk0")]
        pub stat_perk0: Option<i32>,
        /// Stat rune
        #[serde(rename = "statPerk1")]
        pub stat_perk1: Option<i32>,
        /// Stat rune
        #[serde(rename = "statPerk2")]
        pub stat_perk2: Option<i32>,
    }
    /// ParticipantTimeline data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ParticipantTimeline {
        #[serde(rename = "participantId")]
        pub participant_id: Option<i32>,
        /// Creep score difference versus the calculated lane opponent(s) for a specified period.
        #[serde(rename = "csDiffPerMinDeltas")]
        pub cs_diff_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Damage taken for a specified period.
        #[serde(rename = "damageTakenPerMinDeltas")]
        pub damage_taken_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Participant's calculated role.<br>
        /// (Legal values:  DUO,  NONE,  SOLO,  DUO_CARRY,  DUO_SUPPORT)
        #[serde(rename = "role")]
        pub role: Option<String>,
        /// Damage taken difference versus the calculated lane opponent(s) for a specified period.
        #[serde(rename = "damageTakenDiffPerMinDeltas")]
        pub damage_taken_diff_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Experience change for a specified period.
        #[serde(rename = "xpPerMinDeltas")]
        pub xp_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Experience difference versus the calculated lane opponent(s) for a specified period.
        #[serde(rename = "xpDiffPerMinDeltas")]
        pub xp_diff_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Participant's calculated lane. MID and BOT are legacy values.<br>
        /// (Legal values:  MID,  MIDDLE,  TOP,  JUNGLE,  BOT,  BOTTOM)
        #[serde(rename = "lane")]
        pub lane: Option<String>,
        /// Creeps for a specified period.
        #[serde(rename = "creepsPerMinDeltas")]
        pub creeps_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
        /// Gold for a specified period.
        #[serde(rename = "goldPerMinDeltas")]
        pub gold_per_min_deltas: Option<std::collections::HashMap<String, f64>>,
    }
    /// Mastery data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Mastery {
        #[serde(rename = "rank")]
        pub rank: i32,
        #[serde(rename = "masteryId")]
        pub mastery_id: i32,
    }
    /// Matchlist data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Matchlist {
        #[serde(rename = "startIndex")]
        pub start_index: i32,
        /// There is a known issue that this field doesn't correctly return the total number of games that match the parameters of the request. Please paginate using beginIndex until you reach the end of a player's matchlist.
        #[serde(rename = "totalGames")]
        pub total_games: i32,
        #[serde(rename = "endIndex")]
        pub end_index: i32,
        #[serde(rename = "matches")]
        pub matches: std::vec::Vec<MatchReference>,
    }
    /// MatchReference data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchReference {
        #[serde(rename = "gameId")]
        pub game_id: i64,
        #[serde(rename = "role")]
        pub role: Option<String>,
        #[serde(rename = "season")]
        pub season: i32,
        #[serde(rename = "platformId")]
        pub platform_id: String,
        #[serde(rename = "champion")]
        pub champion: crate::consts::Champion,
        #[serde(rename = "queue")]
        pub queue: crate::consts::Queue,
        #[serde(rename = "lane")]
        pub lane: Option<String>,
        #[serde(rename = "timestamp")]
        pub timestamp: i64,
    }
    /// MatchTimeline data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimeline {
        #[serde(rename = "frames")]
        pub frames: std::vec::Vec<MatchFrame>,
        #[serde(rename = "frameInterval")]
        pub frame_interval: i64,
    }
    /// MatchFrame data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchFrame {
        #[serde(rename = "participantFrames")]
        pub participant_frames: std::collections::HashMap<String, MatchParticipantFrame>,
        #[serde(rename = "events")]
        pub events: std::vec::Vec<MatchEvent>,
        #[serde(rename = "timestamp")]
        pub timestamp: i64,
    }
    /// MatchParticipantFrame data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchParticipantFrame {
        #[serde(rename = "participantId")]
        pub participant_id: i32,
        #[serde(rename = "minionsKilled")]
        pub minions_killed: i32,
        #[serde(rename = "teamScore")]
        pub team_score: Option<i32>,
        #[serde(rename = "dominionScore")]
        pub dominion_score: Option<i32>,
        #[serde(rename = "totalGold")]
        pub total_gold: i32,
        #[serde(rename = "level")]
        pub level: i32,
        #[serde(rename = "xp")]
        pub xp: i32,
        #[serde(rename = "currentGold")]
        pub current_gold: i32,
        #[serde(rename = "position")]
        pub position: Option<MatchPosition>,
        #[serde(rename = "jungleMinionsKilled")]
        pub jungle_minions_killed: i32,
    }
    /// MatchPosition data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchPosition {
        #[serde(rename = "x")]
        pub x: i32,
        #[serde(rename = "y")]
        pub y: i32,
    }
    /// MatchEvent data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchEvent {
        #[serde(rename = "laneType")]
        pub lane_type: Option<String>,
        #[serde(rename = "skillSlot")]
        pub skill_slot: Option<i32>,
        #[serde(rename = "ascendedType")]
        pub ascended_type: Option<String>,
        #[serde(rename = "creatorId")]
        pub creator_id: Option<i32>,
        #[serde(rename = "afterId")]
        pub after_id: Option<i32>,
        #[serde(rename = "eventType")]
        pub event_type: Option<String>,
        /// (Legal values:  CHAMPION_KILL,  WARD_PLACED,  WARD_KILL,  BUILDING_KILL,  ELITE_MONSTER_KILL,  ITEM_PURCHASED,  ITEM_SOLD,  ITEM_DESTROYED,  ITEM_UNDO,  SKILL_LEVEL_UP,  ASCENDED_EVENT,  CAPTURE_POINT,  PORO_KING_SUMMON)
        #[serde(rename = "type")]
        pub r#type: String,
        #[serde(rename = "levelUpType")]
        pub level_up_type: Option<String>,
        #[serde(rename = "wardType")]
        pub ward_type: Option<String>,
        #[serde(rename = "participantId")]
        pub participant_id: Option<i32>,
        #[serde(rename = "towerType")]
        pub tower_type: Option<String>,
        #[serde(rename = "itemId")]
        pub item_id: Option<i32>,
        #[serde(rename = "beforeId")]
        pub before_id: Option<i32>,
        #[serde(rename = "pointCaptured")]
        pub point_captured: Option<String>,
        #[serde(rename = "monsterType")]
        pub monster_type: Option<String>,
        #[serde(rename = "monsterSubType")]
        pub monster_sub_type: Option<String>,
        #[serde(rename = "teamId")]
        pub team_id: Option<crate::consts::Team>,
        #[serde(rename = "position")]
        pub position: Option<MatchPosition>,
        #[serde(rename = "killerId")]
        pub killer_id: Option<i32>,
        #[serde(rename = "timestamp")]
        pub timestamp: i64,
        #[serde(rename = "assistingParticipantIds")]
        pub assisting_participant_ids: Option<std::vec::Vec<i32>>,
        #[serde(rename = "buildingType")]
        pub building_type: Option<String>,
        #[serde(rename = "victimId")]
        pub victim_id: Option<i32>,
    }
}

/// Data structs used by [`MatchV5`](crate::endpoints::MatchV5).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod match_v5 {
    /// Match data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Match {
        #[serde(rename = "metadata")]
        pub metadata: MatchMetadata,
        #[serde(rename = "info")]
        pub info: MatchInfo,
    }
    /// MatchTimeline data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimeline {
        #[serde(rename = "metadata")]
        pub metadata: MatchMetadata,
        #[serde(rename = "info")]
        pub info: MatchTimelineInfo,
    }
    /// MatchMetadata data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchMetadata {
        #[serde(rename = "dataVersion")]
        pub data_version: String,
        #[serde(rename = "matchId")]
        pub match_id: String,
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<String>,
    }
    /// MatchInfoParticipantPerksStatPerks data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoParticipantPerksStatPerks {
        #[serde(rename = "defense")]
        pub defense: i64,
        #[serde(rename = "flex")]
        pub flex: i64,
        #[serde(rename = "offense")]
        pub offense: i64,
    }
    /// MatchInfoParticipantPerksStyleSelection data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoParticipantPerksStyleSelection {
        #[serde(rename = "perk")]
        pub perk: i64,
        #[serde(rename = "var1")]
        pub var1: i64,
        #[serde(rename = "var2")]
        pub var2: i64,
        #[serde(rename = "var3")]
        pub var3: i64,
    }
    /// MatchInfoParticipantPerksStyle data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoParticipantPerksStyle {
        #[serde(rename = "description")]
        pub description: String,
        #[serde(rename = "selections")]
        pub selections: std::vec::Vec<MatchInfoParticipantPerksStyleSelection>,
        #[serde(rename = "style")]
        pub style: i64,
    }
    /// MatchInfoParticipantPerks data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoParticipantPerks {
        #[serde(rename = "statPerks")]
        pub stat_perks: MatchInfoParticipantPerksStatPerks,
        #[serde(rename = "styles")]
        pub styles: std::vec::Vec<MatchInfoParticipantPerksStyle>,
    }
    /// MatchInfoParticipant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoParticipant {
        #[serde(rename = "assists")]
        pub assists: i64,
        #[serde(rename = "baronKills")]
        pub baron_kills: i64,
        #[serde(rename = "bountyLevel")]
        pub bounty_level: i64,
        #[serde(rename = "champExperience")]
        pub champ_experience: i64,
        #[serde(rename = "champLevel")]
        pub champ_level: i64,
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        #[serde(rename = "championName")]
        pub champion_name: String,
        #[serde(rename = "championTransform")]
        pub champion_transform: i64,
        #[serde(rename = "consumablesPurchased")]
        pub consumables_purchased: i64,
        #[serde(rename = "damageDealtToBuildings")]
        pub damage_dealt_to_buildings: i64,
        #[serde(rename = "damageDealtToObjectives")]
        pub damage_dealt_to_objectives: i64,
        #[serde(rename = "damageDealtToTurrets")]
        pub damage_dealt_to_turrets: i64,
        #[serde(rename = "damageSelfMitigated")]
        pub damage_self_mitigated: i64,
        #[serde(rename = "deaths")]
        pub deaths: i64,
        #[serde(rename = "detectorWardsPlaced")]
        pub detector_wards_placed: i64,
        #[serde(rename = "doubleKills")]
        pub double_kills: i64,
        #[serde(rename = "dragonKills")]
        pub dragon_kills: i64,
        #[serde(rename = "firstBloodAssist")]
        pub first_blood_assist: bool,
        #[serde(rename = "firstBloodKill")]
        pub first_blood_kill: bool,
        #[serde(rename = "firstTowerAssist")]
        pub first_tower_assist: bool,
        #[serde(rename = "firstTowerKill")]
        pub first_tower_kill: bool,
        #[serde(rename = "gameEndedInEarlySurrender")]
        pub game_ended_in_early_surrender: bool,
        #[serde(rename = "gameEndedInSurrender")]
        pub game_ended_in_surrender: bool,
        #[serde(rename = "goldEarned")]
        pub gold_earned: i64,
        #[serde(rename = "goldSpent")]
        pub gold_spent: i64,
        #[serde(rename = "individualPosition")]
        pub individual_position: String,
        #[serde(rename = "inhibitorKills")]
        pub inhibitor_kills: i64,
        #[serde(rename = "inhibitorsLost")]
        pub inhibitors_lost: i64,
        #[serde(rename = "item0")]
        pub item0: i64,
        #[serde(rename = "item1")]
        pub item1: i64,
        #[serde(rename = "item2")]
        pub item2: i64,
        #[serde(rename = "item3")]
        pub item3: i64,
        #[serde(rename = "item4")]
        pub item4: i64,
        #[serde(rename = "item5")]
        pub item5: i64,
        #[serde(rename = "item6")]
        pub item6: i64,
        #[serde(rename = "itemsPurchased")]
        pub items_purchased: i64,
        #[serde(rename = "killingSprees")]
        pub killing_sprees: i64,
        #[serde(rename = "kills")]
        pub kills: i64,
        #[serde(rename = "lane")]
        pub lane: String,
        #[serde(rename = "largestCriticalStrike")]
        pub largest_critical_strike: i64,
        #[serde(rename = "largestKillingSpree")]
        pub largest_killing_spree: i64,
        #[serde(rename = "largestMultiKill")]
        pub largest_multi_kill: i64,
        #[serde(rename = "longestTimeSpentLiving")]
        pub longest_time_spent_living: i64,
        #[serde(rename = "magicDamageDealt")]
        pub magic_damage_dealt: i64,
        #[serde(rename = "magicDamageDealtToChampions")]
        pub magic_damage_dealt_to_champions: i64,
        #[serde(rename = "magicDamageTaken")]
        pub magic_damage_taken: i64,
        #[serde(rename = "neutralMinionsKilled")]
        pub neutral_minions_killed: i64,
        #[serde(rename = "nexusKills")]
        pub nexus_kills: i64,
        #[serde(rename = "nexusLost")]
        pub nexus_lost: i64,
        #[serde(rename = "objectivesStolen")]
        pub objectives_stolen: i64,
        #[serde(rename = "objectivesStolenAssists")]
        pub objectives_stolen_assists: i64,
        #[serde(rename = "participantId")]
        pub participant_id: i64,
        #[serde(rename = "pentaKills")]
        pub penta_kills: i64,
        #[serde(rename = "perks")]
        pub perks: MatchInfoParticipantPerks,
        #[serde(rename = "physicalDamageDealt")]
        pub physical_damage_dealt: i64,
        #[serde(rename = "physicalDamageDealtToChampions")]
        pub physical_damage_dealt_to_champions: i64,
        #[serde(rename = "physicalDamageTaken")]
        pub physical_damage_taken: i64,
        #[serde(rename = "profileIcon")]
        pub profile_icon: i64,
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "quadraKills")]
        pub quadra_kills: i64,
        #[serde(rename = "riotIdName")]
        pub riot_id_name: String,
        #[serde(rename = "riotIdTagline")]
        pub riot_id_tagline: String,
        #[serde(rename = "role")]
        pub role: String,
        #[serde(rename = "sightWardsBoughtInGame")]
        pub sight_wards_bought_in_game: i64,
        #[serde(rename = "spell1Casts")]
        pub spell1_casts: i64,
        #[serde(rename = "spell2Casts")]
        pub spell2_casts: i64,
        #[serde(rename = "spell3Casts")]
        pub spell3_casts: i64,
        #[serde(rename = "spell4Casts")]
        pub spell4_casts: i64,
        #[serde(rename = "summoner1Casts")]
        pub summoner1_casts: i64,
        #[serde(rename = "summoner1Id")]
        pub summoner1_id: i64,
        #[serde(rename = "summoner2Casts")]
        pub summoner2_casts: i64,
        #[serde(rename = "summoner2Id")]
        pub summoner2_id: i64,
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "summonerLevel")]
        pub summoner_level: i64,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "teamEarlySurrendered")]
        pub team_early_surrendered: bool,
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        #[serde(rename = "teamPosition")]
        pub team_position: String,
        #[serde(rename = "timeCCingOthers")]
        pub time_c_cing_others: i64,
        #[serde(rename = "timePlayed")]
        pub time_played: i64,
        #[serde(rename = "totalDamageDealt")]
        pub total_damage_dealt: i64,
        #[serde(rename = "totalDamageDealtToChampions")]
        pub total_damage_dealt_to_champions: i64,
        #[serde(rename = "totalDamageShieldedOnTeammates")]
        pub total_damage_shielded_on_teammates: i64,
        #[serde(rename = "totalDamageTaken")]
        pub total_damage_taken: i64,
        #[serde(rename = "totalHeal")]
        pub total_heal: i64,
        #[serde(rename = "totalHealsOnTeammates")]
        pub total_heals_on_teammates: i64,
        #[serde(rename = "totalMinionsKilled")]
        pub total_minions_killed: i64,
        #[serde(rename = "totalTimeCCDealt")]
        pub total_time_cc_dealt: i64,
        #[serde(rename = "totalTimeSpentDead")]
        pub total_time_spent_dead: i64,
        #[serde(rename = "totalUnitsHealed")]
        pub total_units_healed: i64,
        #[serde(rename = "tripleKills")]
        pub triple_kills: i64,
        #[serde(rename = "trueDamageDealt")]
        pub true_damage_dealt: i64,
        #[serde(rename = "trueDamageDealtToChampions")]
        pub true_damage_dealt_to_champions: i64,
        #[serde(rename = "trueDamageTaken")]
        pub true_damage_taken: i64,
        #[serde(rename = "turretKills")]
        pub turret_kills: i64,
        #[serde(rename = "turretsLost")]
        pub turrets_lost: i64,
        #[serde(rename = "unrealKills")]
        pub unreal_kills: i64,
        #[serde(rename = "visionScore")]
        pub vision_score: i64,
        #[serde(rename = "visionWardsBoughtInGame")]
        pub vision_wards_bought_in_game: i64,
        #[serde(rename = "wardsKilled")]
        pub wards_killed: i64,
        #[serde(rename = "wardsPlaced")]
        pub wards_placed: i64,
        #[serde(rename = "win")]
        pub win: bool,
    }
    /// MatchInfoTeamBan data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoTeamBan {
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        #[serde(rename = "pickTurn")]
        pub pick_turn: i64,
    }
    /// MatchInfoTeamObjective data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoTeamObjective {
        #[serde(rename = "first")]
        pub first: bool,
        #[serde(rename = "kills")]
        pub kills: i64,
    }
    /// MatchInfoTeamObjectives data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoTeamObjectives {
        #[serde(rename = "baron")]
        pub baron: MatchInfoTeamObjective,
        #[serde(rename = "champion")]
        pub champion: MatchInfoTeamObjective,
        #[serde(rename = "dragon")]
        pub dragon: MatchInfoTeamObjective,
        #[serde(rename = "inhibitor")]
        pub inhibitor: MatchInfoTeamObjective,
        #[serde(rename = "riftHerald")]
        pub rift_herald: MatchInfoTeamObjective,
        #[serde(rename = "tower")]
        pub tower: MatchInfoTeamObjective,
    }
    /// MatchInfoTeam data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfoTeam {
        #[serde(rename = "bans")]
        pub bans: std::vec::Vec<MatchInfoTeamBan>,
        #[serde(rename = "objectives")]
        pub objectives: MatchInfoTeamObjectives,
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        #[serde(rename = "win")]
        pub win: bool,
    }
    /// MatchInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfo {
        #[serde(rename = "gameCreation")]
        pub game_creation: i64,
        #[serde(rename = "gameDuration")]
        pub game_duration: i64,
        #[serde(rename = "gameId")]
        pub game_id: i64,
        #[serde(rename = "gameMode")]
        pub game_mode: crate::consts::GameMode,
        #[serde(rename = "gameName")]
        pub game_name: String,
        #[serde(rename = "gameStartTimestamp")]
        pub game_start_timestamp: i64,
        #[serde(rename = "gameType")]
        pub game_type: crate::consts::GameType,
        #[serde(rename = "gameVersion")]
        pub game_version: String,
        #[serde(rename = "mapId")]
        pub map_id: crate::consts::Map,
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<MatchInfoParticipant>,
        #[serde(rename = "platformId")]
        pub platform_id: String,
        #[serde(rename = "queueId")]
        pub queue_id: crate::consts::Queue,
        #[serde(rename = "teams")]
        pub teams: std::vec::Vec<MatchInfoTeam>,
    }
    /// MatchTimelineInfoFrameEvent data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameEvent {
        #[serde(rename = "realTimestamp")]
        pub real_timestamp: Option<i64>,
        #[serde(rename = "timestamp")]
        pub timestamp: i64,
        #[serde(rename = "type")]
        pub r#type: String,
        #[serde(rename = "itemId")]
        pub item_id: Option<i64>,
        #[serde(rename = "participantId")]
        pub participant_id: Option<i64>,
        #[serde(rename = "levelUpType")]
        pub level_up_type: Option<String>,
        #[serde(rename = "skillSlot")]
        pub skill_slot: Option<i64>,
        #[serde(rename = "creatorId")]
        pub creator_id: Option<i64>,
        #[serde(rename = "wardType")]
        pub ward_type: Option<String>,
        #[serde(rename = "level")]
        pub level: Option<i64>,
        #[serde(rename = "assistingParticipantIds")]
        pub assisting_participant_ids: Option<std::vec::Vec<i64>>,
        #[serde(rename = "bounty")]
        pub bounty: Option<i64>,
        #[serde(rename = "killStreakLength")]
        pub kill_streak_length: Option<i64>,
        #[serde(rename = "killerId")]
        pub killer_id: Option<i64>,
        #[serde(rename = "position")]
        pub position: Option<MatchTimelineInfoFrameParticipantFramePosition>,
        #[serde(rename = "victimDamageDealt")]
        pub victim_damage_dealt: Option<std::vec::Vec<MatchTimelineInfoFrameEventVictimDamageDealt>>,
        #[serde(rename = "victimDamageReceived")]
        pub victim_damage_received: Option<std::vec::Vec<MatchTimelineInfoFrameEventVictimDamageDealt>>,
        #[serde(rename = "victimId")]
        pub victim_id: Option<i64>,
        #[serde(rename = "killType")]
        pub kill_type: Option<String>,
        #[serde(rename = "laneType")]
        pub lane_type: Option<String>,
        #[serde(rename = "teamId")]
        pub team_id: Option<crate::consts::Team>,
        #[serde(rename = "multiKillLength")]
        pub multi_kill_length: Option<i64>,
        #[serde(rename = "killerTeamId")]
        pub killer_team_id: Option<crate::consts::Team>,
        #[serde(rename = "monsterType")]
        pub monster_type: Option<String>,
        #[serde(rename = "monsterSubType")]
        pub monster_sub_type: Option<String>,
        #[serde(rename = "buildingType")]
        pub building_type: Option<String>,
        #[serde(rename = "towerType")]
        pub tower_type: Option<String>,
        #[serde(rename = "afterId")]
        pub after_id: Option<i64>,
        #[serde(rename = "beforeId")]
        pub before_id: Option<i64>,
        #[serde(rename = "goldGain")]
        pub gold_gain: Option<i64>,
        #[serde(rename = "gameId")]
        pub game_id: Option<i64>,
        #[serde(rename = "winningTeam")]
        pub winning_team: Option<i64>,
        #[serde(rename = "transformType")]
        pub transform_type: Option<String>,
        #[serde(rename = "name")]
        pub name: Option<String>,
    }
    /// MatchTimelineInfoFrameParticipantFrameChampionStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameParticipantFrameChampionStats {
        #[serde(rename = "abilityHaste")]
        pub ability_haste: i64,
        #[serde(rename = "abilityPower")]
        pub ability_power: i64,
        #[serde(rename = "armor")]
        pub armor: i64,
        #[serde(rename = "armorPen")]
        pub armor_pen: i64,
        #[serde(rename = "armorPenPercent")]
        pub armor_pen_percent: i64,
        #[serde(rename = "attackDamage")]
        pub attack_damage: i64,
        #[serde(rename = "attackSpeed")]
        pub attack_speed: i64,
        #[serde(rename = "bonusArmorPenPercent")]
        pub bonus_armor_pen_percent: i64,
        #[serde(rename = "bonusMagicPenPercent")]
        pub bonus_magic_pen_percent: i64,
        #[serde(rename = "ccReduction")]
        pub cc_reduction: i64,
        #[serde(rename = "cooldownReduction")]
        pub cooldown_reduction: i64,
        #[serde(rename = "health")]
        pub health: i64,
        #[serde(rename = "healthMax")]
        pub health_max: i64,
        #[serde(rename = "healthRegen")]
        pub health_regen: i64,
        #[serde(rename = "lifesteal")]
        pub lifesteal: i64,
        #[serde(rename = "magicPen")]
        pub magic_pen: i64,
        #[serde(rename = "magicPenPercent")]
        pub magic_pen_percent: i64,
        #[serde(rename = "magicResist")]
        pub magic_resist: i64,
        #[serde(rename = "movementSpeed")]
        pub movement_speed: i64,
        #[serde(rename = "omnivamp")]
        pub omnivamp: i64,
        #[serde(rename = "physicalVamp")]
        pub physical_vamp: i64,
        #[serde(rename = "power")]
        pub power: i64,
        #[serde(rename = "powerMax")]
        pub power_max: i64,
        #[serde(rename = "powerRegen")]
        pub power_regen: i64,
        #[serde(rename = "spellVamp")]
        pub spell_vamp: i64,
    }
    /// MatchTimelineInfoFrameParticipantFrameDamageStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameParticipantFrameDamageStats {
        #[serde(rename = "magicDamageDone")]
        pub magic_damage_done: i64,
        #[serde(rename = "magicDamageDoneToChampions")]
        pub magic_damage_done_to_champions: i64,
        #[serde(rename = "magicDamageTaken")]
        pub magic_damage_taken: i64,
        #[serde(rename = "physicalDamageDone")]
        pub physical_damage_done: i64,
        #[serde(rename = "physicalDamageDoneToChampions")]
        pub physical_damage_done_to_champions: i64,
        #[serde(rename = "physicalDamageTaken")]
        pub physical_damage_taken: i64,
        #[serde(rename = "totalDamageDone")]
        pub total_damage_done: i64,
        #[serde(rename = "totalDamageDoneToChampions")]
        pub total_damage_done_to_champions: i64,
        #[serde(rename = "totalDamageTaken")]
        pub total_damage_taken: i64,
        #[serde(rename = "trueDamageDone")]
        pub true_damage_done: i64,
        #[serde(rename = "trueDamageDoneToChampions")]
        pub true_damage_done_to_champions: i64,
        #[serde(rename = "trueDamageTaken")]
        pub true_damage_taken: i64,
    }
    /// MatchTimelineInfoFrameParticipantFramePosition data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameParticipantFramePosition {
        #[serde(rename = "x")]
        pub x: i64,
        #[serde(rename = "y")]
        pub y: i64,
    }
    /// MatchTimelineInfoFrameParticipantFrame data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameParticipantFrame {
        #[serde(rename = "championStats")]
        pub champion_stats: MatchTimelineInfoFrameParticipantFrameChampionStats,
        #[serde(rename = "currentGold")]
        pub current_gold: i64,
        #[serde(rename = "damageStats")]
        pub damage_stats: MatchTimelineInfoFrameParticipantFrameDamageStats,
        #[serde(rename = "goldPerSecond")]
        pub gold_per_second: i64,
        #[serde(rename = "jungleMinionsKilled")]
        pub jungle_minions_killed: i64,
        #[serde(rename = "level")]
        pub level: i64,
        #[serde(rename = "minionsKilled")]
        pub minions_killed: i64,
        #[serde(rename = "participantId")]
        pub participant_id: i64,
        #[serde(rename = "position")]
        pub position: MatchTimelineInfoFrameParticipantFramePosition,
        #[serde(rename = "timeEnemySpentControlled")]
        pub time_enemy_spent_controlled: i64,
        #[serde(rename = "totalGold")]
        pub total_gold: i64,
        #[serde(rename = "xp")]
        pub xp: i64,
    }
    /// MatchTimelineInfoFrameParticipantFrames data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameParticipantFrames {
        #[serde(rename = "1")]
        pub x1: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "2")]
        pub x2: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "3")]
        pub x3: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "4")]
        pub x4: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "5")]
        pub x5: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "6")]
        pub x6: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "7")]
        pub x7: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "8")]
        pub x8: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "9")]
        pub x9: MatchTimelineInfoFrameParticipantFrame,
        #[serde(rename = "10")]
        pub x10: MatchTimelineInfoFrameParticipantFrame,
    }
    /// MatchTimelineInfoFrame data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrame {
        #[serde(rename = "events")]
        pub events: std::vec::Vec<MatchTimelineInfoFrameEvent>,
        #[serde(rename = "participantFrames")]
        pub participant_frames: MatchTimelineInfoFrameParticipantFrames,
        #[serde(rename = "timestamp")]
        pub timestamp: i64,
    }
    /// MatchTimelineInfoFrameEventVictimDamageDealt data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoFrameEventVictimDamageDealt {
        #[serde(rename = "basic")]
        pub basic: bool,
        #[serde(rename = "magicDamage")]
        pub magic_damage: i64,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "participantId")]
        pub participant_id: i64,
        #[serde(rename = "physicalDamage")]
        pub physical_damage: i64,
        #[serde(rename = "spellName")]
        pub spell_name: String,
        #[serde(rename = "spellSlot")]
        pub spell_slot: i64,
        #[serde(rename = "trueDamage")]
        pub true_damage: i64,
        #[serde(rename = "type")]
        pub r#type: String,
    }
    /// MatchTimelineInfoParticipant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfoParticipant {
        #[serde(rename = "participantId")]
        pub participant_id: i64,
        #[serde(rename = "puuid")]
        pub puuid: String,
    }
    /// MatchTimelineInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchTimelineInfo {
        #[serde(rename = "frameInterval")]
        pub frame_interval: i64,
        #[serde(rename = "frames")]
        pub frames: std::vec::Vec<MatchTimelineInfoFrame>,
        #[serde(rename = "gameId")]
        pub game_id: i64,
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<MatchTimelineInfoParticipant>,
    }
}

/// Data structs used by [`SpectatorV4`](crate::endpoints::SpectatorV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod spectator_v4 {
    /// CurrentGameInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct CurrentGameInfo {
        /// The ID of the game
        #[serde(rename = "gameId")]
        pub game_id: i64,
        /// The game type
        #[serde(rename = "gameType")]
        pub game_type: crate::consts::GameType,
        /// The game start time represented in epoch milliseconds
        #[serde(rename = "gameStartTime")]
        pub game_start_time: i64,
        /// The ID of the map
        #[serde(rename = "mapId")]
        pub map_id: crate::consts::Map,
        /// The amount of time in seconds that has passed since the game started
        #[serde(rename = "gameLength")]
        pub game_length: i64,
        /// The ID of the platform on which the game is being played
        #[serde(rename = "platformId")]
        pub platform_id: String,
        /// The game mode
        #[serde(rename = "gameMode")]
        pub game_mode: crate::consts::GameMode,
        /// Banned champion information
        #[serde(rename = "bannedChampions")]
        pub banned_champions: std::vec::Vec<BannedChampion>,
        /// The queue type (queue types are documented on the Game Constants page)
        #[serde(rename = "gameQueueConfigId")]
        pub game_queue_config_id: Option<crate::consts::Queue>,
        /// The observer information
        #[serde(rename = "observers")]
        pub observers: Observer,
        /// The participant information
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<CurrentGameParticipant>,
    }
    /// BannedChampion data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct BannedChampion {
        /// The turn during which the champion was banned
        #[serde(rename = "pickTurn")]
        pub pick_turn: i32,
        /// The ID of the banned champion
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// The ID of the team that banned the champion
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
    }
    /// Observer data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Observer {
        /// Key used to decrypt the spectator grid game data for playback
        #[serde(rename = "encryptionKey")]
        pub encryption_key: String,
    }
    /// CurrentGameParticipant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct CurrentGameParticipant {
        /// The ID of the champion played by this participant
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// Perks/Runes Reforged Information
        #[serde(rename = "perks")]
        pub perks: Option<Perks>,
        /// The ID of the profile icon used by this participant
        #[serde(rename = "profileIconId")]
        pub profile_icon_id: i64,
        /// Flag indicating whether or not this participant is a bot
        #[serde(rename = "bot")]
        pub bot: bool,
        /// The team ID of this participant, indicating the participant's team
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        /// The summoner name of this participant
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        /// The encrypted summoner ID of this participant
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        /// The ID of the first summoner spell used by this participant
        #[serde(rename = "spell1Id")]
        pub spell1_id: i64,
        /// The ID of the second summoner spell used by this participant
        #[serde(rename = "spell2Id")]
        pub spell2_id: i64,
        /// List of Game Customizations
        #[serde(rename = "gameCustomizationObjects")]
        pub game_customization_objects: std::vec::Vec<GameCustomizationObject>,
    }
    /// Perks data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Perks {
        /// IDs of the perks/runes assigned.
        #[serde(rename = "perkIds")]
        pub perk_ids: std::vec::Vec<i64>,
        /// Primary runes path
        #[serde(rename = "perkStyle")]
        pub perk_style: i64,
        /// Secondary runes path
        #[serde(rename = "perkSubStyle")]
        pub perk_sub_style: i64,
    }
    /// GameCustomizationObject data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct GameCustomizationObject {
        /// Category identifier for Game Customization
        #[serde(rename = "category")]
        pub category: String,
        /// Game Customization content
        #[serde(rename = "content")]
        pub content: String,
    }
    /// FeaturedGames data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct FeaturedGames {
        /// The list of featured games
        #[serde(rename = "gameList")]
        pub game_list: std::vec::Vec<FeaturedGameInfo>,
        /// The suggested interval to wait before requesting FeaturedGames again
        #[serde(rename = "clientRefreshInterval")]
        pub client_refresh_interval: i64,
    }
    /// FeaturedGameInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct FeaturedGameInfo {
        /// The game mode<br>
        /// (Legal values:  CLASSIC,  ODIN,  ARAM,  TUTORIAL,  ONEFORALL,  ASCENSION,  FIRSTBLOOD,  KINGPORO)
        #[serde(rename = "gameMode")]
        pub game_mode: crate::consts::GameMode,
        /// The amount of time in seconds that has passed since the game started
        #[serde(rename = "gameLength")]
        pub game_length: i64,
        /// The ID of the map
        #[serde(rename = "mapId")]
        pub map_id: crate::consts::Map,
        /// The game type<br>
        /// (Legal values:  CUSTOM_GAME,  MATCHED_GAME,  TUTORIAL_GAME)
        #[serde(rename = "gameType")]
        pub game_type: crate::consts::GameType,
        /// Banned champion information
        #[serde(rename = "bannedChampions")]
        pub banned_champions: std::vec::Vec<BannedChampion>,
        /// The ID of the game
        #[serde(rename = "gameId")]
        pub game_id: i64,
        /// The observer information
        #[serde(rename = "observers")]
        pub observers: Observer,
        /// The queue type (queue types are documented on the Game Constants page)
        #[serde(rename = "gameQueueConfigId")]
        pub game_queue_config_id: crate::consts::Queue,
        /// The game start time represented in epoch milliseconds
        #[serde(rename = "gameStartTime")]
        pub game_start_time: i64,
        /// The participant information
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<Participant>,
        /// The ID of the platform on which the game is being played
        #[serde(rename = "platformId")]
        pub platform_id: String,
    }
    /// Participant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Participant {
        /// Flag indicating whether or not this participant is a bot
        #[serde(rename = "bot")]
        pub bot: bool,
        /// The ID of the second summoner spell used by this participant
        #[serde(rename = "spell2Id")]
        pub spell2_id: i64,
        /// The ID of the profile icon used by this participant
        #[serde(rename = "profileIconId")]
        pub profile_icon_id: i64,
        /// The summoner name of this participant
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        /// The ID of the champion played by this participant
        #[serde(rename = "championId")]
        pub champion_id: crate::consts::Champion,
        /// The team ID of this participant, indicating the participant's team
        #[serde(rename = "teamId")]
        pub team_id: crate::consts::Team,
        /// The ID of the first summoner spell used by this participant
        #[serde(rename = "spell1Id")]
        pub spell1_id: i64,
    }
}

/// Data structs used by [`SummonerV4`](crate::endpoints::SummonerV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod summoner_v4 {
    /// Summoner data object.
    /// # Description
    /// represents a summoner
    ///
    /// Note: This struct is automatically generated
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Summoner {
        /// Encrypted account ID. Max length 56 characters.
        #[serde(rename = "accountId")]
        pub account_id: String,
        /// ID of the summoner icon associated with the summoner.
        #[serde(rename = "profileIconId")]
        pub profile_icon_id: i32,
        /// Date summoner was last modified specified as epoch milliseconds. The following events will update this timestamp: profile icon change, playing the tutorial or advanced tutorial, finishing a game, summoner name change
        #[serde(rename = "revisionDate")]
        pub revision_date: i64,
        /// Summoner name.
        #[serde(rename = "name")]
        pub name: String,
        /// Encrypted summoner ID. Max length 63 characters.
        #[serde(rename = "id")]
        pub id: String,
        /// Encrypted PUUID. Exact length of 78 characters.
        #[serde(rename = "puuid")]
        pub puuid: String,
        /// Summoner level associated with the summoner.
        #[serde(rename = "summonerLevel")]
        pub summoner_level: i64,
    }
}

/// Data structs used by [`TftLeagueV1`](crate::endpoints::TftLeagueV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod tft_league_v1 {
    /// LeagueList data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueList {
        #[serde(rename = "leagueId")]
        pub league_id: String,
        #[serde(rename = "entries")]
        pub entries: std::vec::Vec<LeagueItem>,
        #[serde(rename = "tier")]
        pub tier: crate::consts::Tier,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "queue")]
        pub queue: crate::consts::QueueType,
    }
    /// LeagueItem data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueItem {
        #[serde(rename = "freshBlood")]
        pub fresh_blood: bool,
        /// First placement.
        #[serde(rename = "wins")]
        pub wins: i32,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "miniSeries")]
        pub mini_series: Option<MiniSeries>,
        #[serde(rename = "inactive")]
        pub inactive: bool,
        #[serde(rename = "veteran")]
        pub veteran: bool,
        #[serde(rename = "hotStreak")]
        pub hot_streak: bool,
        #[serde(rename = "rank")]
        pub rank: crate::consts::Division,
        #[serde(rename = "leaguePoints")]
        pub league_points: i32,
        /// Second through eighth placement.
        #[serde(rename = "losses")]
        pub losses: i32,
        /// Player's encrypted summonerId.
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
    }
    /// MiniSeries data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MiniSeries {
        #[serde(rename = "losses")]
        pub losses: i32,
        #[serde(rename = "progress")]
        pub progress: String,
        #[serde(rename = "target")]
        pub target: i32,
        #[serde(rename = "wins")]
        pub wins: i32,
    }
    /// LeagueEntry data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LeagueEntry {
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "leagueId")]
        pub league_id: Option<String>,
        /// Player's encrypted summonerId.
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        #[serde(rename = "queueType")]
        pub queue_type: crate::consts::QueueType,
        /// Only included for the RANKED_TFT_TURBO queueType.<br>
        /// (Legal values:  ORANGE,  PURPLE,  BLUE,  GREEN,  GRAY)
        #[serde(rename = "ratedTier")]
        pub rated_tier: Option<String>,
        /// Only included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "ratedRating")]
        pub rated_rating: Option<i32>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "tier")]
        pub tier: Option<crate::consts::Tier>,
        /// A player's division within a tier. Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "rank")]
        pub rank: Option<crate::consts::Division>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "leaguePoints")]
        pub league_points: Option<i32>,
        /// First placement.
        #[serde(rename = "wins")]
        pub wins: i32,
        /// Second through eighth placement.
        #[serde(rename = "losses")]
        pub losses: i32,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "hotStreak")]
        pub hot_streak: Option<bool>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "veteran")]
        pub veteran: Option<bool>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "freshBlood")]
        pub fresh_blood: Option<bool>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "inactive")]
        pub inactive: Option<bool>,
        /// Not included for the RANKED_TFT_TURBO queueType.
        #[serde(rename = "miniSeries")]
        pub mini_series: Option<MiniSeries>,
    }
    /// TopRatedLadderEntry data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TopRatedLadderEntry {
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        #[serde(rename = "summonerName")]
        pub summoner_name: String,
        /// (Legal values:  ORANGE,  PURPLE,  BLUE,  GREEN,  GRAY)
        #[serde(rename = "ratedTier")]
        pub rated_tier: String,
        #[serde(rename = "ratedRating")]
        pub rated_rating: i32,
        /// First placement.
        #[serde(rename = "wins")]
        pub wins: i32,
        #[serde(rename = "previousUpdateLadderPosition")]
        pub previous_update_ladder_position: i32,
    }
}

/// Data structs used by [`TftMatchV1`](crate::endpoints::TftMatchV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod tft_match_v1 {
    /// Match data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Match {
        /// Match metadata.
        #[serde(rename = "metadata")]
        pub metadata: Metadata,
        /// Match info.
        #[serde(rename = "info")]
        pub info: Info,
    }
    /// Metadata data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Metadata {
        /// Match data version.
        #[serde(rename = "data_version")]
        pub data_version: String,
        /// Match id.
        #[serde(rename = "match_id")]
        pub match_id: String,
        /// A list of participant PUUIDs.
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<String>,
    }
    /// Info data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Info {
        /// Unix timestamp.
        #[serde(rename = "game_datetime")]
        pub game_datetime: i64,
        /// Game length in seconds.
        #[serde(rename = "game_length")]
        pub game_length: f32,
        /// Game variation key. Game variations documented in TFT static data.
        #[serde(rename = "game_variation")]
        pub game_variation: Option<String>,
        /// Game client version.
        #[serde(rename = "game_version")]
        pub game_version: String,
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<Participant>,
        /// Please refer to the League of Legends documentation.
        #[serde(rename = "queue_id")]
        pub queue_id: i32,
        /// Teamfight Tactics set number.
        #[serde(rename = "tft_set_number")]
        pub tft_set_number: i32,
    }
    /// Participant data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Participant {
        /// Participant's companion.
        #[serde(rename = "companion")]
        pub companion: Companion,
        /// Gold left after participant was eliminated.
        #[serde(rename = "gold_left")]
        pub gold_left: i32,
        /// The round the participant was eliminated in. Note: If the player was eliminated in stage 2-1 their last_round would be 5.
        #[serde(rename = "last_round")]
        pub last_round: i32,
        /// Participant Little Legend level. Note: This is not the number of active units.
        #[serde(rename = "level")]
        pub level: i32,
        /// Participant placement upon elimination.
        #[serde(rename = "placement")]
        pub placement: i32,
        /// Number of players the participant eliminated.
        #[serde(rename = "players_eliminated")]
        pub players_eliminated: i32,
        #[serde(rename = "puuid")]
        pub puuid: String,
        /// The number of seconds before the participant was eliminated.
        #[serde(rename = "time_eliminated")]
        pub time_eliminated: f32,
        /// Damage the participant dealt to other players.
        #[serde(rename = "total_damage_to_players")]
        pub total_damage_to_players: i32,
        /// A complete list of traits for the participant's active units.
        #[serde(rename = "traits")]
        pub traits: std::vec::Vec<Trait>,
        /// A list of active units for the participant.
        #[serde(rename = "units")]
        pub units: std::vec::Vec<Unit>,
    }
    /// Trait data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Trait {
        /// Trait name.
        #[serde(rename = "name")]
        pub name: String,
        /// Number of units with this trait.
        #[serde(rename = "num_units")]
        pub num_units: i32,
        /// Current style for this trait. (0 = No style, 1 = Bronze, 2 = Silver, 3 = Gold, 4 = Chromatic)
        #[serde(rename = "style")]
        pub style: Option<i32>,
        /// Current active tier for the trait.
        #[serde(rename = "tier_current")]
        pub tier_current: i32,
        /// Total tiers for the trait.
        #[serde(rename = "tier_total")]
        pub tier_total: Option<i32>,
    }
    /// Unit data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Unit {
        /// A list of the unit's items. Please refer to the Teamfight Tactics documentation for item ids.
        #[serde(rename = "items")]
        pub items: std::vec::Vec<i32>,
        /// This field was introduced in patch 9.22 with data_version 2.
        #[serde(rename = "character_id")]
        pub character_id: String,
        /// If a unit is chosen as part of the Fates set mechanic, the chosen trait will be indicated by this field. Otherwise this field is excluded from the response.
        #[serde(rename = "chosen")]
        pub chosen: Option<String>,
        /// Unit name. This field is often left blank.
        #[serde(rename = "name")]
        pub name: String,
        /// Unit rarity. This doesn't equate to the unit cost.
        #[serde(rename = "rarity")]
        pub rarity: i32,
        /// Unit tier.
        #[serde(rename = "tier")]
        pub tier: i32,
    }
    /// Companion data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Companion {
        #[serde(rename = "skin_ID")]
        pub skin_id: i32,
        #[serde(rename = "content_ID")]
        pub content_id: String,
        #[serde(rename = "species")]
        pub species: String,
    }
}

/// Data structs used by [`TftSummonerV1`](crate::endpoints::TftSummonerV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod tft_summoner_v1 {
    /// Summoner data object.
    /// # Description
    /// represents a summoner
    ///
    /// Note: This struct is automatically generated
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Summoner {
        /// Encrypted account ID. Max length 56 characters.
        #[serde(rename = "accountId")]
        pub account_id: String,
        /// ID of the summoner icon associated with the summoner.
        #[serde(rename = "profileIconId")]
        pub profile_icon_id: i32,
        /// Date summoner was last modified specified as epoch milliseconds. The following events will update this timestamp: summoner name change, summoner level change, or profile icon change.
        #[serde(rename = "revisionDate")]
        pub revision_date: i64,
        /// Summoner name.
        #[serde(rename = "name")]
        pub name: String,
        /// Encrypted summoner ID. Max length 63 characters.
        #[serde(rename = "id")]
        pub id: String,
        /// Encrypted PUUID. Exact length of 78 characters.
        #[serde(rename = "puuid")]
        pub puuid: String,
        /// Summoner level associated with the summoner.
        #[serde(rename = "summonerLevel")]
        pub summoner_level: i64,
    }
}

/// Data structs used by [`TournamentStubV4`](crate::endpoints::TournamentStubV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod tournament_stub_v4 {
    /// TournamentCodeParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentCodeParameters {
        /// Optional list of encrypted summonerIds in order to validate the players eligible to join the lobby. NOTE: We currently do not enforce participants at the team level, but rather the aggregate of teamOne and teamTwo. We may add the ability to enforce at the team level in the future.
        #[serde(rename = "allowedSummonerIds")]
        pub allowed_summoner_ids: Option<std::vec::Vec<String>>,
        /// Optional string that may contain any data in any format, if specified at all. Used to denote any custom information about the game.
        #[serde(rename = "metadata")]
        pub metadata: Option<String>,
        /// The team size of the game. Valid values are 1-5.
        #[serde(rename = "teamSize")]
        pub team_size: i32,
        /// The pick type of the game.<br>
        /// (Legal values:  BLIND_PICK,  DRAFT_MODE,  ALL_RANDOM,  TOURNAMENT_DRAFT)
        #[serde(rename = "pickType")]
        pub pick_type: String,
        /// The map type of the game.<br>
        /// (Legal values:  SUMMONERS_RIFT,  TWISTED_TREELINE,  HOWLING_ABYSS)
        #[serde(rename = "mapType")]
        pub map_type: String,
        /// The spectator type of the game.<br>
        /// (Legal values:  NONE,  LOBBYONLY,  ALL)
        #[serde(rename = "spectatorType")]
        pub spectator_type: String,
    }
    /// LobbyEventWrapper data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LobbyEventWrapper {
        #[serde(rename = "eventList")]
        pub event_list: std::vec::Vec<LobbyEvent>,
    }
    /// LobbyEvent data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LobbyEvent {
        /// The summonerId that triggered the event (Encrypted)
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
        /// The type of event that was triggered
        #[serde(rename = "eventType")]
        pub event_type: String,
        /// Timestamp from the event
        #[serde(rename = "timestamp")]
        pub timestamp: String,
    }
    /// ProviderRegistrationParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ProviderRegistrationParameters {
        /// The region in which the provider will be running tournaments.<br>
        /// (Legal values:  BR,  EUNE,  EUW,  JP,  LAN,  LAS,  NA,  OCE,  PBE,  RU,  TR)
        #[serde(rename = "region")]
        pub region: String,
        /// The provider's callback URL to which tournament game results in this region should be posted. The URL must be well-formed, use the http or https protocol, and use the default port for the protocol (http URLs must use port 80, https URLs must use port 443).
        #[serde(rename = "url")]
        pub url: String,
    }
    /// TournamentRegistrationParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentRegistrationParameters {
        /// The provider ID to specify the regional registered provider data to associate this tournament.
        #[serde(rename = "providerId")]
        pub provider_id: i32,
        /// The optional name of the tournament.
        #[serde(rename = "name")]
        pub name: Option<String>,
    }
}

/// Data structs used by [`TournamentV4`](crate::endpoints::TournamentV4).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod tournament_v4 {
    /// TournamentCodeParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentCodeParameters {
        /// Optional list of encrypted summonerIds in order to validate the players eligible to join the lobby. NOTE: We currently do not enforce participants at the team level, but rather the aggregate of teamOne and teamTwo. We may add the ability to enforce at the team level in the future.
        #[serde(rename = "allowedSummonerIds")]
        pub allowed_summoner_ids: Option<std::vec::Vec<String>>,
        /// Optional string that may contain any data in any format, if specified at all. Used to denote any custom information about the game.
        #[serde(rename = "metadata")]
        pub metadata: Option<String>,
        /// The team size of the game. Valid values are 1-5.
        #[serde(rename = "teamSize")]
        pub team_size: i32,
        /// The pick type of the game.<br>
        /// (Legal values:  BLIND_PICK,  DRAFT_MODE,  ALL_RANDOM,  TOURNAMENT_DRAFT)
        #[serde(rename = "pickType")]
        pub pick_type: String,
        /// The map type of the game.<br>
        /// (Legal values:  SUMMONERS_RIFT,  TWISTED_TREELINE,  HOWLING_ABYSS)
        #[serde(rename = "mapType")]
        pub map_type: String,
        /// The spectator type of the game.<br>
        /// (Legal values:  NONE,  LOBBYONLY,  ALL)
        #[serde(rename = "spectatorType")]
        pub spectator_type: String,
    }
    /// TournamentCode data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentCode {
        /// The tournament code.
        #[serde(rename = "code")]
        pub code: String,
        /// The spectator mode for the tournament code game.
        #[serde(rename = "spectators")]
        pub spectators: String,
        /// The lobby name for the tournament code game.
        #[serde(rename = "lobbyName")]
        pub lobby_name: String,
        /// The metadata for tournament code.
        #[serde(rename = "metaData")]
        pub meta_data: String,
        /// The password for the tournament code game.
        #[serde(rename = "password")]
        pub password: String,
        /// The team size for the tournament code game.
        #[serde(rename = "teamSize")]
        pub team_size: i32,
        /// The provider's ID.
        #[serde(rename = "providerId")]
        pub provider_id: i32,
        /// The pick mode for tournament code game.
        #[serde(rename = "pickType")]
        pub pick_type: String,
        /// The tournament's ID.
        #[serde(rename = "tournamentId")]
        pub tournament_id: i32,
        /// The tournament code's ID.
        #[serde(rename = "id")]
        pub id: i32,
        /// The tournament code's region.<br>
        /// (Legal values:  BR,  EUNE,  EUW,  JP,  LAN,  LAS,  NA,  OCE,  PBE,  RU,  TR)
        #[serde(rename = "region")]
        pub region: String,
        /// The game map for the tournament code game
        #[serde(rename = "map")]
        pub map: String,
        /// The summonerIds of the participants (Encrypted)
        #[serde(rename = "participants")]
        pub participants: std::vec::Vec<String>,
    }
    /// TournamentCodeUpdateParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentCodeUpdateParameters {
        /// Optional list of encrypted summonerIds in order to validate the players eligible to join the lobby. NOTE: We currently do not enforce participants at the team level, but rather the aggregate of teamOne and teamTwo. We may add the ability to enforce at the team level in the future.
        #[serde(rename = "allowedSummonerIds")]
        pub allowed_summoner_ids: Option<std::vec::Vec<String>>,
        /// The pick type<br>
        /// (Legal values:  BLIND_PICK,  DRAFT_MODE,  ALL_RANDOM,  TOURNAMENT_DRAFT)
        #[serde(rename = "pickType")]
        pub pick_type: String,
        /// The map type<br>
        /// (Legal values:  SUMMONERS_RIFT,  TWISTED_TREELINE,  HOWLING_ABYSS)
        #[serde(rename = "mapType")]
        pub map_type: String,
        /// The spectator type<br>
        /// (Legal values:  NONE,  LOBBYONLY,  ALL)
        #[serde(rename = "spectatorType")]
        pub spectator_type: String,
    }
    /// LobbyEventWrapper data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LobbyEventWrapper {
        #[serde(rename = "eventList")]
        pub event_list: std::vec::Vec<LobbyEvent>,
    }
    /// LobbyEvent data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LobbyEvent {
        /// Timestamp from the event
        #[serde(rename = "timestamp")]
        pub timestamp: String,
        /// The type of event that was triggered
        #[serde(rename = "eventType")]
        pub event_type: String,
        /// The summonerId that triggered the event (Encrypted)
        #[serde(rename = "summonerId")]
        pub summoner_id: String,
    }
    /// ProviderRegistrationParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ProviderRegistrationParameters {
        /// The region in which the provider will be running tournaments.<br>
        /// (Legal values:  BR,  EUNE,  EUW,  JP,  LAN,  LAS,  NA,  OCE,  PBE,  RU,  TR)
        #[serde(rename = "region")]
        pub region: String,
        /// The provider's callback URL to which tournament game results in this region should be posted. The URL must be well-formed, use the http or https protocol, and use the default port for the protocol (http URLs must use port 80, https URLs must use port 443).
        #[serde(rename = "url")]
        pub url: String,
    }
    /// TournamentRegistrationParameters data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct TournamentRegistrationParameters {
        /// The provider ID to specify the regional registered provider data to associate this tournament.
        #[serde(rename = "providerId")]
        pub provider_id: i32,
        /// The optional name of the tournament.
        #[serde(rename = "name")]
        pub name: Option<String>,
    }
}

/// Data structs used by [`ValContentV1`](crate::endpoints::ValContentV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod val_content_v1 {
    /// Content data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Content {
        #[serde(rename = "version")]
        pub version: String,
        #[serde(rename = "characters")]
        pub characters: std::vec::Vec<ContentItem>,
        #[serde(rename = "maps")]
        pub maps: std::vec::Vec<ContentItem>,
        #[serde(rename = "chromas")]
        pub chromas: std::vec::Vec<ContentItem>,
        #[serde(rename = "skins")]
        pub skins: std::vec::Vec<ContentItem>,
        #[serde(rename = "skinLevels")]
        pub skin_levels: std::vec::Vec<ContentItem>,
        #[serde(rename = "equips")]
        pub equips: std::vec::Vec<ContentItem>,
        #[serde(rename = "gameModes")]
        pub game_modes: std::vec::Vec<ContentItem>,
        #[serde(rename = "sprays")]
        pub sprays: std::vec::Vec<ContentItem>,
        #[serde(rename = "sprayLevels")]
        pub spray_levels: std::vec::Vec<ContentItem>,
        #[serde(rename = "charms")]
        pub charms: std::vec::Vec<ContentItem>,
        #[serde(rename = "charmLevels")]
        pub charm_levels: std::vec::Vec<ContentItem>,
        #[serde(rename = "playerCards")]
        pub player_cards: std::vec::Vec<ContentItem>,
        #[serde(rename = "playerTitles")]
        pub player_titles: std::vec::Vec<ContentItem>,
        #[serde(rename = "acts")]
        pub acts: std::vec::Vec<Act>,
    }
    /// ContentItem data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct ContentItem {
        #[serde(rename = "name")]
        pub name: String,
        /// This field is excluded from the response when a locale is set
        #[serde(rename = "localizedNames")]
        pub localized_names: Option<LocalizedNames>,
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "assetName")]
        pub asset_name: String,
        /// This field is only included for maps and game modes. These values are used in the match response.
        #[serde(rename = "assetPath")]
        pub asset_path: Option<String>,
    }
    /// LocalizedNames data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct LocalizedNames {
        #[serde(rename = "ar-AE")]
        pub ar_ae: String,
        #[serde(rename = "de-DE")]
        pub de_de: String,
        #[serde(rename = "en-GB")]
        pub en_gb: String,
        #[serde(rename = "en-US")]
        pub en_us: String,
        #[serde(rename = "es-ES")]
        pub es_es: String,
        #[serde(rename = "es-MX")]
        pub es_mx: String,
        #[serde(rename = "fr-FR")]
        pub fr_fr: String,
        #[serde(rename = "id-ID")]
        pub id_id: String,
        #[serde(rename = "it-IT")]
        pub it_it: String,
        #[serde(rename = "ja-JP")]
        pub ja_jp: String,
        #[serde(rename = "ko-KR")]
        pub ko_kr: String,
        #[serde(rename = "pl-PL")]
        pub pl_pl: String,
        #[serde(rename = "pt-BR")]
        pub pt_br: String,
        #[serde(rename = "ru-RU")]
        pub ru_ru: String,
        #[serde(rename = "th-TH")]
        pub th_th: String,
        #[serde(rename = "tr-TR")]
        pub tr_tr: String,
        #[serde(rename = "vi-VN")]
        pub vi_vn: String,
        #[serde(rename = "zh-CN")]
        pub zh_cn: String,
        #[serde(rename = "zh-TW")]
        pub zh_tw: String,
    }
    /// Act data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Act {
        #[serde(rename = "name")]
        pub name: String,
        /// This field is excluded from the response when a locale is set
        #[serde(rename = "localizedNames")]
        pub localized_names: Option<LocalizedNames>,
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "isActive")]
        pub is_active: bool,
    }
}

/// Data structs used by [`ValMatchV1`](crate::endpoints::ValMatchV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod val_match_v1 {
    /// Match data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Match {
        #[serde(rename = "matchInfo")]
        pub match_info: MatchInfo,
        #[serde(rename = "players")]
        pub players: std::vec::Vec<Player>,
        #[serde(rename = "coaches")]
        pub coaches: std::vec::Vec<Coach>,
        #[serde(rename = "teams")]
        pub teams: std::vec::Vec<Team>,
        #[serde(rename = "roundResults")]
        pub round_results: std::vec::Vec<RoundResult>,
    }
    /// MatchInfo data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchInfo {
        #[serde(rename = "matchId")]
        pub match_id: String,
        #[serde(rename = "mapId")]
        pub map_id: String,
        #[serde(rename = "gameLengthMillis")]
        pub game_length_millis: i32,
        #[serde(rename = "gameStartMillis")]
        pub game_start_millis: i64,
        #[serde(rename = "provisioningFlowId")]
        pub provisioning_flow_id: String,
        #[serde(rename = "isCompleted")]
        pub is_completed: bool,
        #[serde(rename = "customGameName")]
        pub custom_game_name: String,
        #[serde(rename = "queueId")]
        pub queue_id: String,
        #[serde(rename = "gameMode")]
        pub game_mode: String,
        #[serde(rename = "isRanked")]
        pub is_ranked: bool,
        #[serde(rename = "seasonId")]
        pub season_id: String,
    }
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "gameName")]
        pub game_name: String,
        #[serde(rename = "tagLine")]
        pub tag_line: String,
        #[serde(rename = "teamId")]
        pub team_id: String,
        #[serde(rename = "partyId")]
        pub party_id: String,
        #[serde(rename = "characterId")]
        pub character_id: String,
        #[serde(rename = "stats")]
        pub stats: PlayerStats,
        #[serde(rename = "competitiveTier")]
        pub competitive_tier: i32,
        #[serde(rename = "playerCard")]
        pub player_card: String,
        #[serde(rename = "playerTitle")]
        pub player_title: String,
    }
    /// PlayerStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlayerStats {
        #[serde(rename = "score")]
        pub score: i32,
        #[serde(rename = "roundsPlayed")]
        pub rounds_played: i32,
        #[serde(rename = "kills")]
        pub kills: i32,
        #[serde(rename = "deaths")]
        pub deaths: i32,
        #[serde(rename = "assists")]
        pub assists: i32,
        #[serde(rename = "playtimeMillis")]
        pub playtime_millis: i32,
        #[serde(rename = "abilityCasts")]
        pub ability_casts: AbilityCasts,
    }
    /// AbilityCasts data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct AbilityCasts {
        #[serde(rename = "grenadeCasts")]
        pub grenade_casts: i32,
        #[serde(rename = "ability1Casts")]
        pub ability1_casts: i32,
        #[serde(rename = "ability2Casts")]
        pub ability2_casts: i32,
        #[serde(rename = "ultimateCasts")]
        pub ultimate_casts: i32,
    }
    /// Coach data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Coach {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "teamId")]
        pub team_id: String,
    }
    /// Team data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Team {
        /// This is an arbitrary string. Red and Blue in bomb modes. The puuid of the player in deathmatch.
        #[serde(rename = "teamId")]
        pub team_id: String,
        #[serde(rename = "won")]
        pub won: bool,
        #[serde(rename = "roundsPlayed")]
        pub rounds_played: i32,
        #[serde(rename = "roundsWon")]
        pub rounds_won: i32,
        /// Team points scored. Number of kills in deathmatch.
        #[serde(rename = "numPoints")]
        pub num_points: i32,
    }
    /// RoundResult data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct RoundResult {
        #[serde(rename = "roundNum")]
        pub round_num: i32,
        #[serde(rename = "roundResult")]
        pub round_result: String,
        #[serde(rename = "roundCeremony")]
        pub round_ceremony: String,
        #[serde(rename = "winningTeam")]
        pub winning_team: String,
        /// PUUID of player
        #[serde(rename = "bombPlanter")]
        pub bomb_planter: String,
        /// PUUID of player
        #[serde(rename = "bombDefuser")]
        pub bomb_defuser: String,
        #[serde(rename = "plantRoundTime")]
        pub plant_round_time: i32,
        #[serde(rename = "plantPlayerLocations")]
        pub plant_player_locations: std::vec::Vec<PlayerLocations>,
        #[serde(rename = "plantLocation")]
        pub plant_location: Location,
        #[serde(rename = "plantSite")]
        pub plant_site: String,
        #[serde(rename = "defuseRoundTime")]
        pub defuse_round_time: i32,
        #[serde(rename = "defusePlayerLocations")]
        pub defuse_player_locations: std::vec::Vec<PlayerLocations>,
        #[serde(rename = "defuseLocation")]
        pub defuse_location: Location,
        #[serde(rename = "playerStats")]
        pub player_stats: std::vec::Vec<PlayerRoundStats>,
        #[serde(rename = "roundResultCode")]
        pub round_result_code: String,
    }
    /// PlayerLocations data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlayerLocations {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "viewRadians")]
        pub view_radians: f32,
        #[serde(rename = "location")]
        pub location: Location,
    }
    /// Location data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Location {
        #[serde(rename = "x")]
        pub x: i32,
        #[serde(rename = "y")]
        pub y: i32,
    }
    /// PlayerRoundStats data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlayerRoundStats {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "kills")]
        pub kills: std::vec::Vec<Kill>,
        #[serde(rename = "damage")]
        pub damage: std::vec::Vec<Damage>,
        #[serde(rename = "score")]
        pub score: i32,
        #[serde(rename = "economy")]
        pub economy: Economy,
        #[serde(rename = "ability")]
        pub ability: Ability,
    }
    /// Kill data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Kill {
        #[serde(rename = "timeSinceGameStartMillis")]
        pub time_since_game_start_millis: i32,
        #[serde(rename = "timeSinceRoundStartMillis")]
        pub time_since_round_start_millis: i32,
        /// PUUID
        #[serde(rename = "killer")]
        pub killer: String,
        /// PUUID
        #[serde(rename = "victim")]
        pub victim: String,
        #[serde(rename = "victimLocation")]
        pub victim_location: Location,
        /// List of PUUIDs
        #[serde(rename = "assistants")]
        pub assistants: std::vec::Vec<String>,
        #[serde(rename = "playerLocations")]
        pub player_locations: std::vec::Vec<PlayerLocations>,
        #[serde(rename = "finishingDamage")]
        pub finishing_damage: FinishingDamage,
    }
    /// FinishingDamage data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct FinishingDamage {
        #[serde(rename = "damageType")]
        pub damage_type: String,
        #[serde(rename = "damageItem")]
        pub damage_item: String,
        #[serde(rename = "isSecondaryFireMode")]
        pub is_secondary_fire_mode: bool,
    }
    /// Damage data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Damage {
        /// PUUID
        #[serde(rename = "receiver")]
        pub receiver: String,
        #[serde(rename = "damage")]
        pub damage: i32,
        #[serde(rename = "legshots")]
        pub legshots: i32,
        #[serde(rename = "bodyshots")]
        pub bodyshots: i32,
        #[serde(rename = "headshots")]
        pub headshots: i32,
    }
    /// Economy data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Economy {
        #[serde(rename = "loadoutValue")]
        pub loadout_value: i32,
        #[serde(rename = "weapon")]
        pub weapon: String,
        #[serde(rename = "armor")]
        pub armor: String,
        #[serde(rename = "remaining")]
        pub remaining: i32,
        #[serde(rename = "spent")]
        pub spent: i32,
    }
    /// Ability data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Ability {
        #[serde(rename = "grenadeEffects")]
        pub grenade_effects: String,
        #[serde(rename = "ability1Effects")]
        pub ability1_effects: String,
        #[serde(rename = "ability2Effects")]
        pub ability2_effects: String,
        #[serde(rename = "ultimateEffects")]
        pub ultimate_effects: String,
    }
    /// Matchlist data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Matchlist {
        #[serde(rename = "puuid")]
        pub puuid: String,
        #[serde(rename = "history")]
        pub history: std::vec::Vec<MatchlistEntry>,
    }
    /// MatchlistEntry data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct MatchlistEntry {
        #[serde(rename = "matchId")]
        pub match_id: String,
        #[serde(rename = "gameStartTimeMillis")]
        pub game_start_time_millis: i64,
        #[serde(rename = "teamId")]
        pub team_id: String,
    }
    /// RecentMatches data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct RecentMatches {
        #[serde(rename = "currentTime")]
        pub current_time: i64,
        /// A list of recent match ids.
        #[serde(rename = "matchIds")]
        pub match_ids: std::vec::Vec<String>,
    }
}

/// Data structs used by [`ValRankedV1`](crate::endpoints::ValRankedV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod val_ranked_v1 {
    /// Leaderboard data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Leaderboard {
        /// The shard for the given leaderboard.
        #[serde(rename = "shard")]
        pub shard: String,
        /// The act id for the given leaderboard. Act ids can be found using the val-content API.
        #[serde(rename = "actId")]
        pub act_id: String,
        /// The total number of players in the leaderboard.
        #[serde(rename = "totalPlayers")]
        pub total_players: i64,
        #[serde(rename = "players")]
        pub players: std::vec::Vec<Player>,
    }
    /// Player data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Player {
        /// This field may be omitted if the player has been anonymized.
        #[serde(rename = "puuid")]
        pub puuid: Option<String>,
        /// This field may be omitted if the player has been anonymized.
        #[serde(rename = "gameName")]
        pub game_name: Option<String>,
        /// This field may be omitted if the player has been anonymized.
        #[serde(rename = "tagLine")]
        pub tag_line: Option<String>,
        #[serde(rename = "leaderboardRank")]
        pub leaderboard_rank: i64,
        #[serde(rename = "rankedRating")]
        pub ranked_rating: i64,
        #[serde(rename = "numberOfWins")]
        pub number_of_wins: i64,
    }
}

/// Data structs used by [`ValStatusV1`](crate::endpoints::ValStatusV1).
/// 
/// Note: this module is automatically generated.
#[allow(dead_code)]
pub mod val_status_v1 {
    /// PlatformData data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct PlatformData {
        #[serde(rename = "id")]
        pub id: String,
        #[serde(rename = "name")]
        pub name: String,
        #[serde(rename = "locales")]
        pub locales: std::vec::Vec<String>,
        #[serde(rename = "maintenances")]
        pub maintenances: std::vec::Vec<Status>,
        #[serde(rename = "incidents")]
        pub incidents: std::vec::Vec<Status>,
    }
    /// Status data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Status {
        #[serde(rename = "id")]
        pub id: i32,
        /// (Legal values:  scheduled,  in_progress,  complete)
        #[serde(rename = "maintenance_status")]
        pub maintenance_status: String,
        /// (Legal values:  info,  warning,  critical)
        #[serde(rename = "incident_severity")]
        pub incident_severity: String,
        #[serde(rename = "titles")]
        pub titles: std::vec::Vec<Content>,
        #[serde(rename = "updates")]
        pub updates: std::vec::Vec<Update>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "archive_at")]
        pub archive_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
        /// (Legal values: windows, macos, android, ios, ps4, xbone, switch)
        #[serde(rename = "platforms")]
        pub platforms: std::vec::Vec<String>,
    }
    /// Content data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Content {
        #[serde(rename = "locale")]
        pub locale: String,
        #[serde(rename = "content")]
        pub content: String,
    }
    /// Update data object.
    #[derive(Debug)]
    #[derive(serde::Serialize, serde::Deserialize)]
    pub struct Update {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "author")]
        pub author: String,
        #[serde(rename = "publish")]
        pub publish: bool,
        /// (Legal values: riotclient, riotstatus, game)
        #[serde(rename = "publish_locations")]
        pub publish_locations: std::vec::Vec<String>,
        #[serde(rename = "translations")]
        pub translations: std::vec::Vec<Content>,
        #[serde(rename = "created_at")]
        pub created_at: String,
        #[serde(rename = "updated_at")]
        pub updated_at: String,
    }
}
